package io

import "io"

func init() {
	registerOutputHandler("null", func() OutputHandler { return &NullOutputHandler{} })
}

// Declare conformance with OutputHandler interface.
var _ OutputHandler = &NullOutputHandler{}

// NullOutputHandler is a "dummy" output handler which simply ignores the data
// given to it, without writing anything. This can be useful in situations
// where you are going to drop the output data anyway, as using the null
// handler means you won't spend any overhead on formatting output you plan to
// discard.
type NullOutputHandler struct {
}

func (n *NullOutputHandler) init() {
}

// Name implements OutputHandler.Name().
func (n *NullOutputHandler) Name() string {
	return "null"
}

// SetOption implements OutputHandler.SetOption().
func (n *NullOutputHandler) SetOption(name string, value string) error {
	return nil
}

// Format implements OutputHandler.Format()
func (n *NullOutputHandler) Format(writer io.Writer, data interface{}) error {
	return nil
}
