#!/bin/sh

# This test checks that using -O and -I on the same file performs correctly,
# that is to say that the input file is entirely read before it is re-opened
# for writing.

set -e
set -u
set -x

rm -f file.json expect.json
trap "rm -f file.json expect.json" EXIT

printf '{"foo":"bar"}' > expect.json

echo '{"foo":"bar","x":"y"}' > file.json
"$RQ" 'object.filter(input, ["foo"])' --ugly -I ./file.json -O file.json
diff expect.json file.json

echo '{"foo":"bar","x":"y"}' > file.json
"$RQ" script -I ./file.json -O file.json ./script.rq
diff expect.json file.json
