package engagementfabricapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/engagementfabric/mgmt/2018-09-01/engagementfabric"
	"github.com/Azure/go-autorest/autorest"
)

// BaseClientAPI contains the set of methods on the BaseClient type.
type BaseClientAPI interface {
	CheckNameAvailability(ctx context.Context, resourceGroupName string, parameters engagementfabric.CheckNameAvailabilityParameter) (result engagementfabric.CheckNameAvailabilityResult, err error)
}

var _ BaseClientAPI = (*engagementfabric.BaseClient)(nil)

// AccountsClientAPI contains the set of methods on the AccountsClient type.
type AccountsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, accountName string, account engagementfabric.Account) (result engagementfabric.Account, err error)
	Delete(ctx context.Context, resourceGroupName string, accountName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, accountName string) (result engagementfabric.Account, err error)
	List(ctx context.Context) (result engagementfabric.AccountList, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result engagementfabric.AccountList, err error)
	ListChannelTypes(ctx context.Context, resourceGroupName string, accountName string) (result engagementfabric.ChannelTypeDescriptionList, err error)
	ListKeys(ctx context.Context, resourceGroupName string, accountName string) (result engagementfabric.KeyDescriptionList, err error)
	RegenerateKey(ctx context.Context, resourceGroupName string, accountName string, parameter engagementfabric.RegenerateKeyParameter) (result engagementfabric.KeyDescription, err error)
	Update(ctx context.Context, resourceGroupName string, accountName string, accountPatch engagementfabric.AccountPatch) (result engagementfabric.Account, err error)
}

var _ AccountsClientAPI = (*engagementfabric.AccountsClient)(nil)

// ChannelsClientAPI contains the set of methods on the ChannelsClient type.
type ChannelsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, accountName string, channelName string, channel engagementfabric.Channel) (result engagementfabric.Channel, err error)
	Delete(ctx context.Context, resourceGroupName string, accountName string, channelName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, accountName string, channelName string) (result engagementfabric.Channel, err error)
	ListByAccount(ctx context.Context, resourceGroupName string, accountName string) (result engagementfabric.ChannelList, err error)
}

var _ ChannelsClientAPI = (*engagementfabric.ChannelsClient)(nil)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result engagementfabric.OperationList, err error)
}

var _ OperationsClientAPI = (*engagementfabric.OperationsClient)(nil)

// SKUsClientAPI contains the set of methods on the SKUsClient type.
type SKUsClientAPI interface {
	List(ctx context.Context) (result engagementfabric.SkuDescriptionList, err error)
}

var _ SKUsClientAPI = (*engagementfabric.SKUsClient)(nil)
