package aliyuncvc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMeetingInternational invokes the aliyuncvc.GetMeetingInternational API synchronously
func (client *Client) GetMeetingInternational(request *GetMeetingInternationalRequest) (response *GetMeetingInternationalResponse, err error) {
	response = CreateGetMeetingInternationalResponse()
	err = client.DoAction(request, response)
	return
}

// GetMeetingInternationalWithChan invokes the aliyuncvc.GetMeetingInternational API asynchronously
func (client *Client) GetMeetingInternationalWithChan(request *GetMeetingInternationalRequest) (<-chan *GetMeetingInternationalResponse, <-chan error) {
	responseChan := make(chan *GetMeetingInternationalResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMeetingInternational(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMeetingInternationalWithCallback invokes the aliyuncvc.GetMeetingInternational API asynchronously
func (client *Client) GetMeetingInternationalWithCallback(request *GetMeetingInternationalRequest, callback func(response *GetMeetingInternationalResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMeetingInternationalResponse
		var err error
		defer close(result)
		response, err = client.GetMeetingInternational(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMeetingInternationalRequest is the request struct for api GetMeetingInternational
type GetMeetingInternationalRequest struct {
	*requests.RpcRequest
	MeetingUUID string `position:"Body" name:"MeetingUUID"`
}

// GetMeetingInternationalResponse is the response struct for api GetMeetingInternational
type GetMeetingInternationalResponse struct {
	*responses.BaseResponse
	ErrorCode   int         `json:"ErrorCode" xml:"ErrorCode"`
	Message     string      `json:"Message" xml:"Message"`
	Success     bool        `json:"Success" xml:"Success"`
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	MeetingInfo MeetingInfo `json:"MeetingInfo" xml:"MeetingInfo"`
}

// CreateGetMeetingInternationalRequest creates a request to invoke GetMeetingInternational API
func CreateGetMeetingInternationalRequest() (request *GetMeetingInternationalRequest) {
	request = &GetMeetingInternationalRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aliyuncvc", "2019-10-30", "GetMeetingInternational", "aliyuncvc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetMeetingInternationalResponse creates a response to parse from GetMeetingInternational response
func CreateGetMeetingInternationalResponse() (response *GetMeetingInternationalResponse) {
	response = &GetMeetingInternationalResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
