package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OpenVCluster invokes the arms.OpenVCluster API synchronously
func (client *Client) OpenVCluster(request *OpenVClusterRequest) (response *OpenVClusterResponse, err error) {
	response = CreateOpenVClusterResponse()
	err = client.DoAction(request, response)
	return
}

// OpenVClusterWithChan invokes the arms.OpenVCluster API asynchronously
func (client *Client) OpenVClusterWithChan(request *OpenVClusterRequest) (<-chan *OpenVClusterResponse, <-chan error) {
	responseChan := make(chan *OpenVClusterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OpenVCluster(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OpenVClusterWithCallback invokes the arms.OpenVCluster API asynchronously
func (client *Client) OpenVClusterWithCallback(request *OpenVClusterRequest, callback func(response *OpenVClusterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OpenVClusterResponse
		var err error
		defer close(result)
		response, err = client.OpenVCluster(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OpenVClusterRequest is the request struct for api OpenVCluster
type OpenVClusterRequest struct {
	*requests.RpcRequest
	ClusterType    string           `position:"Query" name:"ClusterType"`
	Product        string           `position:"Query" name:"Product"`
	RecreateSwitch requests.Boolean `position:"Query" name:"RecreateSwitch"`
	Length         requests.Integer `position:"Query" name:"Length"`
}

// OpenVClusterResponse is the response struct for api OpenVCluster
type OpenVClusterResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateOpenVClusterRequest creates a request to invoke OpenVCluster API
func CreateOpenVClusterRequest() (request *OpenVClusterRequest) {
	request = &OpenVClusterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "OpenVCluster", "", "")
	request.Method = requests.POST
	return
}

// CreateOpenVClusterResponse creates a response to parse from OpenVCluster response
func CreateOpenVClusterResponse() (response *OpenVClusterResponse) {
	response = &OpenVClusterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
