package cas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSSLCertificateCount invokes the cas.DescribeSSLCertificateCount API synchronously
func (client *Client) DescribeSSLCertificateCount(request *DescribeSSLCertificateCountRequest) (response *DescribeSSLCertificateCountResponse, err error) {
	response = CreateDescribeSSLCertificateCountResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSSLCertificateCountWithChan invokes the cas.DescribeSSLCertificateCount API asynchronously
func (client *Client) DescribeSSLCertificateCountWithChan(request *DescribeSSLCertificateCountRequest) (<-chan *DescribeSSLCertificateCountResponse, <-chan error) {
	responseChan := make(chan *DescribeSSLCertificateCountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSSLCertificateCount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSSLCertificateCountWithCallback invokes the cas.DescribeSSLCertificateCount API asynchronously
func (client *Client) DescribeSSLCertificateCountWithCallback(request *DescribeSSLCertificateCountRequest, callback func(response *DescribeSSLCertificateCountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSSLCertificateCountResponse
		var err error
		defer close(result)
		response, err = client.DescribeSSLCertificateCount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSSLCertificateCountRequest is the request struct for api DescribeSSLCertificateCount
type DescribeSSLCertificateCountRequest struct {
	*requests.RpcRequest
	SourceIp    string `position:"Query" name:"SourceIp"`
	SearchValue string `position:"Query" name:"SearchValue"`
}

// DescribeSSLCertificateCountResponse is the response struct for api DescribeSSLCertificateCount
type DescribeSSLCertificateCountResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	TotalCount int    `json:"TotalCount" xml:"TotalCount"`
}

// CreateDescribeSSLCertificateCountRequest creates a request to invoke DescribeSSLCertificateCount API
func CreateDescribeSSLCertificateCountRequest() (request *DescribeSSLCertificateCountRequest) {
	request = &DescribeSSLCertificateCountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cas", "2020-06-19", "DescribeSSLCertificateCount", "cas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSSLCertificateCountResponse creates a response to parse from DescribeSSLCertificateCount response
func CreateDescribeSSLCertificateCountResponse() (response *DescribeSSLCertificateCountResponse) {
	response = &DescribeSSLCertificateCountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
