package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ValidateUniqueDomainName invokes the cloudcallcenter.ValidateUniqueDomainName API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/validateuniquedomainname.html
func (client *Client) ValidateUniqueDomainName(request *ValidateUniqueDomainNameRequest) (response *ValidateUniqueDomainNameResponse, err error) {
	response = CreateValidateUniqueDomainNameResponse()
	err = client.DoAction(request, response)
	return
}

// ValidateUniqueDomainNameWithChan invokes the cloudcallcenter.ValidateUniqueDomainName API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/validateuniquedomainname.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ValidateUniqueDomainNameWithChan(request *ValidateUniqueDomainNameRequest) (<-chan *ValidateUniqueDomainNameResponse, <-chan error) {
	responseChan := make(chan *ValidateUniqueDomainNameResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ValidateUniqueDomainName(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ValidateUniqueDomainNameWithCallback invokes the cloudcallcenter.ValidateUniqueDomainName API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/validateuniquedomainname.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ValidateUniqueDomainNameWithCallback(request *ValidateUniqueDomainNameRequest, callback func(response *ValidateUniqueDomainNameResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ValidateUniqueDomainNameResponse
		var err error
		defer close(result)
		response, err = client.ValidateUniqueDomainName(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ValidateUniqueDomainNameRequest is the request struct for api ValidateUniqueDomainName
type ValidateUniqueDomainNameRequest struct {
	*requests.RpcRequest
	DomainName string `position:"Query" name:"DomainName"`
}

// ValidateUniqueDomainNameResponse is the response struct for api ValidateUniqueDomainName
type ValidateUniqueDomainNameResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	IsUnique       bool   `json:"IsUnique" xml:"IsUnique"`
}

// CreateValidateUniqueDomainNameRequest creates a request to invoke ValidateUniqueDomainName API
func CreateValidateUniqueDomainNameRequest() (request *ValidateUniqueDomainNameRequest) {
	request = &ValidateUniqueDomainNameRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ValidateUniqueDomainName", "", "")
	request.Method = requests.POST
	return
}

// CreateValidateUniqueDomainNameResponse creates a response to parse from ValidateUniqueDomainName response
func CreateValidateUniqueDomainNameResponse() (response *ValidateUniqueDomainNameResponse) {
	response = &ValidateUniqueDomainNameResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
