package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDataServiceApi invokes the dataworks_public.CreateDataServiceApi API synchronously
func (client *Client) CreateDataServiceApi(request *CreateDataServiceApiRequest) (response *CreateDataServiceApiResponse, err error) {
	response = CreateCreateDataServiceApiResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDataServiceApiWithChan invokes the dataworks_public.CreateDataServiceApi API asynchronously
func (client *Client) CreateDataServiceApiWithChan(request *CreateDataServiceApiRequest) (<-chan *CreateDataServiceApiResponse, <-chan error) {
	responseChan := make(chan *CreateDataServiceApiResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDataServiceApi(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDataServiceApiWithCallback invokes the dataworks_public.CreateDataServiceApi API asynchronously
func (client *Client) CreateDataServiceApiWithCallback(request *CreateDataServiceApiRequest, callback func(response *CreateDataServiceApiResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDataServiceApiResponse
		var err error
		defer close(result)
		response, err = client.CreateDataServiceApi(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDataServiceApiRequest is the request struct for api CreateDataServiceApi
type CreateDataServiceApiRequest struct {
	*requests.RpcRequest
	ScriptDetails       string           `position:"Body" name:"ScriptDetails"`
	RequestMethod       requests.Integer `position:"Body" name:"RequestMethod"`
	GroupId             string           `position:"Body" name:"GroupId"`
	ApiPath             string           `position:"Body" name:"ApiPath"`
	WizardDetails       string           `position:"Body" name:"WizardDetails"`
	ApiMode             requests.Integer `position:"Body" name:"ApiMode"`
	VisibleRange        requests.Integer `position:"Body" name:"VisibleRange"`
	ApiDescription      string           `position:"Body" name:"ApiDescription"`
	Timeout             requests.Integer `position:"Body" name:"Timeout"`
	FolderId            requests.Integer `position:"Body" name:"FolderId"`
	RegistrationDetails string           `position:"Body" name:"RegistrationDetails"`
	ApiName             string           `position:"Body" name:"ApiName"`
	TenantId            requests.Integer `position:"Body" name:"TenantId"`
	Protocols           string           `position:"Body" name:"Protocols"`
	ProjectId           requests.Integer `position:"Body" name:"ProjectId"`
	ResponseContentType requests.Integer `position:"Body" name:"ResponseContentType"`
}

// CreateDataServiceApiResponse is the response struct for api CreateDataServiceApi
type CreateDataServiceApiResponse struct {
	*responses.BaseResponse
	Data           int64  `json:"Data" xml:"Data"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Success        bool   `json:"Success" xml:"Success"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateDataServiceApiRequest creates a request to invoke CreateDataServiceApi API
func CreateCreateDataServiceApiRequest() (request *CreateDataServiceApiRequest) {
	request = &CreateDataServiceApiRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "CreateDataServiceApi", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateDataServiceApiResponse creates a response to parse from CreateDataServiceApi response
func CreateCreateDataServiceApiResponse() (response *CreateDataServiceApiResponse) {
	response = &CreateDataServiceApiResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
