package devops_rdc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListServiceConnections invokes the devops_rdc.ListServiceConnections API synchronously
func (client *Client) ListServiceConnections(request *ListServiceConnectionsRequest) (response *ListServiceConnectionsResponse, err error) {
	response = CreateListServiceConnectionsResponse()
	err = client.DoAction(request, response)
	return
}

// ListServiceConnectionsWithChan invokes the devops_rdc.ListServiceConnections API asynchronously
func (client *Client) ListServiceConnectionsWithChan(request *ListServiceConnectionsRequest) (<-chan *ListServiceConnectionsResponse, <-chan error) {
	responseChan := make(chan *ListServiceConnectionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListServiceConnections(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListServiceConnectionsWithCallback invokes the devops_rdc.ListServiceConnections API asynchronously
func (client *Client) ListServiceConnectionsWithCallback(request *ListServiceConnectionsRequest, callback func(response *ListServiceConnectionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListServiceConnectionsResponse
		var err error
		defer close(result)
		response, err = client.ListServiceConnections(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListServiceConnectionsRequest is the request struct for api ListServiceConnections
type ListServiceConnectionsRequest struct {
	*requests.RpcRequest
	ScType string `position:"Body" name:"ScType"`
	UserPk string `position:"Body" name:"UserPk"`
	OrgId  string `position:"Body" name:"OrgId"`
}

// ListServiceConnectionsResponse is the response struct for api ListServiceConnections
type ListServiceConnectionsResponse struct {
	*responses.BaseResponse
	RequestId    string                   `json:"RequestId" xml:"RequestId"`
	ErrorCode    string                   `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string                   `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool                     `json:"Success" xml:"Success"`
	Object       []map[string]interface{} `json:"Object" xml:"Object"`
}

// CreateListServiceConnectionsRequest creates a request to invoke ListServiceConnections API
func CreateListServiceConnectionsRequest() (request *ListServiceConnectionsRequest) {
	request = &ListServiceConnectionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("devops-rdc", "2020-03-03", "ListServiceConnections", "", "")
	request.Method = requests.POST
	return
}

// CreateListServiceConnectionsResponse creates a response to parse from ListServiceConnections response
func CreateListServiceConnectionsResponse() (response *ListServiceConnectionsResponse) {
	response = &ListServiceConnectionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
