package emas_appmonitor

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryLaunchTimeTrend invokes the emas_appmonitor.QueryLaunchTimeTrend API synchronously
func (client *Client) QueryLaunchTimeTrend(request *QueryLaunchTimeTrendRequest) (response *QueryLaunchTimeTrendResponse, err error) {
	response = CreateQueryLaunchTimeTrendResponse()
	err = client.DoAction(request, response)
	return
}

// QueryLaunchTimeTrendWithChan invokes the emas_appmonitor.QueryLaunchTimeTrend API asynchronously
func (client *Client) QueryLaunchTimeTrendWithChan(request *QueryLaunchTimeTrendRequest) (<-chan *QueryLaunchTimeTrendResponse, <-chan error) {
	responseChan := make(chan *QueryLaunchTimeTrendResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryLaunchTimeTrend(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryLaunchTimeTrendWithCallback invokes the emas_appmonitor.QueryLaunchTimeTrend API asynchronously
func (client *Client) QueryLaunchTimeTrendWithCallback(request *QueryLaunchTimeTrendRequest, callback func(response *QueryLaunchTimeTrendResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryLaunchTimeTrendResponse
		var err error
		defer close(result)
		response, err = client.QueryLaunchTimeTrend(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryLaunchTimeTrendRequest is the request struct for api QueryLaunchTimeTrend
type QueryLaunchTimeTrendRequest struct {
	*requests.RpcRequest
	AppVersionStrategy string           `position:"Body" name:"AppVersionStrategy"`
	StartTime          requests.Integer `position:"Body" name:"StartTime"`
	LaunchType         string           `position:"Body" name:"LaunchType"`
	DeviceLevel        string           `position:"Body" name:"DeviceLevel"`
	Province           *[]string        `position:"Body" name:"Province"  type:"Repeated"`
	StatType           string           `position:"Body" name:"StatType"`
	IntervalMinutes    requests.Integer `position:"Body" name:"IntervalMinutes"`
	UniqueAppId        string           `position:"Body" name:"UniqueAppId"`
	EndTime            requests.Integer `position:"Body" name:"EndTime"`
	AppVersion         *[]string        `position:"Body" name:"AppVersion"  type:"Repeated"`
}

// QueryLaunchTimeTrendResponse is the response struct for api QueryLaunchTimeTrend
type QueryLaunchTimeTrendResponse struct {
	*responses.BaseResponse
	RequestId        string             `json:"RequestId" xml:"RequestId"`
	MetricResultList []MetricResultItem `json:"MetricResultList" xml:"MetricResultList"`
}

// CreateQueryLaunchTimeTrendRequest creates a request to invoke QueryLaunchTimeTrend API
func CreateQueryLaunchTimeTrendRequest() (request *QueryLaunchTimeTrendRequest) {
	request = &QueryLaunchTimeTrendRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("emas-appmonitor", "2019-06-11", "QueryLaunchTimeTrend", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryLaunchTimeTrendResponse creates a response to parse from QueryLaunchTimeTrend response
func CreateQueryLaunchTimeTrendResponse() (response *QueryLaunchTimeTrendResponse) {
	response = &QueryLaunchTimeTrendResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
