package oam

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateTagById invokes the oam.UpdateTagById API synchronously
// api document: https://help.aliyun.com/api/oam/updatetagbyid.html
func (client *Client) UpdateTagById(request *UpdateTagByIdRequest) (response *UpdateTagByIdResponse, err error) {
	response = CreateUpdateTagByIdResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateTagByIdWithChan invokes the oam.UpdateTagById API asynchronously
// api document: https://help.aliyun.com/api/oam/updatetagbyid.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateTagByIdWithChan(request *UpdateTagByIdRequest) (<-chan *UpdateTagByIdResponse, <-chan error) {
	responseChan := make(chan *UpdateTagByIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateTagById(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateTagByIdWithCallback invokes the oam.UpdateTagById API asynchronously
// api document: https://help.aliyun.com/api/oam/updatetagbyid.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateTagByIdWithCallback(request *UpdateTagByIdRequest, callback func(response *UpdateTagByIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateTagByIdResponse
		var err error
		defer close(result)
		response, err = client.UpdateTagById(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateTagByIdRequest is the request struct for api UpdateTagById
type UpdateTagByIdRequest struct {
	*requests.RpcRequest
	TagId       string                     `position:"Query" name:"TagId"`
	RoleCellId  *[]UpdateTagByIdRoleCellId `position:"Query" name:"RoleCellId"  type:"Repeated"`
	Name        string                     `position:"Query" name:"Name"`
	Description string                     `position:"Query" name:"Description"`
	UserId      string                     `position:"Query" name:"UserId"`
}

// UpdateTagByIdRoleCellId is a repeated param struct in UpdateTagByIdRequest
type UpdateTagByIdRoleCellId struct {
	NewId string `name:"NewId"`
	OldId string `name:"OldId"`
}

// UpdateTagByIdResponse is the response struct for api UpdateTagById
type UpdateTagByIdResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateTagByIdRequest creates a request to invoke UpdateTagById API
func CreateUpdateTagByIdRequest() (request *UpdateTagByIdRequest) {
	request = &UpdateTagByIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Oam", "2017-01-01", "UpdateTagById", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateTagByIdResponse creates a response to parse from UpdateTagById response
func CreateUpdateTagByIdResponse() (response *UpdateTagByIdResponse) {
	response = &UpdateTagByIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
