package outboundbot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteScriptWaveform invokes the outboundbot.DeleteScriptWaveform API synchronously
func (client *Client) DeleteScriptWaveform(request *DeleteScriptWaveformRequest) (response *DeleteScriptWaveformResponse, err error) {
	response = CreateDeleteScriptWaveformResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteScriptWaveformWithChan invokes the outboundbot.DeleteScriptWaveform API asynchronously
func (client *Client) DeleteScriptWaveformWithChan(request *DeleteScriptWaveformRequest) (<-chan *DeleteScriptWaveformResponse, <-chan error) {
	responseChan := make(chan *DeleteScriptWaveformResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteScriptWaveform(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteScriptWaveformWithCallback invokes the outboundbot.DeleteScriptWaveform API asynchronously
func (client *Client) DeleteScriptWaveformWithCallback(request *DeleteScriptWaveformRequest, callback func(response *DeleteScriptWaveformResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteScriptWaveformResponse
		var err error
		defer close(result)
		response, err = client.DeleteScriptWaveform(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteScriptWaveformRequest is the request struct for api DeleteScriptWaveform
type DeleteScriptWaveformRequest struct {
	*requests.RpcRequest
	ScriptWaveformId string `position:"Query" name:"ScriptWaveformId"`
	ScriptId         string `position:"Query" name:"ScriptId"`
	InstanceId       string `position:"Query" name:"InstanceId"`
}

// DeleteScriptWaveformResponse is the response struct for api DeleteScriptWaveform
type DeleteScriptWaveformResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateDeleteScriptWaveformRequest creates a request to invoke DeleteScriptWaveform API
func CreateDeleteScriptWaveformRequest() (request *DeleteScriptWaveformRequest) {
	request = &DeleteScriptWaveformRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OutboundBot", "2019-12-26", "DeleteScriptWaveform", "outboundbot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteScriptWaveformResponse creates a response to parse from DeleteScriptWaveform response
func CreateDeleteScriptWaveformResponse() (response *DeleteScriptWaveformResponse) {
	response = &DeleteScriptWaveformResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
