package outboundbot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// Dialogue invokes the outboundbot.Dialogue API synchronously
func (client *Client) Dialogue(request *DialogueRequest) (response *DialogueResponse, err error) {
	response = CreateDialogueResponse()
	err = client.DoAction(request, response)
	return
}

// DialogueWithChan invokes the outboundbot.Dialogue API asynchronously
func (client *Client) DialogueWithChan(request *DialogueRequest) (<-chan *DialogueResponse, <-chan error) {
	responseChan := make(chan *DialogueResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.Dialogue(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DialogueWithCallback invokes the outboundbot.Dialogue API asynchronously
func (client *Client) DialogueWithCallback(request *DialogueRequest, callback func(response *DialogueResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DialogueResponse
		var err error
		defer close(result)
		response, err = client.Dialogue(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DialogueRequest is the request struct for api Dialogue
type DialogueRequest struct {
	*requests.RpcRequest
	CallId          string           `position:"Query" name:"CallId"`
	InstanceOwnerId requests.Integer `position:"Query" name:"InstanceOwnerId"`
	CalledNumber    string           `position:"Query" name:"CalledNumber"`
	CallType        string           `position:"Query" name:"CallType"`
	ScenarioId      string           `position:"Query" name:"ScenarioId"`
	TaskId          string           `position:"Query" name:"TaskId"`
	Utterance       string           `position:"Query" name:"Utterance"`
	ActionParams    string           `position:"Query" name:"ActionParams"`
	CallingNumber   string           `position:"Query" name:"CallingNumber"`
	InstanceId      string           `position:"Query" name:"InstanceId"`
	ActionKey       string           `position:"Query" name:"ActionKey"`
}

// DialogueResponse is the response struct for api Dialogue
type DialogueResponse struct {
	*responses.BaseResponse
	Code           string   `json:"Code" xml:"Code"`
	HttpStatusCode int      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string   `json:"Message" xml:"Message"`
	RequestId      string   `json:"RequestId" xml:"RequestId"`
	Success        bool     `json:"Success" xml:"Success"`
	Feedback       Feedback `json:"Feedback" xml:"Feedback"`
}

// CreateDialogueRequest creates a request to invoke Dialogue API
func CreateDialogueRequest() (request *DialogueRequest) {
	request = &DialogueRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OutboundBot", "2019-12-26", "Dialogue", "outboundbot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDialogueResponse creates a response to parse from Dialogue response
func CreateDialogueResponse() (response *DialogueResponse) {
	response = &DialogueResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
