package r_kvstore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RenewAdditionalBandwidth invokes the r_kvstore.RenewAdditionalBandwidth API synchronously
func (client *Client) RenewAdditionalBandwidth(request *RenewAdditionalBandwidthRequest) (response *RenewAdditionalBandwidthResponse, err error) {
	response = CreateRenewAdditionalBandwidthResponse()
	err = client.DoAction(request, response)
	return
}

// RenewAdditionalBandwidthWithChan invokes the r_kvstore.RenewAdditionalBandwidth API asynchronously
func (client *Client) RenewAdditionalBandwidthWithChan(request *RenewAdditionalBandwidthRequest) (<-chan *RenewAdditionalBandwidthResponse, <-chan error) {
	responseChan := make(chan *RenewAdditionalBandwidthResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RenewAdditionalBandwidth(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RenewAdditionalBandwidthWithCallback invokes the r_kvstore.RenewAdditionalBandwidth API asynchronously
func (client *Client) RenewAdditionalBandwidthWithCallback(request *RenewAdditionalBandwidthRequest, callback func(response *RenewAdditionalBandwidthResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RenewAdditionalBandwidthResponse
		var err error
		defer close(result)
		response, err = client.RenewAdditionalBandwidth(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RenewAdditionalBandwidthRequest is the request struct for api RenewAdditionalBandwidth
type RenewAdditionalBandwidthRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	CouponNo             string           `position:"Query" name:"CouponNo"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	SourceBiz            string           `position:"Query" name:"SourceBiz"`
	OrderTimeLength      string           `position:"Query" name:"OrderTimeLength"`
	Product              string           `position:"Query" name:"Product"`
	AutoPay              requests.Boolean `position:"Query" name:"AutoPay"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
	Category             string           `position:"Query" name:"Category"`
}

// RenewAdditionalBandwidthResponse is the response struct for api RenewAdditionalBandwidth
type RenewAdditionalBandwidthResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	OrderId   string `json:"OrderId" xml:"OrderId"`
}

// CreateRenewAdditionalBandwidthRequest creates a request to invoke RenewAdditionalBandwidth API
func CreateRenewAdditionalBandwidthRequest() (request *RenewAdditionalBandwidthRequest) {
	request = &RenewAdditionalBandwidthRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("R-kvstore", "2015-01-01", "RenewAdditionalBandwidth", "redisa", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRenewAdditionalBandwidthResponse creates a response to parse from RenewAdditionalBandwidth response
func CreateRenewAdditionalBandwidthResponse() (response *RenewAdditionalBandwidthResponse) {
	response = &RenewAdditionalBandwidthResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
