package rtc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateRecordTask invokes the rtc.UpdateRecordTask API synchronously
func (client *Client) UpdateRecordTask(request *UpdateRecordTaskRequest) (response *UpdateRecordTaskResponse, err error) {
	response = CreateUpdateRecordTaskResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateRecordTaskWithChan invokes the rtc.UpdateRecordTask API asynchronously
func (client *Client) UpdateRecordTaskWithChan(request *UpdateRecordTaskRequest) (<-chan *UpdateRecordTaskResponse, <-chan error) {
	responseChan := make(chan *UpdateRecordTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateRecordTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateRecordTaskWithCallback invokes the rtc.UpdateRecordTask API asynchronously
func (client *Client) UpdateRecordTaskWithCallback(request *UpdateRecordTaskRequest, callback func(response *UpdateRecordTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateRecordTaskResponse
		var err error
		defer close(result)
		response, err = client.UpdateRecordTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateRecordTaskRequest is the request struct for api UpdateRecordTask
type UpdateRecordTaskRequest struct {
	*requests.RpcRequest
	UserPanes                 *[]UpdateRecordTaskUserPanes `position:"Query" name:"UserPanes"  type:"Repeated"`
	SubSpecCameraUsers        *[]string                    `position:"Query" name:"SubSpecCameraUsers"  type:"Repeated"`
	LayoutIds                 *[]string                    `position:"Query" name:"LayoutIds"  type:"Repeated"`
	TaskId                    string                       `position:"Query" name:"TaskId"`
	ShowLog                   string                       `position:"Query" name:"ShowLog"`
	UnsubSpecCameraUsers      *[]string                    `position:"Query" name:"UnsubSpecCameraUsers"  type:"Repeated"`
	UnsubSpecAudioUsers       *[]string                    `position:"Query" name:"UnsubSpecAudioUsers"  type:"Repeated"`
	UnsubSpecShareScreenUsers *[]string                    `position:"Query" name:"UnsubSpecShareScreenUsers"  type:"Repeated"`
	OwnerId                   requests.Integer             `position:"Query" name:"OwnerId"`
	TemplateId                string                       `position:"Query" name:"TemplateId"`
	SubSpecAudioUsers         *[]string                    `position:"Query" name:"SubSpecAudioUsers"  type:"Repeated"`
	SubSpecShareScreenUsers   *[]string                    `position:"Query" name:"SubSpecShareScreenUsers"  type:"Repeated"`
	SubSpecUsers              *[]string                    `position:"Query" name:"SubSpecUsers"  type:"Repeated"`
	AppId                     string                       `position:"Query" name:"AppId"`
	ChannelId                 string                       `position:"Query" name:"ChannelId"`
}

// UpdateRecordTaskUserPanes is a repeated param struct in UpdateRecordTaskRequest
type UpdateRecordTaskUserPanes struct {
	Images     *[]UpdateRecordTaskUserPanesImages `name:"Images" type:"Repeated"`
	UserId     string                             `name:"UserId"`
	Texts      *[]UpdateRecordTaskUserPanesTexts  `name:"Texts" type:"Repeated"`
	SourceType string                             `name:"SourceType"`
	PaneId     string                             `name:"PaneId"`
}

// UpdateRecordTaskUserPanesImages is a repeated param struct in UpdateRecordTaskRequest
type UpdateRecordTaskUserPanesImages struct {
	Width   string `name:"Width"`
	Height  string `name:"Height"`
	Y       string `name:"Y"`
	Url     string `name:"Url"`
	Display string `name:"Display"`
	ZOrder  string `name:"ZOrder"`
	X       string `name:"X"`
}

// UpdateRecordTaskUserPanesTexts is a repeated param struct in UpdateRecordTaskRequest
type UpdateRecordTaskUserPanesTexts struct {
	FontType  string `name:"FontType"`
	FontColor string `name:"FontColor"`
	Y         string `name:"Y"`
	Text      string `name:"Text"`
	ZOrder    string `name:"ZOrder"`
	X         string `name:"X"`
	FontSize  string `name:"FontSize"`
}

// UpdateRecordTaskResponse is the response struct for api UpdateRecordTask
type UpdateRecordTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateRecordTaskRequest creates a request to invoke UpdateRecordTask API
func CreateUpdateRecordTaskRequest() (request *UpdateRecordTaskRequest) {
	request = &UpdateRecordTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("rtc", "2018-01-11", "UpdateRecordTask", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateRecordTaskResponse creates a response to parse from UpdateRecordTask response
func CreateUpdateRecordTaskResponse() (response *UpdateRecordTaskResponse) {
	response = &UpdateRecordTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
