package trademark

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// InsertMaterial invokes the trademark.InsertMaterial API synchronously
// api document: https://help.aliyun.com/api/trademark/insertmaterial.html
func (client *Client) InsertMaterial(request *InsertMaterialRequest) (response *InsertMaterialResponse, err error) {
	response = CreateInsertMaterialResponse()
	err = client.DoAction(request, response)
	return
}

// InsertMaterialWithChan invokes the trademark.InsertMaterial API asynchronously
// api document: https://help.aliyun.com/api/trademark/insertmaterial.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) InsertMaterialWithChan(request *InsertMaterialRequest) (<-chan *InsertMaterialResponse, <-chan error) {
	responseChan := make(chan *InsertMaterialResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.InsertMaterial(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// InsertMaterialWithCallback invokes the trademark.InsertMaterial API asynchronously
// api document: https://help.aliyun.com/api/trademark/insertmaterial.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) InsertMaterialWithCallback(request *InsertMaterialRequest, callback func(response *InsertMaterialResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *InsertMaterialResponse
		var err error
		defer close(result)
		response, err = client.InsertMaterial(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// InsertMaterialRequest is the request struct for api InsertMaterial
type InsertMaterialRequest struct {
	*requests.RpcRequest
	ContactEmail          string           `position:"Query" name:"ContactEmail"`
	ContactAddress        string           `position:"Query" name:"ContactAddress"`
	EAddress              string           `position:"Query" name:"EAddress"`
	Country               string           `position:"Query" name:"Country"`
	LegalNoticeOssKey     string           `position:"Query" name:"LegalNoticeOssKey"`
	Address               string           `position:"Query" name:"Address"`
	Town                  string           `position:"Query" name:"Town"`
	ContactNumber         string           `position:"Query" name:"ContactNumber"`
	City                  string           `position:"Query" name:"City"`
	IdCardOssKey          string           `position:"Query" name:"IdCardOssKey"`
	Type                  requests.Integer `position:"Query" name:"Type"`
	ContactName           string           `position:"Query" name:"ContactName"`
	PassportOssKey        string           `position:"Query" name:"PassportOssKey"`
	ContactZipcode        string           `position:"Query" name:"ContactZipcode"`
	EName                 string           `position:"Query" name:"EName"`
	Province              string           `position:"Query" name:"Province"`
	BusinessLicenceOssKey string           `position:"Query" name:"BusinessLicenceOssKey"`
	Name                  string           `position:"Query" name:"Name"`
	CardNumber            string           `position:"Query" name:"CardNumber"`
	Region                requests.Integer `position:"Query" name:"Region"`
	LoaOssKey             string           `position:"Query" name:"LoaOssKey"`
}

// InsertMaterialResponse is the response struct for api InsertMaterial
type InsertMaterialResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateInsertMaterialRequest creates a request to invoke InsertMaterial API
func CreateInsertMaterialRequest() (request *InsertMaterialRequest) {
	request = &InsertMaterialRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Trademark", "2018-07-24", "InsertMaterial", "trademark", "openAPI")
	return
}

// CreateInsertMaterialResponse creates a response to parse from InsertMaterial response
func CreateInsertMaterialResponse() (response *InsertMaterialResponse) {
	response = &InsertMaterialResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
