package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchUnbindTemplate invokes the vs.BatchUnbindTemplate API synchronously
func (client *Client) BatchUnbindTemplate(request *BatchUnbindTemplateRequest) (response *BatchUnbindTemplateResponse, err error) {
	response = CreateBatchUnbindTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// BatchUnbindTemplateWithChan invokes the vs.BatchUnbindTemplate API asynchronously
func (client *Client) BatchUnbindTemplateWithChan(request *BatchUnbindTemplateRequest) (<-chan *BatchUnbindTemplateResponse, <-chan error) {
	responseChan := make(chan *BatchUnbindTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchUnbindTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchUnbindTemplateWithCallback invokes the vs.BatchUnbindTemplate API asynchronously
func (client *Client) BatchUnbindTemplateWithCallback(request *BatchUnbindTemplateRequest, callback func(response *BatchUnbindTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchUnbindTemplateResponse
		var err error
		defer close(result)
		response, err = client.BatchUnbindTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchUnbindTemplateRequest is the request struct for api BatchUnbindTemplate
type BatchUnbindTemplateRequest struct {
	*requests.RpcRequest
	TemplateType string           `position:"Query" name:"TemplateType"`
	InstanceType string           `position:"Query" name:"InstanceType"`
	ShowLog      string           `position:"Query" name:"ShowLog"`
	OwnerId      requests.Integer `position:"Query" name:"OwnerId"`
	TemplateId   string           `position:"Query" name:"TemplateId"`
	InstanceId   string           `position:"Query" name:"InstanceId"`
}

// BatchUnbindTemplateResponse is the response struct for api BatchUnbindTemplate
type BatchUnbindTemplateResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	Bindings  []Binding `json:"Bindings" xml:"Bindings"`
}

// CreateBatchUnbindTemplateRequest creates a request to invoke BatchUnbindTemplate API
func CreateBatchUnbindTemplateRequest() (request *BatchUnbindTemplateRequest) {
	request = &BatchUnbindTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "BatchUnbindTemplate", "", "")
	request.Method = requests.POST
	return
}

// CreateBatchUnbindTemplateResponse creates a response to parse from BatchUnbindTemplate response
func CreateBatchUnbindTemplateResponse() (response *BatchUnbindTemplateResponse) {
	response = &BatchUnbindTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
