package webplus

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateAppEnv invokes the webplus.CreateAppEnv API synchronously
// api document: https://help.aliyun.com/api/webplus/createappenv.html
func (client *Client) CreateAppEnv(request *CreateAppEnvRequest) (response *CreateAppEnvResponse, err error) {
	response = CreateCreateAppEnvResponse()
	err = client.DoAction(request, response)
	return
}

// CreateAppEnvWithChan invokes the webplus.CreateAppEnv API asynchronously
// api document: https://help.aliyun.com/api/webplus/createappenv.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateAppEnvWithChan(request *CreateAppEnvRequest) (<-chan *CreateAppEnvResponse, <-chan error) {
	responseChan := make(chan *CreateAppEnvResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateAppEnv(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateAppEnvWithCallback invokes the webplus.CreateAppEnv API asynchronously
// api document: https://help.aliyun.com/api/webplus/createappenv.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateAppEnvWithCallback(request *CreateAppEnvRequest, callback func(response *CreateAppEnvResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateAppEnvResponse
		var err error
		defer close(result)
		response, err = client.CreateAppEnv(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateAppEnvRequest is the request struct for api CreateAppEnv
type CreateAppEnvRequest struct {
	*requests.RoaRequest
	OptionSettings  string           `position:"Body" name:"OptionSettings"`
	DryRun          requests.Boolean `position:"Body" name:"DryRun"`
	EnvName         string           `position:"Body" name:"EnvName"`
	ExtraProperties string           `position:"Body" name:"ExtraProperties"`
	StackId         string           `position:"Body" name:"StackId"`
	AppId           string           `position:"Body" name:"AppId"`
	ProfileName     string           `position:"Body" name:"ProfileName"`
	EnvDescription  string           `position:"Body" name:"EnvDescription"`
	PkgVersionId    string           `position:"Body" name:"PkgVersionId"`
	SourceEnvId     string           `position:"Body" name:"SourceEnvId"`
	TemplateId      string           `position:"Body" name:"TemplateId"`
}

// CreateAppEnvResponse is the response struct for api CreateAppEnv
type CreateAppEnvResponse struct {
	*responses.BaseResponse
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	Code            string          `json:"Code" xml:"Code"`
	Message         string          `json:"Message" xml:"Message"`
	EnvChangeDetail EnvChangeDetail `json:"EnvChangeDetail" xml:"EnvChangeDetail"`
}

// CreateCreateAppEnvRequest creates a request to invoke CreateAppEnv API
func CreateCreateAppEnvRequest() (request *CreateAppEnvRequest) {
	request = &CreateAppEnvRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("WebPlus", "2019-03-20", "CreateAppEnv", "/pop/v1/wam/appEnv", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateAppEnvResponse creates a response to parse from CreateAppEnv response
func CreateCreateAppEnvResponse() (response *CreateAppEnvResponse) {
	response = &CreateAppEnvResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
