// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotwireless

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAssociateAwsAccountWithPartnerAccount = "AssociateAwsAccountWithPartnerAccount"

// AssociateAwsAccountWithPartnerAccountRequest generates a "aws/request.Request" representing the
// client's request for the AssociateAwsAccountWithPartnerAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateAwsAccountWithPartnerAccount for more information on using the AssociateAwsAccountWithPartnerAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateAwsAccountWithPartnerAccountRequest method.
//    req, resp := client.AssociateAwsAccountWithPartnerAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateAwsAccountWithPartnerAccount
func (c *IoTWireless) AssociateAwsAccountWithPartnerAccountRequest(input *AssociateAwsAccountWithPartnerAccountInput) (req *request.Request, output *AssociateAwsAccountWithPartnerAccountOutput) {
	op := &request.Operation{
		Name:       opAssociateAwsAccountWithPartnerAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/partner-accounts",
	}

	if input == nil {
		input = &AssociateAwsAccountWithPartnerAccountInput{}
	}

	output = &AssociateAwsAccountWithPartnerAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateAwsAccountWithPartnerAccount API operation for AWS IoT Wireless.
//
// Associates a partner account with your AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation AssociateAwsAccountWithPartnerAccount for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * ResourceNotFoundException
//   Resource does not exist.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
//   * ConflictException
//   Adding, updating, or deleting the resource can cause an inconsistent state.
//
//   * AccessDeniedException
//   User does not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateAwsAccountWithPartnerAccount
func (c *IoTWireless) AssociateAwsAccountWithPartnerAccount(input *AssociateAwsAccountWithPartnerAccountInput) (*AssociateAwsAccountWithPartnerAccountOutput, error) {
	req, out := c.AssociateAwsAccountWithPartnerAccountRequest(input)
	return out, req.Send()
}

// AssociateAwsAccountWithPartnerAccountWithContext is the same as AssociateAwsAccountWithPartnerAccount with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateAwsAccountWithPartnerAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) AssociateAwsAccountWithPartnerAccountWithContext(ctx aws.Context, input *AssociateAwsAccountWithPartnerAccountInput, opts ...request.Option) (*AssociateAwsAccountWithPartnerAccountOutput, error) {
	req, out := c.AssociateAwsAccountWithPartnerAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateWirelessDeviceWithThing = "AssociateWirelessDeviceWithThing"

// AssociateWirelessDeviceWithThingRequest generates a "aws/request.Request" representing the
// client's request for the AssociateWirelessDeviceWithThing operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateWirelessDeviceWithThing for more information on using the AssociateWirelessDeviceWithThing
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateWirelessDeviceWithThingRequest method.
//    req, resp := client.AssociateWirelessDeviceWithThingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessDeviceWithThing
func (c *IoTWireless) AssociateWirelessDeviceWithThingRequest(input *AssociateWirelessDeviceWithThingInput) (req *request.Request, output *AssociateWirelessDeviceWithThingOutput) {
	op := &request.Operation{
		Name:       opAssociateWirelessDeviceWithThing,
		HTTPMethod: "PUT",
		HTTPPath:   "/wireless-devices/{Id}/thing",
	}

	if input == nil {
		input = &AssociateWirelessDeviceWithThingInput{}
	}

	output = &AssociateWirelessDeviceWithThingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateWirelessDeviceWithThing API operation for AWS IoT Wireless.
//
// Associates a wireless device with a thing.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation AssociateWirelessDeviceWithThing for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * AccessDeniedException
//   User does not have permission to perform this action.
//
//   * ResourceNotFoundException
//   Resource does not exist.
//
//   * ConflictException
//   Adding, updating, or deleting the resource can cause an inconsistent state.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessDeviceWithThing
func (c *IoTWireless) AssociateWirelessDeviceWithThing(input *AssociateWirelessDeviceWithThingInput) (*AssociateWirelessDeviceWithThingOutput, error) {
	req, out := c.AssociateWirelessDeviceWithThingRequest(input)
	return out, req.Send()
}

// AssociateWirelessDeviceWithThingWithContext is the same as AssociateWirelessDeviceWithThing with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateWirelessDeviceWithThing for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) AssociateWirelessDeviceWithThingWithContext(ctx aws.Context, input *AssociateWirelessDeviceWithThingInput, opts ...request.Option) (*AssociateWirelessDeviceWithThingOutput, error) {
	req, out := c.AssociateWirelessDeviceWithThingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateWirelessGatewayWithCertificate = "AssociateWirelessGatewayWithCertificate"

// AssociateWirelessGatewayWithCertificateRequest generates a "aws/request.Request" representing the
// client's request for the AssociateWirelessGatewayWithCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateWirelessGatewayWithCertificate for more information on using the AssociateWirelessGatewayWithCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateWirelessGatewayWithCertificateRequest method.
//    req, resp := client.AssociateWirelessGatewayWithCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessGatewayWithCertificate
func (c *IoTWireless) AssociateWirelessGatewayWithCertificateRequest(input *AssociateWirelessGatewayWithCertificateInput) (req *request.Request, output *AssociateWirelessGatewayWithCertificateOutput) {
	op := &request.Operation{
		Name:       opAssociateWirelessGatewayWithCertificate,
		HTTPMethod: "PUT",
		HTTPPath:   "/wireless-gateways/{Id}/certificate",
	}

	if input == nil {
		input = &AssociateWirelessGatewayWithCertificateInput{}
	}

	output = &AssociateWirelessGatewayWithCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateWirelessGatewayWithCertificate API operation for AWS IoT Wireless.
//
// Associates a wireless gateway with a certificate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation AssociateWirelessGatewayWithCertificate for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * AccessDeniedException
//   User does not have permission to perform this action.
//
//   * ResourceNotFoundException
//   Resource does not exist.
//
//   * ConflictException
//   Adding, updating, or deleting the resource can cause an inconsistent state.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessGatewayWithCertificate
func (c *IoTWireless) AssociateWirelessGatewayWithCertificate(input *AssociateWirelessGatewayWithCertificateInput) (*AssociateWirelessGatewayWithCertificateOutput, error) {
	req, out := c.AssociateWirelessGatewayWithCertificateRequest(input)
	return out, req.Send()
}

// AssociateWirelessGatewayWithCertificateWithContext is the same as AssociateWirelessGatewayWithCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateWirelessGatewayWithCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) AssociateWirelessGatewayWithCertificateWithContext(ctx aws.Context, input *AssociateWirelessGatewayWithCertificateInput, opts ...request.Option) (*AssociateWirelessGatewayWithCertificateOutput, error) {
	req, out := c.AssociateWirelessGatewayWithCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateWirelessGatewayWithThing = "AssociateWirelessGatewayWithThing"

// AssociateWirelessGatewayWithThingRequest generates a "aws/request.Request" representing the
// client's request for the AssociateWirelessGatewayWithThing operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateWirelessGatewayWithThing for more information on using the AssociateWirelessGatewayWithThing
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateWirelessGatewayWithThingRequest method.
//    req, resp := client.AssociateWirelessGatewayWithThingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessGatewayWithThing
func (c *IoTWireless) AssociateWirelessGatewayWithThingRequest(input *AssociateWirelessGatewayWithThingInput) (req *request.Request, output *AssociateWirelessGatewayWithThingOutput) {
	op := &request.Operation{
		Name:       opAssociateWirelessGatewayWithThing,
		HTTPMethod: "PUT",
		HTTPPath:   "/wireless-gateways/{Id}/thing",
	}

	if input == nil {
		input = &AssociateWirelessGatewayWithThingInput{}
	}

	output = &AssociateWirelessGatewayWithThingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateWirelessGatewayWithThing API operation for AWS IoT Wireless.
//
// Associates a wireless gateway with a thing.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation AssociateWirelessGatewayWithThing for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * ResourceNotFoundException
//   Resource does not exist.
//
//   * AccessDeniedException
//   User does not have permission to perform this action.
//
//   * ConflictException
//   Adding, updating, or deleting the resource can cause an inconsistent state.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessGatewayWithThing
func (c *IoTWireless) AssociateWirelessGatewayWithThing(input *AssociateWirelessGatewayWithThingInput) (*AssociateWirelessGatewayWithThingOutput, error) {
	req, out := c.AssociateWirelessGatewayWithThingRequest(input)
	return out, req.Send()
}

// AssociateWirelessGatewayWithThingWithContext is the same as AssociateWirelessGatewayWithThing with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateWirelessGatewayWithThing for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) AssociateWirelessGatewayWithThingWithContext(ctx aws.Context, input *AssociateWirelessGatewayWithThingInput, opts ...request.Option) (*AssociateWirelessGatewayWithThingOutput, error) {
	req, out := c.AssociateWirelessGatewayWithThingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDestination = "CreateDestination"

// CreateDestinationRequest generates a "aws/request.Request" representing the
// client's request for the CreateDestination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDestination for more information on using the CreateDestination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDestinationRequest method.
//    req, resp := client.CreateDestinationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateDestination
func (c *IoTWireless) CreateDestinationRequest(input *CreateDestinationInput) (req *request.Request, output *CreateDestinationOutput) {
	op := &request.Operation{
		Name:       opCreateDestination,
		HTTPMethod: "POST",
		HTTPPath:   "/destinations",
	}

	if input == nil {
		input = &CreateDestinationInput{}
	}

	output = &CreateDestinationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDestination API operation for AWS IoT Wireless.
//
// Creates a new destination that maps a device message to an AWS IoT rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation CreateDestination for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * ResourceNotFoundException
//   Resource does not exist.
//
//   * AccessDeniedException
//   User does not have permission to perform this action.
//
//   * ConflictException
//   Adding, updating, or deleting the resource can cause an inconsistent state.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateDestination
func (c *IoTWireless) CreateDestination(input *CreateDestinationInput) (*CreateDestinationOutput, error) {
	req, out := c.CreateDestinationRequest(input)
	return out, req.Send()
}

// CreateDestinationWithContext is the same as CreateDestination with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) CreateDestinationWithContext(ctx aws.Context, input *CreateDestinationInput, opts ...request.Option) (*CreateDestinationOutput, error) {
	req, out := c.CreateDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDeviceProfile = "CreateDeviceProfile"

// CreateDeviceProfileRequest generates a "aws/request.Request" representing the
// client's request for the CreateDeviceProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDeviceProfile for more information on using the CreateDeviceProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDeviceProfileRequest method.
//    req, resp := client.CreateDeviceProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateDeviceProfile
func (c *IoTWireless) CreateDeviceProfileRequest(input *CreateDeviceProfileInput) (req *request.Request, output *CreateDeviceProfileOutput) {
	op := &request.Operation{
		Name:       opCreateDeviceProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/device-profiles",
	}

	if input == nil {
		input = &CreateDeviceProfileInput{}
	}

	output = &CreateDeviceProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDeviceProfile API operation for AWS IoT Wireless.
//
// Creates a new device profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation CreateDeviceProfile for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * AccessDeniedException
//   User does not have permission to perform this action.
//
//   * ConflictException
//   Adding, updating, or deleting the resource can cause an inconsistent state.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateDeviceProfile
func (c *IoTWireless) CreateDeviceProfile(input *CreateDeviceProfileInput) (*CreateDeviceProfileOutput, error) {
	req, out := c.CreateDeviceProfileRequest(input)
	return out, req.Send()
}

// CreateDeviceProfileWithContext is the same as CreateDeviceProfile with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDeviceProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) CreateDeviceProfileWithContext(ctx aws.Context, input *CreateDeviceProfileInput, opts ...request.Option) (*CreateDeviceProfileOutput, error) {
	req, out := c.CreateDeviceProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateServiceProfile = "CreateServiceProfile"

// CreateServiceProfileRequest generates a "aws/request.Request" representing the
// client's request for the CreateServiceProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateServiceProfile for more information on using the CreateServiceProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateServiceProfileRequest method.
//    req, resp := client.CreateServiceProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateServiceProfile
func (c *IoTWireless) CreateServiceProfileRequest(input *CreateServiceProfileInput) (req *request.Request, output *CreateServiceProfileOutput) {
	op := &request.Operation{
		Name:       opCreateServiceProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/service-profiles",
	}

	if input == nil {
		input = &CreateServiceProfileInput{}
	}

	output = &CreateServiceProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateServiceProfile API operation for AWS IoT Wireless.
//
// Creates a new service profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation CreateServiceProfile for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * AccessDeniedException
//   User does not have permission to perform this action.
//
//   * ConflictException
//   Adding, updating, or deleting the resource can cause an inconsistent state.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateServiceProfile
func (c *IoTWireless) CreateServiceProfile(input *CreateServiceProfileInput) (*CreateServiceProfileOutput, error) {
	req, out := c.CreateServiceProfileRequest(input)
	return out, req.Send()
}

// CreateServiceProfileWithContext is the same as CreateServiceProfile with the addition of
// the ability to pass a context and additional request options.
//
// See CreateServiceProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) CreateServiceProfileWithContext(ctx aws.Context, input *CreateServiceProfileInput, opts ...request.Option) (*CreateServiceProfileOutput, error) {
	req, out := c.CreateServiceProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWirelessDevice = "CreateWirelessDevice"

// CreateWirelessDeviceRequest generates a "aws/request.Request" representing the
// client's request for the CreateWirelessDevice operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWirelessDevice for more information on using the CreateWirelessDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateWirelessDeviceRequest method.
//    req, resp := client.CreateWirelessDeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessDevice
func (c *IoTWireless) CreateWirelessDeviceRequest(input *CreateWirelessDeviceInput) (req *request.Request, output *CreateWirelessDeviceOutput) {
	op := &request.Operation{
		Name:       opCreateWirelessDevice,
		HTTPMethod: "POST",
		HTTPPath:   "/wireless-devices",
	}

	if input == nil {
		input = &CreateWirelessDeviceInput{}
	}

	output = &CreateWirelessDeviceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateWirelessDevice API operation for AWS IoT Wireless.
//
// Provisions a wireless device.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation CreateWirelessDevice for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * ResourceNotFoundException
//   Resource does not exist.
//
//   * AccessDeniedException
//   User does not have permission to perform this action.
//
//   * ConflictException
//   Adding, updating, or deleting the resource can cause an inconsistent state.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessDevice
func (c *IoTWireless) CreateWirelessDevice(input *CreateWirelessDeviceInput) (*CreateWirelessDeviceOutput, error) {
	req, out := c.CreateWirelessDeviceRequest(input)
	return out, req.Send()
}

// CreateWirelessDeviceWithContext is the same as CreateWirelessDevice with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWirelessDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) CreateWirelessDeviceWithContext(ctx aws.Context, input *CreateWirelessDeviceInput, opts ...request.Option) (*CreateWirelessDeviceOutput, error) {
	req, out := c.CreateWirelessDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWirelessGateway = "CreateWirelessGateway"

// CreateWirelessGatewayRequest generates a "aws/request.Request" representing the
// client's request for the CreateWirelessGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWirelessGateway for more information on using the CreateWirelessGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateWirelessGatewayRequest method.
//    req, resp := client.CreateWirelessGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessGateway
func (c *IoTWireless) CreateWirelessGatewayRequest(input *CreateWirelessGatewayInput) (req *request.Request, output *CreateWirelessGatewayOutput) {
	op := &request.Operation{
		Name:       opCreateWirelessGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/wireless-gateways",
	}

	if input == nil {
		input = &CreateWirelessGatewayInput{}
	}

	output = &CreateWirelessGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateWirelessGateway API operation for AWS IoT Wireless.
//
// Provisions a wireless gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation CreateWirelessGateway for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * AccessDeniedException
//   User does not have permission to perform this action.
//
//   * ConflictException
//   Adding, updating, or deleting the resource can cause an inconsistent state.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessGateway
func (c *IoTWireless) CreateWirelessGateway(input *CreateWirelessGatewayInput) (*CreateWirelessGatewayOutput, error) {
	req, out := c.CreateWirelessGatewayRequest(input)
	return out, req.Send()
}

// CreateWirelessGatewayWithContext is the same as CreateWirelessGateway with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWirelessGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) CreateWirelessGatewayWithContext(ctx aws.Context, input *CreateWirelessGatewayInput, opts ...request.Option) (*CreateWirelessGatewayOutput, error) {
	req, out := c.CreateWirelessGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWirelessGatewayTask = "CreateWirelessGatewayTask"

// CreateWirelessGatewayTaskRequest generates a "aws/request.Request" representing the
// client's request for the CreateWirelessGatewayTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWirelessGatewayTask for more information on using the CreateWirelessGatewayTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateWirelessGatewayTaskRequest method.
//    req, resp := client.CreateWirelessGatewayTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessGatewayTask
func (c *IoTWireless) CreateWirelessGatewayTaskRequest(input *CreateWirelessGatewayTaskInput) (req *request.Request, output *CreateWirelessGatewayTaskOutput) {
	op := &request.Operation{
		Name:       opCreateWirelessGatewayTask,
		HTTPMethod: "POST",
		HTTPPath:   "/wireless-gateways/{Id}/tasks",
	}

	if input == nil {
		input = &CreateWirelessGatewayTaskInput{}
	}

	output = &CreateWirelessGatewayTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateWirelessGatewayTask API operation for AWS IoT Wireless.
//
// Creates a task for a wireless gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation CreateWirelessGatewayTask for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * AccessDeniedException
//   User does not have permission to perform this action.
//
//   * ResourceNotFoundException
//   Resource does not exist.
//
//   * ConflictException
//   Adding, updating, or deleting the resource can cause an inconsistent state.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessGatewayTask
func (c *IoTWireless) CreateWirelessGatewayTask(input *CreateWirelessGatewayTaskInput) (*CreateWirelessGatewayTaskOutput, error) {
	req, out := c.CreateWirelessGatewayTaskRequest(input)
	return out, req.Send()
}

// CreateWirelessGatewayTaskWithContext is the same as CreateWirelessGatewayTask with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWirelessGatewayTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) CreateWirelessGatewayTaskWithContext(ctx aws.Context, input *CreateWirelessGatewayTaskInput, opts ...request.Option) (*CreateWirelessGatewayTaskOutput, error) {
	req, out := c.CreateWirelessGatewayTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWirelessGatewayTaskDefinition = "CreateWirelessGatewayTaskDefinition"

// CreateWirelessGatewayTaskDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the CreateWirelessGatewayTaskDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWirelessGatewayTaskDefinition for more information on using the CreateWirelessGatewayTaskDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateWirelessGatewayTaskDefinitionRequest method.
//    req, resp := client.CreateWirelessGatewayTaskDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessGatewayTaskDefinition
func (c *IoTWireless) CreateWirelessGatewayTaskDefinitionRequest(input *CreateWirelessGatewayTaskDefinitionInput) (req *request.Request, output *CreateWirelessGatewayTaskDefinitionOutput) {
	op := &request.Operation{
		Name:       opCreateWirelessGatewayTaskDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/wireless-gateway-task-definitions",
	}

	if input == nil {
		input = &CreateWirelessGatewayTaskDefinitionInput{}
	}

	output = &CreateWirelessGatewayTaskDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateWirelessGatewayTaskDefinition API operation for AWS IoT Wireless.
//
// Creates a gateway task definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation CreateWirelessGatewayTaskDefinition for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * AccessDeniedException
//   User does not have permission to perform this action.
//
//   * ResourceNotFoundException
//   Resource does not exist.
//
//   * ConflictException
//   Adding, updating, or deleting the resource can cause an inconsistent state.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessGatewayTaskDefinition
func (c *IoTWireless) CreateWirelessGatewayTaskDefinition(input *CreateWirelessGatewayTaskDefinitionInput) (*CreateWirelessGatewayTaskDefinitionOutput, error) {
	req, out := c.CreateWirelessGatewayTaskDefinitionRequest(input)
	return out, req.Send()
}

// CreateWirelessGatewayTaskDefinitionWithContext is the same as CreateWirelessGatewayTaskDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWirelessGatewayTaskDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) CreateWirelessGatewayTaskDefinitionWithContext(ctx aws.Context, input *CreateWirelessGatewayTaskDefinitionInput, opts ...request.Option) (*CreateWirelessGatewayTaskDefinitionOutput, error) {
	req, out := c.CreateWirelessGatewayTaskDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDestination = "DeleteDestination"

// DeleteDestinationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDestination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDestination for more information on using the DeleteDestination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDestinationRequest method.
//    req, resp := client.DeleteDestinationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteDestination
func (c *IoTWireless) DeleteDestinationRequest(input *DeleteDestinationInput) (req *request.Request, output *DeleteDestinationOutput) {
	op := &request.Operation{
		Name:       opDeleteDestination,
		HTTPMethod: "DELETE",
		HTTPPath:   "/destinations/{Name}",
	}

	if input == nil {
		input = &DeleteDestinationInput{}
	}

	output = &DeleteDestinationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDestination API operation for AWS IoT Wireless.
//
// Deletes a destination.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation DeleteDestination for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * ResourceNotFoundException
//   Resource does not exist.
//
//   * AccessDeniedException
//   User does not have permission to perform this action.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
//   * ConflictException
//   Adding, updating, or deleting the resource can cause an inconsistent state.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteDestination
func (c *IoTWireless) DeleteDestination(input *DeleteDestinationInput) (*DeleteDestinationOutput, error) {
	req, out := c.DeleteDestinationRequest(input)
	return out, req.Send()
}

// DeleteDestinationWithContext is the same as DeleteDestination with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) DeleteDestinationWithContext(ctx aws.Context, input *DeleteDestinationInput, opts ...request.Option) (*DeleteDestinationOutput, error) {
	req, out := c.DeleteDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDeviceProfile = "DeleteDeviceProfile"

// DeleteDeviceProfileRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDeviceProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDeviceProfile for more information on using the DeleteDeviceProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDeviceProfileRequest method.
//    req, resp := client.DeleteDeviceProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteDeviceProfile
func (c *IoTWireless) DeleteDeviceProfileRequest(input *DeleteDeviceProfileInput) (req *request.Request, output *DeleteDeviceProfileOutput) {
	op := &request.Operation{
		Name:       opDeleteDeviceProfile,
		HTTPMethod: "DELETE",
		HTTPPath:   "/device-profiles/{Id}",
	}

	if input == nil {
		input = &DeleteDeviceProfileInput{}
	}

	output = &DeleteDeviceProfileOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDeviceProfile API operation for AWS IoT Wireless.
//
// Deletes a device profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation DeleteDeviceProfile for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * AccessDeniedException
//   User does not have permission to perform this action.
//
//   * ResourceNotFoundException
//   Resource does not exist.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
//   * ConflictException
//   Adding, updating, or deleting the resource can cause an inconsistent state.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteDeviceProfile
func (c *IoTWireless) DeleteDeviceProfile(input *DeleteDeviceProfileInput) (*DeleteDeviceProfileOutput, error) {
	req, out := c.DeleteDeviceProfileRequest(input)
	return out, req.Send()
}

// DeleteDeviceProfileWithContext is the same as DeleteDeviceProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDeviceProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) DeleteDeviceProfileWithContext(ctx aws.Context, input *DeleteDeviceProfileInput, opts ...request.Option) (*DeleteDeviceProfileOutput, error) {
	req, out := c.DeleteDeviceProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteServiceProfile = "DeleteServiceProfile"

// DeleteServiceProfileRequest generates a "aws/request.Request" representing the
// client's request for the DeleteServiceProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteServiceProfile for more information on using the DeleteServiceProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteServiceProfileRequest method.
//    req, resp := client.DeleteServiceProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteServiceProfile
func (c *IoTWireless) DeleteServiceProfileRequest(input *DeleteServiceProfileInput) (req *request.Request, output *DeleteServiceProfileOutput) {
	op := &request.Operation{
		Name:       opDeleteServiceProfile,
		HTTPMethod: "DELETE",
		HTTPPath:   "/service-profiles/{Id}",
	}

	if input == nil {
		input = &DeleteServiceProfileInput{}
	}

	output = &DeleteServiceProfileOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteServiceProfile API operation for AWS IoT Wireless.
//
// Deletes a service profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation DeleteServiceProfile for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * AccessDeniedException
//   User does not have permission to perform this action.
//
//   * ResourceNotFoundException
//   Resource does not exist.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
//   * ConflictException
//   Adding, updating, or deleting the resource can cause an inconsistent state.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteServiceProfile
func (c *IoTWireless) DeleteServiceProfile(input *DeleteServiceProfileInput) (*DeleteServiceProfileOutput, error) {
	req, out := c.DeleteServiceProfileRequest(input)
	return out, req.Send()
}

// DeleteServiceProfileWithContext is the same as DeleteServiceProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteServiceProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) DeleteServiceProfileWithContext(ctx aws.Context, input *DeleteServiceProfileInput, opts ...request.Option) (*DeleteServiceProfileOutput, error) {
	req, out := c.DeleteServiceProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteWirelessDevice = "DeleteWirelessDevice"

// DeleteWirelessDeviceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteWirelessDevice operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteWirelessDevice for more information on using the DeleteWirelessDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteWirelessDeviceRequest method.
//    req, resp := client.DeleteWirelessDeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessDevice
func (c *IoTWireless) DeleteWirelessDeviceRequest(input *DeleteWirelessDeviceInput) (req *request.Request, output *DeleteWirelessDeviceOutput) {
	op := &request.Operation{
		Name:       opDeleteWirelessDevice,
		HTTPMethod: "DELETE",
		HTTPPath:   "/wireless-devices/{Id}",
	}

	if input == nil {
		input = &DeleteWirelessDeviceInput{}
	}

	output = &DeleteWirelessDeviceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteWirelessDevice API operation for AWS IoT Wireless.
//
// Deletes a wireless device.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation DeleteWirelessDevice for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * ResourceNotFoundException
//   Resource does not exist.
//
//   * AccessDeniedException
//   User does not have permission to perform this action.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessDevice
func (c *IoTWireless) DeleteWirelessDevice(input *DeleteWirelessDeviceInput) (*DeleteWirelessDeviceOutput, error) {
	req, out := c.DeleteWirelessDeviceRequest(input)
	return out, req.Send()
}

// DeleteWirelessDeviceWithContext is the same as DeleteWirelessDevice with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteWirelessDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) DeleteWirelessDeviceWithContext(ctx aws.Context, input *DeleteWirelessDeviceInput, opts ...request.Option) (*DeleteWirelessDeviceOutput, error) {
	req, out := c.DeleteWirelessDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteWirelessGateway = "DeleteWirelessGateway"

// DeleteWirelessGatewayRequest generates a "aws/request.Request" representing the
// client's request for the DeleteWirelessGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteWirelessGateway for more information on using the DeleteWirelessGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteWirelessGatewayRequest method.
//    req, resp := client.DeleteWirelessGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessGateway
func (c *IoTWireless) DeleteWirelessGatewayRequest(input *DeleteWirelessGatewayInput) (req *request.Request, output *DeleteWirelessGatewayOutput) {
	op := &request.Operation{
		Name:       opDeleteWirelessGateway,
		HTTPMethod: "DELETE",
		HTTPPath:   "/wireless-gateways/{Id}",
	}

	if input == nil {
		input = &DeleteWirelessGatewayInput{}
	}

	output = &DeleteWirelessGatewayOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteWirelessGateway API operation for AWS IoT Wireless.
//
// Deletes a wireless gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation DeleteWirelessGateway for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * ResourceNotFoundException
//   Resource does not exist.
//
//   * AccessDeniedException
//   User does not have permission to perform this action.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessGateway
func (c *IoTWireless) DeleteWirelessGateway(input *DeleteWirelessGatewayInput) (*DeleteWirelessGatewayOutput, error) {
	req, out := c.DeleteWirelessGatewayRequest(input)
	return out, req.Send()
}

// DeleteWirelessGatewayWithContext is the same as DeleteWirelessGateway with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteWirelessGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) DeleteWirelessGatewayWithContext(ctx aws.Context, input *DeleteWirelessGatewayInput, opts ...request.Option) (*DeleteWirelessGatewayOutput, error) {
	req, out := c.DeleteWirelessGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteWirelessGatewayTask = "DeleteWirelessGatewayTask"

// DeleteWirelessGatewayTaskRequest generates a "aws/request.Request" representing the
// client's request for the DeleteWirelessGatewayTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteWirelessGatewayTask for more information on using the DeleteWirelessGatewayTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteWirelessGatewayTaskRequest method.
//    req, resp := client.DeleteWirelessGatewayTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessGatewayTask
func (c *IoTWireless) DeleteWirelessGatewayTaskRequest(input *DeleteWirelessGatewayTaskInput) (req *request.Request, output *DeleteWirelessGatewayTaskOutput) {
	op := &request.Operation{
		Name:       opDeleteWirelessGatewayTask,
		HTTPMethod: "DELETE",
		HTTPPath:   "/wireless-gateways/{Id}/tasks",
	}

	if input == nil {
		input = &DeleteWirelessGatewayTaskInput{}
	}

	output = &DeleteWirelessGatewayTaskOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteWirelessGatewayTask API operation for AWS IoT Wireless.
//
// Deletes a wireless gateway task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation DeleteWirelessGatewayTask for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * AccessDeniedException
//   User does not have permission to perform this action.
//
//   * ResourceNotFoundException
//   Resource does not exist.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessGatewayTask
func (c *IoTWireless) DeleteWirelessGatewayTask(input *DeleteWirelessGatewayTaskInput) (*DeleteWirelessGatewayTaskOutput, error) {
	req, out := c.DeleteWirelessGatewayTaskRequest(input)
	return out, req.Send()
}

// DeleteWirelessGatewayTaskWithContext is the same as DeleteWirelessGatewayTask with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteWirelessGatewayTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) DeleteWirelessGatewayTaskWithContext(ctx aws.Context, input *DeleteWirelessGatewayTaskInput, opts ...request.Option) (*DeleteWirelessGatewayTaskOutput, error) {
	req, out := c.DeleteWirelessGatewayTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteWirelessGatewayTaskDefinition = "DeleteWirelessGatewayTaskDefinition"

// DeleteWirelessGatewayTaskDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteWirelessGatewayTaskDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteWirelessGatewayTaskDefinition for more information on using the DeleteWirelessGatewayTaskDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteWirelessGatewayTaskDefinitionRequest method.
//    req, resp := client.DeleteWirelessGatewayTaskDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessGatewayTaskDefinition
func (c *IoTWireless) DeleteWirelessGatewayTaskDefinitionRequest(input *DeleteWirelessGatewayTaskDefinitionInput) (req *request.Request, output *DeleteWirelessGatewayTaskDefinitionOutput) {
	op := &request.Operation{
		Name:       opDeleteWirelessGatewayTaskDefinition,
		HTTPMethod: "DELETE",
		HTTPPath:   "/wireless-gateway-task-definitions/{Id}",
	}

	if input == nil {
		input = &DeleteWirelessGatewayTaskDefinitionInput{}
	}

	output = &DeleteWirelessGatewayTaskDefinitionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteWirelessGatewayTaskDefinition API operation for AWS IoT Wireless.
//
// Deletes a wireless gateway task definition. Deleting this task definition
// does not affect tasks that are currently in progress.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation DeleteWirelessGatewayTaskDefinition for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * AccessDeniedException
//   User does not have permission to perform this action.
//
//   * ResourceNotFoundException
//   Resource does not exist.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessGatewayTaskDefinition
func (c *IoTWireless) DeleteWirelessGatewayTaskDefinition(input *DeleteWirelessGatewayTaskDefinitionInput) (*DeleteWirelessGatewayTaskDefinitionOutput, error) {
	req, out := c.DeleteWirelessGatewayTaskDefinitionRequest(input)
	return out, req.Send()
}

// DeleteWirelessGatewayTaskDefinitionWithContext is the same as DeleteWirelessGatewayTaskDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteWirelessGatewayTaskDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) DeleteWirelessGatewayTaskDefinitionWithContext(ctx aws.Context, input *DeleteWirelessGatewayTaskDefinitionInput, opts ...request.Option) (*DeleteWirelessGatewayTaskDefinitionOutput, error) {
	req, out := c.DeleteWirelessGatewayTaskDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateAwsAccountFromPartnerAccount = "DisassociateAwsAccountFromPartnerAccount"

// DisassociateAwsAccountFromPartnerAccountRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateAwsAccountFromPartnerAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateAwsAccountFromPartnerAccount for more information on using the DisassociateAwsAccountFromPartnerAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateAwsAccountFromPartnerAccountRequest method.
//    req, resp := client.DisassociateAwsAccountFromPartnerAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateAwsAccountFromPartnerAccount
func (c *IoTWireless) DisassociateAwsAccountFromPartnerAccountRequest(input *DisassociateAwsAccountFromPartnerAccountInput) (req *request.Request, output *DisassociateAwsAccountFromPartnerAccountOutput) {
	op := &request.Operation{
		Name:       opDisassociateAwsAccountFromPartnerAccount,
		HTTPMethod: "DELETE",
		HTTPPath:   "/partner-accounts/{PartnerAccountId}",
	}

	if input == nil {
		input = &DisassociateAwsAccountFromPartnerAccountInput{}
	}

	output = &DisassociateAwsAccountFromPartnerAccountOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateAwsAccountFromPartnerAccount API operation for AWS IoT Wireless.
//
// Disassociates your AWS account from a partner account. If PartnerAccountId
// and PartnerType are null, disassociates your AWS account from all partner
// accounts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation DisassociateAwsAccountFromPartnerAccount for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * ResourceNotFoundException
//   Resource does not exist.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateAwsAccountFromPartnerAccount
func (c *IoTWireless) DisassociateAwsAccountFromPartnerAccount(input *DisassociateAwsAccountFromPartnerAccountInput) (*DisassociateAwsAccountFromPartnerAccountOutput, error) {
	req, out := c.DisassociateAwsAccountFromPartnerAccountRequest(input)
	return out, req.Send()
}

// DisassociateAwsAccountFromPartnerAccountWithContext is the same as DisassociateAwsAccountFromPartnerAccount with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateAwsAccountFromPartnerAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) DisassociateAwsAccountFromPartnerAccountWithContext(ctx aws.Context, input *DisassociateAwsAccountFromPartnerAccountInput, opts ...request.Option) (*DisassociateAwsAccountFromPartnerAccountOutput, error) {
	req, out := c.DisassociateAwsAccountFromPartnerAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateWirelessDeviceFromThing = "DisassociateWirelessDeviceFromThing"

// DisassociateWirelessDeviceFromThingRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateWirelessDeviceFromThing operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateWirelessDeviceFromThing for more information on using the DisassociateWirelessDeviceFromThing
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateWirelessDeviceFromThingRequest method.
//    req, resp := client.DisassociateWirelessDeviceFromThingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessDeviceFromThing
func (c *IoTWireless) DisassociateWirelessDeviceFromThingRequest(input *DisassociateWirelessDeviceFromThingInput) (req *request.Request, output *DisassociateWirelessDeviceFromThingOutput) {
	op := &request.Operation{
		Name:       opDisassociateWirelessDeviceFromThing,
		HTTPMethod: "DELETE",
		HTTPPath:   "/wireless-devices/{Id}/thing",
	}

	if input == nil {
		input = &DisassociateWirelessDeviceFromThingInput{}
	}

	output = &DisassociateWirelessDeviceFromThingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateWirelessDeviceFromThing API operation for AWS IoT Wireless.
//
// Disassociates a wireless device from its currently associated thing.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation DisassociateWirelessDeviceFromThing for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * AccessDeniedException
//   User does not have permission to perform this action.
//
//   * ResourceNotFoundException
//   Resource does not exist.
//
//   * ConflictException
//   Adding, updating, or deleting the resource can cause an inconsistent state.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessDeviceFromThing
func (c *IoTWireless) DisassociateWirelessDeviceFromThing(input *DisassociateWirelessDeviceFromThingInput) (*DisassociateWirelessDeviceFromThingOutput, error) {
	req, out := c.DisassociateWirelessDeviceFromThingRequest(input)
	return out, req.Send()
}

// DisassociateWirelessDeviceFromThingWithContext is the same as DisassociateWirelessDeviceFromThing with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateWirelessDeviceFromThing for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) DisassociateWirelessDeviceFromThingWithContext(ctx aws.Context, input *DisassociateWirelessDeviceFromThingInput, opts ...request.Option) (*DisassociateWirelessDeviceFromThingOutput, error) {
	req, out := c.DisassociateWirelessDeviceFromThingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateWirelessGatewayFromCertificate = "DisassociateWirelessGatewayFromCertificate"

// DisassociateWirelessGatewayFromCertificateRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateWirelessGatewayFromCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateWirelessGatewayFromCertificate for more information on using the DisassociateWirelessGatewayFromCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateWirelessGatewayFromCertificateRequest method.
//    req, resp := client.DisassociateWirelessGatewayFromCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessGatewayFromCertificate
func (c *IoTWireless) DisassociateWirelessGatewayFromCertificateRequest(input *DisassociateWirelessGatewayFromCertificateInput) (req *request.Request, output *DisassociateWirelessGatewayFromCertificateOutput) {
	op := &request.Operation{
		Name:       opDisassociateWirelessGatewayFromCertificate,
		HTTPMethod: "DELETE",
		HTTPPath:   "/wireless-gateways/{Id}/certificate",
	}

	if input == nil {
		input = &DisassociateWirelessGatewayFromCertificateInput{}
	}

	output = &DisassociateWirelessGatewayFromCertificateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateWirelessGatewayFromCertificate API operation for AWS IoT Wireless.
//
// Disassociates a wireless gateway from its currently associated certificate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation DisassociateWirelessGatewayFromCertificate for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * AccessDeniedException
//   User does not have permission to perform this action.
//
//   * ResourceNotFoundException
//   Resource does not exist.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessGatewayFromCertificate
func (c *IoTWireless) DisassociateWirelessGatewayFromCertificate(input *DisassociateWirelessGatewayFromCertificateInput) (*DisassociateWirelessGatewayFromCertificateOutput, error) {
	req, out := c.DisassociateWirelessGatewayFromCertificateRequest(input)
	return out, req.Send()
}

// DisassociateWirelessGatewayFromCertificateWithContext is the same as DisassociateWirelessGatewayFromCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateWirelessGatewayFromCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) DisassociateWirelessGatewayFromCertificateWithContext(ctx aws.Context, input *DisassociateWirelessGatewayFromCertificateInput, opts ...request.Option) (*DisassociateWirelessGatewayFromCertificateOutput, error) {
	req, out := c.DisassociateWirelessGatewayFromCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateWirelessGatewayFromThing = "DisassociateWirelessGatewayFromThing"

// DisassociateWirelessGatewayFromThingRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateWirelessGatewayFromThing operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateWirelessGatewayFromThing for more information on using the DisassociateWirelessGatewayFromThing
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateWirelessGatewayFromThingRequest method.
//    req, resp := client.DisassociateWirelessGatewayFromThingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessGatewayFromThing
func (c *IoTWireless) DisassociateWirelessGatewayFromThingRequest(input *DisassociateWirelessGatewayFromThingInput) (req *request.Request, output *DisassociateWirelessGatewayFromThingOutput) {
	op := &request.Operation{
		Name:       opDisassociateWirelessGatewayFromThing,
		HTTPMethod: "DELETE",
		HTTPPath:   "/wireless-gateways/{Id}/thing",
	}

	if input == nil {
		input = &DisassociateWirelessGatewayFromThingInput{}
	}

	output = &DisassociateWirelessGatewayFromThingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateWirelessGatewayFromThing API operation for AWS IoT Wireless.
//
// Disassociates a wireless gateway from its currently associated thing.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation DisassociateWirelessGatewayFromThing for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * AccessDeniedException
//   User does not have permission to perform this action.
//
//   * ResourceNotFoundException
//   Resource does not exist.
//
//   * ConflictException
//   Adding, updating, or deleting the resource can cause an inconsistent state.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessGatewayFromThing
func (c *IoTWireless) DisassociateWirelessGatewayFromThing(input *DisassociateWirelessGatewayFromThingInput) (*DisassociateWirelessGatewayFromThingOutput, error) {
	req, out := c.DisassociateWirelessGatewayFromThingRequest(input)
	return out, req.Send()
}

// DisassociateWirelessGatewayFromThingWithContext is the same as DisassociateWirelessGatewayFromThing with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateWirelessGatewayFromThing for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) DisassociateWirelessGatewayFromThingWithContext(ctx aws.Context, input *DisassociateWirelessGatewayFromThingInput, opts ...request.Option) (*DisassociateWirelessGatewayFromThingOutput, error) {
	req, out := c.DisassociateWirelessGatewayFromThingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDestination = "GetDestination"

// GetDestinationRequest generates a "aws/request.Request" representing the
// client's request for the GetDestination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDestination for more information on using the GetDestination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDestinationRequest method.
//    req, resp := client.GetDestinationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetDestination
func (c *IoTWireless) GetDestinationRequest(input *GetDestinationInput) (req *request.Request, output *GetDestinationOutput) {
	op := &request.Operation{
		Name:       opGetDestination,
		HTTPMethod: "GET",
		HTTPPath:   "/destinations/{Name}",
	}

	if input == nil {
		input = &GetDestinationInput{}
	}

	output = &GetDestinationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDestination API operation for AWS IoT Wireless.
//
// Gets information about a destination.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation GetDestination for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * ResourceNotFoundException
//   Resource does not exist.
//
//   * AccessDeniedException
//   User does not have permission to perform this action.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetDestination
func (c *IoTWireless) GetDestination(input *GetDestinationInput) (*GetDestinationOutput, error) {
	req, out := c.GetDestinationRequest(input)
	return out, req.Send()
}

// GetDestinationWithContext is the same as GetDestination with the addition of
// the ability to pass a context and additional request options.
//
// See GetDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) GetDestinationWithContext(ctx aws.Context, input *GetDestinationInput, opts ...request.Option) (*GetDestinationOutput, error) {
	req, out := c.GetDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDeviceProfile = "GetDeviceProfile"

// GetDeviceProfileRequest generates a "aws/request.Request" representing the
// client's request for the GetDeviceProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDeviceProfile for more information on using the GetDeviceProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDeviceProfileRequest method.
//    req, resp := client.GetDeviceProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetDeviceProfile
func (c *IoTWireless) GetDeviceProfileRequest(input *GetDeviceProfileInput) (req *request.Request, output *GetDeviceProfileOutput) {
	op := &request.Operation{
		Name:       opGetDeviceProfile,
		HTTPMethod: "GET",
		HTTPPath:   "/device-profiles/{Id}",
	}

	if input == nil {
		input = &GetDeviceProfileInput{}
	}

	output = &GetDeviceProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDeviceProfile API operation for AWS IoT Wireless.
//
// Gets information about a device profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation GetDeviceProfile for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * AccessDeniedException
//   User does not have permission to perform this action.
//
//   * ResourceNotFoundException
//   Resource does not exist.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetDeviceProfile
func (c *IoTWireless) GetDeviceProfile(input *GetDeviceProfileInput) (*GetDeviceProfileOutput, error) {
	req, out := c.GetDeviceProfileRequest(input)
	return out, req.Send()
}

// GetDeviceProfileWithContext is the same as GetDeviceProfile with the addition of
// the ability to pass a context and additional request options.
//
// See GetDeviceProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) GetDeviceProfileWithContext(ctx aws.Context, input *GetDeviceProfileInput, opts ...request.Option) (*GetDeviceProfileOutput, error) {
	req, out := c.GetDeviceProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPartnerAccount = "GetPartnerAccount"

// GetPartnerAccountRequest generates a "aws/request.Request" representing the
// client's request for the GetPartnerAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPartnerAccount for more information on using the GetPartnerAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetPartnerAccountRequest method.
//    req, resp := client.GetPartnerAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetPartnerAccount
func (c *IoTWireless) GetPartnerAccountRequest(input *GetPartnerAccountInput) (req *request.Request, output *GetPartnerAccountOutput) {
	op := &request.Operation{
		Name:       opGetPartnerAccount,
		HTTPMethod: "GET",
		HTTPPath:   "/partner-accounts/{PartnerAccountId}",
	}

	if input == nil {
		input = &GetPartnerAccountInput{}
	}

	output = &GetPartnerAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPartnerAccount API operation for AWS IoT Wireless.
//
// Gets information about a partner account. If PartnerAccountId and PartnerType
// are null, returns all partner accounts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation GetPartnerAccount for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * ResourceNotFoundException
//   Resource does not exist.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetPartnerAccount
func (c *IoTWireless) GetPartnerAccount(input *GetPartnerAccountInput) (*GetPartnerAccountOutput, error) {
	req, out := c.GetPartnerAccountRequest(input)
	return out, req.Send()
}

// GetPartnerAccountWithContext is the same as GetPartnerAccount with the addition of
// the ability to pass a context and additional request options.
//
// See GetPartnerAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) GetPartnerAccountWithContext(ctx aws.Context, input *GetPartnerAccountInput, opts ...request.Option) (*GetPartnerAccountOutput, error) {
	req, out := c.GetPartnerAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetServiceEndpoint = "GetServiceEndpoint"

// GetServiceEndpointRequest generates a "aws/request.Request" representing the
// client's request for the GetServiceEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetServiceEndpoint for more information on using the GetServiceEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetServiceEndpointRequest method.
//    req, resp := client.GetServiceEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetServiceEndpoint
func (c *IoTWireless) GetServiceEndpointRequest(input *GetServiceEndpointInput) (req *request.Request, output *GetServiceEndpointOutput) {
	op := &request.Operation{
		Name:       opGetServiceEndpoint,
		HTTPMethod: "GET",
		HTTPPath:   "/service-endpoint",
	}

	if input == nil {
		input = &GetServiceEndpointInput{}
	}

	output = &GetServiceEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetServiceEndpoint API operation for AWS IoT Wireless.
//
// Gets the account-specific endpoint for Configuration and Update Server (CUPS)
// protocol or LoRaWAN Network Server (LNS) connections.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation GetServiceEndpoint for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * AccessDeniedException
//   User does not have permission to perform this action.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetServiceEndpoint
func (c *IoTWireless) GetServiceEndpoint(input *GetServiceEndpointInput) (*GetServiceEndpointOutput, error) {
	req, out := c.GetServiceEndpointRequest(input)
	return out, req.Send()
}

// GetServiceEndpointWithContext is the same as GetServiceEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See GetServiceEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) GetServiceEndpointWithContext(ctx aws.Context, input *GetServiceEndpointInput, opts ...request.Option) (*GetServiceEndpointOutput, error) {
	req, out := c.GetServiceEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetServiceProfile = "GetServiceProfile"

// GetServiceProfileRequest generates a "aws/request.Request" representing the
// client's request for the GetServiceProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetServiceProfile for more information on using the GetServiceProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetServiceProfileRequest method.
//    req, resp := client.GetServiceProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetServiceProfile
func (c *IoTWireless) GetServiceProfileRequest(input *GetServiceProfileInput) (req *request.Request, output *GetServiceProfileOutput) {
	op := &request.Operation{
		Name:       opGetServiceProfile,
		HTTPMethod: "GET",
		HTTPPath:   "/service-profiles/{Id}",
	}

	if input == nil {
		input = &GetServiceProfileInput{}
	}

	output = &GetServiceProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetServiceProfile API operation for AWS IoT Wireless.
//
// Gets information about a service profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation GetServiceProfile for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * AccessDeniedException
//   User does not have permission to perform this action.
//
//   * ResourceNotFoundException
//   Resource does not exist.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetServiceProfile
func (c *IoTWireless) GetServiceProfile(input *GetServiceProfileInput) (*GetServiceProfileOutput, error) {
	req, out := c.GetServiceProfileRequest(input)
	return out, req.Send()
}

// GetServiceProfileWithContext is the same as GetServiceProfile with the addition of
// the ability to pass a context and additional request options.
//
// See GetServiceProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) GetServiceProfileWithContext(ctx aws.Context, input *GetServiceProfileInput, opts ...request.Option) (*GetServiceProfileOutput, error) {
	req, out := c.GetServiceProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetWirelessDevice = "GetWirelessDevice"

// GetWirelessDeviceRequest generates a "aws/request.Request" representing the
// client's request for the GetWirelessDevice operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetWirelessDevice for more information on using the GetWirelessDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetWirelessDeviceRequest method.
//    req, resp := client.GetWirelessDeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessDevice
func (c *IoTWireless) GetWirelessDeviceRequest(input *GetWirelessDeviceInput) (req *request.Request, output *GetWirelessDeviceOutput) {
	op := &request.Operation{
		Name:       opGetWirelessDevice,
		HTTPMethod: "GET",
		HTTPPath:   "/wireless-devices/{Identifier}",
	}

	if input == nil {
		input = &GetWirelessDeviceInput{}
	}

	output = &GetWirelessDeviceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetWirelessDevice API operation for AWS IoT Wireless.
//
// Gets information about a wireless device.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation GetWirelessDevice for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * AccessDeniedException
//   User does not have permission to perform this action.
//
//   * ResourceNotFoundException
//   Resource does not exist.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessDevice
func (c *IoTWireless) GetWirelessDevice(input *GetWirelessDeviceInput) (*GetWirelessDeviceOutput, error) {
	req, out := c.GetWirelessDeviceRequest(input)
	return out, req.Send()
}

// GetWirelessDeviceWithContext is the same as GetWirelessDevice with the addition of
// the ability to pass a context and additional request options.
//
// See GetWirelessDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) GetWirelessDeviceWithContext(ctx aws.Context, input *GetWirelessDeviceInput, opts ...request.Option) (*GetWirelessDeviceOutput, error) {
	req, out := c.GetWirelessDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetWirelessDeviceStatistics = "GetWirelessDeviceStatistics"

// GetWirelessDeviceStatisticsRequest generates a "aws/request.Request" representing the
// client's request for the GetWirelessDeviceStatistics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetWirelessDeviceStatistics for more information on using the GetWirelessDeviceStatistics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetWirelessDeviceStatisticsRequest method.
//    req, resp := client.GetWirelessDeviceStatisticsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessDeviceStatistics
func (c *IoTWireless) GetWirelessDeviceStatisticsRequest(input *GetWirelessDeviceStatisticsInput) (req *request.Request, output *GetWirelessDeviceStatisticsOutput) {
	op := &request.Operation{
		Name:       opGetWirelessDeviceStatistics,
		HTTPMethod: "GET",
		HTTPPath:   "/wireless-devices/{Id}/statistics",
	}

	if input == nil {
		input = &GetWirelessDeviceStatisticsInput{}
	}

	output = &GetWirelessDeviceStatisticsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetWirelessDeviceStatistics API operation for AWS IoT Wireless.
//
// Gets operating information about a wireless device.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation GetWirelessDeviceStatistics for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * AccessDeniedException
//   User does not have permission to perform this action.
//
//   * ResourceNotFoundException
//   Resource does not exist.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessDeviceStatistics
func (c *IoTWireless) GetWirelessDeviceStatistics(input *GetWirelessDeviceStatisticsInput) (*GetWirelessDeviceStatisticsOutput, error) {
	req, out := c.GetWirelessDeviceStatisticsRequest(input)
	return out, req.Send()
}

// GetWirelessDeviceStatisticsWithContext is the same as GetWirelessDeviceStatistics with the addition of
// the ability to pass a context and additional request options.
//
// See GetWirelessDeviceStatistics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) GetWirelessDeviceStatisticsWithContext(ctx aws.Context, input *GetWirelessDeviceStatisticsInput, opts ...request.Option) (*GetWirelessDeviceStatisticsOutput, error) {
	req, out := c.GetWirelessDeviceStatisticsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetWirelessGateway = "GetWirelessGateway"

// GetWirelessGatewayRequest generates a "aws/request.Request" representing the
// client's request for the GetWirelessGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetWirelessGateway for more information on using the GetWirelessGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetWirelessGatewayRequest method.
//    req, resp := client.GetWirelessGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGateway
func (c *IoTWireless) GetWirelessGatewayRequest(input *GetWirelessGatewayInput) (req *request.Request, output *GetWirelessGatewayOutput) {
	op := &request.Operation{
		Name:       opGetWirelessGateway,
		HTTPMethod: "GET",
		HTTPPath:   "/wireless-gateways/{Identifier}",
	}

	if input == nil {
		input = &GetWirelessGatewayInput{}
	}

	output = &GetWirelessGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetWirelessGateway API operation for AWS IoT Wireless.
//
// Gets information about a wireless gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation GetWirelessGateway for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * ResourceNotFoundException
//   Resource does not exist.
//
//   * AccessDeniedException
//   User does not have permission to perform this action.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGateway
func (c *IoTWireless) GetWirelessGateway(input *GetWirelessGatewayInput) (*GetWirelessGatewayOutput, error) {
	req, out := c.GetWirelessGatewayRequest(input)
	return out, req.Send()
}

// GetWirelessGatewayWithContext is the same as GetWirelessGateway with the addition of
// the ability to pass a context and additional request options.
//
// See GetWirelessGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) GetWirelessGatewayWithContext(ctx aws.Context, input *GetWirelessGatewayInput, opts ...request.Option) (*GetWirelessGatewayOutput, error) {
	req, out := c.GetWirelessGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetWirelessGatewayCertificate = "GetWirelessGatewayCertificate"

// GetWirelessGatewayCertificateRequest generates a "aws/request.Request" representing the
// client's request for the GetWirelessGatewayCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetWirelessGatewayCertificate for more information on using the GetWirelessGatewayCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetWirelessGatewayCertificateRequest method.
//    req, resp := client.GetWirelessGatewayCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayCertificate
func (c *IoTWireless) GetWirelessGatewayCertificateRequest(input *GetWirelessGatewayCertificateInput) (req *request.Request, output *GetWirelessGatewayCertificateOutput) {
	op := &request.Operation{
		Name:       opGetWirelessGatewayCertificate,
		HTTPMethod: "GET",
		HTTPPath:   "/wireless-gateways/{Id}/certificate",
	}

	if input == nil {
		input = &GetWirelessGatewayCertificateInput{}
	}

	output = &GetWirelessGatewayCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetWirelessGatewayCertificate API operation for AWS IoT Wireless.
//
// Gets the ID of the certificate that is currently associated with a wireless
// gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation GetWirelessGatewayCertificate for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * AccessDeniedException
//   User does not have permission to perform this action.
//
//   * ResourceNotFoundException
//   Resource does not exist.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayCertificate
func (c *IoTWireless) GetWirelessGatewayCertificate(input *GetWirelessGatewayCertificateInput) (*GetWirelessGatewayCertificateOutput, error) {
	req, out := c.GetWirelessGatewayCertificateRequest(input)
	return out, req.Send()
}

// GetWirelessGatewayCertificateWithContext is the same as GetWirelessGatewayCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See GetWirelessGatewayCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) GetWirelessGatewayCertificateWithContext(ctx aws.Context, input *GetWirelessGatewayCertificateInput, opts ...request.Option) (*GetWirelessGatewayCertificateOutput, error) {
	req, out := c.GetWirelessGatewayCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetWirelessGatewayFirmwareInformation = "GetWirelessGatewayFirmwareInformation"

// GetWirelessGatewayFirmwareInformationRequest generates a "aws/request.Request" representing the
// client's request for the GetWirelessGatewayFirmwareInformation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetWirelessGatewayFirmwareInformation for more information on using the GetWirelessGatewayFirmwareInformation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetWirelessGatewayFirmwareInformationRequest method.
//    req, resp := client.GetWirelessGatewayFirmwareInformationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayFirmwareInformation
func (c *IoTWireless) GetWirelessGatewayFirmwareInformationRequest(input *GetWirelessGatewayFirmwareInformationInput) (req *request.Request, output *GetWirelessGatewayFirmwareInformationOutput) {
	op := &request.Operation{
		Name:       opGetWirelessGatewayFirmwareInformation,
		HTTPMethod: "GET",
		HTTPPath:   "/wireless-gateways/{Id}/firmware-information",
	}

	if input == nil {
		input = &GetWirelessGatewayFirmwareInformationInput{}
	}

	output = &GetWirelessGatewayFirmwareInformationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetWirelessGatewayFirmwareInformation API operation for AWS IoT Wireless.
//
// Gets the firmware version and other information about a wireless gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation GetWirelessGatewayFirmwareInformation for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * AccessDeniedException
//   User does not have permission to perform this action.
//
//   * ResourceNotFoundException
//   Resource does not exist.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayFirmwareInformation
func (c *IoTWireless) GetWirelessGatewayFirmwareInformation(input *GetWirelessGatewayFirmwareInformationInput) (*GetWirelessGatewayFirmwareInformationOutput, error) {
	req, out := c.GetWirelessGatewayFirmwareInformationRequest(input)
	return out, req.Send()
}

// GetWirelessGatewayFirmwareInformationWithContext is the same as GetWirelessGatewayFirmwareInformation with the addition of
// the ability to pass a context and additional request options.
//
// See GetWirelessGatewayFirmwareInformation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) GetWirelessGatewayFirmwareInformationWithContext(ctx aws.Context, input *GetWirelessGatewayFirmwareInformationInput, opts ...request.Option) (*GetWirelessGatewayFirmwareInformationOutput, error) {
	req, out := c.GetWirelessGatewayFirmwareInformationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetWirelessGatewayStatistics = "GetWirelessGatewayStatistics"

// GetWirelessGatewayStatisticsRequest generates a "aws/request.Request" representing the
// client's request for the GetWirelessGatewayStatistics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetWirelessGatewayStatistics for more information on using the GetWirelessGatewayStatistics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetWirelessGatewayStatisticsRequest method.
//    req, resp := client.GetWirelessGatewayStatisticsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayStatistics
func (c *IoTWireless) GetWirelessGatewayStatisticsRequest(input *GetWirelessGatewayStatisticsInput) (req *request.Request, output *GetWirelessGatewayStatisticsOutput) {
	op := &request.Operation{
		Name:       opGetWirelessGatewayStatistics,
		HTTPMethod: "GET",
		HTTPPath:   "/wireless-gateways/{Id}/statistics",
	}

	if input == nil {
		input = &GetWirelessGatewayStatisticsInput{}
	}

	output = &GetWirelessGatewayStatisticsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetWirelessGatewayStatistics API operation for AWS IoT Wireless.
//
// Gets operating information about a wireless gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation GetWirelessGatewayStatistics for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * AccessDeniedException
//   User does not have permission to perform this action.
//
//   * ResourceNotFoundException
//   Resource does not exist.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayStatistics
func (c *IoTWireless) GetWirelessGatewayStatistics(input *GetWirelessGatewayStatisticsInput) (*GetWirelessGatewayStatisticsOutput, error) {
	req, out := c.GetWirelessGatewayStatisticsRequest(input)
	return out, req.Send()
}

// GetWirelessGatewayStatisticsWithContext is the same as GetWirelessGatewayStatistics with the addition of
// the ability to pass a context and additional request options.
//
// See GetWirelessGatewayStatistics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) GetWirelessGatewayStatisticsWithContext(ctx aws.Context, input *GetWirelessGatewayStatisticsInput, opts ...request.Option) (*GetWirelessGatewayStatisticsOutput, error) {
	req, out := c.GetWirelessGatewayStatisticsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetWirelessGatewayTask = "GetWirelessGatewayTask"

// GetWirelessGatewayTaskRequest generates a "aws/request.Request" representing the
// client's request for the GetWirelessGatewayTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetWirelessGatewayTask for more information on using the GetWirelessGatewayTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetWirelessGatewayTaskRequest method.
//    req, resp := client.GetWirelessGatewayTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayTask
func (c *IoTWireless) GetWirelessGatewayTaskRequest(input *GetWirelessGatewayTaskInput) (req *request.Request, output *GetWirelessGatewayTaskOutput) {
	op := &request.Operation{
		Name:       opGetWirelessGatewayTask,
		HTTPMethod: "GET",
		HTTPPath:   "/wireless-gateways/{Id}/tasks",
	}

	if input == nil {
		input = &GetWirelessGatewayTaskInput{}
	}

	output = &GetWirelessGatewayTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetWirelessGatewayTask API operation for AWS IoT Wireless.
//
// Gets information about a wireless gateway task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation GetWirelessGatewayTask for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * AccessDeniedException
//   User does not have permission to perform this action.
//
//   * ResourceNotFoundException
//   Resource does not exist.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayTask
func (c *IoTWireless) GetWirelessGatewayTask(input *GetWirelessGatewayTaskInput) (*GetWirelessGatewayTaskOutput, error) {
	req, out := c.GetWirelessGatewayTaskRequest(input)
	return out, req.Send()
}

// GetWirelessGatewayTaskWithContext is the same as GetWirelessGatewayTask with the addition of
// the ability to pass a context and additional request options.
//
// See GetWirelessGatewayTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) GetWirelessGatewayTaskWithContext(ctx aws.Context, input *GetWirelessGatewayTaskInput, opts ...request.Option) (*GetWirelessGatewayTaskOutput, error) {
	req, out := c.GetWirelessGatewayTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetWirelessGatewayTaskDefinition = "GetWirelessGatewayTaskDefinition"

// GetWirelessGatewayTaskDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the GetWirelessGatewayTaskDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetWirelessGatewayTaskDefinition for more information on using the GetWirelessGatewayTaskDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetWirelessGatewayTaskDefinitionRequest method.
//    req, resp := client.GetWirelessGatewayTaskDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayTaskDefinition
func (c *IoTWireless) GetWirelessGatewayTaskDefinitionRequest(input *GetWirelessGatewayTaskDefinitionInput) (req *request.Request, output *GetWirelessGatewayTaskDefinitionOutput) {
	op := &request.Operation{
		Name:       opGetWirelessGatewayTaskDefinition,
		HTTPMethod: "GET",
		HTTPPath:   "/wireless-gateway-task-definitions/{Id}",
	}

	if input == nil {
		input = &GetWirelessGatewayTaskDefinitionInput{}
	}

	output = &GetWirelessGatewayTaskDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetWirelessGatewayTaskDefinition API operation for AWS IoT Wireless.
//
// Gets information about a wireless gateway task definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation GetWirelessGatewayTaskDefinition for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * AccessDeniedException
//   User does not have permission to perform this action.
//
//   * ResourceNotFoundException
//   Resource does not exist.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayTaskDefinition
func (c *IoTWireless) GetWirelessGatewayTaskDefinition(input *GetWirelessGatewayTaskDefinitionInput) (*GetWirelessGatewayTaskDefinitionOutput, error) {
	req, out := c.GetWirelessGatewayTaskDefinitionRequest(input)
	return out, req.Send()
}

// GetWirelessGatewayTaskDefinitionWithContext is the same as GetWirelessGatewayTaskDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See GetWirelessGatewayTaskDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) GetWirelessGatewayTaskDefinitionWithContext(ctx aws.Context, input *GetWirelessGatewayTaskDefinitionInput, opts ...request.Option) (*GetWirelessGatewayTaskDefinitionOutput, error) {
	req, out := c.GetWirelessGatewayTaskDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDestinations = "ListDestinations"

// ListDestinationsRequest generates a "aws/request.Request" representing the
// client's request for the ListDestinations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDestinations for more information on using the ListDestinations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDestinationsRequest method.
//    req, resp := client.ListDestinationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDestinations
func (c *IoTWireless) ListDestinationsRequest(input *ListDestinationsInput) (req *request.Request, output *ListDestinationsOutput) {
	op := &request.Operation{
		Name:       opListDestinations,
		HTTPMethod: "GET",
		HTTPPath:   "/destinations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDestinationsInput{}
	}

	output = &ListDestinationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDestinations API operation for AWS IoT Wireless.
//
// Lists the destinations registered to your AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation ListDestinations for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * AccessDeniedException
//   User does not have permission to perform this action.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDestinations
func (c *IoTWireless) ListDestinations(input *ListDestinationsInput) (*ListDestinationsOutput, error) {
	req, out := c.ListDestinationsRequest(input)
	return out, req.Send()
}

// ListDestinationsWithContext is the same as ListDestinations with the addition of
// the ability to pass a context and additional request options.
//
// See ListDestinations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) ListDestinationsWithContext(ctx aws.Context, input *ListDestinationsInput, opts ...request.Option) (*ListDestinationsOutput, error) {
	req, out := c.ListDestinationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDestinationsPages iterates over the pages of a ListDestinations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDestinations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDestinations operation.
//    pageNum := 0
//    err := client.ListDestinationsPages(params,
//        func(page *iotwireless.ListDestinationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTWireless) ListDestinationsPages(input *ListDestinationsInput, fn func(*ListDestinationsOutput, bool) bool) error {
	return c.ListDestinationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDestinationsPagesWithContext same as ListDestinationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) ListDestinationsPagesWithContext(ctx aws.Context, input *ListDestinationsInput, fn func(*ListDestinationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDestinationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDestinationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDestinationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDeviceProfiles = "ListDeviceProfiles"

// ListDeviceProfilesRequest generates a "aws/request.Request" representing the
// client's request for the ListDeviceProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDeviceProfiles for more information on using the ListDeviceProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDeviceProfilesRequest method.
//    req, resp := client.ListDeviceProfilesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDeviceProfiles
func (c *IoTWireless) ListDeviceProfilesRequest(input *ListDeviceProfilesInput) (req *request.Request, output *ListDeviceProfilesOutput) {
	op := &request.Operation{
		Name:       opListDeviceProfiles,
		HTTPMethod: "GET",
		HTTPPath:   "/device-profiles",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDeviceProfilesInput{}
	}

	output = &ListDeviceProfilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDeviceProfiles API operation for AWS IoT Wireless.
//
// Lists the device profiles registered to your AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation ListDeviceProfiles for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * AccessDeniedException
//   User does not have permission to perform this action.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDeviceProfiles
func (c *IoTWireless) ListDeviceProfiles(input *ListDeviceProfilesInput) (*ListDeviceProfilesOutput, error) {
	req, out := c.ListDeviceProfilesRequest(input)
	return out, req.Send()
}

// ListDeviceProfilesWithContext is the same as ListDeviceProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See ListDeviceProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) ListDeviceProfilesWithContext(ctx aws.Context, input *ListDeviceProfilesInput, opts ...request.Option) (*ListDeviceProfilesOutput, error) {
	req, out := c.ListDeviceProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDeviceProfilesPages iterates over the pages of a ListDeviceProfiles operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDeviceProfiles method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDeviceProfiles operation.
//    pageNum := 0
//    err := client.ListDeviceProfilesPages(params,
//        func(page *iotwireless.ListDeviceProfilesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTWireless) ListDeviceProfilesPages(input *ListDeviceProfilesInput, fn func(*ListDeviceProfilesOutput, bool) bool) error {
	return c.ListDeviceProfilesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDeviceProfilesPagesWithContext same as ListDeviceProfilesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) ListDeviceProfilesPagesWithContext(ctx aws.Context, input *ListDeviceProfilesInput, fn func(*ListDeviceProfilesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDeviceProfilesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDeviceProfilesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDeviceProfilesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPartnerAccounts = "ListPartnerAccounts"

// ListPartnerAccountsRequest generates a "aws/request.Request" representing the
// client's request for the ListPartnerAccounts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPartnerAccounts for more information on using the ListPartnerAccounts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPartnerAccountsRequest method.
//    req, resp := client.ListPartnerAccountsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListPartnerAccounts
func (c *IoTWireless) ListPartnerAccountsRequest(input *ListPartnerAccountsInput) (req *request.Request, output *ListPartnerAccountsOutput) {
	op := &request.Operation{
		Name:       opListPartnerAccounts,
		HTTPMethod: "GET",
		HTTPPath:   "/partner-accounts",
	}

	if input == nil {
		input = &ListPartnerAccountsInput{}
	}

	output = &ListPartnerAccountsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPartnerAccounts API operation for AWS IoT Wireless.
//
// Lists the partner accounts associated with your AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation ListPartnerAccounts for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * ResourceNotFoundException
//   Resource does not exist.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListPartnerAccounts
func (c *IoTWireless) ListPartnerAccounts(input *ListPartnerAccountsInput) (*ListPartnerAccountsOutput, error) {
	req, out := c.ListPartnerAccountsRequest(input)
	return out, req.Send()
}

// ListPartnerAccountsWithContext is the same as ListPartnerAccounts with the addition of
// the ability to pass a context and additional request options.
//
// See ListPartnerAccounts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) ListPartnerAccountsWithContext(ctx aws.Context, input *ListPartnerAccountsInput, opts ...request.Option) (*ListPartnerAccountsOutput, error) {
	req, out := c.ListPartnerAccountsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListServiceProfiles = "ListServiceProfiles"

// ListServiceProfilesRequest generates a "aws/request.Request" representing the
// client's request for the ListServiceProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListServiceProfiles for more information on using the ListServiceProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListServiceProfilesRequest method.
//    req, resp := client.ListServiceProfilesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListServiceProfiles
func (c *IoTWireless) ListServiceProfilesRequest(input *ListServiceProfilesInput) (req *request.Request, output *ListServiceProfilesOutput) {
	op := &request.Operation{
		Name:       opListServiceProfiles,
		HTTPMethod: "GET",
		HTTPPath:   "/service-profiles",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListServiceProfilesInput{}
	}

	output = &ListServiceProfilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListServiceProfiles API operation for AWS IoT Wireless.
//
// Lists the service profiles registered to your AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation ListServiceProfiles for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * AccessDeniedException
//   User does not have permission to perform this action.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListServiceProfiles
func (c *IoTWireless) ListServiceProfiles(input *ListServiceProfilesInput) (*ListServiceProfilesOutput, error) {
	req, out := c.ListServiceProfilesRequest(input)
	return out, req.Send()
}

// ListServiceProfilesWithContext is the same as ListServiceProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See ListServiceProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) ListServiceProfilesWithContext(ctx aws.Context, input *ListServiceProfilesInput, opts ...request.Option) (*ListServiceProfilesOutput, error) {
	req, out := c.ListServiceProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListServiceProfilesPages iterates over the pages of a ListServiceProfiles operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListServiceProfiles method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListServiceProfiles operation.
//    pageNum := 0
//    err := client.ListServiceProfilesPages(params,
//        func(page *iotwireless.ListServiceProfilesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTWireless) ListServiceProfilesPages(input *ListServiceProfilesInput, fn func(*ListServiceProfilesOutput, bool) bool) error {
	return c.ListServiceProfilesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListServiceProfilesPagesWithContext same as ListServiceProfilesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) ListServiceProfilesPagesWithContext(ctx aws.Context, input *ListServiceProfilesInput, fn func(*ListServiceProfilesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListServiceProfilesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListServiceProfilesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListServiceProfilesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListTagsForResource
func (c *IoTWireless) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS IoT Wireless.
//
// Lists the tags (metadata) you have assigned to the resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * ResourceNotFoundException
//   Resource does not exist.
//
//   * ConflictException
//   Adding, updating, or deleting the resource can cause an inconsistent state.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListTagsForResource
func (c *IoTWireless) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListWirelessDevices = "ListWirelessDevices"

// ListWirelessDevicesRequest generates a "aws/request.Request" representing the
// client's request for the ListWirelessDevices operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListWirelessDevices for more information on using the ListWirelessDevices
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListWirelessDevicesRequest method.
//    req, resp := client.ListWirelessDevicesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessDevices
func (c *IoTWireless) ListWirelessDevicesRequest(input *ListWirelessDevicesInput) (req *request.Request, output *ListWirelessDevicesOutput) {
	op := &request.Operation{
		Name:       opListWirelessDevices,
		HTTPMethod: "GET",
		HTTPPath:   "/wireless-devices",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListWirelessDevicesInput{}
	}

	output = &ListWirelessDevicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListWirelessDevices API operation for AWS IoT Wireless.
//
// Lists the wireless devices registered to your AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation ListWirelessDevices for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
//   * AccessDeniedException
//   User does not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessDevices
func (c *IoTWireless) ListWirelessDevices(input *ListWirelessDevicesInput) (*ListWirelessDevicesOutput, error) {
	req, out := c.ListWirelessDevicesRequest(input)
	return out, req.Send()
}

// ListWirelessDevicesWithContext is the same as ListWirelessDevices with the addition of
// the ability to pass a context and additional request options.
//
// See ListWirelessDevices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) ListWirelessDevicesWithContext(ctx aws.Context, input *ListWirelessDevicesInput, opts ...request.Option) (*ListWirelessDevicesOutput, error) {
	req, out := c.ListWirelessDevicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListWirelessDevicesPages iterates over the pages of a ListWirelessDevices operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListWirelessDevices method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListWirelessDevices operation.
//    pageNum := 0
//    err := client.ListWirelessDevicesPages(params,
//        func(page *iotwireless.ListWirelessDevicesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTWireless) ListWirelessDevicesPages(input *ListWirelessDevicesInput, fn func(*ListWirelessDevicesOutput, bool) bool) error {
	return c.ListWirelessDevicesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListWirelessDevicesPagesWithContext same as ListWirelessDevicesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) ListWirelessDevicesPagesWithContext(ctx aws.Context, input *ListWirelessDevicesInput, fn func(*ListWirelessDevicesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListWirelessDevicesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListWirelessDevicesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListWirelessDevicesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListWirelessGatewayTaskDefinitions = "ListWirelessGatewayTaskDefinitions"

// ListWirelessGatewayTaskDefinitionsRequest generates a "aws/request.Request" representing the
// client's request for the ListWirelessGatewayTaskDefinitions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListWirelessGatewayTaskDefinitions for more information on using the ListWirelessGatewayTaskDefinitions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListWirelessGatewayTaskDefinitionsRequest method.
//    req, resp := client.ListWirelessGatewayTaskDefinitionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessGatewayTaskDefinitions
func (c *IoTWireless) ListWirelessGatewayTaskDefinitionsRequest(input *ListWirelessGatewayTaskDefinitionsInput) (req *request.Request, output *ListWirelessGatewayTaskDefinitionsOutput) {
	op := &request.Operation{
		Name:       opListWirelessGatewayTaskDefinitions,
		HTTPMethod: "GET",
		HTTPPath:   "/wireless-gateway-task-definitions",
	}

	if input == nil {
		input = &ListWirelessGatewayTaskDefinitionsInput{}
	}

	output = &ListWirelessGatewayTaskDefinitionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListWirelessGatewayTaskDefinitions API operation for AWS IoT Wireless.
//
// List the wireless gateway tasks definitions registered to your AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation ListWirelessGatewayTaskDefinitions for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * AccessDeniedException
//   User does not have permission to perform this action.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessGatewayTaskDefinitions
func (c *IoTWireless) ListWirelessGatewayTaskDefinitions(input *ListWirelessGatewayTaskDefinitionsInput) (*ListWirelessGatewayTaskDefinitionsOutput, error) {
	req, out := c.ListWirelessGatewayTaskDefinitionsRequest(input)
	return out, req.Send()
}

// ListWirelessGatewayTaskDefinitionsWithContext is the same as ListWirelessGatewayTaskDefinitions with the addition of
// the ability to pass a context and additional request options.
//
// See ListWirelessGatewayTaskDefinitions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) ListWirelessGatewayTaskDefinitionsWithContext(ctx aws.Context, input *ListWirelessGatewayTaskDefinitionsInput, opts ...request.Option) (*ListWirelessGatewayTaskDefinitionsOutput, error) {
	req, out := c.ListWirelessGatewayTaskDefinitionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListWirelessGateways = "ListWirelessGateways"

// ListWirelessGatewaysRequest generates a "aws/request.Request" representing the
// client's request for the ListWirelessGateways operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListWirelessGateways for more information on using the ListWirelessGateways
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListWirelessGatewaysRequest method.
//    req, resp := client.ListWirelessGatewaysRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessGateways
func (c *IoTWireless) ListWirelessGatewaysRequest(input *ListWirelessGatewaysInput) (req *request.Request, output *ListWirelessGatewaysOutput) {
	op := &request.Operation{
		Name:       opListWirelessGateways,
		HTTPMethod: "GET",
		HTTPPath:   "/wireless-gateways",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListWirelessGatewaysInput{}
	}

	output = &ListWirelessGatewaysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListWirelessGateways API operation for AWS IoT Wireless.
//
// Lists the wireless gateways registered to your AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation ListWirelessGateways for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
//   * AccessDeniedException
//   User does not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessGateways
func (c *IoTWireless) ListWirelessGateways(input *ListWirelessGatewaysInput) (*ListWirelessGatewaysOutput, error) {
	req, out := c.ListWirelessGatewaysRequest(input)
	return out, req.Send()
}

// ListWirelessGatewaysWithContext is the same as ListWirelessGateways with the addition of
// the ability to pass a context and additional request options.
//
// See ListWirelessGateways for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) ListWirelessGatewaysWithContext(ctx aws.Context, input *ListWirelessGatewaysInput, opts ...request.Option) (*ListWirelessGatewaysOutput, error) {
	req, out := c.ListWirelessGatewaysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListWirelessGatewaysPages iterates over the pages of a ListWirelessGateways operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListWirelessGateways method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListWirelessGateways operation.
//    pageNum := 0
//    err := client.ListWirelessGatewaysPages(params,
//        func(page *iotwireless.ListWirelessGatewaysOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTWireless) ListWirelessGatewaysPages(input *ListWirelessGatewaysInput, fn func(*ListWirelessGatewaysOutput, bool) bool) error {
	return c.ListWirelessGatewaysPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListWirelessGatewaysPagesWithContext same as ListWirelessGatewaysPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) ListWirelessGatewaysPagesWithContext(ctx aws.Context, input *ListWirelessGatewaysInput, fn func(*ListWirelessGatewaysOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListWirelessGatewaysInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListWirelessGatewaysRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListWirelessGatewaysOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSendDataToWirelessDevice = "SendDataToWirelessDevice"

// SendDataToWirelessDeviceRequest generates a "aws/request.Request" representing the
// client's request for the SendDataToWirelessDevice operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendDataToWirelessDevice for more information on using the SendDataToWirelessDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SendDataToWirelessDeviceRequest method.
//    req, resp := client.SendDataToWirelessDeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/SendDataToWirelessDevice
func (c *IoTWireless) SendDataToWirelessDeviceRequest(input *SendDataToWirelessDeviceInput) (req *request.Request, output *SendDataToWirelessDeviceOutput) {
	op := &request.Operation{
		Name:       opSendDataToWirelessDevice,
		HTTPMethod: "POST",
		HTTPPath:   "/wireless-devices/{Id}/data",
	}

	if input == nil {
		input = &SendDataToWirelessDeviceInput{}
	}

	output = &SendDataToWirelessDeviceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SendDataToWirelessDevice API operation for AWS IoT Wireless.
//
// Sends a decrypted application data frame to a device.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation SendDataToWirelessDevice for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * ResourceNotFoundException
//   Resource does not exist.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/SendDataToWirelessDevice
func (c *IoTWireless) SendDataToWirelessDevice(input *SendDataToWirelessDeviceInput) (*SendDataToWirelessDeviceOutput, error) {
	req, out := c.SendDataToWirelessDeviceRequest(input)
	return out, req.Send()
}

// SendDataToWirelessDeviceWithContext is the same as SendDataToWirelessDevice with the addition of
// the ability to pass a context and additional request options.
//
// See SendDataToWirelessDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) SendDataToWirelessDeviceWithContext(ctx aws.Context, input *SendDataToWirelessDeviceInput, opts ...request.Option) (*SendDataToWirelessDeviceOutput, error) {
	req, out := c.SendDataToWirelessDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/TagResource
func (c *IoTWireless) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS IoT Wireless.
//
// Adds a tag to a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * ResourceNotFoundException
//   Resource does not exist.
//
//   * ConflictException
//   Adding, updating, or deleting the resource can cause an inconsistent state.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
//   * TooManyTagsException
//   The request was denied because the resource can't have any more tags.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/TagResource
func (c *IoTWireless) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTestWirelessDevice = "TestWirelessDevice"

// TestWirelessDeviceRequest generates a "aws/request.Request" representing the
// client's request for the TestWirelessDevice operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TestWirelessDevice for more information on using the TestWirelessDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TestWirelessDeviceRequest method.
//    req, resp := client.TestWirelessDeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/TestWirelessDevice
func (c *IoTWireless) TestWirelessDeviceRequest(input *TestWirelessDeviceInput) (req *request.Request, output *TestWirelessDeviceOutput) {
	op := &request.Operation{
		Name:       opTestWirelessDevice,
		HTTPMethod: "POST",
		HTTPPath:   "/wireless-devices/{Id}/test",
	}

	if input == nil {
		input = &TestWirelessDeviceInput{}
	}

	output = &TestWirelessDeviceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TestWirelessDevice API operation for AWS IoT Wireless.
//
// Simulates a provisioned device by sending an uplink data payload of Hello.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation TestWirelessDevice for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * ResourceNotFoundException
//   Resource does not exist.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/TestWirelessDevice
func (c *IoTWireless) TestWirelessDevice(input *TestWirelessDeviceInput) (*TestWirelessDeviceOutput, error) {
	req, out := c.TestWirelessDeviceRequest(input)
	return out, req.Send()
}

// TestWirelessDeviceWithContext is the same as TestWirelessDevice with the addition of
// the ability to pass a context and additional request options.
//
// See TestWirelessDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) TestWirelessDeviceWithContext(ctx aws.Context, input *TestWirelessDeviceInput, opts ...request.Option) (*TestWirelessDeviceOutput, error) {
	req, out := c.TestWirelessDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UntagResource
func (c *IoTWireless) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS IoT Wireless.
//
// Removes one or more tags from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * ResourceNotFoundException
//   Resource does not exist.
//
//   * ConflictException
//   Adding, updating, or deleting the resource can cause an inconsistent state.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UntagResource
func (c *IoTWireless) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDestination = "UpdateDestination"

// UpdateDestinationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDestination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDestination for more information on using the UpdateDestination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDestinationRequest method.
//    req, resp := client.UpdateDestinationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateDestination
func (c *IoTWireless) UpdateDestinationRequest(input *UpdateDestinationInput) (req *request.Request, output *UpdateDestinationOutput) {
	op := &request.Operation{
		Name:       opUpdateDestination,
		HTTPMethod: "PATCH",
		HTTPPath:   "/destinations/{Name}",
	}

	if input == nil {
		input = &UpdateDestinationInput{}
	}

	output = &UpdateDestinationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateDestination API operation for AWS IoT Wireless.
//
// Updates properties of a destination.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation UpdateDestination for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * ResourceNotFoundException
//   Resource does not exist.
//
//   * AccessDeniedException
//   User does not have permission to perform this action.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateDestination
func (c *IoTWireless) UpdateDestination(input *UpdateDestinationInput) (*UpdateDestinationOutput, error) {
	req, out := c.UpdateDestinationRequest(input)
	return out, req.Send()
}

// UpdateDestinationWithContext is the same as UpdateDestination with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) UpdateDestinationWithContext(ctx aws.Context, input *UpdateDestinationInput, opts ...request.Option) (*UpdateDestinationOutput, error) {
	req, out := c.UpdateDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePartnerAccount = "UpdatePartnerAccount"

// UpdatePartnerAccountRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePartnerAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePartnerAccount for more information on using the UpdatePartnerAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdatePartnerAccountRequest method.
//    req, resp := client.UpdatePartnerAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdatePartnerAccount
func (c *IoTWireless) UpdatePartnerAccountRequest(input *UpdatePartnerAccountInput) (req *request.Request, output *UpdatePartnerAccountOutput) {
	op := &request.Operation{
		Name:       opUpdatePartnerAccount,
		HTTPMethod: "PATCH",
		HTTPPath:   "/partner-accounts/{PartnerAccountId}",
	}

	if input == nil {
		input = &UpdatePartnerAccountInput{}
	}

	output = &UpdatePartnerAccountOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdatePartnerAccount API operation for AWS IoT Wireless.
//
// Updates properties of a partner account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation UpdatePartnerAccount for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * ResourceNotFoundException
//   Resource does not exist.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdatePartnerAccount
func (c *IoTWireless) UpdatePartnerAccount(input *UpdatePartnerAccountInput) (*UpdatePartnerAccountOutput, error) {
	req, out := c.UpdatePartnerAccountRequest(input)
	return out, req.Send()
}

// UpdatePartnerAccountWithContext is the same as UpdatePartnerAccount with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePartnerAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) UpdatePartnerAccountWithContext(ctx aws.Context, input *UpdatePartnerAccountInput, opts ...request.Option) (*UpdatePartnerAccountOutput, error) {
	req, out := c.UpdatePartnerAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateWirelessDevice = "UpdateWirelessDevice"

// UpdateWirelessDeviceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateWirelessDevice operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateWirelessDevice for more information on using the UpdateWirelessDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateWirelessDeviceRequest method.
//    req, resp := client.UpdateWirelessDeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateWirelessDevice
func (c *IoTWireless) UpdateWirelessDeviceRequest(input *UpdateWirelessDeviceInput) (req *request.Request, output *UpdateWirelessDeviceOutput) {
	op := &request.Operation{
		Name:       opUpdateWirelessDevice,
		HTTPMethod: "PATCH",
		HTTPPath:   "/wireless-devices/{Id}",
	}

	if input == nil {
		input = &UpdateWirelessDeviceInput{}
	}

	output = &UpdateWirelessDeviceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateWirelessDevice API operation for AWS IoT Wireless.
//
// Updates properties of a wireless device.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation UpdateWirelessDevice for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * ResourceNotFoundException
//   Resource does not exist.
//
//   * AccessDeniedException
//   User does not have permission to perform this action.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateWirelessDevice
func (c *IoTWireless) UpdateWirelessDevice(input *UpdateWirelessDeviceInput) (*UpdateWirelessDeviceOutput, error) {
	req, out := c.UpdateWirelessDeviceRequest(input)
	return out, req.Send()
}

// UpdateWirelessDeviceWithContext is the same as UpdateWirelessDevice with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateWirelessDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) UpdateWirelessDeviceWithContext(ctx aws.Context, input *UpdateWirelessDeviceInput, opts ...request.Option) (*UpdateWirelessDeviceOutput, error) {
	req, out := c.UpdateWirelessDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateWirelessGateway = "UpdateWirelessGateway"

// UpdateWirelessGatewayRequest generates a "aws/request.Request" representing the
// client's request for the UpdateWirelessGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateWirelessGateway for more information on using the UpdateWirelessGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateWirelessGatewayRequest method.
//    req, resp := client.UpdateWirelessGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateWirelessGateway
func (c *IoTWireless) UpdateWirelessGatewayRequest(input *UpdateWirelessGatewayInput) (req *request.Request, output *UpdateWirelessGatewayOutput) {
	op := &request.Operation{
		Name:       opUpdateWirelessGateway,
		HTTPMethod: "PATCH",
		HTTPPath:   "/wireless-gateways/{Id}",
	}

	if input == nil {
		input = &UpdateWirelessGatewayInput{}
	}

	output = &UpdateWirelessGatewayOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateWirelessGateway API operation for AWS IoT Wireless.
//
// Updates properties of a wireless gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Wireless's
// API operation UpdateWirelessGateway for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input did not meet the specified constraints.
//
//   * ResourceNotFoundException
//   Resource does not exist.
//
//   * AccessDeniedException
//   User does not have permission to perform this action.
//
//   * InternalServerException
//   An unexpected error occurred while processing a request.
//
//   * ThrottlingException
//   The request was denied because it exceeded the allowed API request rate.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateWirelessGateway
func (c *IoTWireless) UpdateWirelessGateway(input *UpdateWirelessGatewayInput) (*UpdateWirelessGatewayOutput, error) {
	req, out := c.UpdateWirelessGatewayRequest(input)
	return out, req.Send()
}

// UpdateWirelessGatewayWithContext is the same as UpdateWirelessGateway with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateWirelessGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTWireless) UpdateWirelessGatewayWithContext(ctx aws.Context, input *UpdateWirelessGatewayInput, opts ...request.Option) (*UpdateWirelessGatewayOutput, error) {
	req, out := c.UpdateWirelessGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ABP device object for LoRaWAN specification v1.0.x
type AbpV10X struct {
	_ struct{} `type:"structure"`

	// The DevAddr value.
	DevAddr *string `type:"string"`

	// Session keys for ABP v1.0.x
	SessionKeys *SessionKeysAbpV10X `type:"structure"`
}

// String returns the string representation
func (s AbpV10X) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AbpV10X) GoString() string {
	return s.String()
}

// SetDevAddr sets the DevAddr field's value.
func (s *AbpV10X) SetDevAddr(v string) *AbpV10X {
	s.DevAddr = &v
	return s
}

// SetSessionKeys sets the SessionKeys field's value.
func (s *AbpV10X) SetSessionKeys(v *SessionKeysAbpV10X) *AbpV10X {
	s.SessionKeys = v
	return s
}

// ABP device object for LoRaWAN specification v1.1
type AbpV11 struct {
	_ struct{} `type:"structure"`

	// The DevAddr value.
	DevAddr *string `type:"string"`

	// Session keys for ABP v1.1
	SessionKeys *SessionKeysAbpV11 `type:"structure"`
}

// String returns the string representation
func (s AbpV11) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AbpV11) GoString() string {
	return s.String()
}

// SetDevAddr sets the DevAddr field's value.
func (s *AbpV11) SetDevAddr(v string) *AbpV11 {
	s.DevAddr = &v
	return s
}

// SetSessionKeys sets the SessionKeys field's value.
func (s *AbpV11) SetSessionKeys(v *SessionKeysAbpV11) *AbpV11 {
	s.SessionKeys = v
	return s
}

// User does not have permission to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type AssociateAwsAccountWithPartnerAccountInput struct {
	_ struct{} `type:"structure"`

	// Each resource must have a unique client request token. If you try to create
	// a new resource with the same token as a resource that already exists, an
	// exception occurs. If you omit this value, AWS SDKs will automatically generate
	// a unique client request.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Sidewalk account credentials.
	//
	// Sidewalk is a required field
	Sidewalk *SidewalkAccountInfo `type:"structure" required:"true"`

	// The tags to attach to the specified resource. Tags are metadata that you
	// can use to manage a resource.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s AssociateAwsAccountWithPartnerAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateAwsAccountWithPartnerAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateAwsAccountWithPartnerAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateAwsAccountWithPartnerAccountInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.Sidewalk == nil {
		invalidParams.Add(request.NewErrParamRequired("Sidewalk"))
	}
	if s.Sidewalk != nil {
		if err := s.Sidewalk.Validate(); err != nil {
			invalidParams.AddNested("Sidewalk", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *AssociateAwsAccountWithPartnerAccountInput) SetClientRequestToken(v string) *AssociateAwsAccountWithPartnerAccountInput {
	s.ClientRequestToken = &v
	return s
}

// SetSidewalk sets the Sidewalk field's value.
func (s *AssociateAwsAccountWithPartnerAccountInput) SetSidewalk(v *SidewalkAccountInfo) *AssociateAwsAccountWithPartnerAccountInput {
	s.Sidewalk = v
	return s
}

// SetTags sets the Tags field's value.
func (s *AssociateAwsAccountWithPartnerAccountInput) SetTags(v []*Tag) *AssociateAwsAccountWithPartnerAccountInput {
	s.Tags = v
	return s
}

type AssociateAwsAccountWithPartnerAccountOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name of the resource.
	Arn *string `type:"string"`

	// The Sidewalk account credentials.
	Sidewalk *SidewalkAccountInfo `type:"structure"`
}

// String returns the string representation
func (s AssociateAwsAccountWithPartnerAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateAwsAccountWithPartnerAccountOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AssociateAwsAccountWithPartnerAccountOutput) SetArn(v string) *AssociateAwsAccountWithPartnerAccountOutput {
	s.Arn = &v
	return s
}

// SetSidewalk sets the Sidewalk field's value.
func (s *AssociateAwsAccountWithPartnerAccountOutput) SetSidewalk(v *SidewalkAccountInfo) *AssociateAwsAccountWithPartnerAccountOutput {
	s.Sidewalk = v
	return s
}

type AssociateWirelessDeviceWithThingInput struct {
	_ struct{} `type:"structure"`

	// The ID of the resource to update.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The ARN of the thing to associate with the wireless device.
	//
	// ThingArn is a required field
	ThingArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateWirelessDeviceWithThingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateWirelessDeviceWithThingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateWirelessDeviceWithThingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateWirelessDeviceWithThingInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.ThingArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *AssociateWirelessDeviceWithThingInput) SetId(v string) *AssociateWirelessDeviceWithThingInput {
	s.Id = &v
	return s
}

// SetThingArn sets the ThingArn field's value.
func (s *AssociateWirelessDeviceWithThingInput) SetThingArn(v string) *AssociateWirelessDeviceWithThingInput {
	s.ThingArn = &v
	return s
}

type AssociateWirelessDeviceWithThingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateWirelessDeviceWithThingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateWirelessDeviceWithThingOutput) GoString() string {
	return s.String()
}

type AssociateWirelessGatewayWithCertificateInput struct {
	_ struct{} `type:"structure"`

	// The ID of the resource to update.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The ID of the certificate to associate with the wireless gateway.
	//
	// IotCertificateId is a required field
	IotCertificateId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateWirelessGatewayWithCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateWirelessGatewayWithCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateWirelessGatewayWithCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateWirelessGatewayWithCertificateInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.IotCertificateId == nil {
		invalidParams.Add(request.NewErrParamRequired("IotCertificateId"))
	}
	if s.IotCertificateId != nil && len(*s.IotCertificateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IotCertificateId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *AssociateWirelessGatewayWithCertificateInput) SetId(v string) *AssociateWirelessGatewayWithCertificateInput {
	s.Id = &v
	return s
}

// SetIotCertificateId sets the IotCertificateId field's value.
func (s *AssociateWirelessGatewayWithCertificateInput) SetIotCertificateId(v string) *AssociateWirelessGatewayWithCertificateInput {
	s.IotCertificateId = &v
	return s
}

type AssociateWirelessGatewayWithCertificateOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the certificate associated with the wireless gateway.
	IotCertificateId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AssociateWirelessGatewayWithCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateWirelessGatewayWithCertificateOutput) GoString() string {
	return s.String()
}

// SetIotCertificateId sets the IotCertificateId field's value.
func (s *AssociateWirelessGatewayWithCertificateOutput) SetIotCertificateId(v string) *AssociateWirelessGatewayWithCertificateOutput {
	s.IotCertificateId = &v
	return s
}

type AssociateWirelessGatewayWithThingInput struct {
	_ struct{} `type:"structure"`

	// The ID of the resource to update.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The ARN of the thing to associate with the wireless gateway.
	//
	// ThingArn is a required field
	ThingArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateWirelessGatewayWithThingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateWirelessGatewayWithThingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateWirelessGatewayWithThingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateWirelessGatewayWithThingInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.ThingArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *AssociateWirelessGatewayWithThingInput) SetId(v string) *AssociateWirelessGatewayWithThingInput {
	s.Id = &v
	return s
}

// SetThingArn sets the ThingArn field's value.
func (s *AssociateWirelessGatewayWithThingInput) SetThingArn(v string) *AssociateWirelessGatewayWithThingInput {
	s.ThingArn = &v
	return s
}

type AssociateWirelessGatewayWithThingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateWirelessGatewayWithThingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateWirelessGatewayWithThingOutput) GoString() string {
	return s.String()
}

// List of sidewalk certificates.
type CertificateList struct {
	_ struct{} `type:"structure"`

	// The certificate chain algorithm provided by sidewalk.
	//
	// SigningAlg is a required field
	SigningAlg *string `type:"string" required:"true" enum:"SigningAlg"`

	// The value of the chosen sidewalk certificate.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CertificateList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CertificateList) GoString() string {
	return s.String()
}

// SetSigningAlg sets the SigningAlg field's value.
func (s *CertificateList) SetSigningAlg(v string) *CertificateList {
	s.SigningAlg = &v
	return s
}

// SetValue sets the Value field's value.
func (s *CertificateList) SetValue(v string) *CertificateList {
	s.Value = &v
	return s
}

// Adding, updating, or deleting the resource can cause an inconsistent state.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// Id of the resource in the conflicting operation.
	ResourceId *string `type:"string"`

	// Type of the resource in the conflicting operation.
	ResourceType *string `type:"string"`
}

// String returns the string representation
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateDestinationInput struct {
	_ struct{} `type:"structure"`

	// Each resource must have a unique client request token. If you try to create
	// a new resource with the same token as a resource that already exists, an
	// exception occurs. If you omit this value, AWS SDKs will automatically generate
	// a unique client request.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The description of the new resource.
	Description *string `type:"string"`

	// The rule name or topic rule to send messages to.
	//
	// Expression is a required field
	Expression *string `type:"string" required:"true"`

	// The type of value in Expression.
	//
	// ExpressionType is a required field
	ExpressionType *string `type:"string" required:"true" enum:"ExpressionType"`

	// The name of the new resource.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The ARN of the IAM Role that authorizes the destination.
	//
	// RoleArn is a required field
	RoleArn *string `min:"20" type:"string" required:"true"`

	// The tags to attach to the new destination. Tags are metadata that you can
	// use to manage a resource.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDestinationInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.Expression == nil {
		invalidParams.Add(request.NewErrParamRequired("Expression"))
	}
	if s.ExpressionType == nil {
		invalidParams.Add(request.NewErrParamRequired("ExpressionType"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateDestinationInput) SetClientRequestToken(v string) *CreateDestinationInput {
	s.ClientRequestToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateDestinationInput) SetDescription(v string) *CreateDestinationInput {
	s.Description = &v
	return s
}

// SetExpression sets the Expression field's value.
func (s *CreateDestinationInput) SetExpression(v string) *CreateDestinationInput {
	s.Expression = &v
	return s
}

// SetExpressionType sets the ExpressionType field's value.
func (s *CreateDestinationInput) SetExpressionType(v string) *CreateDestinationInput {
	s.ExpressionType = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDestinationInput) SetName(v string) *CreateDestinationInput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateDestinationInput) SetRoleArn(v string) *CreateDestinationInput {
	s.RoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDestinationInput) SetTags(v []*Tag) *CreateDestinationInput {
	s.Tags = v
	return s
}

type CreateDestinationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name of the new resource.
	Arn *string `type:"string"`

	// The name of the new resource.
	Name *string `type:"string"`
}

// String returns the string representation
func (s CreateDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDestinationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateDestinationOutput) SetArn(v string) *CreateDestinationOutput {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDestinationOutput) SetName(v string) *CreateDestinationOutput {
	s.Name = &v
	return s
}

type CreateDeviceProfileInput struct {
	_ struct{} `type:"structure"`

	// Each resource must have a unique client request token. If you try to create
	// a new resource with the same token as a resource that already exists, an
	// exception occurs. If you omit this value, AWS SDKs will automatically generate
	// a unique client request.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The device profile information to use to create the device profile.
	LoRaWAN *LoRaWANDeviceProfile `type:"structure"`

	// The name of the new resource.
	Name *string `type:"string"`

	// The tags to attach to the new device profile. Tags are metadata that you
	// can use to manage a resource.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateDeviceProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeviceProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDeviceProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDeviceProfileInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.LoRaWAN != nil {
		if err := s.LoRaWAN.Validate(); err != nil {
			invalidParams.AddNested("LoRaWAN", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateDeviceProfileInput) SetClientRequestToken(v string) *CreateDeviceProfileInput {
	s.ClientRequestToken = &v
	return s
}

// SetLoRaWAN sets the LoRaWAN field's value.
func (s *CreateDeviceProfileInput) SetLoRaWAN(v *LoRaWANDeviceProfile) *CreateDeviceProfileInput {
	s.LoRaWAN = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDeviceProfileInput) SetName(v string) *CreateDeviceProfileInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDeviceProfileInput) SetTags(v []*Tag) *CreateDeviceProfileInput {
	s.Tags = v
	return s
}

type CreateDeviceProfileOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name of the new resource.
	Arn *string `type:"string"`

	// The ID of the new device profile.
	Id *string `type:"string"`
}

// String returns the string representation
func (s CreateDeviceProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeviceProfileOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateDeviceProfileOutput) SetArn(v string) *CreateDeviceProfileOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateDeviceProfileOutput) SetId(v string) *CreateDeviceProfileOutput {
	s.Id = &v
	return s
}

type CreateServiceProfileInput struct {
	_ struct{} `type:"structure"`

	// Each resource must have a unique client request token. If you try to create
	// a new resource with the same token as a resource that already exists, an
	// exception occurs. If you omit this value, AWS SDKs will automatically generate
	// a unique client request.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The service profile information to use to create the service profile.
	LoRaWAN *LoRaWANServiceProfile `type:"structure"`

	// The name of the new resource.
	Name *string `type:"string"`

	// The tags to attach to the new service profile. Tags are metadata that you
	// can use to manage a resource.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateServiceProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateServiceProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateServiceProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateServiceProfileInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateServiceProfileInput) SetClientRequestToken(v string) *CreateServiceProfileInput {
	s.ClientRequestToken = &v
	return s
}

// SetLoRaWAN sets the LoRaWAN field's value.
func (s *CreateServiceProfileInput) SetLoRaWAN(v *LoRaWANServiceProfile) *CreateServiceProfileInput {
	s.LoRaWAN = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateServiceProfileInput) SetName(v string) *CreateServiceProfileInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateServiceProfileInput) SetTags(v []*Tag) *CreateServiceProfileInput {
	s.Tags = v
	return s
}

type CreateServiceProfileOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name of the new resource.
	Arn *string `type:"string"`

	// The ID of the new service profile.
	Id *string `type:"string"`
}

// String returns the string representation
func (s CreateServiceProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateServiceProfileOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateServiceProfileOutput) SetArn(v string) *CreateServiceProfileOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateServiceProfileOutput) SetId(v string) *CreateServiceProfileOutput {
	s.Id = &v
	return s
}

type CreateWirelessDeviceInput struct {
	_ struct{} `type:"structure"`

	// Each resource must have a unique client request token. If you try to create
	// a new resource with the same token as a resource that already exists, an
	// exception occurs. If you omit this value, AWS SDKs will automatically generate
	// a unique client request.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The description of the new resource.
	Description *string `type:"string"`

	// The name of the destination to assign to the new wireless device.
	//
	// DestinationName is a required field
	DestinationName *string `type:"string" required:"true"`

	// The device configuration information to use to create the wireless device.
	LoRaWAN *LoRaWANDevice `type:"structure"`

	// The name of the new resource.
	Name *string `type:"string"`

	// The tags to attach to the new wireless device. Tags are metadata that you
	// can use to manage a resource.
	Tags []*Tag `type:"list"`

	// The wireless device type.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"WirelessDeviceType"`
}

// String returns the string representation
func (s CreateWirelessDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateWirelessDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWirelessDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWirelessDeviceInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.DestinationName == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationName"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateWirelessDeviceInput) SetClientRequestToken(v string) *CreateWirelessDeviceInput {
	s.ClientRequestToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateWirelessDeviceInput) SetDescription(v string) *CreateWirelessDeviceInput {
	s.Description = &v
	return s
}

// SetDestinationName sets the DestinationName field's value.
func (s *CreateWirelessDeviceInput) SetDestinationName(v string) *CreateWirelessDeviceInput {
	s.DestinationName = &v
	return s
}

// SetLoRaWAN sets the LoRaWAN field's value.
func (s *CreateWirelessDeviceInput) SetLoRaWAN(v *LoRaWANDevice) *CreateWirelessDeviceInput {
	s.LoRaWAN = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateWirelessDeviceInput) SetName(v string) *CreateWirelessDeviceInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateWirelessDeviceInput) SetTags(v []*Tag) *CreateWirelessDeviceInput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *CreateWirelessDeviceInput) SetType(v string) *CreateWirelessDeviceInput {
	s.Type = &v
	return s
}

type CreateWirelessDeviceOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name of the new resource.
	Arn *string `type:"string"`

	// The ID of the new wireless device.
	Id *string `type:"string"`
}

// String returns the string representation
func (s CreateWirelessDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateWirelessDeviceOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateWirelessDeviceOutput) SetArn(v string) *CreateWirelessDeviceOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateWirelessDeviceOutput) SetId(v string) *CreateWirelessDeviceOutput {
	s.Id = &v
	return s
}

type CreateWirelessGatewayInput struct {
	_ struct{} `type:"structure"`

	// Each resource must have a unique client request token. If you try to create
	// a new resource with the same token as a resource that already exists, an
	// exception occurs. If you omit this value, AWS SDKs will automatically generate
	// a unique client request.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The description of the new resource.
	Description *string `type:"string"`

	// The gateway configuration information to use to create the wireless gateway.
	//
	// LoRaWAN is a required field
	LoRaWAN *LoRaWANGateway `type:"structure" required:"true"`

	// The name of the new resource.
	Name *string `type:"string"`

	// The tags to attach to the new wireless gateway. Tags are metadata that you
	// can use to manage a resource.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateWirelessGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateWirelessGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWirelessGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWirelessGatewayInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.LoRaWAN == nil {
		invalidParams.Add(request.NewErrParamRequired("LoRaWAN"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateWirelessGatewayInput) SetClientRequestToken(v string) *CreateWirelessGatewayInput {
	s.ClientRequestToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateWirelessGatewayInput) SetDescription(v string) *CreateWirelessGatewayInput {
	s.Description = &v
	return s
}

// SetLoRaWAN sets the LoRaWAN field's value.
func (s *CreateWirelessGatewayInput) SetLoRaWAN(v *LoRaWANGateway) *CreateWirelessGatewayInput {
	s.LoRaWAN = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateWirelessGatewayInput) SetName(v string) *CreateWirelessGatewayInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateWirelessGatewayInput) SetTags(v []*Tag) *CreateWirelessGatewayInput {
	s.Tags = v
	return s
}

type CreateWirelessGatewayOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name of the new resource.
	Arn *string `type:"string"`

	// The ID of the new wireless gateway.
	Id *string `type:"string"`
}

// String returns the string representation
func (s CreateWirelessGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateWirelessGatewayOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateWirelessGatewayOutput) SetArn(v string) *CreateWirelessGatewayOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateWirelessGatewayOutput) SetId(v string) *CreateWirelessGatewayOutput {
	s.Id = &v
	return s
}

type CreateWirelessGatewayTaskDefinitionInput struct {
	_ struct{} `type:"structure"`

	// Whether to automatically create tasks using this task definition for all
	// gateways with the specified current version. If false, the task must me created
	// by calling CreateWirelessGatewayTask.
	//
	// AutoCreateTasks is a required field
	AutoCreateTasks *bool `type:"boolean" required:"true"`

	// Each resource must have a unique client request token. If you try to create
	// a new resource with the same token as a resource that already exists, an
	// exception occurs. If you omit this value, AWS SDKs will automatically generate
	// a unique client request.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The name of the new resource.
	Name *string `min:"1" type:"string"`

	// The tags to attach to the specified resource. Tags are metadata that you
	// can use to manage a resource.
	Tags []*Tag `type:"list"`

	// Information about the gateways to update.
	Update *UpdateWirelessGatewayTaskCreate `type:"structure"`
}

// String returns the string representation
func (s CreateWirelessGatewayTaskDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateWirelessGatewayTaskDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWirelessGatewayTaskDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWirelessGatewayTaskDefinitionInput"}
	if s.AutoCreateTasks == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoCreateTasks"))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Update != nil {
		if err := s.Update.Validate(); err != nil {
			invalidParams.AddNested("Update", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoCreateTasks sets the AutoCreateTasks field's value.
func (s *CreateWirelessGatewayTaskDefinitionInput) SetAutoCreateTasks(v bool) *CreateWirelessGatewayTaskDefinitionInput {
	s.AutoCreateTasks = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateWirelessGatewayTaskDefinitionInput) SetClientRequestToken(v string) *CreateWirelessGatewayTaskDefinitionInput {
	s.ClientRequestToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateWirelessGatewayTaskDefinitionInput) SetName(v string) *CreateWirelessGatewayTaskDefinitionInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateWirelessGatewayTaskDefinitionInput) SetTags(v []*Tag) *CreateWirelessGatewayTaskDefinitionInput {
	s.Tags = v
	return s
}

// SetUpdate sets the Update field's value.
func (s *CreateWirelessGatewayTaskDefinitionInput) SetUpdate(v *UpdateWirelessGatewayTaskCreate) *CreateWirelessGatewayTaskDefinitionInput {
	s.Update = v
	return s
}

type CreateWirelessGatewayTaskDefinitionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name of the resource.
	Arn *string `type:"string"`

	// The ID of the new wireless gateway task definition.
	Id *string `type:"string"`
}

// String returns the string representation
func (s CreateWirelessGatewayTaskDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateWirelessGatewayTaskDefinitionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateWirelessGatewayTaskDefinitionOutput) SetArn(v string) *CreateWirelessGatewayTaskDefinitionOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateWirelessGatewayTaskDefinitionOutput) SetId(v string) *CreateWirelessGatewayTaskDefinitionOutput {
	s.Id = &v
	return s
}

type CreateWirelessGatewayTaskInput struct {
	_ struct{} `type:"structure"`

	// The ID of the resource to update.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The ID of the WirelessGatewayTaskDefinition.
	//
	// WirelessGatewayTaskDefinitionId is a required field
	WirelessGatewayTaskDefinitionId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateWirelessGatewayTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateWirelessGatewayTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWirelessGatewayTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWirelessGatewayTaskInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.WirelessGatewayTaskDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("WirelessGatewayTaskDefinitionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *CreateWirelessGatewayTaskInput) SetId(v string) *CreateWirelessGatewayTaskInput {
	s.Id = &v
	return s
}

// SetWirelessGatewayTaskDefinitionId sets the WirelessGatewayTaskDefinitionId field's value.
func (s *CreateWirelessGatewayTaskInput) SetWirelessGatewayTaskDefinitionId(v string) *CreateWirelessGatewayTaskInput {
	s.WirelessGatewayTaskDefinitionId = &v
	return s
}

type CreateWirelessGatewayTaskOutput struct {
	_ struct{} `type:"structure"`

	// The status of the request.
	Status *string `type:"string" enum:"WirelessGatewayTaskStatus"`

	// The ID of the WirelessGatewayTaskDefinition.
	WirelessGatewayTaskDefinitionId *string `type:"string"`
}

// String returns the string representation
func (s CreateWirelessGatewayTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateWirelessGatewayTaskOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *CreateWirelessGatewayTaskOutput) SetStatus(v string) *CreateWirelessGatewayTaskOutput {
	s.Status = &v
	return s
}

// SetWirelessGatewayTaskDefinitionId sets the WirelessGatewayTaskDefinitionId field's value.
func (s *CreateWirelessGatewayTaskOutput) SetWirelessGatewayTaskDefinitionId(v string) *CreateWirelessGatewayTaskOutput {
	s.WirelessGatewayTaskDefinitionId = &v
	return s
}

type DeleteDestinationInput struct {
	_ struct{} `type:"structure"`

	// The name of the resource to delete.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDestinationInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteDestinationInput) SetName(v string) *DeleteDestinationInput {
	s.Name = &v
	return s
}

type DeleteDestinationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDestinationOutput) GoString() string {
	return s.String()
}

type DeleteDeviceProfileInput struct {
	_ struct{} `type:"structure"`

	// The ID of the resource to delete.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDeviceProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDeviceProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDeviceProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDeviceProfileInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteDeviceProfileInput) SetId(v string) *DeleteDeviceProfileInput {
	s.Id = &v
	return s
}

type DeleteDeviceProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDeviceProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDeviceProfileOutput) GoString() string {
	return s.String()
}

type DeleteServiceProfileInput struct {
	_ struct{} `type:"structure"`

	// The ID of the resource to delete.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteServiceProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteServiceProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteServiceProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteServiceProfileInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteServiceProfileInput) SetId(v string) *DeleteServiceProfileInput {
	s.Id = &v
	return s
}

type DeleteServiceProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteServiceProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteServiceProfileOutput) GoString() string {
	return s.String()
}

type DeleteWirelessDeviceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the resource to delete.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteWirelessDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteWirelessDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteWirelessDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteWirelessDeviceInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteWirelessDeviceInput) SetId(v string) *DeleteWirelessDeviceInput {
	s.Id = &v
	return s
}

type DeleteWirelessDeviceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteWirelessDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteWirelessDeviceOutput) GoString() string {
	return s.String()
}

type DeleteWirelessGatewayInput struct {
	_ struct{} `type:"structure"`

	// The ID of the resource to delete.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteWirelessGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteWirelessGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteWirelessGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteWirelessGatewayInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteWirelessGatewayInput) SetId(v string) *DeleteWirelessGatewayInput {
	s.Id = &v
	return s
}

type DeleteWirelessGatewayOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteWirelessGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteWirelessGatewayOutput) GoString() string {
	return s.String()
}

type DeleteWirelessGatewayTaskDefinitionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the resource to delete.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteWirelessGatewayTaskDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteWirelessGatewayTaskDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteWirelessGatewayTaskDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteWirelessGatewayTaskDefinitionInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteWirelessGatewayTaskDefinitionInput) SetId(v string) *DeleteWirelessGatewayTaskDefinitionInput {
	s.Id = &v
	return s
}

type DeleteWirelessGatewayTaskDefinitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteWirelessGatewayTaskDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteWirelessGatewayTaskDefinitionOutput) GoString() string {
	return s.String()
}

type DeleteWirelessGatewayTaskInput struct {
	_ struct{} `type:"structure"`

	// The ID of the resource to delete.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteWirelessGatewayTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteWirelessGatewayTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteWirelessGatewayTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteWirelessGatewayTaskInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteWirelessGatewayTaskInput) SetId(v string) *DeleteWirelessGatewayTaskInput {
	s.Id = &v
	return s
}

type DeleteWirelessGatewayTaskOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteWirelessGatewayTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteWirelessGatewayTaskOutput) GoString() string {
	return s.String()
}

// Describes a destination.
type Destinations struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name of the resource.
	Arn *string `type:"string"`

	// The description of the resource.
	Description *string `type:"string"`

	// The rule name or topic rule to send messages to.
	Expression *string `type:"string"`

	// The type of value in Expression.
	ExpressionType *string `type:"string" enum:"ExpressionType"`

	// The name of the resource.
	Name *string `type:"string"`

	// The ARN of the IAM Role that authorizes the destination.
	RoleArn *string `min:"20" type:"string"`
}

// String returns the string representation
func (s Destinations) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Destinations) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Destinations) SetArn(v string) *Destinations {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Destinations) SetDescription(v string) *Destinations {
	s.Description = &v
	return s
}

// SetExpression sets the Expression field's value.
func (s *Destinations) SetExpression(v string) *Destinations {
	s.Expression = &v
	return s
}

// SetExpressionType sets the ExpressionType field's value.
func (s *Destinations) SetExpressionType(v string) *Destinations {
	s.ExpressionType = &v
	return s
}

// SetName sets the Name field's value.
func (s *Destinations) SetName(v string) *Destinations {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *Destinations) SetRoleArn(v string) *Destinations {
	s.RoleArn = &v
	return s
}

// Describes a device profile.
type DeviceProfile struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name of the resource.
	Arn *string `type:"string"`

	// The ID of the device profile.
	Id *string `type:"string"`

	// The name of the resource.
	Name *string `type:"string"`
}

// String returns the string representation
func (s DeviceProfile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeviceProfile) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DeviceProfile) SetArn(v string) *DeviceProfile {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *DeviceProfile) SetId(v string) *DeviceProfile {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeviceProfile) SetName(v string) *DeviceProfile {
	s.Name = &v
	return s
}

type DisassociateAwsAccountFromPartnerAccountInput struct {
	_ struct{} `type:"structure"`

	// The partner account ID to disassociate from the AWS account.
	//
	// PartnerAccountId is a required field
	PartnerAccountId *string `location:"uri" locationName:"PartnerAccountId" type:"string" required:"true"`

	// The partner type.
	//
	// PartnerType is a required field
	PartnerType *string `location:"querystring" locationName:"partnerType" type:"string" required:"true" enum:"PartnerType"`
}

// String returns the string representation
func (s DisassociateAwsAccountFromPartnerAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateAwsAccountFromPartnerAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateAwsAccountFromPartnerAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateAwsAccountFromPartnerAccountInput"}
	if s.PartnerAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("PartnerAccountId"))
	}
	if s.PartnerAccountId != nil && len(*s.PartnerAccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PartnerAccountId", 1))
	}
	if s.PartnerType == nil {
		invalidParams.Add(request.NewErrParamRequired("PartnerType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPartnerAccountId sets the PartnerAccountId field's value.
func (s *DisassociateAwsAccountFromPartnerAccountInput) SetPartnerAccountId(v string) *DisassociateAwsAccountFromPartnerAccountInput {
	s.PartnerAccountId = &v
	return s
}

// SetPartnerType sets the PartnerType field's value.
func (s *DisassociateAwsAccountFromPartnerAccountInput) SetPartnerType(v string) *DisassociateAwsAccountFromPartnerAccountInput {
	s.PartnerType = &v
	return s
}

type DisassociateAwsAccountFromPartnerAccountOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateAwsAccountFromPartnerAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateAwsAccountFromPartnerAccountOutput) GoString() string {
	return s.String()
}

type DisassociateWirelessDeviceFromThingInput struct {
	_ struct{} `type:"structure"`

	// The ID of the resource to update.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateWirelessDeviceFromThingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateWirelessDeviceFromThingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateWirelessDeviceFromThingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateWirelessDeviceFromThingInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DisassociateWirelessDeviceFromThingInput) SetId(v string) *DisassociateWirelessDeviceFromThingInput {
	s.Id = &v
	return s
}

type DisassociateWirelessDeviceFromThingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateWirelessDeviceFromThingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateWirelessDeviceFromThingOutput) GoString() string {
	return s.String()
}

type DisassociateWirelessGatewayFromCertificateInput struct {
	_ struct{} `type:"structure"`

	// The ID of the resource to update.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateWirelessGatewayFromCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateWirelessGatewayFromCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateWirelessGatewayFromCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateWirelessGatewayFromCertificateInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DisassociateWirelessGatewayFromCertificateInput) SetId(v string) *DisassociateWirelessGatewayFromCertificateInput {
	s.Id = &v
	return s
}

type DisassociateWirelessGatewayFromCertificateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateWirelessGatewayFromCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateWirelessGatewayFromCertificateOutput) GoString() string {
	return s.String()
}

type DisassociateWirelessGatewayFromThingInput struct {
	_ struct{} `type:"structure"`

	// The ID of the resource to update.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateWirelessGatewayFromThingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateWirelessGatewayFromThingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateWirelessGatewayFromThingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateWirelessGatewayFromThingInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DisassociateWirelessGatewayFromThingInput) SetId(v string) *DisassociateWirelessGatewayFromThingInput {
	s.Id = &v
	return s
}

type DisassociateWirelessGatewayFromThingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateWirelessGatewayFromThingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateWirelessGatewayFromThingOutput) GoString() string {
	return s.String()
}

type GetDestinationInput struct {
	_ struct{} `type:"structure"`

	// The name of the resource to get.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDestinationInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetDestinationInput) SetName(v string) *GetDestinationInput {
	s.Name = &v
	return s
}

type GetDestinationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name of the resource.
	Arn *string `type:"string"`

	// The description of the resource.
	Description *string `type:"string"`

	// The rule name or topic rule to send messages to.
	Expression *string `type:"string"`

	// The type of value in Expression.
	ExpressionType *string `type:"string" enum:"ExpressionType"`

	// The name of the resource.
	Name *string `type:"string"`

	// The ARN of the IAM Role that authorizes the destination.
	RoleArn *string `min:"20" type:"string"`
}

// String returns the string representation
func (s GetDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDestinationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetDestinationOutput) SetArn(v string) *GetDestinationOutput {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetDestinationOutput) SetDescription(v string) *GetDestinationOutput {
	s.Description = &v
	return s
}

// SetExpression sets the Expression field's value.
func (s *GetDestinationOutput) SetExpression(v string) *GetDestinationOutput {
	s.Expression = &v
	return s
}

// SetExpressionType sets the ExpressionType field's value.
func (s *GetDestinationOutput) SetExpressionType(v string) *GetDestinationOutput {
	s.ExpressionType = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetDestinationOutput) SetName(v string) *GetDestinationOutput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *GetDestinationOutput) SetRoleArn(v string) *GetDestinationOutput {
	s.RoleArn = &v
	return s
}

type GetDeviceProfileInput struct {
	_ struct{} `type:"structure"`

	// The ID of the resource to get.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDeviceProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeviceProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDeviceProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDeviceProfileInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetDeviceProfileInput) SetId(v string) *GetDeviceProfileInput {
	s.Id = &v
	return s
}

type GetDeviceProfileOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name of the resource.
	Arn *string `type:"string"`

	// The ID of the device profile.
	Id *string `type:"string"`

	// Information about the device profile.
	LoRaWAN *LoRaWANDeviceProfile `type:"structure"`

	// The name of the resource.
	Name *string `type:"string"`
}

// String returns the string representation
func (s GetDeviceProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeviceProfileOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetDeviceProfileOutput) SetArn(v string) *GetDeviceProfileOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetDeviceProfileOutput) SetId(v string) *GetDeviceProfileOutput {
	s.Id = &v
	return s
}

// SetLoRaWAN sets the LoRaWAN field's value.
func (s *GetDeviceProfileOutput) SetLoRaWAN(v *LoRaWANDeviceProfile) *GetDeviceProfileOutput {
	s.LoRaWAN = v
	return s
}

// SetName sets the Name field's value.
func (s *GetDeviceProfileOutput) SetName(v string) *GetDeviceProfileOutput {
	s.Name = &v
	return s
}

type GetPartnerAccountInput struct {
	_ struct{} `type:"structure"`

	// The partner account ID to disassociate from the AWS account.
	//
	// PartnerAccountId is a required field
	PartnerAccountId *string `location:"uri" locationName:"PartnerAccountId" type:"string" required:"true"`

	// The partner type.
	//
	// PartnerType is a required field
	PartnerType *string `location:"querystring" locationName:"partnerType" type:"string" required:"true" enum:"PartnerType"`
}

// String returns the string representation
func (s GetPartnerAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPartnerAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPartnerAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPartnerAccountInput"}
	if s.PartnerAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("PartnerAccountId"))
	}
	if s.PartnerAccountId != nil && len(*s.PartnerAccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PartnerAccountId", 1))
	}
	if s.PartnerType == nil {
		invalidParams.Add(request.NewErrParamRequired("PartnerType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPartnerAccountId sets the PartnerAccountId field's value.
func (s *GetPartnerAccountInput) SetPartnerAccountId(v string) *GetPartnerAccountInput {
	s.PartnerAccountId = &v
	return s
}

// SetPartnerType sets the PartnerType field's value.
func (s *GetPartnerAccountInput) SetPartnerType(v string) *GetPartnerAccountInput {
	s.PartnerType = &v
	return s
}

type GetPartnerAccountOutput struct {
	_ struct{} `type:"structure"`

	// Whether the partner account is linked to the AWS account.
	AccountLinked *bool `type:"boolean"`

	// The Sidewalk account credentials.
	Sidewalk *SidewalkAccountInfoWithFingerprint `type:"structure"`
}

// String returns the string representation
func (s GetPartnerAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPartnerAccountOutput) GoString() string {
	return s.String()
}

// SetAccountLinked sets the AccountLinked field's value.
func (s *GetPartnerAccountOutput) SetAccountLinked(v bool) *GetPartnerAccountOutput {
	s.AccountLinked = &v
	return s
}

// SetSidewalk sets the Sidewalk field's value.
func (s *GetPartnerAccountOutput) SetSidewalk(v *SidewalkAccountInfoWithFingerprint) *GetPartnerAccountOutput {
	s.Sidewalk = v
	return s
}

type GetServiceEndpointInput struct {
	_ struct{} `type:"structure"`

	// The service type for which to get endpoint information about. Can be CUPS
	// for the Configuration and Update Server endpoint, or LNS for the LoRaWAN
	// Network Server endpoint.
	ServiceType *string `location:"querystring" locationName:"serviceType" type:"string" enum:"WirelessGatewayServiceType"`
}

// String returns the string representation
func (s GetServiceEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetServiceEndpointInput) GoString() string {
	return s.String()
}

// SetServiceType sets the ServiceType field's value.
func (s *GetServiceEndpointInput) SetServiceType(v string) *GetServiceEndpointInput {
	s.ServiceType = &v
	return s
}

type GetServiceEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The Root CA of the server trust certificate.
	ServerTrust *string `min:"1" type:"string"`

	// The service endpoint value.
	ServiceEndpoint *string `min:"1" type:"string"`

	// The endpoint's service type.
	ServiceType *string `type:"string" enum:"WirelessGatewayServiceType"`
}

// String returns the string representation
func (s GetServiceEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetServiceEndpointOutput) GoString() string {
	return s.String()
}

// SetServerTrust sets the ServerTrust field's value.
func (s *GetServiceEndpointOutput) SetServerTrust(v string) *GetServiceEndpointOutput {
	s.ServerTrust = &v
	return s
}

// SetServiceEndpoint sets the ServiceEndpoint field's value.
func (s *GetServiceEndpointOutput) SetServiceEndpoint(v string) *GetServiceEndpointOutput {
	s.ServiceEndpoint = &v
	return s
}

// SetServiceType sets the ServiceType field's value.
func (s *GetServiceEndpointOutput) SetServiceType(v string) *GetServiceEndpointOutput {
	s.ServiceType = &v
	return s
}

type GetServiceProfileInput struct {
	_ struct{} `type:"structure"`

	// The ID of the resource to get.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetServiceProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetServiceProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetServiceProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetServiceProfileInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetServiceProfileInput) SetId(v string) *GetServiceProfileInput {
	s.Id = &v
	return s
}

type GetServiceProfileOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name of the resource.
	Arn *string `type:"string"`

	// The ID of the service profile.
	Id *string `type:"string"`

	// Information about the service profile.
	LoRaWAN *LoRaWANGetServiceProfileInfo `type:"structure"`

	// The name of the resource.
	Name *string `type:"string"`
}

// String returns the string representation
func (s GetServiceProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetServiceProfileOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetServiceProfileOutput) SetArn(v string) *GetServiceProfileOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetServiceProfileOutput) SetId(v string) *GetServiceProfileOutput {
	s.Id = &v
	return s
}

// SetLoRaWAN sets the LoRaWAN field's value.
func (s *GetServiceProfileOutput) SetLoRaWAN(v *LoRaWANGetServiceProfileInfo) *GetServiceProfileOutput {
	s.LoRaWAN = v
	return s
}

// SetName sets the Name field's value.
func (s *GetServiceProfileOutput) SetName(v string) *GetServiceProfileOutput {
	s.Name = &v
	return s
}

type GetWirelessDeviceInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the wireless device to get.
	//
	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"Identifier" type:"string" required:"true"`

	// The type of identifier used in identifier.
	//
	// IdentifierType is a required field
	IdentifierType *string `location:"querystring" locationName:"identifierType" type:"string" required:"true" enum:"WirelessDeviceIdType"`
}

// String returns the string representation
func (s GetWirelessDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetWirelessDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetWirelessDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetWirelessDeviceInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}
	if s.IdentifierType == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentifierType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *GetWirelessDeviceInput) SetIdentifier(v string) *GetWirelessDeviceInput {
	s.Identifier = &v
	return s
}

// SetIdentifierType sets the IdentifierType field's value.
func (s *GetWirelessDeviceInput) SetIdentifierType(v string) *GetWirelessDeviceInput {
	s.IdentifierType = &v
	return s
}

type GetWirelessDeviceOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name of the resource.
	Arn *string `type:"string"`

	// The description of the resource.
	Description *string `type:"string"`

	// The name of the destination to which the device is assigned.
	DestinationName *string `type:"string"`

	// The ID of the wireless device.
	Id *string `type:"string"`

	// Information about the wireless device.
	LoRaWAN *LoRaWANDevice `type:"structure"`

	// The name of the resource.
	Name *string `type:"string"`

	// Sidewalk device object.
	Sidewalk *SidewalkDevice `type:"structure"`

	// The ARN of the thing associated with the wireless device.
	ThingArn *string `type:"string"`

	// The name of the thing associated with the wireless device. The value is empty
	// if a thing isn't associated with the device.
	ThingName *string `type:"string"`

	// The wireless device type.
	Type *string `type:"string" enum:"WirelessDeviceType"`
}

// String returns the string representation
func (s GetWirelessDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetWirelessDeviceOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetWirelessDeviceOutput) SetArn(v string) *GetWirelessDeviceOutput {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetWirelessDeviceOutput) SetDescription(v string) *GetWirelessDeviceOutput {
	s.Description = &v
	return s
}

// SetDestinationName sets the DestinationName field's value.
func (s *GetWirelessDeviceOutput) SetDestinationName(v string) *GetWirelessDeviceOutput {
	s.DestinationName = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetWirelessDeviceOutput) SetId(v string) *GetWirelessDeviceOutput {
	s.Id = &v
	return s
}

// SetLoRaWAN sets the LoRaWAN field's value.
func (s *GetWirelessDeviceOutput) SetLoRaWAN(v *LoRaWANDevice) *GetWirelessDeviceOutput {
	s.LoRaWAN = v
	return s
}

// SetName sets the Name field's value.
func (s *GetWirelessDeviceOutput) SetName(v string) *GetWirelessDeviceOutput {
	s.Name = &v
	return s
}

// SetSidewalk sets the Sidewalk field's value.
func (s *GetWirelessDeviceOutput) SetSidewalk(v *SidewalkDevice) *GetWirelessDeviceOutput {
	s.Sidewalk = v
	return s
}

// SetThingArn sets the ThingArn field's value.
func (s *GetWirelessDeviceOutput) SetThingArn(v string) *GetWirelessDeviceOutput {
	s.ThingArn = &v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *GetWirelessDeviceOutput) SetThingName(v string) *GetWirelessDeviceOutput {
	s.ThingName = &v
	return s
}

// SetType sets the Type field's value.
func (s *GetWirelessDeviceOutput) SetType(v string) *GetWirelessDeviceOutput {
	s.Type = &v
	return s
}

type GetWirelessDeviceStatisticsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the wireless device for which to get the data.
	//
	// WirelessDeviceId is a required field
	WirelessDeviceId *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetWirelessDeviceStatisticsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetWirelessDeviceStatisticsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetWirelessDeviceStatisticsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetWirelessDeviceStatisticsInput"}
	if s.WirelessDeviceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WirelessDeviceId"))
	}
	if s.WirelessDeviceId != nil && len(*s.WirelessDeviceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WirelessDeviceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWirelessDeviceId sets the WirelessDeviceId field's value.
func (s *GetWirelessDeviceStatisticsInput) SetWirelessDeviceId(v string) *GetWirelessDeviceStatisticsInput {
	s.WirelessDeviceId = &v
	return s
}

type GetWirelessDeviceStatisticsOutput struct {
	_ struct{} `type:"structure"`

	// The date and time when the most recent uplink was received.
	LastUplinkReceivedAt *string `type:"string"`

	// Information about the wireless device's operations.
	LoRaWAN *LoRaWANDeviceMetadata `type:"structure"`

	// MetaData for Sidewalk device.
	Sidewalk *SidewalkDeviceMetadata `type:"structure"`

	// The ID of the wireless device.
	WirelessDeviceId *string `type:"string"`
}

// String returns the string representation
func (s GetWirelessDeviceStatisticsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetWirelessDeviceStatisticsOutput) GoString() string {
	return s.String()
}

// SetLastUplinkReceivedAt sets the LastUplinkReceivedAt field's value.
func (s *GetWirelessDeviceStatisticsOutput) SetLastUplinkReceivedAt(v string) *GetWirelessDeviceStatisticsOutput {
	s.LastUplinkReceivedAt = &v
	return s
}

// SetLoRaWAN sets the LoRaWAN field's value.
func (s *GetWirelessDeviceStatisticsOutput) SetLoRaWAN(v *LoRaWANDeviceMetadata) *GetWirelessDeviceStatisticsOutput {
	s.LoRaWAN = v
	return s
}

// SetSidewalk sets the Sidewalk field's value.
func (s *GetWirelessDeviceStatisticsOutput) SetSidewalk(v *SidewalkDeviceMetadata) *GetWirelessDeviceStatisticsOutput {
	s.Sidewalk = v
	return s
}

// SetWirelessDeviceId sets the WirelessDeviceId field's value.
func (s *GetWirelessDeviceStatisticsOutput) SetWirelessDeviceId(v string) *GetWirelessDeviceStatisticsOutput {
	s.WirelessDeviceId = &v
	return s
}

type GetWirelessGatewayCertificateInput struct {
	_ struct{} `type:"structure"`

	// The ID of the resource to get.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetWirelessGatewayCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetWirelessGatewayCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetWirelessGatewayCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetWirelessGatewayCertificateInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetWirelessGatewayCertificateInput) SetId(v string) *GetWirelessGatewayCertificateInput {
	s.Id = &v
	return s
}

type GetWirelessGatewayCertificateOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the certificate associated with the wireless gateway.
	IotCertificateId *string `min:"1" type:"string"`

	// The ID of the certificate that is associated with the wireless gateway and
	// used for the LoRaWANNetworkServer endpoint.
	LoRaWANNetworkServerCertificateId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetWirelessGatewayCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetWirelessGatewayCertificateOutput) GoString() string {
	return s.String()
}

// SetIotCertificateId sets the IotCertificateId field's value.
func (s *GetWirelessGatewayCertificateOutput) SetIotCertificateId(v string) *GetWirelessGatewayCertificateOutput {
	s.IotCertificateId = &v
	return s
}

// SetLoRaWANNetworkServerCertificateId sets the LoRaWANNetworkServerCertificateId field's value.
func (s *GetWirelessGatewayCertificateOutput) SetLoRaWANNetworkServerCertificateId(v string) *GetWirelessGatewayCertificateOutput {
	s.LoRaWANNetworkServerCertificateId = &v
	return s
}

type GetWirelessGatewayFirmwareInformationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the resource to get.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetWirelessGatewayFirmwareInformationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetWirelessGatewayFirmwareInformationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetWirelessGatewayFirmwareInformationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetWirelessGatewayFirmwareInformationInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetWirelessGatewayFirmwareInformationInput) SetId(v string) *GetWirelessGatewayFirmwareInformationInput {
	s.Id = &v
	return s
}

type GetWirelessGatewayFirmwareInformationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the wireless gateway's firmware.
	LoRaWAN *LoRaWANGatewayCurrentVersion `type:"structure"`
}

// String returns the string representation
func (s GetWirelessGatewayFirmwareInformationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetWirelessGatewayFirmwareInformationOutput) GoString() string {
	return s.String()
}

// SetLoRaWAN sets the LoRaWAN field's value.
func (s *GetWirelessGatewayFirmwareInformationOutput) SetLoRaWAN(v *LoRaWANGatewayCurrentVersion) *GetWirelessGatewayFirmwareInformationOutput {
	s.LoRaWAN = v
	return s
}

type GetWirelessGatewayInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the wireless gateway to get.
	//
	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"Identifier" type:"string" required:"true"`

	// The type of identifier used in identifier.
	//
	// IdentifierType is a required field
	IdentifierType *string `location:"querystring" locationName:"identifierType" type:"string" required:"true" enum:"WirelessGatewayIdType"`
}

// String returns the string representation
func (s GetWirelessGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetWirelessGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetWirelessGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetWirelessGatewayInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}
	if s.IdentifierType == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentifierType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *GetWirelessGatewayInput) SetIdentifier(v string) *GetWirelessGatewayInput {
	s.Identifier = &v
	return s
}

// SetIdentifierType sets the IdentifierType field's value.
func (s *GetWirelessGatewayInput) SetIdentifierType(v string) *GetWirelessGatewayInput {
	s.IdentifierType = &v
	return s
}

type GetWirelessGatewayOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name of the resource.
	Arn *string `type:"string"`

	// The description of the resource.
	Description *string `type:"string"`

	// The ID of the wireless gateway.
	Id *string `type:"string"`

	// Information about the wireless gateway.
	LoRaWAN *LoRaWANGateway `type:"structure"`

	// The name of the resource.
	Name *string `type:"string"`

	// The ARN of the thing associated with the wireless gateway.
	ThingArn *string `type:"string"`

	// The name of the thing associated with the wireless gateway. The value is
	// empty if a thing isn't associated with the gateway.
	ThingName *string `type:"string"`
}

// String returns the string representation
func (s GetWirelessGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetWirelessGatewayOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetWirelessGatewayOutput) SetArn(v string) *GetWirelessGatewayOutput {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetWirelessGatewayOutput) SetDescription(v string) *GetWirelessGatewayOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetWirelessGatewayOutput) SetId(v string) *GetWirelessGatewayOutput {
	s.Id = &v
	return s
}

// SetLoRaWAN sets the LoRaWAN field's value.
func (s *GetWirelessGatewayOutput) SetLoRaWAN(v *LoRaWANGateway) *GetWirelessGatewayOutput {
	s.LoRaWAN = v
	return s
}

// SetName sets the Name field's value.
func (s *GetWirelessGatewayOutput) SetName(v string) *GetWirelessGatewayOutput {
	s.Name = &v
	return s
}

// SetThingArn sets the ThingArn field's value.
func (s *GetWirelessGatewayOutput) SetThingArn(v string) *GetWirelessGatewayOutput {
	s.ThingArn = &v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *GetWirelessGatewayOutput) SetThingName(v string) *GetWirelessGatewayOutput {
	s.ThingName = &v
	return s
}

type GetWirelessGatewayStatisticsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the wireless gateway for which to get the data.
	//
	// WirelessGatewayId is a required field
	WirelessGatewayId *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetWirelessGatewayStatisticsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetWirelessGatewayStatisticsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetWirelessGatewayStatisticsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetWirelessGatewayStatisticsInput"}
	if s.WirelessGatewayId == nil {
		invalidParams.Add(request.NewErrParamRequired("WirelessGatewayId"))
	}
	if s.WirelessGatewayId != nil && len(*s.WirelessGatewayId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WirelessGatewayId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWirelessGatewayId sets the WirelessGatewayId field's value.
func (s *GetWirelessGatewayStatisticsInput) SetWirelessGatewayId(v string) *GetWirelessGatewayStatisticsInput {
	s.WirelessGatewayId = &v
	return s
}

type GetWirelessGatewayStatisticsOutput struct {
	_ struct{} `type:"structure"`

	// The connection status of the wireless gateway.
	ConnectionStatus *string `type:"string" enum:"ConnectionStatus"`

	// The date and time when the most recent uplink was received.
	LastUplinkReceivedAt *string `type:"string"`

	// The ID of the wireless gateway.
	WirelessGatewayId *string `type:"string"`
}

// String returns the string representation
func (s GetWirelessGatewayStatisticsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetWirelessGatewayStatisticsOutput) GoString() string {
	return s.String()
}

// SetConnectionStatus sets the ConnectionStatus field's value.
func (s *GetWirelessGatewayStatisticsOutput) SetConnectionStatus(v string) *GetWirelessGatewayStatisticsOutput {
	s.ConnectionStatus = &v
	return s
}

// SetLastUplinkReceivedAt sets the LastUplinkReceivedAt field's value.
func (s *GetWirelessGatewayStatisticsOutput) SetLastUplinkReceivedAt(v string) *GetWirelessGatewayStatisticsOutput {
	s.LastUplinkReceivedAt = &v
	return s
}

// SetWirelessGatewayId sets the WirelessGatewayId field's value.
func (s *GetWirelessGatewayStatisticsOutput) SetWirelessGatewayId(v string) *GetWirelessGatewayStatisticsOutput {
	s.WirelessGatewayId = &v
	return s
}

type GetWirelessGatewayTaskDefinitionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the resource to get.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetWirelessGatewayTaskDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetWirelessGatewayTaskDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetWirelessGatewayTaskDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetWirelessGatewayTaskDefinitionInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetWirelessGatewayTaskDefinitionInput) SetId(v string) *GetWirelessGatewayTaskDefinitionInput {
	s.Id = &v
	return s
}

type GetWirelessGatewayTaskDefinitionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name of the resource.
	Arn *string `type:"string"`

	// Whether to automatically create tasks using this task definition for all
	// gateways with the specified current version. If false, the task must me created
	// by calling CreateWirelessGatewayTask.
	AutoCreateTasks *bool `type:"boolean"`

	// The name of the resource.
	Name *string `min:"1" type:"string"`

	// Information about the gateways to update.
	Update *UpdateWirelessGatewayTaskCreate `type:"structure"`
}

// String returns the string representation
func (s GetWirelessGatewayTaskDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetWirelessGatewayTaskDefinitionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetWirelessGatewayTaskDefinitionOutput) SetArn(v string) *GetWirelessGatewayTaskDefinitionOutput {
	s.Arn = &v
	return s
}

// SetAutoCreateTasks sets the AutoCreateTasks field's value.
func (s *GetWirelessGatewayTaskDefinitionOutput) SetAutoCreateTasks(v bool) *GetWirelessGatewayTaskDefinitionOutput {
	s.AutoCreateTasks = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetWirelessGatewayTaskDefinitionOutput) SetName(v string) *GetWirelessGatewayTaskDefinitionOutput {
	s.Name = &v
	return s
}

// SetUpdate sets the Update field's value.
func (s *GetWirelessGatewayTaskDefinitionOutput) SetUpdate(v *UpdateWirelessGatewayTaskCreate) *GetWirelessGatewayTaskDefinitionOutput {
	s.Update = v
	return s
}

type GetWirelessGatewayTaskInput struct {
	_ struct{} `type:"structure"`

	// The ID of the resource to get.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetWirelessGatewayTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetWirelessGatewayTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetWirelessGatewayTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetWirelessGatewayTaskInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetWirelessGatewayTaskInput) SetId(v string) *GetWirelessGatewayTaskInput {
	s.Id = &v
	return s
}

type GetWirelessGatewayTaskOutput struct {
	_ struct{} `type:"structure"`

	// The date and time when the most recent uplink was received.
	LastUplinkReceivedAt *string `type:"string"`

	// The status of the request.
	Status *string `type:"string" enum:"WirelessGatewayTaskStatus"`

	// The date and time when the task was created.
	TaskCreatedAt *string `type:"string"`

	// The ID of the wireless gateway.
	WirelessGatewayId *string `type:"string"`

	// The ID of the WirelessGatewayTask.
	WirelessGatewayTaskDefinitionId *string `type:"string"`
}

// String returns the string representation
func (s GetWirelessGatewayTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetWirelessGatewayTaskOutput) GoString() string {
	return s.String()
}

// SetLastUplinkReceivedAt sets the LastUplinkReceivedAt field's value.
func (s *GetWirelessGatewayTaskOutput) SetLastUplinkReceivedAt(v string) *GetWirelessGatewayTaskOutput {
	s.LastUplinkReceivedAt = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetWirelessGatewayTaskOutput) SetStatus(v string) *GetWirelessGatewayTaskOutput {
	s.Status = &v
	return s
}

// SetTaskCreatedAt sets the TaskCreatedAt field's value.
func (s *GetWirelessGatewayTaskOutput) SetTaskCreatedAt(v string) *GetWirelessGatewayTaskOutput {
	s.TaskCreatedAt = &v
	return s
}

// SetWirelessGatewayId sets the WirelessGatewayId field's value.
func (s *GetWirelessGatewayTaskOutput) SetWirelessGatewayId(v string) *GetWirelessGatewayTaskOutput {
	s.WirelessGatewayId = &v
	return s
}

// SetWirelessGatewayTaskDefinitionId sets the WirelessGatewayTaskDefinitionId field's value.
func (s *GetWirelessGatewayTaskOutput) SetWirelessGatewayTaskDefinitionId(v string) *GetWirelessGatewayTaskOutput {
	s.WirelessGatewayTaskDefinitionId = &v
	return s
}

// An unexpected error occurred while processing a request.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListDestinationsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in this operation.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// To retrieve the next set of results, the nextToken value from a previous
	// response; otherwise null to receive the first set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDestinationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDestinationsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDestinationsInput) SetMaxResults(v int64) *ListDestinationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDestinationsInput) SetNextToken(v string) *ListDestinationsInput {
	s.NextToken = &v
	return s
}

type ListDestinationsOutput struct {
	_ struct{} `type:"structure"`

	// The list of destinations.
	DestinationList []*Destinations `type:"list"`

	// The token to use to get the next set of results, or null if there are no
	// additional results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListDestinationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDestinationsOutput) GoString() string {
	return s.String()
}

// SetDestinationList sets the DestinationList field's value.
func (s *ListDestinationsOutput) SetDestinationList(v []*Destinations) *ListDestinationsOutput {
	s.DestinationList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDestinationsOutput) SetNextToken(v string) *ListDestinationsOutput {
	s.NextToken = &v
	return s
}

type ListDeviceProfilesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in this operation.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// To retrieve the next set of results, the nextToken value from a previous
	// response; otherwise null to receive the first set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDeviceProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeviceProfilesInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDeviceProfilesInput) SetMaxResults(v int64) *ListDeviceProfilesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeviceProfilesInput) SetNextToken(v string) *ListDeviceProfilesInput {
	s.NextToken = &v
	return s
}

type ListDeviceProfilesOutput struct {
	_ struct{} `type:"structure"`

	// The list of device profiles.
	DeviceProfileList []*DeviceProfile `type:"list"`

	// The token to use to get the next set of results, or null if there are no
	// additional results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListDeviceProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeviceProfilesOutput) GoString() string {
	return s.String()
}

// SetDeviceProfileList sets the DeviceProfileList field's value.
func (s *ListDeviceProfilesOutput) SetDeviceProfileList(v []*DeviceProfile) *ListDeviceProfilesOutput {
	s.DeviceProfileList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeviceProfilesOutput) SetNextToken(v string) *ListDeviceProfilesOutput {
	s.NextToken = &v
	return s
}

type ListPartnerAccountsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in this operation.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// To retrieve the next set of results, the nextToken value from a previous
	// response; otherwise null to receive the first set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListPartnerAccountsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPartnerAccountsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPartnerAccountsInput) SetMaxResults(v int64) *ListPartnerAccountsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPartnerAccountsInput) SetNextToken(v string) *ListPartnerAccountsInput {
	s.NextToken = &v
	return s
}

type ListPartnerAccountsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to get the next set of results, or null if there are no
	// additional results.
	NextToken *string `type:"string"`

	// The Sidewalk account credentials.
	Sidewalk []*SidewalkAccountInfoWithFingerprint `type:"list"`
}

// String returns the string representation
func (s ListPartnerAccountsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPartnerAccountsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPartnerAccountsOutput) SetNextToken(v string) *ListPartnerAccountsOutput {
	s.NextToken = &v
	return s
}

// SetSidewalk sets the Sidewalk field's value.
func (s *ListPartnerAccountsOutput) SetSidewalk(v []*SidewalkAccountInfoWithFingerprint) *ListPartnerAccountsOutput {
	s.Sidewalk = v
	return s
}

type ListServiceProfilesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in this operation.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// To retrieve the next set of results, the nextToken value from a previous
	// response; otherwise null to receive the first set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListServiceProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListServiceProfilesInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListServiceProfilesInput) SetMaxResults(v int64) *ListServiceProfilesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListServiceProfilesInput) SetNextToken(v string) *ListServiceProfilesInput {
	s.NextToken = &v
	return s
}

type ListServiceProfilesOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to get the next set of results, or null if there are no
	// additional results.
	NextToken *string `type:"string"`

	// The list of service profiles.
	ServiceProfileList []*ServiceProfile `type:"list"`
}

// String returns the string representation
func (s ListServiceProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListServiceProfilesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListServiceProfilesOutput) SetNextToken(v string) *ListServiceProfilesOutput {
	s.NextToken = &v
	return s
}

// SetServiceProfileList sets the ServiceProfileList field's value.
func (s *ListServiceProfilesOutput) SetServiceProfileList(v []*ServiceProfile) *ListServiceProfilesOutput {
	s.ServiceProfileList = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource for which you want to list tags.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"querystring" locationName:"resourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags to attach to the specified resource. Tags are metadata that you
	// can use to manage a resource.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListWirelessDevicesInput struct {
	_ struct{} `type:"structure"`

	// A filter to list only the wireless devices that use this destination.
	DestinationName *string `location:"querystring" locationName:"destinationName" type:"string"`

	// A filter to list only the wireless devices that use this device profile.
	DeviceProfileId *string `location:"querystring" locationName:"deviceProfileId" type:"string"`

	// The maximum number of results to return in this operation.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// To retrieve the next set of results, the nextToken value from a previous
	// response; otherwise null to receive the first set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// A filter to list only the wireless devices that use this service profile.
	ServiceProfileId *string `location:"querystring" locationName:"serviceProfileId" type:"string"`

	// A filter to list only the wireless devices that use this wireless device
	// type.
	WirelessDeviceType *string `location:"querystring" locationName:"wirelessDeviceType" type:"string" enum:"WirelessDeviceType"`
}

// String returns the string representation
func (s ListWirelessDevicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListWirelessDevicesInput) GoString() string {
	return s.String()
}

// SetDestinationName sets the DestinationName field's value.
func (s *ListWirelessDevicesInput) SetDestinationName(v string) *ListWirelessDevicesInput {
	s.DestinationName = &v
	return s
}

// SetDeviceProfileId sets the DeviceProfileId field's value.
func (s *ListWirelessDevicesInput) SetDeviceProfileId(v string) *ListWirelessDevicesInput {
	s.DeviceProfileId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListWirelessDevicesInput) SetMaxResults(v int64) *ListWirelessDevicesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListWirelessDevicesInput) SetNextToken(v string) *ListWirelessDevicesInput {
	s.NextToken = &v
	return s
}

// SetServiceProfileId sets the ServiceProfileId field's value.
func (s *ListWirelessDevicesInput) SetServiceProfileId(v string) *ListWirelessDevicesInput {
	s.ServiceProfileId = &v
	return s
}

// SetWirelessDeviceType sets the WirelessDeviceType field's value.
func (s *ListWirelessDevicesInput) SetWirelessDeviceType(v string) *ListWirelessDevicesInput {
	s.WirelessDeviceType = &v
	return s
}

type ListWirelessDevicesOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to get the next set of results, or null if there are no
	// additional results.
	NextToken *string `type:"string"`

	// The ID of the wireless device.
	WirelessDeviceList []*WirelessDeviceStatistics `type:"list"`
}

// String returns the string representation
func (s ListWirelessDevicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListWirelessDevicesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListWirelessDevicesOutput) SetNextToken(v string) *ListWirelessDevicesOutput {
	s.NextToken = &v
	return s
}

// SetWirelessDeviceList sets the WirelessDeviceList field's value.
func (s *ListWirelessDevicesOutput) SetWirelessDeviceList(v []*WirelessDeviceStatistics) *ListWirelessDevicesOutput {
	s.WirelessDeviceList = v
	return s
}

type ListWirelessGatewayTaskDefinitionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in this operation.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// To retrieve the next set of results, the nextToken value from a previous
	// response; otherwise null to receive the first set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// A filter to list only the wireless gateway task definitions that use this
	// task definition type.
	TaskDefinitionType *string `location:"querystring" locationName:"taskDefinitionType" type:"string" enum:"WirelessGatewayTaskDefinitionType"`
}

// String returns the string representation
func (s ListWirelessGatewayTaskDefinitionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListWirelessGatewayTaskDefinitionsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListWirelessGatewayTaskDefinitionsInput) SetMaxResults(v int64) *ListWirelessGatewayTaskDefinitionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListWirelessGatewayTaskDefinitionsInput) SetNextToken(v string) *ListWirelessGatewayTaskDefinitionsInput {
	s.NextToken = &v
	return s
}

// SetTaskDefinitionType sets the TaskDefinitionType field's value.
func (s *ListWirelessGatewayTaskDefinitionsInput) SetTaskDefinitionType(v string) *ListWirelessGatewayTaskDefinitionsInput {
	s.TaskDefinitionType = &v
	return s
}

type ListWirelessGatewayTaskDefinitionsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to get the next set of results, or null if there are no
	// additional results.
	NextToken *string `type:"string"`

	// The list of task definitions.
	TaskDefinitions []*UpdateWirelessGatewayTaskEntry `type:"list"`
}

// String returns the string representation
func (s ListWirelessGatewayTaskDefinitionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListWirelessGatewayTaskDefinitionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListWirelessGatewayTaskDefinitionsOutput) SetNextToken(v string) *ListWirelessGatewayTaskDefinitionsOutput {
	s.NextToken = &v
	return s
}

// SetTaskDefinitions sets the TaskDefinitions field's value.
func (s *ListWirelessGatewayTaskDefinitionsOutput) SetTaskDefinitions(v []*UpdateWirelessGatewayTaskEntry) *ListWirelessGatewayTaskDefinitionsOutput {
	s.TaskDefinitions = v
	return s
}

type ListWirelessGatewaysInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in this operation.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// To retrieve the next set of results, the nextToken value from a previous
	// response; otherwise null to receive the first set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListWirelessGatewaysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListWirelessGatewaysInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListWirelessGatewaysInput) SetMaxResults(v int64) *ListWirelessGatewaysInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListWirelessGatewaysInput) SetNextToken(v string) *ListWirelessGatewaysInput {
	s.NextToken = &v
	return s
}

type ListWirelessGatewaysOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to get the next set of results, or null if there are no
	// additional results.
	NextToken *string `type:"string"`

	// The ID of the wireless gateway.
	WirelessGatewayList []*WirelessGatewayStatistics `type:"list"`
}

// String returns the string representation
func (s ListWirelessGatewaysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListWirelessGatewaysOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListWirelessGatewaysOutput) SetNextToken(v string) *ListWirelessGatewaysOutput {
	s.NextToken = &v
	return s
}

// SetWirelessGatewayList sets the WirelessGatewayList field's value.
func (s *ListWirelessGatewaysOutput) SetWirelessGatewayList(v []*WirelessGatewayStatistics) *ListWirelessGatewaysOutput {
	s.WirelessGatewayList = v
	return s
}

// LoRaWAN object for create functions.
type LoRaWANDevice struct {
	_ struct{} `type:"structure"`

	// LoRaWAN object for create APIs
	AbpV1_0_x *AbpV10X `type:"structure"`

	// ABP device object for create APIs for v1.1
	AbpV1_1 *AbpV11 `type:"structure"`

	// The DevEUI value.
	DevEui *string `type:"string"`

	// The ID of the device profile for the new wireless device.
	DeviceProfileId *string `type:"string"`

	// OTAA device object for create APIs for v1.0.x
	OtaaV1_0_x *OtaaV10X `type:"structure"`

	// OTAA device object for v1.1 for create APIs
	OtaaV1_1 *OtaaV11 `type:"structure"`

	// The ID of the service profile.
	ServiceProfileId *string `type:"string"`
}

// String returns the string representation
func (s LoRaWANDevice) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoRaWANDevice) GoString() string {
	return s.String()
}

// SetAbpV1_0_x sets the AbpV1_0_x field's value.
func (s *LoRaWANDevice) SetAbpV1_0_x(v *AbpV10X) *LoRaWANDevice {
	s.AbpV1_0_x = v
	return s
}

// SetAbpV1_1 sets the AbpV1_1 field's value.
func (s *LoRaWANDevice) SetAbpV1_1(v *AbpV11) *LoRaWANDevice {
	s.AbpV1_1 = v
	return s
}

// SetDevEui sets the DevEui field's value.
func (s *LoRaWANDevice) SetDevEui(v string) *LoRaWANDevice {
	s.DevEui = &v
	return s
}

// SetDeviceProfileId sets the DeviceProfileId field's value.
func (s *LoRaWANDevice) SetDeviceProfileId(v string) *LoRaWANDevice {
	s.DeviceProfileId = &v
	return s
}

// SetOtaaV1_0_x sets the OtaaV1_0_x field's value.
func (s *LoRaWANDevice) SetOtaaV1_0_x(v *OtaaV10X) *LoRaWANDevice {
	s.OtaaV1_0_x = v
	return s
}

// SetOtaaV1_1 sets the OtaaV1_1 field's value.
func (s *LoRaWANDevice) SetOtaaV1_1(v *OtaaV11) *LoRaWANDevice {
	s.OtaaV1_1 = v
	return s
}

// SetServiceProfileId sets the ServiceProfileId field's value.
func (s *LoRaWANDevice) SetServiceProfileId(v string) *LoRaWANDevice {
	s.ServiceProfileId = &v
	return s
}

// LoRaWAN device metatdata.
type LoRaWANDeviceMetadata struct {
	_ struct{} `type:"structure"`

	// The DataRate value.
	DataRate *int64 `type:"integer"`

	// The DevEUI value.
	DevEui *string `type:"string"`

	// The FPort value.
	FPort *int64 `type:"integer"`

	// The device's channel frequency in Hz.
	Frequency *int64 `type:"integer"`

	// Information about the gateways accessed by the device.
	Gateways []*LoRaWANGatewayMetadata `type:"list"`

	// The date and time of the metadata.
	Timestamp *string `type:"string"`
}

// String returns the string representation
func (s LoRaWANDeviceMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoRaWANDeviceMetadata) GoString() string {
	return s.String()
}

// SetDataRate sets the DataRate field's value.
func (s *LoRaWANDeviceMetadata) SetDataRate(v int64) *LoRaWANDeviceMetadata {
	s.DataRate = &v
	return s
}

// SetDevEui sets the DevEui field's value.
func (s *LoRaWANDeviceMetadata) SetDevEui(v string) *LoRaWANDeviceMetadata {
	s.DevEui = &v
	return s
}

// SetFPort sets the FPort field's value.
func (s *LoRaWANDeviceMetadata) SetFPort(v int64) *LoRaWANDeviceMetadata {
	s.FPort = &v
	return s
}

// SetFrequency sets the Frequency field's value.
func (s *LoRaWANDeviceMetadata) SetFrequency(v int64) *LoRaWANDeviceMetadata {
	s.Frequency = &v
	return s
}

// SetGateways sets the Gateways field's value.
func (s *LoRaWANDeviceMetadata) SetGateways(v []*LoRaWANGatewayMetadata) *LoRaWANDeviceMetadata {
	s.Gateways = v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *LoRaWANDeviceMetadata) SetTimestamp(v string) *LoRaWANDeviceMetadata {
	s.Timestamp = &v
	return s
}

// LoRaWANDeviceProfile object.
type LoRaWANDeviceProfile struct {
	_ struct{} `type:"structure"`

	// The ClassBTimeout value.
	ClassBTimeout *int64 `type:"integer"`

	// The ClassCTimeout value.
	ClassCTimeout *int64 `type:"integer"`

	// The list of values that make up the FactoryPresetFreqs value.
	FactoryPresetFreqsList []*int64 `type:"list"`

	// The MAC version (such as OTAA 1.1 or OTAA 1.0.3) to use with this device
	// profile.
	MacVersion *string `type:"string"`

	// The MaxDutyCycle value.
	MaxDutyCycle *int64 `type:"integer"`

	// The MaxEIRP value.
	MaxEirp *int64 `type:"integer"`

	// The PingSlotDR value.
	PingSlotDr *int64 `type:"integer"`

	// The PingSlotFreq value.
	PingSlotFreq *int64 `min:"1e+06" type:"integer"`

	// The PingSlotPeriod value.
	PingSlotPeriod *int64 `min:"128" type:"integer"`

	// The version of regional parameters.
	RegParamsRevision *string `type:"string"`

	// The frequency band (RFRegion) value.
	RfRegion *string `type:"string"`

	// The RXDataRate2 value.
	RxDataRate2 *int64 `type:"integer"`

	// The RXDelay1 value.
	RxDelay1 *int64 `type:"integer"`

	// The RXDROffset1 value.
	RxDrOffset1 *int64 `type:"integer"`

	// The RXFreq2 value.
	RxFreq2 *int64 `min:"1e+06" type:"integer"`

	// The Supports32BitFCnt value.
	Supports32BitFCnt *bool `type:"boolean"`

	// The SupportsClassB value.
	SupportsClassB *bool `type:"boolean"`

	// The SupportsClassC value.
	SupportsClassC *bool `type:"boolean"`

	// The SupportsJoin value.
	SupportsJoin *bool `type:"boolean"`
}

// String returns the string representation
func (s LoRaWANDeviceProfile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoRaWANDeviceProfile) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LoRaWANDeviceProfile) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LoRaWANDeviceProfile"}
	if s.PingSlotFreq != nil && *s.PingSlotFreq < 1e+06 {
		invalidParams.Add(request.NewErrParamMinValue("PingSlotFreq", 1e+06))
	}
	if s.PingSlotPeriod != nil && *s.PingSlotPeriod < 128 {
		invalidParams.Add(request.NewErrParamMinValue("PingSlotPeriod", 128))
	}
	if s.RxFreq2 != nil && *s.RxFreq2 < 1e+06 {
		invalidParams.Add(request.NewErrParamMinValue("RxFreq2", 1e+06))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClassBTimeout sets the ClassBTimeout field's value.
func (s *LoRaWANDeviceProfile) SetClassBTimeout(v int64) *LoRaWANDeviceProfile {
	s.ClassBTimeout = &v
	return s
}

// SetClassCTimeout sets the ClassCTimeout field's value.
func (s *LoRaWANDeviceProfile) SetClassCTimeout(v int64) *LoRaWANDeviceProfile {
	s.ClassCTimeout = &v
	return s
}

// SetFactoryPresetFreqsList sets the FactoryPresetFreqsList field's value.
func (s *LoRaWANDeviceProfile) SetFactoryPresetFreqsList(v []*int64) *LoRaWANDeviceProfile {
	s.FactoryPresetFreqsList = v
	return s
}

// SetMacVersion sets the MacVersion field's value.
func (s *LoRaWANDeviceProfile) SetMacVersion(v string) *LoRaWANDeviceProfile {
	s.MacVersion = &v
	return s
}

// SetMaxDutyCycle sets the MaxDutyCycle field's value.
func (s *LoRaWANDeviceProfile) SetMaxDutyCycle(v int64) *LoRaWANDeviceProfile {
	s.MaxDutyCycle = &v
	return s
}

// SetMaxEirp sets the MaxEirp field's value.
func (s *LoRaWANDeviceProfile) SetMaxEirp(v int64) *LoRaWANDeviceProfile {
	s.MaxEirp = &v
	return s
}

// SetPingSlotDr sets the PingSlotDr field's value.
func (s *LoRaWANDeviceProfile) SetPingSlotDr(v int64) *LoRaWANDeviceProfile {
	s.PingSlotDr = &v
	return s
}

// SetPingSlotFreq sets the PingSlotFreq field's value.
func (s *LoRaWANDeviceProfile) SetPingSlotFreq(v int64) *LoRaWANDeviceProfile {
	s.PingSlotFreq = &v
	return s
}

// SetPingSlotPeriod sets the PingSlotPeriod field's value.
func (s *LoRaWANDeviceProfile) SetPingSlotPeriod(v int64) *LoRaWANDeviceProfile {
	s.PingSlotPeriod = &v
	return s
}

// SetRegParamsRevision sets the RegParamsRevision field's value.
func (s *LoRaWANDeviceProfile) SetRegParamsRevision(v string) *LoRaWANDeviceProfile {
	s.RegParamsRevision = &v
	return s
}

// SetRfRegion sets the RfRegion field's value.
func (s *LoRaWANDeviceProfile) SetRfRegion(v string) *LoRaWANDeviceProfile {
	s.RfRegion = &v
	return s
}

// SetRxDataRate2 sets the RxDataRate2 field's value.
func (s *LoRaWANDeviceProfile) SetRxDataRate2(v int64) *LoRaWANDeviceProfile {
	s.RxDataRate2 = &v
	return s
}

// SetRxDelay1 sets the RxDelay1 field's value.
func (s *LoRaWANDeviceProfile) SetRxDelay1(v int64) *LoRaWANDeviceProfile {
	s.RxDelay1 = &v
	return s
}

// SetRxDrOffset1 sets the RxDrOffset1 field's value.
func (s *LoRaWANDeviceProfile) SetRxDrOffset1(v int64) *LoRaWANDeviceProfile {
	s.RxDrOffset1 = &v
	return s
}

// SetRxFreq2 sets the RxFreq2 field's value.
func (s *LoRaWANDeviceProfile) SetRxFreq2(v int64) *LoRaWANDeviceProfile {
	s.RxFreq2 = &v
	return s
}

// SetSupports32BitFCnt sets the Supports32BitFCnt field's value.
func (s *LoRaWANDeviceProfile) SetSupports32BitFCnt(v bool) *LoRaWANDeviceProfile {
	s.Supports32BitFCnt = &v
	return s
}

// SetSupportsClassB sets the SupportsClassB field's value.
func (s *LoRaWANDeviceProfile) SetSupportsClassB(v bool) *LoRaWANDeviceProfile {
	s.SupportsClassB = &v
	return s
}

// SetSupportsClassC sets the SupportsClassC field's value.
func (s *LoRaWANDeviceProfile) SetSupportsClassC(v bool) *LoRaWANDeviceProfile {
	s.SupportsClassC = &v
	return s
}

// SetSupportsJoin sets the SupportsJoin field's value.
func (s *LoRaWANDeviceProfile) SetSupportsJoin(v bool) *LoRaWANDeviceProfile {
	s.SupportsJoin = &v
	return s
}

// LoRaWANGateway object.
type LoRaWANGateway struct {
	_ struct{} `type:"structure"`

	// The gateway's EUI value.
	GatewayEui *string `type:"string"`

	// A list of JoinEuiRange used by LoRa gateways to filter LoRa frames.
	JoinEuiFilters [][]*string `type:"list"`

	// A list of NetId values that are used by LoRa gateways to filter the uplink
	// frames.
	NetIdFilters []*string `type:"list"`

	// The frequency band (RFRegion) value.
	RfRegion *string `type:"string"`

	// A list of integer indicating which sub bands are supported by LoRa gateway.
	SubBands []*int64 `type:"list"`
}

// String returns the string representation
func (s LoRaWANGateway) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoRaWANGateway) GoString() string {
	return s.String()
}

// SetGatewayEui sets the GatewayEui field's value.
func (s *LoRaWANGateway) SetGatewayEui(v string) *LoRaWANGateway {
	s.GatewayEui = &v
	return s
}

// SetJoinEuiFilters sets the JoinEuiFilters field's value.
func (s *LoRaWANGateway) SetJoinEuiFilters(v [][]*string) *LoRaWANGateway {
	s.JoinEuiFilters = v
	return s
}

// SetNetIdFilters sets the NetIdFilters field's value.
func (s *LoRaWANGateway) SetNetIdFilters(v []*string) *LoRaWANGateway {
	s.NetIdFilters = v
	return s
}

// SetRfRegion sets the RfRegion field's value.
func (s *LoRaWANGateway) SetRfRegion(v string) *LoRaWANGateway {
	s.RfRegion = &v
	return s
}

// SetSubBands sets the SubBands field's value.
func (s *LoRaWANGateway) SetSubBands(v []*int64) *LoRaWANGateway {
	s.SubBands = v
	return s
}

// LoRaWANGatewayCurrentVersion object.
type LoRaWANGatewayCurrentVersion struct {
	_ struct{} `type:"structure"`

	// The version of the gateways that should receive the update.
	CurrentVersion *LoRaWANGatewayVersion `type:"structure"`
}

// String returns the string representation
func (s LoRaWANGatewayCurrentVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoRaWANGatewayCurrentVersion) GoString() string {
	return s.String()
}

// SetCurrentVersion sets the CurrentVersion field's value.
func (s *LoRaWANGatewayCurrentVersion) SetCurrentVersion(v *LoRaWANGatewayVersion) *LoRaWANGatewayCurrentVersion {
	s.CurrentVersion = v
	return s
}

// LoRaWAN gateway metatdata.
type LoRaWANGatewayMetadata struct {
	_ struct{} `type:"structure"`

	// The gateway's EUI value.
	GatewayEui *string `type:"string"`

	// The RSSI value.
	Rssi *float64 `type:"double"`

	// The SNR value.
	Snr *float64 `type:"double"`
}

// String returns the string representation
func (s LoRaWANGatewayMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoRaWANGatewayMetadata) GoString() string {
	return s.String()
}

// SetGatewayEui sets the GatewayEui field's value.
func (s *LoRaWANGatewayMetadata) SetGatewayEui(v string) *LoRaWANGatewayMetadata {
	s.GatewayEui = &v
	return s
}

// SetRssi sets the Rssi field's value.
func (s *LoRaWANGatewayMetadata) SetRssi(v float64) *LoRaWANGatewayMetadata {
	s.Rssi = &v
	return s
}

// SetSnr sets the Snr field's value.
func (s *LoRaWANGatewayMetadata) SetSnr(v float64) *LoRaWANGatewayMetadata {
	s.Snr = &v
	return s
}

// LoRaWANGatewayVersion object.
type LoRaWANGatewayVersion struct {
	_ struct{} `type:"structure"`

	// The model number of the wireless gateway.
	Model *string `min:"1" type:"string"`

	// The version of the wireless gateway firmware.
	PackageVersion *string `min:"1" type:"string"`

	// The basic station version of the wireless gateway.
	Station *string `min:"1" type:"string"`
}

// String returns the string representation
func (s LoRaWANGatewayVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoRaWANGatewayVersion) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LoRaWANGatewayVersion) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LoRaWANGatewayVersion"}
	if s.Model != nil && len(*s.Model) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Model", 1))
	}
	if s.PackageVersion != nil && len(*s.PackageVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PackageVersion", 1))
	}
	if s.Station != nil && len(*s.Station) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Station", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetModel sets the Model field's value.
func (s *LoRaWANGatewayVersion) SetModel(v string) *LoRaWANGatewayVersion {
	s.Model = &v
	return s
}

// SetPackageVersion sets the PackageVersion field's value.
func (s *LoRaWANGatewayVersion) SetPackageVersion(v string) *LoRaWANGatewayVersion {
	s.PackageVersion = &v
	return s
}

// SetStation sets the Station field's value.
func (s *LoRaWANGatewayVersion) SetStation(v string) *LoRaWANGatewayVersion {
	s.Station = &v
	return s
}

// LoRaWANGetServiceProfileInfo object.
type LoRaWANGetServiceProfileInfo struct {
	_ struct{} `type:"structure"`

	// The AddGWMetaData value.
	AddGwMetadata *bool `type:"boolean"`

	// The ChannelMask value.
	ChannelMask *string `type:"string"`

	// The DevStatusReqFreq value.
	DevStatusReqFreq *int64 `type:"integer"`

	// The DLBucketSize value.
	DlBucketSize *int64 `type:"integer"`

	// The DLRate value.
	DlRate *int64 `type:"integer"`

	// The DLRatePolicy value.
	DlRatePolicy *string `type:"string"`

	// The DRMax value.
	DrMax *int64 `type:"integer"`

	// The DRMin value.
	DrMin *int64 `type:"integer"`

	// The HRAllowed value that describes whether handover roaming is allowed.
	HrAllowed *bool `type:"boolean"`

	// The MinGwDiversity value.
	MinGwDiversity *int64 `min:"1" type:"integer"`

	// The NwkGeoLoc value.
	NwkGeoLoc *bool `type:"boolean"`

	// The PRAllowed value that describes whether passive roaming is allowed.
	PrAllowed *bool `type:"boolean"`

	// The RAAllowed value that describes whether roaming activation is allowed.
	RaAllowed *bool `type:"boolean"`

	// The ReportDevStatusBattery value.
	ReportDevStatusBattery *bool `type:"boolean"`

	// The ReportDevStatusMargin value.
	ReportDevStatusMargin *bool `type:"boolean"`

	// The TargetPER value.
	TargetPer *int64 `type:"integer"`

	// The ULBucketSize value.
	UlBucketSize *int64 `type:"integer"`

	// The ULRate value.
	UlRate *int64 `type:"integer"`

	// The ULRatePolicy value.
	UlRatePolicy *string `type:"string"`
}

// String returns the string representation
func (s LoRaWANGetServiceProfileInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoRaWANGetServiceProfileInfo) GoString() string {
	return s.String()
}

// SetAddGwMetadata sets the AddGwMetadata field's value.
func (s *LoRaWANGetServiceProfileInfo) SetAddGwMetadata(v bool) *LoRaWANGetServiceProfileInfo {
	s.AddGwMetadata = &v
	return s
}

// SetChannelMask sets the ChannelMask field's value.
func (s *LoRaWANGetServiceProfileInfo) SetChannelMask(v string) *LoRaWANGetServiceProfileInfo {
	s.ChannelMask = &v
	return s
}

// SetDevStatusReqFreq sets the DevStatusReqFreq field's value.
func (s *LoRaWANGetServiceProfileInfo) SetDevStatusReqFreq(v int64) *LoRaWANGetServiceProfileInfo {
	s.DevStatusReqFreq = &v
	return s
}

// SetDlBucketSize sets the DlBucketSize field's value.
func (s *LoRaWANGetServiceProfileInfo) SetDlBucketSize(v int64) *LoRaWANGetServiceProfileInfo {
	s.DlBucketSize = &v
	return s
}

// SetDlRate sets the DlRate field's value.
func (s *LoRaWANGetServiceProfileInfo) SetDlRate(v int64) *LoRaWANGetServiceProfileInfo {
	s.DlRate = &v
	return s
}

// SetDlRatePolicy sets the DlRatePolicy field's value.
func (s *LoRaWANGetServiceProfileInfo) SetDlRatePolicy(v string) *LoRaWANGetServiceProfileInfo {
	s.DlRatePolicy = &v
	return s
}

// SetDrMax sets the DrMax field's value.
func (s *LoRaWANGetServiceProfileInfo) SetDrMax(v int64) *LoRaWANGetServiceProfileInfo {
	s.DrMax = &v
	return s
}

// SetDrMin sets the DrMin field's value.
func (s *LoRaWANGetServiceProfileInfo) SetDrMin(v int64) *LoRaWANGetServiceProfileInfo {
	s.DrMin = &v
	return s
}

// SetHrAllowed sets the HrAllowed field's value.
func (s *LoRaWANGetServiceProfileInfo) SetHrAllowed(v bool) *LoRaWANGetServiceProfileInfo {
	s.HrAllowed = &v
	return s
}

// SetMinGwDiversity sets the MinGwDiversity field's value.
func (s *LoRaWANGetServiceProfileInfo) SetMinGwDiversity(v int64) *LoRaWANGetServiceProfileInfo {
	s.MinGwDiversity = &v
	return s
}

// SetNwkGeoLoc sets the NwkGeoLoc field's value.
func (s *LoRaWANGetServiceProfileInfo) SetNwkGeoLoc(v bool) *LoRaWANGetServiceProfileInfo {
	s.NwkGeoLoc = &v
	return s
}

// SetPrAllowed sets the PrAllowed field's value.
func (s *LoRaWANGetServiceProfileInfo) SetPrAllowed(v bool) *LoRaWANGetServiceProfileInfo {
	s.PrAllowed = &v
	return s
}

// SetRaAllowed sets the RaAllowed field's value.
func (s *LoRaWANGetServiceProfileInfo) SetRaAllowed(v bool) *LoRaWANGetServiceProfileInfo {
	s.RaAllowed = &v
	return s
}

// SetReportDevStatusBattery sets the ReportDevStatusBattery field's value.
func (s *LoRaWANGetServiceProfileInfo) SetReportDevStatusBattery(v bool) *LoRaWANGetServiceProfileInfo {
	s.ReportDevStatusBattery = &v
	return s
}

// SetReportDevStatusMargin sets the ReportDevStatusMargin field's value.
func (s *LoRaWANGetServiceProfileInfo) SetReportDevStatusMargin(v bool) *LoRaWANGetServiceProfileInfo {
	s.ReportDevStatusMargin = &v
	return s
}

// SetTargetPer sets the TargetPer field's value.
func (s *LoRaWANGetServiceProfileInfo) SetTargetPer(v int64) *LoRaWANGetServiceProfileInfo {
	s.TargetPer = &v
	return s
}

// SetUlBucketSize sets the UlBucketSize field's value.
func (s *LoRaWANGetServiceProfileInfo) SetUlBucketSize(v int64) *LoRaWANGetServiceProfileInfo {
	s.UlBucketSize = &v
	return s
}

// SetUlRate sets the UlRate field's value.
func (s *LoRaWANGetServiceProfileInfo) SetUlRate(v int64) *LoRaWANGetServiceProfileInfo {
	s.UlRate = &v
	return s
}

// SetUlRatePolicy sets the UlRatePolicy field's value.
func (s *LoRaWANGetServiceProfileInfo) SetUlRatePolicy(v string) *LoRaWANGetServiceProfileInfo {
	s.UlRatePolicy = &v
	return s
}

// LoRaWAN object for list functions.
type LoRaWANListDevice struct {
	_ struct{} `type:"structure"`

	// The DevEUI value.
	DevEui *string `type:"string"`
}

// String returns the string representation
func (s LoRaWANListDevice) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoRaWANListDevice) GoString() string {
	return s.String()
}

// SetDevEui sets the DevEui field's value.
func (s *LoRaWANListDevice) SetDevEui(v string) *LoRaWANListDevice {
	s.DevEui = &v
	return s
}

// LoRaWAN router info.
type LoRaWANSendDataToDevice struct {
	_ struct{} `type:"structure"`

	// The Fport value.
	FPort *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s LoRaWANSendDataToDevice) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoRaWANSendDataToDevice) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LoRaWANSendDataToDevice) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LoRaWANSendDataToDevice"}
	if s.FPort != nil && *s.FPort < 1 {
		invalidParams.Add(request.NewErrParamMinValue("FPort", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFPort sets the FPort field's value.
func (s *LoRaWANSendDataToDevice) SetFPort(v int64) *LoRaWANSendDataToDevice {
	s.FPort = &v
	return s
}

// LoRaWANServiceProfile object.
type LoRaWANServiceProfile struct {
	_ struct{} `type:"structure"`

	// The AddGWMetaData value.
	AddGwMetadata *bool `type:"boolean"`
}

// String returns the string representation
func (s LoRaWANServiceProfile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoRaWANServiceProfile) GoString() string {
	return s.String()
}

// SetAddGwMetadata sets the AddGwMetadata field's value.
func (s *LoRaWANServiceProfile) SetAddGwMetadata(v bool) *LoRaWANServiceProfile {
	s.AddGwMetadata = &v
	return s
}

// LoRaWAN object for update functions.
type LoRaWANUpdateDevice struct {
	_ struct{} `type:"structure"`

	// The ID of the device profile for the wireless device.
	DeviceProfileId *string `type:"string"`

	// The ID of the service profile.
	ServiceProfileId *string `type:"string"`
}

// String returns the string representation
func (s LoRaWANUpdateDevice) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoRaWANUpdateDevice) GoString() string {
	return s.String()
}

// SetDeviceProfileId sets the DeviceProfileId field's value.
func (s *LoRaWANUpdateDevice) SetDeviceProfileId(v string) *LoRaWANUpdateDevice {
	s.DeviceProfileId = &v
	return s
}

// SetServiceProfileId sets the ServiceProfileId field's value.
func (s *LoRaWANUpdateDevice) SetServiceProfileId(v string) *LoRaWANUpdateDevice {
	s.ServiceProfileId = &v
	return s
}

// LoRaWANUpdateGatewayTaskCreate object.
type LoRaWANUpdateGatewayTaskCreate struct {
	_ struct{} `type:"structure"`

	// The version of the gateways that should receive the update.
	CurrentVersion *LoRaWANGatewayVersion `type:"structure"`

	// The CRC of the signature private key to check.
	SigKeyCrc *int64 `min:"1" type:"long"`

	// The signature used to verify the update firmware.
	UpdateSignature *string `min:"1" type:"string"`

	// The firmware version to update the gateway to.
	UpdateVersion *LoRaWANGatewayVersion `type:"structure"`
}

// String returns the string representation
func (s LoRaWANUpdateGatewayTaskCreate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoRaWANUpdateGatewayTaskCreate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LoRaWANUpdateGatewayTaskCreate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LoRaWANUpdateGatewayTaskCreate"}
	if s.SigKeyCrc != nil && *s.SigKeyCrc < 1 {
		invalidParams.Add(request.NewErrParamMinValue("SigKeyCrc", 1))
	}
	if s.UpdateSignature != nil && len(*s.UpdateSignature) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UpdateSignature", 1))
	}
	if s.CurrentVersion != nil {
		if err := s.CurrentVersion.Validate(); err != nil {
			invalidParams.AddNested("CurrentVersion", err.(request.ErrInvalidParams))
		}
	}
	if s.UpdateVersion != nil {
		if err := s.UpdateVersion.Validate(); err != nil {
			invalidParams.AddNested("UpdateVersion", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCurrentVersion sets the CurrentVersion field's value.
func (s *LoRaWANUpdateGatewayTaskCreate) SetCurrentVersion(v *LoRaWANGatewayVersion) *LoRaWANUpdateGatewayTaskCreate {
	s.CurrentVersion = v
	return s
}

// SetSigKeyCrc sets the SigKeyCrc field's value.
func (s *LoRaWANUpdateGatewayTaskCreate) SetSigKeyCrc(v int64) *LoRaWANUpdateGatewayTaskCreate {
	s.SigKeyCrc = &v
	return s
}

// SetUpdateSignature sets the UpdateSignature field's value.
func (s *LoRaWANUpdateGatewayTaskCreate) SetUpdateSignature(v string) *LoRaWANUpdateGatewayTaskCreate {
	s.UpdateSignature = &v
	return s
}

// SetUpdateVersion sets the UpdateVersion field's value.
func (s *LoRaWANUpdateGatewayTaskCreate) SetUpdateVersion(v *LoRaWANGatewayVersion) *LoRaWANUpdateGatewayTaskCreate {
	s.UpdateVersion = v
	return s
}

// LoRaWANUpdateGatewayTaskEntry object.
type LoRaWANUpdateGatewayTaskEntry struct {
	_ struct{} `type:"structure"`

	// The version of the gateways that should receive the update.
	CurrentVersion *LoRaWANGatewayVersion `type:"structure"`

	// The firmware version to update the gateway to.
	UpdateVersion *LoRaWANGatewayVersion `type:"structure"`
}

// String returns the string representation
func (s LoRaWANUpdateGatewayTaskEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoRaWANUpdateGatewayTaskEntry) GoString() string {
	return s.String()
}

// SetCurrentVersion sets the CurrentVersion field's value.
func (s *LoRaWANUpdateGatewayTaskEntry) SetCurrentVersion(v *LoRaWANGatewayVersion) *LoRaWANUpdateGatewayTaskEntry {
	s.CurrentVersion = v
	return s
}

// SetUpdateVersion sets the UpdateVersion field's value.
func (s *LoRaWANUpdateGatewayTaskEntry) SetUpdateVersion(v *LoRaWANGatewayVersion) *LoRaWANUpdateGatewayTaskEntry {
	s.UpdateVersion = v
	return s
}

// OTAA device object for v1.0.x
type OtaaV10X struct {
	_ struct{} `type:"structure"`

	// The AppEUI value.
	AppEui *string `type:"string"`

	// The AppKey value.
	AppKey *string `type:"string"`
}

// String returns the string representation
func (s OtaaV10X) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OtaaV10X) GoString() string {
	return s.String()
}

// SetAppEui sets the AppEui field's value.
func (s *OtaaV10X) SetAppEui(v string) *OtaaV10X {
	s.AppEui = &v
	return s
}

// SetAppKey sets the AppKey field's value.
func (s *OtaaV10X) SetAppKey(v string) *OtaaV10X {
	s.AppKey = &v
	return s
}

// OTAA device object for v1.1
type OtaaV11 struct {
	_ struct{} `type:"structure"`

	// The AppKey value.
	AppKey *string `type:"string"`

	// The JoinEUI value.
	JoinEui *string `type:"string"`

	// The NwkKey value.
	NwkKey *string `type:"string"`
}

// String returns the string representation
func (s OtaaV11) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OtaaV11) GoString() string {
	return s.String()
}

// SetAppKey sets the AppKey field's value.
func (s *OtaaV11) SetAppKey(v string) *OtaaV11 {
	s.AppKey = &v
	return s
}

// SetJoinEui sets the JoinEui field's value.
func (s *OtaaV11) SetJoinEui(v string) *OtaaV11 {
	s.JoinEui = &v
	return s
}

// SetNwkKey sets the NwkKey field's value.
func (s *OtaaV11) SetNwkKey(v string) *OtaaV11 {
	s.NwkKey = &v
	return s
}

// Resource does not exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// Id of the not found resource.
	ResourceId *string `type:"string"`

	// Type of the font found resource.
	ResourceType *string `type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type SendDataToWirelessDeviceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the wireless device to receive the data.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The message payload to send.
	//
	// PayloadData is a required field
	PayloadData *string `type:"string" required:"true"`

	// The transmit mode to use to send data to the wireless device. Can be: 0 for
	// UM (unacknowledge mode) or 1 for AM (acknowledge mode).
	//
	// TransmitMode is a required field
	TransmitMode *int64 `type:"integer" required:"true"`

	// Metadata about the message request.
	WirelessMetadata *WirelessMetadata `type:"structure"`
}

// String returns the string representation
func (s SendDataToWirelessDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendDataToWirelessDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendDataToWirelessDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendDataToWirelessDeviceInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.PayloadData == nil {
		invalidParams.Add(request.NewErrParamRequired("PayloadData"))
	}
	if s.TransmitMode == nil {
		invalidParams.Add(request.NewErrParamRequired("TransmitMode"))
	}
	if s.WirelessMetadata != nil {
		if err := s.WirelessMetadata.Validate(); err != nil {
			invalidParams.AddNested("WirelessMetadata", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *SendDataToWirelessDeviceInput) SetId(v string) *SendDataToWirelessDeviceInput {
	s.Id = &v
	return s
}

// SetPayloadData sets the PayloadData field's value.
func (s *SendDataToWirelessDeviceInput) SetPayloadData(v string) *SendDataToWirelessDeviceInput {
	s.PayloadData = &v
	return s
}

// SetTransmitMode sets the TransmitMode field's value.
func (s *SendDataToWirelessDeviceInput) SetTransmitMode(v int64) *SendDataToWirelessDeviceInput {
	s.TransmitMode = &v
	return s
}

// SetWirelessMetadata sets the WirelessMetadata field's value.
func (s *SendDataToWirelessDeviceInput) SetWirelessMetadata(v *WirelessMetadata) *SendDataToWirelessDeviceInput {
	s.WirelessMetadata = v
	return s
}

type SendDataToWirelessDeviceOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the message sent to the wireless device.
	MessageId *string `type:"string"`
}

// String returns the string representation
func (s SendDataToWirelessDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendDataToWirelessDeviceOutput) GoString() string {
	return s.String()
}

// SetMessageId sets the MessageId field's value.
func (s *SendDataToWirelessDeviceOutput) SetMessageId(v string) *SendDataToWirelessDeviceOutput {
	s.MessageId = &v
	return s
}

// Information about a service profile.
type ServiceProfile struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name of the resource.
	Arn *string `type:"string"`

	// The ID of the service profile.
	Id *string `type:"string"`

	// The name of the resource.
	Name *string `type:"string"`
}

// String returns the string representation
func (s ServiceProfile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceProfile) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ServiceProfile) SetArn(v string) *ServiceProfile {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *ServiceProfile) SetId(v string) *ServiceProfile {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *ServiceProfile) SetName(v string) *ServiceProfile {
	s.Name = &v
	return s
}

// Session keys for ABP v1.1
type SessionKeysAbpV10X struct {
	_ struct{} `type:"structure"`

	// The AppSKey value.
	AppSKey *string `type:"string"`

	// The NwkSKey value.
	NwkSKey *string `type:"string"`
}

// String returns the string representation
func (s SessionKeysAbpV10X) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SessionKeysAbpV10X) GoString() string {
	return s.String()
}

// SetAppSKey sets the AppSKey field's value.
func (s *SessionKeysAbpV10X) SetAppSKey(v string) *SessionKeysAbpV10X {
	s.AppSKey = &v
	return s
}

// SetNwkSKey sets the NwkSKey field's value.
func (s *SessionKeysAbpV10X) SetNwkSKey(v string) *SessionKeysAbpV10X {
	s.NwkSKey = &v
	return s
}

// Session keys for ABP v1.1
type SessionKeysAbpV11 struct {
	_ struct{} `type:"structure"`

	// The AppSKey value.
	AppSKey *string `type:"string"`

	// The FNwkSIntKey value.
	FNwkSIntKey *string `type:"string"`

	// The NwkSEncKey value.
	NwkSEncKey *string `type:"string"`

	// The SNwkSIntKey value.
	SNwkSIntKey *string `type:"string"`
}

// String returns the string representation
func (s SessionKeysAbpV11) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SessionKeysAbpV11) GoString() string {
	return s.String()
}

// SetAppSKey sets the AppSKey field's value.
func (s *SessionKeysAbpV11) SetAppSKey(v string) *SessionKeysAbpV11 {
	s.AppSKey = &v
	return s
}

// SetFNwkSIntKey sets the FNwkSIntKey field's value.
func (s *SessionKeysAbpV11) SetFNwkSIntKey(v string) *SessionKeysAbpV11 {
	s.FNwkSIntKey = &v
	return s
}

// SetNwkSEncKey sets the NwkSEncKey field's value.
func (s *SessionKeysAbpV11) SetNwkSEncKey(v string) *SessionKeysAbpV11 {
	s.NwkSEncKey = &v
	return s
}

// SetSNwkSIntKey sets the SNwkSIntKey field's value.
func (s *SessionKeysAbpV11) SetSNwkSIntKey(v string) *SessionKeysAbpV11 {
	s.SNwkSIntKey = &v
	return s
}

// Information about a Sidewalk account.
type SidewalkAccountInfo struct {
	_ struct{} `type:"structure"`

	// The Sidewalk Amazon ID.
	AmazonId *string `type:"string"`

	// The Sidewalk application server private key.
	AppServerPrivateKey *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation
func (s SidewalkAccountInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SidewalkAccountInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SidewalkAccountInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SidewalkAccountInfo"}
	if s.AppServerPrivateKey != nil && len(*s.AppServerPrivateKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppServerPrivateKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmazonId sets the AmazonId field's value.
func (s *SidewalkAccountInfo) SetAmazonId(v string) *SidewalkAccountInfo {
	s.AmazonId = &v
	return s
}

// SetAppServerPrivateKey sets the AppServerPrivateKey field's value.
func (s *SidewalkAccountInfo) SetAppServerPrivateKey(v string) *SidewalkAccountInfo {
	s.AppServerPrivateKey = &v
	return s
}

// Information about a Sidewalk account.
type SidewalkAccountInfoWithFingerprint struct {
	_ struct{} `type:"structure"`

	// The Sidewalk Amazon ID.
	AmazonId *string `type:"string"`

	// The Amazon Resource Name of the resource.
	Arn *string `type:"string"`

	// The fingerprint of the Sidewalk application server private key.
	Fingerprint *string `min:"64" type:"string" sensitive:"true"`
}

// String returns the string representation
func (s SidewalkAccountInfoWithFingerprint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SidewalkAccountInfoWithFingerprint) GoString() string {
	return s.String()
}

// SetAmazonId sets the AmazonId field's value.
func (s *SidewalkAccountInfoWithFingerprint) SetAmazonId(v string) *SidewalkAccountInfoWithFingerprint {
	s.AmazonId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *SidewalkAccountInfoWithFingerprint) SetArn(v string) *SidewalkAccountInfoWithFingerprint {
	s.Arn = &v
	return s
}

// SetFingerprint sets the Fingerprint field's value.
func (s *SidewalkAccountInfoWithFingerprint) SetFingerprint(v string) *SidewalkAccountInfoWithFingerprint {
	s.Fingerprint = &v
	return s
}

// Sidewalk device object.
type SidewalkDevice struct {
	_ struct{} `type:"structure"`

	// The sidewalk device certificates for Ed25519 and P256r1.
	DeviceCertificates []*CertificateList `type:"list"`

	// The sidewalk device identification.
	SidewalkId *string `type:"string"`

	// The Sidewalk manufacturing series number.
	SidewalkManufacturingSn *string `type:"string"`
}

// String returns the string representation
func (s SidewalkDevice) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SidewalkDevice) GoString() string {
	return s.String()
}

// SetDeviceCertificates sets the DeviceCertificates field's value.
func (s *SidewalkDevice) SetDeviceCertificates(v []*CertificateList) *SidewalkDevice {
	s.DeviceCertificates = v
	return s
}

// SetSidewalkId sets the SidewalkId field's value.
func (s *SidewalkDevice) SetSidewalkId(v string) *SidewalkDevice {
	s.SidewalkId = &v
	return s
}

// SetSidewalkManufacturingSn sets the SidewalkManufacturingSn field's value.
func (s *SidewalkDevice) SetSidewalkManufacturingSn(v string) *SidewalkDevice {
	s.SidewalkManufacturingSn = &v
	return s
}

// MetaData for Sidewalk device.
type SidewalkDeviceMetadata struct {
	_ struct{} `type:"structure"`

	// Sidewalk device battery level.
	BatteryLevel *string `type:"string" enum:"BatteryLevel"`

	// Device state defines the device status of sidewalk device.
	DeviceState *string `type:"string" enum:"DeviceState"`

	// Sidewalk device status notification.
	Event *string `type:"string" enum:"Event"`

	// The RSSI value.
	Rssi *int64 `type:"integer"`
}

// String returns the string representation
func (s SidewalkDeviceMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SidewalkDeviceMetadata) GoString() string {
	return s.String()
}

// SetBatteryLevel sets the BatteryLevel field's value.
func (s *SidewalkDeviceMetadata) SetBatteryLevel(v string) *SidewalkDeviceMetadata {
	s.BatteryLevel = &v
	return s
}

// SetDeviceState sets the DeviceState field's value.
func (s *SidewalkDeviceMetadata) SetDeviceState(v string) *SidewalkDeviceMetadata {
	s.DeviceState = &v
	return s
}

// SetEvent sets the Event field's value.
func (s *SidewalkDeviceMetadata) SetEvent(v string) *SidewalkDeviceMetadata {
	s.Event = &v
	return s
}

// SetRssi sets the Rssi field's value.
func (s *SidewalkDeviceMetadata) SetRssi(v int64) *SidewalkDeviceMetadata {
	s.Rssi = &v
	return s
}

// Sidewalk object used by list functions.
type SidewalkListDevice struct {
	_ struct{} `type:"structure"`

	// The Sidewalk Amazon ID.
	AmazonId *string `type:"string"`

	// The sidewalk device certificates for Ed25519 and P256r1.
	DeviceCertificates []*CertificateList `type:"list"`

	// The sidewalk device identification.
	SidewalkId *string `type:"string"`

	// The Sidewalk manufacturing series number.
	SidewalkManufacturingSn *string `type:"string"`
}

// String returns the string representation
func (s SidewalkListDevice) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SidewalkListDevice) GoString() string {
	return s.String()
}

// SetAmazonId sets the AmazonId field's value.
func (s *SidewalkListDevice) SetAmazonId(v string) *SidewalkListDevice {
	s.AmazonId = &v
	return s
}

// SetDeviceCertificates sets the DeviceCertificates field's value.
func (s *SidewalkListDevice) SetDeviceCertificates(v []*CertificateList) *SidewalkListDevice {
	s.DeviceCertificates = v
	return s
}

// SetSidewalkId sets the SidewalkId field's value.
func (s *SidewalkListDevice) SetSidewalkId(v string) *SidewalkListDevice {
	s.SidewalkId = &v
	return s
}

// SetSidewalkManufacturingSn sets the SidewalkManufacturingSn field's value.
func (s *SidewalkListDevice) SetSidewalkManufacturingSn(v string) *SidewalkListDevice {
	s.SidewalkManufacturingSn = &v
	return s
}

// Information about a Sidewalk router.
type SidewalkSendDataToDevice struct {
	_ struct{} `type:"structure"`

	// Sidewalk device message type.
	MessageType *string `type:"string" enum:"MessageType"`

	// The sequence number.
	Seq *int64 `type:"integer"`
}

// String returns the string representation
func (s SidewalkSendDataToDevice) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SidewalkSendDataToDevice) GoString() string {
	return s.String()
}

// SetMessageType sets the MessageType field's value.
func (s *SidewalkSendDataToDevice) SetMessageType(v string) *SidewalkSendDataToDevice {
	s.MessageType = &v
	return s
}

// SetSeq sets the Seq field's value.
func (s *SidewalkSendDataToDevice) SetSeq(v int64) *SidewalkSendDataToDevice {
	s.Seq = &v
	return s
}

// Sidewalk update.
type SidewalkUpdateAccount struct {
	_ struct{} `type:"structure"`

	// The new Sidewalk application server private key.
	AppServerPrivateKey *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation
func (s SidewalkUpdateAccount) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SidewalkUpdateAccount) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SidewalkUpdateAccount) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SidewalkUpdateAccount"}
	if s.AppServerPrivateKey != nil && len(*s.AppServerPrivateKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppServerPrivateKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppServerPrivateKey sets the AppServerPrivateKey field's value.
func (s *SidewalkUpdateAccount) SetAppServerPrivateKey(v string) *SidewalkUpdateAccount {
	s.AppServerPrivateKey = &v
	return s
}

// A simple label consisting of a customer-defined key-value pair
type Tag struct {
	_ struct{} `type:"structure"`

	// The tag's key value.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The tag's value.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource to add tags to.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"querystring" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// Adds to or modifies the tags of the given resource. Tags are metadata that
	// you can use to manage a resource.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type TestWirelessDeviceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the wireless device to test.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s TestWirelessDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TestWirelessDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TestWirelessDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TestWirelessDeviceInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *TestWirelessDeviceInput) SetId(v string) *TestWirelessDeviceInput {
	s.Id = &v
	return s
}

type TestWirelessDeviceOutput struct {
	_ struct{} `type:"structure"`

	// The result returned by the test.
	Result *string `type:"string"`
}

// String returns the string representation
func (s TestWirelessDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TestWirelessDeviceOutput) GoString() string {
	return s.String()
}

// SetResult sets the Result field's value.
func (s *TestWirelessDeviceOutput) SetResult(v string) *TestWirelessDeviceOutput {
	s.Result = &v
	return s
}

// The request was denied because it exceeded the allowed API request rate.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was denied because the resource can't have any more tags.
type TooManyTagsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// Name of the resource that exceeds maximum number of tags allowed.
	ResourceName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s TooManyTagsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TooManyTagsException) GoString() string {
	return s.String()
}

func newErrorTooManyTagsException(v protocol.ResponseMetadata) error {
	return &TooManyTagsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyTagsException) Code() string {
	return "TooManyTagsException"
}

// Message returns the exception's message.
func (s *TooManyTagsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyTagsException) OrigErr() error {
	return nil
}

func (s *TooManyTagsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyTagsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyTagsException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource to remove tags from.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"querystring" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// A list of the keys of the tags to remove from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateDestinationInput struct {
	_ struct{} `type:"structure"`

	// A new description of the resource.
	Description *string `type:"string"`

	// The new rule name or topic rule to send messages to.
	Expression *string `type:"string"`

	// The type of value in Expression.
	ExpressionType *string `type:"string" enum:"ExpressionType"`

	// The new name of the resource.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" type:"string" required:"true"`

	// The ARN of the IAM Role that authorizes the destination.
	RoleArn *string `min:"20" type:"string"`
}

// String returns the string representation
func (s UpdateDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDestinationInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateDestinationInput) SetDescription(v string) *UpdateDestinationInput {
	s.Description = &v
	return s
}

// SetExpression sets the Expression field's value.
func (s *UpdateDestinationInput) SetExpression(v string) *UpdateDestinationInput {
	s.Expression = &v
	return s
}

// SetExpressionType sets the ExpressionType field's value.
func (s *UpdateDestinationInput) SetExpressionType(v string) *UpdateDestinationInput {
	s.ExpressionType = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateDestinationInput) SetName(v string) *UpdateDestinationInput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateDestinationInput) SetRoleArn(v string) *UpdateDestinationInput {
	s.RoleArn = &v
	return s
}

type UpdateDestinationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDestinationOutput) GoString() string {
	return s.String()
}

type UpdatePartnerAccountInput struct {
	_ struct{} `type:"structure"`

	// The ID of the partner account to update.
	//
	// PartnerAccountId is a required field
	PartnerAccountId *string `location:"uri" locationName:"PartnerAccountId" type:"string" required:"true"`

	// The partner type.
	//
	// PartnerType is a required field
	PartnerType *string `location:"querystring" locationName:"partnerType" type:"string" required:"true" enum:"PartnerType"`

	// The Sidewalk account credentials.
	//
	// Sidewalk is a required field
	Sidewalk *SidewalkUpdateAccount `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdatePartnerAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePartnerAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePartnerAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePartnerAccountInput"}
	if s.PartnerAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("PartnerAccountId"))
	}
	if s.PartnerAccountId != nil && len(*s.PartnerAccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PartnerAccountId", 1))
	}
	if s.PartnerType == nil {
		invalidParams.Add(request.NewErrParamRequired("PartnerType"))
	}
	if s.Sidewalk == nil {
		invalidParams.Add(request.NewErrParamRequired("Sidewalk"))
	}
	if s.Sidewalk != nil {
		if err := s.Sidewalk.Validate(); err != nil {
			invalidParams.AddNested("Sidewalk", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPartnerAccountId sets the PartnerAccountId field's value.
func (s *UpdatePartnerAccountInput) SetPartnerAccountId(v string) *UpdatePartnerAccountInput {
	s.PartnerAccountId = &v
	return s
}

// SetPartnerType sets the PartnerType field's value.
func (s *UpdatePartnerAccountInput) SetPartnerType(v string) *UpdatePartnerAccountInput {
	s.PartnerType = &v
	return s
}

// SetSidewalk sets the Sidewalk field's value.
func (s *UpdatePartnerAccountInput) SetSidewalk(v *SidewalkUpdateAccount) *UpdatePartnerAccountInput {
	s.Sidewalk = v
	return s
}

type UpdatePartnerAccountOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdatePartnerAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePartnerAccountOutput) GoString() string {
	return s.String()
}

type UpdateWirelessDeviceInput struct {
	_ struct{} `type:"structure"`

	// A new description of the resource.
	Description *string `type:"string"`

	// The name of the new destination for the device.
	DestinationName *string `type:"string"`

	// The ID of the resource to update.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The updated wireless device's configuration.
	LoRaWAN *LoRaWANUpdateDevice `type:"structure"`

	// The new name of the resource.
	Name *string `type:"string"`
}

// String returns the string representation
func (s UpdateWirelessDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateWirelessDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateWirelessDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateWirelessDeviceInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateWirelessDeviceInput) SetDescription(v string) *UpdateWirelessDeviceInput {
	s.Description = &v
	return s
}

// SetDestinationName sets the DestinationName field's value.
func (s *UpdateWirelessDeviceInput) SetDestinationName(v string) *UpdateWirelessDeviceInput {
	s.DestinationName = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateWirelessDeviceInput) SetId(v string) *UpdateWirelessDeviceInput {
	s.Id = &v
	return s
}

// SetLoRaWAN sets the LoRaWAN field's value.
func (s *UpdateWirelessDeviceInput) SetLoRaWAN(v *LoRaWANUpdateDevice) *UpdateWirelessDeviceInput {
	s.LoRaWAN = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateWirelessDeviceInput) SetName(v string) *UpdateWirelessDeviceInput {
	s.Name = &v
	return s
}

type UpdateWirelessDeviceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateWirelessDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateWirelessDeviceOutput) GoString() string {
	return s.String()
}

type UpdateWirelessGatewayInput struct {
	_ struct{} `type:"structure"`

	// A new description of the resource.
	Description *string `type:"string"`

	// The ID of the resource to update.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// A list of JoinEuiRange used by LoRa gateways to filter LoRa frames.
	JoinEuiFilters [][]*string `type:"list"`

	// The new name of the resource.
	Name *string `type:"string"`

	// A list of NetId values that are used by LoRa gateways to filter the uplink
	// frames.
	NetIdFilters []*string `type:"list"`
}

// String returns the string representation
func (s UpdateWirelessGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateWirelessGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateWirelessGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateWirelessGatewayInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateWirelessGatewayInput) SetDescription(v string) *UpdateWirelessGatewayInput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateWirelessGatewayInput) SetId(v string) *UpdateWirelessGatewayInput {
	s.Id = &v
	return s
}

// SetJoinEuiFilters sets the JoinEuiFilters field's value.
func (s *UpdateWirelessGatewayInput) SetJoinEuiFilters(v [][]*string) *UpdateWirelessGatewayInput {
	s.JoinEuiFilters = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateWirelessGatewayInput) SetName(v string) *UpdateWirelessGatewayInput {
	s.Name = &v
	return s
}

// SetNetIdFilters sets the NetIdFilters field's value.
func (s *UpdateWirelessGatewayInput) SetNetIdFilters(v []*string) *UpdateWirelessGatewayInput {
	s.NetIdFilters = v
	return s
}

type UpdateWirelessGatewayOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateWirelessGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateWirelessGatewayOutput) GoString() string {
	return s.String()
}

// UpdateWirelessGatewayTaskCreate object.
type UpdateWirelessGatewayTaskCreate struct {
	_ struct{} `type:"structure"`

	// The properties that relate to the LoRaWAN wireless gateway.
	LoRaWAN *LoRaWANUpdateGatewayTaskCreate `type:"structure"`

	// The IAM role used to read data from the S3 bucket.
	UpdateDataRole *string `min:"1" type:"string"`

	// The link to the S3 bucket.
	UpdateDataSource *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateWirelessGatewayTaskCreate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateWirelessGatewayTaskCreate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateWirelessGatewayTaskCreate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateWirelessGatewayTaskCreate"}
	if s.UpdateDataRole != nil && len(*s.UpdateDataRole) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UpdateDataRole", 1))
	}
	if s.UpdateDataSource != nil && len(*s.UpdateDataSource) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UpdateDataSource", 1))
	}
	if s.LoRaWAN != nil {
		if err := s.LoRaWAN.Validate(); err != nil {
			invalidParams.AddNested("LoRaWAN", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLoRaWAN sets the LoRaWAN field's value.
func (s *UpdateWirelessGatewayTaskCreate) SetLoRaWAN(v *LoRaWANUpdateGatewayTaskCreate) *UpdateWirelessGatewayTaskCreate {
	s.LoRaWAN = v
	return s
}

// SetUpdateDataRole sets the UpdateDataRole field's value.
func (s *UpdateWirelessGatewayTaskCreate) SetUpdateDataRole(v string) *UpdateWirelessGatewayTaskCreate {
	s.UpdateDataRole = &v
	return s
}

// SetUpdateDataSource sets the UpdateDataSource field's value.
func (s *UpdateWirelessGatewayTaskCreate) SetUpdateDataSource(v string) *UpdateWirelessGatewayTaskCreate {
	s.UpdateDataSource = &v
	return s
}

// UpdateWirelessGatewayTaskEntry object.
type UpdateWirelessGatewayTaskEntry struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name of the resource.
	Arn *string `type:"string"`

	// The ID of the new wireless gateway task entry.
	Id *string `type:"string"`

	// The properties that relate to the LoRaWAN wireless gateway.
	LoRaWAN *LoRaWANUpdateGatewayTaskEntry `type:"structure"`
}

// String returns the string representation
func (s UpdateWirelessGatewayTaskEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateWirelessGatewayTaskEntry) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateWirelessGatewayTaskEntry) SetArn(v string) *UpdateWirelessGatewayTaskEntry {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateWirelessGatewayTaskEntry) SetId(v string) *UpdateWirelessGatewayTaskEntry {
	s.Id = &v
	return s
}

// SetLoRaWAN sets the LoRaWAN field's value.
func (s *UpdateWirelessGatewayTaskEntry) SetLoRaWAN(v *LoRaWANUpdateGatewayTaskEntry) *UpdateWirelessGatewayTaskEntry {
	s.LoRaWAN = v
	return s
}

// The input did not meet the specified constraints.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about a wireless device's operation.
type WirelessDeviceStatistics struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name of the resource.
	Arn *string `type:"string"`

	// The name of the destination to which the device is assigned.
	DestinationName *string `type:"string"`

	// The ID of the wireless device reporting the data.
	Id *string `type:"string"`

	// The date and time when the most recent uplink was received.
	LastUplinkReceivedAt *string `type:"string"`

	// LoRaWAN device info.
	LoRaWAN *LoRaWANListDevice `type:"structure"`

	// The name of the resource.
	Name *string `type:"string"`

	// The Sidewalk account credentials.
	Sidewalk *SidewalkListDevice `type:"structure"`

	// The wireless device type.
	Type *string `type:"string" enum:"WirelessDeviceType"`
}

// String returns the string representation
func (s WirelessDeviceStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WirelessDeviceStatistics) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *WirelessDeviceStatistics) SetArn(v string) *WirelessDeviceStatistics {
	s.Arn = &v
	return s
}

// SetDestinationName sets the DestinationName field's value.
func (s *WirelessDeviceStatistics) SetDestinationName(v string) *WirelessDeviceStatistics {
	s.DestinationName = &v
	return s
}

// SetId sets the Id field's value.
func (s *WirelessDeviceStatistics) SetId(v string) *WirelessDeviceStatistics {
	s.Id = &v
	return s
}

// SetLastUplinkReceivedAt sets the LastUplinkReceivedAt field's value.
func (s *WirelessDeviceStatistics) SetLastUplinkReceivedAt(v string) *WirelessDeviceStatistics {
	s.LastUplinkReceivedAt = &v
	return s
}

// SetLoRaWAN sets the LoRaWAN field's value.
func (s *WirelessDeviceStatistics) SetLoRaWAN(v *LoRaWANListDevice) *WirelessDeviceStatistics {
	s.LoRaWAN = v
	return s
}

// SetName sets the Name field's value.
func (s *WirelessDeviceStatistics) SetName(v string) *WirelessDeviceStatistics {
	s.Name = &v
	return s
}

// SetSidewalk sets the Sidewalk field's value.
func (s *WirelessDeviceStatistics) SetSidewalk(v *SidewalkListDevice) *WirelessDeviceStatistics {
	s.Sidewalk = v
	return s
}

// SetType sets the Type field's value.
func (s *WirelessDeviceStatistics) SetType(v string) *WirelessDeviceStatistics {
	s.Type = &v
	return s
}

// Information about a wireless gateway's operation.
type WirelessGatewayStatistics struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name of the resource.
	Arn *string `type:"string"`

	// The description of the resource.
	Description *string `type:"string"`

	// The ID of the wireless gateway reporting the data.
	Id *string `type:"string"`

	// The date and time when the most recent uplink was received.
	LastUplinkReceivedAt *string `type:"string"`

	// LoRaWAN gateway info.
	LoRaWAN *LoRaWANGateway `type:"structure"`

	// The name of the resource.
	Name *string `type:"string"`
}

// String returns the string representation
func (s WirelessGatewayStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WirelessGatewayStatistics) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *WirelessGatewayStatistics) SetArn(v string) *WirelessGatewayStatistics {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *WirelessGatewayStatistics) SetDescription(v string) *WirelessGatewayStatistics {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *WirelessGatewayStatistics) SetId(v string) *WirelessGatewayStatistics {
	s.Id = &v
	return s
}

// SetLastUplinkReceivedAt sets the LastUplinkReceivedAt field's value.
func (s *WirelessGatewayStatistics) SetLastUplinkReceivedAt(v string) *WirelessGatewayStatistics {
	s.LastUplinkReceivedAt = &v
	return s
}

// SetLoRaWAN sets the LoRaWAN field's value.
func (s *WirelessGatewayStatistics) SetLoRaWAN(v *LoRaWANGateway) *WirelessGatewayStatistics {
	s.LoRaWAN = v
	return s
}

// SetName sets the Name field's value.
func (s *WirelessGatewayStatistics) SetName(v string) *WirelessGatewayStatistics {
	s.Name = &v
	return s
}

// WirelessMetadata object.
type WirelessMetadata struct {
	_ struct{} `type:"structure"`

	// LoRaWAN device info.
	LoRaWAN *LoRaWANSendDataToDevice `type:"structure"`

	// The Sidewalk account credentials.
	Sidewalk *SidewalkSendDataToDevice `type:"structure"`
}

// String returns the string representation
func (s WirelessMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WirelessMetadata) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WirelessMetadata) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WirelessMetadata"}
	if s.LoRaWAN != nil {
		if err := s.LoRaWAN.Validate(); err != nil {
			invalidParams.AddNested("LoRaWAN", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLoRaWAN sets the LoRaWAN field's value.
func (s *WirelessMetadata) SetLoRaWAN(v *LoRaWANSendDataToDevice) *WirelessMetadata {
	s.LoRaWAN = v
	return s
}

// SetSidewalk sets the Sidewalk field's value.
func (s *WirelessMetadata) SetSidewalk(v *SidewalkSendDataToDevice) *WirelessMetadata {
	s.Sidewalk = v
	return s
}

// Sidewalk device battery level.
const (
	// BatteryLevelNormal is a BatteryLevel enum value
	BatteryLevelNormal = "normal"

	// BatteryLevelLow is a BatteryLevel enum value
	BatteryLevelLow = "low"

	// BatteryLevelCritical is a BatteryLevel enum value
	BatteryLevelCritical = "critical"
)

// BatteryLevel_Values returns all elements of the BatteryLevel enum
func BatteryLevel_Values() []string {
	return []string{
		BatteryLevelNormal,
		BatteryLevelLow,
		BatteryLevelCritical,
	}
}

const (
	// ConnectionStatusConnected is a ConnectionStatus enum value
	ConnectionStatusConnected = "Connected"

	// ConnectionStatusDisconnected is a ConnectionStatus enum value
	ConnectionStatusDisconnected = "Disconnected"
)

// ConnectionStatus_Values returns all elements of the ConnectionStatus enum
func ConnectionStatus_Values() []string {
	return []string{
		ConnectionStatusConnected,
		ConnectionStatusDisconnected,
	}
}

// Device state defines the device status of sidewalk device.
const (
	// DeviceStateProvisioned is a DeviceState enum value
	DeviceStateProvisioned = "Provisioned"

	// DeviceStateRegisteredNotSeen is a DeviceState enum value
	DeviceStateRegisteredNotSeen = "RegisteredNotSeen"

	// DeviceStateRegisteredReachable is a DeviceState enum value
	DeviceStateRegisteredReachable = "RegisteredReachable"

	// DeviceStateRegisteredUnreachable is a DeviceState enum value
	DeviceStateRegisteredUnreachable = "RegisteredUnreachable"
)

// DeviceState_Values returns all elements of the DeviceState enum
func DeviceState_Values() []string {
	return []string{
		DeviceStateProvisioned,
		DeviceStateRegisteredNotSeen,
		DeviceStateRegisteredReachable,
		DeviceStateRegisteredUnreachable,
	}
}

// Sidewalk device status notification.
const (
	// EventDiscovered is a Event enum value
	EventDiscovered = "discovered"

	// EventLost is a Event enum value
	EventLost = "lost"

	// EventAck is a Event enum value
	EventAck = "ack"

	// EventNack is a Event enum value
	EventNack = "nack"

	// EventPassthrough is a Event enum value
	EventPassthrough = "passthrough"
)

// Event_Values returns all elements of the Event enum
func Event_Values() []string {
	return []string{
		EventDiscovered,
		EventLost,
		EventAck,
		EventNack,
		EventPassthrough,
	}
}

const (
	// ExpressionTypeRuleName is a ExpressionType enum value
	ExpressionTypeRuleName = "RuleName"

	// ExpressionTypeMqttTopic is a ExpressionType enum value
	ExpressionTypeMqttTopic = "MqttTopic"
)

// ExpressionType_Values returns all elements of the ExpressionType enum
func ExpressionType_Values() []string {
	return []string{
		ExpressionTypeRuleName,
		ExpressionTypeMqttTopic,
	}
}

// Sidewalk device message type.
const (
	// MessageTypeCustomCommandIdNotify is a MessageType enum value
	MessageTypeCustomCommandIdNotify = "CUSTOM_COMMAND_ID_NOTIFY"

	// MessageTypeCustomCommandIdGet is a MessageType enum value
	MessageTypeCustomCommandIdGet = "CUSTOM_COMMAND_ID_GET"

	// MessageTypeCustomCommandIdSet is a MessageType enum value
	MessageTypeCustomCommandIdSet = "CUSTOM_COMMAND_ID_SET"

	// MessageTypeCustomCommandIdResp is a MessageType enum value
	MessageTypeCustomCommandIdResp = "CUSTOM_COMMAND_ID_RESP"
)

// MessageType_Values returns all elements of the MessageType enum
func MessageType_Values() []string {
	return []string{
		MessageTypeCustomCommandIdNotify,
		MessageTypeCustomCommandIdGet,
		MessageTypeCustomCommandIdSet,
		MessageTypeCustomCommandIdResp,
	}
}

const (
	// PartnerTypeSidewalk is a PartnerType enum value
	PartnerTypeSidewalk = "Sidewalk"
)

// PartnerType_Values returns all elements of the PartnerType enum
func PartnerType_Values() []string {
	return []string{
		PartnerTypeSidewalk,
	}
}

// The certificate chain algorithm provided by sidewalk.
const (
	// SigningAlgEd25519 is a SigningAlg enum value
	SigningAlgEd25519 = "Ed25519"

	// SigningAlgP256r1 is a SigningAlg enum value
	SigningAlgP256r1 = "P256r1"
)

// SigningAlg_Values returns all elements of the SigningAlg enum
func SigningAlg_Values() []string {
	return []string{
		SigningAlgEd25519,
		SigningAlgP256r1,
	}
}

const (
	// WirelessDeviceIdTypeWirelessDeviceId is a WirelessDeviceIdType enum value
	WirelessDeviceIdTypeWirelessDeviceId = "WirelessDeviceId"

	// WirelessDeviceIdTypeDevEui is a WirelessDeviceIdType enum value
	WirelessDeviceIdTypeDevEui = "DevEui"

	// WirelessDeviceIdTypeThingName is a WirelessDeviceIdType enum value
	WirelessDeviceIdTypeThingName = "ThingName"
)

// WirelessDeviceIdType_Values returns all elements of the WirelessDeviceIdType enum
func WirelessDeviceIdType_Values() []string {
	return []string{
		WirelessDeviceIdTypeWirelessDeviceId,
		WirelessDeviceIdTypeDevEui,
		WirelessDeviceIdTypeThingName,
	}
}

const (
	// WirelessDeviceTypeSidewalk is a WirelessDeviceType enum value
	WirelessDeviceTypeSidewalk = "Sidewalk"

	// WirelessDeviceTypeLoRaWan is a WirelessDeviceType enum value
	WirelessDeviceTypeLoRaWan = "LoRaWAN"
)

// WirelessDeviceType_Values returns all elements of the WirelessDeviceType enum
func WirelessDeviceType_Values() []string {
	return []string{
		WirelessDeviceTypeSidewalk,
		WirelessDeviceTypeLoRaWan,
	}
}

const (
	// WirelessGatewayIdTypeGatewayEui is a WirelessGatewayIdType enum value
	WirelessGatewayIdTypeGatewayEui = "GatewayEui"

	// WirelessGatewayIdTypeWirelessGatewayId is a WirelessGatewayIdType enum value
	WirelessGatewayIdTypeWirelessGatewayId = "WirelessGatewayId"

	// WirelessGatewayIdTypeThingName is a WirelessGatewayIdType enum value
	WirelessGatewayIdTypeThingName = "ThingName"
)

// WirelessGatewayIdType_Values returns all elements of the WirelessGatewayIdType enum
func WirelessGatewayIdType_Values() []string {
	return []string{
		WirelessGatewayIdTypeGatewayEui,
		WirelessGatewayIdTypeWirelessGatewayId,
		WirelessGatewayIdTypeThingName,
	}
}

const (
	// WirelessGatewayServiceTypeCups is a WirelessGatewayServiceType enum value
	WirelessGatewayServiceTypeCups = "CUPS"

	// WirelessGatewayServiceTypeLns is a WirelessGatewayServiceType enum value
	WirelessGatewayServiceTypeLns = "LNS"
)

// WirelessGatewayServiceType_Values returns all elements of the WirelessGatewayServiceType enum
func WirelessGatewayServiceType_Values() []string {
	return []string{
		WirelessGatewayServiceTypeCups,
		WirelessGatewayServiceTypeLns,
	}
}

const (
	// WirelessGatewayTaskDefinitionTypeUpdate is a WirelessGatewayTaskDefinitionType enum value
	WirelessGatewayTaskDefinitionTypeUpdate = "UPDATE"
)

// WirelessGatewayTaskDefinitionType_Values returns all elements of the WirelessGatewayTaskDefinitionType enum
func WirelessGatewayTaskDefinitionType_Values() []string {
	return []string{
		WirelessGatewayTaskDefinitionTypeUpdate,
	}
}

const (
	// WirelessGatewayTaskStatusPending is a WirelessGatewayTaskStatus enum value
	WirelessGatewayTaskStatusPending = "PENDING"

	// WirelessGatewayTaskStatusInProgress is a WirelessGatewayTaskStatus enum value
	WirelessGatewayTaskStatusInProgress = "IN_PROGRESS"

	// WirelessGatewayTaskStatusFirstRetry is a WirelessGatewayTaskStatus enum value
	WirelessGatewayTaskStatusFirstRetry = "FIRST_RETRY"

	// WirelessGatewayTaskStatusSecondRetry is a WirelessGatewayTaskStatus enum value
	WirelessGatewayTaskStatusSecondRetry = "SECOND_RETRY"

	// WirelessGatewayTaskStatusCompleted is a WirelessGatewayTaskStatus enum value
	WirelessGatewayTaskStatusCompleted = "COMPLETED"

	// WirelessGatewayTaskStatusFailed is a WirelessGatewayTaskStatus enum value
	WirelessGatewayTaskStatusFailed = "FAILED"
)

// WirelessGatewayTaskStatus_Values returns all elements of the WirelessGatewayTaskStatus enum
func WirelessGatewayTaskStatus_Values() []string {
	return []string{
		WirelessGatewayTaskStatusPending,
		WirelessGatewayTaskStatusInProgress,
		WirelessGatewayTaskStatusFirstRetry,
		WirelessGatewayTaskStatusSecondRetry,
		WirelessGatewayTaskStatusCompleted,
		WirelessGatewayTaskStatusFailed,
	}
}
