// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package components

import (
	"errors"
	"fmt"
	"github.com/censys/censys-sdk-go/internal/utils"
)

type HostnamePort struct {
	// Hostname to scan
	Hostname string `json:"hostname"`
	// Port number to scan
	Port int `json:"port"`
}

func (o *HostnamePort) GetHostname() string {
	if o == nil {
		return ""
	}
	return o.Hostname
}

func (o *HostnamePort) GetPort() int {
	if o == nil {
		return 0
	}
	return o.Port
}

// Target2 - Discovery scan against hostname:PORT
type Target2 struct {
	HostnamePort HostnamePort `json:"hostname_port"`
}

func (o *Target2) GetHostnamePort() HostnamePort {
	if o == nil {
		return HostnamePort{}
	}
	return o.HostnamePort
}

type HostPort struct {
	// IP address to scan
	IP string `json:"ip"`
	// Port number to scan
	Port int `json:"port"`
}

func (o *HostPort) GetIP() string {
	if o == nil {
		return ""
	}
	return o.IP
}

func (o *HostPort) GetPort() int {
	if o == nil {
		return 0
	}
	return o.Port
}

// Target1 - Discovery scan against IP:PORT
type Target1 struct {
	HostPort HostPort `json:"host_port"`
}

func (o *Target1) GetHostPort() HostPort {
	if o == nil {
		return HostPort{}
	}
	return o.HostPort
}

type ScansDiscoveryInputBodyTargetType string

const (
	ScansDiscoveryInputBodyTargetTypeTarget1 ScansDiscoveryInputBodyTargetType = "target_1"
	ScansDiscoveryInputBodyTargetTypeTarget2 ScansDiscoveryInputBodyTargetType = "target_2"
)

type ScansDiscoveryInputBodyTarget struct {
	Target1 *Target1 `queryParam:"inline"`
	Target2 *Target2 `queryParam:"inline"`

	Type ScansDiscoveryInputBodyTargetType
}

func CreateScansDiscoveryInputBodyTargetTarget1(target1 Target1) ScansDiscoveryInputBodyTarget {
	typ := ScansDiscoveryInputBodyTargetTypeTarget1

	return ScansDiscoveryInputBodyTarget{
		Target1: &target1,
		Type:    typ,
	}
}

func CreateScansDiscoveryInputBodyTargetTarget2(target2 Target2) ScansDiscoveryInputBodyTarget {
	typ := ScansDiscoveryInputBodyTargetTypeTarget2

	return ScansDiscoveryInputBodyTarget{
		Target2: &target2,
		Type:    typ,
	}
}

func (u *ScansDiscoveryInputBodyTarget) UnmarshalJSON(data []byte) error {

	var target1 Target1 = Target1{}
	if err := utils.UnmarshalJSON(data, &target1, "", true, true); err == nil {
		u.Target1 = &target1
		u.Type = ScansDiscoveryInputBodyTargetTypeTarget1
		return nil
	}

	var target2 Target2 = Target2{}
	if err := utils.UnmarshalJSON(data, &target2, "", true, true); err == nil {
		u.Target2 = &target2
		u.Type = ScansDiscoveryInputBodyTargetTypeTarget2
		return nil
	}

	return fmt.Errorf("could not unmarshal `%s` into any supported union types for ScansDiscoveryInputBodyTarget", string(data))
}

func (u ScansDiscoveryInputBodyTarget) MarshalJSON() ([]byte, error) {
	if u.Target1 != nil {
		return utils.MarshalJSON(u.Target1, "", true)
	}

	if u.Target2 != nil {
		return utils.MarshalJSON(u.Target2, "", true)
	}

	return nil, errors.New("could not marshal union type ScansDiscoveryInputBodyTarget: all fields are null")
}

type ScansDiscoveryInputBody struct {
	Target ScansDiscoveryInputBodyTarget `json:"target"`
}

func (o *ScansDiscoveryInputBody) GetTarget() ScansDiscoveryInputBodyTarget {
	if o == nil {
		return ScansDiscoveryInputBodyTarget{}
	}
	return o.Target
}
