// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        (unknown)
// source: coinbase/cloud/mpc_wallets/v1/mpc_wallets.proto

package v1

import (
	v1 "github.com/coinbase/waas-client-library-go/gen/go/coinbase/cloud/blockchain/v1"
	_ "github.com/grpc-ecosystem/grpc-gateway/v2/protoc-gen-openapiv2/options"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The MPCWallet resource, which represents a collection of on-chain Addresses and their
// backing MPCKeys.
type MPCWallet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the MPCWallet.
	// Format: pools/{pool_id}/mpcWallets/{mpc_wallet_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The resource name of the MPCKeyService DeviceGroup associated with this MPCWallet.
	// The DeviceGroup performs the underlying MPC operations.
	// Format: pools/{pool_id}/deviceGroups/{device_group_id}
	DeviceGroup string `protobuf:"bytes,2,opt,name=device_group,json=deviceGroup,proto3" json:"device_group,omitempty"`
}

func (x *MPCWallet) Reset() {
	*x = MPCWallet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MPCWallet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MPCWallet) ProtoMessage() {}

func (x *MPCWallet) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MPCWallet.ProtoReflect.Descriptor instead.
func (*MPCWallet) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_rawDescGZIP(), []int{0}
}

func (x *MPCWallet) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *MPCWallet) GetDeviceGroup() string {
	if x != nil {
		return x.DeviceGroup
	}
	return ""
}

// The Address resource, which represents an on-chain Address backed by an MPCKey
// in an MPCWallet.
type Address struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the Address. The resource ID of the Address is
	// equal to the address field.
	// Format: networks/{network_id}/addresses/{address_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The address value - for example, a 0x-prefixed checksummed hexadecimal string.
	// This is equal to the resource ID of the Address.
	Address string `protobuf:"bytes,2,opt,name=address,proto3" json:"address,omitempty"`
	// The resource names of the MPCKeys that back this Address.
	// For EVM networks, there will be only one MPCKey.
	// Format: pools/{pool_id}/deviceGroups/{device_group_id}/mpcKeys/{mpc_key_id}
	MpcKeys []string `protobuf:"bytes,3,rep,name=mpc_keys,json=mpcKeys,proto3" json:"mpc_keys,omitempty"`
	// The resource name of the MPCWallet to which this Address belongs.
	// Format: pools/{pool}/mpcWallets/{mpcWallet}
	MpcWallet string `protobuf:"bytes,4,opt,name=mpc_wallet,json=mpcWallet,proto3" json:"mpc_wallet,omitempty"`
}

func (x *Address) Reset() {
	*x = Address{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Address) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Address) ProtoMessage() {}

func (x *Address) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Address.ProtoReflect.Descriptor instead.
func (*Address) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_rawDescGZIP(), []int{1}
}

func (x *Address) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Address) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *Address) GetMpcKeys() []string {
	if x != nil {
		return x.MpcKeys
	}
	return nil
}

func (x *Address) GetMpcWallet() string {
	if x != nil {
		return x.MpcWallet
	}
	return ""
}

// The Balance resource, which represents an amount of an Asset held on-chain by an Address.
type Balance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the Balance.
	// Format: networks/{network_id}/addresses/{address_id}/balances/{balance_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The resource name of the Asset to which this Balance corresponds.
	// Format: networks/{network}/assets/{asset}
	Asset string `protobuf:"bytes,2,opt,name=asset,proto3" json:"asset,omitempty"`
	// The amount of the asset. For native assets or ERC-20 contracts, this is presented in terms of
	// atomic units (e.g., Wei for Ether) as a base-10 number. For ERC-721 and ERC-1155 contracts, it
	// is the count of distinct token IDs held by address.
	Amount string `protobuf:"bytes,3,opt,name=amount,proto3" json:"amount,omitempty"`
	// The resource name of the MPCWallet to which this Balance belongs.
	// Format: pools/{pool}/mpcWallets/{mpcWallet}
	MpcWallet string `protobuf:"bytes,4,opt,name=mpc_wallet,json=mpcWallet,proto3" json:"mpc_wallet,omitempty"`
}

func (x *Balance) Reset() {
	*x = Balance{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Balance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Balance) ProtoMessage() {}

func (x *Balance) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Balance.ProtoReflect.Descriptor instead.
func (*Balance) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_rawDescGZIP(), []int{2}
}

func (x *Balance) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Balance) GetAsset() string {
	if x != nil {
		return x.Asset
	}
	return ""
}

func (x *Balance) GetAmount() string {
	if x != nil {
		return x.Amount
	}
	return ""
}

func (x *Balance) GetMpcWallet() string {
	if x != nil {
		return x.MpcWallet
	}
	return ""
}

// The BalanceDetail resource, which enumerates the specific tokens held which compose a Balance.
type BalanceDetail struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the BalanceDetail.
	// Format: networks/{network_id}/addresses/{address_id}/balances/{balance_id}/balanceDetails/{balance_detail_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The resource name of the Asset to which the parent Balance corresponds.
	// Format: networks/{network}/assets/{asset}
	Asset string `protobuf:"bytes,2,opt,name=asset,proto3" json:"asset,omitempty"`
	// The amount of the BalanceDetail as a base-10 number.
	// For a BalanceDetail for a native Balance or ERC-20 Balance, this is denominated in atomic units of the asset.
	Amount string `protobuf:"bytes,3,opt,name=amount,proto3" json:"amount,omitempty"`
	// The asset definition which can be used to identify what token the amount corresponds to.
	//
	// A BalanceDetail for a native Balance will only have the asset_type field set ("native").
	// A BalanceDetail for an ERC-20 Balance will only have the asset_type ("erc20") and asset_group_id (contract address) fields set.
	// A BalanceDetail for an ERC-721 Balance or ERC-1155 Balance will have the asset_type ("erc721" or "erc1155"),
	// asset_group_id (contract address), and sub_group_id (token ID) fields set.
	AssetDefinition *v1.Asset_Definition `protobuf:"bytes,4,opt,name=asset_definition,json=assetDefinition,proto3" json:"asset_definition,omitempty"`
	// The resource name of the MPCWallet to which the parent Balance belongs.
	// Format: pools/{pool}/mpcWallets/{mpcWallet}
	MpcWallet string `protobuf:"bytes,5,opt,name=mpc_wallet,json=mpcWallet,proto3" json:"mpc_wallet,omitempty"`
}

func (x *BalanceDetail) Reset() {
	*x = BalanceDetail{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BalanceDetail) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BalanceDetail) ProtoMessage() {}

func (x *BalanceDetail) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BalanceDetail.ProtoReflect.Descriptor instead.
func (*BalanceDetail) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_rawDescGZIP(), []int{3}
}

func (x *BalanceDetail) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *BalanceDetail) GetAsset() string {
	if x != nil {
		return x.Asset
	}
	return ""
}

func (x *BalanceDetail) GetAmount() string {
	if x != nil {
		return x.Amount
	}
	return ""
}

func (x *BalanceDetail) GetAssetDefinition() *v1.Asset_Definition {
	if x != nil {
		return x.AssetDefinition
	}
	return nil
}

func (x *BalanceDetail) GetMpcWallet() string {
	if x != nil {
		return x.MpcWallet
	}
	return ""
}

// The request message for CreateMPCWallet.
type CreateMPCWalletRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the parent Pool.
	// Format: pools/{pool_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The MPCWallet to be created. This should be blank.
	MpcWallet *MPCWallet `protobuf:"bytes,2,opt,name=mpc_wallet,json=mpcWallet,proto3" json:"mpc_wallet,omitempty"`
	// The resource name of the Device that will initially be the sole member of the underlying
	// DeviceGroup. This Device should have already been registered using MPCKeyService's
	// RegisterDevice.
	// Format: devices/{device_id}
	Device string `protobuf:"bytes,3,opt,name=device,proto3" json:"device,omitempty"`
	// A user-provided request ID to allow for idempotency. This should be a UUID.
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateMPCWalletRequest) Reset() {
	*x = CreateMPCWalletRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateMPCWalletRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateMPCWalletRequest) ProtoMessage() {}

func (x *CreateMPCWalletRequest) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateMPCWalletRequest.ProtoReflect.Descriptor instead.
func (*CreateMPCWalletRequest) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_rawDescGZIP(), []int{4}
}

func (x *CreateMPCWalletRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateMPCWalletRequest) GetMpcWallet() *MPCWallet {
	if x != nil {
		return x.MpcWallet
	}
	return nil
}

func (x *CreateMPCWalletRequest) GetDevice() string {
	if x != nil {
		return x.Device
	}
	return ""
}

func (x *CreateMPCWalletRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Metadata associated with the CreateMPCWallet long-running operation.
type CreateMPCWalletMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the DeviceGroup to poll for using ListMPCOperations.
	// Format: pools/{pool_id}/deviceGroups/{device_group_id}
	DeviceGroup string `protobuf:"bytes,1,opt,name=device_group,json=deviceGroup,proto3" json:"device_group,omitempty"`
}

func (x *CreateMPCWalletMetadata) Reset() {
	*x = CreateMPCWalletMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateMPCWalletMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateMPCWalletMetadata) ProtoMessage() {}

func (x *CreateMPCWalletMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateMPCWalletMetadata.ProtoReflect.Descriptor instead.
func (*CreateMPCWalletMetadata) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_rawDescGZIP(), []int{5}
}

func (x *CreateMPCWalletMetadata) GetDeviceGroup() string {
	if x != nil {
		return x.DeviceGroup
	}
	return ""
}

// The request message for GetMPCWallet.
type GetMPCWalletRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the MPCWallet.
	// Format: pools/{pool_id}/mpcWallets/{mpc_wallet_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetMPCWalletRequest) Reset() {
	*x = GetMPCWalletRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetMPCWalletRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMPCWalletRequest) ProtoMessage() {}

func (x *GetMPCWalletRequest) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMPCWalletRequest.ProtoReflect.Descriptor instead.
func (*GetMPCWalletRequest) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_rawDescGZIP(), []int{6}
}

func (x *GetMPCWalletRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for ListMPCWallets.
type ListMPCWalletsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the parent Pool.
	// Format: pools/{pool_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of MPCWallets to return. The default is 50.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous ListMPCWallets call.
	// Provide this to retrieve the subsequent page.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListMPCWalletsRequest) Reset() {
	*x = ListMPCWalletsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListMPCWalletsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMPCWalletsRequest) ProtoMessage() {}

func (x *ListMPCWalletsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMPCWalletsRequest.ProtoReflect.Descriptor instead.
func (*ListMPCWalletsRequest) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_rawDescGZIP(), []int{7}
}

func (x *ListMPCWalletsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListMPCWalletsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListMPCWalletsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response message for ListMPCWallets.
type ListMPCWalletsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of MPCWallets.
	MpcWallets []*MPCWallet `protobuf:"bytes,1,rep,name=mpc_wallets,json=mpcWallets,proto3" json:"mpc_wallets,omitempty"`
	// A token, which can be sent as page_token to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListMPCWalletsResponse) Reset() {
	*x = ListMPCWalletsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListMPCWalletsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMPCWalletsResponse) ProtoMessage() {}

func (x *ListMPCWalletsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMPCWalletsResponse.ProtoReflect.Descriptor instead.
func (*ListMPCWalletsResponse) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_rawDescGZIP(), []int{8}
}

func (x *ListMPCWalletsResponse) GetMpcWallets() []*MPCWallet {
	if x != nil {
		return x.MpcWallets
	}
	return nil
}

func (x *ListMPCWalletsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request message for GenerateAddress.
type GenerateAddressRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the MPCWallet within which to generate the Address.
	// Format: pools/{pool_id}/mpcWallets/{mpc_wallet_id}
	MpcWallet string `protobuf:"bytes,1,opt,name=mpc_wallet,json=mpcWallet,proto3" json:"mpc_wallet,omitempty"`
	// The resource name of the Network for which to generate the Address.
	// Format: networks/{network_id}
	Network string `protobuf:"bytes,2,opt,name=network,proto3" json:"network,omitempty"`
	// A user-provided request ID to allow for idempotency. This should be a UUID.
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *GenerateAddressRequest) Reset() {
	*x = GenerateAddressRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateAddressRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateAddressRequest) ProtoMessage() {}

func (x *GenerateAddressRequest) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateAddressRequest.ProtoReflect.Descriptor instead.
func (*GenerateAddressRequest) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_rawDescGZIP(), []int{9}
}

func (x *GenerateAddressRequest) GetMpcWallet() string {
	if x != nil {
		return x.MpcWallet
	}
	return ""
}

func (x *GenerateAddressRequest) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *GenerateAddressRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// The request message for GetAddress.
type GetAddressRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the Address.
	// Format: networks/{network_id}/addresses/{address_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAddressRequest) Reset() {
	*x = GetAddressRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAddressRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAddressRequest) ProtoMessage() {}

func (x *GetAddressRequest) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAddressRequest.ProtoReflect.Descriptor instead.
func (*GetAddressRequest) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_rawDescGZIP(), []int{10}
}

func (x *GetAddressRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for ListAddresses.
type ListAddressesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the parent Network.
	// Format: networks/{network_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The resource name of the MPCWallet to which the Addresses belong.
	// Format: pools/{pool_id}/mpcWallets/{mpc_wallet_id}
	MpcWallet string `protobuf:"bytes,2,opt,name=mpc_wallet,json=mpcWallet,proto3" json:"mpc_wallet,omitempty"`
	// The maximum number of Addresses to return. The default is 50.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous ListAddresses call.
	// Provide this to retrieve the subsequent page.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListAddressesRequest) Reset() {
	*x = ListAddressesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAddressesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAddressesRequest) ProtoMessage() {}

func (x *ListAddressesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAddressesRequest.ProtoReflect.Descriptor instead.
func (*ListAddressesRequest) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_rawDescGZIP(), []int{11}
}

func (x *ListAddressesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAddressesRequest) GetMpcWallet() string {
	if x != nil {
		return x.MpcWallet
	}
	return ""
}

func (x *ListAddressesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAddressesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response message for ListAddresses.
type ListAddressesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Addresses.
	Addresses []*Address `protobuf:"bytes,1,rep,name=addresses,proto3" json:"addresses,omitempty"`
	// A token, which can be sent as page_token to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAddressesResponse) Reset() {
	*x = ListAddressesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAddressesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAddressesResponse) ProtoMessage() {}

func (x *ListAddressesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAddressesResponse.ProtoReflect.Descriptor instead.
func (*ListAddressesResponse) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_rawDescGZIP(), []int{12}
}

func (x *ListAddressesResponse) GetAddresses() []*Address {
	if x != nil {
		return x.Addresses
	}
	return nil
}

func (x *ListAddressesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request message for ListBalances.
type ListBalancesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the parent Address.
	// Format: networks/{network_id}/addresses/{address_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of Balances to return. If unspecified, at most 25 Balances
	// will be returned.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous ListBalances call.
	// Provide this to retrieve the subsequent page.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListBalancesRequest) Reset() {
	*x = ListBalancesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBalancesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBalancesRequest) ProtoMessage() {}

func (x *ListBalancesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBalancesRequest.ProtoReflect.Descriptor instead.
func (*ListBalancesRequest) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_rawDescGZIP(), []int{13}
}

func (x *ListBalancesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListBalancesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListBalancesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response message for ListBalances.
type ListBalancesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Balances.
	Balances []*Balance `protobuf:"bytes,1,rep,name=balances,proto3" json:"balances,omitempty"`
	// A token, which can be sent as page_token to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListBalancesResponse) Reset() {
	*x = ListBalancesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBalancesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBalancesResponse) ProtoMessage() {}

func (x *ListBalancesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBalancesResponse.ProtoReflect.Descriptor instead.
func (*ListBalancesResponse) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_rawDescGZIP(), []int{14}
}

func (x *ListBalancesResponse) GetBalances() []*Balance {
	if x != nil {
		return x.Balances
	}
	return nil
}

func (x *ListBalancesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request message for ListBalanceDetails.
type ListBalanceDetailsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the parent Balance.
	// Format: networks/{network_id}/addresses/{address_id}/balances/{balance_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of BalanceDetails to return. If unspecified, at most 25 BalanceDetails
	// will be returned.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous ListBalanceDetails call.
	// Provide this to retrieve the subsequent page.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListBalanceDetailsRequest) Reset() {
	*x = ListBalanceDetailsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBalanceDetailsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBalanceDetailsRequest) ProtoMessage() {}

func (x *ListBalanceDetailsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBalanceDetailsRequest.ProtoReflect.Descriptor instead.
func (*ListBalanceDetailsRequest) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_rawDescGZIP(), []int{15}
}

func (x *ListBalanceDetailsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListBalanceDetailsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListBalanceDetailsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response message for ListBalanceDetails.
type ListBalanceDetailsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of balance details.
	BalanceDetails []*BalanceDetail `protobuf:"bytes,1,rep,name=balance_details,json=balanceDetails,proto3" json:"balance_details,omitempty"`
	// A token, which can be sent as page_token to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListBalanceDetailsResponse) Reset() {
	*x = ListBalanceDetailsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBalanceDetailsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBalanceDetailsResponse) ProtoMessage() {}

func (x *ListBalanceDetailsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBalanceDetailsResponse.ProtoReflect.Descriptor instead.
func (*ListBalanceDetailsResponse) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_rawDescGZIP(), []int{16}
}

func (x *ListBalanceDetailsResponse) GetBalanceDetails() []*BalanceDetail {
	if x != nil {
		return x.BalanceDetails
	}
	return nil
}

func (x *ListBalanceDetailsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

var File_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto protoreflect.FileDescriptor

var file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_rawDesc = []byte{
	0x0a, 0x2f, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x6d, 0x70, 0x63, 0x5f, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x73, 0x2f, 0x76, 0x31, 0x2f,
	0x6d, 0x70, 0x63, 0x5f, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x1d, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x70, 0x63, 0x5f, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x1a, 0x2d, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x2f, 0x76, 0x31, 0x2f, 0x62,
	0x6c, 0x6f, 0x63, 0x6b, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x2d,
	0x67, 0x65, 0x6e, 0x2d, 0x6f, 0x70, 0x65, 0x6e, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x6f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc2, 0x06, 0x0a, 0x09, 0x4d, 0x50, 0x43, 0x57,
	0x61, 0x6c, 0x6c, 0x65, 0x74, 0x12, 0xd9, 0x01, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0xc4, 0x01, 0x92, 0x41, 0xbc, 0x01, 0x2a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x32, 0x56, 0x54, 0x68, 0x65, 0x20, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x20,
	0x6e, 0x61, 0x6d, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4d, 0x50, 0x43, 0x57,
	0x61, 0x6c, 0x6c, 0x65, 0x74, 0x2e, 0x0a, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x3a, 0x20, 0x70,
	0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x7b, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6d,
	0x70, 0x63, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x6d, 0x70, 0x63, 0x5f, 0x77,
	0x61, 0x6c, 0x6c, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x4a, 0x5c, 0x22, 0x70, 0x6f, 0x6f, 0x6c,
	0x73, 0x2f, 0x39, 0x35, 0x32, 0x35, 0x37, 0x63, 0x35, 0x61, 0x2d, 0x35, 0x32, 0x32, 0x66, 0x2d,
	0x34, 0x32, 0x34, 0x31, 0x2d, 0x62, 0x66, 0x39, 0x37, 0x2d, 0x32, 0x36, 0x35, 0x36, 0x61, 0x38,
	0x65, 0x39, 0x63, 0x63, 0x39, 0x31, 0x2f, 0x6d, 0x70, 0x63, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74,
	0x73, 0x2f, 0x64, 0x32, 0x38, 0x31, 0x39, 0x37, 0x65, 0x38, 0x2d, 0x33, 0x37, 0x32, 0x63, 0x2d,
	0x34, 0x36, 0x31, 0x63, 0x2d, 0x39, 0x61, 0x30, 0x30, 0x2d, 0x32, 0x64, 0x61, 0x33, 0x63, 0x35,
	0x32, 0x38, 0x63, 0x32, 0x64, 0x31, 0x22, 0xe2, 0x41, 0x01, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x88, 0x03, 0x0a, 0x0c, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0xe4, 0x02, 0x92, 0x41, 0xb1, 0x02, 0x2a,
	0x0b, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x32, 0xc1, 0x01, 0x54,
	0x68, 0x65, 0x20, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65,
	0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4d, 0x50, 0x43, 0x4b, 0x65, 0x79, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x20, 0x61, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x65, 0x64, 0x20, 0x77, 0x69, 0x74,
	0x68, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x4d, 0x50, 0x43, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74,
	0x2e, 0x20, 0x54, 0x68, 0x65, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x20, 0x70, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20, 0x75,
	0x6e, 0x64, 0x65, 0x72, 0x6c, 0x79, 0x69, 0x6e, 0x67, 0x20, 0x4d, 0x50, 0x43, 0x20, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x20, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x3a, 0x20, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x7b, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x69, 0x64,
	0x7d, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x7b,
	0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x7d,
	0x4a, 0x5e, 0x22, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x39, 0x35, 0x32, 0x35, 0x37, 0x63, 0x35,
	0x61, 0x2d, 0x35, 0x32, 0x32, 0x66, 0x2d, 0x34, 0x32, 0x34, 0x31, 0x2d, 0x62, 0x66, 0x39, 0x37,
	0x2d, 0x32, 0x36, 0x35, 0x36, 0x61, 0x38, 0x65, 0x39, 0x63, 0x63, 0x39, 0x31, 0x2f, 0x64, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x33, 0x61, 0x31, 0x36, 0x38,
	0x61, 0x35, 0x34, 0x2d, 0x36, 0x36, 0x36, 0x31, 0x2d, 0x34, 0x65, 0x35, 0x61, 0x2d, 0x38, 0x62,
	0x63, 0x35, 0x2d, 0x39, 0x37, 0x35, 0x39, 0x36, 0x37, 0x31, 0x61, 0x61, 0x37, 0x37, 0x37, 0x22,
	0xe2, 0x41, 0x01, 0x03, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x61, 0x70, 0x69, 0x2e, 0x64, 0x65, 0x76,
	0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52,
	0x0b, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x3a, 0xcd, 0x01, 0x92,
	0x41, 0x75, 0x0a, 0x73, 0x2a, 0x09, 0x4d, 0x50, 0x43, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x32,
	0x66, 0x54, 0x68, 0x65, 0x20, 0x4d, 0x50, 0x43, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x20, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2c, 0x20, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x72,
	0x65, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x73, 0x20, 0x61, 0x20, 0x63, 0x6f, 0x6c, 0x6c,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20, 0x6f, 0x6e, 0x2d, 0x63, 0x68, 0x61,
	0x69, 0x6e, 0x20, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x20, 0x61, 0x6e, 0x64,
	0x20, 0x74, 0x68, 0x65, 0x69, 0x72, 0x20, 0x62, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x20, 0x4d,
	0x50, 0x43, 0x4b, 0x65, 0x79, 0x73, 0x2e, 0xea, 0x41, 0x52, 0x0a, 0x24, 0x61, 0x70, 0x69, 0x2e,
	0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61,
	0x73, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x50, 0x43, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74,
	0x12, 0x2a, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x7b, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x69, 0x64,
	0x7d, 0x2f, 0x6d, 0x70, 0x63, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x6d, 0x70,
	0x63, 0x5f, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x22, 0xc8, 0x0a, 0x0a,
	0x07, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0xcc, 0x01, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0xb7, 0x01, 0x92, 0x41, 0xaf, 0x01, 0x2a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x32, 0x56, 0x54, 0x68, 0x65, 0x20, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x41,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x2e, 0x0a, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x3a, 0x20,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x7b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x2f,
	0x7b, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x69, 0x64, 0x7d, 0x4a, 0x4f, 0x22, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x65, 0x74, 0x68, 0x65, 0x72, 0x65, 0x75, 0x6d,
	0x2d, 0x67, 0x6f, 0x65, 0x72, 0x6c, 0x69, 0x2f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65,
	0x73, 0x2f, 0x30, 0x78, 0x44, 0x41, 0x46, 0x45, 0x41, 0x34, 0x39, 0x32, 0x44, 0x39, 0x63, 0x36,
	0x37, 0x33, 0x33, 0x61, 0x65, 0x33, 0x64, 0x35, 0x36, 0x62, 0x37, 0x45, 0x64, 0x31, 0x41, 0x44,
	0x42, 0x36, 0x30, 0x36, 0x39, 0x32, 0x63, 0x39, 0x38, 0x42, 0x63, 0x35, 0x22, 0xe2, 0x41, 0x01,
	0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xda, 0x01, 0x0a, 0x07, 0x61, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0xbf, 0x01, 0x92, 0x41, 0xb7, 0x01,
	0x2a, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x32, 0x7f, 0x54, 0x68, 0x65, 0x20, 0x61,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x20, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x2d, 0x20, 0x66,
	0x6f, 0x72, 0x20, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x2c, 0x20, 0x61, 0x20, 0x30, 0x78,
	0x2d, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x65, 0x64, 0x20, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x73,
	0x75, 0x6d, 0x6d, 0x65, 0x64, 0x20, 0x68, 0x65, 0x78, 0x61, 0x64, 0x65, 0x63, 0x69, 0x6d, 0x61,
	0x6c, 0x20, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x20, 0x54, 0x68, 0x69, 0x73, 0x20, 0x69,
	0x73, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x20, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x20, 0x49, 0x44, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68,
	0x65, 0x20, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x2e, 0x4a, 0x2b, 0x22, 0x30, 0x78, 0x44,
	0x41, 0x46, 0x45, 0x41, 0x34, 0x39, 0x32, 0x44, 0x39, 0x63, 0x36, 0x37, 0x33, 0x33, 0x61, 0x65,
	0x33, 0x64, 0x35, 0x36, 0x62, 0x37, 0x45, 0x64, 0x31, 0x41, 0x44, 0x42, 0x36, 0x30, 0x36, 0x39,
	0x32, 0x63, 0x39, 0x38, 0x42, 0x63, 0x22, 0xe2, 0x41, 0x01, 0x03, 0x52, 0x07, 0x61, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x12, 0x9d, 0x03, 0x0a, 0x08, 0x6d, 0x70, 0x63, 0x5f, 0x6b, 0x65, 0x79,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x81, 0x03, 0x92, 0x41, 0xd3, 0x02, 0x2a, 0x07,
	0x6d, 0x70, 0x63, 0x4b, 0x65, 0x79, 0x73, 0x32, 0xb7, 0x01, 0x54, 0x68, 0x65, 0x20, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x20, 0x6f, 0x66, 0x20,
	0x74, 0x68, 0x65, 0x20, 0x4d, 0x50, 0x43, 0x4b, 0x65, 0x79, 0x73, 0x20, 0x74, 0x68, 0x61, 0x74,
	0x20, 0x62, 0x61, 0x63, 0x6b, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x41, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x2e, 0x20, 0x46, 0x6f, 0x72, 0x20, 0x45, 0x56, 0x4d, 0x20, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x73, 0x2c, 0x20, 0x74, 0x68, 0x65, 0x72, 0x65, 0x20, 0x77, 0x69, 0x6c, 0x6c,
	0x20, 0x62, 0x65, 0x20, 0x6f, 0x6e, 0x6c, 0x79, 0x20, 0x6f, 0x6e, 0x65, 0x20, 0x4d, 0x50, 0x43,
	0x4b, 0x65, 0x79, 0x2e, 0x0a, 0x20, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x3a, 0x20, 0x70, 0x6f,
	0x6f, 0x6c, 0x73, 0x2f, 0x7b, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x64, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x7b, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6d, 0x70, 0x63,
	0x4b, 0x65, 0x79, 0x73, 0x2f, 0x7b, 0x6d, 0x70, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x69, 0x64,
	0x7d, 0x4a, 0x8d, 0x01, 0x5b, 0x22, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x39, 0x35, 0x32, 0x35,
	0x37, 0x63, 0x35, 0x61, 0x2d, 0x35, 0x32, 0x32, 0x66, 0x2d, 0x34, 0x32, 0x34, 0x31, 0x2d, 0x62,
	0x66, 0x39, 0x37, 0x2d, 0x32, 0x36, 0x35, 0x36, 0x61, 0x38, 0x65, 0x39, 0x63, 0x63, 0x39, 0x31,
	0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x33, 0x61,
	0x31, 0x36, 0x38, 0x61, 0x35, 0x34, 0x2d, 0x36, 0x36, 0x36, 0x31, 0x2d, 0x34, 0x65, 0x35, 0x61,
	0x2d, 0x38, 0x62, 0x63, 0x35, 0x2d, 0x39, 0x37, 0x35, 0x39, 0x36, 0x37, 0x31, 0x61, 0x61, 0x37,
	0x37, 0x37, 0x2f, 0x6d, 0x70, 0x63, 0x4b, 0x65, 0x79, 0x73, 0x2f, 0x64, 0x32, 0x38, 0x62, 0x39,
	0x34, 0x36, 0x62, 0x2d, 0x35, 0x33, 0x33, 0x62, 0x2d, 0x34, 0x36, 0x36, 0x65, 0x2d, 0x62, 0x62,
	0x36, 0x31, 0x2d, 0x39, 0x31, 0x64, 0x39, 0x33, 0x38, 0x37, 0x34, 0x33, 0x38, 0x35, 0x38, 0x22,
	0x5d, 0xe2, 0x41, 0x01, 0x03, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x61, 0x70, 0x69, 0x2e, 0x64, 0x65,
	0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x50, 0x43, 0x4b, 0x65, 0x79, 0x52, 0x07, 0x6d, 0x70, 0x63,
	0x4b, 0x65, 0x79, 0x73, 0x12, 0xa9, 0x02, 0x0a, 0x0a, 0x6d, 0x70, 0x63, 0x5f, 0x77, 0x61, 0x6c,
	0x6c, 0x65, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x89, 0x02, 0x92, 0x41, 0xd8, 0x01,
	0x2a, 0x09, 0x6d, 0x70, 0x63, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x32, 0x6d, 0x54, 0x68, 0x65,
	0x20, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x20, 0x6f,
	0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4d, 0x50, 0x43, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x20,
	0x74, 0x6f, 0x20, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x41, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x20, 0x62, 0x65, 0x6c, 0x6f, 0x6e, 0x67, 0x73, 0x2e, 0x20, 0x46,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x3a, 0x20, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x7b, 0x70, 0x6f,
	0x6f, 0x6c, 0x7d, 0x2f, 0x6d, 0x70, 0x63, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x73, 0x2f, 0x7b,
	0x6d, 0x70, 0x63, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x7d, 0x4a, 0x5c, 0x22, 0x70, 0x6f, 0x6f,
	0x6c, 0x73, 0x2f, 0x39, 0x35, 0x32, 0x35, 0x37, 0x63, 0x35, 0x61, 0x2d, 0x35, 0x32, 0x32, 0x66,
	0x2d, 0x34, 0x32, 0x34, 0x31, 0x2d, 0x62, 0x66, 0x39, 0x37, 0x2d, 0x32, 0x36, 0x35, 0x36, 0x61,
	0x38, 0x65, 0x39, 0x63, 0x63, 0x39, 0x31, 0x2f, 0x6d, 0x70, 0x63, 0x57, 0x61, 0x6c, 0x6c, 0x65,
	0x74, 0x73, 0x2f, 0x64, 0x32, 0x38, 0x31, 0x39, 0x37, 0x65, 0x38, 0x2d, 0x33, 0x37, 0x32, 0x63,
	0x2d, 0x34, 0x36, 0x31, 0x63, 0x2d, 0x39, 0x61, 0x30, 0x30, 0x2d, 0x32, 0x64, 0x61, 0x33, 0x63,
	0x35, 0x32, 0x38, 0x63, 0x32, 0x64, 0x31, 0x22, 0xe2, 0x41, 0x01, 0x03, 0xfa, 0x41, 0x26, 0x0a,
	0x24, 0x61, 0x70, 0x69, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63,
	0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x50, 0x43, 0x57,
	0x61, 0x6c, 0x6c, 0x65, 0x74, 0x52, 0x09, 0x6d, 0x70, 0x63, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74,
	0x3a, 0xc4, 0x01, 0x92, 0x41, 0x6c, 0x0a, 0x6a, 0x2a, 0x07, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x32, 0x5f, 0x54, 0x68, 0x65, 0x20, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x20, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2c, 0x20, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x72,
	0x65, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x73, 0x20, 0x61, 0x6e, 0x20, 0x6f, 0x6e, 0x2d,
	0x63, 0x68, 0x61, 0x69, 0x6e, 0x20, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x20, 0x62, 0x61,
	0x63, 0x6b, 0x65, 0x64, 0x20, 0x62, 0x79, 0x20, 0x61, 0x6e, 0x20, 0x4d, 0x50, 0x43, 0x4b, 0x65,
	0x79, 0x20, 0x69, 0x6e, 0x20, 0x61, 0x6e, 0x20, 0x4d, 0x50, 0x43, 0x57, 0x61, 0x6c, 0x6c, 0x65,
	0x74, 0x2e, 0xea, 0x41, 0x52, 0x0a, 0x22, 0x61, 0x70, 0x69, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c,
	0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x2c, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x73, 0x2f, 0x7b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x69, 0x64, 0x7d,
	0x2f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x2f, 0x7b, 0x61, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x5f, 0x69, 0x64, 0x7d, 0x22, 0xcd, 0x0a, 0x0a, 0x07, 0x42, 0x61, 0x6c, 0x61,
	0x6e, 0x63, 0x65, 0x12, 0x90, 0x02, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0xfb, 0x01, 0x92, 0x41, 0xf3, 0x01, 0x2a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x32,
	0x6c, 0x54, 0x68, 0x65, 0x20, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x20, 0x6e, 0x61,
	0x6d, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63,
	0x65, 0x2e, 0x0a, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x3a, 0x20, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x73, 0x2f, 0x7b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x69, 0x64, 0x7d,
	0x2f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x2f, 0x7b, 0x61, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x2f, 0x7b, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x7d, 0x4a, 0x7d, 0x22,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x65, 0x74, 0x68, 0x65, 0x72, 0x65, 0x75,
	0x6d, 0x2d, 0x67, 0x6f, 0x65, 0x72, 0x6c, 0x69, 0x2f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x65, 0x73, 0x2f, 0x30, 0x78, 0x44, 0x41, 0x46, 0x45, 0x41, 0x34, 0x39, 0x32, 0x44, 0x39, 0x63,
	0x36, 0x37, 0x33, 0x33, 0x61, 0x65, 0x33, 0x64, 0x35, 0x36, 0x62, 0x37, 0x45, 0x64, 0x31, 0x41,
	0x44, 0x42, 0x36, 0x30, 0x36, 0x39, 0x32, 0x63, 0x39, 0x38, 0x42, 0x63, 0x35, 0x2f, 0x62, 0x61,
	0x6c, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x65, 0x31, 0x38, 0x33, 0x35, 0x38, 0x30, 0x36, 0x2d,
	0x30, 0x37, 0x31, 0x38, 0x2d, 0x34, 0x31, 0x38, 0x61, 0x2d, 0x62, 0x31, 0x38, 0x35, 0x2d, 0x39,
	0x33, 0x35, 0x35, 0x33, 0x63, 0x34, 0x39, 0x36, 0x36, 0x35, 0x35, 0x22, 0xe2, 0x41, 0x01, 0x03,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x80, 0x02, 0x0a, 0x05, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0xe9, 0x01, 0x92, 0x41, 0xbc, 0x01, 0x2a, 0x05, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x32, 0x6b, 0x54, 0x68, 0x65, 0x20, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x41,
	0x73, 0x73, 0x65, 0x74, 0x20, 0x74, 0x6f, 0x20, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x74, 0x68,
	0x69, 0x73, 0x20, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x20, 0x63, 0x6f, 0x72, 0x72, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x64, 0x73, 0x2e, 0x20, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x3a, 0x20,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x7b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x7d, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x7d, 0x4a, 0x46, 0x22, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x65, 0x74, 0x68,
	0x65, 0x72, 0x65, 0x75, 0x6d, 0x2d, 0x67, 0x6f, 0x65, 0x72, 0x6c, 0x69, 0x2f, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x73, 0x2f, 0x65, 0x31, 0x38, 0x33, 0x35, 0x38, 0x30, 0x36, 0x2d, 0x30, 0x37, 0x31,
	0x38, 0x2d, 0x34, 0x31, 0x38, 0x61, 0x2d, 0x62, 0x31, 0x38, 0x35, 0x2d, 0x39, 0x33, 0x35, 0x35,
	0x33, 0x63, 0x34, 0x39, 0x36, 0x36, 0x35, 0x35, 0x22, 0xe2, 0x41, 0x01, 0x03, 0xfa, 0x41, 0x22,
	0x0a, 0x20, 0x61, 0x70, 0x69, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e,
	0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x52, 0x05, 0x61, 0x73, 0x73, 0x65, 0x74, 0x12, 0xa8, 0x02, 0x0a, 0x06, 0x61, 0x6d,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x8f, 0x02, 0x92, 0x41, 0x87,
	0x02, 0x2a, 0x06, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x32, 0xf0, 0x01, 0x54, 0x68, 0x65, 0x20,
	0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x61, 0x73,
	0x73, 0x65, 0x74, 0x2e, 0x20, 0x46, 0x6f, 0x72, 0x20, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x20,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x20, 0x6f, 0x72, 0x20, 0x45, 0x52, 0x43, 0x2d, 0x32, 0x30,
	0x20, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x61, 0x63, 0x74, 0x73, 0x2c, 0x20, 0x74, 0x68, 0x69, 0x73,
	0x20, 0x69, 0x73, 0x20, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x65, 0x64, 0x20, 0x69, 0x6e,
	0x20, 0x74, 0x65, 0x72, 0x6d, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x61, 0x74, 0x6f, 0x6d, 0x69, 0x63,
	0x20, 0x75, 0x6e, 0x69, 0x74, 0x73, 0x20, 0x28, 0x65, 0x2e, 0x67, 0x2e, 0x2c, 0x20, 0x57, 0x65,
	0x69, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x45, 0x74, 0x68, 0x65, 0x72, 0x29, 0x20, 0x61, 0x73, 0x20,
	0x61, 0x20, 0x62, 0x61, 0x73, 0x65, 0x2d, 0x31, 0x30, 0x20, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72,
	0x2e, 0x20, 0x46, 0x6f, 0x72, 0x20, 0x45, 0x52, 0x43, 0x2d, 0x37, 0x32, 0x31, 0x20, 0x61, 0x6e,
	0x64, 0x20, 0x45, 0x52, 0x43, 0x2d, 0x31, 0x31, 0x35, 0x35, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x72,
	0x61, 0x63, 0x74, 0x73, 0x2c, 0x20, 0x69, 0x74, 0x20, 0x69, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x64, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x63,
	0x74, 0x20, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x20, 0x49, 0x44, 0x73, 0x20, 0x68, 0x65, 0x6c, 0x64,
	0x20, 0x62, 0x79, 0x20, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x2e, 0x4a, 0x0a, 0x22, 0x31,
	0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x22, 0xe2, 0x41, 0x01, 0x03, 0x52, 0x06, 0x61, 0x6d,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0xa9, 0x02, 0x0a, 0x0a, 0x6d, 0x70, 0x63, 0x5f, 0x77, 0x61, 0x6c,
	0x6c, 0x65, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x89, 0x02, 0x92, 0x41, 0xd8, 0x01,
	0x2a, 0x09, 0x6d, 0x70, 0x63, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x32, 0x6d, 0x54, 0x68, 0x65,
	0x20, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x20, 0x6f,
	0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4d, 0x50, 0x43, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x20,
	0x74, 0x6f, 0x20, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x42, 0x61,
	0x6c, 0x61, 0x6e, 0x63, 0x65, 0x20, 0x62, 0x65, 0x6c, 0x6f, 0x6e, 0x67, 0x73, 0x2e, 0x20, 0x46,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x3a, 0x20, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x7b, 0x70, 0x6f,
	0x6f, 0x6c, 0x7d, 0x2f, 0x6d, 0x70, 0x63, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x73, 0x2f, 0x7b,
	0x6d, 0x70, 0x63, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x7d, 0x4a, 0x5c, 0x22, 0x70, 0x6f, 0x6f,
	0x6c, 0x73, 0x2f, 0x39, 0x35, 0x32, 0x35, 0x37, 0x63, 0x35, 0x61, 0x2d, 0x35, 0x32, 0x32, 0x66,
	0x2d, 0x34, 0x32, 0x34, 0x31, 0x2d, 0x62, 0x66, 0x39, 0x37, 0x2d, 0x32, 0x36, 0x35, 0x36, 0x61,
	0x38, 0x65, 0x39, 0x63, 0x63, 0x39, 0x31, 0x2f, 0x6d, 0x70, 0x63, 0x57, 0x61, 0x6c, 0x6c, 0x65,
	0x74, 0x73, 0x2f, 0x64, 0x32, 0x38, 0x31, 0x39, 0x37, 0x65, 0x38, 0x2d, 0x33, 0x37, 0x32, 0x63,
	0x2d, 0x34, 0x36, 0x31, 0x63, 0x2d, 0x39, 0x61, 0x30, 0x30, 0x2d, 0x32, 0x64, 0x61, 0x33, 0x63,
	0x35, 0x32, 0x38, 0x63, 0x32, 0x64, 0x31, 0x22, 0xe2, 0x41, 0x01, 0x03, 0xfa, 0x41, 0x26, 0x0a,
	0x24, 0x61, 0x70, 0x69, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63,
	0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x50, 0x43, 0x57,
	0x61, 0x6c, 0x6c, 0x65, 0x74, 0x52, 0x09, 0x6d, 0x70, 0x63, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74,
	0x3a, 0xd4, 0x01, 0x92, 0x41, 0x66, 0x0a, 0x64, 0x2a, 0x07, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63,
	0x65, 0x32, 0x59, 0x54, 0x68, 0x65, 0x20, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x20, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2c, 0x20, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x72,
	0x65, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x73, 0x20, 0x61, 0x6e, 0x20, 0x61, 0x6d, 0x6f,
	0x75, 0x6e, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x61, 0x6e, 0x20, 0x41, 0x73, 0x73, 0x65, 0x74, 0x20,
	0x68, 0x65, 0x6c, 0x64, 0x20, 0x6f, 0x6e, 0x2d, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x20, 0x62, 0x79,
	0x20, 0x61, 0x6e, 0x20, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x2e, 0xea, 0x41, 0x68, 0x0a,
	0x22, 0x61, 0x70, 0x69, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63,
	0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x6c, 0x61,
	0x6e, 0x63, 0x65, 0x12, 0x42, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x7b, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x61, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x65, 0x73, 0x2f, 0x7b, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x69, 0x64,
	0x7d, 0x2f, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x62, 0x61, 0x6c, 0x61,
	0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x7d, 0x22, 0xa0, 0x0f, 0x0a, 0x0d, 0x42, 0x61, 0x6c, 0x61,
	0x6e, 0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0xef, 0x02, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0xda, 0x02, 0x92, 0x41, 0xd2, 0x02, 0x2a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x32, 0x95, 0x01, 0x54, 0x68, 0x65, 0x20, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x0a,
	0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x3a, 0x20, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x2f, 0x7b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x61, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x2f, 0x7b, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x62,
	0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x62, 0x61, 0x6c, 0x61, 0x6e,
	0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2f, 0x7b, 0x62, 0x61, 0x6c, 0x61, 0x6e,
	0x63, 0x65, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x5f, 0x69, 0x64, 0x7d, 0x4a, 0xb1, 0x01,
	0x22, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x65, 0x74, 0x68, 0x65, 0x72, 0x65,
	0x75, 0x6d, 0x2d, 0x67, 0x6f, 0x65, 0x72, 0x6c, 0x69, 0x2f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x65, 0x73, 0x2f, 0x30, 0x78, 0x44, 0x41, 0x46, 0x45, 0x41, 0x34, 0x39, 0x32, 0x44, 0x39,
	0x63, 0x36, 0x37, 0x33, 0x33, 0x61, 0x65, 0x33, 0x64, 0x35, 0x36, 0x62, 0x37, 0x45, 0x64, 0x31,
	0x41, 0x44, 0x42, 0x36, 0x30, 0x36, 0x39, 0x32, 0x63, 0x39, 0x38, 0x42, 0x63, 0x35, 0x2f, 0x62,
	0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x65, 0x31, 0x38, 0x33, 0x35, 0x38, 0x30, 0x36,
	0x2d, 0x30, 0x37, 0x31, 0x38, 0x2d, 0x34, 0x31, 0x38, 0x61, 0x2d, 0x62, 0x31, 0x38, 0x35, 0x2d,
	0x39, 0x33, 0x35, 0x35, 0x33, 0x63, 0x34, 0x39, 0x36, 0x36, 0x35, 0x35, 0x2f, 0x62, 0x61, 0x6c,
	0x61, 0x6e, 0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2f, 0x32, 0x35, 0x62, 0x30,
	0x33, 0x36, 0x63, 0x62, 0x2d, 0x65, 0x39, 0x36, 0x38, 0x2d, 0x35, 0x33, 0x35, 0x31, 0x2d, 0x38,
	0x62, 0x30, 0x65, 0x2d, 0x33, 0x63, 0x61, 0x62, 0x63, 0x36, 0x63, 0x64, 0x64, 0x61, 0x62, 0x63,
	0x22, 0xe2, 0x41, 0x01, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x86, 0x02, 0x0a, 0x05,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0xef, 0x01, 0x92, 0x41,
	0xc2, 0x01, 0x2a, 0x05, 0x61, 0x73, 0x73, 0x65, 0x74, 0x32, 0x71, 0x54, 0x68, 0x65, 0x20, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x20, 0x6f, 0x66, 0x20,
	0x74, 0x68, 0x65, 0x20, 0x41, 0x73, 0x73, 0x65, 0x74, 0x20, 0x74, 0x6f, 0x20, 0x77, 0x68, 0x69,
	0x63, 0x68, 0x20, 0x74, 0x68, 0x65, 0x20, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x20, 0x42, 0x61,
	0x6c, 0x61, 0x6e, 0x63, 0x65, 0x20, 0x63, 0x6f, 0x72, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x64,
	0x73, 0x2e, 0x20, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x3a, 0x20, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x73, 0x2f, 0x7b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x7d, 0x2f, 0x61, 0x73,
	0x73, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x73, 0x73, 0x65, 0x74, 0x7d, 0x4a, 0x46, 0x22, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x65, 0x74, 0x68, 0x65, 0x72, 0x65, 0x75, 0x6d,
	0x2d, 0x67, 0x6f, 0x65, 0x72, 0x6c, 0x69, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x65,
	0x31, 0x38, 0x33, 0x35, 0x38, 0x30, 0x36, 0x2d, 0x30, 0x37, 0x31, 0x38, 0x2d, 0x34, 0x31, 0x38,
	0x61, 0x2d, 0x62, 0x31, 0x38, 0x35, 0x2d, 0x39, 0x33, 0x35, 0x35, 0x33, 0x63, 0x34, 0x39, 0x36,
	0x36, 0x35, 0x35, 0x22, 0xe2, 0x41, 0x01, 0x03, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x61, 0x70, 0x69,
	0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62,
	0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x05, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x12, 0x6c, 0x0a, 0x06, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x54, 0x92, 0x41, 0x4d, 0x2a, 0x06, 0x61, 0x6d, 0x6f, 0x75, 0x6e,
	0x74, 0x32, 0x37, 0x2f, 0x2f, 0x20, 0x54, 0x68, 0x65, 0x20, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74,
	0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x20, 0x61, 0x73, 0x20, 0x61, 0x20, 0x62, 0x61, 0x73, 0x65, 0x2d,
	0x31, 0x30, 0x20, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x2e, 0x4a, 0x0a, 0x22, 0x31, 0x30, 0x30,
	0x30, 0x30, 0x30, 0x30, 0x30, 0x22, 0xe2, 0x41, 0x01, 0x03, 0x52, 0x06, 0x61, 0x6d, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0xe7, 0x04, 0x0a, 0x10, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x64, 0x65, 0x66,
	0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e,
	0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x6c, 0x6f, 0x63, 0x6b, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x2e, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x8b, 0x04,
	0x92, 0x41, 0x83, 0x04, 0x2a, 0x10, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x64, 0x65, 0x66, 0x69,
	0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x32, 0xee, 0x03, 0x54, 0x68, 0x65, 0x20, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x20, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x77, 0x68,
	0x69, 0x63, 0x68, 0x20, 0x63, 0x61, 0x6e, 0x20, 0x62, 0x65, 0x20, 0x75, 0x73, 0x65, 0x64, 0x20,
	0x74, 0x6f, 0x20, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x20, 0x77, 0x68, 0x61, 0x74,
	0x20, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x61, 0x6d, 0x6f, 0x75, 0x6e,
	0x74, 0x20, 0x63, 0x6f, 0x72, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x64, 0x73, 0x20, 0x74, 0x6f,
	0x2e, 0x0a, 0x0a, 0x20, 0x41, 0x20, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x61, 0x20, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x20, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x20, 0x77, 0x69, 0x6c, 0x6c, 0x20, 0x6f, 0x6e,
	0x6c, 0x79, 0x20, 0x68, 0x61, 0x76, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x20, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x20, 0x73, 0x65, 0x74,
	0x20, 0x28, 0x22, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x22, 0x29, 0x2e, 0x0a, 0x20, 0x41, 0x20,
	0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x20, 0x66, 0x6f,
	0x72, 0x20, 0x61, 0x6e, 0x20, 0x45, 0x52, 0x43, 0x2d, 0x32, 0x30, 0x20, 0x42, 0x61, 0x6c, 0x61,
	0x6e, 0x63, 0x65, 0x20, 0x77, 0x69, 0x6c, 0x6c, 0x20, 0x6f, 0x6e, 0x6c, 0x79, 0x20, 0x68, 0x61,
	0x76, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x20, 0x28, 0x22, 0x65, 0x72, 0x63, 0x32, 0x30, 0x22, 0x29, 0x20, 0x61, 0x6e, 0x64, 0x20,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x20, 0x28,
	0x63, 0x6f, 0x6e, 0x74, 0x72, 0x61, 0x63, 0x74, 0x20, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x29, 0x20, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x20, 0x73, 0x65, 0x74, 0x2e, 0x0a, 0x20, 0x41,
	0x20, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x20, 0x66,
	0x6f, 0x72, 0x20, 0x61, 0x6e, 0x20, 0x45, 0x52, 0x43, 0x2d, 0x37, 0x32, 0x31, 0x20, 0x42, 0x61,
	0x6c, 0x61, 0x6e, 0x63, 0x65, 0x20, 0x6f, 0x72, 0x20, 0x45, 0x52, 0x43, 0x2d, 0x31, 0x31, 0x35,
	0x35, 0x20, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x20, 0x77, 0x69, 0x6c, 0x6c, 0x20, 0x68,
	0x61, 0x76, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x20, 0x28, 0x22, 0x65, 0x72, 0x63, 0x37, 0x32, 0x31, 0x22, 0x20, 0x6f, 0x72, 0x20,
	0x22, 0x65, 0x72, 0x63, 0x31, 0x31, 0x35, 0x35, 0x22, 0x29, 0x2c, 0x0a, 0x20, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x20, 0x28, 0x63, 0x6f, 0x6e,
	0x74, 0x72, 0x61, 0x63, 0x74, 0x20, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x29, 0x2c, 0x20,
	0x61, 0x6e, 0x64, 0x20, 0x73, 0x75, 0x62, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64,
	0x20, 0x28, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x20, 0x49, 0x44, 0x29, 0x20, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x73, 0x20, 0x73, 0x65, 0x74, 0x2e, 0xe2, 0x41, 0x01, 0x03, 0x52, 0x0f, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0xaf, 0x02, 0x0a,
	0x0a, 0x6d, 0x70, 0x63, 0x5f, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x8f, 0x02, 0x92, 0x41, 0xde, 0x01, 0x2a, 0x09, 0x6d, 0x70, 0x63, 0x57, 0x61, 0x6c,
	0x6c, 0x65, 0x74, 0x32, 0x73, 0x54, 0x68, 0x65, 0x20, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4d, 0x50,
	0x43, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x20, 0x74, 0x6f, 0x20, 0x77, 0x68, 0x69, 0x63, 0x68,
	0x20, 0x74, 0x68, 0x65, 0x20, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x20, 0x42, 0x61, 0x6c, 0x61,
	0x6e, 0x63, 0x65, 0x20, 0x62, 0x65, 0x6c, 0x6f, 0x6e, 0x67, 0x73, 0x2e, 0x20, 0x46, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x3a, 0x20, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x7b, 0x70, 0x6f, 0x6f, 0x6c,
	0x7d, 0x2f, 0x6d, 0x70, 0x63, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x6d, 0x70,
	0x63, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x7d, 0x4a, 0x5c, 0x22, 0x70, 0x6f, 0x6f, 0x6c, 0x73,
	0x2f, 0x39, 0x35, 0x32, 0x35, 0x37, 0x63, 0x35, 0x61, 0x2d, 0x35, 0x32, 0x32, 0x66, 0x2d, 0x34,
	0x32, 0x34, 0x31, 0x2d, 0x62, 0x66, 0x39, 0x37, 0x2d, 0x32, 0x36, 0x35, 0x36, 0x61, 0x38, 0x65,
	0x39, 0x63, 0x63, 0x39, 0x31, 0x2f, 0x6d, 0x70, 0x63, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x73,
	0x2f, 0x64, 0x32, 0x38, 0x31, 0x39, 0x37, 0x65, 0x38, 0x2d, 0x33, 0x37, 0x32, 0x63, 0x2d, 0x34,
	0x36, 0x31, 0x63, 0x2d, 0x39, 0x61, 0x30, 0x30, 0x2d, 0x32, 0x64, 0x61, 0x33, 0x63, 0x35, 0x32,
	0x38, 0x63, 0x32, 0x64, 0x31, 0x22, 0xe2, 0x41, 0x01, 0x03, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x61,
	0x70, 0x69, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69,
	0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x50, 0x43, 0x57, 0x61, 0x6c,
	0x6c, 0x65, 0x74, 0x52, 0x09, 0x6d, 0x70, 0x63, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x3a, 0x89,
	0x02, 0x92, 0x41, 0x71, 0x0a, 0x6f, 0x2a, 0x0d, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x32, 0x5e, 0x54, 0x68, 0x65, 0x20, 0x42, 0x61, 0x6c, 0x61, 0x6e,
	0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x20, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2c, 0x20, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x65, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x61,
	0x74, 0x65, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x63,
	0x20, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x20, 0x68, 0x65, 0x6c, 0x64, 0x20, 0x77, 0x68, 0x69,
	0x63, 0x68, 0x20, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x65, 0x20, 0x61, 0x20, 0x42, 0x61, 0x6c,
	0x61, 0x6e, 0x63, 0x65, 0x2e, 0xea, 0x41, 0x91, 0x01, 0x0a, 0x28, 0x61, 0x70, 0x69, 0x2e, 0x64,
	0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73,
	0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x12, 0x65, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x7b, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x61, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x65, 0x73, 0x2f, 0x7b, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x69, 0x64,
	0x7d, 0x2f, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x62, 0x61, 0x6c, 0x61,
	0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2f, 0x7b, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x5f,
	0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x5f, 0x69, 0x64, 0x7d, 0x22, 0xa8, 0x02, 0x0a, 0x16, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x50, 0x43, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x56, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3e, 0x92, 0x41, 0x0e, 0xca, 0x3e, 0x0b, 0xfa, 0x02, 0x08,
	0x70, 0x6f, 0x6f, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0xe2, 0x41, 0x01, 0x02, 0xfa, 0x41, 0x26, 0x12,
	0x24, 0x61, 0x70, 0x69, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63,
	0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x50, 0x43, 0x57,
	0x61, 0x6c, 0x6c, 0x65, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x4d, 0x0a,
	0x0a, 0x6d, 0x70, 0x63, 0x5f, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x70, 0x63, 0x5f, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x4d, 0x50, 0x43, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x42, 0x04, 0xe2, 0x41, 0x01,
	0x02, 0x52, 0x09, 0x6d, 0x70, 0x63, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x12, 0x42, 0x0a, 0x06,
	0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe2, 0x41,
	0x01, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x61, 0x70, 0x69, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c,
	0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x06, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x12, 0x23, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xe0, 0x02, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x4d, 0x50, 0x43, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0xc4, 0x02, 0x0a, 0x0c, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0xa0, 0x02, 0x92, 0x41, 0xed, 0x01, 0x2a,
	0x0c, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x32, 0x7d, 0x54,
	0x68, 0x65, 0x20, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65,
	0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x20, 0x74, 0x6f, 0x20, 0x70, 0x6f, 0x6c, 0x6c, 0x20, 0x75, 0x73, 0x69, 0x6e,
	0x67, 0x20, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x50, 0x43, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x0a, 0x20, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x3a, 0x20, 0x70, 0x6f,
	0x6f, 0x6c, 0x73, 0x2f, 0x7b, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x64, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x7b, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x7d, 0x4a, 0x5e, 0x22, 0x70,
	0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x39, 0x35, 0x32, 0x35, 0x37, 0x63, 0x35, 0x61, 0x2d, 0x35, 0x32,
	0x32, 0x66, 0x2d, 0x34, 0x32, 0x34, 0x31, 0x2d, 0x62, 0x66, 0x39, 0x37, 0x2d, 0x32, 0x36, 0x35,
	0x36, 0x61, 0x38, 0x65, 0x39, 0x63, 0x63, 0x39, 0x31, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x33, 0x61, 0x31, 0x36, 0x38, 0x61, 0x35, 0x34, 0x2d,
	0x36, 0x36, 0x36, 0x31, 0x2d, 0x34, 0x65, 0x35, 0x61, 0x2d, 0x38, 0x62, 0x63, 0x35, 0x2d, 0x39,
	0x37, 0x35, 0x39, 0x36, 0x37, 0x31, 0x61, 0x61, 0x37, 0x37, 0x37, 0x22, 0xe2, 0x41, 0x01, 0x03,
	0xfa, 0x41, 0x28, 0x0a, 0x26, 0x61, 0x70, 0x69, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70,
	0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x0b, 0x64, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x22, 0x6e, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x4d,
	0x50, 0x43, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x57, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x43, 0x92,
	0x41, 0x13, 0xca, 0x3e, 0x10, 0xfa, 0x02, 0x0d, 0x6d, 0x70, 0x63, 0x57, 0x61, 0x6c, 0x6c, 0x65,
	0x74, 0x4e, 0x61, 0x6d, 0x65, 0xe2, 0x41, 0x01, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x61, 0x70,
	0x69, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e,
	0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x50, 0x43, 0x57, 0x61, 0x6c, 0x6c,
	0x65, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xab, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73,
	0x74, 0x4d, 0x50, 0x43, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x56, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x3e, 0x92, 0x41, 0x0e, 0xca, 0x3e, 0x0b, 0xfa, 0x02, 0x08, 0x70, 0x6f, 0x6f,
	0x6c, 0x4e, 0x61, 0x6d, 0x65, 0xe2, 0x41, 0x01, 0x02, 0xfa, 0x41, 0x26, 0x12, 0x24, 0x61, 0x70,
	0x69, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e,
	0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x50, 0x43, 0x57, 0x61, 0x6c, 0x6c,
	0x65, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xd4, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x4d,
	0x50, 0x43, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x49, 0x0a, 0x0b, 0x6d, 0x70, 0x63, 0x5f, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x70, 0x63, 0x5f, 0x77, 0x61, 0x6c, 0x6c,
	0x65, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x50, 0x43, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74,
	0x52, 0x0a, 0x6d, 0x70, 0x63, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x3a, 0x47, 0x92, 0x41, 0x44, 0x0a, 0x42, 0x2a, 0x16, 0x4c, 0x69, 0x73,
	0x74, 0x4d, 0x50, 0x43, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x32, 0x28, 0x54, 0x68, 0x65, 0x20, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x20, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x4c, 0x69,
	0x73, 0x74, 0x4d, 0x50, 0x43, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x73, 0x2e, 0x22, 0xe8, 0x01,
	0x0a, 0x16, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x62, 0x0a, 0x0a, 0x6d, 0x70, 0x63, 0x5f,
	0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x43, 0x92, 0x41,
	0x13, 0xca, 0x3e, 0x10, 0xfa, 0x02, 0x0d, 0x6d, 0x70, 0x63, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74,
	0x4e, 0x61, 0x6d, 0x65, 0xe2, 0x41, 0x01, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x61, 0x70, 0x69,
	0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62,
	0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x50, 0x43, 0x57, 0x61, 0x6c, 0x6c, 0x65,
	0x74, 0x52, 0x09, 0x6d, 0x70, 0x63, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x12, 0x45, 0x0a, 0x07,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe2,
	0x41, 0x01, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x61, 0x70, 0x69, 0x2e, 0x64, 0x65, 0x76, 0x65,
	0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x12, 0x23, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x01, 0x52, 0x09, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x68, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x41,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x53, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3f, 0x92, 0x41, 0x11,
	0xca, 0x3e, 0x0e, 0xfa, 0x02, 0x0b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x4e, 0x61, 0x6d,
	0x65, 0xe2, 0x41, 0x01, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x61, 0x70, 0x69, 0x2e, 0x64, 0x65,
	0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0x85, 0x02, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x57, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3f, 0x92, 0x41, 0x11,
	0xca, 0x3e, 0x0e, 0xfa, 0x02, 0x0b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x4e, 0x61, 0x6d,
	0x65, 0xe2, 0x41, 0x01, 0x02, 0xfa, 0x41, 0x24, 0x12, 0x22, 0x61, 0x70, 0x69, 0x2e, 0x64, 0x65,
	0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x4c, 0x0a, 0x0a, 0x6d, 0x70, 0x63, 0x5f, 0x77, 0x61, 0x6c, 0x6c,
	0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe2, 0x41, 0x01, 0x01, 0xfa, 0x41,
	0x26, 0x0a, 0x24, 0x61, 0x70, 0x69, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72,
	0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x50,
	0x43, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x52, 0x09, 0x6d, 0x70, 0x63, 0x57, 0x61, 0x6c, 0x6c,
	0x65, 0x74, 0x12, 0x21, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x23, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x01, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xcc, 0x01, 0x0a, 0x15, 0x4c,
	0x69, 0x73, 0x74, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x44, 0x0a, 0x09, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61,
	0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x70, 0x63, 0x5f, 0x77, 0x61, 0x6c,
	0x6c, 0x65, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x52,
	0x09, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x3a, 0x45, 0x92, 0x41, 0x42, 0x0a, 0x40, 0x2a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x41,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x32, 0x27, 0x54, 0x68, 0x65, 0x20, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x20, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x4c, 0x69, 0x73, 0x74, 0x41,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x2e, 0x22, 0xb6, 0x01, 0x0a, 0x13, 0x4c, 0x69,
	0x73, 0x74, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x57, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x3f, 0x92, 0x41, 0x11, 0xca, 0x3e, 0x0e, 0xfa, 0x02, 0x0b, 0x61, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x4e, 0x61, 0x6d, 0x65, 0xe2, 0x41, 0x01, 0x02, 0xfa, 0x41, 0x24, 0x12, 0x22,
	0x61, 0x70, 0x69, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f,
	0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x6c, 0x61, 0x6e,
	0x63, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x21, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x04, 0xe2,
	0x41, 0x01, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x23, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0xc7, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x6c, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x42, 0x0a, 0x08, 0x62,
	0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e,
	0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x70, 0x63, 0x5f, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61,
	0x6c, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x3a, 0x43, 0x92, 0x41, 0x40, 0x0a, 0x3e, 0x2a, 0x14,
	0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x32, 0x26, 0x54, 0x68, 0x65, 0x20, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x20, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x4c,
	0x69, 0x73, 0x74, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2e, 0x22, 0xc2, 0x01, 0x0a,
	0x19, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5d, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x45, 0x92, 0x41, 0x11, 0xca,
	0x3e, 0x0e, 0xfa, 0x02, 0x0b, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65,
	0xe2, 0x41, 0x01, 0x02, 0xfa, 0x41, 0x2a, 0x12, 0x28, 0x61, 0x70, 0x69, 0x2e, 0x64, 0x65, 0x76,
	0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x21, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x04, 0xe2, 0x41,
	0x01, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x23, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x04, 0xe2, 0x41, 0x01, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0xec, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63,
	0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x55, 0x0a, 0x0f, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x64, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x63, 0x6f, 0x69, 0x6e,
	0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x70, 0x63, 0x5f, 0x77,
	0x61, 0x6c, 0x6c, 0x65, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63,
	0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x52, 0x0e, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x3a,
	0x4f, 0x92, 0x41, 0x4c, 0x0a, 0x4a, 0x2a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x6c, 0x61,
	0x6e, 0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x32, 0x2c, 0x54, 0x68, 0x65, 0x20, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x20, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x4c, 0x69, 0x73,
	0x74, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e,
	0x32, 0xbe, 0x1a, 0x0a, 0x10, 0x4d, 0x50, 0x43, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x9b, 0x07, 0x0a, 0x0f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x4d, 0x50, 0x43, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x12, 0x35, 0x2e, 0x63, 0x6f, 0x69, 0x6e,
	0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x70, 0x63, 0x5f, 0x77,
	0x61, 0x6c, 0x6c, 0x65, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x4d, 0x50, 0x43, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0xb1, 0x06, 0x92, 0x41, 0xa8, 0x05, 0x12, 0x0f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x50,
	0x43, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x1a, 0x94, 0x05, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x73, 0x20, 0x61, 0x6e, 0x20, 0x4d, 0x50, 0x43, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x2e, 0x20,
	0x54, 0x68, 0x65, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68,
	0x65, 0x20, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x68,
	0x61, 0x76, 0x65, 0x20, 0x62, 0x65, 0x65, 0x6e, 0x20, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65,
	0x72, 0x65, 0x64, 0x20, 0x75, 0x73, 0x69, 0x6e, 0x67, 0x20, 0x4d, 0x50, 0x43, 0x4b, 0x65, 0x79,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x27, 0x73, 0x20, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x65, 0x72, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x20, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x20,
	0x74, 0x68, 0x69, 0x73, 0x20, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x20, 0x69, 0x73, 0x20, 0x63,
	0x61, 0x6c, 0x6c, 0x65, 0x64, 0x2e, 0x0a, 0x0a, 0x20, 0x55, 0x6e, 0x64, 0x65, 0x72, 0x20, 0x74,
	0x68, 0x65, 0x20, 0x68, 0x6f, 0x6f, 0x64, 0x2c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x63, 0x61,
	0x6c, 0x6c, 0x73, 0x20, 0x4d, 0x50, 0x43, 0x4b, 0x65, 0x79, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x27, 0x73, 0x20, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x74, 0x68, 0x65, 0x20, 0x61,
	0x70, 0x70, 0x72, 0x6f, 0x70, 0x72, 0x69, 0x61, 0x74, 0x65, 0x20, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x20, 0x41, 0x66, 0x74, 0x65, 0x72, 0x20, 0x63, 0x61, 0x6c,
	0x6c, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x69, 0x73, 0x2c, 0x20, 0x75, 0x73, 0x65, 0x20, 0x4d,
	0x50, 0x43, 0x4b, 0x65, 0x79, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x27, 0x73, 0x20, 0x4c,
	0x69, 0x73, 0x74, 0x4d, 0x50, 0x43, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x20, 0x74, 0x6f, 0x20, 0x70, 0x6f, 0x6c, 0x6c, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x20, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x20, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x75, 0x73, 0x65, 0x20, 0x74, 0x68,
	0x65, 0x20, 0x57, 0x61, 0x61, 0x53, 0x20, 0x53, 0x44, 0x4b, 0x27, 0x73, 0x20, 0x63, 0x6f, 0x6d,
	0x70, 0x75, 0x74, 0x65, 0x4d, 0x50, 0x43, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x20, 0x74, 0x6f, 0x20, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x0a, 0x0a, 0x20, 0x4e, 0x6f,
	0x74, 0x65, 0x3a, 0x20, 0x62, 0x65, 0x63, 0x61, 0x75, 0x73, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20, 0x4d, 0x50, 0x43, 0x20,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x69, 0x73, 0x20, 0x61, 0x73,
	0x79, 0x6e, 0x63, 0x68, 0x72, 0x6f, 0x6e, 0x6f, 0x75, 0x73, 0x2c, 0x20, 0x4c, 0x69, 0x73, 0x74,
	0x4d, 0x50, 0x43, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x6d, 0x61,
	0x79, 0x20, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x20, 0x61, 0x20, 0x4e, 0x4f, 0x54, 0x5f, 0x46,
	0x4f, 0x55, 0x4e, 0x44, 0x20, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x20, 0x69, 0x6d, 0x6d, 0x65, 0x64,
	0x69, 0x61, 0x74, 0x65, 0x6c, 0x79, 0x20, 0x61, 0x66, 0x74, 0x65, 0x72, 0x20, 0x63, 0x61, 0x6c,
	0x6c, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x20, 0x54, 0x6f, 0x20, 0x63, 0x6f,
	0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75, 0x65, 0x20, 0x70,
	0x6f, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x20, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x50, 0x43, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x65, 0x76, 0x65, 0x6e, 0x20, 0x69, 0x66,
	0x20, 0x69, 0x74, 0x20, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x73, 0x20, 0x61, 0x20, 0x4e, 0x4f,
	0x54, 0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44, 0x20, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x2e, 0xca, 0x41,
	0x24, 0x0a, 0x09, 0x4d, 0x50, 0x43, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x12, 0x17, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x4d, 0x50, 0x43, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x28, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6d,
	0x70, 0x63, 0x5f, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x2c, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x2c, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x3a, 0x0a, 0x6d, 0x70, 0x63, 0x5f, 0x77, 0x61, 0x6c, 0x6c,
	0x65, 0x74, 0x22, 0x1f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x70, 0x63, 0x57, 0x61, 0x6c, 0x6c,
	0x65, 0x74, 0x73, 0x12, 0xd7, 0x01, 0x0a, 0x0c, 0x47, 0x65, 0x74, 0x4d, 0x50, 0x43, 0x57, 0x61,
	0x6c, 0x6c, 0x65, 0x74, 0x12, 0x32, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x70, 0x63, 0x5f, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4d, 0x50, 0x43, 0x57, 0x61, 0x6c, 0x6c, 0x65,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62,
	0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x70, 0x63, 0x5f, 0x77, 0x61,
	0x6c, 0x6c, 0x65, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x50, 0x43, 0x57, 0x61, 0x6c, 0x6c,
	0x65, 0x74, 0x22, 0x69, 0x92, 0x41, 0x38, 0x12, 0x0c, 0x47, 0x65, 0x74, 0x4d, 0x50, 0x43, 0x57,
	0x61, 0x6c, 0x6c, 0x65, 0x74, 0x1a, 0x28, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x73,
	0x20, 0x61, 0x6e, 0x20, 0x4d, 0x50, 0x43, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x20, 0x62, 0x79,
	0x20, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x2e, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x21, 0x12, 0x1f, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a, 0x2f,
	0x6d, 0x70, 0x63, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xeb, 0x01,
	0x0a, 0x0e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x50, 0x43, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x73,
	0x12, 0x34, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x70, 0x63, 0x5f, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x50, 0x43, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x70, 0x63, 0x5f, 0x77, 0x61, 0x6c, 0x6c,
	0x65, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x50, 0x43, 0x57, 0x61,
	0x6c, 0x6c, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x6c, 0x92,
	0x41, 0x39, 0x12, 0x0e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x50, 0x43, 0x57, 0x61, 0x6c, 0x6c, 0x65,
	0x74, 0x73, 0x1a, 0x27, 0x52, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x73, 0x20, 0x61, 0x20, 0x6c, 0x69,
	0x73, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x4d, 0x50, 0x43, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x73,
	0x20, 0x69, 0x6e, 0x20, 0x61, 0x20, 0x50, 0x6f, 0x6f, 0x6c, 0x2e, 0xda, 0x41, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x21, 0x12, 0x1f, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x6d, 0x70, 0x63, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x73, 0x12, 0xc7, 0x04, 0x0a, 0x0f,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12,
	0x35, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x70, 0x63, 0x5f, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x70, 0x63, 0x5f, 0x77, 0x61, 0x6c, 0x6c,
	0x65, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x22, 0xd4,
	0x03, 0x92, 0x41, 0xfb, 0x02, 0x12, 0x0f, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x1a, 0xe7, 0x02, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x65, 0x73, 0x20, 0x61, 0x6e, 0x20, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x20, 0x77, 0x69,
	0x74, 0x68, 0x69, 0x6e, 0x20, 0x61, 0x6e, 0x20, 0x4d, 0x50, 0x43, 0x57, 0x61, 0x6c, 0x6c, 0x65,
	0x74, 0x2e, 0x20, 0x54, 0x68, 0x65, 0x20, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x20, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x20, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x64, 0x20,
	0x61, 0x72, 0x65, 0x20, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x20, 0x61, 0x63,
	0x72, 0x6f, 0x73, 0x73, 0x20, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x20, 0x6f, 0x66,
	0x20, 0x74, 0x68, 0x65, 0x20, 0x73, 0x61, 0x6d, 0x65, 0x20, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63,
	0x6f, 0x6c, 0x20, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x20, 0x28, 0x65, 0x2e, 0x67, 0x2e, 0x20,
	0x45, 0x56, 0x4d, 0x29, 0x2e, 0x20, 0x53, 0x6f, 0x2c, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x65, 0x78,
	0x61, 0x6d, 0x70, 0x6c, 0x65, 0x2c, 0x20, 0x63, 0x61, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x20, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x20, 0x74,
	0x77, 0x69, 0x63, 0x65, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x2f, 0x65, 0x74, 0x68, 0x65, 0x72, 0x65, 0x75, 0x6d, 0x2d, 0x6d, 0x61, 0x69, 0x6e, 0x6e,
	0x65, 0x74, 0x2c, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x74, 0x68, 0x65, 0x6e, 0x20, 0x63, 0x61, 0x6c,
	0x6c, 0x69, 0x6e, 0x67, 0x20, 0x69, 0x74, 0x20, 0x74, 0x77, 0x69, 0x63, 0x65, 0x20, 0x6d, 0x6f,
	0x72, 0x65, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f,
	0x65, 0x74, 0x68, 0x65, 0x72, 0x65, 0x75, 0x6d, 0x2d, 0x67, 0x6f, 0x65, 0x72, 0x6c, 0x69, 0x2c,
	0x20, 0x77, 0x69, 0x6c, 0x6c, 0x20, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x20, 0x69, 0x6e, 0x20,
	0x74, 0x77, 0x6f, 0x20, 0x70, 0x61, 0x69, 0x72, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x20, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73,
	0x20, 0x6f, 0x6e, 0x20, 0x45, 0x74, 0x68, 0x65, 0x72, 0x65, 0x75, 0x6d, 0x20, 0x4d, 0x61, 0x69,
	0x6e, 0x6e, 0x65, 0x74, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x47, 0x6f, 0x65, 0x72, 0x6c, 0x69, 0x2e,
	0xda, 0x41, 0x12, 0x6d, 0x70, 0x63, 0x5f, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x2c, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x3a, 0x01, 0x2a, 0x22, 0x35,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6d, 0x70, 0x63, 0x5f, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x3d,
	0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x70, 0x63, 0x57, 0x61, 0x6c, 0x6c, 0x65,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0xcf, 0x01, 0x0a, 0x0a, 0x47, 0x65, 0x74, 0x41, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x12, 0x30, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x70, 0x63, 0x5f, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x70, 0x63, 0x5f, 0x77, 0x61, 0x6c, 0x6c,
	0x65, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x22, 0x67,
	0x92, 0x41, 0x34, 0x12, 0x0a, 0x47, 0x65, 0x74, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x1a,
	0x26, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x73, 0x20, 0x61, 0x6e, 0x20, 0x41, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x20, 0x62, 0x79, 0x20, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x2e, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x23, 0x12, 0x21, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xf9, 0x01, 0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74,
	0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x12, 0x33, 0x2e, 0x63, 0x6f, 0x69, 0x6e,
	0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x70, 0x63, 0x5f, 0x77,
	0x61, 0x6c, 0x6c, 0x65, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34,
	0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x70, 0x63, 0x5f, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x7d, 0x92, 0x41, 0x3d, 0x12, 0x0d, 0x4c, 0x69, 0x73, 0x74, 0x41,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x1a, 0x2c, 0x52, 0x65, 0x74, 0x75, 0x72, 0x6e,
	0x73, 0x20, 0x61, 0x20, 0x6c, 0x69, 0x73, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x41, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x65, 0x73, 0x20, 0x69, 0x6e, 0x20, 0x61, 0x6e, 0x20, 0x4d, 0x50, 0x43, 0x57,
	0x61, 0x6c, 0x6c, 0x65, 0x74, 0x2e, 0xda, 0x41, 0x11, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c,
	0x6d, 0x70, 0x63, 0x5f, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x23,
	0x12, 0x21, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x65, 0x73, 0x12, 0xe4, 0x01, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x6c, 0x61,
	0x6e, 0x63, 0x65, 0x73, 0x12, 0x32, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x70, 0x63, 0x5f, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62,
	0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x70, 0x63, 0x5f, 0x77, 0x61,
	0x6c, 0x6c, 0x65, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x6c,
	0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x6b, 0x92,
	0x41, 0x2b, 0x12, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x1a, 0x1b, 0x52, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x73, 0x20, 0x61, 0x20, 0x6c, 0x69, 0x73, 0x74,
	0x20, 0x6f, 0x66, 0x20, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2e, 0xda, 0x41, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2e, 0x12, 0x2c, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x94, 0x02, 0x0a, 0x12, 0x4c,
	0x69, 0x73, 0x74, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x12, 0x38, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x70, 0x63, 0x5f, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x63, 0x6f,
	0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x70, 0x63,
	0x5f, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x88, 0x01, 0x92, 0x41, 0x37, 0x12, 0x12, 0x4c, 0x69,
	0x73, 0x74, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x1a, 0x21, 0x52, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x73, 0x20, 0x61, 0x20, 0x6c, 0x69, 0x73, 0x74,
	0x20, 0x6f, 0x66, 0x20, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x2e, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x3f, 0x12, 0x3d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x1a, 0xad, 0x03, 0x92, 0x41, 0xfb, 0x02, 0x12, 0xf8, 0x02, 0x41, 0x20, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x73, 0x20, 0x42, 0x49, 0x50, 0x2d, 0x33, 0x32, 0x2d, 0x62, 0x61, 0x73, 0x65, 0x64, 0x20, 0x48,
	0x69, 0x65, 0x72, 0x61, 0x72, 0x63, 0x68, 0x69, 0x63, 0x61, 0x6c, 0x6c, 0x79, 0x20, 0x44, 0x65,
	0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x69, 0x73, 0x74, 0x69, 0x63, 0x20, 0x28, 0x48, 0x44, 0x29,
	0x20, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x6f, 0x66, 0x20,
	0x6f, 0x6e, 0x2d, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x20, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x65, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x74, 0x68, 0x65, 0x69, 0x72, 0x20, 0x61, 0x73, 0x73,
	0x6f, 0x63, 0x69, 0x61, 0x74, 0x65, 0x64, 0x20, 0x41, 0x73, 0x73, 0x65, 0x74, 0x20, 0x62, 0x61,
	0x6c, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2e, 0x20, 0x54, 0x68, 0x65, 0x20, 0x41, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x65, 0x73, 0x20, 0x61, 0x72, 0x65, 0x20, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x64,
	0x20, 0x62, 0x79, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4d, 0x50, 0x43, 0x4b, 0x65, 0x79, 0x20, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x4b, 0x65, 0x79, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2c, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x69, 0x6e, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x61, 0x62, 0x6f, 0x75, 0x74, 0x20, 0x74, 0x68,
	0x65, 0x20, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x20, 0x63, 0x61, 0x6e, 0x20, 0x62, 0x65, 0x20,
	0x71, 0x75, 0x65, 0x72, 0x69, 0x65, 0x64, 0x20, 0x75, 0x73, 0x69, 0x6e, 0x67, 0x20, 0x42, 0x6c,
	0x6f, 0x63, 0x6b, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e,
	0x20, 0x42, 0x65, 0x63, 0x61, 0x75, 0x73, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20,
	0x62, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x20, 0x62, 0x79, 0x20, 0x4d, 0x50, 0x43, 0x20, 0x4b,
	0x65, 0x79, 0x73, 0x2c, 0x20, 0x66, 0x75, 0x6c, 0x6c, 0x20, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x73, 0x65,
	0x20, 0x41, 0x50, 0x49, 0x73, 0x20, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x73, 0x20, 0x75,
	0x73, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x57, 0x61, 0x61, 0x53, 0x20, 0x53,
	0x44, 0x4b, 0x2e, 0xca, 0x41, 0x2b, 0x61, 0x70, 0x69, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f,
	0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x77, 0x61, 0x61, 0x73, 0x2f, 0x6d, 0x70, 0x63, 0x5f, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74,
	0x73, 0x42, 0xbf, 0x01, 0x5a, 0x4f, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2f, 0x77, 0x61, 0x61, 0x73, 0x2d, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2d, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x2d, 0x67, 0x6f,
	0x2f, 0x67, 0x65, 0x6e, 0x2f, 0x67, 0x6f, 0x2f, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x70, 0x63, 0x5f, 0x77, 0x61, 0x6c, 0x6c, 0x65,
	0x74, 0x73, 0x2f, 0x76, 0x31, 0x92, 0x41, 0x6b, 0x12, 0x15, 0x0a, 0x0e, 0x4d, 0x50, 0x43, 0x57,
	0x61, 0x6c, 0x6c, 0x65, 0x74, 0x73, 0x20, 0x41, 0x50, 0x49, 0x32, 0x03, 0x31, 0x2e, 0x30, 0x1a,
	0x2b, 0x61, 0x70, 0x69, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63,
	0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x77, 0x61, 0x61, 0x73,
	0x2f, 0x6d, 0x70, 0x63, 0x5f, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x73, 0x2a, 0x01, 0x02, 0x32,
	0x10, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x6a, 0x73, 0x6f,
	0x6e, 0x3a, 0x10, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x6a,
	0x73, 0x6f, 0x6e, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_rawDescOnce sync.Once
	file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_rawDescData = file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_rawDesc
)

func file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_rawDescGZIP() []byte {
	file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_rawDescOnce.Do(func() {
		file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_rawDescData = protoimpl.X.CompressGZIP(file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_rawDescData)
	})
	return file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_rawDescData
}

var file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes = make([]protoimpl.MessageInfo, 17)
var file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_goTypes = []interface{}{
	(*MPCWallet)(nil),                  // 0: coinbase.cloud.mpc_wallets.v1.MPCWallet
	(*Address)(nil),                    // 1: coinbase.cloud.mpc_wallets.v1.Address
	(*Balance)(nil),                    // 2: coinbase.cloud.mpc_wallets.v1.Balance
	(*BalanceDetail)(nil),              // 3: coinbase.cloud.mpc_wallets.v1.BalanceDetail
	(*CreateMPCWalletRequest)(nil),     // 4: coinbase.cloud.mpc_wallets.v1.CreateMPCWalletRequest
	(*CreateMPCWalletMetadata)(nil),    // 5: coinbase.cloud.mpc_wallets.v1.CreateMPCWalletMetadata
	(*GetMPCWalletRequest)(nil),        // 6: coinbase.cloud.mpc_wallets.v1.GetMPCWalletRequest
	(*ListMPCWalletsRequest)(nil),      // 7: coinbase.cloud.mpc_wallets.v1.ListMPCWalletsRequest
	(*ListMPCWalletsResponse)(nil),     // 8: coinbase.cloud.mpc_wallets.v1.ListMPCWalletsResponse
	(*GenerateAddressRequest)(nil),     // 9: coinbase.cloud.mpc_wallets.v1.GenerateAddressRequest
	(*GetAddressRequest)(nil),          // 10: coinbase.cloud.mpc_wallets.v1.GetAddressRequest
	(*ListAddressesRequest)(nil),       // 11: coinbase.cloud.mpc_wallets.v1.ListAddressesRequest
	(*ListAddressesResponse)(nil),      // 12: coinbase.cloud.mpc_wallets.v1.ListAddressesResponse
	(*ListBalancesRequest)(nil),        // 13: coinbase.cloud.mpc_wallets.v1.ListBalancesRequest
	(*ListBalancesResponse)(nil),       // 14: coinbase.cloud.mpc_wallets.v1.ListBalancesResponse
	(*ListBalanceDetailsRequest)(nil),  // 15: coinbase.cloud.mpc_wallets.v1.ListBalanceDetailsRequest
	(*ListBalanceDetailsResponse)(nil), // 16: coinbase.cloud.mpc_wallets.v1.ListBalanceDetailsResponse
	(*v1.Asset_Definition)(nil),        // 17: coinbase.cloud.blockchain.v1.Asset.Definition
	(*longrunning.Operation)(nil),      // 18: google.longrunning.Operation
}
var file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_depIdxs = []int32{
	17, // 0: coinbase.cloud.mpc_wallets.v1.BalanceDetail.asset_definition:type_name -> coinbase.cloud.blockchain.v1.Asset.Definition
	0,  // 1: coinbase.cloud.mpc_wallets.v1.CreateMPCWalletRequest.mpc_wallet:type_name -> coinbase.cloud.mpc_wallets.v1.MPCWallet
	0,  // 2: coinbase.cloud.mpc_wallets.v1.ListMPCWalletsResponse.mpc_wallets:type_name -> coinbase.cloud.mpc_wallets.v1.MPCWallet
	1,  // 3: coinbase.cloud.mpc_wallets.v1.ListAddressesResponse.addresses:type_name -> coinbase.cloud.mpc_wallets.v1.Address
	2,  // 4: coinbase.cloud.mpc_wallets.v1.ListBalancesResponse.balances:type_name -> coinbase.cloud.mpc_wallets.v1.Balance
	3,  // 5: coinbase.cloud.mpc_wallets.v1.ListBalanceDetailsResponse.balance_details:type_name -> coinbase.cloud.mpc_wallets.v1.BalanceDetail
	4,  // 6: coinbase.cloud.mpc_wallets.v1.MPCWalletService.CreateMPCWallet:input_type -> coinbase.cloud.mpc_wallets.v1.CreateMPCWalletRequest
	6,  // 7: coinbase.cloud.mpc_wallets.v1.MPCWalletService.GetMPCWallet:input_type -> coinbase.cloud.mpc_wallets.v1.GetMPCWalletRequest
	7,  // 8: coinbase.cloud.mpc_wallets.v1.MPCWalletService.ListMPCWallets:input_type -> coinbase.cloud.mpc_wallets.v1.ListMPCWalletsRequest
	9,  // 9: coinbase.cloud.mpc_wallets.v1.MPCWalletService.GenerateAddress:input_type -> coinbase.cloud.mpc_wallets.v1.GenerateAddressRequest
	10, // 10: coinbase.cloud.mpc_wallets.v1.MPCWalletService.GetAddress:input_type -> coinbase.cloud.mpc_wallets.v1.GetAddressRequest
	11, // 11: coinbase.cloud.mpc_wallets.v1.MPCWalletService.ListAddresses:input_type -> coinbase.cloud.mpc_wallets.v1.ListAddressesRequest
	13, // 12: coinbase.cloud.mpc_wallets.v1.MPCWalletService.ListBalances:input_type -> coinbase.cloud.mpc_wallets.v1.ListBalancesRequest
	15, // 13: coinbase.cloud.mpc_wallets.v1.MPCWalletService.ListBalanceDetails:input_type -> coinbase.cloud.mpc_wallets.v1.ListBalanceDetailsRequest
	18, // 14: coinbase.cloud.mpc_wallets.v1.MPCWalletService.CreateMPCWallet:output_type -> google.longrunning.Operation
	0,  // 15: coinbase.cloud.mpc_wallets.v1.MPCWalletService.GetMPCWallet:output_type -> coinbase.cloud.mpc_wallets.v1.MPCWallet
	8,  // 16: coinbase.cloud.mpc_wallets.v1.MPCWalletService.ListMPCWallets:output_type -> coinbase.cloud.mpc_wallets.v1.ListMPCWalletsResponse
	1,  // 17: coinbase.cloud.mpc_wallets.v1.MPCWalletService.GenerateAddress:output_type -> coinbase.cloud.mpc_wallets.v1.Address
	1,  // 18: coinbase.cloud.mpc_wallets.v1.MPCWalletService.GetAddress:output_type -> coinbase.cloud.mpc_wallets.v1.Address
	12, // 19: coinbase.cloud.mpc_wallets.v1.MPCWalletService.ListAddresses:output_type -> coinbase.cloud.mpc_wallets.v1.ListAddressesResponse
	14, // 20: coinbase.cloud.mpc_wallets.v1.MPCWalletService.ListBalances:output_type -> coinbase.cloud.mpc_wallets.v1.ListBalancesResponse
	16, // 21: coinbase.cloud.mpc_wallets.v1.MPCWalletService.ListBalanceDetails:output_type -> coinbase.cloud.mpc_wallets.v1.ListBalanceDetailsResponse
	14, // [14:22] is the sub-list for method output_type
	6,  // [6:14] is the sub-list for method input_type
	6,  // [6:6] is the sub-list for extension type_name
	6,  // [6:6] is the sub-list for extension extendee
	0,  // [0:6] is the sub-list for field type_name
}

func init() { file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_init() }
func file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_init() {
	if File_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MPCWallet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Address); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Balance); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BalanceDetail); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateMPCWalletRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateMPCWalletMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetMPCWalletRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListMPCWalletsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListMPCWalletsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateAddressRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAddressRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAddressesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAddressesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListBalancesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListBalancesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListBalanceDetailsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListBalanceDetailsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   17,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_goTypes,
		DependencyIndexes: file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_depIdxs,
		MessageInfos:      file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_msgTypes,
	}.Build()
	File_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto = out.File
	file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_rawDesc = nil
	file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_goTypes = nil
	file_coinbase_cloud_mpc_wallets_v1_mpc_wallets_proto_depIdxs = nil
}
