# Summary

- [Primer](README.md)
  - [Approaches](about.md)
  - [Installation](install.md)
- [Features](features.md)
- Tutorials
  - [Simple Server](tutorial/todo-list.md)
  - [Custom Server](tutorial/custom-server.md)
  - [Dynamic Server](tutorial/dynamic.md)
  - Security
    - [Authentication](tutorial/authentication/README.md)
    - [OAuth2](tutorial/oauth2/README.md)
    - [Composition](tutorial/composed-auth/README.md)
- Use-Cases
  - [Options and commands](usage/swagger.md)
  - [Serve UI](usage/serve_ui.md)
  - [Validate](usage/validate.md)
  - [Diff](usage/diff.md)
  - [Transform spec](use/transform.md)
    - [Expand](usage/expand.md)
    - [Flatten](usage/flatten.md)
    - [Mixin](usage/mixin.md)
  - [Generate markdown](usage/markdown.md)
  - Generate code from spec
    - [Dependencies & Requirements](generate/requirements.md)
    - [API Client](generate/client.md)
    - [CLI (Command Line Tool)](generate/cli.md)
    - API Server
      - [Server Usage](generate/server.md)
      - [How to use the server](use/server.md)
    - API Model
      - [Model Usage](generate/model.md)
      - [How to use models](use/model.md)
        - [Schema generation rules](use/models/schemas.md)
  - Generate spec from source
      - [Spec Usage](generate/spec.md)
      - [Spec generation rules](use/spec.md)
        - [swagger:meta](use/spec/meta.md)
        - [swagger:route](use/spec/route.md)
        - [swagger:params](use/spec/params.md)
        - [swagger:operation](use/spec/operation.md)
        - [swagger:response](use/spec/response.md)
        - [swagger:model](use/spec/model.md)
        - [swagger:allOf](use/spec/allOf.md)
        - [swagger:strfmt](use/spec/strfmt.md)
        - [swagger:discriminated](use/spec/discriminated.md)
        - [swagger:ignore](use/spec/ignore.md)
- [Using middleware](use/middleware.md)
- [Custom generation](use/template_layout.md)
  - [Custom templates](generate/templates.md)
- [CLI autocompletion](cli_helpers.md)
- [Guidelines to maintainers](guidelines/README.md)
- [FAQ](faq/README.md)
  - [Installation,setup and environment](faq/faq_setup.md)
  - [Model generation](faq/faq_model.md)
  - [Server generation & customization](faq/faq_server.md)
  - [Client generation](faq/faq_client.md)
  - [Spec generation from source](faq/faq_spec.md)
  - [API testing](faq/faq_testing.md)
  - [Documenting your API](faq/faq_documenting.md)
  - [Swagger specification](faq/faq_swagger.md)
