// Code generated by go-swagger; DO NOT EDIT.

package tasks

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"net/http"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// NewListTasksParams creates a new ListTasksParams object
// with the default values initialized.
func NewListTasksParams() ListTasksParams {

	var (
		// initialize parameters with default values

		pageSizeDefault = int32(20)
	)

	return ListTasksParams{
		PageSize: &pageSizeDefault,
	}
}

// ListTasksParams contains all the bound params for the list tasks operation
// typically these are obtained from a http.Request
//
// swagger:parameters listTasks
type ListTasksParams struct {

	// HTTP Request Object
	HTTPRequest *http.Request `json:"-"`

	/*Amount of items to return in a single page
	  In: query
	  Default: 20
	*/
	PageSize *int32
	/*The last id that was seen.
	  In: query
	*/
	SinceID *int64
	/*the status to filter by
	  Unique: true
	  In: query
	  Collection Format: pipes
	*/
	Status []string
	/*the tags to filter by
	  Unique: true
	  In: query
	*/
	Tags []string
}

// BindRequest both binds and validates a request, it assumes that complex things implement a Validatable(strfmt.Registry) error interface
// for simple values it will use straight method calls.
//
// To ensure default values, the struct must have been initialized with NewListTasksParams() beforehand.
func (o *ListTasksParams) BindRequest(r *http.Request, route *middleware.MatchedRoute) error {
	var res []error

	o.HTTPRequest = r

	qs := runtime.Values(r.URL.Query())

	qPageSize, qhkPageSize, _ := qs.GetOK("pageSize")
	if err := o.bindPageSize(qPageSize, qhkPageSize, route.Formats); err != nil {
		res = append(res, err)
	}

	qSinceID, qhkSinceID, _ := qs.GetOK("sinceId")
	if err := o.bindSinceID(qSinceID, qhkSinceID, route.Formats); err != nil {
		res = append(res, err)
	}

	qStatus, qhkStatus, _ := qs.GetOK("status")
	if err := o.bindStatus(qStatus, qhkStatus, route.Formats); err != nil {
		res = append(res, err)
	}

	qTags, qhkTags, _ := qs.GetOK("tags")
	if err := o.bindTags(qTags, qhkTags, route.Formats); err != nil {
		res = append(res, err)
	}
	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindPageSize binds and validates parameter PageSize from query.
func (o *ListTasksParams) bindPageSize(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: false
	// AllowEmptyValue: false

	if raw == "" { // empty values pass all other validations
		// Default values have been previously initialized by NewListTasksParams()
		return nil
	}

	value, err := swag.ConvertInt32(raw)
	if err != nil {
		return errors.InvalidType("pageSize", "query", "int32", raw)
	}
	o.PageSize = &value

	return nil
}

// bindSinceID binds and validates parameter SinceID from query.
func (o *ListTasksParams) bindSinceID(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: false
	// AllowEmptyValue: false

	if raw == "" { // empty values pass all other validations
		return nil
	}

	value, err := swag.ConvertInt64(raw)
	if err != nil {
		return errors.InvalidType("sinceId", "query", "int64", raw)
	}
	o.SinceID = &value

	return nil
}

// bindStatus binds and validates array parameter Status from query.
//
// Arrays are parsed according to CollectionFormat: "pipes" (defaults to "csv" when empty).
func (o *ListTasksParams) bindStatus(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var qvStatus string
	if len(rawData) > 0 {
		qvStatus = rawData[len(rawData)-1]
	}

	// CollectionFormat: pipes
	statusIC := swag.SplitByFormat(qvStatus, "pipes")
	if len(statusIC) == 0 {
		return nil
	}

	var statusIR []string
	for i, statusIV := range statusIC {
		statusI := statusIV

		if err := validate.EnumCase(fmt.Sprintf("%s.%v", "status", i), "query", statusI, []interface{}{"open", "closed", "ignored", "rejected"}, true); err != nil {
			return err
		}

		statusIR = append(statusIR, statusI)
	}

	o.Status = statusIR
	if err := o.validateStatus(formats); err != nil {
		return err
	}

	return nil
}

// validateStatus carries on validations for parameter Status
func (o *ListTasksParams) validateStatus(formats strfmt.Registry) error {

	// uniqueItems: true
	if err := validate.UniqueItems("status", "query", o.Status); err != nil {
		return err
	}
	return nil
}

// bindTags binds and validates array parameter Tags from query.
//
// Arrays are parsed according to CollectionFormat: "" (defaults to "csv" when empty).
func (o *ListTasksParams) bindTags(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var qvTags string
	if len(rawData) > 0 {
		qvTags = rawData[len(rawData)-1]
	}

	// CollectionFormat:
	tagsIC := swag.SplitByFormat(qvTags, "")
	if len(tagsIC) == 0 {
		return nil
	}

	var tagsIR []string
	for _, tagsIV := range tagsIC {
		tagsI := tagsIV

		tagsIR = append(tagsIR, tagsI)
	}

	o.Tags = tagsIR
	if err := o.validateTags(formats); err != nil {
		return err
	}

	return nil
}

// validateTags carries on validations for parameter Tags
func (o *ListTasksParams) validateTags(formats strfmt.Registry) error {

	// uniqueItems: true
	if err := validate.UniqueItems("tags", "query", o.Tags); err != nil {
		return err
	}
	return nil
}
