# Changelog

## [v0.26.1](https://github.com/go-swagger/go-swagger/tree/v0.26.1) (2021-02-05)

[Full Changelog](https://github.com/go-swagger/go-swagger/compare/v0.26.0...v0.26.1)

**Implemented enhancements:**

- Can't configure content type in generated client [\#1924](https://github.com/go-swagger/go-swagger/issues/1924)

**Fixed bugs:**

- Generate models from official docker specification [\#2494](https://github.com/go-swagger/go-swagger/issues/2494)
- Could not resolve reference: invalid character looking for beginning of value [\#2492](https://github.com/go-swagger/go-swagger/issues/2492)

**Closed issues:**

- swagger:strfmt annotation incompatible with slice type [\#2505](https://github.com/go-swagger/go-swagger/issues/2505)
- 0.26.0 - Enum constants are not unique for some special characters [\#2501](https://github.com/go-swagger/go-swagger/issues/2501)
- upgrade to version 0.26.0 introduces error `undefined: validate.WithOperationRequest` in generated code [\#2498](https://github.com/go-swagger/go-swagger/issues/2498)
- Unable to generate specification for "hello world" [\#2101](https://github.com/go-swagger/go-swagger/issues/2101)

**Merged pull requests:**

- added sudo to debian install [\#2509](https://github.com/go-swagger/go-swagger/pull/2509) ([somersbmatthews](https://github.com/somersbmatthews))
- Update-ReadOnly-Documentation [\#2508](https://github.com/go-swagger/go-swagger/pull/2508) ([youyuanwu](https://github.com/youyuanwu))
- add client option to client template. [\#2507](https://github.com/go-swagger/go-swagger/pull/2507) ([gmidorii](https://github.com/gmidorii))
- Fix input swagger file docs for spec generation [\#2504](https://github.com/go-swagger/go-swagger/pull/2504) ([oliverbenns](https://github.com/oliverbenns))
- Generator: Handle special characters \*, /, and = [\#2502](https://github.com/go-swagger/go-swagger/pull/2502) ([armsnyder](https://github.com/armsnyder))
- fixed map elements which are arrays should never be rendered with a pointer [\#2497](https://github.com/go-swagger/go-swagger/pull/2497) ([fredbi](https://github.com/fredbi))
- updated go-openapi/spec and go-openapi/loads [\#2496](https://github.com/go-swagger/go-swagger/pull/2496) ([fredbi](https://github.com/fredbi))
- fix: use single quotes for pwd in alias [\#2495](https://github.com/go-swagger/go-swagger/pull/2495) ([jadwahab](https://github.com/jadwahab))

## [v0.26.0](https://github.com/go-swagger/go-swagger/tree/v0.26.0) (2021-01-19)

[Full Changelog](https://github.com/go-swagger/go-swagger/compare/v0.25.0...v0.26.0)

**Implemented enhancements:**

- Generate client: example struct tag is not rendered properly [\#2445](https://github.com/go-swagger/go-swagger/issues/2445)
- model validations: support minProperties and maxProperties [\#2444](https://github.com/go-swagger/go-swagger/issues/2444)
- Option to overwrite buffer size on upload file api  [\#2373](https://github.com/go-swagger/go-swagger/issues/2373)
- v0.25.0 generates incorrect imports [\#2362](https://github.com/go-swagger/go-swagger/issues/2362)
- go-swagger is generating invalid validation functions [\#2163](https://github.com/go-swagger/go-swagger/issues/2163)
- Unused variable i [\#1771](https://github.com/go-swagger/go-swagger/issues/1771)
- "swagger generate model" does nothing if no paths are defined [\#1679](https://github.com/go-swagger/go-swagger/issues/1679)
- Principal should support definition as an interface [\#1659](https://github.com/go-swagger/go-swagger/issues/1659)
- go-swagger version depends on git [\#1283](https://github.com/go-swagger/go-swagger/issues/1283)
- Improve readability of templates used for code generation [\#673](https://github.com/go-swagger/go-swagger/issues/673)
- option for case insensitivity for enum query params [\#303](https://github.com/go-swagger/go-swagger/issues/303)
- Generate markdown representation for a swagger specification [\#184](https://github.com/go-swagger/go-swagger/issues/184)

**Fixed bugs:**

- Optional Headers array parameters generated client code doesn't compile [\#2471](https://github.com/go-swagger/go-swagger/issues/2471)
- custom tags are not added to instances of objects when specified [\#2457](https://github.com/go-swagger/go-swagger/issues/2457)
- Go swagger can't validate all uint64 in path parameters [\#2448](https://github.com/go-swagger/go-swagger/issues/2448)
- authorizationUrl empty breaking mixin and validation [\#2430](https://github.com/go-swagger/go-swagger/issues/2430)
- swagger validate fails on responses with description field [\#2429](https://github.com/go-swagger/go-swagger/issues/2429)
- Backticks appearing in tags are not properly handled [\#2423](https://github.com/go-swagger/go-swagger/issues/2423)
- Shadowing api var in generated main.go [\#2405](https://github.com/go-swagger/go-swagger/issues/2405)
- How to define properties of an object \(that are referenced to definitions\) as required ? [\#2400](https://github.com/go-swagger/go-swagger/issues/2400)
- x-go-type for a custom type in models/ [\#2385](https://github.com/go-swagger/go-swagger/issues/2385)
- Missing required validation for property referencing string [\#2381](https://github.com/go-swagger/go-swagger/issues/2381)
- allOf is always pointer using inheritance [\#2364](https://github.com/go-swagger/go-swagger/issues/2364)
- Wrong generation for required object parameters [\#2330](https://github.com/go-swagger/go-swagger/issues/2330)
- Required, Non Nil map\[string\]interface{} [\#2300](https://github.com/go-swagger/go-swagger/issues/2300)
- Support Basic-Auth and custom HTTP Headers when loading a swagger spec [\#2263](https://github.com/go-swagger/go-swagger/issues/2263)
- nested  $ref not found [\#2113](https://github.com/go-swagger/go-swagger/issues/2113)
- Default value for csv parameter \[\]interface{} instead of \[\]string [\#2096](https://github.com/go-swagger/go-swagger/issues/2096)
- Required object value without type produces broken validator [\#2081](https://github.com/go-swagger/go-swagger/issues/2081)
- Allow empty string for authorizationUrl in security definition [\#1775](https://github.com/go-swagger/go-swagger/issues/1775)
- go-swagger generate client generates wrong default formData parameter type for array of strings [\#1753](https://github.com/go-swagger/go-swagger/issues/1753)
- Client generation breaks on nested structures [\#1505](https://github.com/go-swagger/go-swagger/issues/1505)
- no consumer registered error when "Transfer-Encoding: chunked" is provided [\#1430](https://github.com/go-swagger/go-swagger/issues/1430)
- Generated Client - Panic with binary downloads [\#883](https://github.com/go-swagger/go-swagger/issues/883)
- Tips for debugging BindValidRequest\(\) errors? [\#773](https://github.com/go-swagger/go-swagger/issues/773)

**Closed issues:**

- Missing info on how to build specific version from source [\#2474](https://github.com/go-swagger/go-swagger/issues/2474)
- x-omitempty doesn't work with a $ref'ed object [\#2473](https://github.com/go-swagger/go-swagger/issues/2473)
- Generated client doesn't detect mongodb primitive.ObjectID [\#2468](https://github.com/go-swagger/go-swagger/issues/2468)
- swagger serve openapi apidocs failed [\#2463](https://github.com/go-swagger/go-swagger/issues/2463)
- Petstore example does not work [\#2459](https://github.com/go-swagger/go-swagger/issues/2459)
- How can I merge YAML file after generation with openapi v3 YAML file [\#2437](https://github.com/go-swagger/go-swagger/issues/2437)
- Backticks in  [\#2422](https://github.com/go-swagger/go-swagger/issues/2422)
- Update generation doc regarding Terms of Services [\#2421](https://github.com/go-swagger/go-swagger/issues/2421)
- No definition for aliased struct with the same name [\#2416](https://github.com/go-swagger/go-swagger/issues/2416)
- Embedded uuid field interpreted as bytearray [\#2404](https://github.com/go-swagger/go-swagger/issues/2404)
- disable try it out button [\#2402](https://github.com/go-swagger/go-swagger/issues/2402)
- How can I generate `swagger:parameters` spec using form tag from struct? [\#2399](https://github.com/go-swagger/go-swagger/issues/2399)
- Why is version always dev? [\#2395](https://github.com/go-swagger/go-swagger/issues/2395)
- Expanding schema with cyclic ref is underterministic [\#2393](https://github.com/go-swagger/go-swagger/issues/2393)
- Append cline.Text  to classify error [\#2391](https://github.com/go-swagger/go-swagger/issues/2391)
- principal alias imports bug in v0.25.0 [\#2372](https://github.com/go-swagger/go-swagger/issues/2372)
- Upload of large files fails due to 32 mb limit [\#2370](https://github.com/go-swagger/go-swagger/issues/2370)
- Can't set custom PORT [\#2363](https://github.com/go-swagger/go-swagger/issues/2363)
- is latest go-openapi/errors incompatible with swagger generation? [\#2361](https://github.com/go-swagger/go-swagger/issues/2361)
- Comitting generated code to version control [\#2360](https://github.com/go-swagger/go-swagger/issues/2360)
- Is it possible to publish a new release [\#2357](https://github.com/go-swagger/go-swagger/issues/2357)
- JSON 'unknown field' error when using allOf composition [\#2350](https://github.com/go-swagger/go-swagger/issues/2350)
- Client File Upload 0 Bytes [\#1838](https://github.com/go-swagger/go-swagger/issues/1838)

**Merged pull requests:**

- updated deps to go-openapi libraries [\#2490](https://github.com/go-swagger/go-swagger/pull/2490) ([fredbi](https://github.com/fredbi))
- fixed indenting / comment spacing issues [\#2489](https://github.com/go-swagger/go-swagger/pull/2489) ([fredbi](https://github.com/fredbi))
- added a configurable var to set the max amount of memory for multipart.ParseMultiPartForm [\#2488](https://github.com/go-swagger/go-swagger/pull/2488) ([fredbi](https://github.com/fredbi))
- added example illustrating file upload with a multipart form [\#2487](https://github.com/go-swagger/go-swagger/pull/2487) ([fredbi](https://github.com/fredbi))
- Fix 883 [\#2486](https://github.com/go-swagger/go-swagger/pull/2486) ([fredbi](https://github.com/fredbi))
- regenerated examples [\#2485](https://github.com/go-swagger/go-swagger/pull/2485) ([fredbi](https://github.com/fredbi))
- fixed generated client issues for nested array parameters and response headers [\#2484](https://github.com/go-swagger/go-swagger/pull/2484) ([fredbi](https://github.com/fredbi))
- relinted all packages [\#2481](https://github.com/go-swagger/go-swagger/pull/2481) ([fredbi](https://github.com/fredbi))
- Removed redundant unit tests from CI [\#2480](https://github.com/go-swagger/go-swagger/pull/2480) ([fredbi](https://github.com/fredbi))
- generate client: added support for array parameter in header [\#2478](https://github.com/go-swagger/go-swagger/pull/2478) ([fredbi](https://github.com/fredbi))
- added support for minProperties, maxProperties validations [\#2477](https://github.com/go-swagger/go-swagger/pull/2477) ([fredbi](https://github.com/fredbi))
- refactored validations handling in models and type resolver [\#2476](https://github.com/go-swagger/go-swagger/pull/2476) ([fredbi](https://github.com/fredbi))
- add specific version install info [\#2475](https://github.com/go-swagger/go-swagger/pull/2475) ([blami](https://github.com/blami))
- added markdown generator [\#2466](https://github.com/go-swagger/go-swagger/pull/2466) ([fredbi](https://github.com/fredbi))
- Ensure enum variant name is unique [\#2464](https://github.com/go-swagger/go-swagger/pull/2464) ([mraerino](https://github.com/mraerino))
- CLI version: added versioning from module support for go get users [\#2462](https://github.com/go-swagger/go-swagger/pull/2462) ([fredbi](https://github.com/fredbi))
- fixed doc in petstore example [\#2461](https://github.com/go-swagger/go-swagger/pull/2461) ([fredbi](https://github.com/fredbi))
- refactored, documented and tested tags in models [\#2460](https://github.com/go-swagger/go-swagger/pull/2460) ([fredbi](https://github.com/fredbi))
- ensure custom tag is applied to object in generated model \(\#2457\) [\#2458](https://github.com/go-swagger/go-swagger/pull/2458) ([bobcallaway](https://github.com/bobcallaway))
- fixed numerical validations for integer types [\#2453](https://github.com/go-swagger/go-swagger/pull/2453) ([fredbi](https://github.com/fredbi))
- test: model tests go parallel [\#2450](https://github.com/go-swagger/go-swagger/pull/2450) ([fredbi](https://github.com/fredbi))
- escape backticks in regex patterns [\#2449](https://github.com/go-swagger/go-swagger/pull/2449) ([casualjim](https://github.com/casualjim))
- Generate example struct tag if example is provided [\#2447](https://github.com/go-swagger/go-swagger/pull/2447) ([sbstp](https://github.com/sbstp))
- auth: added support for adding a principal as an interface  [\#2442](https://github.com/go-swagger/go-swagger/pull/2442) ([fredbi](https://github.com/fredbi))
- fixed generated package resolution for principal [\#2440](https://github.com/go-swagger/go-swagger/pull/2440) ([fredbi](https://github.com/fredbi))
- Added more control over external types [\#2438](https://github.com/go-swagger/go-swagger/pull/2438) ([fredbi](https://github.com/fredbi))
- Acknowledged codegen regression fixed [\#2435](https://github.com/go-swagger/go-swagger/pull/2435) ([fredbi](https://github.com/fredbi))
- Fixed required aliased type [\#2434](https://github.com/go-swagger/go-swagger/pull/2434) ([fredbi](https://github.com/fredbi))
- fixup replace clause left in go.mod [\#2433](https://github.com/go-swagger/go-swagger/pull/2433) ([fredbi](https://github.com/fredbi))
- Updated go-openapi [\#2432](https://github.com/go-swagger/go-swagger/pull/2432) ([fredbi](https://github.com/fredbi))
- test\(generate spec\): extra code parsing assertions for the TermsOfService annotation [\#2431](https://github.com/go-swagger/go-swagger/pull/2431) ([fredbi](https://github.com/fredbi))
- updated go-openapi dependencies [\#2427](https://github.com/go-swagger/go-swagger/pull/2427) ([fredbi](https://github.com/fredbi))
- added validation guards against inconsistent validations [\#2426](https://github.com/go-swagger/go-swagger/pull/2426) ([fredbi](https://github.com/fredbi))
- Fixed missing Required validations [\#2425](https://github.com/go-swagger/go-swagger/pull/2425) ([fredbi](https://github.com/fredbi))
- fixed server codegen package conflicts when specifying --server-package and --api-package [\#2424](https://github.com/go-swagger/go-swagger/pull/2424) ([fredbi](https://github.com/fredbi))
- Change comment in server template: add periods at the end [\#2418](https://github.com/go-swagger/go-swagger/pull/2418) ([alexandear](https://github.com/alexandear))
- fix codescan, and support SelectorExpr with response. [\#2414](https://github.com/go-swagger/go-swagger/pull/2414) ([j2gg0s](https://github.com/j2gg0s))
- Fix 2391: Add more infomation to classify error [\#2392](https://github.com/go-swagger/go-swagger/pull/2392) ([tptpp](https://github.com/tptpp))
- Fix panics and boost coverage [\#2390](https://github.com/go-swagger/go-swagger/pull/2390) ([wjase](https://github.com/wjase))
- Pass examples to the generated models [\#2389](https://github.com/go-swagger/go-swagger/pull/2389) ([SVilgelm](https://github.com/SVilgelm))
- doc: fix issue of displaying code [\#2377](https://github.com/go-swagger/go-swagger/pull/2377) ([meysampg](https://github.com/meysampg))
- Added support to ignore conflicts in mixin command [\#2375](https://github.com/go-swagger/go-swagger/pull/2375) ([stijndehaes](https://github.com/stijndehaes))
- Feature/ReadOnly-Validation Support [\#2369](https://github.com/go-swagger/go-swagger/pull/2369) ([youyuanwu](https://github.com/youyuanwu))
- Fixed diff writing to file called stdout instead of os.StdOut [\#2367](https://github.com/go-swagger/go-swagger/pull/2367) ([wjase](https://github.com/wjase))
- Fix VMware reference. [\#2366](https://github.com/go-swagger/go-swagger/pull/2366) ([zmb3](https://github.com/zmb3))
- allow x-nullable hint to override allOf nullability status [\#2365](https://github.com/go-swagger/go-swagger/pull/2365) ([fredbi](https://github.com/fredbi))
- Acknowledged fixes from go-openapi/spec updates [\#2142](https://github.com/go-swagger/go-swagger/pull/2142) ([fredbi](https://github.com/fredbi))



\* *This Changelog was automatically generated by [github_changelog_generator](https://github.com/github-changelog-generator/github-changelog-generator)*
