[Full Changelog](https://github.com/go-swagger/go-swagger/compare/0.4.0...0.5.0)

**Implemented enhancements:**

- No consumers and producers for "text/plain" in the client runtime [#360](https://github.com/go-swagger/go-swagger/issues/360)
- No consumers and producers for "application/xml" in the client runtime [#359](https://github.com/go-swagger/go-swagger/issues/359)
- Add http/unix socket transport [#278](https://github.com/go-swagger/go-swagger/issues/278)
- Clean up tutorial [#275](https://github.com/go-swagger/go-swagger/issues/275)

**Fixed bugs:**

- Basic auth doesn't compile [#406](https://github.com/go-swagger/go-swagger/issues/406)
- Recursive model definition causes infinite loop [#399](https://github.com/go-swagger/go-swagger/issues/399)
- No data fields in the response object [#384](https://github.com/go-swagger/go-swagger/issues/384)
- Validation code tries to compare a non-nullable with a nil value. [#381](https://github.com/go-swagger/go-swagger/issues/381)
- CLI help is printed twice. [#375](https://github.com/go-swagger/go-swagger/issues/375)
- Question - Expose the server port if a random port is used for the server  [#372](https://github.com/go-swagger/go-swagger/issues/372)
- Expanding nested items is broken. [#367](https://github.com/go-swagger/go-swagger/issues/367)
- Incorrect type used for validator [#363](https://github.com/go-swagger/go-swagger/issues/363)
- Generated comments on model types and client operations don't begin with the type / operation name in some cases [#356](https://github.com/go-swagger/go-swagger/issues/356)
- Wrong enum type names in the client generator [#352](https://github.com/go-swagger/go-swagger/issues/352)
- panic: on array/collectionFormat + validation [#351](https://github.com/go-swagger/go-swagger/issues/351)
- Default value is not generated for boolean type. [#350](https://github.com/go-swagger/go-swagger/issues/350)
- Generated model results in broken build [#340](https://github.com/go-swagger/go-swagger/issues/340)
- API client has wrong package name [#330](https://github.com/go-swagger/go-swagger/issues/330)
- duplicate declarations on a naming colision [#325](https://github.com/go-swagger/go-swagger/issues/325)
- Validator treats parameter references as errors [#321](https://github.com/go-swagger/go-swagger/issues/321)
- Issue with parameters of type file in the client generator [#320](https://github.com/go-swagger/go-swagger/issues/320)
- Map of base type generates a map of *Interface instead of map of Interface [#319](https://github.com/go-swagger/go-swagger/issues/319)
- Models: do not generate pointers and omitempty if property is required [#300](https://github.com/go-swagger/go-swagger/issues/300)

**Closed issues:**

- Panic expanding responses that are a schema ref with circular refs [#415](https://github.com/go-swagger/go-swagger/issues/415)
- No way to hook code after flags are parsed but before request handling starts [#403](https://github.com/go-swagger/go-swagger/issues/403)
- Tagging a parameter with "pattern" doesn't seem to always have affect [#369](https://github.com/go-swagger/go-swagger/issues/369)
- Boolean parameters are generated into strings [#346](https://github.com/go-swagger/go-swagger/issues/346)
- Missing package swag in generated models [#345](https://github.com/go-swagger/go-swagger/issues/345)
- Wrong httpkit/validate package in generated model files [#343](https://github.com/go-swagger/go-swagger/issues/343)
- String param with binary format in body does not validate [#341](https://github.com/go-swagger/go-swagger/issues/341)
- Add support for tar, gzip [#326](https://github.com/go-swagger/go-swagger/issues/326)
- The generated import path has incorrect prefix [#323](https://github.com/go-swagger/go-swagger/issues/323)
- Some --skip-* flags not working [#322](https://github.com/go-swagger/go-swagger/issues/322)
- Support for cookies in the client runtime [#308](https://github.com/go-swagger/go-swagger/issues/308)

**Merged pull requests:**

- adds dumpdata flags to client and server [#418](https://github.com/go-swagger/go-swagger/pull/418) ([casualjim](https://github.com/casualjim))
- resolves refs for parameters and responses, fixes #384 [#417](https://github.com/go-swagger/go-swagger/pull/417) ([casualjim](https://github.com/casualjim))
- fix Panic expanding responses that are a schema ref with circular [#416](https://github.com/go-swagger/go-swagger/pull/416) ([pytlesk4](https://github.com/pytlesk4))
- Don't panic when handling circular refs. [#414](https://github.com/go-swagger/go-swagger/pull/414) ([pytlesk4](https://github.com/pytlesk4))
- Fix build on all build servers [#412](https://github.com/go-swagger/go-swagger/pull/412) ([casualjim](https://github.com/casualjim))
- Remove dependency heavy goconvey [#411](https://github.com/go-swagger/go-swagger/pull/411) ([casualjim](https://github.com/casualjim))
- refines omitempty and fixes basicauth [#410](https://github.com/go-swagger/go-swagger/pull/410) ([casualjim](https://github.com/casualjim))
- Add *raw-stream mimetype mapping [#408](https://github.com/go-swagger/go-swagger/pull/408) ([sflxn](https://github.com/sflxn))
- Add setter to generated response writer [#405](https://github.com/go-swagger/go-swagger/pull/405) ([anfernee](https://github.com/anfernee))
- Allow empty content-type when allowed list is empty [#404](https://github.com/go-swagger/go-swagger/pull/404) ([anfernee](https://github.com/anfernee))
- generate all models if name not specified [#401](https://github.com/go-swagger/go-swagger/pull/401) ([easeway](https://github.com/easeway))
- Proper handle of array of pointers to struct [#396](https://github.com/go-swagger/go-swagger/pull/396) ([gaplyk](https://github.com/gaplyk))
- 368 merge expand items [#394](https://github.com/go-swagger/go-swagger/pull/394) ([casualjim](https://github.com/casualjim))

  - expand schemas properly, with all tests passing. [#393](https://github.com/go-swagger/go-swagger/pull/393) ([pytlesk4](https://github.com/pytlesk4))

- split restapi.NewServer [#392](https://github.com/go-swagger/go-swagger/pull/392) ([caglar10ur](https://github.com/caglar10ur))
- Fix issue with unknown primitive. [#391](https://github.com/go-swagger/go-swagger/pull/391) ([gaplyk](https://github.com/gaplyk))
- better validation for invalid refs [#387](https://github.com/go-swagger/go-swagger/pull/387) ([casualjim](https://github.com/casualjim))
- deal with empty required bodies [#385](https://github.com/go-swagger/go-swagger/pull/385) ([casualjim](https://github.com/casualjim))
- primitive aliases are not nullable [#383](https://github.com/go-swagger/go-swagger/pull/383) ([casualjim](https://github.com/casualjim))
- fixes some golint warnings in generated client [#380](https://github.com/go-swagger/go-swagger/pull/380) ([casualjim](https://github.com/casualjim))
- mangle type name for string alias [#379](https://github.com/go-swagger/go-swagger/pull/379) ([casualjim](https://github.com/casualjim))
- fix argument passing for validation function [#378](https://github.com/go-swagger/go-swagger/pull/378) ([casualjim](https://github.com/casualjim))
- better default handling in parameters [#377](https://github.com/go-swagger/go-swagger/pull/377) ([casualjim](https://github.com/casualjim))
- Fixes compilation error for stream type [#376](https://github.com/go-swagger/go-swagger/pull/376) ([casualjim](https://github.com/casualjim))
- specializes min/max validations for int [#374](https://github.com/go-swagger/go-swagger/pull/374) ([casualjim](https://github.com/casualjim))
- Separates listen from serve in server [#373](https://github.com/go-swagger/go-swagger/pull/373) ([casualjim](https://github.com/casualjim))
- Add plain text consumer and producer [#364](https://github.com/go-swagger/go-swagger/pull/364) ([stoyanr](https://github.com/stoyanr))
- Add XML consumer and producer [#362](https://github.com/go-swagger/go-swagger/pull/362) ([stoyanr](https://github.com/stoyanr))
- scan: treat error primitive as string [#349](https://github.com/go-swagger/go-swagger/pull/349) ([fsouza](https://github.com/fsouza))
- Fix overriding consumes in spec for client [#348](https://github.com/go-swagger/go-swagger/pull/348) ([casualjim](https://github.com/casualjim))
- fix missing httpkit import in models [#344](https://github.com/go-swagger/go-swagger/pull/344) ([easeway](https://github.com/easeway))
- fixes #330 package for client is client package [#339](https://github.com/go-swagger/go-swagger/pull/339) ([casualjim](https://github.com/casualjim))
- update vendored deps [#338](https://github.com/go-swagger/go-swagger/pull/338) ([casualjim](https://github.com/casualjim))
- adds --with-context for a request scoped net/context [#337](https://github.com/go-swagger/go-swagger/pull/337) ([casualjim](https://github.com/casualjim))
- add support for binary string format [#336](https://github.com/go-swagger/go-swagger/pull/336) ([casualjim](https://github.com/casualjim))
- make enum names for property different from aliased types [#335](https://github.com/go-swagger/go-swagger/pull/335) ([casualjim](https://github.com/casualjim))
- add --scan-models flag for generate spec command [#333](https://github.com/go-swagger/go-swagger/pull/333) ([casualjim](https://github.com/casualjim))
- no pointer for base type in maps [#332](https://github.com/go-swagger/go-swagger/pull/332) ([casualjim](https://github.com/casualjim))
- reinstate --skip-* arguments [#329](https://github.com/go-swagger/go-swagger/pull/329) ([casualjim](https://github.com/casualjim))
- Add tar, gzip support [#327](https://github.com/go-swagger/go-swagger/pull/327) ([jzt](https://github.com/jzt))
- full path for go imports run [#324](https://github.com/go-swagger/go-swagger/pull/324) ([casualjim](https://github.com/casualjim))
- ensure file names don't end with _test [#318](https://github.com/go-swagger/go-swagger/pull/318) ([casualjim](https://github.com/casualjim))
- fix #306 also recognize application/octet-stream in generator [#317](https://github.com/go-swagger/go-swagger/pull/317) ([casualjim](https://github.com/casualjim))
- update changelog [#316](https://github.com/go-swagger/go-swagger/pull/316) ([casualjim](https://github.com/casualjim))
