// Copyright 2024 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package generativelanguage provides access to the Generative Language API.
//
// For product documentation, see: https://developers.generativeai.google/api
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/generativelanguage/v1beta"
//	...
//	ctx := context.Background()
//	generativelanguageService, err := generativelanguage.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	generativelanguageService, err := generativelanguage.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	generativelanguageService, err := generativelanguage.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package generativelanguage // import "google.golang.org/api/generativelanguage/v1beta"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	internal "github.com/google/generative-ai-go/genai/internal"
	gensupport "github.com/google/generative-ai-go/genai/internal/gensupport"
	googleapi "google.golang.org/api/googleapi"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version

const apiId = "generativelanguage:v1beta"
const apiName = "generativelanguage"
const apiVersion = "v1beta"
const basePath = "https://generativelanguage.googleapis.com/"
const basePathTemplate = "https://generativelanguage.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://generativelanguage.mtls.googleapis.com/"

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.CachedContents = NewCachedContentsService(s)
	s.Corpora = NewCorporaService(s)
	s.Files = NewFilesService(s)
	s.Media = NewMediaService(s)
	s.Models = NewModelsService(s)
	s.TunedModels = NewTunedModelsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	CachedContents *CachedContentsService

	Corpora *CorporaService

	Files *FilesService

	Media *MediaService

	Models *ModelsService

	TunedModels *TunedModelsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewCachedContentsService(s *Service) *CachedContentsService {
	rs := &CachedContentsService{s: s}
	return rs
}

type CachedContentsService struct {
	s *Service
}

func NewCorporaService(s *Service) *CorporaService {
	rs := &CorporaService{s: s}
	rs.Documents = NewCorporaDocumentsService(s)
	rs.Permissions = NewCorporaPermissionsService(s)
	return rs
}

type CorporaService struct {
	s *Service

	Documents *CorporaDocumentsService

	Permissions *CorporaPermissionsService
}

func NewCorporaDocumentsService(s *Service) *CorporaDocumentsService {
	rs := &CorporaDocumentsService{s: s}
	rs.Chunks = NewCorporaDocumentsChunksService(s)
	return rs
}

type CorporaDocumentsService struct {
	s *Service

	Chunks *CorporaDocumentsChunksService
}

func NewCorporaDocumentsChunksService(s *Service) *CorporaDocumentsChunksService {
	rs := &CorporaDocumentsChunksService{s: s}
	return rs
}

type CorporaDocumentsChunksService struct {
	s *Service
}

func NewCorporaPermissionsService(s *Service) *CorporaPermissionsService {
	rs := &CorporaPermissionsService{s: s}
	return rs
}

type CorporaPermissionsService struct {
	s *Service
}

func NewFilesService(s *Service) *FilesService {
	rs := &FilesService{s: s}
	return rs
}

type FilesService struct {
	s *Service
}

func NewMediaService(s *Service) *MediaService {
	rs := &MediaService{s: s}
	return rs
}

type MediaService struct {
	s *Service
}

func NewModelsService(s *Service) *ModelsService {
	rs := &ModelsService{s: s}
	return rs
}

type ModelsService struct {
	s *Service
}

func NewTunedModelsService(s *Service) *TunedModelsService {
	rs := &TunedModelsService{s: s}
	rs.Permissions = NewTunedModelsPermissionsService(s)
	return rs
}

type TunedModelsService struct {
	s *Service

	Permissions *TunedModelsPermissionsService
}

func NewTunedModelsPermissionsService(s *Service) *TunedModelsPermissionsService {
	rs := &TunedModelsPermissionsService{s: s}
	return rs
}

type TunedModelsPermissionsService struct {
	s *Service
}

// AttributionSourceId: Identifier for the source contributing to this
// attribution.
type AttributionSourceId struct {
	// GroundingPassage: Identifier for an inline passage.
	GroundingPassage *GroundingPassageId `json:"groundingPassage,omitempty"`
	// SemanticRetrieverChunk: Identifier for a `Chunk` fetched via Semantic
	// Retriever.
	SemanticRetrieverChunk *SemanticRetrieverChunk `json:"semanticRetrieverChunk,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GroundingPassage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GroundingPassage") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AttributionSourceId) MarshalJSON() ([]byte, error) {
	type NoMethod AttributionSourceId
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BatchCreateChunksRequest: Request to batch create `Chunk`s.
type BatchCreateChunksRequest struct {
	// Requests: Required. The request messages specifying the `Chunk`s to create.
	// A maximum of 100 `Chunk`s can be created in a batch.
	Requests []*CreateChunkRequest `json:"requests,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Requests") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BatchCreateChunksRequest) MarshalJSON() ([]byte, error) {
	type NoMethod BatchCreateChunksRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BatchCreateChunksResponse: Response from `BatchCreateChunks` containing a
// list of created `Chunk`s.
type BatchCreateChunksResponse struct {
	// Chunks: `Chunk`s created.
	Chunks []*Chunk `json:"chunks,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Chunks") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Chunks") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BatchCreateChunksResponse) MarshalJSON() ([]byte, error) {
	type NoMethod BatchCreateChunksResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BatchDeleteChunksRequest: Request to batch delete `Chunk`s.
type BatchDeleteChunksRequest struct {
	// Requests: Required. The request messages specifying the `Chunk`s to delete.
	Requests []*DeleteChunkRequest `json:"requests,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Requests") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BatchDeleteChunksRequest) MarshalJSON() ([]byte, error) {
	type NoMethod BatchDeleteChunksRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BatchEmbedContentsRequest: Batch request to get embeddings from the model
// for a list of prompts.
type BatchEmbedContentsRequest struct {
	// Requests: Required. Embed requests for the batch. The model in each of these
	// requests must match the model specified `BatchEmbedContentsRequest.model`.
	Requests []*EmbedContentRequest `json:"requests,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Requests") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BatchEmbedContentsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod BatchEmbedContentsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BatchEmbedContentsResponse: The response to a `BatchEmbedContentsRequest`.
type BatchEmbedContentsResponse struct {
	// Embeddings: Output only. The embeddings for each request, in the same order
	// as provided in the batch request.
	Embeddings []*ContentEmbedding `json:"embeddings,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Embeddings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Embeddings") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BatchEmbedContentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod BatchEmbedContentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BatchEmbedTextRequest: Batch request to get a text embedding from the model.
type BatchEmbedTextRequest struct {
	// Requests: Optional. Embed requests for the batch. Only one of `texts` or
	// `requests` can be set.
	Requests []*EmbedTextRequest `json:"requests,omitempty"`
	// Texts: Optional. The free-form input texts that the model will turn into an
	// embedding. The current limit is 100 texts, over which an error will be
	// thrown.
	Texts []string `json:"texts,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Requests") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BatchEmbedTextRequest) MarshalJSON() ([]byte, error) {
	type NoMethod BatchEmbedTextRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BatchEmbedTextResponse: The response to a EmbedTextRequest.
type BatchEmbedTextResponse struct {
	// Embeddings: Output only. The embeddings generated from the input text.
	Embeddings []*Embedding `json:"embeddings,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Embeddings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Embeddings") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BatchEmbedTextResponse) MarshalJSON() ([]byte, error) {
	type NoMethod BatchEmbedTextResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BatchUpdateChunksRequest: Request to batch update `Chunk`s.
type BatchUpdateChunksRequest struct {
	// Requests: Required. The request messages specifying the `Chunk`s to update.
	// A maximum of 100 `Chunk`s can be updated in a batch.
	Requests []*UpdateChunkRequest `json:"requests,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Requests") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BatchUpdateChunksRequest) MarshalJSON() ([]byte, error) {
	type NoMethod BatchUpdateChunksRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BatchUpdateChunksResponse: Response from `BatchUpdateChunks` containing a
// list of updated `Chunk`s.
type BatchUpdateChunksResponse struct {
	// Chunks: `Chunk`s updated.
	Chunks []*Chunk `json:"chunks,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Chunks") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Chunks") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BatchUpdateChunksResponse) MarshalJSON() ([]byte, error) {
	type NoMethod BatchUpdateChunksResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Blob: Raw media bytes. Text should not be sent as raw bytes, use the 'text'
// field.
type Blob struct {
	// Data: Raw bytes for media formats.
	Data string `json:"data,omitempty"`
	// MimeType: The IANA standard MIME type of the source data. Examples: -
	// image/png - image/jpeg If an unsupported MIME type is provided, an error
	// will be returned. For a complete list of supported types, see Supported file
	// formats
	// (https://ai.google.dev/gemini-api/docs/prompting_with_media#supported_file_formats).
	MimeType string `json:"mimeType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Data") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Data") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Blob) MarshalJSON() ([]byte, error) {
	type NoMethod Blob
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CachedContent: Content that has been preprocessed and can be used in
// subsequent request to GenerativeService. Cached content can be only used
// with model it was created for.
type CachedContent struct {
	// Contents: Optional. Input only. Immutable. The content to cache.
	Contents []*Content `json:"contents,omitempty"`
	// CreateTime: Output only. Creation time of the cache entry.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: Optional. Immutable. The user-generated meaningful display name
	// of the cached content. Maximum 128 Unicode characters.
	DisplayName string `json:"displayName,omitempty"`
	// ExpireTime: Timestamp in UTC of when this resource is considered expired.
	// This is *always* provided on output, regardless of what was sent on input.
	ExpireTime string `json:"expireTime,omitempty"`
	// Model: Required. Immutable. The name of the `Model` to use for cached
	// content Format: `models/{model}`
	Model string `json:"model,omitempty"`
	// Name: Optional. Identifier. The resource name referring to the cached
	// content. Format: `cachedContents/{id}`
	Name string `json:"name,omitempty"`
	// SystemInstruction: Optional. Input only. Immutable. Developer set system
	// instruction. Currently text only.
	SystemInstruction *Content `json:"systemInstruction,omitempty"`
	// ToolConfig: Optional. Input only. Immutable. Tool config. This config is
	// shared for all tools.
	ToolConfig *ToolConfig `json:"toolConfig,omitempty"`
	// Tools: Optional. Input only. Immutable. A list of `Tools` the model may use
	// to generate the next response
	Tools []*Tool `json:"tools,omitempty"`
	// Ttl: Input only. New TTL for this resource, input only.
	Ttl string `json:"ttl,omitempty"`
	// UpdateTime: Output only. When the cache entry was last updated in UTC time.
	UpdateTime string `json:"updateTime,omitempty"`
	// UsageMetadata: Output only. Metadata on the usage of the cached content.
	UsageMetadata *CachedContentUsageMetadata `json:"usageMetadata,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Contents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Contents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CachedContent) MarshalJSON() ([]byte, error) {
	type NoMethod CachedContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CachedContentUsageMetadata: Metadata on the usage of the cached content.
type CachedContentUsageMetadata struct {
	// TotalTokenCount: Total number of tokens that the cached content consumes.
	TotalTokenCount int64 `json:"totalTokenCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TotalTokenCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TotalTokenCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CachedContentUsageMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod CachedContentUsageMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Candidate: A response candidate generated from the model.
type Candidate struct {
	// CitationMetadata: Output only. Citation information for model-generated
	// candidate. This field may be populated with recitation information for any
	// text included in the `content`. These are passages that are "recited" from
	// copyrighted material in the foundational LLM's training data.
	CitationMetadata *CitationMetadata `json:"citationMetadata,omitempty"`
	// Content: Output only. Generated content returned from the model.
	Content *Content `json:"content,omitempty"`
	// FinishReason: Optional. Output only. The reason why the model stopped
	// generating tokens. If empty, the model has not stopped generating the
	// tokens.
	//
	// Possible values:
	//   "FINISH_REASON_UNSPECIFIED" - Default value. This value is unused.
	//   "STOP" - Natural stop point of the model or provided stop sequence.
	//   "MAX_TOKENS" - The maximum number of tokens as specified in the request
	// was reached.
	//   "SAFETY" - The candidate content was flagged for safety reasons.
	//   "RECITATION" - The candidate content was flagged for recitation reasons.
	//   "LANGUAGE" - The candidate content was flagged for using an unsupported
	// language.
	//   "OTHER" - Unknown reason.
	FinishReason string `json:"finishReason,omitempty"`
	// GroundingAttributions: Output only. Attribution information for sources that
	// contributed to a grounded answer. This field is populated for
	// `GenerateAnswer` calls.
	GroundingAttributions []*GroundingAttribution `json:"groundingAttributions,omitempty"`
	// Index: Output only. Index of the candidate in the list of candidates.
	Index int64 `json:"index,omitempty"`
	// SafetyRatings: List of ratings for the safety of a response candidate. There
	// is at most one rating per category.
	SafetyRatings []*SafetyRating `json:"safetyRatings,omitempty"`
	// TokenCount: Output only. Token count for this candidate.
	TokenCount int64 `json:"tokenCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CitationMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CitationMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Candidate) MarshalJSON() ([]byte, error) {
	type NoMethod Candidate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Chunk: A `Chunk` is a subpart of a `Document` that is treated as an
// independent unit for the purposes of vector representation and storage. A
// `Corpus` can have a maximum of 1 million `Chunk`s.
type Chunk struct {
	// CreateTime: Output only. The Timestamp of when the `Chunk` was created.
	CreateTime string `json:"createTime,omitempty"`
	// CustomMetadata: Optional. User provided custom metadata stored as key-value
	// pairs. The maximum number of `CustomMetadata` per chunk is 20.
	CustomMetadata []*CustomMetadata `json:"customMetadata,omitempty"`
	// Data: Required. The content for the `Chunk`, such as the text string. The
	// maximum number of tokens per chunk is 2043.
	Data *ChunkData `json:"data,omitempty"`
	// Name: Immutable. Identifier. The `Chunk` resource name. The ID (name
	// excluding the "corpora/*/documents/*/chunks/" prefix) can contain up to 40
	// characters that are lowercase alphanumeric or dashes (-). The ID cannot
	// start or end with a dash. If the name is empty on create, a random
	// 12-character unique ID will be generated. Example:
	// `corpora/{corpus_id}/documents/{document_id}/chunks/123a456b789c`
	Name string `json:"name,omitempty"`
	// State: Output only. Current state of the `Chunk`.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The default value. This value is used if the state
	// is omitted.
	//   "STATE_PENDING_PROCESSING" - `Chunk` is being processed (embedding and
	// vector storage).
	//   "STATE_ACTIVE" - `Chunk` is processed and available for querying.
	//   "STATE_FAILED" - `Chunk` failed processing.
	State string `json:"state,omitempty"`
	// UpdateTime: Output only. The Timestamp of when the `Chunk` was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Chunk) MarshalJSON() ([]byte, error) {
	type NoMethod Chunk
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ChunkData: Extracted data that represents the `Chunk` content.
type ChunkData struct {
	// StringValue: The `Chunk` content as a string. The maximum number of tokens
	// per chunk is 2043.
	StringValue string `json:"stringValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "StringValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "StringValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ChunkData) MarshalJSON() ([]byte, error) {
	type NoMethod ChunkData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CitationMetadata: A collection of source attributions for a piece of
// content.
type CitationMetadata struct {
	// CitationSources: Citations to sources for a specific response.
	CitationSources []*CitationSource `json:"citationSources,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CitationSources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CitationSources") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CitationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod CitationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CitationSource: A citation to a source for a portion of a specific response.
type CitationSource struct {
	// EndIndex: Optional. End of the attributed segment, exclusive.
	EndIndex int64 `json:"endIndex,omitempty"`
	// License: Optional. License for the GitHub project that is attributed as a
	// source for segment. License info is required for code citations.
	License string `json:"license,omitempty"`
	// StartIndex: Optional. Start of segment of the response that is attributed to
	// this source. Index indicates the start of the segment, measured in bytes.
	StartIndex int64 `json:"startIndex,omitempty"`
	// Uri: Optional. URI that is attributed as a source for a portion of the text.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndIndex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndIndex") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CitationSource) MarshalJSON() ([]byte, error) {
	type NoMethod CitationSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CodeExecution: Tool that executes code generated by the model, and
// automatically returns the result to the model. See also `ExecutableCode` and
// `CodeExecutionResult` which are only generated when using this tool.
type CodeExecution struct {
}

// CodeExecutionResult: Result of executing the `ExecutableCode`. Only
// generated when using the `CodeExecution`, and always follows a `part`
// containing the `ExecutableCode`.
type CodeExecutionResult struct {
	// Outcome: Required. Outcome of the code execution.
	//
	// Possible values:
	//   "OUTCOME_UNSPECIFIED" - Unspecified status. This value should not be used.
	//   "OUTCOME_OK" - Code execution completed successfully.
	//   "OUTCOME_FAILED" - Code execution finished but with a failure. `stderr`
	// should contain the reason.
	//   "OUTCOME_DEADLINE_EXCEEDED" - Code execution ran for too long, and was
	// cancelled. There may or may not be a partial output present.
	Outcome string `json:"outcome,omitempty"`
	// Output: Optional. Contains stdout when code execution is successful, stderr
	// or other description otherwise.
	Output string `json:"output,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Outcome") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Outcome") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CodeExecutionResult) MarshalJSON() ([]byte, error) {
	type NoMethod CodeExecutionResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Condition: Filter condition applicable to a single key.
type Condition struct {
	// NumericValue: The numeric value to filter the metadata on.
	NumericValue float64 `json:"numericValue,omitempty"`
	// Operation: Required. Operator applied to the given key-value pair to trigger
	// the condition.
	//
	// Possible values:
	//   "OPERATOR_UNSPECIFIED" - The default value. This value is unused.
	//   "LESS" - Supported by numeric.
	//   "LESS_EQUAL" - Supported by numeric.
	//   "EQUAL" - Supported by numeric & string.
	//   "GREATER_EQUAL" - Supported by numeric.
	//   "GREATER" - Supported by numeric.
	//   "NOT_EQUAL" - Supported by numeric & string.
	//   "INCLUDES" - Supported by string only when `CustomMetadata` value type for
	// the given key has a `string_list_value`.
	//   "EXCLUDES" - Supported by string only when `CustomMetadata` value type for
	// the given key has a `string_list_value`.
	Operation string `json:"operation,omitempty"`
	// StringValue: The string value to filter the metadata on.
	StringValue string `json:"stringValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NumericValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NumericValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Condition) MarshalJSON() ([]byte, error) {
	type NoMethod Condition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *Condition) UnmarshalJSON(data []byte) error {
	type NoMethod Condition
	var s1 struct {
		NumericValue gensupport.JSONFloat64 `json:"numericValue"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.NumericValue = float64(s1.NumericValue)
	return nil
}

// Content: The base structured datatype containing multi-part content of a
// message. A `Content` includes a `role` field designating the producer of the
// `Content` and a `parts` field containing multi-part data that contains the
// content of the message turn.
type Content struct {
	// Parts: Ordered `Parts` that constitute a single message. Parts may have
	// different MIME types.
	Parts []*Part `json:"parts,omitempty"`
	// Role: Optional. The producer of the content. Must be either 'user' or
	// 'model'. Useful to set for multi-turn conversations, otherwise can be left
	// blank or unset.
	Role string `json:"role,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parts") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parts") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Content) MarshalJSON() ([]byte, error) {
	type NoMethod Content
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ContentEmbedding: A list of floats representing an embedding.
type ContentEmbedding struct {
	// Values: The embedding values.
	Values []float64 `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Values") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ContentEmbedding) MarshalJSON() ([]byte, error) {
	type NoMethod ContentEmbedding
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *ContentEmbedding) UnmarshalJSON(data []byte) error {
	type NoMethod ContentEmbedding
	var s1 struct {
		Values []gensupport.JSONFloat64 `json:"values"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Values = make([]float64, len(s1.Values))
	for i := range s1.Values {
		s.Values[i] = float64(s1.Values[i])
	}
	return nil
}

// ContentFilter: Content filtering metadata associated with processing a
// single request. ContentFilter contains a reason and an optional supporting
// string. The reason may be unspecified.
type ContentFilter struct {
	// Message: A string that describes the filtering behavior in more detail.
	Message string `json:"message,omitempty"`
	// Reason: The reason content was blocked during request processing.
	//
	// Possible values:
	//   "BLOCKED_REASON_UNSPECIFIED" - A blocked reason was not specified.
	//   "SAFETY" - Content was blocked by safety settings.
	//   "OTHER" - Content was blocked, but the reason is uncategorized.
	Reason string `json:"reason,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Message") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Message") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ContentFilter) MarshalJSON() ([]byte, error) {
	type NoMethod ContentFilter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Corpus: A `Corpus` is a collection of `Document`s. A project can create up
// to 5 corpora.
type Corpus struct {
	// CreateTime: Output only. The Timestamp of when the `Corpus` was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: Optional. The human-readable display name for the `Corpus`. The
	// display name must be no more than 512 characters in length, including
	// spaces. Example: "Docs on Semantic Retriever"
	DisplayName string `json:"displayName,omitempty"`
	// Name: Immutable. Identifier. The `Corpus` resource name. The ID (name
	// excluding the "corpora/" prefix) can contain up to 40 characters that are
	// lowercase alphanumeric or dashes (-). The ID cannot start or end with a
	// dash. If the name is empty on create, a unique name will be derived from
	// `display_name` along with a 12 character random suffix. Example:
	// `corpora/my-awesome-corpora-123a456b789c`
	Name string `json:"name,omitempty"`
	// UpdateTime: Output only. The Timestamp of when the `Corpus` was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Corpus) MarshalJSON() ([]byte, error) {
	type NoMethod Corpus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CountMessageTokensRequest: Counts the number of tokens in the `prompt` sent
// to a model. Models may tokenize text differently, so each model may return a
// different `token_count`.
type CountMessageTokensRequest struct {
	// Prompt: Required. The prompt, whose token count is to be returned.
	Prompt *MessagePrompt `json:"prompt,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Prompt") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Prompt") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CountMessageTokensRequest) MarshalJSON() ([]byte, error) {
	type NoMethod CountMessageTokensRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CountMessageTokensResponse: A response from `CountMessageTokens`. It returns
// the model's `token_count` for the `prompt`.
type CountMessageTokensResponse struct {
	// TokenCount: The number of tokens that the `model` tokenizes the `prompt`
	// into. Always non-negative.
	TokenCount int64 `json:"tokenCount,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "TokenCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TokenCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CountMessageTokensResponse) MarshalJSON() ([]byte, error) {
	type NoMethod CountMessageTokensResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CountTextTokensRequest: Counts the number of tokens in the `prompt` sent to
// a model. Models may tokenize text differently, so each model may return a
// different `token_count`.
type CountTextTokensRequest struct {
	// Prompt: Required. The free-form input text given to the model as a prompt.
	Prompt *TextPrompt `json:"prompt,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Prompt") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Prompt") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CountTextTokensRequest) MarshalJSON() ([]byte, error) {
	type NoMethod CountTextTokensRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CountTextTokensResponse: A response from `CountTextTokens`. It returns the
// model's `token_count` for the `prompt`.
type CountTextTokensResponse struct {
	// TokenCount: The number of tokens that the `model` tokenizes the `prompt`
	// into. Always non-negative.
	TokenCount int64 `json:"tokenCount,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "TokenCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TokenCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CountTextTokensResponse) MarshalJSON() ([]byte, error) {
	type NoMethod CountTextTokensResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CountTokensRequest: Counts the number of tokens in the `prompt` sent to a
// model. Models may tokenize text differently, so each model may return a
// different `token_count`.
type CountTokensRequest struct {
	// Contents: Optional. The input given to the model as a prompt. This field is
	// ignored when `generate_content_request` is set.
	Contents []*Content `json:"contents,omitempty"`
	// GenerateContentRequest: Optional. The overall input given to the model.
	// CountTokens will count prompt, function calling, etc.
	GenerateContentRequest *GenerateContentRequest `json:"generateContentRequest,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Contents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Contents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CountTokensRequest) MarshalJSON() ([]byte, error) {
	type NoMethod CountTokensRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CountTokensResponse: A response from `CountTokens`. It returns the model's
// `token_count` for the `prompt`.
type CountTokensResponse struct {
	// TotalTokens: The number of tokens that the `model` tokenizes the `prompt`
	// into. Always non-negative. When cached_content is set, this is still the
	// total effective prompt size. I.e. this includes the number of tokens in the
	// cached content.
	TotalTokens int64 `json:"totalTokens,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "TotalTokens") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TotalTokens") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CountTokensResponse) MarshalJSON() ([]byte, error) {
	type NoMethod CountTokensResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CreateChunkRequest: Request to create a `Chunk`.
type CreateChunkRequest struct {
	// Chunk: Required. The `Chunk` to create.
	Chunk *Chunk `json:"chunk,omitempty"`
	// Parent: Required. The name of the `Document` where this `Chunk` will be
	// created. Example: `corpora/my-corpus-123/documents/the-doc-abc`
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Chunk") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Chunk") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CreateChunkRequest) MarshalJSON() ([]byte, error) {
	type NoMethod CreateChunkRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CreateFileRequest: Request for `CreateFile`.
type CreateFileRequest struct {
	// File: Optional. Metadata for the file to create.
	File *File `json:"file,omitempty"`
	// ForceSendFields is a list of field names (e.g. "File") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "File") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CreateFileRequest) MarshalJSON() ([]byte, error) {
	type NoMethod CreateFileRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CreateFileResponse: Response for `CreateFile`.
type CreateFileResponse struct {
	// File: Metadata for the created file.
	File *File `json:"file,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "File") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "File") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CreateFileResponse) MarshalJSON() ([]byte, error) {
	type NoMethod CreateFileResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CustomMetadata: User provided metadata stored as key-value pairs.
type CustomMetadata struct {
	// Key: Required. The key of the metadata to store.
	Key string `json:"key,omitempty"`
	// NumericValue: The numeric value of the metadata to store.
	NumericValue float64 `json:"numericValue,omitempty"`
	// StringListValue: The StringList value of the metadata to store.
	StringListValue *StringList `json:"stringListValue,omitempty"`
	// StringValue: The string value of the metadata to store.
	StringValue string `json:"stringValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Key") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Key") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CustomMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod CustomMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *CustomMetadata) UnmarshalJSON(data []byte) error {
	type NoMethod CustomMetadata
	var s1 struct {
		NumericValue gensupport.JSONFloat64 `json:"numericValue"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.NumericValue = float64(s1.NumericValue)
	return nil
}

// Dataset: Dataset for training or validation.
type Dataset struct {
	// Examples: Optional. Inline examples.
	Examples *TuningExamples `json:"examples,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Examples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Examples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Dataset) MarshalJSON() ([]byte, error) {
	type NoMethod Dataset
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DeleteChunkRequest: Request to delete a `Chunk`.
type DeleteChunkRequest struct {
	// Name: Required. The resource name of the `Chunk` to delete. Example:
	// `corpora/my-corpus-123/documents/the-doc-abc/chunks/some-chunk`
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DeleteChunkRequest) MarshalJSON() ([]byte, error) {
	type NoMethod DeleteChunkRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Document: A `Document` is a collection of `Chunk`s. A `Corpus` can have a
// maximum of 10,000 `Document`s.
type Document struct {
	// CreateTime: Output only. The Timestamp of when the `Document` was created.
	CreateTime string `json:"createTime,omitempty"`
	// CustomMetadata: Optional. User provided custom metadata stored as key-value
	// pairs used for querying. A `Document` can have a maximum of 20
	// `CustomMetadata`.
	CustomMetadata []*CustomMetadata `json:"customMetadata,omitempty"`
	// DisplayName: Optional. The human-readable display name for the `Document`.
	// The display name must be no more than 512 characters in length, including
	// spaces. Example: "Semantic Retriever Documentation"
	DisplayName string `json:"displayName,omitempty"`
	// Name: Immutable. Identifier. The `Document` resource name. The ID (name
	// excluding the "corpora/*/documents/" prefix) can contain up to 40 characters
	// that are lowercase alphanumeric or dashes (-). The ID cannot start or end
	// with a dash. If the name is empty on create, a unique name will be derived
	// from `display_name` along with a 12 character random suffix. Example:
	// `corpora/{corpus_id}/documents/my-awesome-doc-123a456b789c`
	Name string `json:"name,omitempty"`
	// UpdateTime: Output only. The Timestamp of when the `Document` was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Document) MarshalJSON() ([]byte, error) {
	type NoMethod Document
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EmbedContentRequest: Request containing the `Content` for the model to
// embed.
type EmbedContentRequest struct {
	// Content: Required. The content to embed. Only the `parts.text` fields will
	// be counted.
	Content *Content `json:"content,omitempty"`
	// Model: Required. The model's resource name. This serves as an ID for the
	// Model to use. This name should match a model name returned by the
	// `ListModels` method. Format: `models/{model}`
	Model string `json:"model,omitempty"`
	// OutputDimensionality: Optional. Optional reduced dimension for the output
	// embedding. If set, excessive values in the output embedding are truncated
	// from the end. Supported by newer models since 2024, and the earlier model
	// (`models/embedding-001`) cannot specify this value.
	OutputDimensionality int64 `json:"outputDimensionality,omitempty"`
	// TaskType: Optional. Optional task type for which the embeddings will be
	// used. Can only be set for `models/embedding-001`.
	//
	// Possible values:
	//   "TASK_TYPE_UNSPECIFIED" - Unset value, which will default to one of the
	// other enum values.
	//   "RETRIEVAL_QUERY" - Specifies the given text is a query in a
	// search/retrieval setting.
	//   "RETRIEVAL_DOCUMENT" - Specifies the given text is a document from the
	// corpus being searched.
	//   "SEMANTIC_SIMILARITY" - Specifies the given text will be used for STS.
	//   "CLASSIFICATION" - Specifies that the given text will be classified.
	//   "CLUSTERING" - Specifies that the embeddings will be used for clustering.
	//   "QUESTION_ANSWERING" - Specifies that the given text will be used for
	// question answering.
	//   "FACT_VERIFICATION" - Specifies that the given text will be used for fact
	// verification.
	TaskType string `json:"taskType,omitempty"`
	// Title: Optional. An optional title for the text. Only applicable when
	// TaskType is `RETRIEVAL_DOCUMENT`. Note: Specifying a `title` for
	// `RETRIEVAL_DOCUMENT` provides better quality embeddings for retrieval.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EmbedContentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod EmbedContentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EmbedContentResponse: The response to an `EmbedContentRequest`.
type EmbedContentResponse struct {
	// Embedding: Output only. The embedding generated from the input content.
	Embedding *ContentEmbedding `json:"embedding,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Embedding") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Embedding") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EmbedContentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod EmbedContentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EmbedTextRequest: Request to get a text embedding from the model.
type EmbedTextRequest struct {
	// Model: Required. The model name to use with the format model=models/{model}.
	Model string `json:"model,omitempty"`
	// Text: Optional. The free-form input text that the model will turn into an
	// embedding.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Model") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Model") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EmbedTextRequest) MarshalJSON() ([]byte, error) {
	type NoMethod EmbedTextRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EmbedTextResponse: The response to a EmbedTextRequest.
type EmbedTextResponse struct {
	// Embedding: Output only. The embedding generated from the input text.
	Embedding *Embedding `json:"embedding,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Embedding") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Embedding") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EmbedTextResponse) MarshalJSON() ([]byte, error) {
	type NoMethod EmbedTextResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Embedding: A list of floats representing the embedding.
type Embedding struct {
	// Value: The embedding values.
	Value []float64 `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Value") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Value") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Embedding) MarshalJSON() ([]byte, error) {
	type NoMethod Embedding
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *Embedding) UnmarshalJSON(data []byte) error {
	type NoMethod Embedding
	var s1 struct {
		Value []gensupport.JSONFloat64 `json:"value"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Value = make([]float64, len(s1.Value))
	for i := range s1.Value {
		s.Value[i] = float64(s1.Value[i])
	}
	return nil
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use it as
// the request or the response type of an API method. For instance: service Foo
// { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// Example: An input/output example used to instruct the Model. It demonstrates
// how the model should respond or format its response.
type Example struct {
	// Input: Required. An example of an input `Message` from the user.
	Input *Message `json:"input,omitempty"`
	// Output: Required. An example of what the model should output given the
	// input.
	Output *Message `json:"output,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Input") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Input") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Example) MarshalJSON() ([]byte, error) {
	type NoMethod Example
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExecutableCode: Code generated by the model that is meant to be executed,
// and the result returned to the model. Only generated when using the
// `CodeExecution` tool, in which the code will be automatically executed, and
// a corresponding `CodeExecutionResult` will also be generated.
type ExecutableCode struct {
	// Code: Required. The code to be executed.
	Code string `json:"code,omitempty"`
	// Language: Required. Programming language of the `code`.
	//
	// Possible values:
	//   "LANGUAGE_UNSPECIFIED" - Unspecified language. This value should not be
	// used.
	//   "PYTHON" - Python >= 3.10, with numpy and simpy available.
	Language string `json:"language,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExecutableCode) MarshalJSON() ([]byte, error) {
	type NoMethod ExecutableCode
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// File: A file uploaded to the API.
type File struct {
	// CreateTime: Output only. The timestamp of when the `File` was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: Optional. The human-readable display name for the `File`. The
	// display name must be no more than 512 characters in length, including
	// spaces. Example: "Welcome Image"
	DisplayName string `json:"displayName,omitempty"`
	// Error: Output only. Error status if File processing failed.
	Error *Status `json:"error,omitempty"`
	// ExpirationTime: Output only. The timestamp of when the `File` will be
	// deleted. Only set if the `File` is scheduled to expire.
	ExpirationTime string `json:"expirationTime,omitempty"`
	// MimeType: Output only. MIME type of the file.
	MimeType string `json:"mimeType,omitempty"`
	// Name: Immutable. Identifier. The `File` resource name. The ID (name
	// excluding the "files/" prefix) can contain up to 40 characters that are
	// lowercase alphanumeric or dashes (-). The ID cannot start or end with a
	// dash. If the name is empty on create, a unique name will be generated.
	// Example: `files/123-456`
	Name string `json:"name,omitempty"`
	// Sha256Hash: Output only. SHA-256 hash of the uploaded bytes.
	Sha256Hash string `json:"sha256Hash,omitempty"`
	// SizeBytes: Output only. Size of the file in bytes.
	SizeBytes int64 `json:"sizeBytes,omitempty,string"`
	// State: Output only. Processing state of the File.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The default value. This value is used if the state
	// is omitted.
	//   "PROCESSING" - File is being processed and cannot be used for inference
	// yet.
	//   "ACTIVE" - File is processed and available for inference.
	//   "FAILED" - File failed processing.
	State string `json:"state,omitempty"`
	// UpdateTime: Output only. The timestamp of when the `File` was last updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// Uri: Output only. The uri of the `File`.
	Uri string `json:"uri,omitempty"`
	// VideoMetadata: Output only. Metadata for a video.
	VideoMetadata *VideoMetadata `json:"videoMetadata,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s File) MarshalJSON() ([]byte, error) {
	type NoMethod File
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FileData: URI based data.
type FileData struct {
	// FileUri: Required. URI.
	FileUri string `json:"fileUri,omitempty"`
	// MimeType: Optional. The IANA standard MIME type of the source data.
	MimeType string `json:"mimeType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FileUri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FileUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FileData) MarshalJSON() ([]byte, error) {
	type NoMethod FileData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FunctionCall: A predicted `FunctionCall` returned from the model that
// contains a string representing the `FunctionDeclaration.name` with the
// arguments and their values.
type FunctionCall struct {
	// Args: Optional. The function parameters and values in JSON object format.
	Args googleapi.RawMessage `json:"args,omitempty"`
	// Name: Required. The name of the function to call. Must be a-z, A-Z, 0-9, or
	// contain underscores and dashes, with a maximum length of 63.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Args") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Args") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FunctionCall) MarshalJSON() ([]byte, error) {
	type NoMethod FunctionCall
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FunctionCallingConfig: Configuration for specifying function calling
// behavior.
type FunctionCallingConfig struct {
	// AllowedFunctionNames: Optional. A set of function names that, when provided,
	// limits the functions the model will call. This should only be set when the
	// Mode is ANY. Function names should match [FunctionDeclaration.name]. With
	// mode set to ANY, model will predict a function call from the set of function
	// names provided.
	AllowedFunctionNames []string `json:"allowedFunctionNames,omitempty"`
	// Mode: Optional. Specifies the mode in which function calling should execute.
	// If unspecified, the default value will be set to AUTO.
	//
	// Possible values:
	//   "MODE_UNSPECIFIED" - Unspecified function calling mode. This value should
	// not be used.
	//   "AUTO" - Default model behavior, model decides to predict either a
	// function call or a natural language response.
	//   "ANY" - Model is constrained to always predicting a function call only. If
	// "allowed_function_names" are set, the predicted function call will be
	// limited to any one of "allowed_function_names", else the predicted function
	// call will be any one of the provided "function_declarations".
	//   "NONE" - Model will not predict any function call. Model behavior is same
	// as when not passing any function declarations.
	Mode string `json:"mode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowedFunctionNames") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowedFunctionNames") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FunctionCallingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod FunctionCallingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FunctionDeclaration: Structured representation of a function declaration as
// defined by the OpenAPI 3.03 specification
// (https://spec.openapis.org/oas/v3.0.3). Included in this declaration are the
// function name and parameters. This FunctionDeclaration is a representation
// of a block of code that can be used as a `Tool` by the model and executed by
// the client.
type FunctionDeclaration struct {
	// Description: Required. A brief description of the function.
	Description string `json:"description,omitempty"`
	// Name: Required. The name of the function. Must be a-z, A-Z, 0-9, or contain
	// underscores and dashes, with a maximum length of 63.
	Name string `json:"name,omitempty"`
	// Parameters: Optional. Describes the parameters to this function. Reflects
	// the Open API 3.03 Parameter Object string Key: the name of the parameter.
	// Parameter names are case sensitive. Schema Value: the Schema defining the
	// type used for the parameter.
	Parameters *Schema `json:"parameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FunctionDeclaration) MarshalJSON() ([]byte, error) {
	type NoMethod FunctionDeclaration
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FunctionResponse: The result output from a `FunctionCall` that contains a
// string representing the `FunctionDeclaration.name` and a structured JSON
// object containing any output from the function is used as context to the
// model. This should contain the result of a`FunctionCall` made based on model
// prediction.
type FunctionResponse struct {
	// Name: Required. The name of the function to call. Must be a-z, A-Z, 0-9, or
	// contain underscores and dashes, with a maximum length of 63.
	Name string `json:"name,omitempty"`
	// Response: Required. The function response in JSON object format.
	Response googleapi.RawMessage `json:"response,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FunctionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod FunctionResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GenerateAnswerRequest: Request to generate a grounded answer from the model.
type GenerateAnswerRequest struct {
	// AnswerStyle: Required. Style in which answers should be returned.
	//
	// Possible values:
	//   "ANSWER_STYLE_UNSPECIFIED" - Unspecified answer style.
	//   "ABSTRACTIVE" - Succint but abstract style.
	//   "EXTRACTIVE" - Very brief and extractive style.
	//   "VERBOSE" - Verbose style including extra details. The response may be
	// formatted as a sentence, paragraph, multiple paragraphs, or bullet points,
	// etc.
	AnswerStyle string `json:"answerStyle,omitempty"`
	// Contents: Required. The content of the current conversation with the model.
	// For single-turn queries, this is a single question to answer. For multi-turn
	// queries, this is a repeated field that contains conversation history and the
	// last `Content` in the list containing the question. Note: GenerateAnswer
	// currently only supports queries in English.
	Contents []*Content `json:"contents,omitempty"`
	// InlinePassages: Passages provided inline with the request.
	InlinePassages *GroundingPassages `json:"inlinePassages,omitempty"`
	// SafetySettings: Optional. A list of unique `SafetySetting` instances for
	// blocking unsafe content. This will be enforced on the
	// `GenerateAnswerRequest.contents` and `GenerateAnswerResponse.candidate`.
	// There should not be more than one setting for each `SafetyCategory` type.
	// The API will block any contents and responses that fail to meet the
	// thresholds set by these settings. This list overrides the default settings
	// for each `SafetyCategory` specified in the safety_settings. If there is no
	// `SafetySetting` for a given `SafetyCategory` provided in the list, the API
	// will use the default safety setting for that category. Harm categories
	// HARM_CATEGORY_HATE_SPEECH, HARM_CATEGORY_SEXUALLY_EXPLICIT,
	// HARM_CATEGORY_DANGEROUS_CONTENT, HARM_CATEGORY_HARASSMENT are supported.
	SafetySettings []*SafetySetting `json:"safetySettings,omitempty"`
	// SemanticRetriever: Content retrieved from resources created via the Semantic
	// Retriever API.
	SemanticRetriever *SemanticRetrieverConfig `json:"semanticRetriever,omitempty"`
	// Temperature: Optional. Controls the randomness of the output. Values can
	// range from [0.0,1.0], inclusive. A value closer to 1.0 will produce
	// responses that are more varied and creative, while a value closer to 0.0
	// will typically result in more straightforward responses from the model. A
	// low temperature (~0.2) is usually recommended for
	// Attributed-Question-Answering use cases.
	Temperature float64 `json:"temperature,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerStyle") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerStyle") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GenerateAnswerRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GenerateAnswerRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GenerateAnswerRequest) UnmarshalJSON(data []byte) error {
	type NoMethod GenerateAnswerRequest
	var s1 struct {
		Temperature gensupport.JSONFloat64 `json:"temperature"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Temperature = float64(s1.Temperature)
	return nil
}

// GenerateAnswerResponse: Response from the model for a grounded answer.
type GenerateAnswerResponse struct {
	// Answer: Candidate answer from the model. Note: The model *always* attempts
	// to provide a grounded answer, even when the answer is unlikely to be
	// answerable from the given passages. In that case, a low-quality or
	// ungrounded answer may be provided, along with a low
	// `answerable_probability`.
	Answer *Candidate `json:"answer,omitempty"`
	// AnswerableProbability: Output only. The model's estimate of the probability
	// that its answer is correct and grounded in the input passages. A low
	// answerable_probability indicates that the answer might not be grounded in
	// the sources. When `answerable_probability` is low, some clients may wish to:
	// * Display a message to the effect of "We couldn’t answer that question" to
	// the user. * Fall back to a general-purpose LLM that answers the question
	// from world knowledge. The threshold and nature of such fallbacks will depend
	// on individual clients’ use cases. 0.5 is a good starting threshold.
	AnswerableProbability float64 `json:"answerableProbability,omitempty"`
	// InputFeedback: Output only. Feedback related to the input data used to
	// answer the question, as opposed to model-generated response to the question.
	// "Input data" can be one or more of the following: - Question specified by
	// the last entry in `GenerateAnswerRequest.content` - Conversation history
	// specified by the other entries in `GenerateAnswerRequest.content` -
	// Grounding sources (`GenerateAnswerRequest.semantic_retriever` or
	// `GenerateAnswerRequest.inline_passages`)
	InputFeedback *InputFeedback `json:"inputFeedback,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Answer") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Answer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GenerateAnswerResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GenerateAnswerResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GenerateAnswerResponse) UnmarshalJSON(data []byte) error {
	type NoMethod GenerateAnswerResponse
	var s1 struct {
		AnswerableProbability gensupport.JSONFloat64 `json:"answerableProbability"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AnswerableProbability = float64(s1.AnswerableProbability)
	return nil
}

// GenerateContentRequest: Request to generate a completion from the model.
type GenerateContentRequest struct {
	// CachedContent: Optional. The name of the cached content used as context to
	// serve the prediction. Note: only used in explicit caching, where users can
	// have control over caching (e.g. what content to cache) and enjoy guaranteed
	// cost savings. Format: `cachedContents/{cachedContent}`
	CachedContent string `json:"cachedContent,omitempty"`
	// Contents: Required. The content of the current conversation with the model.
	// For single-turn queries, this is a single instance. For multi-turn queries,
	// this is a repeated field that contains conversation history + latest
	// request.
	Contents []*Content `json:"contents,omitempty"`
	// GenerationConfig: Optional. Configuration options for model generation and
	// outputs.
	GenerationConfig *GenerationConfig `json:"generationConfig,omitempty"`
	// Model: Required. The name of the `Model` to use for generating the
	// completion. Format: `name=models/{model}`.
	Model string `json:"model,omitempty"`
	// SafetySettings: Optional. A list of unique `SafetySetting` instances for
	// blocking unsafe content. This will be enforced on the
	// `GenerateContentRequest.contents` and `GenerateContentResponse.candidates`.
	// There should not be more than one setting for each `SafetyCategory` type.
	// The API will block any contents and responses that fail to meet the
	// thresholds set by these settings. This list overrides the default settings
	// for each `SafetyCategory` specified in the safety_settings. If there is no
	// `SafetySetting` for a given `SafetyCategory` provided in the list, the API
	// will use the default safety setting for that category. Harm categories
	// HARM_CATEGORY_HATE_SPEECH, HARM_CATEGORY_SEXUALLY_EXPLICIT,
	// HARM_CATEGORY_DANGEROUS_CONTENT, HARM_CATEGORY_HARASSMENT are supported.
	SafetySettings []*SafetySetting `json:"safetySettings,omitempty"`
	// SystemInstruction: Optional. Developer set system instruction. Currently,
	// text only.
	SystemInstruction *Content `json:"systemInstruction,omitempty"`
	// ToolConfig: Optional. Tool configuration for any `Tool` specified in the
	// request.
	ToolConfig *ToolConfig `json:"toolConfig,omitempty"`
	// Tools: Optional. A list of `Tools` the model may use to generate the next
	// response. A `Tool` is a piece of code that enables the system to interact
	// with external systems to perform an action, or set of actions, outside of
	// knowledge and scope of the model. The only supported tool is currently
	// `Function`.
	Tools []*Tool `json:"tools,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CachedContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CachedContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GenerateContentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GenerateContentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GenerateContentResponse: Response from the model supporting multiple
// candidates. Note on safety ratings and content filtering. They are reported
// for both prompt in `GenerateContentResponse.prompt_feedback` and for each
// candidate in `finish_reason` and in `safety_ratings`. The API contract is
// that: - either all requested candidates are returned or no candidates at all
// - no candidates are returned only if there was something wrong with the
// prompt (see `prompt_feedback`) - feedback on each candidate is reported on
// `finish_reason` and `safety_ratings`.
type GenerateContentResponse struct {
	// Candidates: Candidate responses from the model.
	Candidates []*Candidate `json:"candidates,omitempty"`
	// PromptFeedback: Returns the prompt's feedback related to the content
	// filters.
	PromptFeedback *PromptFeedback `json:"promptFeedback,omitempty"`
	// UsageMetadata: Output only. Metadata on the generation requests' token
	// usage.
	UsageMetadata *UsageMetadata `json:"usageMetadata,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Candidates") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Candidates") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GenerateContentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GenerateContentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GenerateMessageRequest: Request to generate a message response from the
// model.
type GenerateMessageRequest struct {
	// CandidateCount: Optional. The number of generated response messages to
	// return. This value must be between `[1, 8]`, inclusive. If unset, this will
	// default to `1`.
	CandidateCount int64 `json:"candidateCount,omitempty"`
	// Prompt: Required. The structured textual input given to the model as a
	// prompt. Given a prompt, the model will return what it predicts is the next
	// message in the discussion.
	Prompt *MessagePrompt `json:"prompt,omitempty"`
	// Temperature: Optional. Controls the randomness of the output. Values can
	// range over `[0.0,1.0]`, inclusive. A value closer to `1.0` will produce
	// responses that are more varied, while a value closer to `0.0` will typically
	// result in less surprising responses from the model.
	Temperature float64 `json:"temperature,omitempty"`
	// TopK: Optional. The maximum number of tokens to consider when sampling. The
	// model uses combined Top-k and nucleus sampling. Top-k sampling considers the
	// set of `top_k` most probable tokens.
	TopK int64 `json:"topK,omitempty"`
	// TopP: Optional. The maximum cumulative probability of tokens to consider
	// when sampling. The model uses combined Top-k and nucleus sampling. Nucleus
	// sampling considers the smallest set of tokens whose probability sum is at
	// least `top_p`.
	TopP float64 `json:"topP,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CandidateCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CandidateCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GenerateMessageRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GenerateMessageRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GenerateMessageRequest) UnmarshalJSON(data []byte) error {
	type NoMethod GenerateMessageRequest
	var s1 struct {
		Temperature gensupport.JSONFloat64 `json:"temperature"`
		TopP        gensupport.JSONFloat64 `json:"topP"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Temperature = float64(s1.Temperature)
	s.TopP = float64(s1.TopP)
	return nil
}

// GenerateMessageResponse: The response from the model. This includes
// candidate messages and conversation history in the form of
// chronologically-ordered messages.
type GenerateMessageResponse struct {
	// Candidates: Candidate response messages from the model.
	Candidates []*Message `json:"candidates,omitempty"`
	// Filters: A set of content filtering metadata for the prompt and response
	// text. This indicates which `SafetyCategory`(s) blocked a candidate from this
	// response, the lowest `HarmProbability` that triggered a block, and the
	// HarmThreshold setting for that category.
	Filters []*ContentFilter `json:"filters,omitempty"`
	// Messages: The conversation history used by the model.
	Messages []*Message `json:"messages,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Candidates") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Candidates") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GenerateMessageResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GenerateMessageResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GenerateTextRequest: Request to generate a text completion response from the
// model.
type GenerateTextRequest struct {
	// CandidateCount: Optional. Number of generated responses to return. This
	// value must be between [1, 8], inclusive. If unset, this will default to 1.
	CandidateCount int64 `json:"candidateCount,omitempty"`
	// MaxOutputTokens: Optional. The maximum number of tokens to include in a
	// candidate. If unset, this will default to output_token_limit specified in
	// the `Model` specification.
	MaxOutputTokens int64 `json:"maxOutputTokens,omitempty"`
	// Prompt: Required. The free-form input text given to the model as a prompt.
	// Given a prompt, the model will generate a TextCompletion response it
	// predicts as the completion of the input text.
	Prompt *TextPrompt `json:"prompt,omitempty"`
	// SafetySettings: Optional. A list of unique `SafetySetting` instances for
	// blocking unsafe content. that will be enforced on the
	// `GenerateTextRequest.prompt` and `GenerateTextResponse.candidates`. There
	// should not be more than one setting for each `SafetyCategory` type. The API
	// will block any prompts and responses that fail to meet the thresholds set by
	// these settings. This list overrides the default settings for each
	// `SafetyCategory` specified in the safety_settings. If there is no
	// `SafetySetting` for a given `SafetyCategory` provided in the list, the API
	// will use the default safety setting for that category. Harm categories
	// HARM_CATEGORY_DEROGATORY, HARM_CATEGORY_TOXICITY, HARM_CATEGORY_VIOLENCE,
	// HARM_CATEGORY_SEXUAL, HARM_CATEGORY_MEDICAL, HARM_CATEGORY_DANGEROUS are
	// supported in text service.
	SafetySettings []*SafetySetting `json:"safetySettings,omitempty"`
	// StopSequences: The set of character sequences (up to 5) that will stop
	// output generation. If specified, the API will stop at the first appearance
	// of a stop sequence. The stop sequence will not be included as part of the
	// response.
	StopSequences []string `json:"stopSequences,omitempty"`
	// Temperature: Optional. Controls the randomness of the output. Note: The
	// default value varies by model, see the `Model.temperature` attribute of the
	// `Model` returned the `getModel` function. Values can range from [0.0,1.0],
	// inclusive. A value closer to 1.0 will produce responses that are more varied
	// and creative, while a value closer to 0.0 will typically result in more
	// straightforward responses from the model.
	Temperature float64 `json:"temperature,omitempty"`
	// TopK: Optional. The maximum number of tokens to consider when sampling. The
	// model uses combined Top-k and nucleus sampling. Top-k sampling considers the
	// set of `top_k` most probable tokens. Defaults to 40. Note: The default value
	// varies by model, see the `Model.top_k` attribute of the `Model` returned the
	// `getModel` function.
	TopK int64 `json:"topK,omitempty"`
	// TopP: Optional. The maximum cumulative probability of tokens to consider
	// when sampling. The model uses combined Top-k and nucleus sampling. Tokens
	// are sorted based on their assigned probabilities so that only the most
	// likely tokens are considered. Top-k sampling directly limits the maximum
	// number of tokens to consider, while Nucleus sampling limits number of tokens
	// based on the cumulative probability. Note: The default value varies by
	// model, see the `Model.top_p` attribute of the `Model` returned the
	// `getModel` function.
	TopP float64 `json:"topP,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CandidateCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CandidateCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GenerateTextRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GenerateTextRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GenerateTextRequest) UnmarshalJSON(data []byte) error {
	type NoMethod GenerateTextRequest
	var s1 struct {
		Temperature gensupport.JSONFloat64 `json:"temperature"`
		TopP        gensupport.JSONFloat64 `json:"topP"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Temperature = float64(s1.Temperature)
	s.TopP = float64(s1.TopP)
	return nil
}

// GenerateTextResponse: The response from the model, including candidate
// completions.
type GenerateTextResponse struct {
	// Candidates: Candidate responses from the model.
	Candidates []*TextCompletion `json:"candidates,omitempty"`
	// Filters: A set of content filtering metadata for the prompt and response
	// text. This indicates which `SafetyCategory`(s) blocked a candidate from this
	// response, the lowest `HarmProbability` that triggered a block, and the
	// HarmThreshold setting for that category. This indicates the smallest change
	// to the `SafetySettings` that would be necessary to unblock at least 1
	// response. The blocking is configured by the `SafetySettings` in the request
	// (or the default `SafetySettings` of the API).
	Filters []*ContentFilter `json:"filters,omitempty"`
	// SafetyFeedback: Returns any safety feedback related to content filtering.
	SafetyFeedback []*SafetyFeedback `json:"safetyFeedback,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Candidates") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Candidates") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GenerateTextResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GenerateTextResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GenerationConfig: Configuration options for model generation and outputs.
// Not all parameters may be configurable for every model.
type GenerationConfig struct {
	// CandidateCount: Optional. Number of generated responses to return.
	// Currently, this value can only be set to 1. If unset, this will default to
	// 1.
	CandidateCount int64 `json:"candidateCount,omitempty"`
	// MaxOutputTokens: Optional. The maximum number of tokens to include in a
	// candidate. Note: The default value varies by model, see the
	// `Model.output_token_limit` attribute of the `Model` returned from the
	// `getModel` function.
	MaxOutputTokens int64 `json:"maxOutputTokens,omitempty"`
	// ResponseMimeType: Optional. Output response mimetype of the generated
	// candidate text. Supported mimetype: `text/plain`: (default) Text output.
	// `application/json`: JSON response in the candidates.
	ResponseMimeType string `json:"responseMimeType,omitempty"`
	// ResponseSchema: Optional. Output response schema of the generated candidate
	// text when response mime type can have schema. Schema can be objects,
	// primitives or arrays and is a subset of OpenAPI schema
	// (https://spec.openapis.org/oas/v3.0.3#schema). If set, a compatible
	// response_mime_type must also be set. Compatible mimetypes:
	// `application/json`: Schema for JSON response.
	ResponseSchema *Schema `json:"responseSchema,omitempty"`
	// StopSequences: Optional. The set of character sequences (up to 5) that will
	// stop output generation. If specified, the API will stop at the first
	// appearance of a stop sequence. The stop sequence will not be included as
	// part of the response.
	StopSequences []string `json:"stopSequences,omitempty"`
	// Temperature: Optional. Controls the randomness of the output. Note: The
	// default value varies by model, see the `Model.temperature` attribute of the
	// `Model` returned from the `getModel` function. Values can range from [0.0,
	// 2.0].
	Temperature float64 `json:"temperature,omitempty"`
	// TopK: Optional. The maximum number of tokens to consider when sampling.
	// Models use nucleus sampling or combined Top-k and nucleus sampling. Top-k
	// sampling considers the set of `top_k` most probable tokens. Models running
	// with nucleus sampling don't allow top_k setting. Note: The default value
	// varies by model, see the `Model.top_k` attribute of the `Model` returned
	// from the `getModel` function. Empty `top_k` field in `Model` indicates the
	// model doesn't apply top-k sampling and doesn't allow setting `top_k` on
	// requests.
	TopK int64 `json:"topK,omitempty"`
	// TopP: Optional. The maximum cumulative probability of tokens to consider
	// when sampling. The model uses combined Top-k and nucleus sampling. Tokens
	// are sorted based on their assigned probabilities so that only the most
	// likely tokens are considered. Top-k sampling directly limits the maximum
	// number of tokens to consider, while Nucleus sampling limits number of tokens
	// based on the cumulative probability. Note: The default value varies by
	// model, see the `Model.top_p` attribute of the `Model` returned from the
	// `getModel` function.
	TopP float64 `json:"topP,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CandidateCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CandidateCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GenerationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GenerationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GenerationConfig) UnmarshalJSON(data []byte) error {
	type NoMethod GenerationConfig
	var s1 struct {
		Temperature gensupport.JSONFloat64 `json:"temperature"`
		TopP        gensupport.JSONFloat64 `json:"topP"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Temperature = float64(s1.Temperature)
	s.TopP = float64(s1.TopP)
	return nil
}

// GroundingAttribution: Attribution for a source that contributed to an
// answer.
type GroundingAttribution struct {
	// Content: Grounding source content that makes up this attribution.
	Content *Content `json:"content,omitempty"`
	// SourceId: Output only. Identifier for the source contributing to this
	// attribution.
	SourceId *AttributionSourceId `json:"sourceId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GroundingAttribution) MarshalJSON() ([]byte, error) {
	type NoMethod GroundingAttribution
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GroundingPassage: Passage included inline with a grounding configuration.
type GroundingPassage struct {
	// Content: Content of the passage.
	Content *Content `json:"content,omitempty"`
	// Id: Identifier for the passage for attributing this passage in grounded
	// answers.
	Id string `json:"id,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GroundingPassage) MarshalJSON() ([]byte, error) {
	type NoMethod GroundingPassage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GroundingPassageId: Identifier for a part within a `GroundingPassage`.
type GroundingPassageId struct {
	// PartIndex: Output only. Index of the part within the
	// `GenerateAnswerRequest`'s `GroundingPassage.content`.
	PartIndex int64 `json:"partIndex,omitempty"`
	// PassageId: Output only. ID of the passage matching the
	// `GenerateAnswerRequest`'s `GroundingPassage.id`.
	PassageId string `json:"passageId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PartIndex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PartIndex") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GroundingPassageId) MarshalJSON() ([]byte, error) {
	type NoMethod GroundingPassageId
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GroundingPassages: A repeated list of passages.
type GroundingPassages struct {
	// Passages: List of passages.
	Passages []*GroundingPassage `json:"passages,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Passages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Passages") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GroundingPassages) MarshalJSON() ([]byte, error) {
	type NoMethod GroundingPassages
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Hyperparameters: Hyperparameters controlling the tuning process. Read more
// at https://ai.google.dev/docs/model_tuning_guidance
type Hyperparameters struct {
	// BatchSize: Immutable. The batch size hyperparameter for tuning. If not set,
	// a default of 4 or 16 will be used based on the number of training examples.
	BatchSize int64 `json:"batchSize,omitempty"`
	// EpochCount: Immutable. The number of training epochs. An epoch is one pass
	// through the training data. If not set, a default of 5 will be used.
	EpochCount int64 `json:"epochCount,omitempty"`
	// LearningRate: Optional. Immutable. The learning rate hyperparameter for
	// tuning. If not set, a default of 0.001 or 0.0002 will be calculated based on
	// the number of training examples.
	LearningRate float64 `json:"learningRate,omitempty"`
	// LearningRateMultiplier: Optional. Immutable. The learning rate multiplier is
	// used to calculate a final learning_rate based on the default (recommended)
	// value. Actual learning rate := learning_rate_multiplier * default learning
	// rate Default learning rate is dependent on base model and dataset size. If
	// not set, a default of 1.0 will be used.
	LearningRateMultiplier float64 `json:"learningRateMultiplier,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BatchSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BatchSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Hyperparameters) MarshalJSON() ([]byte, error) {
	type NoMethod Hyperparameters
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *Hyperparameters) UnmarshalJSON(data []byte) error {
	type NoMethod Hyperparameters
	var s1 struct {
		LearningRate           gensupport.JSONFloat64 `json:"learningRate"`
		LearningRateMultiplier gensupport.JSONFloat64 `json:"learningRateMultiplier"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.LearningRate = float64(s1.LearningRate)
	s.LearningRateMultiplier = float64(s1.LearningRateMultiplier)
	return nil
}

// InputFeedback: Feedback related to the input data used to answer the
// question, as opposed to model-generated response to the question.
type InputFeedback struct {
	// BlockReason: Optional. If set, the input was blocked and no candidates are
	// returned. Rephrase your input.
	//
	// Possible values:
	//   "BLOCK_REASON_UNSPECIFIED" - Default value. This value is unused.
	//   "SAFETY" - Input was blocked due to safety reasons. You can inspect
	// `safety_ratings` to understand which safety category blocked it.
	//   "OTHER" - Input was blocked due to other reasons.
	BlockReason string `json:"blockReason,omitempty"`
	// SafetyRatings: Ratings for safety of the input. There is at most one rating
	// per category.
	SafetyRatings []*SafetyRating `json:"safetyRatings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BlockReason") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlockReason") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InputFeedback) MarshalJSON() ([]byte, error) {
	type NoMethod InputFeedback
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListCachedContentsResponse: Response with CachedContents list.
type ListCachedContentsResponse struct {
	// CachedContents: List of cached contents.
	CachedContents []*CachedContent `json:"cachedContents,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CachedContents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CachedContents") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListCachedContentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListCachedContentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListChunksResponse: Response from `ListChunks` containing a paginated list
// of `Chunk`s. The `Chunk`s are sorted by ascending `chunk.create_time`.
type ListChunksResponse struct {
	// Chunks: The returned `Chunk`s.
	Chunks []*Chunk `json:"chunks,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no more pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Chunks") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Chunks") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListChunksResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListChunksResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListCorporaResponse: Response from `ListCorpora` containing a paginated list
// of `Corpora`. The results are sorted by ascending `corpus.create_time`.
type ListCorporaResponse struct {
	// Corpora: The returned corpora.
	Corpora []*Corpus `json:"corpora,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no more pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Corpora") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Corpora") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListCorporaResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListCorporaResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListDocumentsResponse: Response from `ListDocuments` containing a paginated
// list of `Document`s. The `Document`s are sorted by ascending
// `document.create_time`.
type ListDocumentsResponse struct {
	// Documents: The returned `Document`s.
	Documents []*Document `json:"documents,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no more pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Documents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Documents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListDocumentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListFilesResponse: Response for `ListFiles`.
type ListFilesResponse struct {
	// Files: The list of `File`s.
	Files []*File `json:"files,omitempty"`
	// NextPageToken: A token that can be sent as a `page_token` into a subsequent
	// `ListFiles` call.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Files") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Files") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListFilesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListFilesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListModelsResponse: Response from `ListModel` containing a paginated list of
// Models.
type ListModelsResponse struct {
	// Models: The returned Models.
	Models []*Model `json:"models,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no more pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Models") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Models") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListModelsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListModelsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListPermissionsResponse: Response from `ListPermissions` containing a
// paginated list of permissions.
type ListPermissionsResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no more pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Permissions: Returned permissions.
	Permissions []*Permission `json:"permissions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListPermissionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListPermissionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListTunedModelsResponse: Response from `ListTunedModels` containing a
// paginated list of Models.
type ListTunedModelsResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no more pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// TunedModels: The returned Models.
	TunedModels []*TunedModel `json:"tunedModels,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListTunedModelsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListTunedModelsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Message: The base unit of structured text. A `Message` includes an `author`
// and the `content` of the `Message`. The `author` is used to tag messages
// when they are fed to the model as text.
type Message struct {
	// Author: Optional. The author of this Message. This serves as a key for
	// tagging the content of this Message when it is fed to the model as text. The
	// author can be any alphanumeric string.
	Author string `json:"author,omitempty"`
	// CitationMetadata: Output only. Citation information for model-generated
	// `content` in this `Message`. If this `Message` was generated as output from
	// the model, this field may be populated with attribution information for any
	// text included in the `content`. This field is used only on output.
	CitationMetadata *CitationMetadata `json:"citationMetadata,omitempty"`
	// Content: Required. The text content of the structured `Message`.
	Content string `json:"content,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Author") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Author") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Message) MarshalJSON() ([]byte, error) {
	type NoMethod Message
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MessagePrompt: All of the structured input text passed to the model as a
// prompt. A `MessagePrompt` contains a structured set of fields that provide
// context for the conversation, examples of user input/model output message
// pairs that prime the model to respond in different ways, and the
// conversation history or list of messages representing the alternating turns
// of the conversation between the user and the model.
type MessagePrompt struct {
	// Context: Optional. Text that should be provided to the model first to ground
	// the response. If not empty, this `context` will be given to the model first
	// before the `examples` and `messages`. When using a `context` be sure to
	// provide it with every request to maintain continuity. This field can be a
	// description of your prompt to the model to help provide context and guide
	// the responses. Examples: "Translate the phrase from English to French." or
	// "Given a statement, classify the sentiment as happy, sad or neutral."
	// Anything included in this field will take precedence over message history if
	// the total input size exceeds the model's `input_token_limit` and the input
	// request is truncated.
	Context string `json:"context,omitempty"`
	// Examples: Optional. Examples of what the model should generate. This
	// includes both user input and the response that the model should emulate.
	// These `examples` are treated identically to conversation messages except
	// that they take precedence over the history in `messages`: If the total input
	// size exceeds the model's `input_token_limit` the input will be truncated.
	// Items will be dropped from `messages` before `examples`.
	Examples []*Example `json:"examples,omitempty"`
	// Messages: Required. A snapshot of the recent conversation history sorted
	// chronologically. Turns alternate between two authors. If the total input
	// size exceeds the model's `input_token_limit` the input will be truncated:
	// The oldest items will be dropped from `messages`.
	Messages []*Message `json:"messages,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Context") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Context") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MessagePrompt) MarshalJSON() ([]byte, error) {
	type NoMethod MessagePrompt
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MetadataFilter: User provided filter to limit retrieval based on `Chunk` or
// `Document` level metadata values. Example (genre = drama OR genre = action):
// key = "document.custom_metadata.genre" conditions = [{string_value =
// "drama", operation = EQUAL}, {string_value = "action", operation = EQUAL}]
type MetadataFilter struct {
	// Conditions: Required. The `Condition`s for the given key that will trigger
	// this filter. Multiple `Condition`s are joined by logical ORs.
	Conditions []*Condition `json:"conditions,omitempty"`
	// Key: Required. The key of the metadata to filter on.
	Key string `json:"key,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Conditions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conditions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MetadataFilter) MarshalJSON() ([]byte, error) {
	type NoMethod MetadataFilter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Model: Information about a Generative Language Model.
type Model struct {
	// BaseModelId: Required. The name of the base model, pass this to the
	// generation request. Examples: * `chat-bison`
	BaseModelId string `json:"baseModelId,omitempty"`
	// Description: A short description of the model.
	Description string `json:"description,omitempty"`
	// DisplayName: The human-readable name of the model. E.g. "Chat Bison". The
	// name can be up to 128 characters long and can consist of any UTF-8
	// characters.
	DisplayName string `json:"displayName,omitempty"`
	// InputTokenLimit: Maximum number of input tokens allowed for this model.
	InputTokenLimit int64 `json:"inputTokenLimit,omitempty"`
	// MaxTemperature: The maximum temperature this model can use.
	MaxTemperature float64 `json:"maxTemperature,omitempty"`
	// Name: Required. The resource name of the `Model`. Format: `models/{model}`
	// with a `{model}` naming convention of: * "{base_model_id}-{version}"
	// Examples: * `models/chat-bison-001`
	Name string `json:"name,omitempty"`
	// OutputTokenLimit: Maximum number of output tokens available for this model.
	OutputTokenLimit int64 `json:"outputTokenLimit,omitempty"`
	// SupportedGenerationMethods: The model's supported generation methods. The
	// method names are defined as Pascal case strings, such as `generateMessage`
	// which correspond to API methods.
	SupportedGenerationMethods []string `json:"supportedGenerationMethods,omitempty"`
	// Temperature: Controls the randomness of the output. Values can range over
	// `[0.0,max_temperature]`, inclusive. A higher value will produce responses
	// that are more varied, while a value closer to `0.0` will typically result in
	// less surprising responses from the model. This value specifies default to be
	// used by the backend while making the call to the model.
	Temperature float64 `json:"temperature,omitempty"`
	// TopK: For Top-k sampling. Top-k sampling considers the set of `top_k` most
	// probable tokens. This value specifies default to be used by the backend
	// while making the call to the model. If empty, indicates the model doesn't
	// use top-k sampling, and `top_k` isn't allowed as a generation parameter.
	TopK int64 `json:"topK,omitempty"`
	// TopP: For Nucleus sampling. Nucleus sampling considers the smallest set of
	// tokens whose probability sum is at least `top_p`. This value specifies
	// default to be used by the backend while making the call to the model.
	TopP float64 `json:"topP,omitempty"`
	// Version: Required. The version number of the model. This represents the
	// major version
	Version string `json:"version,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BaseModelId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BaseModelId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Model) MarshalJSON() ([]byte, error) {
	type NoMethod Model
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *Model) UnmarshalJSON(data []byte) error {
	type NoMethod Model
	var s1 struct {
		MaxTemperature gensupport.JSONFloat64 `json:"maxTemperature"`
		Temperature    gensupport.JSONFloat64 `json:"temperature"`
		TopP           gensupport.JSONFloat64 `json:"topP"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.MaxTemperature = float64(s1.MaxTemperature)
	s.Temperature = float64(s1.Temperature)
	s.TopP = float64(s1.TopP)
	return nil
}

// Operation: This resource represents a long-running operation that is the
// result of a network API call.
type Operation struct {
	// Done: If the value is `false`, it means the operation is still in progress.
	// If `true`, the operation is completed, and either `error` or `response` is
	// available.
	Done bool `json:"done,omitempty"`
	// Error: The error result of the operation in case of failure or cancellation.
	Error *Status `json:"error,omitempty"`
	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as create
	// time. Some services might not provide such metadata. Any method that returns
	// a long-running operation should document the metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: The server-assigned name, which is only unique within the same service
	// that originally returns it. If you use the default HTTP mapping, the `name`
	// should be a resource name ending with `operations/{unique_id}`.
	Name string `json:"name,omitempty"`
	// Response: The normal, successful response of the operation. If the original
	// method returns no data on success, such as `Delete`, the response is
	// `google.protobuf.Empty`. If the original method is standard
	// `Get`/`Create`/`Update`, the response should be the resource. For other
	// methods, the response should have the type `XxxResponse`, where `Xxx` is the
	// original method name. For example, if the original method name is
	// `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Operation) MarshalJSON() ([]byte, error) {
	type NoMethod Operation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Part: A datatype containing media that is part of a multi-part `Content`
// message. A `Part` consists of data which has an associated datatype. A
// `Part` can only contain one of the accepted types in `Part.data`. A `Part`
// must have a fixed IANA MIME type identifying the type and subtype of the
// media if the `inline_data` field is filled with raw bytes.
type Part struct {
	// CodeExecutionResult: Result of executing the `ExecutableCode`.
	CodeExecutionResult *CodeExecutionResult `json:"codeExecutionResult,omitempty"`
	// ExecutableCode: Code generated by the model that is meant to be executed.
	ExecutableCode *ExecutableCode `json:"executableCode,omitempty"`
	// FileData: URI based data.
	FileData *FileData `json:"fileData,omitempty"`
	// FunctionCall: A predicted `FunctionCall` returned from the model that
	// contains a string representing the `FunctionDeclaration.name` with the
	// arguments and their values.
	FunctionCall *FunctionCall `json:"functionCall,omitempty"`
	// FunctionResponse: The result output of a `FunctionCall` that contains a
	// string representing the `FunctionDeclaration.name` and a structured JSON
	// object containing any output from the function is used as context to the
	// model.
	FunctionResponse *FunctionResponse `json:"functionResponse,omitempty"`
	// InlineData: Inline media bytes.
	InlineData *Blob `json:"inlineData,omitempty"`
	// Text: Inline text.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CodeExecutionResult") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CodeExecutionResult") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Part) MarshalJSON() ([]byte, error) {
	type NoMethod Part
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Permission: Permission resource grants user, group or the rest of the world
// access to the PaLM API resource (e.g. a tuned model, corpus). A role is a
// collection of permitted operations that allows users to perform specific
// actions on PaLM API resources. To make them available to users, groups, or
// service accounts, you assign roles. When you assign a role, you grant
// permissions that the role contains. There are three concentric roles. Each
// role is a superset of the previous role's permitted operations: - reader can
// use the resource (e.g. tuned model, corpus) for inference - writer has
// reader's permissions and additionally can edit and share - owner has
// writer's permissions and additionally can delete
type Permission struct {
	// EmailAddress: Optional. Immutable. The email address of the user of group
	// which this permission refers. Field is not set when permission's grantee
	// type is EVERYONE.
	EmailAddress string `json:"emailAddress,omitempty"`
	// GranteeType: Optional. Immutable. The type of the grantee.
	//
	// Possible values:
	//   "GRANTEE_TYPE_UNSPECIFIED" - The default value. This value is unused.
	//   "USER" - Represents a user. When set, you must provide email_address for
	// the user.
	//   "GROUP" - Represents a group. When set, you must provide email_address for
	// the group.
	//   "EVERYONE" - Represents access to everyone. No extra information is
	// required.
	GranteeType string `json:"granteeType,omitempty"`
	// Name: Output only. Identifier. The permission name. A unique name will be
	// generated on create. Examples:
	// tunedModels/{tuned_model}/permissions/{permission}
	// corpora/{corpus}/permissions/{permission} Output only.
	Name string `json:"name,omitempty"`
	// Role: Required. The role granted by this permission.
	//
	// Possible values:
	//   "ROLE_UNSPECIFIED" - The default value. This value is unused.
	//   "OWNER" - Owner can use, update, share and delete the resource.
	//   "WRITER" - Writer can use, update and share the resource.
	//   "READER" - Reader can use the resource.
	Role string `json:"role,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "EmailAddress") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EmailAddress") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Permission) MarshalJSON() ([]byte, error) {
	type NoMethod Permission
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PromptFeedback: A set of the feedback metadata the prompt specified in
// `GenerateContentRequest.content`.
type PromptFeedback struct {
	// BlockReason: Optional. If set, the prompt was blocked and no candidates are
	// returned. Rephrase your prompt.
	//
	// Possible values:
	//   "BLOCK_REASON_UNSPECIFIED" - Default value. This value is unused.
	//   "SAFETY" - Prompt was blocked due to safety reasons. You can inspect
	// `safety_ratings` to understand which safety category blocked it.
	//   "OTHER" - Prompt was blocked due to unknown reasons.
	BlockReason string `json:"blockReason,omitempty"`
	// SafetyRatings: Ratings for safety of the prompt. There is at most one rating
	// per category.
	SafetyRatings []*SafetyRating `json:"safetyRatings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BlockReason") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlockReason") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PromptFeedback) MarshalJSON() ([]byte, error) {
	type NoMethod PromptFeedback
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// QueryCorpusRequest: Request for querying a `Corpus`.
type QueryCorpusRequest struct {
	// MetadataFilters: Optional. Filter for `Chunk` and `Document` metadata. Each
	// `MetadataFilter` object should correspond to a unique key. Multiple
	// `MetadataFilter` objects are joined by logical "AND"s. Example query at
	// document level: (year >= 2020 OR year < 2010) AND (genre = drama OR genre =
	// action) `MetadataFilter` object list: metadata_filters = [ {key =
	// "document.custom_metadata.year" conditions = [{int_value = 2020, operation =
	// GREATER_EQUAL}, {int_value = 2010, operation = LESS}]}, {key =
	// "document.custom_metadata.year" conditions = [{int_value = 2020, operation =
	// GREATER_EQUAL}, {int_value = 2010, operation = LESS}]}, {key =
	// "document.custom_metadata.genre" conditions = [{string_value = "drama",
	// operation = EQUAL}, {string_value = "action", operation = EQUAL}]}] Example
	// query at chunk level for a numeric range of values: (year > 2015 AND year <=
	// 2020) `MetadataFilter` object list: metadata_filters = [ {key =
	// "chunk.custom_metadata.year" conditions = [{int_value = 2015, operation =
	// GREATER}]}, {key = "chunk.custom_metadata.year" conditions = [{int_value =
	// 2020, operation = LESS_EQUAL}]}] Note: "AND"s for the same key are only
	// supported for numeric values. String values only support "OR"s for the same
	// key.
	MetadataFilters []*MetadataFilter `json:"metadataFilters,omitempty"`
	// Query: Required. Query string to perform semantic search.
	Query string `json:"query,omitempty"`
	// ResultsCount: Optional. The maximum number of `Chunk`s to return. The
	// service may return fewer `Chunk`s. If unspecified, at most 10 `Chunk`s will
	// be returned. The maximum specified result count is 100.
	ResultsCount int64 `json:"resultsCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MetadataFilters") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MetadataFilters") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s QueryCorpusRequest) MarshalJSON() ([]byte, error) {
	type NoMethod QueryCorpusRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// QueryCorpusResponse: Response from `QueryCorpus` containing a list of
// relevant chunks.
type QueryCorpusResponse struct {
	// RelevantChunks: The relevant chunks.
	RelevantChunks []*RelevantChunk `json:"relevantChunks,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "RelevantChunks") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RelevantChunks") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s QueryCorpusResponse) MarshalJSON() ([]byte, error) {
	type NoMethod QueryCorpusResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// QueryDocumentRequest: Request for querying a `Document`.
type QueryDocumentRequest struct {
	// MetadataFilters: Optional. Filter for `Chunk` metadata. Each
	// `MetadataFilter` object should correspond to a unique key. Multiple
	// `MetadataFilter` objects are joined by logical "AND"s. Note:
	// `Document`-level filtering is not supported for this request because a
	// `Document` name is already specified. Example query: (year >= 2020 OR year <
	// 2010) AND (genre = drama OR genre = action) `MetadataFilter` object list:
	// metadata_filters = [ {key = "chunk.custom_metadata.year" conditions =
	// [{int_value = 2020, operation = GREATER_EQUAL}, {int_value = 2010, operation
	// = LESS}}, {key = "chunk.custom_metadata.genre" conditions = [{string_value =
	// "drama", operation = EQUAL}, {string_value = "action", operation = EQUAL}}]
	// Example query for a numeric range of values: (year > 2015 AND year <= 2020)
	// `MetadataFilter` object list: metadata_filters = [ {key =
	// "chunk.custom_metadata.year" conditions = [{int_value = 2015, operation =
	// GREATER}]}, {key = "chunk.custom_metadata.year" conditions = [{int_value =
	// 2020, operation = LESS_EQUAL}]}] Note: "AND"s for the same key are only
	// supported for numeric values. String values only support "OR"s for the same
	// key.
	MetadataFilters []*MetadataFilter `json:"metadataFilters,omitempty"`
	// Query: Required. Query string to perform semantic search.
	Query string `json:"query,omitempty"`
	// ResultsCount: Optional. The maximum number of `Chunk`s to return. The
	// service may return fewer `Chunk`s. If unspecified, at most 10 `Chunk`s will
	// be returned. The maximum specified result count is 100.
	ResultsCount int64 `json:"resultsCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MetadataFilters") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MetadataFilters") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s QueryDocumentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod QueryDocumentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// QueryDocumentResponse: Response from `QueryDocument` containing a list of
// relevant chunks.
type QueryDocumentResponse struct {
	// RelevantChunks: The returned relevant chunks.
	RelevantChunks []*RelevantChunk `json:"relevantChunks,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "RelevantChunks") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RelevantChunks") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s QueryDocumentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod QueryDocumentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RelevantChunk: The information for a chunk relevant to a query.
type RelevantChunk struct {
	// Chunk: `Chunk` associated with the query.
	Chunk *Chunk `json:"chunk,omitempty"`
	// ChunkRelevanceScore: `Chunk` relevance to the query.
	ChunkRelevanceScore float64 `json:"chunkRelevanceScore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Chunk") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Chunk") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RelevantChunk) MarshalJSON() ([]byte, error) {
	type NoMethod RelevantChunk
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *RelevantChunk) UnmarshalJSON(data []byte) error {
	type NoMethod RelevantChunk
	var s1 struct {
		ChunkRelevanceScore gensupport.JSONFloat64 `json:"chunkRelevanceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ChunkRelevanceScore = float64(s1.ChunkRelevanceScore)
	return nil
}

// SafetyFeedback: Safety feedback for an entire request. This field is
// populated if content in the input and/or response is blocked due to safety
// settings. SafetyFeedback may not exist for every HarmCategory. Each
// SafetyFeedback will return the safety settings used by the request as well
// as the lowest HarmProbability that should be allowed in order to return a
// result.
type SafetyFeedback struct {
	// Rating: Safety rating evaluated from content.
	Rating *SafetyRating `json:"rating,omitempty"`
	// Setting: Safety settings applied to the request.
	Setting *SafetySetting `json:"setting,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Rating") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Rating") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SafetyFeedback) MarshalJSON() ([]byte, error) {
	type NoMethod SafetyFeedback
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SafetyRating: Safety rating for a piece of content. The safety rating
// contains the category of harm and the harm probability level in that
// category for a piece of content. Content is classified for safety across a
// number of harm categories and the probability of the harm classification is
// included here.
type SafetyRating struct {
	// Blocked: Was this content blocked because of this rating?
	Blocked bool `json:"blocked,omitempty"`
	// Category: Required. The category for this rating.
	//
	// Possible values:
	//   "HARM_CATEGORY_UNSPECIFIED" - Category is unspecified.
	//   "HARM_CATEGORY_DEROGATORY" - Negative or harmful comments targeting
	// identity and/or protected attribute.
	//   "HARM_CATEGORY_TOXICITY" - Content that is rude, disrespectful, or
	// profane.
	//   "HARM_CATEGORY_VIOLENCE" - Describes scenarios depicting violence against
	// an individual or group, or general descriptions of gore.
	//   "HARM_CATEGORY_SEXUAL" - Contains references to sexual acts or other lewd
	// content.
	//   "HARM_CATEGORY_MEDICAL" - Promotes unchecked medical advice.
	//   "HARM_CATEGORY_DANGEROUS" - Dangerous content that promotes, facilitates,
	// or encourages harmful acts.
	//   "HARM_CATEGORY_HARASSMENT" - Harasment content.
	//   "HARM_CATEGORY_HATE_SPEECH" - Hate speech and content.
	//   "HARM_CATEGORY_SEXUALLY_EXPLICIT" - Sexually explicit content.
	//   "HARM_CATEGORY_DANGEROUS_CONTENT" - Dangerous content.
	Category string `json:"category,omitempty"`
	// Probability: Required. The probability of harm for this content.
	//
	// Possible values:
	//   "HARM_PROBABILITY_UNSPECIFIED" - Probability is unspecified.
	//   "NEGLIGIBLE" - Content has a negligible chance of being unsafe.
	//   "LOW" - Content has a low chance of being unsafe.
	//   "MEDIUM" - Content has a medium chance of being unsafe.
	//   "HIGH" - Content has a high chance of being unsafe.
	Probability string `json:"probability,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Blocked") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Blocked") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SafetyRating) MarshalJSON() ([]byte, error) {
	type NoMethod SafetyRating
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SafetySetting: Safety setting, affecting the safety-blocking behavior.
// Passing a safety setting for a category changes the allowed probability that
// content is blocked.
type SafetySetting struct {
	// Category: Required. The category for this setting.
	//
	// Possible values:
	//   "HARM_CATEGORY_UNSPECIFIED" - Category is unspecified.
	//   "HARM_CATEGORY_DEROGATORY" - Negative or harmful comments targeting
	// identity and/or protected attribute.
	//   "HARM_CATEGORY_TOXICITY" - Content that is rude, disrespectful, or
	// profane.
	//   "HARM_CATEGORY_VIOLENCE" - Describes scenarios depicting violence against
	// an individual or group, or general descriptions of gore.
	//   "HARM_CATEGORY_SEXUAL" - Contains references to sexual acts or other lewd
	// content.
	//   "HARM_CATEGORY_MEDICAL" - Promotes unchecked medical advice.
	//   "HARM_CATEGORY_DANGEROUS" - Dangerous content that promotes, facilitates,
	// or encourages harmful acts.
	//   "HARM_CATEGORY_HARASSMENT" - Harasment content.
	//   "HARM_CATEGORY_HATE_SPEECH" - Hate speech and content.
	//   "HARM_CATEGORY_SEXUALLY_EXPLICIT" - Sexually explicit content.
	//   "HARM_CATEGORY_DANGEROUS_CONTENT" - Dangerous content.
	Category string `json:"category,omitempty"`
	// Threshold: Required. Controls the probability threshold at which harm is
	// blocked.
	//
	// Possible values:
	//   "HARM_BLOCK_THRESHOLD_UNSPECIFIED" - Threshold is unspecified.
	//   "BLOCK_LOW_AND_ABOVE" - Content with NEGLIGIBLE will be allowed.
	//   "BLOCK_MEDIUM_AND_ABOVE" - Content with NEGLIGIBLE and LOW will be
	// allowed.
	//   "BLOCK_ONLY_HIGH" - Content with NEGLIGIBLE, LOW, and MEDIUM will be
	// allowed.
	//   "BLOCK_NONE" - All content will be allowed.
	Threshold string `json:"threshold,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Category") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Category") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SafetySetting) MarshalJSON() ([]byte, error) {
	type NoMethod SafetySetting
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Schema: The `Schema` object allows the definition of input and output data
// types. These types can be objects, but also primitives and arrays.
// Represents a select subset of an OpenAPI 3.0 schema object
// (https://spec.openapis.org/oas/v3.0.3#schema).
type Schema struct {
	// Description: Optional. A brief description of the parameter. This could
	// contain examples of use. Parameter description may be formatted as Markdown.
	Description string `json:"description,omitempty"`
	// Enum: Optional. Possible values of the element of Type.STRING with enum
	// format. For example we can define an Enum Direction as : {type:STRING,
	// format:enum, enum:["EAST", NORTH", "SOUTH", "WEST"]}
	Enum []string `json:"enum,omitempty"`
	// Format: Optional. The format of the data. This is used only for primitive
	// datatypes. Supported formats: for NUMBER type: float, double for INTEGER
	// type: int32, int64 for STRING type: enum
	Format string `json:"format,omitempty"`
	// Items: Optional. Schema of the elements of Type.ARRAY.
	Items *Schema `json:"items,omitempty"`
	// Nullable: Optional. Indicates if the value may be null.
	Nullable bool `json:"nullable,omitempty"`
	// Properties: Optional. Properties of Type.OBJECT.
	Properties map[string]Schema `json:"properties,omitempty"`
	// Required: Optional. Required properties of Type.OBJECT.
	Required []string `json:"required,omitempty"`
	// Type: Required. Data type.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Not specified, should not be used.
	//   "STRING" - String type.
	//   "NUMBER" - Number type.
	//   "INTEGER" - Integer type.
	//   "BOOLEAN" - Boolean type.
	//   "ARRAY" - Array type.
	//   "OBJECT" - Object type.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Schema) MarshalJSON() ([]byte, error) {
	type NoMethod Schema
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SemanticRetrieverChunk: Identifier for a `Chunk` retrieved via Semantic
// Retriever specified in the `GenerateAnswerRequest` using
// `SemanticRetrieverConfig`.
type SemanticRetrieverChunk struct {
	// Chunk: Output only. Name of the `Chunk` containing the attributed text.
	// Example: `corpora/123/documents/abc/chunks/xyz`
	Chunk string `json:"chunk,omitempty"`
	// Source: Output only. Name of the source matching the request's
	// `SemanticRetrieverConfig.source`. Example: `corpora/123` or
	// `corpora/123/documents/abc`
	Source string `json:"source,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Chunk") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Chunk") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SemanticRetrieverChunk) MarshalJSON() ([]byte, error) {
	type NoMethod SemanticRetrieverChunk
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SemanticRetrieverConfig: Configuration for retrieving grounding content from
// a `Corpus` or `Document` created using the Semantic Retriever API.
type SemanticRetrieverConfig struct {
	// MaxChunksCount: Optional. Maximum number of relevant `Chunk`s to retrieve.
	MaxChunksCount int64 `json:"maxChunksCount,omitempty"`
	// MetadataFilters: Optional. Filters for selecting `Document`s and/or `Chunk`s
	// from the resource.
	MetadataFilters []*MetadataFilter `json:"metadataFilters,omitempty"`
	// MinimumRelevanceScore: Optional. Minimum relevance score for retrieved
	// relevant `Chunk`s.
	MinimumRelevanceScore float64 `json:"minimumRelevanceScore,omitempty"`
	// Query: Required. Query to use for similarity matching `Chunk`s in the given
	// resource.
	Query *Content `json:"query,omitempty"`
	// Source: Required. Name of the resource for retrieval, e.g. corpora/123 or
	// corpora/123/documents/abc.
	Source string `json:"source,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaxChunksCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaxChunksCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SemanticRetrieverConfig) MarshalJSON() ([]byte, error) {
	type NoMethod SemanticRetrieverConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *SemanticRetrieverConfig) UnmarshalJSON(data []byte) error {
	type NoMethod SemanticRetrieverConfig
	var s1 struct {
		MinimumRelevanceScore gensupport.JSONFloat64 `json:"minimumRelevanceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.MinimumRelevanceScore = float64(s1.MinimumRelevanceScore)
	return nil
}

// Status: The `Status` type defines a logical error model that is suitable for
// different programming environments, including REST APIs and RPC APIs. It is
// used by gRPC (https://github.com/grpc). Each `Status` message contains three
// pieces of data: error code, error message, and error details. You can find
// out more about this error model and how to work with it in the API Design
// Guide (https://cloud.google.com/apis/design/errors).
type Status struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StringList: User provided string values assigned to a single metadata key.
type StringList struct {
	// Values: The string values of the metadata to store.
	Values []string `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Values") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StringList) MarshalJSON() ([]byte, error) {
	type NoMethod StringList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TextCompletion: Output text returned from a model.
type TextCompletion struct {
	// CitationMetadata: Output only. Citation information for model-generated
	// `output` in this `TextCompletion`. This field may be populated with
	// attribution information for any text included in the `output`.
	CitationMetadata *CitationMetadata `json:"citationMetadata,omitempty"`
	// Output: Output only. The generated text returned from the model.
	Output string `json:"output,omitempty"`
	// SafetyRatings: Ratings for the safety of a response. There is at most one
	// rating per category.
	SafetyRatings []*SafetyRating `json:"safetyRatings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CitationMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CitationMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TextCompletion) MarshalJSON() ([]byte, error) {
	type NoMethod TextCompletion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TextPrompt: Text given to the model as a prompt. The Model will use this
// TextPrompt to Generate a text completion.
type TextPrompt struct {
	// Text: Required. The prompt text.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Text") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Text") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TextPrompt) MarshalJSON() ([]byte, error) {
	type NoMethod TextPrompt
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Tool: Tool details that the model may use to generate response. A `Tool` is
// a piece of code that enables the system to interact with external systems to
// perform an action, or set of actions, outside of knowledge and scope of the
// model.
type Tool struct {
	// CodeExecution: Optional. Enables the model to execute code as part of
	// generation.
	CodeExecution *CodeExecution `json:"codeExecution,omitempty"`
	// FunctionDeclarations: Optional. A list of `FunctionDeclarations` available
	// to the model that can be used for function calling. The model or system does
	// not execute the function. Instead the defined function may be returned as a
	// FunctionCall with arguments to the client side for execution. The model may
	// decide to call a subset of these functions by populating FunctionCall in the
	// response. The next conversation turn may contain a FunctionResponse with the
	// [content.role] "function" generation context for the next model turn.
	FunctionDeclarations []*FunctionDeclaration `json:"functionDeclarations,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CodeExecution") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CodeExecution") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Tool) MarshalJSON() ([]byte, error) {
	type NoMethod Tool
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ToolConfig: The Tool configuration containing parameters for specifying
// `Tool` use in the request.
type ToolConfig struct {
	// FunctionCallingConfig: Optional. Function calling config.
	FunctionCallingConfig *FunctionCallingConfig `json:"functionCallingConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FunctionCallingConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FunctionCallingConfig") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ToolConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ToolConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TransferOwnershipRequest: Request to transfer the ownership of the tuned
// model.
type TransferOwnershipRequest struct {
	// EmailAddress: Required. The email address of the user to whom the tuned
	// model is being transferred to.
	EmailAddress string `json:"emailAddress,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EmailAddress") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EmailAddress") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TransferOwnershipRequest) MarshalJSON() ([]byte, error) {
	type NoMethod TransferOwnershipRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TransferOwnershipResponse: Response from `TransferOwnership`.
type TransferOwnershipResponse struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// TunedModel: A fine-tuned model created using ModelService.CreateTunedModel.
type TunedModel struct {
	// BaseModel: Immutable. The name of the `Model` to tune. Example:
	// `models/text-bison-001`
	BaseModel string `json:"baseModel,omitempty"`
	// CreateTime: Output only. The timestamp when this model was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. A short description of this model.
	Description string `json:"description,omitempty"`
	// DisplayName: Optional. The name to display for this model in user
	// interfaces. The display name must be up to 40 characters including spaces.
	DisplayName string `json:"displayName,omitempty"`
	// Name: Output only. The tuned model name. A unique name will be generated on
	// create. Example: `tunedModels/az2mb0bpw6i` If display_name is set on create,
	// the id portion of the name will be set by concatenating the words of the
	// display_name with hyphens and adding a random portion for uniqueness.
	// Example: display_name = "Sentence Translator" name =
	// "tunedModels/sentence-translator-u3b7m"
	Name string `json:"name,omitempty"`
	// State: Output only. The state of the tuned model.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The default value. This value is unused.
	//   "CREATING" - The model is being created.
	//   "ACTIVE" - The model is ready to be used.
	//   "FAILED" - The model failed to be created.
	State string `json:"state,omitempty"`
	// Temperature: Optional. Controls the randomness of the output. Values can
	// range over `[0.0,1.0]`, inclusive. A value closer to `1.0` will produce
	// responses that are more varied, while a value closer to `0.0` will typically
	// result in less surprising responses from the model. This value specifies
	// default to be the one used by the base model while creating the model.
	Temperature float64 `json:"temperature,omitempty"`
	// TopK: Optional. For Top-k sampling. Top-k sampling considers the set of
	// `top_k` most probable tokens. This value specifies default to be used by the
	// backend while making the call to the model. This value specifies default to
	// be the one used by the base model while creating the model.
	TopK int64 `json:"topK,omitempty"`
	// TopP: Optional. For Nucleus sampling. Nucleus sampling considers the
	// smallest set of tokens whose probability sum is at least `top_p`. This value
	// specifies default to be the one used by the base model while creating the
	// model.
	TopP float64 `json:"topP,omitempty"`
	// TunedModelSource: Optional. TunedModel to use as the starting point for
	// training the new model.
	TunedModelSource *TunedModelSource `json:"tunedModelSource,omitempty"`
	// TuningTask: Required. The tuning task that creates the tuned model.
	TuningTask *TuningTask `json:"tuningTask,omitempty"`
	// UpdateTime: Output only. The timestamp when this model was updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BaseModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BaseModel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TunedModel) MarshalJSON() ([]byte, error) {
	type NoMethod TunedModel
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *TunedModel) UnmarshalJSON(data []byte) error {
	type NoMethod TunedModel
	var s1 struct {
		Temperature gensupport.JSONFloat64 `json:"temperature"`
		TopP        gensupport.JSONFloat64 `json:"topP"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Temperature = float64(s1.Temperature)
	s.TopP = float64(s1.TopP)
	return nil
}

// TunedModelSource: Tuned model as a source for training a new model.
type TunedModelSource struct {
	// BaseModel: Output only. The name of the base `Model` this `TunedModel` was
	// tuned from. Example: `models/text-bison-001`
	BaseModel string `json:"baseModel,omitempty"`
	// TunedModel: Immutable. The name of the `TunedModel` to use as the starting
	// point for training the new model. Example: `tunedModels/my-tuned-model`
	TunedModel string `json:"tunedModel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BaseModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BaseModel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TunedModelSource) MarshalJSON() ([]byte, error) {
	type NoMethod TunedModelSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TuningExample: A single example for tuning.
type TuningExample struct {
	// Output: Required. The expected model output.
	Output string `json:"output,omitempty"`
	// TextInput: Optional. Text model input.
	TextInput string `json:"textInput,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Output") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Output") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TuningExample) MarshalJSON() ([]byte, error) {
	type NoMethod TuningExample
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TuningExamples: A set of tuning examples. Can be training or validation
// data.
type TuningExamples struct {
	// Examples: Required. The examples. Example input can be for text or discuss,
	// but all examples in a set must be of the same type.
	Examples []*TuningExample `json:"examples,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Examples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Examples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TuningExamples) MarshalJSON() ([]byte, error) {
	type NoMethod TuningExamples
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TuningSnapshot: Record for a single tuning step.
type TuningSnapshot struct {
	// ComputeTime: Output only. The timestamp when this metric was computed.
	ComputeTime string `json:"computeTime,omitempty"`
	// Epoch: Output only. The epoch this step was part of.
	Epoch int64 `json:"epoch,omitempty"`
	// MeanLoss: Output only. The mean loss of the training examples for this step.
	MeanLoss float64 `json:"meanLoss,omitempty"`
	// Step: Output only. The tuning step.
	Step int64 `json:"step,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ComputeTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ComputeTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TuningSnapshot) MarshalJSON() ([]byte, error) {
	type NoMethod TuningSnapshot
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *TuningSnapshot) UnmarshalJSON(data []byte) error {
	type NoMethod TuningSnapshot
	var s1 struct {
		MeanLoss gensupport.JSONFloat64 `json:"meanLoss"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.MeanLoss = float64(s1.MeanLoss)
	return nil
}

// TuningTask: Tuning tasks that create tuned models.
type TuningTask struct {
	// CompleteTime: Output only. The timestamp when tuning this model completed.
	CompleteTime string `json:"completeTime,omitempty"`
	// Hyperparameters: Immutable. Hyperparameters controlling the tuning process.
	// If not provided, default values will be used.
	Hyperparameters *Hyperparameters `json:"hyperparameters,omitempty"`
	// Snapshots: Output only. Metrics collected during tuning.
	Snapshots []*TuningSnapshot `json:"snapshots,omitempty"`
	// StartTime: Output only. The timestamp when tuning this model started.
	StartTime string `json:"startTime,omitempty"`
	// TrainingData: Required. Input only. Immutable. The model training data.
	TrainingData *Dataset `json:"trainingData,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompleteTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompleteTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TuningTask) MarshalJSON() ([]byte, error) {
	type NoMethod TuningTask
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UpdateChunkRequest: Request to update a `Chunk`.
type UpdateChunkRequest struct {
	// Chunk: Required. The `Chunk` to update.
	Chunk *Chunk `json:"chunk,omitempty"`
	// UpdateMask: Required. The list of fields to update. Currently, this only
	// supports updating `custom_metadata` and `data`.
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Chunk") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Chunk") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UpdateChunkRequest) MarshalJSON() ([]byte, error) {
	type NoMethod UpdateChunkRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UsageMetadata: Metadata on the generation request's token usage.
type UsageMetadata struct {
	// CachedContentTokenCount: Number of tokens in the cached part of the prompt,
	// i.e. in the cached content.
	CachedContentTokenCount int64 `json:"cachedContentTokenCount,omitempty"`
	// CandidatesTokenCount: Total number of tokens across the generated
	// candidates.
	CandidatesTokenCount int64 `json:"candidatesTokenCount,omitempty"`
	// PromptTokenCount: Number of tokens in the prompt. When cached_content is
	// set, this is still the total effective prompt size. I.e. this includes the
	// number of tokens in the cached content.
	PromptTokenCount int64 `json:"promptTokenCount,omitempty"`
	// TotalTokenCount: Total token count for the generation request (prompt +
	// candidates).
	TotalTokenCount int64 `json:"totalTokenCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CachedContentTokenCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CachedContentTokenCount") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UsageMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod UsageMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// VideoMetadata: Metadata for a video `File`.
type VideoMetadata struct {
	// VideoDuration: Duration of the video.
	VideoDuration string `json:"videoDuration,omitempty"`
	// ForceSendFields is a list of field names (e.g. "VideoDuration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "VideoDuration") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s VideoMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod VideoMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type CachedContentsCreateCall struct {
	s             *Service
	cachedcontent *CachedContent
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Create: Creates CachedContent resource.
func (r *CachedContentsService) Create(cachedcontent *CachedContent) *CachedContentsCreateCall {
	c := &CachedContentsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.cachedcontent = cachedcontent
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CachedContentsCreateCall) Fields(s ...googleapi.Field) *CachedContentsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CachedContentsCreateCall) Context(ctx context.Context) *CachedContentsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CachedContentsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CachedContentsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.cachedcontent)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/cachedContents")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.cachedContents.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *CachedContent.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CachedContentsCreateCall) Do(opts ...googleapi.CallOption) (*CachedContent, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CachedContent{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type CachedContentsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes CachedContent resource.
//
//   - name: The resource name referring to the content cache entry Format:
//     `cachedContents/{id}`.
func (r *CachedContentsService) Delete(name string) *CachedContentsDeleteCall {
	c := &CachedContentsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CachedContentsDeleteCall) Fields(s ...googleapi.Field) *CachedContentsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CachedContentsDeleteCall) Context(ctx context.Context) *CachedContentsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CachedContentsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CachedContentsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.cachedContents.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CachedContentsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type CachedContentsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Reads CachedContent resource.
//
//   - name: The resource name referring to the content cache entry. Format:
//     `cachedContents/{id}`.
func (r *CachedContentsService) Get(name string) *CachedContentsGetCall {
	c := &CachedContentsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CachedContentsGetCall) Fields(s ...googleapi.Field) *CachedContentsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CachedContentsGetCall) IfNoneMatch(entityTag string) *CachedContentsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CachedContentsGetCall) Context(ctx context.Context) *CachedContentsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CachedContentsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CachedContentsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.cachedContents.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *CachedContent.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CachedContentsGetCall) Do(opts ...googleapi.CallOption) (*CachedContent, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CachedContent{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type CachedContentsListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists CachedContents.
func (r *CachedContentsService) List() *CachedContentsListCall {
	c := &CachedContentsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// cached contents to return. The service may return fewer than this value. If
// unspecified, some default (under maximum) number of items will be returned.
// The maximum value is 1000; values above 1000 will be coerced to 1000.
func (c *CachedContentsListCall) PageSize(pageSize int64) *CachedContentsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListCachedContents` call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// `ListCachedContents` must match the call that provided the page token.
func (c *CachedContentsListCall) PageToken(pageToken string) *CachedContentsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CachedContentsListCall) Fields(s ...googleapi.Field) *CachedContentsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CachedContentsListCall) IfNoneMatch(entityTag string) *CachedContentsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CachedContentsListCall) Context(ctx context.Context) *CachedContentsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CachedContentsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CachedContentsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/cachedContents")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.cachedContents.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListCachedContentsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CachedContentsListCall) Do(opts ...googleapi.CallOption) (*ListCachedContentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListCachedContentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CachedContentsListCall) Pages(ctx context.Context, f func(*ListCachedContentsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type CachedContentsPatchCall struct {
	s             *Service
	name          string
	cachedcontent *CachedContent
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Patch: Updates CachedContent resource (only expiration is updatable).
//
//   - name: Optional. Identifier. The resource name referring to the cached
//     content. Format: `cachedContents/{id}`.
func (r *CachedContentsService) Patch(name string, cachedcontent *CachedContent) *CachedContentsPatchCall {
	c := &CachedContentsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.cachedcontent = cachedcontent
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of fields to
// update.
func (c *CachedContentsPatchCall) UpdateMask(updateMask string) *CachedContentsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CachedContentsPatchCall) Fields(s ...googleapi.Field) *CachedContentsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CachedContentsPatchCall) Context(ctx context.Context) *CachedContentsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CachedContentsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CachedContentsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.cachedcontent)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.cachedContents.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *CachedContent.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CachedContentsPatchCall) Do(opts ...googleapi.CallOption) (*CachedContent, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CachedContent{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type CorporaCreateCall struct {
	s          *Service
	corpus     *Corpus
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates an empty `Corpus`.
func (r *CorporaService) Create(corpus *Corpus) *CorporaCreateCall {
	c := &CorporaCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.corpus = corpus
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CorporaCreateCall) Fields(s ...googleapi.Field) *CorporaCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CorporaCreateCall) Context(ctx context.Context) *CorporaCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CorporaCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CorporaCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.corpus)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/corpora")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.corpora.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Corpus.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CorporaCreateCall) Do(opts ...googleapi.CallOption) (*Corpus, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Corpus{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type CorporaDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a `Corpus`.
//
// - name: The resource name of the `Corpus`. Example: `corpora/my-corpus-123`.
func (r *CorporaService) Delete(name string) *CorporaDeleteCall {
	c := &CorporaDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Force sets the optional parameter "force": If set to true, any `Document`s
// and objects related to this `Corpus` will also be deleted. If false (the
// default), a `FAILED_PRECONDITION` error will be returned if `Corpus`
// contains any `Document`s.
func (c *CorporaDeleteCall) Force(force bool) *CorporaDeleteCall {
	c.urlParams_.Set("force", fmt.Sprint(force))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CorporaDeleteCall) Fields(s ...googleapi.Field) *CorporaDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CorporaDeleteCall) Context(ctx context.Context) *CorporaDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CorporaDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CorporaDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.corpora.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CorporaDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type CorporaGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a specific `Corpus`.
//
// - name: The name of the `Corpus`. Example: `corpora/my-corpus-123`.
func (r *CorporaService) Get(name string) *CorporaGetCall {
	c := &CorporaGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CorporaGetCall) Fields(s ...googleapi.Field) *CorporaGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CorporaGetCall) IfNoneMatch(entityTag string) *CorporaGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CorporaGetCall) Context(ctx context.Context) *CorporaGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CorporaGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CorporaGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.corpora.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Corpus.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CorporaGetCall) Do(opts ...googleapi.CallOption) (*Corpus, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Corpus{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type CorporaListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all `Corpora` owned by the user.
func (r *CorporaService) List() *CorporaListCall {
	c := &CorporaListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// `Corpora` to return (per page). The service may return fewer `Corpora`. If
// unspecified, at most 10 `Corpora` will be returned. The maximum size limit
// is 20 `Corpora` per page.
func (c *CorporaListCall) PageSize(pageSize int64) *CorporaListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListCorpora` call. Provide the `next_page_token` returned
// in the response as an argument to the next request to retrieve the next
// page. When paginating, all other parameters provided to `ListCorpora` must
// match the call that provided the page token.
func (c *CorporaListCall) PageToken(pageToken string) *CorporaListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CorporaListCall) Fields(s ...googleapi.Field) *CorporaListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CorporaListCall) IfNoneMatch(entityTag string) *CorporaListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CorporaListCall) Context(ctx context.Context) *CorporaListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CorporaListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CorporaListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/corpora")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.corpora.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListCorporaResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *CorporaListCall) Do(opts ...googleapi.CallOption) (*ListCorporaResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListCorporaResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CorporaListCall) Pages(ctx context.Context, f func(*ListCorporaResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type CorporaPatchCall struct {
	s          *Service
	name       string
	corpus     *Corpus
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates a `Corpus`.
//
//   - name: Immutable. Identifier. The `Corpus` resource name. The ID (name
//     excluding the "corpora/" prefix) can contain up to 40 characters that are
//     lowercase alphanumeric or dashes (-). The ID cannot start or end with a
//     dash. If the name is empty on create, a unique name will be derived from
//     `display_name` along with a 12 character random suffix. Example:
//     `corpora/my-awesome-corpora-123a456b789c`.
func (r *CorporaService) Patch(name string, corpus *Corpus) *CorporaPatchCall {
	c := &CorporaPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.corpus = corpus
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The list of
// fields to update. Currently, this only supports updating `display_name`.
func (c *CorporaPatchCall) UpdateMask(updateMask string) *CorporaPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CorporaPatchCall) Fields(s ...googleapi.Field) *CorporaPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CorporaPatchCall) Context(ctx context.Context) *CorporaPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CorporaPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CorporaPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.corpus)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.corpora.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Corpus.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CorporaPatchCall) Do(opts ...googleapi.CallOption) (*Corpus, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Corpus{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type CorporaQueryCall struct {
	s                  *Service
	name               string
	querycorpusrequest *QueryCorpusRequest
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// Query: Performs semantic search over a `Corpus`.
//
// - name: The name of the `Corpus` to query. Example: `corpora/my-corpus-123`.
func (r *CorporaService) Query(name string, querycorpusrequest *QueryCorpusRequest) *CorporaQueryCall {
	c := &CorporaQueryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.querycorpusrequest = querycorpusrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CorporaQueryCall) Fields(s ...googleapi.Field) *CorporaQueryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CorporaQueryCall) Context(ctx context.Context) *CorporaQueryCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CorporaQueryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CorporaQueryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.querycorpusrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}:query")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.corpora.query" call.
// Any non-2xx status code is an error. Response headers are in either
// *QueryCorpusResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *CorporaQueryCall) Do(opts ...googleapi.CallOption) (*QueryCorpusResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &QueryCorpusResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type CorporaDocumentsCreateCall struct {
	s          *Service
	parent     string
	document   *Document
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates an empty `Document`.
//
//   - parent: The name of the `Corpus` where this `Document` will be created.
//     Example: `corpora/my-corpus-123`.
func (r *CorporaDocumentsService) Create(parent string, document *Document) *CorporaDocumentsCreateCall {
	c := &CorporaDocumentsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.document = document
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CorporaDocumentsCreateCall) Fields(s ...googleapi.Field) *CorporaDocumentsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CorporaDocumentsCreateCall) Context(ctx context.Context) *CorporaDocumentsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CorporaDocumentsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CorporaDocumentsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.document)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/documents")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.corpora.documents.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Document.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CorporaDocumentsCreateCall) Do(opts ...googleapi.CallOption) (*Document, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Document{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type CorporaDocumentsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a `Document`.
//
//   - name: The resource name of the `Document` to delete. Example:
//     `corpora/my-corpus-123/documents/the-doc-abc`.
func (r *CorporaDocumentsService) Delete(name string) *CorporaDocumentsDeleteCall {
	c := &CorporaDocumentsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Force sets the optional parameter "force": If set to true, any `Chunk`s and
// objects related to this `Document` will also be deleted. If false (the
// default), a `FAILED_PRECONDITION` error will be returned if `Document`
// contains any `Chunk`s.
func (c *CorporaDocumentsDeleteCall) Force(force bool) *CorporaDocumentsDeleteCall {
	c.urlParams_.Set("force", fmt.Sprint(force))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CorporaDocumentsDeleteCall) Fields(s ...googleapi.Field) *CorporaDocumentsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CorporaDocumentsDeleteCall) Context(ctx context.Context) *CorporaDocumentsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CorporaDocumentsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CorporaDocumentsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.corpora.documents.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CorporaDocumentsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type CorporaDocumentsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a specific `Document`.
//
//   - name: The name of the `Document` to retrieve. Example:
//     `corpora/my-corpus-123/documents/the-doc-abc`.
func (r *CorporaDocumentsService) Get(name string) *CorporaDocumentsGetCall {
	c := &CorporaDocumentsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CorporaDocumentsGetCall) Fields(s ...googleapi.Field) *CorporaDocumentsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CorporaDocumentsGetCall) IfNoneMatch(entityTag string) *CorporaDocumentsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CorporaDocumentsGetCall) Context(ctx context.Context) *CorporaDocumentsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CorporaDocumentsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CorporaDocumentsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.corpora.documents.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Document.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CorporaDocumentsGetCall) Do(opts ...googleapi.CallOption) (*Document, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Document{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type CorporaDocumentsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all `Document`s in a `Corpus`.
//
//   - parent: The name of the `Corpus` containing `Document`s. Example:
//     `corpora/my-corpus-123`.
func (r *CorporaDocumentsService) List(parent string) *CorporaDocumentsListCall {
	c := &CorporaDocumentsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// `Document`s to return (per page). The service may return fewer `Document`s.
// If unspecified, at most 10 `Document`s will be returned. The maximum size
// limit is 20 `Document`s per page.
func (c *CorporaDocumentsListCall) PageSize(pageSize int64) *CorporaDocumentsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListDocuments` call. Provide the `next_page_token` returned
// in the response as an argument to the next request to retrieve the next
// page. When paginating, all other parameters provided to `ListDocuments` must
// match the call that provided the page token.
func (c *CorporaDocumentsListCall) PageToken(pageToken string) *CorporaDocumentsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CorporaDocumentsListCall) Fields(s ...googleapi.Field) *CorporaDocumentsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CorporaDocumentsListCall) IfNoneMatch(entityTag string) *CorporaDocumentsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CorporaDocumentsListCall) Context(ctx context.Context) *CorporaDocumentsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CorporaDocumentsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CorporaDocumentsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/documents")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.corpora.documents.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListDocumentsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *CorporaDocumentsListCall) Do(opts ...googleapi.CallOption) (*ListDocumentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListDocumentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CorporaDocumentsListCall) Pages(ctx context.Context, f func(*ListDocumentsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type CorporaDocumentsPatchCall struct {
	s          *Service
	name       string
	document   *Document
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates a `Document`.
//
//   - name: Immutable. Identifier. The `Document` resource name. The ID (name
//     excluding the "corpora/*/documents/" prefix) can contain up to 40
//     characters that are lowercase alphanumeric or dashes (-). The ID cannot
//     start or end with a dash. If the name is empty on create, a unique name
//     will be derived from `display_name` along with a 12 character random
//     suffix. Example:
//     `corpora/{corpus_id}/documents/my-awesome-doc-123a456b789c`.
func (r *CorporaDocumentsService) Patch(name string, document *Document) *CorporaDocumentsPatchCall {
	c := &CorporaDocumentsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.document = document
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The list of
// fields to update. Currently, this only supports updating `display_name` and
// `custom_metadata`.
func (c *CorporaDocumentsPatchCall) UpdateMask(updateMask string) *CorporaDocumentsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CorporaDocumentsPatchCall) Fields(s ...googleapi.Field) *CorporaDocumentsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CorporaDocumentsPatchCall) Context(ctx context.Context) *CorporaDocumentsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CorporaDocumentsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CorporaDocumentsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.document)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.corpora.documents.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Document.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CorporaDocumentsPatchCall) Do(opts ...googleapi.CallOption) (*Document, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Document{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type CorporaDocumentsQueryCall struct {
	s                    *Service
	name                 string
	querydocumentrequest *QueryDocumentRequest
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// Query: Performs semantic search over a `Document`.
//
//   - name: The name of the `Document` to query. Example:
//     `corpora/my-corpus-123/documents/the-doc-abc`.
func (r *CorporaDocumentsService) Query(name string, querydocumentrequest *QueryDocumentRequest) *CorporaDocumentsQueryCall {
	c := &CorporaDocumentsQueryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.querydocumentrequest = querydocumentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CorporaDocumentsQueryCall) Fields(s ...googleapi.Field) *CorporaDocumentsQueryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CorporaDocumentsQueryCall) Context(ctx context.Context) *CorporaDocumentsQueryCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CorporaDocumentsQueryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CorporaDocumentsQueryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.querydocumentrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}:query")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.corpora.documents.query" call.
// Any non-2xx status code is an error. Response headers are in either
// *QueryDocumentResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *CorporaDocumentsQueryCall) Do(opts ...googleapi.CallOption) (*QueryDocumentResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &QueryDocumentResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type CorporaDocumentsChunksBatchCreateCall struct {
	s                        *Service
	parent                   string
	batchcreatechunksrequest *BatchCreateChunksRequest
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// BatchCreate: Batch create `Chunk`s.
//
//   - parent: Optional. The name of the `Document` where this batch of `Chunk`s
//     will be created. The parent field in every `CreateChunkRequest` must match
//     this value. Example: `corpora/my-corpus-123/documents/the-doc-abc`.
func (r *CorporaDocumentsChunksService) BatchCreate(parent string, batchcreatechunksrequest *BatchCreateChunksRequest) *CorporaDocumentsChunksBatchCreateCall {
	c := &CorporaDocumentsChunksBatchCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.batchcreatechunksrequest = batchcreatechunksrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CorporaDocumentsChunksBatchCreateCall) Fields(s ...googleapi.Field) *CorporaDocumentsChunksBatchCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CorporaDocumentsChunksBatchCreateCall) Context(ctx context.Context) *CorporaDocumentsChunksBatchCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CorporaDocumentsChunksBatchCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CorporaDocumentsChunksBatchCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.batchcreatechunksrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/chunks:batchCreate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.corpora.documents.chunks.batchCreate" call.
// Any non-2xx status code is an error. Response headers are in either
// *BatchCreateChunksResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CorporaDocumentsChunksBatchCreateCall) Do(opts ...googleapi.CallOption) (*BatchCreateChunksResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &BatchCreateChunksResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type CorporaDocumentsChunksBatchDeleteCall struct {
	s                        *Service
	parent                   string
	batchdeletechunksrequest *BatchDeleteChunksRequest
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// BatchDelete: Batch delete `Chunk`s.
//
//   - parent: Optional. The name of the `Document` containing the `Chunk`s to
//     delete. The parent field in every `DeleteChunkRequest` must match this
//     value. Example: `corpora/my-corpus-123/documents/the-doc-abc`.
func (r *CorporaDocumentsChunksService) BatchDelete(parent string, batchdeletechunksrequest *BatchDeleteChunksRequest) *CorporaDocumentsChunksBatchDeleteCall {
	c := &CorporaDocumentsChunksBatchDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.batchdeletechunksrequest = batchdeletechunksrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CorporaDocumentsChunksBatchDeleteCall) Fields(s ...googleapi.Field) *CorporaDocumentsChunksBatchDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CorporaDocumentsChunksBatchDeleteCall) Context(ctx context.Context) *CorporaDocumentsChunksBatchDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CorporaDocumentsChunksBatchDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CorporaDocumentsChunksBatchDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.batchdeletechunksrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/chunks:batchDelete")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.corpora.documents.chunks.batchDelete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CorporaDocumentsChunksBatchDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type CorporaDocumentsChunksBatchUpdateCall struct {
	s                        *Service
	parent                   string
	batchupdatechunksrequest *BatchUpdateChunksRequest
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// BatchUpdate: Batch update `Chunk`s.
//
//   - parent: Optional. The name of the `Document` containing the `Chunk`s to
//     update. The parent field in every `UpdateChunkRequest` must match this
//     value. Example: `corpora/my-corpus-123/documents/the-doc-abc`.
func (r *CorporaDocumentsChunksService) BatchUpdate(parent string, batchupdatechunksrequest *BatchUpdateChunksRequest) *CorporaDocumentsChunksBatchUpdateCall {
	c := &CorporaDocumentsChunksBatchUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.batchupdatechunksrequest = batchupdatechunksrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CorporaDocumentsChunksBatchUpdateCall) Fields(s ...googleapi.Field) *CorporaDocumentsChunksBatchUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CorporaDocumentsChunksBatchUpdateCall) Context(ctx context.Context) *CorporaDocumentsChunksBatchUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CorporaDocumentsChunksBatchUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CorporaDocumentsChunksBatchUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.batchupdatechunksrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/chunks:batchUpdate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.corpora.documents.chunks.batchUpdate" call.
// Any non-2xx status code is an error. Response headers are in either
// *BatchUpdateChunksResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CorporaDocumentsChunksBatchUpdateCall) Do(opts ...googleapi.CallOption) (*BatchUpdateChunksResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &BatchUpdateChunksResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type CorporaDocumentsChunksCreateCall struct {
	s          *Service
	parent     string
	chunk      *Chunk
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a `Chunk`.
//
//   - parent: The name of the `Document` where this `Chunk` will be created.
//     Example: `corpora/my-corpus-123/documents/the-doc-abc`.
func (r *CorporaDocumentsChunksService) Create(parent string, chunk *Chunk) *CorporaDocumentsChunksCreateCall {
	c := &CorporaDocumentsChunksCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.chunk = chunk
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CorporaDocumentsChunksCreateCall) Fields(s ...googleapi.Field) *CorporaDocumentsChunksCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CorporaDocumentsChunksCreateCall) Context(ctx context.Context) *CorporaDocumentsChunksCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CorporaDocumentsChunksCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CorporaDocumentsChunksCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.chunk)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/chunks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.corpora.documents.chunks.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Chunk.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CorporaDocumentsChunksCreateCall) Do(opts ...googleapi.CallOption) (*Chunk, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Chunk{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type CorporaDocumentsChunksDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a `Chunk`.
//
//   - name: The resource name of the `Chunk` to delete. Example:
//     `corpora/my-corpus-123/documents/the-doc-abc/chunks/some-chunk`.
func (r *CorporaDocumentsChunksService) Delete(name string) *CorporaDocumentsChunksDeleteCall {
	c := &CorporaDocumentsChunksDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CorporaDocumentsChunksDeleteCall) Fields(s ...googleapi.Field) *CorporaDocumentsChunksDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CorporaDocumentsChunksDeleteCall) Context(ctx context.Context) *CorporaDocumentsChunksDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CorporaDocumentsChunksDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CorporaDocumentsChunksDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.corpora.documents.chunks.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CorporaDocumentsChunksDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type CorporaDocumentsChunksGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a specific `Chunk`.
//
//   - name: The name of the `Chunk` to retrieve. Example:
//     `corpora/my-corpus-123/documents/the-doc-abc/chunks/some-chunk`.
func (r *CorporaDocumentsChunksService) Get(name string) *CorporaDocumentsChunksGetCall {
	c := &CorporaDocumentsChunksGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CorporaDocumentsChunksGetCall) Fields(s ...googleapi.Field) *CorporaDocumentsChunksGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CorporaDocumentsChunksGetCall) IfNoneMatch(entityTag string) *CorporaDocumentsChunksGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CorporaDocumentsChunksGetCall) Context(ctx context.Context) *CorporaDocumentsChunksGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CorporaDocumentsChunksGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CorporaDocumentsChunksGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.corpora.documents.chunks.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Chunk.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CorporaDocumentsChunksGetCall) Do(opts ...googleapi.CallOption) (*Chunk, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Chunk{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type CorporaDocumentsChunksListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all `Chunk`s in a `Document`.
//
//   - parent: The name of the `Document` containing `Chunk`s. Example:
//     `corpora/my-corpus-123/documents/the-doc-abc`.
func (r *CorporaDocumentsChunksService) List(parent string) *CorporaDocumentsChunksListCall {
	c := &CorporaDocumentsChunksListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// `Chunk`s to return (per page). The service may return fewer `Chunk`s. If
// unspecified, at most 10 `Chunk`s will be returned. The maximum size limit is
// 100 `Chunk`s per page.
func (c *CorporaDocumentsChunksListCall) PageSize(pageSize int64) *CorporaDocumentsChunksListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListChunks` call. Provide the `next_page_token` returned in
// the response as an argument to the next request to retrieve the next page.
// When paginating, all other parameters provided to `ListChunks` must match
// the call that provided the page token.
func (c *CorporaDocumentsChunksListCall) PageToken(pageToken string) *CorporaDocumentsChunksListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CorporaDocumentsChunksListCall) Fields(s ...googleapi.Field) *CorporaDocumentsChunksListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CorporaDocumentsChunksListCall) IfNoneMatch(entityTag string) *CorporaDocumentsChunksListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CorporaDocumentsChunksListCall) Context(ctx context.Context) *CorporaDocumentsChunksListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CorporaDocumentsChunksListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CorporaDocumentsChunksListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/chunks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.corpora.documents.chunks.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListChunksResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *CorporaDocumentsChunksListCall) Do(opts ...googleapi.CallOption) (*ListChunksResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListChunksResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CorporaDocumentsChunksListCall) Pages(ctx context.Context, f func(*ListChunksResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type CorporaDocumentsChunksPatchCall struct {
	s          *Service
	name       string
	chunk      *Chunk
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates a `Chunk`.
//
//   - name: Immutable. Identifier. The `Chunk` resource name. The ID (name
//     excluding the "corpora/*/documents/*/chunks/" prefix) can contain up to 40
//     characters that are lowercase alphanumeric or dashes (-). The ID cannot
//     start or end with a dash. If the name is empty on create, a random
//     12-character unique ID will be generated. Example:
//     `corpora/{corpus_id}/documents/{document_id}/chunks/123a456b789c`.
func (r *CorporaDocumentsChunksService) Patch(name string, chunk *Chunk) *CorporaDocumentsChunksPatchCall {
	c := &CorporaDocumentsChunksPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.chunk = chunk
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The list of
// fields to update. Currently, this only supports updating `custom_metadata`
// and `data`.
func (c *CorporaDocumentsChunksPatchCall) UpdateMask(updateMask string) *CorporaDocumentsChunksPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CorporaDocumentsChunksPatchCall) Fields(s ...googleapi.Field) *CorporaDocumentsChunksPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CorporaDocumentsChunksPatchCall) Context(ctx context.Context) *CorporaDocumentsChunksPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CorporaDocumentsChunksPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CorporaDocumentsChunksPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.chunk)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.corpora.documents.chunks.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Chunk.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CorporaDocumentsChunksPatchCall) Do(opts ...googleapi.CallOption) (*Chunk, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Chunk{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type CorporaPermissionsCreateCall struct {
	s          *Service
	parent     string
	permission *Permission
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Create a permission to a specific resource.
//
//   - parent: The parent resource of the `Permission`. Formats:
//     `tunedModels/{tuned_model}` `corpora/{corpus}`.
func (r *CorporaPermissionsService) Create(parent string, permission *Permission) *CorporaPermissionsCreateCall {
	c := &CorporaPermissionsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.permission = permission
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CorporaPermissionsCreateCall) Fields(s ...googleapi.Field) *CorporaPermissionsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CorporaPermissionsCreateCall) Context(ctx context.Context) *CorporaPermissionsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CorporaPermissionsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CorporaPermissionsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.permission)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/permissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.corpora.permissions.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Permission.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CorporaPermissionsCreateCall) Do(opts ...googleapi.CallOption) (*Permission, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Permission{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type CorporaPermissionsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the permission.
//
//   - name: The resource name of the permission. Formats:
//     `tunedModels/{tuned_model}/permissions/{permission}`
//     `corpora/{corpus}/permissions/{permission}`.
func (r *CorporaPermissionsService) Delete(name string) *CorporaPermissionsDeleteCall {
	c := &CorporaPermissionsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CorporaPermissionsDeleteCall) Fields(s ...googleapi.Field) *CorporaPermissionsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CorporaPermissionsDeleteCall) Context(ctx context.Context) *CorporaPermissionsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CorporaPermissionsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CorporaPermissionsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.corpora.permissions.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CorporaPermissionsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type CorporaPermissionsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a specific Permission.
//
//   - name: The resource name of the permission. Formats:
//     `tunedModels/{tuned_model}/permissions/{permission}`
//     `corpora/{corpus}/permissions/{permission}`.
func (r *CorporaPermissionsService) Get(name string) *CorporaPermissionsGetCall {
	c := &CorporaPermissionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CorporaPermissionsGetCall) Fields(s ...googleapi.Field) *CorporaPermissionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CorporaPermissionsGetCall) IfNoneMatch(entityTag string) *CorporaPermissionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CorporaPermissionsGetCall) Context(ctx context.Context) *CorporaPermissionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CorporaPermissionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CorporaPermissionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.corpora.permissions.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Permission.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CorporaPermissionsGetCall) Do(opts ...googleapi.CallOption) (*Permission, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Permission{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type CorporaPermissionsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists permissions for the specific resource.
//
//   - parent: The parent resource of the permissions. Formats:
//     `tunedModels/{tuned_model}` `corpora/{corpus}`.
func (r *CorporaPermissionsService) List(parent string) *CorporaPermissionsListCall {
	c := &CorporaPermissionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// `Permission`s to return (per page). The service may return fewer
// permissions. If unspecified, at most 10 permissions will be returned. This
// method returns at most 1000 permissions per page, even if you pass larger
// page_size.
func (c *CorporaPermissionsListCall) PageSize(pageSize int64) *CorporaPermissionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListPermissions` call. Provide the `page_token` returned by
// one request as an argument to the next request to retrieve the next page.
// When paginating, all other parameters provided to `ListPermissions` must
// match the call that provided the page token.
func (c *CorporaPermissionsListCall) PageToken(pageToken string) *CorporaPermissionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CorporaPermissionsListCall) Fields(s ...googleapi.Field) *CorporaPermissionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CorporaPermissionsListCall) IfNoneMatch(entityTag string) *CorporaPermissionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CorporaPermissionsListCall) Context(ctx context.Context) *CorporaPermissionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CorporaPermissionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CorporaPermissionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/permissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.corpora.permissions.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CorporaPermissionsListCall) Do(opts ...googleapi.CallOption) (*ListPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CorporaPermissionsListCall) Pages(ctx context.Context, f func(*ListPermissionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type CorporaPermissionsPatchCall struct {
	s          *Service
	name       string
	permission *Permission
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates the permission.
//
//   - name: Output only. Identifier. The permission name. A unique name will be
//     generated on create. Examples:
//     tunedModels/{tuned_model}/permissions/{permission}
//     corpora/{corpus}/permissions/{permission} Output only.
func (r *CorporaPermissionsService) Patch(name string, permission *Permission) *CorporaPermissionsPatchCall {
	c := &CorporaPermissionsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.permission = permission
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The list of
// fields to update. Accepted ones: - role (`Permission.role` field)
func (c *CorporaPermissionsPatchCall) UpdateMask(updateMask string) *CorporaPermissionsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CorporaPermissionsPatchCall) Fields(s ...googleapi.Field) *CorporaPermissionsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CorporaPermissionsPatchCall) Context(ctx context.Context) *CorporaPermissionsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CorporaPermissionsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CorporaPermissionsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.permission)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.corpora.permissions.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Permission.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CorporaPermissionsPatchCall) Do(opts ...googleapi.CallOption) (*Permission, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Permission{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type FilesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the `File`.
//
// - name: The name of the `File` to delete. Example: `files/abc-123`.
func (r *FilesService) Delete(name string) *FilesDeleteCall {
	c := &FilesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FilesDeleteCall) Fields(s ...googleapi.Field) *FilesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FilesDeleteCall) Context(ctx context.Context) *FilesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FilesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FilesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.files.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FilesDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type FilesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the metadata for the given `File`.
//
// - name: The name of the `File` to get. Example: `files/abc-123`.
func (r *FilesService) Get(name string) *FilesGetCall {
	c := &FilesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FilesGetCall) Fields(s ...googleapi.Field) *FilesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *FilesGetCall) IfNoneMatch(entityTag string) *FilesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FilesGetCall) Context(ctx context.Context) *FilesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FilesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FilesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.files.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *File.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FilesGetCall) Do(opts ...googleapi.CallOption) (*File, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &File{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type FilesListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the metadata for `File`s owned by the requesting project.
func (r *FilesService) List() *FilesListCall {
	c := &FilesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of `File`s
// to return per page. If unspecified, defaults to 10. Maximum `page_size` is
// 100.
func (c *FilesListCall) PageSize(pageSize int64) *FilesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token from a
// previous `ListFiles` call.
func (c *FilesListCall) PageToken(pageToken string) *FilesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FilesListCall) Fields(s ...googleapi.Field) *FilesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *FilesListCall) IfNoneMatch(entityTag string) *FilesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FilesListCall) Context(ctx context.Context) *FilesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FilesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FilesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/files")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.files.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListFilesResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *FilesListCall) Do(opts ...googleapi.CallOption) (*ListFilesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListFilesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *FilesListCall) Pages(ctx context.Context, f func(*ListFilesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type MediaUploadCall struct {
	s                 *Service
	createfilerequest *CreateFileRequest
	urlParams_        gensupport.URLParams
	mediaInfo_        *gensupport.MediaInfo
	ctx_              context.Context
	header_           http.Header
}

// Upload: Creates a `File`.
func (r *MediaService) Upload(createfilerequest *CreateFileRequest) *MediaUploadCall {
	c := &MediaUploadCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.createfilerequest = createfilerequest
	return c
}

// Media specifies the media to upload in one or more chunks. The chunk size
// may be controlled by supplying a MediaOption generated by
// googleapi.ChunkSize. The chunk size defaults to
// googleapi.DefaultUploadChunkSize.The Content-Type header used in the upload
// request will be determined by sniffing the contents of r, unless a
// MediaOption generated by googleapi.ContentType is supplied.
// At most one of Media and ResumableMedia may be set.
func (c *MediaUploadCall) Media(r io.Reader, options ...googleapi.MediaOption) *MediaUploadCall {
	c.mediaInfo_ = gensupport.NewInfoFromMedia(r, options)
	return c
}

// ResumableMedia specifies the media to upload in chunks and can be canceled
// with ctx.
//
// Deprecated: use Media instead.
//
// At most one of Media and ResumableMedia may be set. mediaType identifies the
// MIME media type of the upload, such as "image/png". If mediaType is "", it
// will be auto-detected. The provided ctx will supersede any context
// previously provided to the Context method.
func (c *MediaUploadCall) ResumableMedia(ctx context.Context, r io.ReaderAt, size int64, mediaType string) *MediaUploadCall {
	c.ctx_ = ctx
	c.mediaInfo_ = gensupport.NewInfoFromResumableMedia(r, size, mediaType)
	return c
}

// ProgressUpdater provides a callback function that will be called after every
// chunk. It should be a low-latency function in order to not slow down the
// upload operation. This should only be called when using ResumableMedia (as
// opposed to Media).
func (c *MediaUploadCall) ProgressUpdater(pu googleapi.ProgressUpdater) *MediaUploadCall {
	c.mediaInfo_.SetProgressUpdater(pu)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *MediaUploadCall) Fields(s ...googleapi.Field) *MediaUploadCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
// This context will supersede any context previously provided to the
// ResumableMedia method.
func (c *MediaUploadCall) Context(ctx context.Context) *MediaUploadCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *MediaUploadCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MediaUploadCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.createfilerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/files")
	if c.mediaInfo_ != nil {
		urls = googleapi.ResolveRelative(c.s.BasePath, "/upload/v1beta/files")
		c.urlParams_.Set("uploadType", c.mediaInfo_.UploadType())
	}
	if body == nil {
		body = new(bytes.Buffer)
		reqHeaders.Set("Content-Type", "application/json")
	}
	body, getBody, cleanup := c.mediaInfo_.UploadRequest(reqHeaders, body)
	defer cleanup()
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	req.GetBody = getBody
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.media.upload" call.
// Any non-2xx status code is an error. Response headers are in either
// *CreateFileResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *MediaUploadCall) Do(opts ...googleapi.CallOption) (*CreateFileResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	rx := c.mediaInfo_.ResumableUpload(res.Header.Get("Location"))
	if rx != nil {
		rx.Client = c.s.client
		rx.UserAgent = c.s.userAgent()
		ctx := c.ctx_
		if ctx == nil {
			ctx = context.TODO()
		}
		res, err = rx.Upload(ctx)
		if err != nil {
			return nil, err
		}
		defer res.Body.Close()
		if err := googleapi.CheckResponse(res); err != nil {
			return nil, gensupport.WrapError(err)
		}
	}
	ret := &CreateFileResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ModelsBatchEmbedContentsCall struct {
	s                         *Service
	model                     string
	batchembedcontentsrequest *BatchEmbedContentsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// BatchEmbedContents: Generates multiple embeddings from the model given input
// text in a synchronous call.
//
//   - model: The model's resource name. This serves as an ID for the Model to
//     use. This name should match a model name returned by the `ListModels`
//     method. Format: `models/{model}`.
func (r *ModelsService) BatchEmbedContents(model string, batchembedcontentsrequest *BatchEmbedContentsRequest) *ModelsBatchEmbedContentsCall {
	c := &ModelsBatchEmbedContentsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.model = model
	c.batchembedcontentsrequest = batchembedcontentsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ModelsBatchEmbedContentsCall) Fields(s ...googleapi.Field) *ModelsBatchEmbedContentsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ModelsBatchEmbedContentsCall) Context(ctx context.Context) *ModelsBatchEmbedContentsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ModelsBatchEmbedContentsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ModelsBatchEmbedContentsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.batchembedcontentsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+model}:batchEmbedContents")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"model": c.model,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.models.batchEmbedContents" call.
// Any non-2xx status code is an error. Response headers are in either
// *BatchEmbedContentsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ModelsBatchEmbedContentsCall) Do(opts ...googleapi.CallOption) (*BatchEmbedContentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &BatchEmbedContentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ModelsBatchEmbedTextCall struct {
	s                     *Service
	model                 string
	batchembedtextrequest *BatchEmbedTextRequest
	urlParams_            gensupport.URLParams
	ctx_                  context.Context
	header_               http.Header
}

// BatchEmbedText: Generates multiple embeddings from the model given input
// text in a synchronous call.
//
//   - model: The name of the `Model` to use for generating the embedding.
//     Examples: models/embedding-gecko-001.
func (r *ModelsService) BatchEmbedText(model string, batchembedtextrequest *BatchEmbedTextRequest) *ModelsBatchEmbedTextCall {
	c := &ModelsBatchEmbedTextCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.model = model
	c.batchembedtextrequest = batchembedtextrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ModelsBatchEmbedTextCall) Fields(s ...googleapi.Field) *ModelsBatchEmbedTextCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ModelsBatchEmbedTextCall) Context(ctx context.Context) *ModelsBatchEmbedTextCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ModelsBatchEmbedTextCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ModelsBatchEmbedTextCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.batchembedtextrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+model}:batchEmbedText")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"model": c.model,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.models.batchEmbedText" call.
// Any non-2xx status code is an error. Response headers are in either
// *BatchEmbedTextResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ModelsBatchEmbedTextCall) Do(opts ...googleapi.CallOption) (*BatchEmbedTextResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &BatchEmbedTextResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ModelsCountMessageTokensCall struct {
	s                         *Service
	model                     string
	countmessagetokensrequest *CountMessageTokensRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// CountMessageTokens: Runs a model's tokenizer on a string and returns the
// token count.
//
//   - model: The model's resource name. This serves as an ID for the Model to
//     use. This name should match a model name returned by the `ListModels`
//     method. Format: `models/{model}`.
func (r *ModelsService) CountMessageTokens(model string, countmessagetokensrequest *CountMessageTokensRequest) *ModelsCountMessageTokensCall {
	c := &ModelsCountMessageTokensCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.model = model
	c.countmessagetokensrequest = countmessagetokensrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ModelsCountMessageTokensCall) Fields(s ...googleapi.Field) *ModelsCountMessageTokensCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ModelsCountMessageTokensCall) Context(ctx context.Context) *ModelsCountMessageTokensCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ModelsCountMessageTokensCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ModelsCountMessageTokensCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.countmessagetokensrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+model}:countMessageTokens")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"model": c.model,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.models.countMessageTokens" call.
// Any non-2xx status code is an error. Response headers are in either
// *CountMessageTokensResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ModelsCountMessageTokensCall) Do(opts ...googleapi.CallOption) (*CountMessageTokensResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CountMessageTokensResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ModelsCountTextTokensCall struct {
	s                      *Service
	model                  string
	counttexttokensrequest *CountTextTokensRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// CountTextTokens: Runs a model's tokenizer on a text and returns the token
// count.
//
//   - model: The model's resource name. This serves as an ID for the Model to
//     use. This name should match a model name returned by the `ListModels`
//     method. Format: `models/{model}`.
func (r *ModelsService) CountTextTokens(model string, counttexttokensrequest *CountTextTokensRequest) *ModelsCountTextTokensCall {
	c := &ModelsCountTextTokensCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.model = model
	c.counttexttokensrequest = counttexttokensrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ModelsCountTextTokensCall) Fields(s ...googleapi.Field) *ModelsCountTextTokensCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ModelsCountTextTokensCall) Context(ctx context.Context) *ModelsCountTextTokensCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ModelsCountTextTokensCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ModelsCountTextTokensCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.counttexttokensrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+model}:countTextTokens")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"model": c.model,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.models.countTextTokens" call.
// Any non-2xx status code is an error. Response headers are in either
// *CountTextTokensResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ModelsCountTextTokensCall) Do(opts ...googleapi.CallOption) (*CountTextTokensResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CountTextTokensResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ModelsCountTokensCall struct {
	s                  *Service
	model              string
	counttokensrequest *CountTokensRequest
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// CountTokens: Runs a model's tokenizer on input content and returns the token
// count.
//
//   - model: The model's resource name. This serves as an ID for the Model to
//     use. This name should match a model name returned by the `ListModels`
//     method. Format: `models/{model}`.
func (r *ModelsService) CountTokens(model string, counttokensrequest *CountTokensRequest) *ModelsCountTokensCall {
	c := &ModelsCountTokensCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.model = model
	c.counttokensrequest = counttokensrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ModelsCountTokensCall) Fields(s ...googleapi.Field) *ModelsCountTokensCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ModelsCountTokensCall) Context(ctx context.Context) *ModelsCountTokensCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ModelsCountTokensCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ModelsCountTokensCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.counttokensrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+model}:countTokens")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"model": c.model,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.models.countTokens" call.
// Any non-2xx status code is an error. Response headers are in either
// *CountTokensResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ModelsCountTokensCall) Do(opts ...googleapi.CallOption) (*CountTokensResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CountTokensResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ModelsEmbedContentCall struct {
	s                   *Service
	model               string
	embedcontentrequest *EmbedContentRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// EmbedContent: Generates an embedding from the model given an input
// `Content`.
//
//   - model: The model's resource name. This serves as an ID for the Model to
//     use. This name should match a model name returned by the `ListModels`
//     method. Format: `models/{model}`.
func (r *ModelsService) EmbedContent(model string, embedcontentrequest *EmbedContentRequest) *ModelsEmbedContentCall {
	c := &ModelsEmbedContentCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.model = model
	c.embedcontentrequest = embedcontentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ModelsEmbedContentCall) Fields(s ...googleapi.Field) *ModelsEmbedContentCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ModelsEmbedContentCall) Context(ctx context.Context) *ModelsEmbedContentCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ModelsEmbedContentCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ModelsEmbedContentCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.embedcontentrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+model}:embedContent")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"model": c.model,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.models.embedContent" call.
// Any non-2xx status code is an error. Response headers are in either
// *EmbedContentResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ModelsEmbedContentCall) Do(opts ...googleapi.CallOption) (*EmbedContentResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &EmbedContentResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ModelsEmbedTextCall struct {
	s                *Service
	model            string
	embedtextrequest *EmbedTextRequest
	urlParams_       gensupport.URLParams
	ctx_             context.Context
	header_          http.Header
}

// EmbedText: Generates an embedding from the model given an input message.
//
// - model: The model name to use with the format model=models/{model}.
func (r *ModelsService) EmbedText(model string, embedtextrequest *EmbedTextRequest) *ModelsEmbedTextCall {
	c := &ModelsEmbedTextCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.model = model
	c.embedtextrequest = embedtextrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ModelsEmbedTextCall) Fields(s ...googleapi.Field) *ModelsEmbedTextCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ModelsEmbedTextCall) Context(ctx context.Context) *ModelsEmbedTextCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ModelsEmbedTextCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ModelsEmbedTextCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.embedtextrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+model}:embedText")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"model": c.model,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.models.embedText" call.
// Any non-2xx status code is an error. Response headers are in either
// *EmbedTextResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ModelsEmbedTextCall) Do(opts ...googleapi.CallOption) (*EmbedTextResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &EmbedTextResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ModelsGenerateAnswerCall struct {
	s                     *Service
	model                 string
	generateanswerrequest *GenerateAnswerRequest
	urlParams_            gensupport.URLParams
	ctx_                  context.Context
	header_               http.Header
}

// GenerateAnswer: Generates a grounded answer from the model given an input
// `GenerateAnswerRequest`.
//
//   - model: The name of the `Model` to use for generating the grounded
//     response. Format: `model=models/{model}`.
func (r *ModelsService) GenerateAnswer(model string, generateanswerrequest *GenerateAnswerRequest) *ModelsGenerateAnswerCall {
	c := &ModelsGenerateAnswerCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.model = model
	c.generateanswerrequest = generateanswerrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ModelsGenerateAnswerCall) Fields(s ...googleapi.Field) *ModelsGenerateAnswerCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ModelsGenerateAnswerCall) Context(ctx context.Context) *ModelsGenerateAnswerCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ModelsGenerateAnswerCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ModelsGenerateAnswerCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.generateanswerrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+model}:generateAnswer")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"model": c.model,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.models.generateAnswer" call.
// Any non-2xx status code is an error. Response headers are in either
// *GenerateAnswerResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ModelsGenerateAnswerCall) Do(opts ...googleapi.CallOption) (*GenerateAnswerResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GenerateAnswerResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ModelsGenerateContentCall struct {
	s                      *Service
	model                  string
	generatecontentrequest *GenerateContentRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// GenerateContent: Generates a response from the model given an input
// `GenerateContentRequest`. Input capabilities differ between models,
// including tuned models. See the model guide
// (https://ai.google.dev/models/gemini) and tuning guide
// (https://ai.google.dev/docs/model_tuning_guidance) for details.
//
//   - model: The name of the `Model` to use for generating the completion.
//     Format: `name=models/{model}`.
func (r *ModelsService) GenerateContent(model string, generatecontentrequest *GenerateContentRequest) *ModelsGenerateContentCall {
	c := &ModelsGenerateContentCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.model = model
	c.generatecontentrequest = generatecontentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ModelsGenerateContentCall) Fields(s ...googleapi.Field) *ModelsGenerateContentCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ModelsGenerateContentCall) Context(ctx context.Context) *ModelsGenerateContentCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ModelsGenerateContentCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ModelsGenerateContentCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.generatecontentrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+model}:generateContent")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"model": c.model,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.models.generateContent" call.
// Any non-2xx status code is an error. Response headers are in either
// *GenerateContentResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ModelsGenerateContentCall) Do(opts ...googleapi.CallOption) (*GenerateContentResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GenerateContentResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ModelsGenerateMessageCall struct {
	s                      *Service
	model                  string
	generatemessagerequest *GenerateMessageRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// GenerateMessage: Generates a response from the model given an input
// `MessagePrompt`.
//
// - model: The name of the model to use. Format: `name=models/{model}`.
func (r *ModelsService) GenerateMessage(model string, generatemessagerequest *GenerateMessageRequest) *ModelsGenerateMessageCall {
	c := &ModelsGenerateMessageCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.model = model
	c.generatemessagerequest = generatemessagerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ModelsGenerateMessageCall) Fields(s ...googleapi.Field) *ModelsGenerateMessageCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ModelsGenerateMessageCall) Context(ctx context.Context) *ModelsGenerateMessageCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ModelsGenerateMessageCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ModelsGenerateMessageCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.generatemessagerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+model}:generateMessage")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"model": c.model,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.models.generateMessage" call.
// Any non-2xx status code is an error. Response headers are in either
// *GenerateMessageResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ModelsGenerateMessageCall) Do(opts ...googleapi.CallOption) (*GenerateMessageResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GenerateMessageResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ModelsGenerateTextCall struct {
	s                   *Service
	model               string
	generatetextrequest *GenerateTextRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// GenerateText: Generates a response from the model given an input message.
//
//   - model: The name of the `Model` or `TunedModel` to use for generating the
//     completion. Examples: models/text-bison-001
//     tunedModels/sentence-translator-u3b7m.
func (r *ModelsService) GenerateText(model string, generatetextrequest *GenerateTextRequest) *ModelsGenerateTextCall {
	c := &ModelsGenerateTextCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.model = model
	c.generatetextrequest = generatetextrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ModelsGenerateTextCall) Fields(s ...googleapi.Field) *ModelsGenerateTextCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ModelsGenerateTextCall) Context(ctx context.Context) *ModelsGenerateTextCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ModelsGenerateTextCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ModelsGenerateTextCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.generatetextrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+model}:generateText")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"model": c.model,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.models.generateText" call.
// Any non-2xx status code is an error. Response headers are in either
// *GenerateTextResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ModelsGenerateTextCall) Do(opts ...googleapi.CallOption) (*GenerateTextResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GenerateTextResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ModelsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a specific Model.
//
//   - name: The resource name of the model. This name should match a model name
//     returned by the `ListModels` method. Format: `models/{model}`.
func (r *ModelsService) Get(name string) *ModelsGetCall {
	c := &ModelsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ModelsGetCall) Fields(s ...googleapi.Field) *ModelsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ModelsGetCall) IfNoneMatch(entityTag string) *ModelsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ModelsGetCall) Context(ctx context.Context) *ModelsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ModelsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ModelsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.models.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Model.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ModelsGetCall) Do(opts ...googleapi.CallOption) (*Model, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Model{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ModelsListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists models available through the API.
func (r *ModelsService) List() *ModelsListCall {
	c := &ModelsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// `Models` to return (per page). The service may return fewer models. If
// unspecified, at most 50 models will be returned per page. This method
// returns at most 1000 models per page, even if you pass a larger page_size.
func (c *ModelsListCall) PageSize(pageSize int64) *ModelsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListModels` call. Provide the `page_token` returned by one
// request as an argument to the next request to retrieve the next page. When
// paginating, all other parameters provided to `ListModels` must match the
// call that provided the page token.
func (c *ModelsListCall) PageToken(pageToken string) *ModelsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ModelsListCall) Fields(s ...googleapi.Field) *ModelsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ModelsListCall) IfNoneMatch(entityTag string) *ModelsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ModelsListCall) Context(ctx context.Context) *ModelsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ModelsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ModelsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/models")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.models.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListModelsResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ModelsListCall) Do(opts ...googleapi.CallOption) (*ListModelsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListModelsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ModelsListCall) Pages(ctx context.Context, f func(*ListModelsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ModelsStreamGenerateContentCall struct {
	s                      *Service
	model                  string
	generatecontentrequest *GenerateContentRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// StreamGenerateContent: Generates a streamed response from the model given an
// input `GenerateContentRequest`.
//
//   - model: The name of the `Model` to use for generating the completion.
//     Format: `name=models/{model}`.
func (r *ModelsService) StreamGenerateContent(model string, generatecontentrequest *GenerateContentRequest) *ModelsStreamGenerateContentCall {
	c := &ModelsStreamGenerateContentCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.model = model
	c.generatecontentrequest = generatecontentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ModelsStreamGenerateContentCall) Fields(s ...googleapi.Field) *ModelsStreamGenerateContentCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ModelsStreamGenerateContentCall) Context(ctx context.Context) *ModelsStreamGenerateContentCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ModelsStreamGenerateContentCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ModelsStreamGenerateContentCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.generatecontentrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+model}:streamGenerateContent")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"model": c.model,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.models.streamGenerateContent" call.
// Any non-2xx status code is an error. Response headers are in either
// *GenerateContentResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ModelsStreamGenerateContentCall) Do(opts ...googleapi.CallOption) (*GenerateContentResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GenerateContentResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type TunedModelsCreateCall struct {
	s          *Service
	tunedmodel *TunedModel
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a tuned model. Intermediate tuning progress (if any) is
// accessed through the [google.longrunning.Operations] service. Status and
// results can be accessed through the Operations service. Example: GET
// /v1/tunedModels/az2mb0bpw6i/operations/000-111-222
func (r *TunedModelsService) Create(tunedmodel *TunedModel) *TunedModelsCreateCall {
	c := &TunedModelsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.tunedmodel = tunedmodel
	return c
}

// TunedModelId sets the optional parameter "tunedModelId": The unique id for
// the tuned model if specified. This value should be up to 40 characters, the
// first character must be a letter, the last could be a letter or a number.
// The id must match the regular expression: a-z ([a-z0-9-]{0,38}[a-z0-9])?.
func (c *TunedModelsCreateCall) TunedModelId(tunedModelId string) *TunedModelsCreateCall {
	c.urlParams_.Set("tunedModelId", tunedModelId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TunedModelsCreateCall) Fields(s ...googleapi.Field) *TunedModelsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TunedModelsCreateCall) Context(ctx context.Context) *TunedModelsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TunedModelsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TunedModelsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.tunedmodel)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/tunedModels")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.tunedModels.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *TunedModelsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type TunedModelsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a tuned model.
//
// - name: The resource name of the model. Format: `tunedModels/my-model-id`.
func (r *TunedModelsService) Delete(name string) *TunedModelsDeleteCall {
	c := &TunedModelsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TunedModelsDeleteCall) Fields(s ...googleapi.Field) *TunedModelsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TunedModelsDeleteCall) Context(ctx context.Context) *TunedModelsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TunedModelsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TunedModelsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.tunedModels.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *TunedModelsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type TunedModelsGenerateContentCall struct {
	s                      *Service
	model                  string
	generatecontentrequest *GenerateContentRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// GenerateContent: Generates a response from the model given an input
// `GenerateContentRequest`. Input capabilities differ between models,
// including tuned models. See the model guide
// (https://ai.google.dev/models/gemini) and tuning guide
// (https://ai.google.dev/docs/model_tuning_guidance) for details.
//
//   - model: The name of the `Model` to use for generating the completion.
//     Format: `name=models/{model}`.
func (r *TunedModelsService) GenerateContent(model string, generatecontentrequest *GenerateContentRequest) *TunedModelsGenerateContentCall {
	c := &TunedModelsGenerateContentCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.model = model
	c.generatecontentrequest = generatecontentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TunedModelsGenerateContentCall) Fields(s ...googleapi.Field) *TunedModelsGenerateContentCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TunedModelsGenerateContentCall) Context(ctx context.Context) *TunedModelsGenerateContentCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TunedModelsGenerateContentCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TunedModelsGenerateContentCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.generatecontentrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+model}:generateContent")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"model": c.model,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.tunedModels.generateContent" call.
// Any non-2xx status code is an error. Response headers are in either
// *GenerateContentResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *TunedModelsGenerateContentCall) Do(opts ...googleapi.CallOption) (*GenerateContentResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GenerateContentResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type TunedModelsGenerateTextCall struct {
	s                   *Service
	model               string
	generatetextrequest *GenerateTextRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// GenerateText: Generates a response from the model given an input message.
//
//   - model: The name of the `Model` or `TunedModel` to use for generating the
//     completion. Examples: models/text-bison-001
//     tunedModels/sentence-translator-u3b7m.
func (r *TunedModelsService) GenerateText(model string, generatetextrequest *GenerateTextRequest) *TunedModelsGenerateTextCall {
	c := &TunedModelsGenerateTextCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.model = model
	c.generatetextrequest = generatetextrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TunedModelsGenerateTextCall) Fields(s ...googleapi.Field) *TunedModelsGenerateTextCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TunedModelsGenerateTextCall) Context(ctx context.Context) *TunedModelsGenerateTextCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TunedModelsGenerateTextCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TunedModelsGenerateTextCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.generatetextrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+model}:generateText")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"model": c.model,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.tunedModels.generateText" call.
// Any non-2xx status code is an error. Response headers are in either
// *GenerateTextResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *TunedModelsGenerateTextCall) Do(opts ...googleapi.CallOption) (*GenerateTextResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GenerateTextResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type TunedModelsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a specific TunedModel.
//
// - name: The resource name of the model. Format: `tunedModels/my-model-id`.
func (r *TunedModelsService) Get(name string) *TunedModelsGetCall {
	c := &TunedModelsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TunedModelsGetCall) Fields(s ...googleapi.Field) *TunedModelsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *TunedModelsGetCall) IfNoneMatch(entityTag string) *TunedModelsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TunedModelsGetCall) Context(ctx context.Context) *TunedModelsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TunedModelsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TunedModelsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.tunedModels.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *TunedModel.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *TunedModelsGetCall) Do(opts ...googleapi.CallOption) (*TunedModel, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TunedModel{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type TunedModelsListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists tuned models owned by the user.
func (r *TunedModelsService) List() *TunedModelsListCall {
	c := &TunedModelsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// Filter sets the optional parameter "filter": A filter is a full text search
// over the tuned model's description and display name. By default, results
// will not include tuned models shared with everyone. Additional operators: -
// owner:me - writers:me - readers:me - readers:everyone Examples: "owner:me"
// returns all tuned models to which caller has owner role "readers:me" returns
// all tuned models to which caller has reader role "readers:everyone" returns
// all tuned models that are shared with everyone
func (c *TunedModelsListCall) Filter(filter string) *TunedModelsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// `TunedModels` to return (per page). The service may return fewer tuned
// models. If unspecified, at most 10 tuned models will be returned. This
// method returns at most 1000 models per page, even if you pass a larger
// page_size.
func (c *TunedModelsListCall) PageSize(pageSize int64) *TunedModelsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListTunedModels` call. Provide the `page_token` returned by
// one request as an argument to the next request to retrieve the next page.
// When paginating, all other parameters provided to `ListTunedModels` must
// match the call that provided the page token.
func (c *TunedModelsListCall) PageToken(pageToken string) *TunedModelsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TunedModelsListCall) Fields(s ...googleapi.Field) *TunedModelsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *TunedModelsListCall) IfNoneMatch(entityTag string) *TunedModelsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TunedModelsListCall) Context(ctx context.Context) *TunedModelsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TunedModelsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TunedModelsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/tunedModels")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.tunedModels.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListTunedModelsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *TunedModelsListCall) Do(opts ...googleapi.CallOption) (*ListTunedModelsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListTunedModelsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *TunedModelsListCall) Pages(ctx context.Context, f func(*ListTunedModelsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type TunedModelsPatchCall struct {
	s          *Service
	name       string
	tunedmodel *TunedModel
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates a tuned model.
//
//   - name: Output only. The tuned model name. A unique name will be generated
//     on create. Example: `tunedModels/az2mb0bpw6i` If display_name is set on
//     create, the id portion of the name will be set by concatenating the words
//     of the display_name with hyphens and adding a random portion for
//     uniqueness. Example: display_name = "Sentence Translator" name =
//     "tunedModels/sentence-translator-u3b7m".
func (r *TunedModelsService) Patch(name string, tunedmodel *TunedModel) *TunedModelsPatchCall {
	c := &TunedModelsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.tunedmodel = tunedmodel
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The list of
// fields to update.
func (c *TunedModelsPatchCall) UpdateMask(updateMask string) *TunedModelsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TunedModelsPatchCall) Fields(s ...googleapi.Field) *TunedModelsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TunedModelsPatchCall) Context(ctx context.Context) *TunedModelsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TunedModelsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TunedModelsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.tunedmodel)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.tunedModels.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *TunedModel.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *TunedModelsPatchCall) Do(opts ...googleapi.CallOption) (*TunedModel, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TunedModel{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type TunedModelsTransferOwnershipCall struct {
	s                        *Service
	name                     string
	transferownershiprequest *TransferOwnershipRequest
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// TransferOwnership: Transfers ownership of the tuned model. This is the only
// way to change ownership of the tuned model. The current owner will be
// downgraded to writer role.
//
//   - name: The resource name of the tuned model to transfer ownership. Format:
//     `tunedModels/my-model-id`.
func (r *TunedModelsService) TransferOwnership(name string, transferownershiprequest *TransferOwnershipRequest) *TunedModelsTransferOwnershipCall {
	c := &TunedModelsTransferOwnershipCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.transferownershiprequest = transferownershiprequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TunedModelsTransferOwnershipCall) Fields(s ...googleapi.Field) *TunedModelsTransferOwnershipCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TunedModelsTransferOwnershipCall) Context(ctx context.Context) *TunedModelsTransferOwnershipCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TunedModelsTransferOwnershipCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TunedModelsTransferOwnershipCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.transferownershiprequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}:transferOwnership")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.tunedModels.transferOwnership" call.
// Any non-2xx status code is an error. Response headers are in either
// *TransferOwnershipResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *TunedModelsTransferOwnershipCall) Do(opts ...googleapi.CallOption) (*TransferOwnershipResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TransferOwnershipResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type TunedModelsPermissionsCreateCall struct {
	s          *Service
	parent     string
	permission *Permission
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Create a permission to a specific resource.
//
//   - parent: The parent resource of the `Permission`. Formats:
//     `tunedModels/{tuned_model}` `corpora/{corpus}`.
func (r *TunedModelsPermissionsService) Create(parent string, permission *Permission) *TunedModelsPermissionsCreateCall {
	c := &TunedModelsPermissionsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.permission = permission
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TunedModelsPermissionsCreateCall) Fields(s ...googleapi.Field) *TunedModelsPermissionsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TunedModelsPermissionsCreateCall) Context(ctx context.Context) *TunedModelsPermissionsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TunedModelsPermissionsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TunedModelsPermissionsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.permission)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/permissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.tunedModels.permissions.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Permission.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *TunedModelsPermissionsCreateCall) Do(opts ...googleapi.CallOption) (*Permission, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Permission{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type TunedModelsPermissionsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the permission.
//
//   - name: The resource name of the permission. Formats:
//     `tunedModels/{tuned_model}/permissions/{permission}`
//     `corpora/{corpus}/permissions/{permission}`.
func (r *TunedModelsPermissionsService) Delete(name string) *TunedModelsPermissionsDeleteCall {
	c := &TunedModelsPermissionsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TunedModelsPermissionsDeleteCall) Fields(s ...googleapi.Field) *TunedModelsPermissionsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TunedModelsPermissionsDeleteCall) Context(ctx context.Context) *TunedModelsPermissionsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TunedModelsPermissionsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TunedModelsPermissionsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.tunedModels.permissions.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *TunedModelsPermissionsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type TunedModelsPermissionsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a specific Permission.
//
//   - name: The resource name of the permission. Formats:
//     `tunedModels/{tuned_model}/permissions/{permission}`
//     `corpora/{corpus}/permissions/{permission}`.
func (r *TunedModelsPermissionsService) Get(name string) *TunedModelsPermissionsGetCall {
	c := &TunedModelsPermissionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TunedModelsPermissionsGetCall) Fields(s ...googleapi.Field) *TunedModelsPermissionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *TunedModelsPermissionsGetCall) IfNoneMatch(entityTag string) *TunedModelsPermissionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TunedModelsPermissionsGetCall) Context(ctx context.Context) *TunedModelsPermissionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TunedModelsPermissionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TunedModelsPermissionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.tunedModels.permissions.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Permission.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *TunedModelsPermissionsGetCall) Do(opts ...googleapi.CallOption) (*Permission, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Permission{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type TunedModelsPermissionsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists permissions for the specific resource.
//
//   - parent: The parent resource of the permissions. Formats:
//     `tunedModels/{tuned_model}` `corpora/{corpus}`.
func (r *TunedModelsPermissionsService) List(parent string) *TunedModelsPermissionsListCall {
	c := &TunedModelsPermissionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// `Permission`s to return (per page). The service may return fewer
// permissions. If unspecified, at most 10 permissions will be returned. This
// method returns at most 1000 permissions per page, even if you pass larger
// page_size.
func (c *TunedModelsPermissionsListCall) PageSize(pageSize int64) *TunedModelsPermissionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListPermissions` call. Provide the `page_token` returned by
// one request as an argument to the next request to retrieve the next page.
// When paginating, all other parameters provided to `ListPermissions` must
// match the call that provided the page token.
func (c *TunedModelsPermissionsListCall) PageToken(pageToken string) *TunedModelsPermissionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TunedModelsPermissionsListCall) Fields(s ...googleapi.Field) *TunedModelsPermissionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *TunedModelsPermissionsListCall) IfNoneMatch(entityTag string) *TunedModelsPermissionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TunedModelsPermissionsListCall) Context(ctx context.Context) *TunedModelsPermissionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TunedModelsPermissionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TunedModelsPermissionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/permissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.tunedModels.permissions.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *TunedModelsPermissionsListCall) Do(opts ...googleapi.CallOption) (*ListPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *TunedModelsPermissionsListCall) Pages(ctx context.Context, f func(*ListPermissionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type TunedModelsPermissionsPatchCall struct {
	s          *Service
	name       string
	permission *Permission
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates the permission.
//
//   - name: Output only. Identifier. The permission name. A unique name will be
//     generated on create. Examples:
//     tunedModels/{tuned_model}/permissions/{permission}
//     corpora/{corpus}/permissions/{permission} Output only.
func (r *TunedModelsPermissionsService) Patch(name string, permission *Permission) *TunedModelsPermissionsPatchCall {
	c := &TunedModelsPermissionsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.permission = permission
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The list of
// fields to update. Accepted ones: - role (`Permission.role` field)
func (c *TunedModelsPermissionsPatchCall) UpdateMask(updateMask string) *TunedModelsPermissionsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TunedModelsPermissionsPatchCall) Fields(s ...googleapi.Field) *TunedModelsPermissionsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TunedModelsPermissionsPatchCall) Context(ctx context.Context) *TunedModelsPermissionsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TunedModelsPermissionsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TunedModelsPermissionsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.permission)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "generativelanguage.tunedModels.permissions.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Permission.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *TunedModelsPermissionsPatchCall) Do(opts ...googleapi.CallOption) (*Permission, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Permission{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}
