// Code generated by go-swagger; DO NOT EDIT.

package legacy_alerts

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// GetAlertByIDReader is a Reader for the GetAlertByID structure.
type GetAlertByIDReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetAlertByIDReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetAlertByIDOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewGetAlertByIDUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetAlertByIDInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /alerts/{alert_id}] getAlertByID", response, response.Code())
	}
}

// NewGetAlertByIDOK creates a GetAlertByIDOK with default headers values
func NewGetAlertByIDOK() *GetAlertByIDOK {
	return &GetAlertByIDOK{}
}

/*
GetAlertByIDOK describes a response with status code 200, with default header values.

(empty)
*/
type GetAlertByIDOK struct {
	Payload *models.LegacyAlert
}

// IsSuccess returns true when this get alert by Id Ok response has a 2xx status code
func (o *GetAlertByIDOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get alert by Id Ok response has a 3xx status code
func (o *GetAlertByIDOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get alert by Id Ok response has a 4xx status code
func (o *GetAlertByIDOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get alert by Id Ok response has a 5xx status code
func (o *GetAlertByIDOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get alert by Id Ok response a status code equal to that given
func (o *GetAlertByIDOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get alert by Id Ok response
func (o *GetAlertByIDOK) Code() int {
	return 200
}

func (o *GetAlertByIDOK) Error() string {
	return fmt.Sprintf("[GET /alerts/{alert_id}][%d] getAlertByIdOk  %+v", 200, o.Payload)
}

func (o *GetAlertByIDOK) String() string {
	return fmt.Sprintf("[GET /alerts/{alert_id}][%d] getAlertByIdOk  %+v", 200, o.Payload)
}

func (o *GetAlertByIDOK) GetPayload() *models.LegacyAlert {
	return o.Payload
}

func (o *GetAlertByIDOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.LegacyAlert)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAlertByIDUnauthorized creates a GetAlertByIDUnauthorized with default headers values
func NewGetAlertByIDUnauthorized() *GetAlertByIDUnauthorized {
	return &GetAlertByIDUnauthorized{}
}

/*
GetAlertByIDUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type GetAlertByIDUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get alert by Id unauthorized response has a 2xx status code
func (o *GetAlertByIDUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get alert by Id unauthorized response has a 3xx status code
func (o *GetAlertByIDUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get alert by Id unauthorized response has a 4xx status code
func (o *GetAlertByIDUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this get alert by Id unauthorized response has a 5xx status code
func (o *GetAlertByIDUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this get alert by Id unauthorized response a status code equal to that given
func (o *GetAlertByIDUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the get alert by Id unauthorized response
func (o *GetAlertByIDUnauthorized) Code() int {
	return 401
}

func (o *GetAlertByIDUnauthorized) Error() string {
	return fmt.Sprintf("[GET /alerts/{alert_id}][%d] getAlertByIdUnauthorized  %+v", 401, o.Payload)
}

func (o *GetAlertByIDUnauthorized) String() string {
	return fmt.Sprintf("[GET /alerts/{alert_id}][%d] getAlertByIdUnauthorized  %+v", 401, o.Payload)
}

func (o *GetAlertByIDUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetAlertByIDUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAlertByIDInternalServerError creates a GetAlertByIDInternalServerError with default headers values
func NewGetAlertByIDInternalServerError() *GetAlertByIDInternalServerError {
	return &GetAlertByIDInternalServerError{}
}

/*
GetAlertByIDInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type GetAlertByIDInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get alert by Id internal server error response has a 2xx status code
func (o *GetAlertByIDInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get alert by Id internal server error response has a 3xx status code
func (o *GetAlertByIDInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get alert by Id internal server error response has a 4xx status code
func (o *GetAlertByIDInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get alert by Id internal server error response has a 5xx status code
func (o *GetAlertByIDInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get alert by Id internal server error response a status code equal to that given
func (o *GetAlertByIDInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get alert by Id internal server error response
func (o *GetAlertByIDInternalServerError) Code() int {
	return 500
}

func (o *GetAlertByIDInternalServerError) Error() string {
	return fmt.Sprintf("[GET /alerts/{alert_id}][%d] getAlertByIdInternalServerError  %+v", 500, o.Payload)
}

func (o *GetAlertByIDInternalServerError) String() string {
	return fmt.Sprintf("[GET /alerts/{alert_id}][%d] getAlertByIdInternalServerError  %+v", 500, o.Payload)
}

func (o *GetAlertByIDInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetAlertByIDInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
