// Code generated by go-swagger; DO NOT EDIT.

package orgs

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// NewAddOrgUserParams creates a new AddOrgUserParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewAddOrgUserParams() *AddOrgUserParams {
	return &AddOrgUserParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewAddOrgUserParamsWithTimeout creates a new AddOrgUserParams object
// with the ability to set a timeout on a request.
func NewAddOrgUserParamsWithTimeout(timeout time.Duration) *AddOrgUserParams {
	return &AddOrgUserParams{
		timeout: timeout,
	}
}

// NewAddOrgUserParamsWithContext creates a new AddOrgUserParams object
// with the ability to set a context for a request.
func NewAddOrgUserParamsWithContext(ctx context.Context) *AddOrgUserParams {
	return &AddOrgUserParams{
		Context: ctx,
	}
}

// NewAddOrgUserParamsWithHTTPClient creates a new AddOrgUserParams object
// with the ability to set a custom HTTPClient for a request.
func NewAddOrgUserParamsWithHTTPClient(client *http.Client) *AddOrgUserParams {
	return &AddOrgUserParams{
		HTTPClient: client,
	}
}

/*
AddOrgUserParams contains all the parameters to send to the API endpoint

	for the add org user operation.

	Typically these are written to a http.Request.
*/
type AddOrgUserParams struct {

	// Body.
	Body *models.AddOrgUserCommand

	// OrgID.
	//
	// Format: int64
	OrgID int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the add org user params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AddOrgUserParams) WithDefaults() *AddOrgUserParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the add org user params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AddOrgUserParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the add org user params
func (o *AddOrgUserParams) WithTimeout(timeout time.Duration) *AddOrgUserParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the add org user params
func (o *AddOrgUserParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the add org user params
func (o *AddOrgUserParams) WithContext(ctx context.Context) *AddOrgUserParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the add org user params
func (o *AddOrgUserParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the add org user params
func (o *AddOrgUserParams) WithHTTPClient(client *http.Client) *AddOrgUserParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the add org user params
func (o *AddOrgUserParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the add org user params
func (o *AddOrgUserParams) WithBody(body *models.AddOrgUserCommand) *AddOrgUserParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the add org user params
func (o *AddOrgUserParams) SetBody(body *models.AddOrgUserCommand) {
	o.Body = body
}

// WithOrgID adds the orgID to the add org user params
func (o *AddOrgUserParams) WithOrgID(orgID int64) *AddOrgUserParams {
	o.SetOrgID(orgID)
	return o
}

// SetOrgID adds the orgId to the add org user params
func (o *AddOrgUserParams) SetOrgID(orgID int64) {
	o.OrgID = orgID
}

// WriteToRequest writes these params to a swagger request
func (o *AddOrgUserParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param org_id
	if err := r.SetPathParam("org_id", swag.FormatInt64(o.OrgID)); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
