// Code generated by go-swagger; DO NOT EDIT.

package provisioning

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// NewPutTemplateParams creates a new PutTemplateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewPutTemplateParams() *PutTemplateParams {
	return &PutTemplateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewPutTemplateParamsWithTimeout creates a new PutTemplateParams object
// with the ability to set a timeout on a request.
func NewPutTemplateParamsWithTimeout(timeout time.Duration) *PutTemplateParams {
	return &PutTemplateParams{
		timeout: timeout,
	}
}

// NewPutTemplateParamsWithContext creates a new PutTemplateParams object
// with the ability to set a context for a request.
func NewPutTemplateParamsWithContext(ctx context.Context) *PutTemplateParams {
	return &PutTemplateParams{
		Context: ctx,
	}
}

// NewPutTemplateParamsWithHTTPClient creates a new PutTemplateParams object
// with the ability to set a custom HTTPClient for a request.
func NewPutTemplateParamsWithHTTPClient(client *http.Client) *PutTemplateParams {
	return &PutTemplateParams{
		HTTPClient: client,
	}
}

/*
PutTemplateParams contains all the parameters to send to the API endpoint

	for the put template operation.

	Typically these are written to a http.Request.
*/
type PutTemplateParams struct {

	// Body.
	Body *models.NotificationTemplateContent

	// XDisableProvenance.
	XDisableProvenance *string

	/* Name.

	   Template Name
	*/
	Name string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the put template params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PutTemplateParams) WithDefaults() *PutTemplateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the put template params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PutTemplateParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the put template params
func (o *PutTemplateParams) WithTimeout(timeout time.Duration) *PutTemplateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the put template params
func (o *PutTemplateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the put template params
func (o *PutTemplateParams) WithContext(ctx context.Context) *PutTemplateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the put template params
func (o *PutTemplateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the put template params
func (o *PutTemplateParams) WithHTTPClient(client *http.Client) *PutTemplateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the put template params
func (o *PutTemplateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the put template params
func (o *PutTemplateParams) WithBody(body *models.NotificationTemplateContent) *PutTemplateParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the put template params
func (o *PutTemplateParams) SetBody(body *models.NotificationTemplateContent) {
	o.Body = body
}

// WithXDisableProvenance adds the xDisableProvenance to the put template params
func (o *PutTemplateParams) WithXDisableProvenance(xDisableProvenance *string) *PutTemplateParams {
	o.SetXDisableProvenance(xDisableProvenance)
	return o
}

// SetXDisableProvenance adds the xDisableProvenance to the put template params
func (o *PutTemplateParams) SetXDisableProvenance(xDisableProvenance *string) {
	o.XDisableProvenance = xDisableProvenance
}

// WithName adds the name to the put template params
func (o *PutTemplateParams) WithName(name string) *PutTemplateParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the put template params
func (o *PutTemplateParams) SetName(name string) {
	o.Name = name
}

// WriteToRequest writes these params to a swagger request
func (o *PutTemplateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	if o.XDisableProvenance != nil {

		// header param X-Disable-Provenance
		if err := r.SetHeaderParam("X-Disable-Provenance", *o.XDisableProvenance); err != nil {
			return err
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
