// Code generated by go-swagger; DO NOT EDIT.

package network_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-network/preview/2020-09-07/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// ListPeeringsReader is a Reader for the ListPeerings structure.
type ListPeeringsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ListPeeringsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewListPeeringsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewListPeeringsDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewListPeeringsOK creates a ListPeeringsOK with default headers values
func NewListPeeringsOK() *ListPeeringsOK {
	return &ListPeeringsOK{}
}

/*
ListPeeringsOK describes a response with status code 200, with default header values.

A successful response.
*/
type ListPeeringsOK struct {
	Payload *models.HashicorpCloudNetwork20200907ListPeeringsResponse
}

// IsSuccess returns true when this list peerings o k response has a 2xx status code
func (o *ListPeeringsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this list peerings o k response has a 3xx status code
func (o *ListPeeringsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list peerings o k response has a 4xx status code
func (o *ListPeeringsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this list peerings o k response has a 5xx status code
func (o *ListPeeringsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this list peerings o k response a status code equal to that given
func (o *ListPeeringsOK) IsCode(code int) bool {
	return code == 200
}

func (o *ListPeeringsOK) Error() string {
	return fmt.Sprintf("[GET /network/2020-09-07/organizations/{location.organization_id}/projects/{location.project_id}/networks/{hvn_id}/peerings][%d] listPeeringsOK  %+v", 200, o.Payload)
}

func (o *ListPeeringsOK) String() string {
	return fmt.Sprintf("[GET /network/2020-09-07/organizations/{location.organization_id}/projects/{location.project_id}/networks/{hvn_id}/peerings][%d] listPeeringsOK  %+v", 200, o.Payload)
}

func (o *ListPeeringsOK) GetPayload() *models.HashicorpCloudNetwork20200907ListPeeringsResponse {
	return o.Payload
}

func (o *ListPeeringsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudNetwork20200907ListPeeringsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListPeeringsDefault creates a ListPeeringsDefault with default headers values
func NewListPeeringsDefault(code int) *ListPeeringsDefault {
	return &ListPeeringsDefault{
		_statusCode: code,
	}
}

/*
ListPeeringsDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ListPeeringsDefault struct {
	_statusCode int

	Payload *cloud.GrpcGatewayRuntimeError
}

// Code gets the status code for the list peerings default response
func (o *ListPeeringsDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this list peerings default response has a 2xx status code
func (o *ListPeeringsDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this list peerings default response has a 3xx status code
func (o *ListPeeringsDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this list peerings default response has a 4xx status code
func (o *ListPeeringsDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this list peerings default response has a 5xx status code
func (o *ListPeeringsDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this list peerings default response a status code equal to that given
func (o *ListPeeringsDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *ListPeeringsDefault) Error() string {
	return fmt.Sprintf("[GET /network/2020-09-07/organizations/{location.organization_id}/projects/{location.project_id}/networks/{hvn_id}/peerings][%d] ListPeerings default  %+v", o._statusCode, o.Payload)
}

func (o *ListPeeringsDefault) String() string {
	return fmt.Sprintf("[GET /network/2020-09-07/organizations/{location.organization_id}/projects/{location.project_id}/networks/{hvn_id}/peerings][%d] ListPeerings default  %+v", o._statusCode, o.Payload)
}

func (o *ListPeeringsDefault) GetPayload() *cloud.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *ListPeeringsDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
