// Code generated by go-swagger; DO NOT EDIT.

package packer_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewPackerServiceGetIterationParams creates a new PackerServiceGetIterationParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewPackerServiceGetIterationParams() *PackerServiceGetIterationParams {
	return &PackerServiceGetIterationParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewPackerServiceGetIterationParamsWithTimeout creates a new PackerServiceGetIterationParams object
// with the ability to set a timeout on a request.
func NewPackerServiceGetIterationParamsWithTimeout(timeout time.Duration) *PackerServiceGetIterationParams {
	return &PackerServiceGetIterationParams{
		timeout: timeout,
	}
}

// NewPackerServiceGetIterationParamsWithContext creates a new PackerServiceGetIterationParams object
// with the ability to set a context for a request.
func NewPackerServiceGetIterationParamsWithContext(ctx context.Context) *PackerServiceGetIterationParams {
	return &PackerServiceGetIterationParams{
		Context: ctx,
	}
}

// NewPackerServiceGetIterationParamsWithHTTPClient creates a new PackerServiceGetIterationParams object
// with the ability to set a custom HTTPClient for a request.
func NewPackerServiceGetIterationParamsWithHTTPClient(client *http.Client) *PackerServiceGetIterationParams {
	return &PackerServiceGetIterationParams{
		HTTPClient: client,
	}
}

/*
PackerServiceGetIterationParams contains all the parameters to send to the API endpoint

	for the packer service get iteration operation.

	Typically these are written to a http.Request.
*/
type PackerServiceGetIterationParams struct {

	/* BucketSlug.

	   Human-readable name for the bucket.
	*/
	BucketSlug string

	/* Fingerprint.

	     Fingerprint of the iteration. The fingerprint is set by Packer when you
	call `packer build`. It will most often correspond to a git commit sha,
	but can be manually overridden by setting the environment variable
	`HCP_PACKER_BUILD_FINGERPRINT`.
	*/
	Fingerprint *string

	/* IncrementalVersion.

	   The human-readable version number assigned to this iteration.

	   Format: int32
	*/
	IncrementalVersion *int32

	/* IterationID.

	   ULID of the iteration.
	*/
	IterationID *string

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	/* LocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure").
	*/
	LocationRegionProvider *string

	/* LocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1").
	*/
	LocationRegionRegion *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the packer service get iteration params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PackerServiceGetIterationParams) WithDefaults() *PackerServiceGetIterationParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the packer service get iteration params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PackerServiceGetIterationParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the packer service get iteration params
func (o *PackerServiceGetIterationParams) WithTimeout(timeout time.Duration) *PackerServiceGetIterationParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the packer service get iteration params
func (o *PackerServiceGetIterationParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the packer service get iteration params
func (o *PackerServiceGetIterationParams) WithContext(ctx context.Context) *PackerServiceGetIterationParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the packer service get iteration params
func (o *PackerServiceGetIterationParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the packer service get iteration params
func (o *PackerServiceGetIterationParams) WithHTTPClient(client *http.Client) *PackerServiceGetIterationParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the packer service get iteration params
func (o *PackerServiceGetIterationParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBucketSlug adds the bucketSlug to the packer service get iteration params
func (o *PackerServiceGetIterationParams) WithBucketSlug(bucketSlug string) *PackerServiceGetIterationParams {
	o.SetBucketSlug(bucketSlug)
	return o
}

// SetBucketSlug adds the bucketSlug to the packer service get iteration params
func (o *PackerServiceGetIterationParams) SetBucketSlug(bucketSlug string) {
	o.BucketSlug = bucketSlug
}

// WithFingerprint adds the fingerprint to the packer service get iteration params
func (o *PackerServiceGetIterationParams) WithFingerprint(fingerprint *string) *PackerServiceGetIterationParams {
	o.SetFingerprint(fingerprint)
	return o
}

// SetFingerprint adds the fingerprint to the packer service get iteration params
func (o *PackerServiceGetIterationParams) SetFingerprint(fingerprint *string) {
	o.Fingerprint = fingerprint
}

// WithIncrementalVersion adds the incrementalVersion to the packer service get iteration params
func (o *PackerServiceGetIterationParams) WithIncrementalVersion(incrementalVersion *int32) *PackerServiceGetIterationParams {
	o.SetIncrementalVersion(incrementalVersion)
	return o
}

// SetIncrementalVersion adds the incrementalVersion to the packer service get iteration params
func (o *PackerServiceGetIterationParams) SetIncrementalVersion(incrementalVersion *int32) {
	o.IncrementalVersion = incrementalVersion
}

// WithIterationID adds the iterationID to the packer service get iteration params
func (o *PackerServiceGetIterationParams) WithIterationID(iterationID *string) *PackerServiceGetIterationParams {
	o.SetIterationID(iterationID)
	return o
}

// SetIterationID adds the iterationId to the packer service get iteration params
func (o *PackerServiceGetIterationParams) SetIterationID(iterationID *string) {
	o.IterationID = iterationID
}

// WithLocationOrganizationID adds the locationOrganizationID to the packer service get iteration params
func (o *PackerServiceGetIterationParams) WithLocationOrganizationID(locationOrganizationID string) *PackerServiceGetIterationParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the packer service get iteration params
func (o *PackerServiceGetIterationParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the packer service get iteration params
func (o *PackerServiceGetIterationParams) WithLocationProjectID(locationProjectID string) *PackerServiceGetIterationParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the packer service get iteration params
func (o *PackerServiceGetIterationParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WithLocationRegionProvider adds the locationRegionProvider to the packer service get iteration params
func (o *PackerServiceGetIterationParams) WithLocationRegionProvider(locationRegionProvider *string) *PackerServiceGetIterationParams {
	o.SetLocationRegionProvider(locationRegionProvider)
	return o
}

// SetLocationRegionProvider adds the locationRegionProvider to the packer service get iteration params
func (o *PackerServiceGetIterationParams) SetLocationRegionProvider(locationRegionProvider *string) {
	o.LocationRegionProvider = locationRegionProvider
}

// WithLocationRegionRegion adds the locationRegionRegion to the packer service get iteration params
func (o *PackerServiceGetIterationParams) WithLocationRegionRegion(locationRegionRegion *string) *PackerServiceGetIterationParams {
	o.SetLocationRegionRegion(locationRegionRegion)
	return o
}

// SetLocationRegionRegion adds the locationRegionRegion to the packer service get iteration params
func (o *PackerServiceGetIterationParams) SetLocationRegionRegion(locationRegionRegion *string) {
	o.LocationRegionRegion = locationRegionRegion
}

// WriteToRequest writes these params to a swagger request
func (o *PackerServiceGetIterationParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param bucket_slug
	if err := r.SetPathParam("bucket_slug", o.BucketSlug); err != nil {
		return err
	}

	if o.Fingerprint != nil {

		// query param fingerprint
		var qrFingerprint string

		if o.Fingerprint != nil {
			qrFingerprint = *o.Fingerprint
		}
		qFingerprint := qrFingerprint
		if qFingerprint != "" {

			if err := r.SetQueryParam("fingerprint", qFingerprint); err != nil {
				return err
			}
		}
	}

	if o.IncrementalVersion != nil {

		// query param incremental_version
		var qrIncrementalVersion int32

		if o.IncrementalVersion != nil {
			qrIncrementalVersion = *o.IncrementalVersion
		}
		qIncrementalVersion := swag.FormatInt32(qrIncrementalVersion)
		if qIncrementalVersion != "" {

			if err := r.SetQueryParam("incremental_version", qIncrementalVersion); err != nil {
				return err
			}
		}
	}

	if o.IterationID != nil {

		// query param iteration_id
		var qrIterationID string

		if o.IterationID != nil {
			qrIterationID = *o.IterationID
		}
		qIterationID := qrIterationID
		if qIterationID != "" {

			if err := r.SetQueryParam("iteration_id", qIterationID); err != nil {
				return err
			}
		}
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if o.LocationRegionProvider != nil {

		// query param location.region.provider
		var qrLocationRegionProvider string

		if o.LocationRegionProvider != nil {
			qrLocationRegionProvider = *o.LocationRegionProvider
		}
		qLocationRegionProvider := qrLocationRegionProvider
		if qLocationRegionProvider != "" {

			if err := r.SetQueryParam("location.region.provider", qLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.LocationRegionRegion != nil {

		// query param location.region.region
		var qrLocationRegionRegion string

		if o.LocationRegionRegion != nil {
			qrLocationRegionRegion = *o.LocationRegionRegion
		}
		qLocationRegionRegion := qrLocationRegionRegion
		if qLocationRegionRegion != "" {

			if err := r.SetQueryParam("location.region.region", qLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
