// Code generated by go-swagger; DO NOT EDIT.

package packer_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewPackerServiceGetRegistryTFCRunTaskAPIParams creates a new PackerServiceGetRegistryTFCRunTaskAPIParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewPackerServiceGetRegistryTFCRunTaskAPIParams() *PackerServiceGetRegistryTFCRunTaskAPIParams {
	return &PackerServiceGetRegistryTFCRunTaskAPIParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewPackerServiceGetRegistryTFCRunTaskAPIParamsWithTimeout creates a new PackerServiceGetRegistryTFCRunTaskAPIParams object
// with the ability to set a timeout on a request.
func NewPackerServiceGetRegistryTFCRunTaskAPIParamsWithTimeout(timeout time.Duration) *PackerServiceGetRegistryTFCRunTaskAPIParams {
	return &PackerServiceGetRegistryTFCRunTaskAPIParams{
		timeout: timeout,
	}
}

// NewPackerServiceGetRegistryTFCRunTaskAPIParamsWithContext creates a new PackerServiceGetRegistryTFCRunTaskAPIParams object
// with the ability to set a context for a request.
func NewPackerServiceGetRegistryTFCRunTaskAPIParamsWithContext(ctx context.Context) *PackerServiceGetRegistryTFCRunTaskAPIParams {
	return &PackerServiceGetRegistryTFCRunTaskAPIParams{
		Context: ctx,
	}
}

// NewPackerServiceGetRegistryTFCRunTaskAPIParamsWithHTTPClient creates a new PackerServiceGetRegistryTFCRunTaskAPIParams object
// with the ability to set a custom HTTPClient for a request.
func NewPackerServiceGetRegistryTFCRunTaskAPIParamsWithHTTPClient(client *http.Client) *PackerServiceGetRegistryTFCRunTaskAPIParams {
	return &PackerServiceGetRegistryTFCRunTaskAPIParams{
		HTTPClient: client,
	}
}

/*
PackerServiceGetRegistryTFCRunTaskAPIParams contains all the parameters to send to the API endpoint

	for the packer service get registry t f c run task API operation.

	Typically these are written to a http.Request.
*/
type PackerServiceGetRegistryTFCRunTaskAPIParams struct {

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	/* LocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure").
	*/
	LocationRegionProvider *string

	/* LocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1").
	*/
	LocationRegionRegion *string

	/* TaskType.

	     The HCP Packer Terraform Cloud run task type.
	Currently, the only existing type is `validation`.
	*/
	TaskType string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the packer service get registry t f c run task API params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PackerServiceGetRegistryTFCRunTaskAPIParams) WithDefaults() *PackerServiceGetRegistryTFCRunTaskAPIParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the packer service get registry t f c run task API params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PackerServiceGetRegistryTFCRunTaskAPIParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the packer service get registry t f c run task API params
func (o *PackerServiceGetRegistryTFCRunTaskAPIParams) WithTimeout(timeout time.Duration) *PackerServiceGetRegistryTFCRunTaskAPIParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the packer service get registry t f c run task API params
func (o *PackerServiceGetRegistryTFCRunTaskAPIParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the packer service get registry t f c run task API params
func (o *PackerServiceGetRegistryTFCRunTaskAPIParams) WithContext(ctx context.Context) *PackerServiceGetRegistryTFCRunTaskAPIParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the packer service get registry t f c run task API params
func (o *PackerServiceGetRegistryTFCRunTaskAPIParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the packer service get registry t f c run task API params
func (o *PackerServiceGetRegistryTFCRunTaskAPIParams) WithHTTPClient(client *http.Client) *PackerServiceGetRegistryTFCRunTaskAPIParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the packer service get registry t f c run task API params
func (o *PackerServiceGetRegistryTFCRunTaskAPIParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithLocationOrganizationID adds the locationOrganizationID to the packer service get registry t f c run task API params
func (o *PackerServiceGetRegistryTFCRunTaskAPIParams) WithLocationOrganizationID(locationOrganizationID string) *PackerServiceGetRegistryTFCRunTaskAPIParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the packer service get registry t f c run task API params
func (o *PackerServiceGetRegistryTFCRunTaskAPIParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the packer service get registry t f c run task API params
func (o *PackerServiceGetRegistryTFCRunTaskAPIParams) WithLocationProjectID(locationProjectID string) *PackerServiceGetRegistryTFCRunTaskAPIParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the packer service get registry t f c run task API params
func (o *PackerServiceGetRegistryTFCRunTaskAPIParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WithLocationRegionProvider adds the locationRegionProvider to the packer service get registry t f c run task API params
func (o *PackerServiceGetRegistryTFCRunTaskAPIParams) WithLocationRegionProvider(locationRegionProvider *string) *PackerServiceGetRegistryTFCRunTaskAPIParams {
	o.SetLocationRegionProvider(locationRegionProvider)
	return o
}

// SetLocationRegionProvider adds the locationRegionProvider to the packer service get registry t f c run task API params
func (o *PackerServiceGetRegistryTFCRunTaskAPIParams) SetLocationRegionProvider(locationRegionProvider *string) {
	o.LocationRegionProvider = locationRegionProvider
}

// WithLocationRegionRegion adds the locationRegionRegion to the packer service get registry t f c run task API params
func (o *PackerServiceGetRegistryTFCRunTaskAPIParams) WithLocationRegionRegion(locationRegionRegion *string) *PackerServiceGetRegistryTFCRunTaskAPIParams {
	o.SetLocationRegionRegion(locationRegionRegion)
	return o
}

// SetLocationRegionRegion adds the locationRegionRegion to the packer service get registry t f c run task API params
func (o *PackerServiceGetRegistryTFCRunTaskAPIParams) SetLocationRegionRegion(locationRegionRegion *string) {
	o.LocationRegionRegion = locationRegionRegion
}

// WithTaskType adds the taskType to the packer service get registry t f c run task API params
func (o *PackerServiceGetRegistryTFCRunTaskAPIParams) WithTaskType(taskType string) *PackerServiceGetRegistryTFCRunTaskAPIParams {
	o.SetTaskType(taskType)
	return o
}

// SetTaskType adds the taskType to the packer service get registry t f c run task API params
func (o *PackerServiceGetRegistryTFCRunTaskAPIParams) SetTaskType(taskType string) {
	o.TaskType = taskType
}

// WriteToRequest writes these params to a swagger request
func (o *PackerServiceGetRegistryTFCRunTaskAPIParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if o.LocationRegionProvider != nil {

		// query param location.region.provider
		var qrLocationRegionProvider string

		if o.LocationRegionProvider != nil {
			qrLocationRegionProvider = *o.LocationRegionProvider
		}
		qLocationRegionProvider := qrLocationRegionProvider
		if qLocationRegionProvider != "" {

			if err := r.SetQueryParam("location.region.provider", qLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.LocationRegionRegion != nil {

		// query param location.region.region
		var qrLocationRegionRegion string

		if o.LocationRegionRegion != nil {
			qrLocationRegionRegion = *o.LocationRegionRegion
		}
		qLocationRegionRegion := qrLocationRegionRegion
		if qLocationRegionRegion != "" {

			if err := r.SetQueryParam("location.region.region", qLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	// path param task_type
	if err := r.SetPathParam("task_type", o.TaskType); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
