// Code generated by go-swagger; DO NOT EDIT.

package packer_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-packer-service/preview/2022-04-11/models"
)

// NewPackerServiceUpdateBucketParams creates a new PackerServiceUpdateBucketParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewPackerServiceUpdateBucketParams() *PackerServiceUpdateBucketParams {
	return &PackerServiceUpdateBucketParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewPackerServiceUpdateBucketParamsWithTimeout creates a new PackerServiceUpdateBucketParams object
// with the ability to set a timeout on a request.
func NewPackerServiceUpdateBucketParamsWithTimeout(timeout time.Duration) *PackerServiceUpdateBucketParams {
	return &PackerServiceUpdateBucketParams{
		timeout: timeout,
	}
}

// NewPackerServiceUpdateBucketParamsWithContext creates a new PackerServiceUpdateBucketParams object
// with the ability to set a context for a request.
func NewPackerServiceUpdateBucketParamsWithContext(ctx context.Context) *PackerServiceUpdateBucketParams {
	return &PackerServiceUpdateBucketParams{
		Context: ctx,
	}
}

// NewPackerServiceUpdateBucketParamsWithHTTPClient creates a new PackerServiceUpdateBucketParams object
// with the ability to set a custom HTTPClient for a request.
func NewPackerServiceUpdateBucketParamsWithHTTPClient(client *http.Client) *PackerServiceUpdateBucketParams {
	return &PackerServiceUpdateBucketParams{
		HTTPClient: client,
	}
}

/*
PackerServiceUpdateBucketParams contains all the parameters to send to the API endpoint

	for the packer service update bucket operation.

	Typically these are written to a http.Request.
*/
type PackerServiceUpdateBucketParams struct {

	// Body.
	Body *models.HashicorpCloudPacker20220411UpdateBucketRequest

	/* BucketSlug.

	   Human-readable name for the bucket.
	*/
	BucketSlug string

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the packer service update bucket params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PackerServiceUpdateBucketParams) WithDefaults() *PackerServiceUpdateBucketParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the packer service update bucket params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PackerServiceUpdateBucketParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the packer service update bucket params
func (o *PackerServiceUpdateBucketParams) WithTimeout(timeout time.Duration) *PackerServiceUpdateBucketParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the packer service update bucket params
func (o *PackerServiceUpdateBucketParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the packer service update bucket params
func (o *PackerServiceUpdateBucketParams) WithContext(ctx context.Context) *PackerServiceUpdateBucketParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the packer service update bucket params
func (o *PackerServiceUpdateBucketParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the packer service update bucket params
func (o *PackerServiceUpdateBucketParams) WithHTTPClient(client *http.Client) *PackerServiceUpdateBucketParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the packer service update bucket params
func (o *PackerServiceUpdateBucketParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the packer service update bucket params
func (o *PackerServiceUpdateBucketParams) WithBody(body *models.HashicorpCloudPacker20220411UpdateBucketRequest) *PackerServiceUpdateBucketParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the packer service update bucket params
func (o *PackerServiceUpdateBucketParams) SetBody(body *models.HashicorpCloudPacker20220411UpdateBucketRequest) {
	o.Body = body
}

// WithBucketSlug adds the bucketSlug to the packer service update bucket params
func (o *PackerServiceUpdateBucketParams) WithBucketSlug(bucketSlug string) *PackerServiceUpdateBucketParams {
	o.SetBucketSlug(bucketSlug)
	return o
}

// SetBucketSlug adds the bucketSlug to the packer service update bucket params
func (o *PackerServiceUpdateBucketParams) SetBucketSlug(bucketSlug string) {
	o.BucketSlug = bucketSlug
}

// WithLocationOrganizationID adds the locationOrganizationID to the packer service update bucket params
func (o *PackerServiceUpdateBucketParams) WithLocationOrganizationID(locationOrganizationID string) *PackerServiceUpdateBucketParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the packer service update bucket params
func (o *PackerServiceUpdateBucketParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the packer service update bucket params
func (o *PackerServiceUpdateBucketParams) WithLocationProjectID(locationProjectID string) *PackerServiceUpdateBucketParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the packer service update bucket params
func (o *PackerServiceUpdateBucketParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WriteToRequest writes these params to a swagger request
func (o *PackerServiceUpdateBucketParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param bucket_slug
	if err := r.SetPathParam("bucket_slug", o.BucketSlug); err != nil {
		return err
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
