// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// HashicorpCloudPackerChannelAssignment hashicorp cloud packer channel assignment
//
// swagger:model hashicorp.cloud.packer.ChannelAssignment
type HashicorpCloudPackerChannelAssignment struct {

	// The user who assigned this iteration.
	AuthorID string `json:"author_id,omitempty"`

	// The assigned iteration.
	Iteration *HashicorpCloudPackerChannelAssignmentIteration `json:"iteration,omitempty"`

	// When the promotion happened.
	// Format: date-time
	PromotedAt strfmt.DateTime `json:"promoted_at,omitempty"`
}

// Validate validates this hashicorp cloud packer channel assignment
func (m *HashicorpCloudPackerChannelAssignment) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIteration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePromotedAt(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudPackerChannelAssignment) validateIteration(formats strfmt.Registry) error {
	if swag.IsZero(m.Iteration) { // not required
		return nil
	}

	if m.Iteration != nil {
		if err := m.Iteration.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("iteration")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("iteration")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudPackerChannelAssignment) validatePromotedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.PromotedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("promoted_at", "body", "date-time", m.PromotedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this hashicorp cloud packer channel assignment based on the context it is used
func (m *HashicorpCloudPackerChannelAssignment) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIteration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudPackerChannelAssignment) contextValidateIteration(ctx context.Context, formats strfmt.Registry) error {

	if m.Iteration != nil {
		if err := m.Iteration.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("iteration")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("iteration")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudPackerChannelAssignment) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudPackerChannelAssignment) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudPackerChannelAssignment
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
