// Code generated by command: avogen -output zctors_test.go ctorstest. DO NOT EDIT.

//go:build !integration

package x86

import (
	"math"
	"testing"

	"github.com/mmcloughlin/avo/operand"
	"github.com/mmcloughlin/avo/reg"
)

var (
	op1     operand.Op = operand.Imm(1)
	op3     operand.Op = operand.Imm(3)
	opimm2u operand.Op = operand.Imm(3)
	opimm8  operand.Op = operand.Imm(math.MaxInt8)
	opimm16 operand.Op = operand.Imm(math.MaxInt16)
	opimm32 operand.Op = operand.Imm(math.MaxInt32)
	opimm64 operand.Op = operand.Imm(math.MaxInt64)
	opal    operand.Op = reg.AL
	opcl    operand.Op = reg.CL
	opax    operand.Op = reg.AX
	opeax   operand.Op = reg.EAX
	oprax   operand.Op = reg.RAX
	opr8    operand.Op = reg.CH
	opr16   operand.Op = reg.R9W
	opr32   operand.Op = reg.R10L
	opr64   operand.Op = reg.R11
	opxmm0  operand.Op = reg.X0
	opxmm   operand.Op = reg.X7
	opymm   operand.Op = reg.Y15
	opzmm   operand.Op = reg.Z31
	opk     operand.Op = reg.K7
	opm     operand.Op = operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}
	opm8    operand.Op = operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}
	opm16   operand.Op = operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}
	opm32   operand.Op = operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}
	opm64   operand.Op = operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}
	opm128  operand.Op = operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}
	opm256  operand.Op = operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}
	opm512  operand.Op = operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}
	opvm32x operand.Op = operand.Mem{Base: reg.R13, Index: reg.X4, Scale: 1}
	opvm64x operand.Op = operand.Mem{Base: reg.R13, Index: reg.X8, Scale: 1}
	opvm32y operand.Op = operand.Mem{Base: reg.R13, Index: reg.Y4, Scale: 1}
	opvm64y operand.Op = operand.Mem{Base: reg.R13, Index: reg.Y8, Scale: 1}
	opvm32z operand.Op = operand.Mem{Base: reg.R13, Index: reg.Z4, Scale: 1}
	opvm64z operand.Op = operand.Mem{Base: reg.R13, Index: reg.Z8, Scale: 1}
	oprel8  operand.Op = operand.Rel(math.MaxInt8)
	oprel32 operand.Op = operand.LabelRef("lbl")
)

func TestADCBValidFormsNoError(t *testing.T) {
	if _, err := ADCB(opimm8, opal); err != nil {
		t.Fatal(err)
	}
	if _, err := ADCB(opimm8, opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := ADCB(opimm8, opr8); err != nil {
		t.Fatal(err)
	}
	if _, err := ADCB(opm8, opr8); err != nil {
		t.Fatal(err)
	}
	if _, err := ADCB(opr8, opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := ADCB(opr8, opr8); err != nil {
		t.Fatal(err)
	}
}

func TestADCLValidFormsNoError(t *testing.T) {
	if _, err := ADCL(opimm32, opeax); err != nil {
		t.Fatal(err)
	}
	if _, err := ADCL(opimm32, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := ADCL(opimm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := ADCL(opimm8, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := ADCL(opimm8, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := ADCL(opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := ADCL(opr32, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := ADCL(opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestADCQValidFormsNoError(t *testing.T) {
	if _, err := ADCQ(opimm32, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := ADCQ(opimm32, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := ADCQ(opimm32, oprax); err != nil {
		t.Fatal(err)
	}
	if _, err := ADCQ(opimm8, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := ADCQ(opimm8, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := ADCQ(opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := ADCQ(opr64, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := ADCQ(opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestADCWValidFormsNoError(t *testing.T) {
	if _, err := ADCW(opimm16, opax); err != nil {
		t.Fatal(err)
	}
	if _, err := ADCW(opimm16, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := ADCW(opimm16, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := ADCW(opimm8, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := ADCW(opimm8, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := ADCW(opm16, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := ADCW(opr16, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := ADCW(opr16, opr16); err != nil {
		t.Fatal(err)
	}
}

func TestADCXLValidFormsNoError(t *testing.T) {
	if _, err := ADCXL(opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := ADCXL(opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestADCXQValidFormsNoError(t *testing.T) {
	if _, err := ADCXQ(opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := ADCXQ(opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestADDBValidFormsNoError(t *testing.T) {
	if _, err := ADDB(opimm8, opal); err != nil {
		t.Fatal(err)
	}
	if _, err := ADDB(opimm8, opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := ADDB(opimm8, opr8); err != nil {
		t.Fatal(err)
	}
	if _, err := ADDB(opm8, opr8); err != nil {
		t.Fatal(err)
	}
	if _, err := ADDB(opr8, opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := ADDB(opr8, opr8); err != nil {
		t.Fatal(err)
	}
}

func TestADDLValidFormsNoError(t *testing.T) {
	if _, err := ADDL(opimm32, opeax); err != nil {
		t.Fatal(err)
	}
	if _, err := ADDL(opimm32, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := ADDL(opimm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := ADDL(opimm8, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := ADDL(opimm8, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := ADDL(opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := ADDL(opr32, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := ADDL(opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestADDPDValidFormsNoError(t *testing.T) {
	if _, err := ADDPD(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := ADDPD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestADDPSValidFormsNoError(t *testing.T) {
	if _, err := ADDPS(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := ADDPS(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestADDQValidFormsNoError(t *testing.T) {
	if _, err := ADDQ(opimm32, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := ADDQ(opimm32, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := ADDQ(opimm32, oprax); err != nil {
		t.Fatal(err)
	}
	if _, err := ADDQ(opimm8, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := ADDQ(opimm8, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := ADDQ(opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := ADDQ(opr64, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := ADDQ(opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestADDSDValidFormsNoError(t *testing.T) {
	if _, err := ADDSD(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := ADDSD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestADDSSValidFormsNoError(t *testing.T) {
	if _, err := ADDSS(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := ADDSS(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestADDSUBPDValidFormsNoError(t *testing.T) {
	if _, err := ADDSUBPD(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := ADDSUBPD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestADDSUBPSValidFormsNoError(t *testing.T) {
	if _, err := ADDSUBPS(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := ADDSUBPS(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestADDWValidFormsNoError(t *testing.T) {
	if _, err := ADDW(opimm16, opax); err != nil {
		t.Fatal(err)
	}
	if _, err := ADDW(opimm16, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := ADDW(opimm16, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := ADDW(opimm8, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := ADDW(opimm8, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := ADDW(opm16, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := ADDW(opr16, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := ADDW(opr16, opr16); err != nil {
		t.Fatal(err)
	}
}

func TestADOXLValidFormsNoError(t *testing.T) {
	if _, err := ADOXL(opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := ADOXL(opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestADOXQValidFormsNoError(t *testing.T) {
	if _, err := ADOXQ(opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := ADOXQ(opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestAESDECValidFormsNoError(t *testing.T) {
	if _, err := AESDEC(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := AESDEC(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestAESDECLASTValidFormsNoError(t *testing.T) {
	if _, err := AESDECLAST(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := AESDECLAST(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestAESENCValidFormsNoError(t *testing.T) {
	if _, err := AESENC(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := AESENC(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestAESENCLASTValidFormsNoError(t *testing.T) {
	if _, err := AESENCLAST(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := AESENCLAST(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestAESIMCValidFormsNoError(t *testing.T) {
	if _, err := AESIMC(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := AESIMC(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestAESKEYGENASSISTValidFormsNoError(t *testing.T) {
	if _, err := AESKEYGENASSIST(opimm8, opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := AESKEYGENASSIST(opimm8, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestANDBValidFormsNoError(t *testing.T) {
	if _, err := ANDB(opimm8, opal); err != nil {
		t.Fatal(err)
	}
	if _, err := ANDB(opimm8, opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := ANDB(opimm8, opr8); err != nil {
		t.Fatal(err)
	}
	if _, err := ANDB(opm8, opr8); err != nil {
		t.Fatal(err)
	}
	if _, err := ANDB(opr8, opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := ANDB(opr8, opr8); err != nil {
		t.Fatal(err)
	}
}

func TestANDLValidFormsNoError(t *testing.T) {
	if _, err := ANDL(opimm32, opeax); err != nil {
		t.Fatal(err)
	}
	if _, err := ANDL(opimm32, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := ANDL(opimm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := ANDL(opimm8, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := ANDL(opimm8, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := ANDL(opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := ANDL(opr32, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := ANDL(opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestANDNLValidFormsNoError(t *testing.T) {
	if _, err := ANDNL(opm32, opr32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := ANDNL(opr32, opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestANDNPDValidFormsNoError(t *testing.T) {
	if _, err := ANDNPD(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := ANDNPD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestANDNPSValidFormsNoError(t *testing.T) {
	if _, err := ANDNPS(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := ANDNPS(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestANDNQValidFormsNoError(t *testing.T) {
	if _, err := ANDNQ(opm64, opr64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := ANDNQ(opr64, opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestANDPDValidFormsNoError(t *testing.T) {
	if _, err := ANDPD(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := ANDPD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestANDPSValidFormsNoError(t *testing.T) {
	if _, err := ANDPS(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := ANDPS(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestANDQValidFormsNoError(t *testing.T) {
	if _, err := ANDQ(opimm32, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := ANDQ(opimm32, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := ANDQ(opimm32, oprax); err != nil {
		t.Fatal(err)
	}
	if _, err := ANDQ(opimm8, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := ANDQ(opimm8, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := ANDQ(opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := ANDQ(opr64, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := ANDQ(opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestANDWValidFormsNoError(t *testing.T) {
	if _, err := ANDW(opimm16, opax); err != nil {
		t.Fatal(err)
	}
	if _, err := ANDW(opimm16, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := ANDW(opimm16, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := ANDW(opimm8, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := ANDW(opimm8, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := ANDW(opm16, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := ANDW(opr16, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := ANDW(opr16, opr16); err != nil {
		t.Fatal(err)
	}
}

func TestBEXTRLValidFormsNoError(t *testing.T) {
	if _, err := BEXTRL(opr32, opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := BEXTRL(opr32, opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestBEXTRQValidFormsNoError(t *testing.T) {
	if _, err := BEXTRQ(opr64, opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := BEXTRQ(opr64, opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestBLENDPDValidFormsNoError(t *testing.T) {
	if _, err := BLENDPD(opimm8, opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := BLENDPD(opimm8, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestBLENDPSValidFormsNoError(t *testing.T) {
	if _, err := BLENDPS(opimm8, opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := BLENDPS(opimm8, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestBLENDVPDValidFormsNoError(t *testing.T) {
	if _, err := BLENDVPD(opxmm0, opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := BLENDVPD(opxmm0, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestBLENDVPSValidFormsNoError(t *testing.T) {
	if _, err := BLENDVPS(opxmm0, opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := BLENDVPS(opxmm0, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestBLSILValidFormsNoError(t *testing.T) {
	if _, err := BLSIL(opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := BLSIL(opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestBLSIQValidFormsNoError(t *testing.T) {
	if _, err := BLSIQ(opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := BLSIQ(opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestBLSMSKLValidFormsNoError(t *testing.T) {
	if _, err := BLSMSKL(opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := BLSMSKL(opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestBLSMSKQValidFormsNoError(t *testing.T) {
	if _, err := BLSMSKQ(opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := BLSMSKQ(opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestBLSRLValidFormsNoError(t *testing.T) {
	if _, err := BLSRL(opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := BLSRL(opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestBLSRQValidFormsNoError(t *testing.T) {
	if _, err := BLSRQ(opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := BLSRQ(opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestBSFLValidFormsNoError(t *testing.T) {
	if _, err := BSFL(opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := BSFL(opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestBSFQValidFormsNoError(t *testing.T) {
	if _, err := BSFQ(opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := BSFQ(opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestBSFWValidFormsNoError(t *testing.T) {
	if _, err := BSFW(opm16, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := BSFW(opr16, opr16); err != nil {
		t.Fatal(err)
	}
}

func TestBSRLValidFormsNoError(t *testing.T) {
	if _, err := BSRL(opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := BSRL(opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestBSRQValidFormsNoError(t *testing.T) {
	if _, err := BSRQ(opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := BSRQ(opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestBSRWValidFormsNoError(t *testing.T) {
	if _, err := BSRW(opm16, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := BSRW(opr16, opr16); err != nil {
		t.Fatal(err)
	}
}

func TestBSWAPLValidFormsNoError(t *testing.T) {
	if _, err := BSWAPL(opr32); err != nil {
		t.Fatal(err)
	}
}

func TestBSWAPQValidFormsNoError(t *testing.T) {
	if _, err := BSWAPQ(opr64); err != nil {
		t.Fatal(err)
	}
}

func TestBTCLValidFormsNoError(t *testing.T) {
	if _, err := BTCL(opimm8, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := BTCL(opimm8, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := BTCL(opr32, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := BTCL(opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestBTCQValidFormsNoError(t *testing.T) {
	if _, err := BTCQ(opimm8, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := BTCQ(opimm8, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := BTCQ(opr64, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := BTCQ(opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestBTCWValidFormsNoError(t *testing.T) {
	if _, err := BTCW(opimm8, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := BTCW(opimm8, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := BTCW(opr16, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := BTCW(opr16, opr16); err != nil {
		t.Fatal(err)
	}
}

func TestBTLValidFormsNoError(t *testing.T) {
	if _, err := BTL(opimm8, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := BTL(opimm8, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := BTL(opr32, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := BTL(opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestBTQValidFormsNoError(t *testing.T) {
	if _, err := BTQ(opimm8, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := BTQ(opimm8, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := BTQ(opr64, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := BTQ(opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestBTRLValidFormsNoError(t *testing.T) {
	if _, err := BTRL(opimm8, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := BTRL(opimm8, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := BTRL(opr32, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := BTRL(opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestBTRQValidFormsNoError(t *testing.T) {
	if _, err := BTRQ(opimm8, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := BTRQ(opimm8, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := BTRQ(opr64, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := BTRQ(opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestBTRWValidFormsNoError(t *testing.T) {
	if _, err := BTRW(opimm8, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := BTRW(opimm8, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := BTRW(opr16, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := BTRW(opr16, opr16); err != nil {
		t.Fatal(err)
	}
}

func TestBTSLValidFormsNoError(t *testing.T) {
	if _, err := BTSL(opimm8, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := BTSL(opimm8, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := BTSL(opr32, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := BTSL(opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestBTSQValidFormsNoError(t *testing.T) {
	if _, err := BTSQ(opimm8, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := BTSQ(opimm8, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := BTSQ(opr64, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := BTSQ(opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestBTSWValidFormsNoError(t *testing.T) {
	if _, err := BTSW(opimm8, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := BTSW(opimm8, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := BTSW(opr16, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := BTSW(opr16, opr16); err != nil {
		t.Fatal(err)
	}
}

func TestBTWValidFormsNoError(t *testing.T) {
	if _, err := BTW(opimm8, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := BTW(opimm8, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := BTW(opr16, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := BTW(opr16, opr16); err != nil {
		t.Fatal(err)
	}
}

func TestBZHILValidFormsNoError(t *testing.T) {
	if _, err := BZHIL(opr32, opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := BZHIL(opr32, opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestBZHIQValidFormsNoError(t *testing.T) {
	if _, err := BZHIQ(opr64, opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := BZHIQ(opr64, opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestCALLValidFormsNoError(t *testing.T) {
	if _, err := CALL(oprel32); err != nil {
		t.Fatal(err)
	}
}

func TestCBWValidFormsNoError(t *testing.T) {
	if _, err := CBW(); err != nil {
		t.Fatal(err)
	}
}

func TestCDQValidFormsNoError(t *testing.T) {
	if _, err := CDQ(); err != nil {
		t.Fatal(err)
	}
}

func TestCDQEValidFormsNoError(t *testing.T) {
	if _, err := CDQE(); err != nil {
		t.Fatal(err)
	}
}

func TestCLCValidFormsNoError(t *testing.T) {
	if _, err := CLC(); err != nil {
		t.Fatal(err)
	}
}

func TestCLDValidFormsNoError(t *testing.T) {
	if _, err := CLD(); err != nil {
		t.Fatal(err)
	}
}

func TestCLFLUSHValidFormsNoError(t *testing.T) {
	if _, err := CLFLUSH(opm8); err != nil {
		t.Fatal(err)
	}
}

func TestCLFLUSHOPTValidFormsNoError(t *testing.T) {
	if _, err := CLFLUSHOPT(opm8); err != nil {
		t.Fatal(err)
	}
}

func TestCMCValidFormsNoError(t *testing.T) {
	if _, err := CMC(); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVLCCValidFormsNoError(t *testing.T) {
	if _, err := CMOVLCC(opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVLCC(opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVLCSValidFormsNoError(t *testing.T) {
	if _, err := CMOVLCS(opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVLCS(opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVLEQValidFormsNoError(t *testing.T) {
	if _, err := CMOVLEQ(opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVLEQ(opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVLGEValidFormsNoError(t *testing.T) {
	if _, err := CMOVLGE(opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVLGE(opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVLGTValidFormsNoError(t *testing.T) {
	if _, err := CMOVLGT(opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVLGT(opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVLHIValidFormsNoError(t *testing.T) {
	if _, err := CMOVLHI(opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVLHI(opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVLLEValidFormsNoError(t *testing.T) {
	if _, err := CMOVLLE(opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVLLE(opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVLLSValidFormsNoError(t *testing.T) {
	if _, err := CMOVLLS(opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVLLS(opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVLLTValidFormsNoError(t *testing.T) {
	if _, err := CMOVLLT(opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVLLT(opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVLMIValidFormsNoError(t *testing.T) {
	if _, err := CMOVLMI(opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVLMI(opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVLNEValidFormsNoError(t *testing.T) {
	if _, err := CMOVLNE(opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVLNE(opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVLOCValidFormsNoError(t *testing.T) {
	if _, err := CMOVLOC(opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVLOC(opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVLOSValidFormsNoError(t *testing.T) {
	if _, err := CMOVLOS(opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVLOS(opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVLPCValidFormsNoError(t *testing.T) {
	if _, err := CMOVLPC(opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVLPC(opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVLPLValidFormsNoError(t *testing.T) {
	if _, err := CMOVLPL(opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVLPL(opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVLPSValidFormsNoError(t *testing.T) {
	if _, err := CMOVLPS(opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVLPS(opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVQCCValidFormsNoError(t *testing.T) {
	if _, err := CMOVQCC(opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVQCC(opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVQCSValidFormsNoError(t *testing.T) {
	if _, err := CMOVQCS(opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVQCS(opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVQEQValidFormsNoError(t *testing.T) {
	if _, err := CMOVQEQ(opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVQEQ(opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVQGEValidFormsNoError(t *testing.T) {
	if _, err := CMOVQGE(opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVQGE(opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVQGTValidFormsNoError(t *testing.T) {
	if _, err := CMOVQGT(opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVQGT(opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVQHIValidFormsNoError(t *testing.T) {
	if _, err := CMOVQHI(opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVQHI(opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVQLEValidFormsNoError(t *testing.T) {
	if _, err := CMOVQLE(opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVQLE(opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVQLSValidFormsNoError(t *testing.T) {
	if _, err := CMOVQLS(opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVQLS(opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVQLTValidFormsNoError(t *testing.T) {
	if _, err := CMOVQLT(opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVQLT(opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVQMIValidFormsNoError(t *testing.T) {
	if _, err := CMOVQMI(opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVQMI(opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVQNEValidFormsNoError(t *testing.T) {
	if _, err := CMOVQNE(opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVQNE(opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVQOCValidFormsNoError(t *testing.T) {
	if _, err := CMOVQOC(opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVQOC(opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVQOSValidFormsNoError(t *testing.T) {
	if _, err := CMOVQOS(opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVQOS(opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVQPCValidFormsNoError(t *testing.T) {
	if _, err := CMOVQPC(opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVQPC(opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVQPLValidFormsNoError(t *testing.T) {
	if _, err := CMOVQPL(opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVQPL(opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVQPSValidFormsNoError(t *testing.T) {
	if _, err := CMOVQPS(opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVQPS(opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVWCCValidFormsNoError(t *testing.T) {
	if _, err := CMOVWCC(opm16, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVWCC(opr16, opr16); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVWCSValidFormsNoError(t *testing.T) {
	if _, err := CMOVWCS(opm16, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVWCS(opr16, opr16); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVWEQValidFormsNoError(t *testing.T) {
	if _, err := CMOVWEQ(opm16, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVWEQ(opr16, opr16); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVWGEValidFormsNoError(t *testing.T) {
	if _, err := CMOVWGE(opm16, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVWGE(opr16, opr16); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVWGTValidFormsNoError(t *testing.T) {
	if _, err := CMOVWGT(opm16, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVWGT(opr16, opr16); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVWHIValidFormsNoError(t *testing.T) {
	if _, err := CMOVWHI(opm16, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVWHI(opr16, opr16); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVWLEValidFormsNoError(t *testing.T) {
	if _, err := CMOVWLE(opm16, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVWLE(opr16, opr16); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVWLSValidFormsNoError(t *testing.T) {
	if _, err := CMOVWLS(opm16, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVWLS(opr16, opr16); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVWLTValidFormsNoError(t *testing.T) {
	if _, err := CMOVWLT(opm16, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVWLT(opr16, opr16); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVWMIValidFormsNoError(t *testing.T) {
	if _, err := CMOVWMI(opm16, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVWMI(opr16, opr16); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVWNEValidFormsNoError(t *testing.T) {
	if _, err := CMOVWNE(opm16, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVWNE(opr16, opr16); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVWOCValidFormsNoError(t *testing.T) {
	if _, err := CMOVWOC(opm16, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVWOC(opr16, opr16); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVWOSValidFormsNoError(t *testing.T) {
	if _, err := CMOVWOS(opm16, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVWOS(opr16, opr16); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVWPCValidFormsNoError(t *testing.T) {
	if _, err := CMOVWPC(opm16, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVWPC(opr16, opr16); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVWPLValidFormsNoError(t *testing.T) {
	if _, err := CMOVWPL(opm16, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVWPL(opr16, opr16); err != nil {
		t.Fatal(err)
	}
}

func TestCMOVWPSValidFormsNoError(t *testing.T) {
	if _, err := CMOVWPS(opm16, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := CMOVWPS(opr16, opr16); err != nil {
		t.Fatal(err)
	}
}

func TestCMPBValidFormsNoError(t *testing.T) {
	if _, err := CMPB(opal, opimm8); err != nil {
		t.Fatal(err)
	}
	if _, err := CMPB(opm8, opimm8); err != nil {
		t.Fatal(err)
	}
	if _, err := CMPB(opm8, opr8); err != nil {
		t.Fatal(err)
	}
	if _, err := CMPB(opr8, opimm8); err != nil {
		t.Fatal(err)
	}
	if _, err := CMPB(opr8, opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := CMPB(opr8, opr8); err != nil {
		t.Fatal(err)
	}
}

func TestCMPLValidFormsNoError(t *testing.T) {
	if _, err := CMPL(opeax, opimm32); err != nil {
		t.Fatal(err)
	}
	if _, err := CMPL(opm32, opimm32); err != nil {
		t.Fatal(err)
	}
	if _, err := CMPL(opm32, opimm8); err != nil {
		t.Fatal(err)
	}
	if _, err := CMPL(opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := CMPL(opr32, opimm32); err != nil {
		t.Fatal(err)
	}
	if _, err := CMPL(opr32, opimm8); err != nil {
		t.Fatal(err)
	}
	if _, err := CMPL(opr32, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := CMPL(opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestCMPPDValidFormsNoError(t *testing.T) {
	if _, err := CMPPD(opm128, opxmm, opimm8); err != nil {
		t.Fatal(err)
	}
	if _, err := CMPPD(opxmm, opxmm, opimm8); err != nil {
		t.Fatal(err)
	}
}

func TestCMPPSValidFormsNoError(t *testing.T) {
	if _, err := CMPPS(opm128, opxmm, opimm8); err != nil {
		t.Fatal(err)
	}
	if _, err := CMPPS(opxmm, opxmm, opimm8); err != nil {
		t.Fatal(err)
	}
}

func TestCMPQValidFormsNoError(t *testing.T) {
	if _, err := CMPQ(opm64, opimm32); err != nil {
		t.Fatal(err)
	}
	if _, err := CMPQ(opm64, opimm8); err != nil {
		t.Fatal(err)
	}
	if _, err := CMPQ(opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := CMPQ(opr64, opimm32); err != nil {
		t.Fatal(err)
	}
	if _, err := CMPQ(opr64, opimm8); err != nil {
		t.Fatal(err)
	}
	if _, err := CMPQ(opr64, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := CMPQ(opr64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := CMPQ(oprax, opimm32); err != nil {
		t.Fatal(err)
	}
}

func TestCMPSDValidFormsNoError(t *testing.T) {
	if _, err := CMPSD(opm64, opxmm, opimm8); err != nil {
		t.Fatal(err)
	}
	if _, err := CMPSD(opxmm, opxmm, opimm8); err != nil {
		t.Fatal(err)
	}
}

func TestCMPSSValidFormsNoError(t *testing.T) {
	if _, err := CMPSS(opm32, opxmm, opimm8); err != nil {
		t.Fatal(err)
	}
	if _, err := CMPSS(opxmm, opxmm, opimm8); err != nil {
		t.Fatal(err)
	}
}

func TestCMPWValidFormsNoError(t *testing.T) {
	if _, err := CMPW(opax, opimm16); err != nil {
		t.Fatal(err)
	}
	if _, err := CMPW(opm16, opimm16); err != nil {
		t.Fatal(err)
	}
	if _, err := CMPW(opm16, opimm8); err != nil {
		t.Fatal(err)
	}
	if _, err := CMPW(opm16, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := CMPW(opr16, opimm16); err != nil {
		t.Fatal(err)
	}
	if _, err := CMPW(opr16, opimm8); err != nil {
		t.Fatal(err)
	}
	if _, err := CMPW(opr16, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := CMPW(opr16, opr16); err != nil {
		t.Fatal(err)
	}
}

func TestCMPXCHG16BValidFormsNoError(t *testing.T) {
	if _, err := CMPXCHG16B(opm128); err != nil {
		t.Fatal(err)
	}
}

func TestCMPXCHG8BValidFormsNoError(t *testing.T) {
	if _, err := CMPXCHG8B(opm64); err != nil {
		t.Fatal(err)
	}
}

func TestCMPXCHGBValidFormsNoError(t *testing.T) {
	if _, err := CMPXCHGB(opr8, opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := CMPXCHGB(opr8, opr8); err != nil {
		t.Fatal(err)
	}
}

func TestCMPXCHGLValidFormsNoError(t *testing.T) {
	if _, err := CMPXCHGL(opr32, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := CMPXCHGL(opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestCMPXCHGQValidFormsNoError(t *testing.T) {
	if _, err := CMPXCHGQ(opr64, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := CMPXCHGQ(opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestCMPXCHGWValidFormsNoError(t *testing.T) {
	if _, err := CMPXCHGW(opr16, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := CMPXCHGW(opr16, opr16); err != nil {
		t.Fatal(err)
	}
}

func TestCOMISDValidFormsNoError(t *testing.T) {
	if _, err := COMISD(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := COMISD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestCOMISSValidFormsNoError(t *testing.T) {
	if _, err := COMISS(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := COMISS(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestCPUIDValidFormsNoError(t *testing.T) {
	if _, err := CPUID(); err != nil {
		t.Fatal(err)
	}
}

func TestCQOValidFormsNoError(t *testing.T) {
	if _, err := CQO(); err != nil {
		t.Fatal(err)
	}
}

func TestCRC32BValidFormsNoError(t *testing.T) {
	if _, err := CRC32B(opm8, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := CRC32B(opm8, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := CRC32B(opr8, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := CRC32B(opr8, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestCRC32LValidFormsNoError(t *testing.T) {
	if _, err := CRC32L(opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := CRC32L(opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestCRC32QValidFormsNoError(t *testing.T) {
	if _, err := CRC32Q(opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := CRC32Q(opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestCRC32WValidFormsNoError(t *testing.T) {
	if _, err := CRC32W(opm16, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := CRC32W(opr16, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestCVTPD2PLValidFormsNoError(t *testing.T) {
	if _, err := CVTPD2PL(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := CVTPD2PL(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestCVTPD2PSValidFormsNoError(t *testing.T) {
	if _, err := CVTPD2PS(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := CVTPD2PS(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestCVTPL2PDValidFormsNoError(t *testing.T) {
	if _, err := CVTPL2PD(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := CVTPL2PD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestCVTPL2PSValidFormsNoError(t *testing.T) {
	if _, err := CVTPL2PS(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := CVTPL2PS(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestCVTPS2PDValidFormsNoError(t *testing.T) {
	if _, err := CVTPS2PD(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := CVTPS2PD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestCVTPS2PLValidFormsNoError(t *testing.T) {
	if _, err := CVTPS2PL(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := CVTPS2PL(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestCVTSD2SLValidFormsNoError(t *testing.T) {
	if _, err := CVTSD2SL(opm64, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := CVTSD2SL(opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := CVTSD2SL(opxmm, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := CVTSD2SL(opxmm, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestCVTSD2SSValidFormsNoError(t *testing.T) {
	if _, err := CVTSD2SS(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := CVTSD2SS(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestCVTSL2SDValidFormsNoError(t *testing.T) {
	if _, err := CVTSL2SD(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := CVTSL2SD(opr32, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestCVTSL2SSValidFormsNoError(t *testing.T) {
	if _, err := CVTSL2SS(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := CVTSL2SS(opr32, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestCVTSQ2SDValidFormsNoError(t *testing.T) {
	if _, err := CVTSQ2SD(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := CVTSQ2SD(opr64, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestCVTSQ2SSValidFormsNoError(t *testing.T) {
	if _, err := CVTSQ2SS(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := CVTSQ2SS(opr64, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestCVTSS2SDValidFormsNoError(t *testing.T) {
	if _, err := CVTSS2SD(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := CVTSS2SD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestCVTSS2SLValidFormsNoError(t *testing.T) {
	if _, err := CVTSS2SL(opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := CVTSS2SL(opm32, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := CVTSS2SL(opxmm, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := CVTSS2SL(opxmm, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestCVTTPD2PLValidFormsNoError(t *testing.T) {
	if _, err := CVTTPD2PL(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := CVTTPD2PL(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestCVTTPS2PLValidFormsNoError(t *testing.T) {
	if _, err := CVTTPS2PL(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := CVTTPS2PL(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestCVTTSD2SLValidFormsNoError(t *testing.T) {
	if _, err := CVTTSD2SL(opm64, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := CVTTSD2SL(opxmm, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestCVTTSD2SQValidFormsNoError(t *testing.T) {
	if _, err := CVTTSD2SQ(opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := CVTTSD2SQ(opxmm, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestCVTTSS2SLValidFormsNoError(t *testing.T) {
	if _, err := CVTTSS2SL(opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := CVTTSS2SL(opm32, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := CVTTSS2SL(opxmm, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := CVTTSS2SL(opxmm, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestCWDValidFormsNoError(t *testing.T) {
	if _, err := CWD(); err != nil {
		t.Fatal(err)
	}
}

func TestCWDEValidFormsNoError(t *testing.T) {
	if _, err := CWDE(); err != nil {
		t.Fatal(err)
	}
}

func TestDECBValidFormsNoError(t *testing.T) {
	if _, err := DECB(opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := DECB(opr8); err != nil {
		t.Fatal(err)
	}
}

func TestDECLValidFormsNoError(t *testing.T) {
	if _, err := DECL(opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := DECL(opr32); err != nil {
		t.Fatal(err)
	}
}

func TestDECQValidFormsNoError(t *testing.T) {
	if _, err := DECQ(opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := DECQ(opr64); err != nil {
		t.Fatal(err)
	}
}

func TestDECWValidFormsNoError(t *testing.T) {
	if _, err := DECW(opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := DECW(opr16); err != nil {
		t.Fatal(err)
	}
}

func TestDIVBValidFormsNoError(t *testing.T) {
	if _, err := DIVB(opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := DIVB(opr8); err != nil {
		t.Fatal(err)
	}
}

func TestDIVLValidFormsNoError(t *testing.T) {
	if _, err := DIVL(opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := DIVL(opr32); err != nil {
		t.Fatal(err)
	}
}

func TestDIVPDValidFormsNoError(t *testing.T) {
	if _, err := DIVPD(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := DIVPD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestDIVPSValidFormsNoError(t *testing.T) {
	if _, err := DIVPS(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := DIVPS(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestDIVQValidFormsNoError(t *testing.T) {
	if _, err := DIVQ(opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := DIVQ(opr64); err != nil {
		t.Fatal(err)
	}
}

func TestDIVSDValidFormsNoError(t *testing.T) {
	if _, err := DIVSD(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := DIVSD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestDIVSSValidFormsNoError(t *testing.T) {
	if _, err := DIVSS(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := DIVSS(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestDIVWValidFormsNoError(t *testing.T) {
	if _, err := DIVW(opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := DIVW(opr16); err != nil {
		t.Fatal(err)
	}
}

func TestDPPDValidFormsNoError(t *testing.T) {
	if _, err := DPPD(opimm8, opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := DPPD(opimm8, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestDPPSValidFormsNoError(t *testing.T) {
	if _, err := DPPS(opimm8, opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := DPPS(opimm8, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestEXTRACTPSValidFormsNoError(t *testing.T) {
	if _, err := EXTRACTPS(opimm2u, opxmm, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := EXTRACTPS(opimm2u, opxmm, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestHADDPDValidFormsNoError(t *testing.T) {
	if _, err := HADDPD(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := HADDPD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestHADDPSValidFormsNoError(t *testing.T) {
	if _, err := HADDPS(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := HADDPS(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestHSUBPDValidFormsNoError(t *testing.T) {
	if _, err := HSUBPD(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := HSUBPD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestHSUBPSValidFormsNoError(t *testing.T) {
	if _, err := HSUBPS(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := HSUBPS(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestIDIVBValidFormsNoError(t *testing.T) {
	if _, err := IDIVB(opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := IDIVB(opr8); err != nil {
		t.Fatal(err)
	}
}

func TestIDIVLValidFormsNoError(t *testing.T) {
	if _, err := IDIVL(opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := IDIVL(opr32); err != nil {
		t.Fatal(err)
	}
}

func TestIDIVQValidFormsNoError(t *testing.T) {
	if _, err := IDIVQ(opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := IDIVQ(opr64); err != nil {
		t.Fatal(err)
	}
}

func TestIDIVWValidFormsNoError(t *testing.T) {
	if _, err := IDIVW(opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := IDIVW(opr16); err != nil {
		t.Fatal(err)
	}
}

func TestIMUL3LValidFormsNoError(t *testing.T) {
	if _, err := IMUL3L(opimm32, opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := IMUL3L(opimm32, opr32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := IMUL3L(opimm8, opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := IMUL3L(opimm8, opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestIMUL3QValidFormsNoError(t *testing.T) {
	if _, err := IMUL3Q(opimm32, opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := IMUL3Q(opimm32, opr64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := IMUL3Q(opimm8, opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := IMUL3Q(opimm8, opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestIMUL3WValidFormsNoError(t *testing.T) {
	if _, err := IMUL3W(opimm16, opm16, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := IMUL3W(opimm16, opr16, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := IMUL3W(opimm8, opm16, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := IMUL3W(opimm8, opr16, opr16); err != nil {
		t.Fatal(err)
	}
}

func TestIMULBValidFormsNoError(t *testing.T) {
	if _, err := IMULB(opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := IMULB(opr8); err != nil {
		t.Fatal(err)
	}
}

func TestIMULLValidFormsNoError(t *testing.T) {
	if _, err := IMULL(opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := IMULL(opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := IMULL(opr32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := IMULL(opr32); err != nil {
		t.Fatal(err)
	}
}

func TestIMULQValidFormsNoError(t *testing.T) {
	if _, err := IMULQ(opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := IMULQ(opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := IMULQ(opr64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := IMULQ(opr64); err != nil {
		t.Fatal(err)
	}
}

func TestIMULWValidFormsNoError(t *testing.T) {
	if _, err := IMULW(opm16, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := IMULW(opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := IMULW(opr16, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := IMULW(opr16); err != nil {
		t.Fatal(err)
	}
}

func TestINCBValidFormsNoError(t *testing.T) {
	if _, err := INCB(opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := INCB(opr8); err != nil {
		t.Fatal(err)
	}
}

func TestINCLValidFormsNoError(t *testing.T) {
	if _, err := INCL(opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := INCL(opr32); err != nil {
		t.Fatal(err)
	}
}

func TestINCQValidFormsNoError(t *testing.T) {
	if _, err := INCQ(opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := INCQ(opr64); err != nil {
		t.Fatal(err)
	}
}

func TestINCWValidFormsNoError(t *testing.T) {
	if _, err := INCW(opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := INCW(opr16); err != nil {
		t.Fatal(err)
	}
}

func TestINSERTPSValidFormsNoError(t *testing.T) {
	if _, err := INSERTPS(opimm8, opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := INSERTPS(opimm8, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestINTValidFormsNoError(t *testing.T) {
	if _, err := INT(op3); err != nil {
		t.Fatal(err)
	}
	if _, err := INT(opimm8); err != nil {
		t.Fatal(err)
	}
}

func TestJAValidFormsNoError(t *testing.T) {
	if _, err := JA(oprel32); err != nil {
		t.Fatal(err)
	}
	if _, err := JA(oprel8); err != nil {
		t.Fatal(err)
	}
}

func TestJAEValidFormsNoError(t *testing.T) {
	if _, err := JAE(oprel32); err != nil {
		t.Fatal(err)
	}
	if _, err := JAE(oprel8); err != nil {
		t.Fatal(err)
	}
}

func TestJBValidFormsNoError(t *testing.T) {
	if _, err := JB(oprel32); err != nil {
		t.Fatal(err)
	}
	if _, err := JB(oprel8); err != nil {
		t.Fatal(err)
	}
}

func TestJBEValidFormsNoError(t *testing.T) {
	if _, err := JBE(oprel32); err != nil {
		t.Fatal(err)
	}
	if _, err := JBE(oprel8); err != nil {
		t.Fatal(err)
	}
}

func TestJCValidFormsNoError(t *testing.T) {
	if _, err := JC(oprel32); err != nil {
		t.Fatal(err)
	}
	if _, err := JC(oprel8); err != nil {
		t.Fatal(err)
	}
}

func TestJCCValidFormsNoError(t *testing.T) {
	if _, err := JCC(oprel32); err != nil {
		t.Fatal(err)
	}
	if _, err := JCC(oprel8); err != nil {
		t.Fatal(err)
	}
}

func TestJCSValidFormsNoError(t *testing.T) {
	if _, err := JCS(oprel32); err != nil {
		t.Fatal(err)
	}
	if _, err := JCS(oprel8); err != nil {
		t.Fatal(err)
	}
}

func TestJCXZLValidFormsNoError(t *testing.T) {
	if _, err := JCXZL(oprel8); err != nil {
		t.Fatal(err)
	}
}

func TestJCXZQValidFormsNoError(t *testing.T) {
	if _, err := JCXZQ(oprel8); err != nil {
		t.Fatal(err)
	}
}

func TestJEValidFormsNoError(t *testing.T) {
	if _, err := JE(oprel32); err != nil {
		t.Fatal(err)
	}
	if _, err := JE(oprel8); err != nil {
		t.Fatal(err)
	}
}

func TestJEQValidFormsNoError(t *testing.T) {
	if _, err := JEQ(oprel32); err != nil {
		t.Fatal(err)
	}
	if _, err := JEQ(oprel8); err != nil {
		t.Fatal(err)
	}
}

func TestJGValidFormsNoError(t *testing.T) {
	if _, err := JG(oprel32); err != nil {
		t.Fatal(err)
	}
	if _, err := JG(oprel8); err != nil {
		t.Fatal(err)
	}
}

func TestJGEValidFormsNoError(t *testing.T) {
	if _, err := JGE(oprel32); err != nil {
		t.Fatal(err)
	}
	if _, err := JGE(oprel8); err != nil {
		t.Fatal(err)
	}
}

func TestJGTValidFormsNoError(t *testing.T) {
	if _, err := JGT(oprel32); err != nil {
		t.Fatal(err)
	}
	if _, err := JGT(oprel8); err != nil {
		t.Fatal(err)
	}
}

func TestJHIValidFormsNoError(t *testing.T) {
	if _, err := JHI(oprel32); err != nil {
		t.Fatal(err)
	}
	if _, err := JHI(oprel8); err != nil {
		t.Fatal(err)
	}
}

func TestJHSValidFormsNoError(t *testing.T) {
	if _, err := JHS(oprel32); err != nil {
		t.Fatal(err)
	}
	if _, err := JHS(oprel8); err != nil {
		t.Fatal(err)
	}
}

func TestJLValidFormsNoError(t *testing.T) {
	if _, err := JL(oprel32); err != nil {
		t.Fatal(err)
	}
	if _, err := JL(oprel8); err != nil {
		t.Fatal(err)
	}
}

func TestJLEValidFormsNoError(t *testing.T) {
	if _, err := JLE(oprel32); err != nil {
		t.Fatal(err)
	}
	if _, err := JLE(oprel8); err != nil {
		t.Fatal(err)
	}
}

func TestJLOValidFormsNoError(t *testing.T) {
	if _, err := JLO(oprel32); err != nil {
		t.Fatal(err)
	}
	if _, err := JLO(oprel8); err != nil {
		t.Fatal(err)
	}
}

func TestJLSValidFormsNoError(t *testing.T) {
	if _, err := JLS(oprel32); err != nil {
		t.Fatal(err)
	}
	if _, err := JLS(oprel8); err != nil {
		t.Fatal(err)
	}
}

func TestJLTValidFormsNoError(t *testing.T) {
	if _, err := JLT(oprel32); err != nil {
		t.Fatal(err)
	}
	if _, err := JLT(oprel8); err != nil {
		t.Fatal(err)
	}
}

func TestJMIValidFormsNoError(t *testing.T) {
	if _, err := JMI(oprel32); err != nil {
		t.Fatal(err)
	}
	if _, err := JMI(oprel8); err != nil {
		t.Fatal(err)
	}
}

func TestJMPValidFormsNoError(t *testing.T) {
	if _, err := JMP(oprel32); err != nil {
		t.Fatal(err)
	}
	if _, err := JMP(oprel8); err != nil {
		t.Fatal(err)
	}
	if _, err := JMP(opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := JMP(opr64); err != nil {
		t.Fatal(err)
	}
}

func TestJNAValidFormsNoError(t *testing.T) {
	if _, err := JNA(oprel32); err != nil {
		t.Fatal(err)
	}
	if _, err := JNA(oprel8); err != nil {
		t.Fatal(err)
	}
}

func TestJNAEValidFormsNoError(t *testing.T) {
	if _, err := JNAE(oprel32); err != nil {
		t.Fatal(err)
	}
	if _, err := JNAE(oprel8); err != nil {
		t.Fatal(err)
	}
}

func TestJNBValidFormsNoError(t *testing.T) {
	if _, err := JNB(oprel32); err != nil {
		t.Fatal(err)
	}
	if _, err := JNB(oprel8); err != nil {
		t.Fatal(err)
	}
}

func TestJNBEValidFormsNoError(t *testing.T) {
	if _, err := JNBE(oprel32); err != nil {
		t.Fatal(err)
	}
	if _, err := JNBE(oprel8); err != nil {
		t.Fatal(err)
	}
}

func TestJNCValidFormsNoError(t *testing.T) {
	if _, err := JNC(oprel32); err != nil {
		t.Fatal(err)
	}
	if _, err := JNC(oprel8); err != nil {
		t.Fatal(err)
	}
}

func TestJNEValidFormsNoError(t *testing.T) {
	if _, err := JNE(oprel32); err != nil {
		t.Fatal(err)
	}
	if _, err := JNE(oprel8); err != nil {
		t.Fatal(err)
	}
}

func TestJNGValidFormsNoError(t *testing.T) {
	if _, err := JNG(oprel32); err != nil {
		t.Fatal(err)
	}
	if _, err := JNG(oprel8); err != nil {
		t.Fatal(err)
	}
}

func TestJNGEValidFormsNoError(t *testing.T) {
	if _, err := JNGE(oprel32); err != nil {
		t.Fatal(err)
	}
	if _, err := JNGE(oprel8); err != nil {
		t.Fatal(err)
	}
}

func TestJNLValidFormsNoError(t *testing.T) {
	if _, err := JNL(oprel32); err != nil {
		t.Fatal(err)
	}
	if _, err := JNL(oprel8); err != nil {
		t.Fatal(err)
	}
}

func TestJNLEValidFormsNoError(t *testing.T) {
	if _, err := JNLE(oprel32); err != nil {
		t.Fatal(err)
	}
	if _, err := JNLE(oprel8); err != nil {
		t.Fatal(err)
	}
}

func TestJNOValidFormsNoError(t *testing.T) {
	if _, err := JNO(oprel32); err != nil {
		t.Fatal(err)
	}
	if _, err := JNO(oprel8); err != nil {
		t.Fatal(err)
	}
}

func TestJNPValidFormsNoError(t *testing.T) {
	if _, err := JNP(oprel32); err != nil {
		t.Fatal(err)
	}
	if _, err := JNP(oprel8); err != nil {
		t.Fatal(err)
	}
}

func TestJNSValidFormsNoError(t *testing.T) {
	if _, err := JNS(oprel32); err != nil {
		t.Fatal(err)
	}
	if _, err := JNS(oprel8); err != nil {
		t.Fatal(err)
	}
}

func TestJNZValidFormsNoError(t *testing.T) {
	if _, err := JNZ(oprel32); err != nil {
		t.Fatal(err)
	}
	if _, err := JNZ(oprel8); err != nil {
		t.Fatal(err)
	}
}

func TestJOValidFormsNoError(t *testing.T) {
	if _, err := JO(oprel32); err != nil {
		t.Fatal(err)
	}
	if _, err := JO(oprel8); err != nil {
		t.Fatal(err)
	}
}

func TestJOCValidFormsNoError(t *testing.T) {
	if _, err := JOC(oprel32); err != nil {
		t.Fatal(err)
	}
	if _, err := JOC(oprel8); err != nil {
		t.Fatal(err)
	}
}

func TestJOSValidFormsNoError(t *testing.T) {
	if _, err := JOS(oprel32); err != nil {
		t.Fatal(err)
	}
	if _, err := JOS(oprel8); err != nil {
		t.Fatal(err)
	}
}

func TestJPValidFormsNoError(t *testing.T) {
	if _, err := JP(oprel32); err != nil {
		t.Fatal(err)
	}
	if _, err := JP(oprel8); err != nil {
		t.Fatal(err)
	}
}

func TestJPCValidFormsNoError(t *testing.T) {
	if _, err := JPC(oprel32); err != nil {
		t.Fatal(err)
	}
	if _, err := JPC(oprel8); err != nil {
		t.Fatal(err)
	}
}

func TestJPEValidFormsNoError(t *testing.T) {
	if _, err := JPE(oprel32); err != nil {
		t.Fatal(err)
	}
	if _, err := JPE(oprel8); err != nil {
		t.Fatal(err)
	}
}

func TestJPLValidFormsNoError(t *testing.T) {
	if _, err := JPL(oprel32); err != nil {
		t.Fatal(err)
	}
	if _, err := JPL(oprel8); err != nil {
		t.Fatal(err)
	}
}

func TestJPOValidFormsNoError(t *testing.T) {
	if _, err := JPO(oprel32); err != nil {
		t.Fatal(err)
	}
	if _, err := JPO(oprel8); err != nil {
		t.Fatal(err)
	}
}

func TestJPSValidFormsNoError(t *testing.T) {
	if _, err := JPS(oprel32); err != nil {
		t.Fatal(err)
	}
	if _, err := JPS(oprel8); err != nil {
		t.Fatal(err)
	}
}

func TestJSValidFormsNoError(t *testing.T) {
	if _, err := JS(oprel32); err != nil {
		t.Fatal(err)
	}
	if _, err := JS(oprel8); err != nil {
		t.Fatal(err)
	}
}

func TestJZValidFormsNoError(t *testing.T) {
	if _, err := JZ(oprel32); err != nil {
		t.Fatal(err)
	}
	if _, err := JZ(oprel8); err != nil {
		t.Fatal(err)
	}
}

func TestKADDBValidFormsNoError(t *testing.T) {
	if _, err := KADDB(opk, opk, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKADDDValidFormsNoError(t *testing.T) {
	if _, err := KADDD(opk, opk, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKADDQValidFormsNoError(t *testing.T) {
	if _, err := KADDQ(opk, opk, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKADDWValidFormsNoError(t *testing.T) {
	if _, err := KADDW(opk, opk, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKANDBValidFormsNoError(t *testing.T) {
	if _, err := KANDB(opk, opk, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKANDDValidFormsNoError(t *testing.T) {
	if _, err := KANDD(opk, opk, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKANDNBValidFormsNoError(t *testing.T) {
	if _, err := KANDNB(opk, opk, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKANDNDValidFormsNoError(t *testing.T) {
	if _, err := KANDND(opk, opk, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKANDNQValidFormsNoError(t *testing.T) {
	if _, err := KANDNQ(opk, opk, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKANDNWValidFormsNoError(t *testing.T) {
	if _, err := KANDNW(opk, opk, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKANDQValidFormsNoError(t *testing.T) {
	if _, err := KANDQ(opk, opk, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKANDWValidFormsNoError(t *testing.T) {
	if _, err := KANDW(opk, opk, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKMOVBValidFormsNoError(t *testing.T) {
	if _, err := KMOVB(opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := KMOVB(opk, opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := KMOVB(opk, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := KMOVB(opm8, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := KMOVB(opr32, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKMOVDValidFormsNoError(t *testing.T) {
	if _, err := KMOVD(opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := KMOVD(opk, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := KMOVD(opk, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := KMOVD(opm32, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := KMOVD(opr32, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKMOVQValidFormsNoError(t *testing.T) {
	if _, err := KMOVQ(opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := KMOVQ(opk, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := KMOVQ(opk, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := KMOVQ(opm64, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := KMOVQ(opr64, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKMOVWValidFormsNoError(t *testing.T) {
	if _, err := KMOVW(opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := KMOVW(opk, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := KMOVW(opk, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := KMOVW(opm16, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := KMOVW(opr32, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKNOTBValidFormsNoError(t *testing.T) {
	if _, err := KNOTB(opk, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKNOTDValidFormsNoError(t *testing.T) {
	if _, err := KNOTD(opk, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKNOTQValidFormsNoError(t *testing.T) {
	if _, err := KNOTQ(opk, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKNOTWValidFormsNoError(t *testing.T) {
	if _, err := KNOTW(opk, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKORBValidFormsNoError(t *testing.T) {
	if _, err := KORB(opk, opk, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKORDValidFormsNoError(t *testing.T) {
	if _, err := KORD(opk, opk, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKORQValidFormsNoError(t *testing.T) {
	if _, err := KORQ(opk, opk, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKORTESTBValidFormsNoError(t *testing.T) {
	if _, err := KORTESTB(opk, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKORTESTDValidFormsNoError(t *testing.T) {
	if _, err := KORTESTD(opk, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKORTESTQValidFormsNoError(t *testing.T) {
	if _, err := KORTESTQ(opk, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKORTESTWValidFormsNoError(t *testing.T) {
	if _, err := KORTESTW(opk, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKORWValidFormsNoError(t *testing.T) {
	if _, err := KORW(opk, opk, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKSHIFTLBValidFormsNoError(t *testing.T) {
	if _, err := KSHIFTLB(opimm8, opk, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKSHIFTLDValidFormsNoError(t *testing.T) {
	if _, err := KSHIFTLD(opimm8, opk, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKSHIFTLQValidFormsNoError(t *testing.T) {
	if _, err := KSHIFTLQ(opimm8, opk, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKSHIFTLWValidFormsNoError(t *testing.T) {
	if _, err := KSHIFTLW(opimm8, opk, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKSHIFTRBValidFormsNoError(t *testing.T) {
	if _, err := KSHIFTRB(opimm8, opk, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKSHIFTRDValidFormsNoError(t *testing.T) {
	if _, err := KSHIFTRD(opimm8, opk, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKSHIFTRQValidFormsNoError(t *testing.T) {
	if _, err := KSHIFTRQ(opimm8, opk, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKSHIFTRWValidFormsNoError(t *testing.T) {
	if _, err := KSHIFTRW(opimm8, opk, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKTESTBValidFormsNoError(t *testing.T) {
	if _, err := KTESTB(opk, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKTESTDValidFormsNoError(t *testing.T) {
	if _, err := KTESTD(opk, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKTESTQValidFormsNoError(t *testing.T) {
	if _, err := KTESTQ(opk, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKTESTWValidFormsNoError(t *testing.T) {
	if _, err := KTESTW(opk, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKUNPCKBWValidFormsNoError(t *testing.T) {
	if _, err := KUNPCKBW(opk, opk, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKUNPCKDQValidFormsNoError(t *testing.T) {
	if _, err := KUNPCKDQ(opk, opk, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKUNPCKWDValidFormsNoError(t *testing.T) {
	if _, err := KUNPCKWD(opk, opk, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKXNORBValidFormsNoError(t *testing.T) {
	if _, err := KXNORB(opk, opk, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKXNORDValidFormsNoError(t *testing.T) {
	if _, err := KXNORD(opk, opk, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKXNORQValidFormsNoError(t *testing.T) {
	if _, err := KXNORQ(opk, opk, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKXNORWValidFormsNoError(t *testing.T) {
	if _, err := KXNORW(opk, opk, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKXORBValidFormsNoError(t *testing.T) {
	if _, err := KXORB(opk, opk, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKXORDValidFormsNoError(t *testing.T) {
	if _, err := KXORD(opk, opk, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKXORQValidFormsNoError(t *testing.T) {
	if _, err := KXORQ(opk, opk, opk); err != nil {
		t.Fatal(err)
	}
}

func TestKXORWValidFormsNoError(t *testing.T) {
	if _, err := KXORW(opk, opk, opk); err != nil {
		t.Fatal(err)
	}
}

func TestLDDQUValidFormsNoError(t *testing.T) {
	if _, err := LDDQU(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestLDMXCSRValidFormsNoError(t *testing.T) {
	if _, err := LDMXCSR(opm32); err != nil {
		t.Fatal(err)
	}
}

func TestLEALValidFormsNoError(t *testing.T) {
	if _, err := LEAL(opm, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestLEAQValidFormsNoError(t *testing.T) {
	if _, err := LEAQ(opm, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestLEAWValidFormsNoError(t *testing.T) {
	if _, err := LEAW(opm, opr16); err != nil {
		t.Fatal(err)
	}
}

func TestLFENCEValidFormsNoError(t *testing.T) {
	if _, err := LFENCE(); err != nil {
		t.Fatal(err)
	}
}

func TestLZCNTLValidFormsNoError(t *testing.T) {
	if _, err := LZCNTL(opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := LZCNTL(opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestLZCNTQValidFormsNoError(t *testing.T) {
	if _, err := LZCNTQ(opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := LZCNTQ(opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestLZCNTWValidFormsNoError(t *testing.T) {
	if _, err := LZCNTW(opm16, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := LZCNTW(opr16, opr16); err != nil {
		t.Fatal(err)
	}
}

func TestMASKMOVDQUValidFormsNoError(t *testing.T) {
	if _, err := MASKMOVDQU(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestMASKMOVOUValidFormsNoError(t *testing.T) {
	if _, err := MASKMOVOU(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestMAXPDValidFormsNoError(t *testing.T) {
	if _, err := MAXPD(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := MAXPD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestMAXPSValidFormsNoError(t *testing.T) {
	if _, err := MAXPS(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := MAXPS(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestMAXSDValidFormsNoError(t *testing.T) {
	if _, err := MAXSD(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := MAXSD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestMAXSSValidFormsNoError(t *testing.T) {
	if _, err := MAXSS(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := MAXSS(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestMFENCEValidFormsNoError(t *testing.T) {
	if _, err := MFENCE(); err != nil {
		t.Fatal(err)
	}
}

func TestMINPDValidFormsNoError(t *testing.T) {
	if _, err := MINPD(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := MINPD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestMINPSValidFormsNoError(t *testing.T) {
	if _, err := MINPS(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := MINPS(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestMINSDValidFormsNoError(t *testing.T) {
	if _, err := MINSD(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := MINSD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestMINSSValidFormsNoError(t *testing.T) {
	if _, err := MINSS(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := MINSS(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestMONITORValidFormsNoError(t *testing.T) {
	if _, err := MONITOR(); err != nil {
		t.Fatal(err)
	}
}

func TestMOVAPDValidFormsNoError(t *testing.T) {
	if _, err := MOVAPD(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVAPD(opxmm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVAPD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestMOVAPSValidFormsNoError(t *testing.T) {
	if _, err := MOVAPS(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVAPS(opxmm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVAPS(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestMOVBValidFormsNoError(t *testing.T) {
	if _, err := MOVB(opimm8, opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVB(opimm8, opr8); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVB(opm8, opr8); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVB(opr8, opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVB(opr8, opr8); err != nil {
		t.Fatal(err)
	}
}

func TestMOVBELLValidFormsNoError(t *testing.T) {
	if _, err := MOVBELL(opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVBELL(opr32, opm32); err != nil {
		t.Fatal(err)
	}
}

func TestMOVBEQQValidFormsNoError(t *testing.T) {
	if _, err := MOVBEQQ(opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVBEQQ(opr64, opm64); err != nil {
		t.Fatal(err)
	}
}

func TestMOVBEWWValidFormsNoError(t *testing.T) {
	if _, err := MOVBEWW(opm16, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVBEWW(opr16, opm16); err != nil {
		t.Fatal(err)
	}
}

func TestMOVBLSXValidFormsNoError(t *testing.T) {
	if _, err := MOVBLSX(opm8, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVBLSX(opr8, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestMOVBLZXValidFormsNoError(t *testing.T) {
	if _, err := MOVBLZX(opm8, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVBLZX(opr8, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestMOVBQSXValidFormsNoError(t *testing.T) {
	if _, err := MOVBQSX(opm8, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVBQSX(opr8, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestMOVBQZXValidFormsNoError(t *testing.T) {
	if _, err := MOVBQZX(opm8, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVBQZX(opr8, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestMOVBWSXValidFormsNoError(t *testing.T) {
	if _, err := MOVBWSX(opm8, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVBWSX(opr8, opr16); err != nil {
		t.Fatal(err)
	}
}

func TestMOVBWZXValidFormsNoError(t *testing.T) {
	if _, err := MOVBWZX(opm8, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVBWZX(opr8, opr16); err != nil {
		t.Fatal(err)
	}
}

func TestMOVDValidFormsNoError(t *testing.T) {
	if _, err := MOVD(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVD(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVD(opr32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVD(opr64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVD(opxmm, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVD(opxmm, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVD(opxmm, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVD(opxmm, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVD(opimm32, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVD(opimm32, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVD(opimm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVD(opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVD(opr64, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVD(opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestMOVDDUPValidFormsNoError(t *testing.T) {
	if _, err := MOVDDUP(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVDDUP(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestMOVDQ2QValidFormsNoError(t *testing.T) {
	if _, err := MOVDQ2Q(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVDQ2Q(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVDQ2Q(opr32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVDQ2Q(opr64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVDQ2Q(opxmm, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVDQ2Q(opxmm, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVDQ2Q(opxmm, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVDQ2Q(opxmm, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVDQ2Q(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVDQ2Q(opimm32, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVDQ2Q(opimm32, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVDQ2Q(opimm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVDQ2Q(opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVDQ2Q(opr64, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVDQ2Q(opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestMOVHLPSValidFormsNoError(t *testing.T) {
	if _, err := MOVHLPS(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestMOVHPDValidFormsNoError(t *testing.T) {
	if _, err := MOVHPD(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVHPD(opxmm, opm64); err != nil {
		t.Fatal(err)
	}
}

func TestMOVHPSValidFormsNoError(t *testing.T) {
	if _, err := MOVHPS(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVHPS(opxmm, opm64); err != nil {
		t.Fatal(err)
	}
}

func TestMOVLValidFormsNoError(t *testing.T) {
	if _, err := MOVL(opimm32, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVL(opimm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVL(opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVL(opr32, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVL(opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestMOVLHPSValidFormsNoError(t *testing.T) {
	if _, err := MOVLHPS(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestMOVLPDValidFormsNoError(t *testing.T) {
	if _, err := MOVLPD(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVLPD(opxmm, opm64); err != nil {
		t.Fatal(err)
	}
}

func TestMOVLPSValidFormsNoError(t *testing.T) {
	if _, err := MOVLPS(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVLPS(opxmm, opm64); err != nil {
		t.Fatal(err)
	}
}

func TestMOVLQSXValidFormsNoError(t *testing.T) {
	if _, err := MOVLQSX(opm32, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVLQSX(opr32, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestMOVLQZXValidFormsNoError(t *testing.T) {
	if _, err := MOVLQZX(opm32, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestMOVMSKPDValidFormsNoError(t *testing.T) {
	if _, err := MOVMSKPD(opxmm, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestMOVMSKPSValidFormsNoError(t *testing.T) {
	if _, err := MOVMSKPS(opxmm, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestMOVNTDQValidFormsNoError(t *testing.T) {
	if _, err := MOVNTDQ(opxmm, opm128); err != nil {
		t.Fatal(err)
	}
}

func TestMOVNTDQAValidFormsNoError(t *testing.T) {
	if _, err := MOVNTDQA(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestMOVNTILValidFormsNoError(t *testing.T) {
	if _, err := MOVNTIL(opr32, opm32); err != nil {
		t.Fatal(err)
	}
}

func TestMOVNTIQValidFormsNoError(t *testing.T) {
	if _, err := MOVNTIQ(opr64, opm64); err != nil {
		t.Fatal(err)
	}
}

func TestMOVNTOValidFormsNoError(t *testing.T) {
	if _, err := MOVNTO(opxmm, opm128); err != nil {
		t.Fatal(err)
	}
}

func TestMOVNTPDValidFormsNoError(t *testing.T) {
	if _, err := MOVNTPD(opxmm, opm128); err != nil {
		t.Fatal(err)
	}
}

func TestMOVNTPSValidFormsNoError(t *testing.T) {
	if _, err := MOVNTPS(opxmm, opm128); err != nil {
		t.Fatal(err)
	}
}

func TestMOVOValidFormsNoError(t *testing.T) {
	if _, err := MOVO(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVO(opxmm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVO(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestMOVOAValidFormsNoError(t *testing.T) {
	if _, err := MOVOA(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVOA(opxmm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVOA(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestMOVOUValidFormsNoError(t *testing.T) {
	if _, err := MOVOU(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVOU(opxmm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVOU(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestMOVQValidFormsNoError(t *testing.T) {
	if _, err := MOVQ(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVQ(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVQ(opr32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVQ(opr64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVQ(opxmm, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVQ(opxmm, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVQ(opxmm, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVQ(opxmm, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVQ(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVQ(opimm32, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVQ(opimm32, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVQ(opimm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVQ(opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVQ(opr64, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVQ(opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestMOVSDValidFormsNoError(t *testing.T) {
	if _, err := MOVSD(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVSD(opxmm, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVSD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestMOVSHDUPValidFormsNoError(t *testing.T) {
	if _, err := MOVSHDUP(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVSHDUP(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestMOVSLDUPValidFormsNoError(t *testing.T) {
	if _, err := MOVSLDUP(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVSLDUP(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestMOVSSValidFormsNoError(t *testing.T) {
	if _, err := MOVSS(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVSS(opxmm, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVSS(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestMOVUPDValidFormsNoError(t *testing.T) {
	if _, err := MOVUPD(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVUPD(opxmm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVUPD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestMOVUPSValidFormsNoError(t *testing.T) {
	if _, err := MOVUPS(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVUPS(opxmm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVUPS(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestMOVWValidFormsNoError(t *testing.T) {
	if _, err := MOVW(opimm16, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVW(opimm16, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVW(opm16, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVW(opr16, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVW(opr16, opr16); err != nil {
		t.Fatal(err)
	}
}

func TestMOVWLSXValidFormsNoError(t *testing.T) {
	if _, err := MOVWLSX(opm16, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVWLSX(opr16, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestMOVWLZXValidFormsNoError(t *testing.T) {
	if _, err := MOVWLZX(opm16, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVWLZX(opr16, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestMOVWQSXValidFormsNoError(t *testing.T) {
	if _, err := MOVWQSX(opm16, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVWQSX(opr16, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestMOVWQZXValidFormsNoError(t *testing.T) {
	if _, err := MOVWQZX(opm16, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := MOVWQZX(opr16, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestMPSADBWValidFormsNoError(t *testing.T) {
	if _, err := MPSADBW(opimm8, opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := MPSADBW(opimm8, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestMULBValidFormsNoError(t *testing.T) {
	if _, err := MULB(opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := MULB(opr8); err != nil {
		t.Fatal(err)
	}
}

func TestMULLValidFormsNoError(t *testing.T) {
	if _, err := MULL(opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := MULL(opr32); err != nil {
		t.Fatal(err)
	}
}

func TestMULPDValidFormsNoError(t *testing.T) {
	if _, err := MULPD(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := MULPD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestMULPSValidFormsNoError(t *testing.T) {
	if _, err := MULPS(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := MULPS(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestMULQValidFormsNoError(t *testing.T) {
	if _, err := MULQ(opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := MULQ(opr64); err != nil {
		t.Fatal(err)
	}
}

func TestMULSDValidFormsNoError(t *testing.T) {
	if _, err := MULSD(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := MULSD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestMULSSValidFormsNoError(t *testing.T) {
	if _, err := MULSS(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := MULSS(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestMULWValidFormsNoError(t *testing.T) {
	if _, err := MULW(opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := MULW(opr16); err != nil {
		t.Fatal(err)
	}
}

func TestMULXLValidFormsNoError(t *testing.T) {
	if _, err := MULXL(opm32, opr32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := MULXL(opr32, opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestMULXQValidFormsNoError(t *testing.T) {
	if _, err := MULXQ(opm64, opr64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := MULXQ(opr64, opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestMWAITValidFormsNoError(t *testing.T) {
	if _, err := MWAIT(); err != nil {
		t.Fatal(err)
	}
}

func TestNEGBValidFormsNoError(t *testing.T) {
	if _, err := NEGB(opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := NEGB(opr8); err != nil {
		t.Fatal(err)
	}
}

func TestNEGLValidFormsNoError(t *testing.T) {
	if _, err := NEGL(opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := NEGL(opr32); err != nil {
		t.Fatal(err)
	}
}

func TestNEGQValidFormsNoError(t *testing.T) {
	if _, err := NEGQ(opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := NEGQ(opr64); err != nil {
		t.Fatal(err)
	}
}

func TestNEGWValidFormsNoError(t *testing.T) {
	if _, err := NEGW(opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := NEGW(opr16); err != nil {
		t.Fatal(err)
	}
}

func TestNOPValidFormsNoError(t *testing.T) {
	if _, err := NOP(); err != nil {
		t.Fatal(err)
	}
}

func TestNOTBValidFormsNoError(t *testing.T) {
	if _, err := NOTB(opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := NOTB(opr8); err != nil {
		t.Fatal(err)
	}
}

func TestNOTLValidFormsNoError(t *testing.T) {
	if _, err := NOTL(opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := NOTL(opr32); err != nil {
		t.Fatal(err)
	}
}

func TestNOTQValidFormsNoError(t *testing.T) {
	if _, err := NOTQ(opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := NOTQ(opr64); err != nil {
		t.Fatal(err)
	}
}

func TestNOTWValidFormsNoError(t *testing.T) {
	if _, err := NOTW(opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := NOTW(opr16); err != nil {
		t.Fatal(err)
	}
}

func TestORBValidFormsNoError(t *testing.T) {
	if _, err := ORB(opimm8, opal); err != nil {
		t.Fatal(err)
	}
	if _, err := ORB(opimm8, opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := ORB(opimm8, opr8); err != nil {
		t.Fatal(err)
	}
	if _, err := ORB(opm8, opr8); err != nil {
		t.Fatal(err)
	}
	if _, err := ORB(opr8, opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := ORB(opr8, opr8); err != nil {
		t.Fatal(err)
	}
}

func TestORLValidFormsNoError(t *testing.T) {
	if _, err := ORL(opimm32, opeax); err != nil {
		t.Fatal(err)
	}
	if _, err := ORL(opimm32, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := ORL(opimm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := ORL(opimm8, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := ORL(opimm8, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := ORL(opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := ORL(opr32, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := ORL(opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestORPDValidFormsNoError(t *testing.T) {
	if _, err := ORPD(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := ORPD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestORPSValidFormsNoError(t *testing.T) {
	if _, err := ORPS(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := ORPS(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestORQValidFormsNoError(t *testing.T) {
	if _, err := ORQ(opimm32, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := ORQ(opimm32, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := ORQ(opimm32, oprax); err != nil {
		t.Fatal(err)
	}
	if _, err := ORQ(opimm8, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := ORQ(opimm8, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := ORQ(opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := ORQ(opr64, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := ORQ(opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestORWValidFormsNoError(t *testing.T) {
	if _, err := ORW(opimm16, opax); err != nil {
		t.Fatal(err)
	}
	if _, err := ORW(opimm16, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := ORW(opimm16, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := ORW(opimm8, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := ORW(opimm8, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := ORW(opm16, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := ORW(opr16, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := ORW(opr16, opr16); err != nil {
		t.Fatal(err)
	}
}

func TestPABSBValidFormsNoError(t *testing.T) {
	if _, err := PABSB(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PABSB(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPABSDValidFormsNoError(t *testing.T) {
	if _, err := PABSD(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PABSD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPABSWValidFormsNoError(t *testing.T) {
	if _, err := PABSW(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PABSW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPACKSSLWValidFormsNoError(t *testing.T) {
	if _, err := PACKSSLW(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PACKSSLW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPACKSSWBValidFormsNoError(t *testing.T) {
	if _, err := PACKSSWB(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PACKSSWB(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPACKUSDWValidFormsNoError(t *testing.T) {
	if _, err := PACKUSDW(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PACKUSDW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPACKUSWBValidFormsNoError(t *testing.T) {
	if _, err := PACKUSWB(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PACKUSWB(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPADDBValidFormsNoError(t *testing.T) {
	if _, err := PADDB(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PADDB(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPADDDValidFormsNoError(t *testing.T) {
	if _, err := PADDD(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PADDD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPADDLValidFormsNoError(t *testing.T) {
	if _, err := PADDL(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PADDL(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPADDQValidFormsNoError(t *testing.T) {
	if _, err := PADDQ(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PADDQ(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPADDSBValidFormsNoError(t *testing.T) {
	if _, err := PADDSB(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PADDSB(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPADDSWValidFormsNoError(t *testing.T) {
	if _, err := PADDSW(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PADDSW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPADDUSBValidFormsNoError(t *testing.T) {
	if _, err := PADDUSB(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PADDUSB(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPADDUSWValidFormsNoError(t *testing.T) {
	if _, err := PADDUSW(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PADDUSW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPADDWValidFormsNoError(t *testing.T) {
	if _, err := PADDW(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PADDW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPALIGNRValidFormsNoError(t *testing.T) {
	if _, err := PALIGNR(opimm8, opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PALIGNR(opimm8, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPANDValidFormsNoError(t *testing.T) {
	if _, err := PAND(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PAND(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPANDNValidFormsNoError(t *testing.T) {
	if _, err := PANDN(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PANDN(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPAUSEValidFormsNoError(t *testing.T) {
	if _, err := PAUSE(); err != nil {
		t.Fatal(err)
	}
}

func TestPAVGBValidFormsNoError(t *testing.T) {
	if _, err := PAVGB(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PAVGB(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPAVGWValidFormsNoError(t *testing.T) {
	if _, err := PAVGW(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PAVGW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPBLENDVBValidFormsNoError(t *testing.T) {
	if _, err := PBLENDVB(opxmm0, opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PBLENDVB(opxmm0, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPBLENDWValidFormsNoError(t *testing.T) {
	if _, err := PBLENDW(opimm8, opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PBLENDW(opimm8, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPCLMULQDQValidFormsNoError(t *testing.T) {
	if _, err := PCLMULQDQ(opimm8, opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PCLMULQDQ(opimm8, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPCMPEQBValidFormsNoError(t *testing.T) {
	if _, err := PCMPEQB(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PCMPEQB(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPCMPEQLValidFormsNoError(t *testing.T) {
	if _, err := PCMPEQL(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PCMPEQL(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPCMPEQQValidFormsNoError(t *testing.T) {
	if _, err := PCMPEQQ(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PCMPEQQ(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPCMPEQWValidFormsNoError(t *testing.T) {
	if _, err := PCMPEQW(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PCMPEQW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPCMPESTRIValidFormsNoError(t *testing.T) {
	if _, err := PCMPESTRI(opimm8, opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PCMPESTRI(opimm8, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPCMPESTRMValidFormsNoError(t *testing.T) {
	if _, err := PCMPESTRM(opimm8, opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PCMPESTRM(opimm8, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPCMPGTBValidFormsNoError(t *testing.T) {
	if _, err := PCMPGTB(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PCMPGTB(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPCMPGTLValidFormsNoError(t *testing.T) {
	if _, err := PCMPGTL(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PCMPGTL(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPCMPGTQValidFormsNoError(t *testing.T) {
	if _, err := PCMPGTQ(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PCMPGTQ(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPCMPGTWValidFormsNoError(t *testing.T) {
	if _, err := PCMPGTW(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PCMPGTW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPCMPISTRIValidFormsNoError(t *testing.T) {
	if _, err := PCMPISTRI(opimm8, opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PCMPISTRI(opimm8, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPCMPISTRMValidFormsNoError(t *testing.T) {
	if _, err := PCMPISTRM(opimm8, opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PCMPISTRM(opimm8, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPDEPLValidFormsNoError(t *testing.T) {
	if _, err := PDEPL(opm32, opr32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := PDEPL(opr32, opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestPDEPQValidFormsNoError(t *testing.T) {
	if _, err := PDEPQ(opm64, opr64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := PDEPQ(opr64, opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestPEXTLValidFormsNoError(t *testing.T) {
	if _, err := PEXTL(opm32, opr32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := PEXTL(opr32, opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestPEXTQValidFormsNoError(t *testing.T) {
	if _, err := PEXTQ(opm64, opr64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := PEXTQ(opr64, opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestPEXTRBValidFormsNoError(t *testing.T) {
	if _, err := PEXTRB(opimm8, opxmm, opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := PEXTRB(opimm8, opxmm, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestPEXTRDValidFormsNoError(t *testing.T) {
	if _, err := PEXTRD(opimm8, opxmm, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := PEXTRD(opimm8, opxmm, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestPEXTRQValidFormsNoError(t *testing.T) {
	if _, err := PEXTRQ(opimm8, opxmm, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := PEXTRQ(opimm8, opxmm, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestPEXTRWValidFormsNoError(t *testing.T) {
	if _, err := PEXTRW(opimm8, opxmm, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := PEXTRW(opimm8, opxmm, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestPHADDDValidFormsNoError(t *testing.T) {
	if _, err := PHADDD(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PHADDD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPHADDSWValidFormsNoError(t *testing.T) {
	if _, err := PHADDSW(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PHADDSW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPHADDWValidFormsNoError(t *testing.T) {
	if _, err := PHADDW(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PHADDW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPHMINPOSUWValidFormsNoError(t *testing.T) {
	if _, err := PHMINPOSUW(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PHMINPOSUW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPHSUBDValidFormsNoError(t *testing.T) {
	if _, err := PHSUBD(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PHSUBD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPHSUBSWValidFormsNoError(t *testing.T) {
	if _, err := PHSUBSW(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PHSUBSW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPHSUBWValidFormsNoError(t *testing.T) {
	if _, err := PHSUBW(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PHSUBW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPINSRBValidFormsNoError(t *testing.T) {
	if _, err := PINSRB(opimm8, opm8, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PINSRB(opimm8, opr32, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPINSRDValidFormsNoError(t *testing.T) {
	if _, err := PINSRD(opimm8, opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PINSRD(opimm8, opr32, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPINSRQValidFormsNoError(t *testing.T) {
	if _, err := PINSRQ(opimm8, opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PINSRQ(opimm8, opr64, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPINSRWValidFormsNoError(t *testing.T) {
	if _, err := PINSRW(opimm8, opm16, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PINSRW(opimm8, opr32, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPMADDUBSWValidFormsNoError(t *testing.T) {
	if _, err := PMADDUBSW(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PMADDUBSW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPMADDWLValidFormsNoError(t *testing.T) {
	if _, err := PMADDWL(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PMADDWL(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPMAXSBValidFormsNoError(t *testing.T) {
	if _, err := PMAXSB(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PMAXSB(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPMAXSDValidFormsNoError(t *testing.T) {
	if _, err := PMAXSD(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PMAXSD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPMAXSWValidFormsNoError(t *testing.T) {
	if _, err := PMAXSW(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PMAXSW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPMAXUBValidFormsNoError(t *testing.T) {
	if _, err := PMAXUB(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PMAXUB(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPMAXUDValidFormsNoError(t *testing.T) {
	if _, err := PMAXUD(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PMAXUD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPMAXUWValidFormsNoError(t *testing.T) {
	if _, err := PMAXUW(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PMAXUW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPMINSBValidFormsNoError(t *testing.T) {
	if _, err := PMINSB(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PMINSB(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPMINSDValidFormsNoError(t *testing.T) {
	if _, err := PMINSD(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PMINSD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPMINSWValidFormsNoError(t *testing.T) {
	if _, err := PMINSW(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PMINSW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPMINUBValidFormsNoError(t *testing.T) {
	if _, err := PMINUB(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PMINUB(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPMINUDValidFormsNoError(t *testing.T) {
	if _, err := PMINUD(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PMINUD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPMINUWValidFormsNoError(t *testing.T) {
	if _, err := PMINUW(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PMINUW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPMOVMSKBValidFormsNoError(t *testing.T) {
	if _, err := PMOVMSKB(opxmm, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestPMOVSXBDValidFormsNoError(t *testing.T) {
	if _, err := PMOVSXBD(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PMOVSXBD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPMOVSXBQValidFormsNoError(t *testing.T) {
	if _, err := PMOVSXBQ(opm16, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PMOVSXBQ(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPMOVSXBWValidFormsNoError(t *testing.T) {
	if _, err := PMOVSXBW(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PMOVSXBW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPMOVSXDQValidFormsNoError(t *testing.T) {
	if _, err := PMOVSXDQ(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PMOVSXDQ(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPMOVSXWDValidFormsNoError(t *testing.T) {
	if _, err := PMOVSXWD(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PMOVSXWD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPMOVSXWQValidFormsNoError(t *testing.T) {
	if _, err := PMOVSXWQ(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PMOVSXWQ(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPMOVZXBDValidFormsNoError(t *testing.T) {
	if _, err := PMOVZXBD(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PMOVZXBD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPMOVZXBQValidFormsNoError(t *testing.T) {
	if _, err := PMOVZXBQ(opm16, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PMOVZXBQ(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPMOVZXBWValidFormsNoError(t *testing.T) {
	if _, err := PMOVZXBW(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PMOVZXBW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPMOVZXDQValidFormsNoError(t *testing.T) {
	if _, err := PMOVZXDQ(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PMOVZXDQ(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPMOVZXWDValidFormsNoError(t *testing.T) {
	if _, err := PMOVZXWD(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PMOVZXWD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPMOVZXWQValidFormsNoError(t *testing.T) {
	if _, err := PMOVZXWQ(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PMOVZXWQ(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPMULDQValidFormsNoError(t *testing.T) {
	if _, err := PMULDQ(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PMULDQ(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPMULHRSWValidFormsNoError(t *testing.T) {
	if _, err := PMULHRSW(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PMULHRSW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPMULHUWValidFormsNoError(t *testing.T) {
	if _, err := PMULHUW(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PMULHUW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPMULHWValidFormsNoError(t *testing.T) {
	if _, err := PMULHW(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PMULHW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPMULLDValidFormsNoError(t *testing.T) {
	if _, err := PMULLD(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PMULLD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPMULLWValidFormsNoError(t *testing.T) {
	if _, err := PMULLW(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PMULLW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPMULULQValidFormsNoError(t *testing.T) {
	if _, err := PMULULQ(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PMULULQ(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPOPCNTLValidFormsNoError(t *testing.T) {
	if _, err := POPCNTL(opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := POPCNTL(opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestPOPCNTQValidFormsNoError(t *testing.T) {
	if _, err := POPCNTQ(opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := POPCNTQ(opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestPOPCNTWValidFormsNoError(t *testing.T) {
	if _, err := POPCNTW(opm16, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := POPCNTW(opr16, opr16); err != nil {
		t.Fatal(err)
	}
}

func TestPOPQValidFormsNoError(t *testing.T) {
	if _, err := POPQ(opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := POPQ(opr64); err != nil {
		t.Fatal(err)
	}
}

func TestPOPWValidFormsNoError(t *testing.T) {
	if _, err := POPW(opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := POPW(opr16); err != nil {
		t.Fatal(err)
	}
}

func TestPORValidFormsNoError(t *testing.T) {
	if _, err := POR(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := POR(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPREFETCHNTAValidFormsNoError(t *testing.T) {
	if _, err := PREFETCHNTA(opm8); err != nil {
		t.Fatal(err)
	}
}

func TestPREFETCHT0ValidFormsNoError(t *testing.T) {
	if _, err := PREFETCHT0(opm8); err != nil {
		t.Fatal(err)
	}
}

func TestPREFETCHT1ValidFormsNoError(t *testing.T) {
	if _, err := PREFETCHT1(opm8); err != nil {
		t.Fatal(err)
	}
}

func TestPREFETCHT2ValidFormsNoError(t *testing.T) {
	if _, err := PREFETCHT2(opm8); err != nil {
		t.Fatal(err)
	}
}

func TestPSADBWValidFormsNoError(t *testing.T) {
	if _, err := PSADBW(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PSADBW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPSHUFBValidFormsNoError(t *testing.T) {
	if _, err := PSHUFB(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PSHUFB(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPSHUFDValidFormsNoError(t *testing.T) {
	if _, err := PSHUFD(opimm8, opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PSHUFD(opimm8, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPSHUFHWValidFormsNoError(t *testing.T) {
	if _, err := PSHUFHW(opimm8, opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PSHUFHW(opimm8, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPSHUFLValidFormsNoError(t *testing.T) {
	if _, err := PSHUFL(opimm8, opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PSHUFL(opimm8, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPSHUFLWValidFormsNoError(t *testing.T) {
	if _, err := PSHUFLW(opimm8, opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PSHUFLW(opimm8, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPSIGNBValidFormsNoError(t *testing.T) {
	if _, err := PSIGNB(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PSIGNB(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPSIGNDValidFormsNoError(t *testing.T) {
	if _, err := PSIGND(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PSIGND(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPSIGNWValidFormsNoError(t *testing.T) {
	if _, err := PSIGNW(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PSIGNW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPSLLDQValidFormsNoError(t *testing.T) {
	if _, err := PSLLDQ(opimm8, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPSLLLValidFormsNoError(t *testing.T) {
	if _, err := PSLLL(opimm8, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PSLLL(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PSLLL(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPSLLOValidFormsNoError(t *testing.T) {
	if _, err := PSLLO(opimm8, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPSLLQValidFormsNoError(t *testing.T) {
	if _, err := PSLLQ(opimm8, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PSLLQ(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PSLLQ(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPSLLWValidFormsNoError(t *testing.T) {
	if _, err := PSLLW(opimm8, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PSLLW(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PSLLW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPSRALValidFormsNoError(t *testing.T) {
	if _, err := PSRAL(opimm8, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PSRAL(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PSRAL(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPSRAWValidFormsNoError(t *testing.T) {
	if _, err := PSRAW(opimm8, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PSRAW(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PSRAW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPSRLDQValidFormsNoError(t *testing.T) {
	if _, err := PSRLDQ(opimm8, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPSRLLValidFormsNoError(t *testing.T) {
	if _, err := PSRLL(opimm8, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PSRLL(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PSRLL(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPSRLOValidFormsNoError(t *testing.T) {
	if _, err := PSRLO(opimm8, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPSRLQValidFormsNoError(t *testing.T) {
	if _, err := PSRLQ(opimm8, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PSRLQ(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PSRLQ(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPSRLWValidFormsNoError(t *testing.T) {
	if _, err := PSRLW(opimm8, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PSRLW(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PSRLW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPSUBBValidFormsNoError(t *testing.T) {
	if _, err := PSUBB(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PSUBB(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPSUBLValidFormsNoError(t *testing.T) {
	if _, err := PSUBL(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PSUBL(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPSUBQValidFormsNoError(t *testing.T) {
	if _, err := PSUBQ(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PSUBQ(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPSUBSBValidFormsNoError(t *testing.T) {
	if _, err := PSUBSB(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PSUBSB(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPSUBSWValidFormsNoError(t *testing.T) {
	if _, err := PSUBSW(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PSUBSW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPSUBUSBValidFormsNoError(t *testing.T) {
	if _, err := PSUBUSB(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PSUBUSB(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPSUBUSWValidFormsNoError(t *testing.T) {
	if _, err := PSUBUSW(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PSUBUSW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPSUBWValidFormsNoError(t *testing.T) {
	if _, err := PSUBW(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PSUBW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPTESTValidFormsNoError(t *testing.T) {
	if _, err := PTEST(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PTEST(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPUNPCKHBWValidFormsNoError(t *testing.T) {
	if _, err := PUNPCKHBW(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PUNPCKHBW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPUNPCKHLQValidFormsNoError(t *testing.T) {
	if _, err := PUNPCKHLQ(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PUNPCKHLQ(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPUNPCKHQDQValidFormsNoError(t *testing.T) {
	if _, err := PUNPCKHQDQ(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PUNPCKHQDQ(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPUNPCKHWLValidFormsNoError(t *testing.T) {
	if _, err := PUNPCKHWL(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PUNPCKHWL(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPUNPCKLBWValidFormsNoError(t *testing.T) {
	if _, err := PUNPCKLBW(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PUNPCKLBW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPUNPCKLLQValidFormsNoError(t *testing.T) {
	if _, err := PUNPCKLLQ(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PUNPCKLLQ(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPUNPCKLQDQValidFormsNoError(t *testing.T) {
	if _, err := PUNPCKLQDQ(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PUNPCKLQDQ(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPUNPCKLWLValidFormsNoError(t *testing.T) {
	if _, err := PUNPCKLWL(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PUNPCKLWL(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestPUSHQValidFormsNoError(t *testing.T) {
	if _, err := PUSHQ(opimm32); err != nil {
		t.Fatal(err)
	}
	if _, err := PUSHQ(opimm8); err != nil {
		t.Fatal(err)
	}
	if _, err := PUSHQ(opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := PUSHQ(opr64); err != nil {
		t.Fatal(err)
	}
}

func TestPUSHWValidFormsNoError(t *testing.T) {
	if _, err := PUSHW(opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := PUSHW(opr16); err != nil {
		t.Fatal(err)
	}
}

func TestPXORValidFormsNoError(t *testing.T) {
	if _, err := PXOR(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := PXOR(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestRCLBValidFormsNoError(t *testing.T) {
	if _, err := RCLB(op1, opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := RCLB(op1, opr8); err != nil {
		t.Fatal(err)
	}
	if _, err := RCLB(opcl, opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := RCLB(opcl, opr8); err != nil {
		t.Fatal(err)
	}
	if _, err := RCLB(opimm8, opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := RCLB(opimm8, opr8); err != nil {
		t.Fatal(err)
	}
}

func TestRCLLValidFormsNoError(t *testing.T) {
	if _, err := RCLL(op1, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := RCLL(op1, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := RCLL(opcl, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := RCLL(opcl, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := RCLL(opimm8, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := RCLL(opimm8, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestRCLQValidFormsNoError(t *testing.T) {
	if _, err := RCLQ(op1, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := RCLQ(op1, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := RCLQ(opcl, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := RCLQ(opcl, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := RCLQ(opimm8, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := RCLQ(opimm8, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestRCLWValidFormsNoError(t *testing.T) {
	if _, err := RCLW(op1, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := RCLW(op1, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := RCLW(opcl, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := RCLW(opcl, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := RCLW(opimm8, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := RCLW(opimm8, opr16); err != nil {
		t.Fatal(err)
	}
}

func TestRCPPSValidFormsNoError(t *testing.T) {
	if _, err := RCPPS(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := RCPPS(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestRCPSSValidFormsNoError(t *testing.T) {
	if _, err := RCPSS(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := RCPSS(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestRCRBValidFormsNoError(t *testing.T) {
	if _, err := RCRB(op1, opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := RCRB(op1, opr8); err != nil {
		t.Fatal(err)
	}
	if _, err := RCRB(opcl, opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := RCRB(opcl, opr8); err != nil {
		t.Fatal(err)
	}
	if _, err := RCRB(opimm8, opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := RCRB(opimm8, opr8); err != nil {
		t.Fatal(err)
	}
}

func TestRCRLValidFormsNoError(t *testing.T) {
	if _, err := RCRL(op1, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := RCRL(op1, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := RCRL(opcl, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := RCRL(opcl, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := RCRL(opimm8, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := RCRL(opimm8, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestRCRQValidFormsNoError(t *testing.T) {
	if _, err := RCRQ(op1, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := RCRQ(op1, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := RCRQ(opcl, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := RCRQ(opcl, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := RCRQ(opimm8, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := RCRQ(opimm8, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestRCRWValidFormsNoError(t *testing.T) {
	if _, err := RCRW(op1, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := RCRW(op1, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := RCRW(opcl, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := RCRW(opcl, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := RCRW(opimm8, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := RCRW(opimm8, opr16); err != nil {
		t.Fatal(err)
	}
}

func TestRDRANDLValidFormsNoError(t *testing.T) {
	if _, err := RDRANDL(opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := RDRANDL(opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := RDRANDL(opr64); err != nil {
		t.Fatal(err)
	}
}

func TestRDSEEDLValidFormsNoError(t *testing.T) {
	if _, err := RDSEEDL(opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := RDSEEDL(opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := RDSEEDL(opr64); err != nil {
		t.Fatal(err)
	}
}

func TestRDTSCValidFormsNoError(t *testing.T) {
	if _, err := RDTSC(); err != nil {
		t.Fatal(err)
	}
}

func TestRDTSCPValidFormsNoError(t *testing.T) {
	if _, err := RDTSCP(); err != nil {
		t.Fatal(err)
	}
}

func TestRETValidFormsNoError(t *testing.T) {
	if _, err := RET(); err != nil {
		t.Fatal(err)
	}
}

func TestRETFLValidFormsNoError(t *testing.T) {
	if _, err := RETFL(opimm16); err != nil {
		t.Fatal(err)
	}
}

func TestRETFQValidFormsNoError(t *testing.T) {
	if _, err := RETFQ(opimm16); err != nil {
		t.Fatal(err)
	}
}

func TestRETFWValidFormsNoError(t *testing.T) {
	if _, err := RETFW(opimm16); err != nil {
		t.Fatal(err)
	}
}

func TestROLBValidFormsNoError(t *testing.T) {
	if _, err := ROLB(op1, opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := ROLB(op1, opr8); err != nil {
		t.Fatal(err)
	}
	if _, err := ROLB(opcl, opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := ROLB(opcl, opr8); err != nil {
		t.Fatal(err)
	}
	if _, err := ROLB(opimm8, opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := ROLB(opimm8, opr8); err != nil {
		t.Fatal(err)
	}
}

func TestROLLValidFormsNoError(t *testing.T) {
	if _, err := ROLL(op1, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := ROLL(op1, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := ROLL(opcl, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := ROLL(opcl, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := ROLL(opimm8, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := ROLL(opimm8, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestROLQValidFormsNoError(t *testing.T) {
	if _, err := ROLQ(op1, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := ROLQ(op1, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := ROLQ(opcl, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := ROLQ(opcl, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := ROLQ(opimm8, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := ROLQ(opimm8, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestROLWValidFormsNoError(t *testing.T) {
	if _, err := ROLW(op1, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := ROLW(op1, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := ROLW(opcl, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := ROLW(opcl, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := ROLW(opimm8, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := ROLW(opimm8, opr16); err != nil {
		t.Fatal(err)
	}
}

func TestRORBValidFormsNoError(t *testing.T) {
	if _, err := RORB(op1, opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := RORB(op1, opr8); err != nil {
		t.Fatal(err)
	}
	if _, err := RORB(opcl, opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := RORB(opcl, opr8); err != nil {
		t.Fatal(err)
	}
	if _, err := RORB(opimm8, opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := RORB(opimm8, opr8); err != nil {
		t.Fatal(err)
	}
}

func TestRORLValidFormsNoError(t *testing.T) {
	if _, err := RORL(op1, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := RORL(op1, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := RORL(opcl, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := RORL(opcl, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := RORL(opimm8, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := RORL(opimm8, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestRORQValidFormsNoError(t *testing.T) {
	if _, err := RORQ(op1, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := RORQ(op1, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := RORQ(opcl, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := RORQ(opcl, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := RORQ(opimm8, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := RORQ(opimm8, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestRORWValidFormsNoError(t *testing.T) {
	if _, err := RORW(op1, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := RORW(op1, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := RORW(opcl, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := RORW(opcl, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := RORW(opimm8, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := RORW(opimm8, opr16); err != nil {
		t.Fatal(err)
	}
}

func TestRORXLValidFormsNoError(t *testing.T) {
	if _, err := RORXL(opimm8, opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := RORXL(opimm8, opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestRORXQValidFormsNoError(t *testing.T) {
	if _, err := RORXQ(opimm8, opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := RORXQ(opimm8, opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestROUNDPDValidFormsNoError(t *testing.T) {
	if _, err := ROUNDPD(opimm8, opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := ROUNDPD(opimm8, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestROUNDPSValidFormsNoError(t *testing.T) {
	if _, err := ROUNDPS(opimm8, opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := ROUNDPS(opimm8, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestROUNDSDValidFormsNoError(t *testing.T) {
	if _, err := ROUNDSD(opimm8, opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := ROUNDSD(opimm8, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestROUNDSSValidFormsNoError(t *testing.T) {
	if _, err := ROUNDSS(opimm8, opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := ROUNDSS(opimm8, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestRSQRTPSValidFormsNoError(t *testing.T) {
	if _, err := RSQRTPS(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := RSQRTPS(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestRSQRTSSValidFormsNoError(t *testing.T) {
	if _, err := RSQRTSS(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := RSQRTSS(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestSALBValidFormsNoError(t *testing.T) {
	if _, err := SALB(op1, opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := SALB(op1, opr8); err != nil {
		t.Fatal(err)
	}
	if _, err := SALB(opcl, opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := SALB(opcl, opr8); err != nil {
		t.Fatal(err)
	}
	if _, err := SALB(opimm8, opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := SALB(opimm8, opr8); err != nil {
		t.Fatal(err)
	}
}

func TestSALLValidFormsNoError(t *testing.T) {
	if _, err := SALL(op1, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := SALL(op1, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := SALL(opcl, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := SALL(opcl, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := SALL(opimm8, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := SALL(opimm8, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestSALQValidFormsNoError(t *testing.T) {
	if _, err := SALQ(op1, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := SALQ(op1, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := SALQ(opcl, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := SALQ(opcl, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := SALQ(opimm8, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := SALQ(opimm8, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestSALWValidFormsNoError(t *testing.T) {
	if _, err := SALW(op1, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := SALW(op1, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := SALW(opcl, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := SALW(opcl, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := SALW(opimm8, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := SALW(opimm8, opr16); err != nil {
		t.Fatal(err)
	}
}

func TestSARBValidFormsNoError(t *testing.T) {
	if _, err := SARB(op1, opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := SARB(op1, opr8); err != nil {
		t.Fatal(err)
	}
	if _, err := SARB(opcl, opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := SARB(opcl, opr8); err != nil {
		t.Fatal(err)
	}
	if _, err := SARB(opimm8, opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := SARB(opimm8, opr8); err != nil {
		t.Fatal(err)
	}
}

func TestSARLValidFormsNoError(t *testing.T) {
	if _, err := SARL(op1, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := SARL(op1, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := SARL(opcl, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := SARL(opcl, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := SARL(opimm8, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := SARL(opimm8, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestSARQValidFormsNoError(t *testing.T) {
	if _, err := SARQ(op1, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := SARQ(op1, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := SARQ(opcl, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := SARQ(opcl, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := SARQ(opimm8, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := SARQ(opimm8, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestSARWValidFormsNoError(t *testing.T) {
	if _, err := SARW(op1, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := SARW(op1, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := SARW(opcl, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := SARW(opcl, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := SARW(opimm8, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := SARW(opimm8, opr16); err != nil {
		t.Fatal(err)
	}
}

func TestSARXLValidFormsNoError(t *testing.T) {
	if _, err := SARXL(opr32, opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := SARXL(opr32, opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestSARXQValidFormsNoError(t *testing.T) {
	if _, err := SARXQ(opr64, opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := SARXQ(opr64, opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestSBBBValidFormsNoError(t *testing.T) {
	if _, err := SBBB(opimm8, opal); err != nil {
		t.Fatal(err)
	}
	if _, err := SBBB(opimm8, opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := SBBB(opimm8, opr8); err != nil {
		t.Fatal(err)
	}
	if _, err := SBBB(opm8, opr8); err != nil {
		t.Fatal(err)
	}
	if _, err := SBBB(opr8, opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := SBBB(opr8, opr8); err != nil {
		t.Fatal(err)
	}
}

func TestSBBLValidFormsNoError(t *testing.T) {
	if _, err := SBBL(opimm32, opeax); err != nil {
		t.Fatal(err)
	}
	if _, err := SBBL(opimm32, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := SBBL(opimm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := SBBL(opimm8, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := SBBL(opimm8, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := SBBL(opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := SBBL(opr32, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := SBBL(opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestSBBQValidFormsNoError(t *testing.T) {
	if _, err := SBBQ(opimm32, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := SBBQ(opimm32, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := SBBQ(opimm32, oprax); err != nil {
		t.Fatal(err)
	}
	if _, err := SBBQ(opimm8, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := SBBQ(opimm8, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := SBBQ(opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := SBBQ(opr64, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := SBBQ(opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestSBBWValidFormsNoError(t *testing.T) {
	if _, err := SBBW(opimm16, opax); err != nil {
		t.Fatal(err)
	}
	if _, err := SBBW(opimm16, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := SBBW(opimm16, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := SBBW(opimm8, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := SBBW(opimm8, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := SBBW(opm16, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := SBBW(opr16, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := SBBW(opr16, opr16); err != nil {
		t.Fatal(err)
	}
}

func TestSETCCValidFormsNoError(t *testing.T) {
	if _, err := SETCC(opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := SETCC(opr8); err != nil {
		t.Fatal(err)
	}
}

func TestSETCSValidFormsNoError(t *testing.T) {
	if _, err := SETCS(opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := SETCS(opr8); err != nil {
		t.Fatal(err)
	}
}

func TestSETEQValidFormsNoError(t *testing.T) {
	if _, err := SETEQ(opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := SETEQ(opr8); err != nil {
		t.Fatal(err)
	}
}

func TestSETGEValidFormsNoError(t *testing.T) {
	if _, err := SETGE(opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := SETGE(opr8); err != nil {
		t.Fatal(err)
	}
}

func TestSETGTValidFormsNoError(t *testing.T) {
	if _, err := SETGT(opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := SETGT(opr8); err != nil {
		t.Fatal(err)
	}
}

func TestSETHIValidFormsNoError(t *testing.T) {
	if _, err := SETHI(opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := SETHI(opr8); err != nil {
		t.Fatal(err)
	}
}

func TestSETLEValidFormsNoError(t *testing.T) {
	if _, err := SETLE(opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := SETLE(opr8); err != nil {
		t.Fatal(err)
	}
}

func TestSETLSValidFormsNoError(t *testing.T) {
	if _, err := SETLS(opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := SETLS(opr8); err != nil {
		t.Fatal(err)
	}
}

func TestSETLTValidFormsNoError(t *testing.T) {
	if _, err := SETLT(opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := SETLT(opr8); err != nil {
		t.Fatal(err)
	}
}

func TestSETMIValidFormsNoError(t *testing.T) {
	if _, err := SETMI(opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := SETMI(opr8); err != nil {
		t.Fatal(err)
	}
}

func TestSETNEValidFormsNoError(t *testing.T) {
	if _, err := SETNE(opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := SETNE(opr8); err != nil {
		t.Fatal(err)
	}
}

func TestSETOCValidFormsNoError(t *testing.T) {
	if _, err := SETOC(opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := SETOC(opr8); err != nil {
		t.Fatal(err)
	}
}

func TestSETOSValidFormsNoError(t *testing.T) {
	if _, err := SETOS(opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := SETOS(opr8); err != nil {
		t.Fatal(err)
	}
}

func TestSETPCValidFormsNoError(t *testing.T) {
	if _, err := SETPC(opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := SETPC(opr8); err != nil {
		t.Fatal(err)
	}
}

func TestSETPLValidFormsNoError(t *testing.T) {
	if _, err := SETPL(opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := SETPL(opr8); err != nil {
		t.Fatal(err)
	}
}

func TestSETPSValidFormsNoError(t *testing.T) {
	if _, err := SETPS(opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := SETPS(opr8); err != nil {
		t.Fatal(err)
	}
}

func TestSFENCEValidFormsNoError(t *testing.T) {
	if _, err := SFENCE(); err != nil {
		t.Fatal(err)
	}
}

func TestSHA1MSG1ValidFormsNoError(t *testing.T) {
	if _, err := SHA1MSG1(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := SHA1MSG1(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestSHA1MSG2ValidFormsNoError(t *testing.T) {
	if _, err := SHA1MSG2(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := SHA1MSG2(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestSHA1NEXTEValidFormsNoError(t *testing.T) {
	if _, err := SHA1NEXTE(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := SHA1NEXTE(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestSHA1RNDS4ValidFormsNoError(t *testing.T) {
	if _, err := SHA1RNDS4(opimm2u, opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := SHA1RNDS4(opimm2u, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestSHA256MSG1ValidFormsNoError(t *testing.T) {
	if _, err := SHA256MSG1(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := SHA256MSG1(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestSHA256MSG2ValidFormsNoError(t *testing.T) {
	if _, err := SHA256MSG2(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := SHA256MSG2(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestSHA256RNDS2ValidFormsNoError(t *testing.T) {
	if _, err := SHA256RNDS2(opxmm0, opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := SHA256RNDS2(opxmm0, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestSHLBValidFormsNoError(t *testing.T) {
	if _, err := SHLB(op1, opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := SHLB(op1, opr8); err != nil {
		t.Fatal(err)
	}
	if _, err := SHLB(opcl, opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := SHLB(opcl, opr8); err != nil {
		t.Fatal(err)
	}
	if _, err := SHLB(opimm8, opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := SHLB(opimm8, opr8); err != nil {
		t.Fatal(err)
	}
}

func TestSHLLValidFormsNoError(t *testing.T) {
	if _, err := SHLL(op1, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := SHLL(op1, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := SHLL(opcl, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := SHLL(opcl, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := SHLL(opcl, opr32, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := SHLL(opcl, opr32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := SHLL(opimm8, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := SHLL(opimm8, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := SHLL(opimm8, opr32, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := SHLL(opimm8, opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestSHLQValidFormsNoError(t *testing.T) {
	if _, err := SHLQ(op1, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := SHLQ(op1, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := SHLQ(opcl, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := SHLQ(opcl, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := SHLQ(opcl, opr64, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := SHLQ(opcl, opr64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := SHLQ(opimm8, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := SHLQ(opimm8, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := SHLQ(opimm8, opr64, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := SHLQ(opimm8, opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestSHLWValidFormsNoError(t *testing.T) {
	if _, err := SHLW(op1, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := SHLW(op1, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := SHLW(opcl, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := SHLW(opcl, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := SHLW(opcl, opr16, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := SHLW(opcl, opr16, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := SHLW(opimm8, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := SHLW(opimm8, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := SHLW(opimm8, opr16, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := SHLW(opimm8, opr16, opr16); err != nil {
		t.Fatal(err)
	}
}

func TestSHLXLValidFormsNoError(t *testing.T) {
	if _, err := SHLXL(opr32, opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := SHLXL(opr32, opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestSHLXQValidFormsNoError(t *testing.T) {
	if _, err := SHLXQ(opr64, opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := SHLXQ(opr64, opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestSHRBValidFormsNoError(t *testing.T) {
	if _, err := SHRB(op1, opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := SHRB(op1, opr8); err != nil {
		t.Fatal(err)
	}
	if _, err := SHRB(opcl, opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := SHRB(opcl, opr8); err != nil {
		t.Fatal(err)
	}
	if _, err := SHRB(opimm8, opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := SHRB(opimm8, opr8); err != nil {
		t.Fatal(err)
	}
}

func TestSHRLValidFormsNoError(t *testing.T) {
	if _, err := SHRL(op1, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := SHRL(op1, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := SHRL(opcl, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := SHRL(opcl, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := SHRL(opcl, opr32, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := SHRL(opcl, opr32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := SHRL(opimm8, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := SHRL(opimm8, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := SHRL(opimm8, opr32, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := SHRL(opimm8, opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestSHRQValidFormsNoError(t *testing.T) {
	if _, err := SHRQ(op1, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := SHRQ(op1, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := SHRQ(opcl, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := SHRQ(opcl, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := SHRQ(opcl, opr64, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := SHRQ(opcl, opr64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := SHRQ(opimm8, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := SHRQ(opimm8, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := SHRQ(opimm8, opr64, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := SHRQ(opimm8, opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestSHRWValidFormsNoError(t *testing.T) {
	if _, err := SHRW(op1, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := SHRW(op1, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := SHRW(opcl, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := SHRW(opcl, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := SHRW(opcl, opr16, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := SHRW(opcl, opr16, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := SHRW(opimm8, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := SHRW(opimm8, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := SHRW(opimm8, opr16, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := SHRW(opimm8, opr16, opr16); err != nil {
		t.Fatal(err)
	}
}

func TestSHRXLValidFormsNoError(t *testing.T) {
	if _, err := SHRXL(opr32, opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := SHRXL(opr32, opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestSHRXQValidFormsNoError(t *testing.T) {
	if _, err := SHRXQ(opr64, opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := SHRXQ(opr64, opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestSHUFPDValidFormsNoError(t *testing.T) {
	if _, err := SHUFPD(opimm8, opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := SHUFPD(opimm8, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestSHUFPSValidFormsNoError(t *testing.T) {
	if _, err := SHUFPS(opimm8, opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := SHUFPS(opimm8, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestSQRTPDValidFormsNoError(t *testing.T) {
	if _, err := SQRTPD(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := SQRTPD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestSQRTPSValidFormsNoError(t *testing.T) {
	if _, err := SQRTPS(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := SQRTPS(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestSQRTSDValidFormsNoError(t *testing.T) {
	if _, err := SQRTSD(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := SQRTSD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestSQRTSSValidFormsNoError(t *testing.T) {
	if _, err := SQRTSS(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := SQRTSS(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestSTCValidFormsNoError(t *testing.T) {
	if _, err := STC(); err != nil {
		t.Fatal(err)
	}
}

func TestSTDValidFormsNoError(t *testing.T) {
	if _, err := STD(); err != nil {
		t.Fatal(err)
	}
}

func TestSTMXCSRValidFormsNoError(t *testing.T) {
	if _, err := STMXCSR(opm32); err != nil {
		t.Fatal(err)
	}
}

func TestSUBBValidFormsNoError(t *testing.T) {
	if _, err := SUBB(opimm8, opal); err != nil {
		t.Fatal(err)
	}
	if _, err := SUBB(opimm8, opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := SUBB(opimm8, opr8); err != nil {
		t.Fatal(err)
	}
	if _, err := SUBB(opm8, opr8); err != nil {
		t.Fatal(err)
	}
	if _, err := SUBB(opr8, opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := SUBB(opr8, opr8); err != nil {
		t.Fatal(err)
	}
}

func TestSUBLValidFormsNoError(t *testing.T) {
	if _, err := SUBL(opimm32, opeax); err != nil {
		t.Fatal(err)
	}
	if _, err := SUBL(opimm32, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := SUBL(opimm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := SUBL(opimm8, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := SUBL(opimm8, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := SUBL(opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := SUBL(opr32, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := SUBL(opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestSUBPDValidFormsNoError(t *testing.T) {
	if _, err := SUBPD(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := SUBPD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestSUBPSValidFormsNoError(t *testing.T) {
	if _, err := SUBPS(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := SUBPS(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestSUBQValidFormsNoError(t *testing.T) {
	if _, err := SUBQ(opimm32, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := SUBQ(opimm32, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := SUBQ(opimm32, oprax); err != nil {
		t.Fatal(err)
	}
	if _, err := SUBQ(opimm8, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := SUBQ(opimm8, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := SUBQ(opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := SUBQ(opr64, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := SUBQ(opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestSUBSDValidFormsNoError(t *testing.T) {
	if _, err := SUBSD(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := SUBSD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestSUBSSValidFormsNoError(t *testing.T) {
	if _, err := SUBSS(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := SUBSS(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestSUBWValidFormsNoError(t *testing.T) {
	if _, err := SUBW(opimm16, opax); err != nil {
		t.Fatal(err)
	}
	if _, err := SUBW(opimm16, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := SUBW(opimm16, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := SUBW(opimm8, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := SUBW(opimm8, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := SUBW(opm16, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := SUBW(opr16, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := SUBW(opr16, opr16); err != nil {
		t.Fatal(err)
	}
}

func TestSYSCALLValidFormsNoError(t *testing.T) {
	if _, err := SYSCALL(); err != nil {
		t.Fatal(err)
	}
}

func TestTESTBValidFormsNoError(t *testing.T) {
	if _, err := TESTB(opimm8, opal); err != nil {
		t.Fatal(err)
	}
	if _, err := TESTB(opimm8, opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := TESTB(opimm8, opr8); err != nil {
		t.Fatal(err)
	}
	if _, err := TESTB(opr8, opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := TESTB(opr8, opr8); err != nil {
		t.Fatal(err)
	}
}

func TestTESTLValidFormsNoError(t *testing.T) {
	if _, err := TESTL(opimm32, opeax); err != nil {
		t.Fatal(err)
	}
	if _, err := TESTL(opimm32, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := TESTL(opimm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := TESTL(opr32, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := TESTL(opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestTESTQValidFormsNoError(t *testing.T) {
	if _, err := TESTQ(opimm32, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := TESTQ(opimm32, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := TESTQ(opimm32, oprax); err != nil {
		t.Fatal(err)
	}
	if _, err := TESTQ(opr64, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := TESTQ(opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestTESTWValidFormsNoError(t *testing.T) {
	if _, err := TESTW(opimm16, opax); err != nil {
		t.Fatal(err)
	}
	if _, err := TESTW(opimm16, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := TESTW(opimm16, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := TESTW(opr16, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := TESTW(opr16, opr16); err != nil {
		t.Fatal(err)
	}
}

func TestTZCNTLValidFormsNoError(t *testing.T) {
	if _, err := TZCNTL(opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := TZCNTL(opr32, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestTZCNTQValidFormsNoError(t *testing.T) {
	if _, err := TZCNTQ(opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := TZCNTQ(opr64, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestTZCNTWValidFormsNoError(t *testing.T) {
	if _, err := TZCNTW(opm16, opr16); err != nil {
		t.Fatal(err)
	}
	if _, err := TZCNTW(opr16, opr16); err != nil {
		t.Fatal(err)
	}
}

func TestUCOMISDValidFormsNoError(t *testing.T) {
	if _, err := UCOMISD(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := UCOMISD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestUCOMISSValidFormsNoError(t *testing.T) {
	if _, err := UCOMISS(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := UCOMISS(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestUD2ValidFormsNoError(t *testing.T) {
	if _, err := UD2(); err != nil {
		t.Fatal(err)
	}
}

func TestUNPCKHPDValidFormsNoError(t *testing.T) {
	if _, err := UNPCKHPD(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := UNPCKHPD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestUNPCKHPSValidFormsNoError(t *testing.T) {
	if _, err := UNPCKHPS(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := UNPCKHPS(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestUNPCKLPDValidFormsNoError(t *testing.T) {
	if _, err := UNPCKLPD(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := UNPCKLPD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestUNPCKLPSValidFormsNoError(t *testing.T) {
	if _, err := UNPCKLPS(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := UNPCKLPS(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVADDPDValidFormsNoError(t *testing.T) {
	if _, err := VADDPD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPD(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVADDPD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VADDPD_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPD_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPD_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPD_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPD_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPD_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVADDPD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VADDPD_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPD_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPD_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVADDPD_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VADDPD_RD_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPD_RD_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVADDPD_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VADDPD_RD_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVADDPD_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VADDPD_RN_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPD_RN_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVADDPD_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VADDPD_RN_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVADDPD_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VADDPD_RU_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPD_RU_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVADDPD_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VADDPD_RU_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVADDPD_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VADDPD_RZ_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPD_RZ_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVADDPD_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VADDPD_RZ_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVADDPD_ZValidFormsNoError(t *testing.T) {
	if _, err := VADDPD_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVADDPSValidFormsNoError(t *testing.T) {
	if _, err := VADDPS(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPS(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPS(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPS(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPS(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPS(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPS(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPS(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPS(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPS(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVADDPS_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VADDPS_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPS_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPS_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPS_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPS_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPS_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVADDPS_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VADDPS_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPS_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPS_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVADDPS_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VADDPS_RD_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPS_RD_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVADDPS_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VADDPS_RD_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVADDPS_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VADDPS_RN_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPS_RN_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVADDPS_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VADDPS_RN_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVADDPS_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VADDPS_RU_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPS_RU_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVADDPS_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VADDPS_RU_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVADDPS_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VADDPS_RZ_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPS_RZ_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVADDPS_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VADDPS_RZ_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVADDPS_ZValidFormsNoError(t *testing.T) {
	if _, err := VADDPS_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPS_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPS_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPS_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDPS_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVADDSDValidFormsNoError(t *testing.T) {
	if _, err := VADDSD(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDSD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDSD(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDSD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVADDSD_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VADDSD_RD_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDSD_RD_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVADDSD_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VADDSD_RD_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVADDSD_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VADDSD_RN_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDSD_RN_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVADDSD_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VADDSD_RN_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVADDSD_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VADDSD_RU_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDSD_RU_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVADDSD_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VADDSD_RU_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVADDSD_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VADDSD_RZ_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDSD_RZ_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVADDSD_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VADDSD_RZ_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVADDSD_ZValidFormsNoError(t *testing.T) {
	if _, err := VADDSD_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDSD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVADDSSValidFormsNoError(t *testing.T) {
	if _, err := VADDSS(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDSS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDSS(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDSS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVADDSS_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VADDSS_RD_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDSS_RD_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVADDSS_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VADDSS_RD_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVADDSS_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VADDSS_RN_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDSS_RN_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVADDSS_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VADDSS_RN_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVADDSS_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VADDSS_RU_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDSS_RU_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVADDSS_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VADDSS_RU_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVADDSS_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VADDSS_RZ_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDSS_RZ_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVADDSS_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VADDSS_RZ_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVADDSS_ZValidFormsNoError(t *testing.T) {
	if _, err := VADDSS_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDSS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVADDSUBPDValidFormsNoError(t *testing.T) {
	if _, err := VADDSUBPD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDSUBPD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDSUBPD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDSUBPD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVADDSUBPSValidFormsNoError(t *testing.T) {
	if _, err := VADDSUBPS(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDSUBPS(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDSUBPS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VADDSUBPS(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVAESDECValidFormsNoError(t *testing.T) {
	if _, err := VAESDEC(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VAESDEC(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VAESDEC(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VAESDEC(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VAESDEC(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VAESDEC(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVAESDECLASTValidFormsNoError(t *testing.T) {
	if _, err := VAESDECLAST(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VAESDECLAST(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VAESDECLAST(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VAESDECLAST(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VAESDECLAST(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VAESDECLAST(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVAESENCValidFormsNoError(t *testing.T) {
	if _, err := VAESENC(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VAESENC(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VAESENC(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VAESENC(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VAESENC(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VAESENC(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVAESENCLASTValidFormsNoError(t *testing.T) {
	if _, err := VAESENCLAST(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VAESENCLAST(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VAESENCLAST(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VAESENCLAST(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VAESENCLAST(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VAESENCLAST(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVAESIMCValidFormsNoError(t *testing.T) {
	if _, err := VAESIMC(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VAESIMC(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVAESKEYGENASSISTValidFormsNoError(t *testing.T) {
	if _, err := VAESKEYGENASSIST(opimm8, opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VAESKEYGENASSIST(opimm8, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVALIGNDValidFormsNoError(t *testing.T) {
	if _, err := VALIGND(opimm8, opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VALIGND(opimm8, opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VALIGND(opimm8, opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VALIGND(opimm8, opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VALIGND(opimm8, opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VALIGND(opimm8, opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VALIGND(opimm8, opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VALIGND(opimm8, opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VALIGND(opimm8, opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VALIGND(opimm8, opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VALIGND(opimm8, opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VALIGND(opimm8, opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVALIGND_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VALIGND_BCST(opimm8, opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VALIGND_BCST(opimm8, opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VALIGND_BCST(opimm8, opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VALIGND_BCST(opimm8, opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VALIGND_BCST(opimm8, opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VALIGND_BCST(opimm8, opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVALIGND_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VALIGND_BCST_Z(opimm8, opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VALIGND_BCST_Z(opimm8, opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VALIGND_BCST_Z(opimm8, opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVALIGND_ZValidFormsNoError(t *testing.T) {
	if _, err := VALIGND_Z(opimm8, opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VALIGND_Z(opimm8, opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VALIGND_Z(opimm8, opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VALIGND_Z(opimm8, opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VALIGND_Z(opimm8, opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VALIGND_Z(opimm8, opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVALIGNQValidFormsNoError(t *testing.T) {
	if _, err := VALIGNQ(opimm8, opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VALIGNQ(opimm8, opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VALIGNQ(opimm8, opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VALIGNQ(opimm8, opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VALIGNQ(opimm8, opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VALIGNQ(opimm8, opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VALIGNQ(opimm8, opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VALIGNQ(opimm8, opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VALIGNQ(opimm8, opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VALIGNQ(opimm8, opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VALIGNQ(opimm8, opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VALIGNQ(opimm8, opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVALIGNQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VALIGNQ_BCST(opimm8, opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VALIGNQ_BCST(opimm8, opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VALIGNQ_BCST(opimm8, opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VALIGNQ_BCST(opimm8, opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VALIGNQ_BCST(opimm8, opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VALIGNQ_BCST(opimm8, opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVALIGNQ_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VALIGNQ_BCST_Z(opimm8, opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VALIGNQ_BCST_Z(opimm8, opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VALIGNQ_BCST_Z(opimm8, opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVALIGNQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VALIGNQ_Z(opimm8, opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VALIGNQ_Z(opimm8, opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VALIGNQ_Z(opimm8, opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VALIGNQ_Z(opimm8, opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VALIGNQ_Z(opimm8, opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VALIGNQ_Z(opimm8, opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVANDNPDValidFormsNoError(t *testing.T) {
	if _, err := VANDNPD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDNPD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDNPD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDNPD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDNPD(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDNPD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDNPD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDNPD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDNPD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDNPD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDNPD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDNPD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVANDNPD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VANDNPD_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDNPD_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDNPD_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDNPD_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDNPD_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDNPD_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVANDNPD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VANDNPD_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDNPD_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDNPD_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVANDNPD_ZValidFormsNoError(t *testing.T) {
	if _, err := VANDNPD_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDNPD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDNPD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDNPD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDNPD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDNPD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVANDNPSValidFormsNoError(t *testing.T) {
	if _, err := VANDNPS(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDNPS(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDNPS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDNPS(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDNPS(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDNPS(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDNPS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDNPS(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDNPS(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDNPS(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDNPS(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDNPS(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVANDNPS_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VANDNPS_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDNPS_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDNPS_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDNPS_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDNPS_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDNPS_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVANDNPS_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VANDNPS_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDNPS_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDNPS_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVANDNPS_ZValidFormsNoError(t *testing.T) {
	if _, err := VANDNPS_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDNPS_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDNPS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDNPS_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDNPS_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDNPS_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVANDPDValidFormsNoError(t *testing.T) {
	if _, err := VANDPD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDPD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDPD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDPD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDPD(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDPD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDPD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDPD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDPD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDPD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDPD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDPD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVANDPD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VANDPD_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDPD_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDPD_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDPD_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDPD_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDPD_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVANDPD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VANDPD_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDPD_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDPD_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVANDPD_ZValidFormsNoError(t *testing.T) {
	if _, err := VANDPD_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDPD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDPD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDPD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDPD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDPD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVANDPSValidFormsNoError(t *testing.T) {
	if _, err := VANDPS(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDPS(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDPS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDPS(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDPS(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDPS(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDPS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDPS(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDPS(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDPS(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDPS(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDPS(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVANDPS_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VANDPS_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDPS_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDPS_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDPS_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDPS_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDPS_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVANDPS_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VANDPS_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDPS_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDPS_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVANDPS_ZValidFormsNoError(t *testing.T) {
	if _, err := VANDPS_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDPS_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDPS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDPS_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDPS_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VANDPS_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVBLENDMPDValidFormsNoError(t *testing.T) {
	if _, err := VBLENDMPD(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDMPD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDMPD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDMPD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDMPD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDMPD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDMPD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDMPD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDMPD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDMPD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDMPD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDMPD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVBLENDMPD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VBLENDMPD_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDMPD_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDMPD_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDMPD_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDMPD_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDMPD_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVBLENDMPD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VBLENDMPD_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDMPD_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDMPD_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVBLENDMPD_ZValidFormsNoError(t *testing.T) {
	if _, err := VBLENDMPD_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDMPD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDMPD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDMPD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDMPD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDMPD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVBLENDMPSValidFormsNoError(t *testing.T) {
	if _, err := VBLENDMPS(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDMPS(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDMPS(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDMPS(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDMPS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDMPS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDMPS(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDMPS(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDMPS(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDMPS(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDMPS(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDMPS(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVBLENDMPS_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VBLENDMPS_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDMPS_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDMPS_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDMPS_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDMPS_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDMPS_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVBLENDMPS_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VBLENDMPS_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDMPS_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDMPS_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVBLENDMPS_ZValidFormsNoError(t *testing.T) {
	if _, err := VBLENDMPS_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDMPS_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDMPS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDMPS_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDMPS_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDMPS_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVBLENDPDValidFormsNoError(t *testing.T) {
	if _, err := VBLENDPD(opimm8, opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDPD(opimm8, opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDPD(opimm8, opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDPD(opimm8, opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVBLENDPSValidFormsNoError(t *testing.T) {
	if _, err := VBLENDPS(opimm8, opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDPS(opimm8, opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDPS(opimm8, opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDPS(opimm8, opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVBLENDVPDValidFormsNoError(t *testing.T) {
	if _, err := VBLENDVPD(opxmm, opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDVPD(opxmm, opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDVPD(opymm, opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDVPD(opymm, opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVBLENDVPSValidFormsNoError(t *testing.T) {
	if _, err := VBLENDVPS(opxmm, opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDVPS(opxmm, opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDVPS(opymm, opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBLENDVPS(opymm, opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVBROADCASTF128ValidFormsNoError(t *testing.T) {
	if _, err := VBROADCASTF128(opm128, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVBROADCASTF32X2ValidFormsNoError(t *testing.T) {
	if _, err := VBROADCASTF32X2(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTF32X2(opm64, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTF32X2(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTF32X2(opxmm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTF32X2(opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTF32X2(opm64, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTF32X2(opxmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTF32X2(opxmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVBROADCASTF32X2_ZValidFormsNoError(t *testing.T) {
	if _, err := VBROADCASTF32X2_Z(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTF32X2_Z(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTF32X2_Z(opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTF32X2_Z(opxmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVBROADCASTF32X4ValidFormsNoError(t *testing.T) {
	if _, err := VBROADCASTF32X4(opm128, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTF32X4(opm128, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTF32X4(opm128, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTF32X4(opm128, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVBROADCASTF32X4_ZValidFormsNoError(t *testing.T) {
	if _, err := VBROADCASTF32X4_Z(opm128, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTF32X4_Z(opm128, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVBROADCASTF32X8ValidFormsNoError(t *testing.T) {
	if _, err := VBROADCASTF32X8(opm256, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTF32X8(opm256, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVBROADCASTF32X8_ZValidFormsNoError(t *testing.T) {
	if _, err := VBROADCASTF32X8_Z(opm256, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVBROADCASTF64X2ValidFormsNoError(t *testing.T) {
	if _, err := VBROADCASTF64X2(opm128, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTF64X2(opm128, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTF64X2(opm128, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTF64X2(opm128, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVBROADCASTF64X2_ZValidFormsNoError(t *testing.T) {
	if _, err := VBROADCASTF64X2_Z(opm128, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTF64X2_Z(opm128, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVBROADCASTF64X4ValidFormsNoError(t *testing.T) {
	if _, err := VBROADCASTF64X4(opm256, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTF64X4(opm256, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVBROADCASTF64X4_ZValidFormsNoError(t *testing.T) {
	if _, err := VBROADCASTF64X4_Z(opm256, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVBROADCASTI128ValidFormsNoError(t *testing.T) {
	if _, err := VBROADCASTI128(opm128, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVBROADCASTI32X2ValidFormsNoError(t *testing.T) {
	if _, err := VBROADCASTI32X2(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTI32X2(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTI32X2(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTI32X2(opm64, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTI32X2(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTI32X2(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTI32X2(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTI32X2(opxmm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTI32X2(opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTI32X2(opm64, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTI32X2(opxmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTI32X2(opxmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVBROADCASTI32X2_ZValidFormsNoError(t *testing.T) {
	if _, err := VBROADCASTI32X2_Z(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTI32X2_Z(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTI32X2_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTI32X2_Z(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTI32X2_Z(opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTI32X2_Z(opxmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVBROADCASTI32X4ValidFormsNoError(t *testing.T) {
	if _, err := VBROADCASTI32X4(opm128, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTI32X4(opm128, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTI32X4(opm128, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTI32X4(opm128, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVBROADCASTI32X4_ZValidFormsNoError(t *testing.T) {
	if _, err := VBROADCASTI32X4_Z(opm128, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTI32X4_Z(opm128, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVBROADCASTI32X8ValidFormsNoError(t *testing.T) {
	if _, err := VBROADCASTI32X8(opm256, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTI32X8(opm256, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVBROADCASTI32X8_ZValidFormsNoError(t *testing.T) {
	if _, err := VBROADCASTI32X8_Z(opm256, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVBROADCASTI64X2ValidFormsNoError(t *testing.T) {
	if _, err := VBROADCASTI64X2(opm128, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTI64X2(opm128, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTI64X2(opm128, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTI64X2(opm128, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVBROADCASTI64X2_ZValidFormsNoError(t *testing.T) {
	if _, err := VBROADCASTI64X2_Z(opm128, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTI64X2_Z(opm128, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVBROADCASTI64X4ValidFormsNoError(t *testing.T) {
	if _, err := VBROADCASTI64X4(opm256, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTI64X4(opm256, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVBROADCASTI64X4_ZValidFormsNoError(t *testing.T) {
	if _, err := VBROADCASTI64X4_Z(opm256, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVBROADCASTSDValidFormsNoError(t *testing.T) {
	if _, err := VBROADCASTSD(opxmm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTSD(opm64, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTSD(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTSD(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTSD(opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTSD(opm64, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTSD(opxmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTSD(opxmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVBROADCASTSD_ZValidFormsNoError(t *testing.T) {
	if _, err := VBROADCASTSD_Z(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTSD_Z(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTSD_Z(opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTSD_Z(opxmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVBROADCASTSSValidFormsNoError(t *testing.T) {
	if _, err := VBROADCASTSS(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTSS(opxmm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTSS(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTSS(opm32, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTSS(opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTSS(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTSS(opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTSS(opm32, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTSS(opxmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTSS(opxmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVBROADCASTSS_ZValidFormsNoError(t *testing.T) {
	if _, err := VBROADCASTSS_Z(opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTSS_Z(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTSS_Z(opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VBROADCASTSS_Z(opxmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCMPPDValidFormsNoError(t *testing.T) {
	if _, err := VCMPPD(opimm8, opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPPD(opimm8, opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPPD(opimm8, opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPPD(opimm8, opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPPD(opimm8, opm128, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPPD(opimm8, opm128, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPPD(opimm8, opm256, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPPD(opimm8, opm256, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPPD(opimm8, opxmm, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPPD(opimm8, opxmm, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPPD(opimm8, opymm, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPPD(opimm8, opymm, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPPD(opimm8, opm512, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPPD(opimm8, opm512, opzmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPPD(opimm8, opzmm, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPPD(opimm8, opzmm, opzmm, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVCMPPD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VCMPPD_BCST(opimm8, opm64, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPPD_BCST(opimm8, opm64, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPPD_BCST(opimm8, opm64, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPPD_BCST(opimm8, opm64, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPPD_BCST(opimm8, opm64, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPPD_BCST(opimm8, opm64, opzmm, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVCMPPD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCMPPD_SAE(opimm8, opzmm, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPPD_SAE(opimm8, opzmm, opzmm, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVCMPPSValidFormsNoError(t *testing.T) {
	if _, err := VCMPPS(opimm8, opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPPS(opimm8, opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPPS(opimm8, opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPPS(opimm8, opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPPS(opimm8, opm128, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPPS(opimm8, opm128, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPPS(opimm8, opm256, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPPS(opimm8, opm256, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPPS(opimm8, opxmm, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPPS(opimm8, opxmm, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPPS(opimm8, opymm, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPPS(opimm8, opymm, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPPS(opimm8, opm512, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPPS(opimm8, opm512, opzmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPPS(opimm8, opzmm, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPPS(opimm8, opzmm, opzmm, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVCMPPS_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VCMPPS_BCST(opimm8, opm32, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPPS_BCST(opimm8, opm32, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPPS_BCST(opimm8, opm32, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPPS_BCST(opimm8, opm32, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPPS_BCST(opimm8, opm32, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPPS_BCST(opimm8, opm32, opzmm, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVCMPPS_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCMPPS_SAE(opimm8, opzmm, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPPS_SAE(opimm8, opzmm, opzmm, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVCMPSDValidFormsNoError(t *testing.T) {
	if _, err := VCMPSD(opimm8, opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPSD(opimm8, opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPSD(opimm8, opm64, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPSD(opimm8, opm64, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPSD(opimm8, opxmm, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPSD(opimm8, opxmm, opxmm, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVCMPSD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCMPSD_SAE(opimm8, opxmm, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPSD_SAE(opimm8, opxmm, opxmm, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVCMPSSValidFormsNoError(t *testing.T) {
	if _, err := VCMPSS(opimm8, opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPSS(opimm8, opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPSS(opimm8, opm32, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPSS(opimm8, opm32, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPSS(opimm8, opxmm, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPSS(opimm8, opxmm, opxmm, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVCMPSS_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCMPSS_SAE(opimm8, opxmm, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VCMPSS_SAE(opimm8, opxmm, opxmm, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVCOMISDValidFormsNoError(t *testing.T) {
	if _, err := VCOMISD(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCOMISD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCOMISD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCOMISD_SAE(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCOMISSValidFormsNoError(t *testing.T) {
	if _, err := VCOMISS(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCOMISS(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCOMISS_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCOMISS_SAE(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCOMPRESSPDValidFormsNoError(t *testing.T) {
	if _, err := VCOMPRESSPD(opxmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VCOMPRESSPD(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCOMPRESSPD(opxmm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VCOMPRESSPD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCOMPRESSPD(opymm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VCOMPRESSPD(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCOMPRESSPD(opymm, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VCOMPRESSPD(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCOMPRESSPD(opzmm, opk, opm512); err != nil {
		t.Fatal(err)
	}
	if _, err := VCOMPRESSPD(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCOMPRESSPD(opzmm, opm512); err != nil {
		t.Fatal(err)
	}
	if _, err := VCOMPRESSPD(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCOMPRESSPD_ZValidFormsNoError(t *testing.T) {
	if _, err := VCOMPRESSPD_Z(opxmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VCOMPRESSPD_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCOMPRESSPD_Z(opymm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VCOMPRESSPD_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCOMPRESSPD_Z(opzmm, opk, opm512); err != nil {
		t.Fatal(err)
	}
	if _, err := VCOMPRESSPD_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCOMPRESSPSValidFormsNoError(t *testing.T) {
	if _, err := VCOMPRESSPS(opxmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VCOMPRESSPS(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCOMPRESSPS(opxmm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VCOMPRESSPS(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCOMPRESSPS(opymm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VCOMPRESSPS(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCOMPRESSPS(opymm, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VCOMPRESSPS(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCOMPRESSPS(opzmm, opk, opm512); err != nil {
		t.Fatal(err)
	}
	if _, err := VCOMPRESSPS(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCOMPRESSPS(opzmm, opm512); err != nil {
		t.Fatal(err)
	}
	if _, err := VCOMPRESSPS(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCOMPRESSPS_ZValidFormsNoError(t *testing.T) {
	if _, err := VCOMPRESSPS_Z(opxmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VCOMPRESSPS_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCOMPRESSPS_Z(opymm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VCOMPRESSPS_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCOMPRESSPS_Z(opzmm, opk, opm512); err != nil {
		t.Fatal(err)
	}
	if _, err := VCOMPRESSPS_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTDQ2PDValidFormsNoError(t *testing.T) {
	if _, err := VCVTDQ2PD(opm128, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PD(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PD(opxmm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PD(opm128, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PD(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PD(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PD(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PD(opm256, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PD(opm256, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PD(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PD(opymm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTDQ2PD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VCVTDQ2PD_BCST(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PD_BCST(opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PD_BCST(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PD_BCST(opm32, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PD_BCST(opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PD_BCST(opm32, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTDQ2PD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTDQ2PD_BCST_Z(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PD_BCST_Z(opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PD_BCST_Z(opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTDQ2PD_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTDQ2PD_Z(opm128, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PD_Z(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PD_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PD_Z(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PD_Z(opm256, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PD_Z(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTDQ2PSValidFormsNoError(t *testing.T) {
	if _, err := VCVTDQ2PS(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PS(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PS(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PS(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PS(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PS(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PS(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PS(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PS(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PS(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PS(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PS(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTDQ2PS_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VCVTDQ2PS_BCST(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PS_BCST(opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PS_BCST(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PS_BCST(opm32, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PS_BCST(opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PS_BCST(opm32, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTDQ2PS_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTDQ2PS_BCST_Z(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PS_BCST_Z(opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PS_BCST_Z(opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTDQ2PS_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTDQ2PS_RD_SAE(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PS_RD_SAE(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTDQ2PS_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTDQ2PS_RD_SAE_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTDQ2PS_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTDQ2PS_RN_SAE(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PS_RN_SAE(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTDQ2PS_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTDQ2PS_RN_SAE_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTDQ2PS_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTDQ2PS_RU_SAE(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PS_RU_SAE(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTDQ2PS_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTDQ2PS_RU_SAE_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTDQ2PS_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTDQ2PS_RZ_SAE(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PS_RZ_SAE(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTDQ2PS_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTDQ2PS_RZ_SAE_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTDQ2PS_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTDQ2PS_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PS_Z(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PS_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PS_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PS_Z(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTDQ2PS_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2DQValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2DQ(opm512, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2DQ(opm512, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2DQ(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2DQ(opzmm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2DQXValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2DQX(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2DQX(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2DQX(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2DQX(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2DQX_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2DQX_BCST(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2DQX_BCST(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2DQX_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2DQX_BCST_Z(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2DQX_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2DQX_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2DQX_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2DQYValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2DQY(opm256, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2DQY(opymm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2DQY(opm256, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2DQY(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2DQY_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2DQY_BCST(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2DQY_BCST(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2DQY_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2DQY_BCST_Z(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2DQY_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2DQY_Z(opm256, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2DQY_Z(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2DQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2DQ_BCST(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2DQ_BCST(opm64, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2DQ_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2DQ_BCST_Z(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2DQ_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2DQ_RD_SAE(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2DQ_RD_SAE(opzmm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2DQ_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2DQ_RD_SAE_Z(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2DQ_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2DQ_RN_SAE(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2DQ_RN_SAE(opzmm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2DQ_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2DQ_RN_SAE_Z(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2DQ_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2DQ_RU_SAE(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2DQ_RU_SAE(opzmm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2DQ_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2DQ_RU_SAE_Z(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2DQ_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2DQ_RZ_SAE(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2DQ_RZ_SAE(opzmm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2DQ_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2DQ_RZ_SAE_Z(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2DQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2DQ_Z(opm512, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2DQ_Z(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2PSValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2PS(opm512, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2PS(opm512, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2PS(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2PS(opzmm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2PSXValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2PSX(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2PSX(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2PSX(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2PSX(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2PSX_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2PSX_BCST(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2PSX_BCST(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2PSX_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2PSX_BCST_Z(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2PSX_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2PSX_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2PSX_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2PSYValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2PSY(opm256, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2PSY(opymm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2PSY(opm256, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2PSY(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2PSY_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2PSY_BCST(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2PSY_BCST(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2PSY_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2PSY_BCST_Z(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2PSY_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2PSY_Z(opm256, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2PSY_Z(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2PS_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2PS_BCST(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2PS_BCST(opm64, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2PS_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2PS_BCST_Z(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2PS_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2PS_RD_SAE(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2PS_RD_SAE(opzmm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2PS_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2PS_RD_SAE_Z(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2PS_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2PS_RN_SAE(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2PS_RN_SAE(opzmm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2PS_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2PS_RN_SAE_Z(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2PS_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2PS_RU_SAE(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2PS_RU_SAE(opzmm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2PS_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2PS_RU_SAE_Z(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2PS_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2PS_RZ_SAE(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2PS_RZ_SAE(opzmm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2PS_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2PS_RZ_SAE_Z(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2PS_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2PS_Z(opm512, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2PS_Z(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2QQValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2QQ(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2QQ(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2QQ(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2QQ(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2QQ(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2QQ(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2QQ(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2QQ(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2QQ(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2QQ(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2QQ(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2QQ(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2QQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2QQ_BCST(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2QQ_BCST(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2QQ_BCST(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2QQ_BCST(opm64, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2QQ_BCST(opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2QQ_BCST(opm64, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2QQ_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2QQ_BCST_Z(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2QQ_BCST_Z(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2QQ_BCST_Z(opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2QQ_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2QQ_RD_SAE(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2QQ_RD_SAE(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2QQ_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2QQ_RD_SAE_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2QQ_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2QQ_RN_SAE(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2QQ_RN_SAE(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2QQ_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2QQ_RN_SAE_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2QQ_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2QQ_RU_SAE(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2QQ_RU_SAE(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2QQ_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2QQ_RU_SAE_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2QQ_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2QQ_RZ_SAE(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2QQ_RZ_SAE(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2QQ_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2QQ_RZ_SAE_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2QQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2QQ_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2QQ_Z(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2QQ_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2QQ_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2QQ_Z(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2QQ_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2UDQValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2UDQ(opm512, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2UDQ(opm512, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2UDQ(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2UDQ(opzmm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2UDQXValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2UDQX(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2UDQX(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2UDQX(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2UDQX(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2UDQX_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2UDQX_BCST(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2UDQX_BCST(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2UDQX_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2UDQX_BCST_Z(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2UDQX_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2UDQX_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2UDQX_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2UDQYValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2UDQY(opm256, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2UDQY(opm256, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2UDQY(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2UDQY(opymm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2UDQY_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2UDQY_BCST(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2UDQY_BCST(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2UDQY_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2UDQY_BCST_Z(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2UDQY_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2UDQY_Z(opm256, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2UDQY_Z(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2UDQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2UDQ_BCST(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2UDQ_BCST(opm64, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2UDQ_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2UDQ_BCST_Z(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2UDQ_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2UDQ_RD_SAE(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2UDQ_RD_SAE(opzmm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2UDQ_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2UDQ_RD_SAE_Z(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2UDQ_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2UDQ_RN_SAE(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2UDQ_RN_SAE(opzmm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2UDQ_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2UDQ_RN_SAE_Z(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2UDQ_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2UDQ_RU_SAE(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2UDQ_RU_SAE(opzmm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2UDQ_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2UDQ_RU_SAE_Z(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2UDQ_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2UDQ_RZ_SAE(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2UDQ_RZ_SAE(opzmm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2UDQ_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2UDQ_RZ_SAE_Z(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2UDQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2UDQ_Z(opm512, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2UDQ_Z(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2UQQValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2UQQ(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2UQQ(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2UQQ(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2UQQ(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2UQQ(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2UQQ(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2UQQ(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2UQQ(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2UQQ(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2UQQ(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2UQQ(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2UQQ(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2UQQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2UQQ_BCST(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2UQQ_BCST(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2UQQ_BCST(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2UQQ_BCST(opm64, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2UQQ_BCST(opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2UQQ_BCST(opm64, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2UQQ_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2UQQ_BCST_Z(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2UQQ_BCST_Z(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2UQQ_BCST_Z(opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2UQQ_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2UQQ_RD_SAE(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2UQQ_RD_SAE(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2UQQ_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2UQQ_RD_SAE_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2UQQ_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2UQQ_RN_SAE(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2UQQ_RN_SAE(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2UQQ_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2UQQ_RN_SAE_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2UQQ_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2UQQ_RU_SAE(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2UQQ_RU_SAE(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2UQQ_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2UQQ_RU_SAE_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2UQQ_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2UQQ_RZ_SAE(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2UQQ_RZ_SAE(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2UQQ_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2UQQ_RZ_SAE_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPD2UQQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPD2UQQ_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2UQQ_Z(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2UQQ_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2UQQ_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2UQQ_Z(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPD2UQQ_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPH2PSValidFormsNoError(t *testing.T) {
	if _, err := VCVTPH2PS(opm128, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPH2PS(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPH2PS(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPH2PS(opxmm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPH2PS(opm128, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPH2PS(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPH2PS(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPH2PS(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPH2PS(opm256, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPH2PS(opm256, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPH2PS(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPH2PS(opymm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPH2PS_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTPH2PS_SAE(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPH2PS_SAE(opymm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPH2PS_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPH2PS_SAE_Z(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPH2PS_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPH2PS_Z(opm128, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPH2PS_Z(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPH2PS_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPH2PS_Z(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPH2PS_Z(opm256, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPH2PS_Z(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2DQValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2DQ(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2DQ(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2DQ(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2DQ(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2DQ(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2DQ(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2DQ(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2DQ(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2DQ(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2DQ(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2DQ(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2DQ(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2DQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2DQ_BCST(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2DQ_BCST(opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2DQ_BCST(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2DQ_BCST(opm32, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2DQ_BCST(opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2DQ_BCST(opm32, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2DQ_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2DQ_BCST_Z(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2DQ_BCST_Z(opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2DQ_BCST_Z(opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2DQ_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2DQ_RD_SAE(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2DQ_RD_SAE(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2DQ_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2DQ_RD_SAE_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2DQ_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2DQ_RN_SAE(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2DQ_RN_SAE(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2DQ_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2DQ_RN_SAE_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2DQ_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2DQ_RU_SAE(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2DQ_RU_SAE(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2DQ_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2DQ_RU_SAE_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2DQ_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2DQ_RZ_SAE(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2DQ_RZ_SAE(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2DQ_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2DQ_RZ_SAE_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2DQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2DQ_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2DQ_Z(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2DQ_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2DQ_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2DQ_Z(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2DQ_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2PDValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2PD(opm128, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2PD(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2PD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2PD(opxmm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2PD(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2PD(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2PD(opm256, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2PD(opm256, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2PD(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2PD(opymm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2PD(opm128, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2PD(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2PD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2PD_BCST(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2PD_BCST(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2PD_BCST(opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2PD_BCST(opm32, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2PD_BCST(opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2PD_BCST(opm32, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2PD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2PD_BCST_Z(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2PD_BCST_Z(opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2PD_BCST_Z(opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2PD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2PD_SAE(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2PD_SAE(opymm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2PD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2PD_SAE_Z(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2PD_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2PD_Z(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2PD_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2PD_Z(opm256, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2PD_Z(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2PD_Z(opm128, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2PD_Z(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2PHValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2PH(opimm8, opxmm, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2PH(opimm8, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2PH(opimm8, opymm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2PH(opimm8, opymm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2PH(opimm8, opxmm, opk, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2PH(opimm8, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2PH(opimm8, opymm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2PH(opimm8, opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2PH(opimm8, opzmm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2PH(opimm8, opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2PH(opimm8, opzmm, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2PH(opimm8, opzmm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2PH_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2PH_SAE(opimm8, opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2PH_SAE(opimm8, opzmm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2PH_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2PH_SAE_Z(opimm8, opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2PH_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2PH_Z(opimm8, opxmm, opk, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2PH_Z(opimm8, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2PH_Z(opimm8, opymm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2PH_Z(opimm8, opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2PH_Z(opimm8, opzmm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2PH_Z(opimm8, opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2QQValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2QQ(opm128, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2QQ(opm128, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2QQ(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2QQ(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2QQ(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2QQ(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2QQ(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2QQ(opxmm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2QQ(opm256, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2QQ(opm256, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2QQ(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2QQ(opymm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2QQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2QQ_BCST(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2QQ_BCST(opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2QQ_BCST(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2QQ_BCST(opm32, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2QQ_BCST(opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2QQ_BCST(opm32, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2QQ_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2QQ_BCST_Z(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2QQ_BCST_Z(opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2QQ_BCST_Z(opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2QQ_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2QQ_RD_SAE(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2QQ_RD_SAE(opymm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2QQ_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2QQ_RD_SAE_Z(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2QQ_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2QQ_RN_SAE(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2QQ_RN_SAE(opymm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2QQ_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2QQ_RN_SAE_Z(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2QQ_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2QQ_RU_SAE(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2QQ_RU_SAE(opymm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2QQ_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2QQ_RU_SAE_Z(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2QQ_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2QQ_RZ_SAE(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2QQ_RZ_SAE(opymm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2QQ_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2QQ_RZ_SAE_Z(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2QQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2QQ_Z(opm128, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2QQ_Z(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2QQ_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2QQ_Z(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2QQ_Z(opm256, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2QQ_Z(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2UDQValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2UDQ(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UDQ(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UDQ(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UDQ(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UDQ(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UDQ(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UDQ(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UDQ(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UDQ(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UDQ(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UDQ(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UDQ(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2UDQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2UDQ_BCST(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UDQ_BCST(opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UDQ_BCST(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UDQ_BCST(opm32, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UDQ_BCST(opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UDQ_BCST(opm32, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2UDQ_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2UDQ_BCST_Z(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UDQ_BCST_Z(opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UDQ_BCST_Z(opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2UDQ_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2UDQ_RD_SAE(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UDQ_RD_SAE(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2UDQ_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2UDQ_RD_SAE_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2UDQ_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2UDQ_RN_SAE(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UDQ_RN_SAE(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2UDQ_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2UDQ_RN_SAE_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2UDQ_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2UDQ_RU_SAE(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UDQ_RU_SAE(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2UDQ_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2UDQ_RU_SAE_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2UDQ_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2UDQ_RZ_SAE(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UDQ_RZ_SAE(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2UDQ_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2UDQ_RZ_SAE_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2UDQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2UDQ_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UDQ_Z(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UDQ_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UDQ_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UDQ_Z(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UDQ_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2UQQValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2UQQ(opm128, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UQQ(opm128, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UQQ(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UQQ(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UQQ(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UQQ(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UQQ(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UQQ(opxmm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UQQ(opm256, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UQQ(opm256, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UQQ(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UQQ(opymm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2UQQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2UQQ_BCST(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UQQ_BCST(opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UQQ_BCST(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UQQ_BCST(opm32, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UQQ_BCST(opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UQQ_BCST(opm32, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2UQQ_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2UQQ_BCST_Z(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UQQ_BCST_Z(opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UQQ_BCST_Z(opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2UQQ_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2UQQ_RD_SAE(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UQQ_RD_SAE(opymm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2UQQ_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2UQQ_RD_SAE_Z(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2UQQ_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2UQQ_RN_SAE(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UQQ_RN_SAE(opymm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2UQQ_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2UQQ_RN_SAE_Z(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2UQQ_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2UQQ_RU_SAE(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UQQ_RU_SAE(opymm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2UQQ_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2UQQ_RU_SAE_Z(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2UQQ_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2UQQ_RZ_SAE(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UQQ_RZ_SAE(opymm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2UQQ_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2UQQ_RZ_SAE_Z(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTPS2UQQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTPS2UQQ_Z(opm128, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UQQ_Z(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UQQ_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UQQ_Z(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UQQ_Z(opm256, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTPS2UQQ_Z(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTQQ2PDValidFormsNoError(t *testing.T) {
	if _, err := VCVTQQ2PD(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTQQ2PD(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTQQ2PD(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTQQ2PD(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTQQ2PD(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTQQ2PD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTQQ2PD(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTQQ2PD(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTQQ2PD(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTQQ2PD(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTQQ2PD(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTQQ2PD(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTQQ2PD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VCVTQQ2PD_BCST(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTQQ2PD_BCST(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTQQ2PD_BCST(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTQQ2PD_BCST(opm64, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTQQ2PD_BCST(opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTQQ2PD_BCST(opm64, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTQQ2PD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTQQ2PD_BCST_Z(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTQQ2PD_BCST_Z(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTQQ2PD_BCST_Z(opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTQQ2PD_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTQQ2PD_RD_SAE(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTQQ2PD_RD_SAE(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTQQ2PD_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTQQ2PD_RD_SAE_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTQQ2PD_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTQQ2PD_RN_SAE(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTQQ2PD_RN_SAE(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTQQ2PD_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTQQ2PD_RN_SAE_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTQQ2PD_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTQQ2PD_RU_SAE(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTQQ2PD_RU_SAE(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTQQ2PD_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTQQ2PD_RU_SAE_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTQQ2PD_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTQQ2PD_RZ_SAE(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTQQ2PD_RZ_SAE(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTQQ2PD_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTQQ2PD_RZ_SAE_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTQQ2PD_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTQQ2PD_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTQQ2PD_Z(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTQQ2PD_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTQQ2PD_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTQQ2PD_Z(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTQQ2PD_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTQQ2PSValidFormsNoError(t *testing.T) {
	if _, err := VCVTQQ2PS(opm512, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTQQ2PS(opm512, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTQQ2PS(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTQQ2PS(opzmm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTQQ2PSXValidFormsNoError(t *testing.T) {
	if _, err := VCVTQQ2PSX(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTQQ2PSX(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTQQ2PSX(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTQQ2PSX(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTQQ2PSX_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VCVTQQ2PSX_BCST(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTQQ2PSX_BCST(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTQQ2PSX_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTQQ2PSX_BCST_Z(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTQQ2PSX_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTQQ2PSX_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTQQ2PSX_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTQQ2PSYValidFormsNoError(t *testing.T) {
	if _, err := VCVTQQ2PSY(opm256, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTQQ2PSY(opm256, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTQQ2PSY(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTQQ2PSY(opymm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTQQ2PSY_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VCVTQQ2PSY_BCST(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTQQ2PSY_BCST(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTQQ2PSY_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTQQ2PSY_BCST_Z(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTQQ2PSY_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTQQ2PSY_Z(opm256, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTQQ2PSY_Z(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTQQ2PS_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VCVTQQ2PS_BCST(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTQQ2PS_BCST(opm64, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTQQ2PS_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTQQ2PS_BCST_Z(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTQQ2PS_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTQQ2PS_RD_SAE(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTQQ2PS_RD_SAE(opzmm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTQQ2PS_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTQQ2PS_RD_SAE_Z(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTQQ2PS_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTQQ2PS_RN_SAE(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTQQ2PS_RN_SAE(opzmm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTQQ2PS_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTQQ2PS_RN_SAE_Z(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTQQ2PS_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTQQ2PS_RU_SAE(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTQQ2PS_RU_SAE(opzmm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTQQ2PS_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTQQ2PS_RU_SAE_Z(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTQQ2PS_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTQQ2PS_RZ_SAE(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTQQ2PS_RZ_SAE(opzmm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTQQ2PS_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTQQ2PS_RZ_SAE_Z(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTQQ2PS_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTQQ2PS_Z(opm512, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTQQ2PS_Z(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSD2SIValidFormsNoError(t *testing.T) {
	if _, err := VCVTSD2SI(opm64, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTSD2SI(opxmm, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSD2SIQValidFormsNoError(t *testing.T) {
	if _, err := VCVTSD2SIQ(opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTSD2SIQ(opxmm, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSD2SIQ_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSD2SIQ_RD_SAE(opxmm, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSD2SIQ_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSD2SIQ_RN_SAE(opxmm, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSD2SIQ_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSD2SIQ_RU_SAE(opxmm, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSD2SIQ_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSD2SIQ_RZ_SAE(opxmm, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSD2SI_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSD2SI_RD_SAE(opxmm, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSD2SI_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSD2SI_RN_SAE(opxmm, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSD2SI_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSD2SI_RU_SAE(opxmm, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSD2SI_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSD2SI_RZ_SAE(opxmm, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSD2SSValidFormsNoError(t *testing.T) {
	if _, err := VCVTSD2SS(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTSD2SS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTSD2SS(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTSD2SS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSD2SS_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSD2SS_RD_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTSD2SS_RD_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSD2SS_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTSD2SS_RD_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSD2SS_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSD2SS_RN_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTSD2SS_RN_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSD2SS_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTSD2SS_RN_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSD2SS_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSD2SS_RU_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTSD2SS_RU_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSD2SS_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTSD2SS_RU_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSD2SS_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSD2SS_RZ_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTSD2SS_RZ_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSD2SS_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTSD2SS_RZ_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSD2SS_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTSD2SS_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTSD2SS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSD2USILValidFormsNoError(t *testing.T) {
	if _, err := VCVTSD2USIL(opm64, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTSD2USIL(opxmm, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSD2USIL_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSD2USIL_RD_SAE(opxmm, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSD2USIL_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSD2USIL_RN_SAE(opxmm, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSD2USIL_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSD2USIL_RU_SAE(opxmm, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSD2USIL_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSD2USIL_RZ_SAE(opxmm, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSD2USIQValidFormsNoError(t *testing.T) {
	if _, err := VCVTSD2USIQ(opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTSD2USIQ(opxmm, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSD2USIQ_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSD2USIQ_RD_SAE(opxmm, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSD2USIQ_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSD2USIQ_RN_SAE(opxmm, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSD2USIQ_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSD2USIQ_RU_SAE(opxmm, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSD2USIQ_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSD2USIQ_RZ_SAE(opxmm, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSI2SDLValidFormsNoError(t *testing.T) {
	if _, err := VCVTSI2SDL(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTSI2SDL(opr32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSI2SDQValidFormsNoError(t *testing.T) {
	if _, err := VCVTSI2SDQ(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTSI2SDQ(opr64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSI2SDQ_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSI2SDQ_RD_SAE(opr64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSI2SDQ_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSI2SDQ_RN_SAE(opr64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSI2SDQ_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSI2SDQ_RU_SAE(opr64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSI2SDQ_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSI2SDQ_RZ_SAE(opr64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSI2SSLValidFormsNoError(t *testing.T) {
	if _, err := VCVTSI2SSL(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTSI2SSL(opr32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSI2SSL_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSI2SSL_RD_SAE(opr32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSI2SSL_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSI2SSL_RN_SAE(opr32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSI2SSL_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSI2SSL_RU_SAE(opr32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSI2SSL_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSI2SSL_RZ_SAE(opr32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSI2SSQValidFormsNoError(t *testing.T) {
	if _, err := VCVTSI2SSQ(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTSI2SSQ(opr64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSI2SSQ_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSI2SSQ_RD_SAE(opr64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSI2SSQ_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSI2SSQ_RN_SAE(opr64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSI2SSQ_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSI2SSQ_RU_SAE(opr64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSI2SSQ_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSI2SSQ_RZ_SAE(opr64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSS2SDValidFormsNoError(t *testing.T) {
	if _, err := VCVTSS2SD(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTSS2SD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTSS2SD(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTSS2SD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSS2SD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSS2SD_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTSS2SD_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSS2SD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTSS2SD_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSS2SD_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTSS2SD_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTSS2SD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSS2SIValidFormsNoError(t *testing.T) {
	if _, err := VCVTSS2SI(opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTSS2SI(opxmm, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSS2SIQValidFormsNoError(t *testing.T) {
	if _, err := VCVTSS2SIQ(opm32, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTSS2SIQ(opxmm, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSS2SIQ_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSS2SIQ_RD_SAE(opxmm, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSS2SIQ_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSS2SIQ_RN_SAE(opxmm, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSS2SIQ_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSS2SIQ_RU_SAE(opxmm, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSS2SIQ_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSS2SIQ_RZ_SAE(opxmm, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSS2SI_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSS2SI_RD_SAE(opxmm, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSS2SI_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSS2SI_RN_SAE(opxmm, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSS2SI_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSS2SI_RU_SAE(opxmm, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSS2SI_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSS2SI_RZ_SAE(opxmm, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSS2USILValidFormsNoError(t *testing.T) {
	if _, err := VCVTSS2USIL(opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTSS2USIL(opxmm, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSS2USIL_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSS2USIL_RD_SAE(opxmm, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSS2USIL_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSS2USIL_RN_SAE(opxmm, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSS2USIL_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSS2USIL_RU_SAE(opxmm, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSS2USIL_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSS2USIL_RZ_SAE(opxmm, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSS2USIQValidFormsNoError(t *testing.T) {
	if _, err := VCVTSS2USIQ(opm32, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTSS2USIQ(opxmm, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSS2USIQ_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSS2USIQ_RD_SAE(opxmm, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSS2USIQ_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSS2USIQ_RN_SAE(opxmm, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSS2USIQ_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSS2USIQ_RU_SAE(opxmm, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTSS2USIQ_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTSS2USIQ_RZ_SAE(opxmm, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPD2DQValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPD2DQ(opm512, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2DQ(opm512, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2DQ(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2DQ(opzmm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPD2DQXValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPD2DQX(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2DQX(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2DQX(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2DQX(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPD2DQX_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPD2DQX_BCST(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2DQX_BCST(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPD2DQX_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPD2DQX_BCST_Z(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPD2DQX_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPD2DQX_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2DQX_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPD2DQYValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPD2DQY(opm256, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2DQY(opymm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2DQY(opm256, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2DQY(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPD2DQY_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPD2DQY_BCST(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2DQY_BCST(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPD2DQY_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPD2DQY_BCST_Z(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPD2DQY_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPD2DQY_Z(opm256, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2DQY_Z(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPD2DQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPD2DQ_BCST(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2DQ_BCST(opm64, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPD2DQ_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPD2DQ_BCST_Z(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPD2DQ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPD2DQ_SAE(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2DQ_SAE(opzmm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPD2DQ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPD2DQ_SAE_Z(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPD2DQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPD2DQ_Z(opm512, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2DQ_Z(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPD2QQValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPD2QQ(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2QQ(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2QQ(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2QQ(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2QQ(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2QQ(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2QQ(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2QQ(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2QQ(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2QQ(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2QQ(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2QQ(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPD2QQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPD2QQ_BCST(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2QQ_BCST(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2QQ_BCST(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2QQ_BCST(opm64, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2QQ_BCST(opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2QQ_BCST(opm64, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPD2QQ_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPD2QQ_BCST_Z(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2QQ_BCST_Z(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2QQ_BCST_Z(opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPD2QQ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPD2QQ_SAE(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2QQ_SAE(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPD2QQ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPD2QQ_SAE_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPD2QQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPD2QQ_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2QQ_Z(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2QQ_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2QQ_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2QQ_Z(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2QQ_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPD2UDQValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPD2UDQ(opm512, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2UDQ(opm512, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2UDQ(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2UDQ(opzmm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPD2UDQXValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPD2UDQX(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2UDQX(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2UDQX(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2UDQX(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPD2UDQX_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPD2UDQX_BCST(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2UDQX_BCST(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPD2UDQX_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPD2UDQX_BCST_Z(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPD2UDQX_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPD2UDQX_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2UDQX_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPD2UDQYValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPD2UDQY(opm256, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2UDQY(opm256, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2UDQY(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2UDQY(opymm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPD2UDQY_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPD2UDQY_BCST(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2UDQY_BCST(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPD2UDQY_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPD2UDQY_BCST_Z(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPD2UDQY_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPD2UDQY_Z(opm256, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2UDQY_Z(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPD2UDQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPD2UDQ_BCST(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2UDQ_BCST(opm64, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPD2UDQ_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPD2UDQ_BCST_Z(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPD2UDQ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPD2UDQ_SAE(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2UDQ_SAE(opzmm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPD2UDQ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPD2UDQ_SAE_Z(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPD2UDQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPD2UDQ_Z(opm512, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2UDQ_Z(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPD2UQQValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPD2UQQ(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2UQQ(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2UQQ(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2UQQ(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2UQQ(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2UQQ(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2UQQ(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2UQQ(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2UQQ(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2UQQ(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2UQQ(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2UQQ(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPD2UQQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPD2UQQ_BCST(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2UQQ_BCST(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2UQQ_BCST(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2UQQ_BCST(opm64, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2UQQ_BCST(opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2UQQ_BCST(opm64, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPD2UQQ_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPD2UQQ_BCST_Z(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2UQQ_BCST_Z(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2UQQ_BCST_Z(opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPD2UQQ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPD2UQQ_SAE(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2UQQ_SAE(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPD2UQQ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPD2UQQ_SAE_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPD2UQQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPD2UQQ_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2UQQ_Z(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2UQQ_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2UQQ_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2UQQ_Z(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPD2UQQ_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPS2DQValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPS2DQ(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2DQ(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2DQ(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2DQ(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2DQ(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2DQ(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2DQ(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2DQ(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2DQ(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2DQ(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2DQ(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2DQ(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPS2DQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPS2DQ_BCST(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2DQ_BCST(opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2DQ_BCST(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2DQ_BCST(opm32, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2DQ_BCST(opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2DQ_BCST(opm32, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPS2DQ_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPS2DQ_BCST_Z(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2DQ_BCST_Z(opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2DQ_BCST_Z(opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPS2DQ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPS2DQ_SAE(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2DQ_SAE(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPS2DQ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPS2DQ_SAE_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPS2DQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPS2DQ_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2DQ_Z(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2DQ_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2DQ_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2DQ_Z(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2DQ_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPS2QQValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPS2QQ(opm128, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2QQ(opm128, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2QQ(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2QQ(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2QQ(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2QQ(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2QQ(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2QQ(opxmm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2QQ(opm256, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2QQ(opm256, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2QQ(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2QQ(opymm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPS2QQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPS2QQ_BCST(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2QQ_BCST(opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2QQ_BCST(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2QQ_BCST(opm32, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2QQ_BCST(opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2QQ_BCST(opm32, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPS2QQ_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPS2QQ_BCST_Z(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2QQ_BCST_Z(opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2QQ_BCST_Z(opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPS2QQ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPS2QQ_SAE(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2QQ_SAE(opymm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPS2QQ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPS2QQ_SAE_Z(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPS2QQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPS2QQ_Z(opm128, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2QQ_Z(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2QQ_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2QQ_Z(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2QQ_Z(opm256, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2QQ_Z(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPS2UDQValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPS2UDQ(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UDQ(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UDQ(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UDQ(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UDQ(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UDQ(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UDQ(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UDQ(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UDQ(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UDQ(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UDQ(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UDQ(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPS2UDQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPS2UDQ_BCST(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UDQ_BCST(opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UDQ_BCST(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UDQ_BCST(opm32, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UDQ_BCST(opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UDQ_BCST(opm32, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPS2UDQ_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPS2UDQ_BCST_Z(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UDQ_BCST_Z(opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UDQ_BCST_Z(opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPS2UDQ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPS2UDQ_SAE(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UDQ_SAE(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPS2UDQ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPS2UDQ_SAE_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPS2UDQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPS2UDQ_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UDQ_Z(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UDQ_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UDQ_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UDQ_Z(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UDQ_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPS2UQQValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPS2UQQ(opm128, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UQQ(opm128, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UQQ(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UQQ(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UQQ(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UQQ(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UQQ(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UQQ(opxmm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UQQ(opm256, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UQQ(opm256, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UQQ(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UQQ(opymm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPS2UQQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPS2UQQ_BCST(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UQQ_BCST(opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UQQ_BCST(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UQQ_BCST(opm32, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UQQ_BCST(opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UQQ_BCST(opm32, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPS2UQQ_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPS2UQQ_BCST_Z(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UQQ_BCST_Z(opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UQQ_BCST_Z(opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPS2UQQ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPS2UQQ_SAE(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UQQ_SAE(opymm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPS2UQQ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPS2UQQ_SAE_Z(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTPS2UQQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTTPS2UQQ_Z(opm128, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UQQ_Z(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UQQ_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UQQ_Z(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UQQ_Z(opm256, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTPS2UQQ_Z(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTSD2SIValidFormsNoError(t *testing.T) {
	if _, err := VCVTTSD2SI(opm64, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTSD2SI(opxmm, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTSD2SIQValidFormsNoError(t *testing.T) {
	if _, err := VCVTTSD2SIQ(opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTSD2SIQ(opxmm, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTSD2SIQ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTTSD2SIQ_SAE(opxmm, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTSD2SI_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTTSD2SI_SAE(opxmm, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTSD2USILValidFormsNoError(t *testing.T) {
	if _, err := VCVTTSD2USIL(opm64, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTSD2USIL(opxmm, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTSD2USIL_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTTSD2USIL_SAE(opxmm, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTSD2USIQValidFormsNoError(t *testing.T) {
	if _, err := VCVTTSD2USIQ(opm64, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTSD2USIQ(opxmm, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTSD2USIQ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTTSD2USIQ_SAE(opxmm, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTSS2SIValidFormsNoError(t *testing.T) {
	if _, err := VCVTTSS2SI(opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTSS2SI(opxmm, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTSS2SIQValidFormsNoError(t *testing.T) {
	if _, err := VCVTTSS2SIQ(opm32, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTSS2SIQ(opxmm, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTSS2SIQ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTTSS2SIQ_SAE(opxmm, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTSS2SI_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTTSS2SI_SAE(opxmm, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTSS2USILValidFormsNoError(t *testing.T) {
	if _, err := VCVTTSS2USIL(opm32, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTSS2USIL(opxmm, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTSS2USIL_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTTSS2USIL_SAE(opxmm, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTSS2USIQValidFormsNoError(t *testing.T) {
	if _, err := VCVTTSS2USIQ(opm32, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTTSS2USIQ(opxmm, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTTSS2USIQ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTTSS2USIQ_SAE(opxmm, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUDQ2PDValidFormsNoError(t *testing.T) {
	if _, err := VCVTUDQ2PD(opm128, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PD(opm128, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PD(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PD(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PD(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PD(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PD(opxmm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PD(opm256, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PD(opm256, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PD(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PD(opymm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUDQ2PD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VCVTUDQ2PD_BCST(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PD_BCST(opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PD_BCST(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PD_BCST(opm32, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PD_BCST(opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PD_BCST(opm32, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUDQ2PD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTUDQ2PD_BCST_Z(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PD_BCST_Z(opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PD_BCST_Z(opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUDQ2PD_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTUDQ2PD_Z(opm128, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PD_Z(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PD_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PD_Z(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PD_Z(opm256, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PD_Z(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUDQ2PSValidFormsNoError(t *testing.T) {
	if _, err := VCVTUDQ2PS(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PS(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PS(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PS(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PS(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PS(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PS(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PS(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PS(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PS(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PS(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PS(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUDQ2PS_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VCVTUDQ2PS_BCST(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PS_BCST(opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PS_BCST(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PS_BCST(opm32, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PS_BCST(opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PS_BCST(opm32, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUDQ2PS_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTUDQ2PS_BCST_Z(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PS_BCST_Z(opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PS_BCST_Z(opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUDQ2PS_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTUDQ2PS_RD_SAE(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PS_RD_SAE(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUDQ2PS_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTUDQ2PS_RD_SAE_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUDQ2PS_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTUDQ2PS_RN_SAE(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PS_RN_SAE(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUDQ2PS_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTUDQ2PS_RN_SAE_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUDQ2PS_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTUDQ2PS_RU_SAE(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PS_RU_SAE(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUDQ2PS_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTUDQ2PS_RU_SAE_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUDQ2PS_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTUDQ2PS_RZ_SAE(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PS_RZ_SAE(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUDQ2PS_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTUDQ2PS_RZ_SAE_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUDQ2PS_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTUDQ2PS_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PS_Z(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PS_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PS_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PS_Z(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUDQ2PS_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUQQ2PDValidFormsNoError(t *testing.T) {
	if _, err := VCVTUQQ2PD(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUQQ2PD(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUQQ2PD(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUQQ2PD(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUQQ2PD(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUQQ2PD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUQQ2PD(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUQQ2PD(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUQQ2PD(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUQQ2PD(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUQQ2PD(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUQQ2PD(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUQQ2PD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VCVTUQQ2PD_BCST(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUQQ2PD_BCST(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUQQ2PD_BCST(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUQQ2PD_BCST(opm64, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUQQ2PD_BCST(opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUQQ2PD_BCST(opm64, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUQQ2PD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTUQQ2PD_BCST_Z(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUQQ2PD_BCST_Z(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUQQ2PD_BCST_Z(opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUQQ2PD_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTUQQ2PD_RD_SAE(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUQQ2PD_RD_SAE(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUQQ2PD_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTUQQ2PD_RD_SAE_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUQQ2PD_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTUQQ2PD_RN_SAE(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUQQ2PD_RN_SAE(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUQQ2PD_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTUQQ2PD_RN_SAE_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUQQ2PD_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTUQQ2PD_RU_SAE(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUQQ2PD_RU_SAE(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUQQ2PD_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTUQQ2PD_RU_SAE_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUQQ2PD_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTUQQ2PD_RZ_SAE(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUQQ2PD_RZ_SAE(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUQQ2PD_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTUQQ2PD_RZ_SAE_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUQQ2PD_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTUQQ2PD_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUQQ2PD_Z(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUQQ2PD_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUQQ2PD_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUQQ2PD_Z(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUQQ2PD_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUQQ2PSValidFormsNoError(t *testing.T) {
	if _, err := VCVTUQQ2PS(opm512, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUQQ2PS(opm512, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUQQ2PS(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUQQ2PS(opzmm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUQQ2PSXValidFormsNoError(t *testing.T) {
	if _, err := VCVTUQQ2PSX(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUQQ2PSX(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUQQ2PSX(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUQQ2PSX(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUQQ2PSX_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VCVTUQQ2PSX_BCST(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUQQ2PSX_BCST(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUQQ2PSX_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTUQQ2PSX_BCST_Z(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUQQ2PSX_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTUQQ2PSX_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUQQ2PSX_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUQQ2PSYValidFormsNoError(t *testing.T) {
	if _, err := VCVTUQQ2PSY(opm256, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUQQ2PSY(opm256, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUQQ2PSY(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUQQ2PSY(opymm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUQQ2PSY_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VCVTUQQ2PSY_BCST(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUQQ2PSY_BCST(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUQQ2PSY_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTUQQ2PSY_BCST_Z(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUQQ2PSY_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTUQQ2PSY_Z(opm256, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUQQ2PSY_Z(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUQQ2PS_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VCVTUQQ2PS_BCST(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUQQ2PS_BCST(opm64, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUQQ2PS_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTUQQ2PS_BCST_Z(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUQQ2PS_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTUQQ2PS_RD_SAE(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUQQ2PS_RD_SAE(opzmm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUQQ2PS_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTUQQ2PS_RD_SAE_Z(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUQQ2PS_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTUQQ2PS_RN_SAE(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUQQ2PS_RN_SAE(opzmm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUQQ2PS_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTUQQ2PS_RN_SAE_Z(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUQQ2PS_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTUQQ2PS_RU_SAE(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUQQ2PS_RU_SAE(opzmm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUQQ2PS_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTUQQ2PS_RU_SAE_Z(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUQQ2PS_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTUQQ2PS_RZ_SAE(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUQQ2PS_RZ_SAE(opzmm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUQQ2PS_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTUQQ2PS_RZ_SAE_Z(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUQQ2PS_ZValidFormsNoError(t *testing.T) {
	if _, err := VCVTUQQ2PS_Z(opm512, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUQQ2PS_Z(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUSI2SDLValidFormsNoError(t *testing.T) {
	if _, err := VCVTUSI2SDL(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUSI2SDL(opr32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUSI2SDQValidFormsNoError(t *testing.T) {
	if _, err := VCVTUSI2SDQ(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUSI2SDQ(opr64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUSI2SDQ_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTUSI2SDQ_RD_SAE(opr64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUSI2SDQ_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTUSI2SDQ_RN_SAE(opr64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUSI2SDQ_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTUSI2SDQ_RU_SAE(opr64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUSI2SDQ_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTUSI2SDQ_RZ_SAE(opr64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUSI2SSLValidFormsNoError(t *testing.T) {
	if _, err := VCVTUSI2SSL(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUSI2SSL(opr32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUSI2SSL_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTUSI2SSL_RD_SAE(opr32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUSI2SSL_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTUSI2SSL_RN_SAE(opr32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUSI2SSL_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTUSI2SSL_RU_SAE(opr32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUSI2SSL_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTUSI2SSL_RZ_SAE(opr32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUSI2SSQValidFormsNoError(t *testing.T) {
	if _, err := VCVTUSI2SSQ(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VCVTUSI2SSQ(opr64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUSI2SSQ_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTUSI2SSQ_RD_SAE(opr64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUSI2SSQ_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTUSI2SSQ_RN_SAE(opr64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUSI2SSQ_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTUSI2SSQ_RU_SAE(opr64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVCVTUSI2SSQ_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VCVTUSI2SSQ_RZ_SAE(opr64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDBPSADBWValidFormsNoError(t *testing.T) {
	if _, err := VDBPSADBW(opimm8, opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDBPSADBW(opimm8, opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDBPSADBW(opimm8, opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDBPSADBW(opimm8, opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDBPSADBW(opimm8, opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDBPSADBW(opimm8, opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDBPSADBW(opimm8, opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDBPSADBW(opimm8, opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDBPSADBW(opimm8, opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDBPSADBW(opimm8, opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDBPSADBW(opimm8, opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDBPSADBW(opimm8, opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDBPSADBW_ZValidFormsNoError(t *testing.T) {
	if _, err := VDBPSADBW_Z(opimm8, opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDBPSADBW_Z(opimm8, opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDBPSADBW_Z(opimm8, opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDBPSADBW_Z(opimm8, opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDBPSADBW_Z(opimm8, opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDBPSADBW_Z(opimm8, opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDIVPDValidFormsNoError(t *testing.T) {
	if _, err := VDIVPD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPD(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDIVPD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VDIVPD_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPD_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPD_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPD_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPD_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPD_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDIVPD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VDIVPD_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPD_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPD_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDIVPD_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VDIVPD_RD_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPD_RD_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDIVPD_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VDIVPD_RD_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDIVPD_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VDIVPD_RN_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPD_RN_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDIVPD_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VDIVPD_RN_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDIVPD_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VDIVPD_RU_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPD_RU_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDIVPD_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VDIVPD_RU_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDIVPD_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VDIVPD_RZ_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPD_RZ_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDIVPD_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VDIVPD_RZ_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDIVPD_ZValidFormsNoError(t *testing.T) {
	if _, err := VDIVPD_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDIVPSValidFormsNoError(t *testing.T) {
	if _, err := VDIVPS(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPS(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPS(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPS(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPS(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPS(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPS(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPS(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPS(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPS(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDIVPS_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VDIVPS_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPS_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPS_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPS_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPS_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPS_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDIVPS_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VDIVPS_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPS_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPS_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDIVPS_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VDIVPS_RD_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPS_RD_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDIVPS_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VDIVPS_RD_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDIVPS_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VDIVPS_RN_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPS_RN_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDIVPS_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VDIVPS_RN_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDIVPS_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VDIVPS_RU_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPS_RU_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDIVPS_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VDIVPS_RU_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDIVPS_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VDIVPS_RZ_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPS_RZ_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDIVPS_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VDIVPS_RZ_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDIVPS_ZValidFormsNoError(t *testing.T) {
	if _, err := VDIVPS_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPS_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPS_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPS_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVPS_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDIVSDValidFormsNoError(t *testing.T) {
	if _, err := VDIVSD(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVSD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVSD(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVSD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDIVSD_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VDIVSD_RD_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVSD_RD_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDIVSD_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VDIVSD_RD_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDIVSD_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VDIVSD_RN_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVSD_RN_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDIVSD_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VDIVSD_RN_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDIVSD_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VDIVSD_RU_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVSD_RU_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDIVSD_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VDIVSD_RU_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDIVSD_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VDIVSD_RZ_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVSD_RZ_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDIVSD_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VDIVSD_RZ_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDIVSD_ZValidFormsNoError(t *testing.T) {
	if _, err := VDIVSD_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVSD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDIVSSValidFormsNoError(t *testing.T) {
	if _, err := VDIVSS(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVSS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVSS(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVSS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDIVSS_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VDIVSS_RD_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVSS_RD_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDIVSS_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VDIVSS_RD_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDIVSS_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VDIVSS_RN_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVSS_RN_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDIVSS_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VDIVSS_RN_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDIVSS_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VDIVSS_RU_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVSS_RU_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDIVSS_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VDIVSS_RU_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDIVSS_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VDIVSS_RZ_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVSS_RZ_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDIVSS_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VDIVSS_RZ_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDIVSS_ZValidFormsNoError(t *testing.T) {
	if _, err := VDIVSS_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDIVSS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDPPDValidFormsNoError(t *testing.T) {
	if _, err := VDPPD(opimm8, opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDPPD(opimm8, opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVDPPSValidFormsNoError(t *testing.T) {
	if _, err := VDPPS(opimm8, opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDPPS(opimm8, opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDPPS(opimm8, opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VDPPS(opimm8, opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVEXP2PDValidFormsNoError(t *testing.T) {
	if _, err := VEXP2PD(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXP2PD(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXP2PD(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXP2PD(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVEXP2PD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VEXP2PD_BCST(opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXP2PD_BCST(opm64, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVEXP2PD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VEXP2PD_BCST_Z(opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVEXP2PD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VEXP2PD_SAE(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXP2PD_SAE(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVEXP2PD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VEXP2PD_SAE_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVEXP2PD_ZValidFormsNoError(t *testing.T) {
	if _, err := VEXP2PD_Z(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXP2PD_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVEXP2PSValidFormsNoError(t *testing.T) {
	if _, err := VEXP2PS(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXP2PS(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXP2PS(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXP2PS(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVEXP2PS_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VEXP2PS_BCST(opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXP2PS_BCST(opm32, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVEXP2PS_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VEXP2PS_BCST_Z(opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVEXP2PS_SAEValidFormsNoError(t *testing.T) {
	if _, err := VEXP2PS_SAE(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXP2PS_SAE(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVEXP2PS_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VEXP2PS_SAE_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVEXP2PS_ZValidFormsNoError(t *testing.T) {
	if _, err := VEXP2PS_Z(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXP2PS_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVEXPANDPDValidFormsNoError(t *testing.T) {
	if _, err := VEXPANDPD(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXPANDPD(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXPANDPD(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXPANDPD(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXPANDPD(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXPANDPD(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXPANDPD(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXPANDPD(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXPANDPD(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXPANDPD(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXPANDPD(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXPANDPD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVEXPANDPD_ZValidFormsNoError(t *testing.T) {
	if _, err := VEXPANDPD_Z(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXPANDPD_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXPANDPD_Z(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXPANDPD_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXPANDPD_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXPANDPD_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVEXPANDPSValidFormsNoError(t *testing.T) {
	if _, err := VEXPANDPS(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXPANDPS(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXPANDPS(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXPANDPS(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXPANDPS(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXPANDPS(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXPANDPS(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXPANDPS(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXPANDPS(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXPANDPS(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXPANDPS(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXPANDPS(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVEXPANDPS_ZValidFormsNoError(t *testing.T) {
	if _, err := VEXPANDPS_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXPANDPS_Z(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXPANDPS_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXPANDPS_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXPANDPS_Z(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXPANDPS_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVEXTRACTF128ValidFormsNoError(t *testing.T) {
	if _, err := VEXTRACTF128(opimm8, opymm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTF128(opimm8, opymm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVEXTRACTF32X4ValidFormsNoError(t *testing.T) {
	if _, err := VEXTRACTF32X4(opimm8, opymm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTF32X4(opimm8, opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTF32X4(opimm8, opymm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTF32X4(opimm8, opymm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTF32X4(opimm8, opzmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTF32X4(opimm8, opzmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTF32X4(opimm8, opzmm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTF32X4(opimm8, opzmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVEXTRACTF32X4_ZValidFormsNoError(t *testing.T) {
	if _, err := VEXTRACTF32X4_Z(opimm8, opymm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTF32X4_Z(opimm8, opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTF32X4_Z(opimm8, opzmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTF32X4_Z(opimm8, opzmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVEXTRACTF32X8ValidFormsNoError(t *testing.T) {
	if _, err := VEXTRACTF32X8(opimm8, opzmm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTF32X8(opimm8, opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTF32X8(opimm8, opzmm, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTF32X8(opimm8, opzmm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVEXTRACTF32X8_ZValidFormsNoError(t *testing.T) {
	if _, err := VEXTRACTF32X8_Z(opimm8, opzmm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTF32X8_Z(opimm8, opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVEXTRACTF64X2ValidFormsNoError(t *testing.T) {
	if _, err := VEXTRACTF64X2(opimm8, opymm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTF64X2(opimm8, opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTF64X2(opimm8, opymm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTF64X2(opimm8, opymm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTF64X2(opimm8, opzmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTF64X2(opimm8, opzmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTF64X2(opimm8, opzmm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTF64X2(opimm8, opzmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVEXTRACTF64X2_ZValidFormsNoError(t *testing.T) {
	if _, err := VEXTRACTF64X2_Z(opimm8, opymm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTF64X2_Z(opimm8, opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTF64X2_Z(opimm8, opzmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTF64X2_Z(opimm8, opzmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVEXTRACTF64X4ValidFormsNoError(t *testing.T) {
	if _, err := VEXTRACTF64X4(opimm8, opzmm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTF64X4(opimm8, opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTF64X4(opimm8, opzmm, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTF64X4(opimm8, opzmm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVEXTRACTF64X4_ZValidFormsNoError(t *testing.T) {
	if _, err := VEXTRACTF64X4_Z(opimm8, opzmm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTF64X4_Z(opimm8, opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVEXTRACTI128ValidFormsNoError(t *testing.T) {
	if _, err := VEXTRACTI128(opimm8, opymm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTI128(opimm8, opymm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVEXTRACTI32X4ValidFormsNoError(t *testing.T) {
	if _, err := VEXTRACTI32X4(opimm8, opymm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTI32X4(opimm8, opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTI32X4(opimm8, opymm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTI32X4(opimm8, opymm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTI32X4(opimm8, opzmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTI32X4(opimm8, opzmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTI32X4(opimm8, opzmm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTI32X4(opimm8, opzmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVEXTRACTI32X4_ZValidFormsNoError(t *testing.T) {
	if _, err := VEXTRACTI32X4_Z(opimm8, opymm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTI32X4_Z(opimm8, opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTI32X4_Z(opimm8, opzmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTI32X4_Z(opimm8, opzmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVEXTRACTI32X8ValidFormsNoError(t *testing.T) {
	if _, err := VEXTRACTI32X8(opimm8, opzmm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTI32X8(opimm8, opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTI32X8(opimm8, opzmm, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTI32X8(opimm8, opzmm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVEXTRACTI32X8_ZValidFormsNoError(t *testing.T) {
	if _, err := VEXTRACTI32X8_Z(opimm8, opzmm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTI32X8_Z(opimm8, opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVEXTRACTI64X2ValidFormsNoError(t *testing.T) {
	if _, err := VEXTRACTI64X2(opimm8, opymm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTI64X2(opimm8, opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTI64X2(opimm8, opymm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTI64X2(opimm8, opymm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTI64X2(opimm8, opzmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTI64X2(opimm8, opzmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTI64X2(opimm8, opzmm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTI64X2(opimm8, opzmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVEXTRACTI64X2_ZValidFormsNoError(t *testing.T) {
	if _, err := VEXTRACTI64X2_Z(opimm8, opymm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTI64X2_Z(opimm8, opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTI64X2_Z(opimm8, opzmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTI64X2_Z(opimm8, opzmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVEXTRACTI64X4ValidFormsNoError(t *testing.T) {
	if _, err := VEXTRACTI64X4(opimm8, opzmm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTI64X4(opimm8, opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTI64X4(opimm8, opzmm, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTI64X4(opimm8, opzmm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVEXTRACTI64X4_ZValidFormsNoError(t *testing.T) {
	if _, err := VEXTRACTI64X4_Z(opimm8, opzmm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTI64X4_Z(opimm8, opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVEXTRACTPSValidFormsNoError(t *testing.T) {
	if _, err := VEXTRACTPS(opimm8, opxmm, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := VEXTRACTPS(opimm8, opxmm, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestVFIXUPIMMPDValidFormsNoError(t *testing.T) {
	if _, err := VFIXUPIMMPD(opimm8, opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPD(opimm8, opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPD(opimm8, opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPD(opimm8, opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPD(opimm8, opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPD(opimm8, opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPD(opimm8, opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPD(opimm8, opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPD(opimm8, opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPD(opimm8, opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPD(opimm8, opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPD(opimm8, opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFIXUPIMMPD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VFIXUPIMMPD_BCST(opimm8, opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPD_BCST(opimm8, opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPD_BCST(opimm8, opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPD_BCST(opimm8, opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPD_BCST(opimm8, opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPD_BCST(opimm8, opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFIXUPIMMPD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VFIXUPIMMPD_BCST_Z(opimm8, opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPD_BCST_Z(opimm8, opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPD_BCST_Z(opimm8, opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFIXUPIMMPD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFIXUPIMMPD_SAE(opimm8, opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPD_SAE(opimm8, opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFIXUPIMMPD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFIXUPIMMPD_SAE_Z(opimm8, opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFIXUPIMMPD_ZValidFormsNoError(t *testing.T) {
	if _, err := VFIXUPIMMPD_Z(opimm8, opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPD_Z(opimm8, opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPD_Z(opimm8, opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPD_Z(opimm8, opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPD_Z(opimm8, opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPD_Z(opimm8, opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFIXUPIMMPSValidFormsNoError(t *testing.T) {
	if _, err := VFIXUPIMMPS(opimm8, opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPS(opimm8, opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPS(opimm8, opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPS(opimm8, opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPS(opimm8, opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPS(opimm8, opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPS(opimm8, opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPS(opimm8, opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPS(opimm8, opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPS(opimm8, opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPS(opimm8, opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPS(opimm8, opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFIXUPIMMPS_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VFIXUPIMMPS_BCST(opimm8, opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPS_BCST(opimm8, opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPS_BCST(opimm8, opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPS_BCST(opimm8, opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPS_BCST(opimm8, opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPS_BCST(opimm8, opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFIXUPIMMPS_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VFIXUPIMMPS_BCST_Z(opimm8, opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPS_BCST_Z(opimm8, opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPS_BCST_Z(opimm8, opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFIXUPIMMPS_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFIXUPIMMPS_SAE(opimm8, opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPS_SAE(opimm8, opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFIXUPIMMPS_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFIXUPIMMPS_SAE_Z(opimm8, opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFIXUPIMMPS_ZValidFormsNoError(t *testing.T) {
	if _, err := VFIXUPIMMPS_Z(opimm8, opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPS_Z(opimm8, opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPS_Z(opimm8, opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPS_Z(opimm8, opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPS_Z(opimm8, opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMPS_Z(opimm8, opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFIXUPIMMSDValidFormsNoError(t *testing.T) {
	if _, err := VFIXUPIMMSD(opimm8, opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMSD(opimm8, opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMSD(opimm8, opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMSD(opimm8, opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFIXUPIMMSD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFIXUPIMMSD_SAE(opimm8, opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMSD_SAE(opimm8, opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFIXUPIMMSD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFIXUPIMMSD_SAE_Z(opimm8, opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFIXUPIMMSD_ZValidFormsNoError(t *testing.T) {
	if _, err := VFIXUPIMMSD_Z(opimm8, opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMSD_Z(opimm8, opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFIXUPIMMSSValidFormsNoError(t *testing.T) {
	if _, err := VFIXUPIMMSS(opimm8, opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMSS(opimm8, opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMSS(opimm8, opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMSS(opimm8, opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFIXUPIMMSS_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFIXUPIMMSS_SAE(opimm8, opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMSS_SAE(opimm8, opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFIXUPIMMSS_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFIXUPIMMSS_SAE_Z(opimm8, opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFIXUPIMMSS_ZValidFormsNoError(t *testing.T) {
	if _, err := VFIXUPIMMSS_Z(opimm8, opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFIXUPIMMSS_Z(opimm8, opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD132PDValidFormsNoError(t *testing.T) {
	if _, err := VFMADD132PD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PD(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD132PD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VFMADD132PD_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PD_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PD_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PD_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PD_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PD_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD132PD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD132PD_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PD_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PD_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD132PD_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD132PD_RD_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PD_RD_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD132PD_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD132PD_RD_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD132PD_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD132PD_RN_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PD_RN_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD132PD_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD132PD_RN_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD132PD_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD132PD_RU_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PD_RU_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD132PD_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD132PD_RU_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD132PD_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD132PD_RZ_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PD_RZ_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD132PD_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD132PD_RZ_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD132PD_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD132PD_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD132PSValidFormsNoError(t *testing.T) {
	if _, err := VFMADD132PS(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PS(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PS(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PS(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PS(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PS(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PS(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PS(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PS(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PS(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD132PS_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VFMADD132PS_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PS_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PS_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PS_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PS_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PS_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD132PS_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD132PS_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PS_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PS_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD132PS_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD132PS_RD_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PS_RD_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD132PS_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD132PS_RD_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD132PS_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD132PS_RN_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PS_RN_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD132PS_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD132PS_RN_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD132PS_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD132PS_RU_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PS_RU_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD132PS_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD132PS_RU_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD132PS_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD132PS_RZ_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PS_RZ_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD132PS_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD132PS_RZ_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD132PS_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD132PS_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PS_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PS_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PS_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132PS_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD132SDValidFormsNoError(t *testing.T) {
	if _, err := VFMADD132SD(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132SD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132SD(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132SD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD132SD_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD132SD_RD_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132SD_RD_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD132SD_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD132SD_RD_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD132SD_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD132SD_RN_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132SD_RN_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD132SD_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD132SD_RN_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD132SD_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD132SD_RU_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132SD_RU_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD132SD_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD132SD_RU_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD132SD_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD132SD_RZ_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132SD_RZ_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD132SD_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD132SD_RZ_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD132SD_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD132SD_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132SD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD132SSValidFormsNoError(t *testing.T) {
	if _, err := VFMADD132SS(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132SS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132SS(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132SS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD132SS_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD132SS_RD_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132SS_RD_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD132SS_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD132SS_RD_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD132SS_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD132SS_RN_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132SS_RN_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD132SS_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD132SS_RN_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD132SS_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD132SS_RU_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132SS_RU_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD132SS_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD132SS_RU_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD132SS_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD132SS_RZ_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132SS_RZ_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD132SS_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD132SS_RZ_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD132SS_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD132SS_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD132SS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD213PDValidFormsNoError(t *testing.T) {
	if _, err := VFMADD213PD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PD(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD213PD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VFMADD213PD_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PD_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PD_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PD_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PD_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PD_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD213PD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD213PD_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PD_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PD_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD213PD_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD213PD_RD_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PD_RD_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD213PD_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD213PD_RD_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD213PD_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD213PD_RN_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PD_RN_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD213PD_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD213PD_RN_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD213PD_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD213PD_RU_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PD_RU_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD213PD_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD213PD_RU_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD213PD_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD213PD_RZ_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PD_RZ_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD213PD_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD213PD_RZ_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD213PD_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD213PD_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD213PSValidFormsNoError(t *testing.T) {
	if _, err := VFMADD213PS(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PS(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PS(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PS(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PS(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PS(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PS(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PS(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PS(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PS(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD213PS_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VFMADD213PS_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PS_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PS_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PS_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PS_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PS_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD213PS_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD213PS_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PS_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PS_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD213PS_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD213PS_RD_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PS_RD_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD213PS_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD213PS_RD_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD213PS_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD213PS_RN_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PS_RN_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD213PS_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD213PS_RN_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD213PS_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD213PS_RU_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PS_RU_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD213PS_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD213PS_RU_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD213PS_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD213PS_RZ_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PS_RZ_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD213PS_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD213PS_RZ_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD213PS_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD213PS_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PS_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PS_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PS_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213PS_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD213SDValidFormsNoError(t *testing.T) {
	if _, err := VFMADD213SD(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213SD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213SD(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213SD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD213SD_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD213SD_RD_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213SD_RD_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD213SD_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD213SD_RD_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD213SD_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD213SD_RN_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213SD_RN_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD213SD_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD213SD_RN_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD213SD_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD213SD_RU_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213SD_RU_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD213SD_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD213SD_RU_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD213SD_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD213SD_RZ_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213SD_RZ_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD213SD_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD213SD_RZ_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD213SD_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD213SD_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213SD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD213SSValidFormsNoError(t *testing.T) {
	if _, err := VFMADD213SS(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213SS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213SS(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213SS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD213SS_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD213SS_RD_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213SS_RD_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD213SS_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD213SS_RD_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD213SS_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD213SS_RN_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213SS_RN_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD213SS_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD213SS_RN_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD213SS_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD213SS_RU_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213SS_RU_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD213SS_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD213SS_RU_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD213SS_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD213SS_RZ_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213SS_RZ_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD213SS_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD213SS_RZ_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD213SS_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD213SS_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD213SS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD231PDValidFormsNoError(t *testing.T) {
	if _, err := VFMADD231PD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PD(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD231PD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VFMADD231PD_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PD_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PD_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PD_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PD_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PD_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD231PD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD231PD_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PD_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PD_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD231PD_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD231PD_RD_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PD_RD_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD231PD_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD231PD_RD_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD231PD_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD231PD_RN_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PD_RN_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD231PD_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD231PD_RN_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD231PD_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD231PD_RU_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PD_RU_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD231PD_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD231PD_RU_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD231PD_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD231PD_RZ_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PD_RZ_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD231PD_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD231PD_RZ_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD231PD_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD231PD_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD231PSValidFormsNoError(t *testing.T) {
	if _, err := VFMADD231PS(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PS(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PS(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PS(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PS(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PS(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PS(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PS(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PS(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PS(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD231PS_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VFMADD231PS_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PS_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PS_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PS_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PS_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PS_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD231PS_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD231PS_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PS_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PS_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD231PS_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD231PS_RD_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PS_RD_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD231PS_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD231PS_RD_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD231PS_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD231PS_RN_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PS_RN_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD231PS_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD231PS_RN_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD231PS_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD231PS_RU_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PS_RU_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD231PS_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD231PS_RU_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD231PS_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD231PS_RZ_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PS_RZ_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD231PS_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD231PS_RZ_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD231PS_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD231PS_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PS_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PS_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PS_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231PS_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD231SDValidFormsNoError(t *testing.T) {
	if _, err := VFMADD231SD(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231SD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231SD(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231SD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD231SD_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD231SD_RD_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231SD_RD_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD231SD_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD231SD_RD_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD231SD_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD231SD_RN_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231SD_RN_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD231SD_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD231SD_RN_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD231SD_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD231SD_RU_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231SD_RU_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD231SD_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD231SD_RU_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD231SD_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD231SD_RZ_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231SD_RZ_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD231SD_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD231SD_RZ_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD231SD_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD231SD_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231SD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD231SSValidFormsNoError(t *testing.T) {
	if _, err := VFMADD231SS(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231SS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231SS(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231SS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD231SS_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD231SS_RD_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231SS_RD_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD231SS_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD231SS_RD_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD231SS_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD231SS_RN_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231SS_RN_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD231SS_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD231SS_RN_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD231SS_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD231SS_RU_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231SS_RU_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD231SS_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD231SS_RU_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD231SS_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADD231SS_RZ_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231SS_RZ_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD231SS_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD231SS_RZ_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADD231SS_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADD231SS_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADD231SS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB132PDValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB132PD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PD(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB132PD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB132PD_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PD_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PD_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PD_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PD_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PD_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB132PD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB132PD_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PD_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PD_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB132PD_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB132PD_RD_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PD_RD_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB132PD_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB132PD_RD_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB132PD_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB132PD_RN_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PD_RN_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB132PD_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB132PD_RN_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB132PD_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB132PD_RU_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PD_RU_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB132PD_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB132PD_RU_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB132PD_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB132PD_RZ_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PD_RZ_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB132PD_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB132PD_RZ_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB132PD_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB132PD_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB132PSValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB132PS(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PS(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PS(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PS(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PS(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PS(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PS(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PS(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PS(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PS(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB132PS_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB132PS_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PS_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PS_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PS_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PS_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PS_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB132PS_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB132PS_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PS_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PS_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB132PS_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB132PS_RD_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PS_RD_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB132PS_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB132PS_RD_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB132PS_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB132PS_RN_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PS_RN_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB132PS_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB132PS_RN_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB132PS_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB132PS_RU_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PS_RU_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB132PS_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB132PS_RU_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB132PS_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB132PS_RZ_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PS_RZ_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB132PS_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB132PS_RZ_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB132PS_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB132PS_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PS_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PS_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PS_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB132PS_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB213PDValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB213PD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PD(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB213PD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB213PD_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PD_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PD_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PD_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PD_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PD_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB213PD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB213PD_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PD_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PD_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB213PD_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB213PD_RD_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PD_RD_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB213PD_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB213PD_RD_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB213PD_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB213PD_RN_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PD_RN_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB213PD_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB213PD_RN_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB213PD_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB213PD_RU_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PD_RU_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB213PD_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB213PD_RU_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB213PD_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB213PD_RZ_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PD_RZ_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB213PD_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB213PD_RZ_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB213PD_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB213PD_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB213PSValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB213PS(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PS(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PS(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PS(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PS(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PS(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PS(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PS(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PS(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PS(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB213PS_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB213PS_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PS_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PS_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PS_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PS_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PS_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB213PS_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB213PS_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PS_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PS_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB213PS_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB213PS_RD_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PS_RD_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB213PS_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB213PS_RD_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB213PS_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB213PS_RN_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PS_RN_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB213PS_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB213PS_RN_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB213PS_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB213PS_RU_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PS_RU_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB213PS_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB213PS_RU_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB213PS_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB213PS_RZ_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PS_RZ_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB213PS_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB213PS_RZ_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB213PS_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB213PS_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PS_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PS_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PS_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB213PS_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB231PDValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB231PD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PD(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB231PD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB231PD_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PD_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PD_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PD_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PD_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PD_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB231PD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB231PD_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PD_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PD_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB231PD_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB231PD_RD_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PD_RD_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB231PD_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB231PD_RD_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB231PD_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB231PD_RN_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PD_RN_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB231PD_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB231PD_RN_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB231PD_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB231PD_RU_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PD_RU_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB231PD_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB231PD_RU_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB231PD_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB231PD_RZ_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PD_RZ_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB231PD_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB231PD_RZ_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB231PD_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB231PD_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB231PSValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB231PS(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PS(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PS(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PS(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PS(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PS(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PS(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PS(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PS(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PS(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB231PS_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB231PS_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PS_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PS_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PS_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PS_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PS_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB231PS_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB231PS_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PS_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PS_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB231PS_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB231PS_RD_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PS_RD_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB231PS_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB231PS_RD_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB231PS_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB231PS_RN_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PS_RN_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB231PS_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB231PS_RN_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB231PS_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB231PS_RU_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PS_RU_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB231PS_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB231PS_RU_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB231PS_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB231PS_RZ_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PS_RZ_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB231PS_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB231PS_RZ_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMADDSUB231PS_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMADDSUB231PS_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PS_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PS_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PS_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMADDSUB231PS_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB132PDValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB132PD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PD(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB132PD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB132PD_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PD_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PD_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PD_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PD_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PD_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB132PD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB132PD_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PD_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PD_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB132PD_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB132PD_RD_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PD_RD_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB132PD_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB132PD_RD_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB132PD_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB132PD_RN_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PD_RN_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB132PD_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB132PD_RN_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB132PD_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB132PD_RU_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PD_RU_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB132PD_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB132PD_RU_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB132PD_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB132PD_RZ_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PD_RZ_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB132PD_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB132PD_RZ_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB132PD_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB132PD_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB132PSValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB132PS(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PS(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PS(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PS(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PS(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PS(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PS(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PS(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PS(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PS(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB132PS_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB132PS_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PS_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PS_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PS_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PS_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PS_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB132PS_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB132PS_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PS_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PS_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB132PS_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB132PS_RD_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PS_RD_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB132PS_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB132PS_RD_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB132PS_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB132PS_RN_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PS_RN_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB132PS_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB132PS_RN_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB132PS_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB132PS_RU_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PS_RU_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB132PS_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB132PS_RU_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB132PS_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB132PS_RZ_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PS_RZ_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB132PS_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB132PS_RZ_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB132PS_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB132PS_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PS_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PS_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PS_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132PS_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB132SDValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB132SD(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132SD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132SD(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132SD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB132SD_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB132SD_RD_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132SD_RD_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB132SD_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB132SD_RD_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB132SD_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB132SD_RN_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132SD_RN_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB132SD_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB132SD_RN_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB132SD_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB132SD_RU_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132SD_RU_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB132SD_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB132SD_RU_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB132SD_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB132SD_RZ_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132SD_RZ_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB132SD_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB132SD_RZ_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB132SD_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB132SD_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132SD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB132SSValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB132SS(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132SS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132SS(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132SS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB132SS_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB132SS_RD_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132SS_RD_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB132SS_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB132SS_RD_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB132SS_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB132SS_RN_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132SS_RN_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB132SS_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB132SS_RN_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB132SS_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB132SS_RU_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132SS_RU_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB132SS_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB132SS_RU_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB132SS_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB132SS_RZ_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132SS_RZ_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB132SS_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB132SS_RZ_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB132SS_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB132SS_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB132SS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB213PDValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB213PD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PD(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB213PD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB213PD_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PD_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PD_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PD_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PD_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PD_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB213PD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB213PD_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PD_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PD_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB213PD_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB213PD_RD_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PD_RD_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB213PD_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB213PD_RD_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB213PD_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB213PD_RN_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PD_RN_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB213PD_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB213PD_RN_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB213PD_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB213PD_RU_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PD_RU_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB213PD_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB213PD_RU_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB213PD_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB213PD_RZ_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PD_RZ_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB213PD_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB213PD_RZ_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB213PD_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB213PD_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB213PSValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB213PS(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PS(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PS(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PS(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PS(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PS(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PS(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PS(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PS(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PS(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB213PS_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB213PS_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PS_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PS_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PS_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PS_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PS_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB213PS_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB213PS_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PS_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PS_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB213PS_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB213PS_RD_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PS_RD_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB213PS_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB213PS_RD_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB213PS_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB213PS_RN_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PS_RN_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB213PS_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB213PS_RN_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB213PS_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB213PS_RU_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PS_RU_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB213PS_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB213PS_RU_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB213PS_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB213PS_RZ_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PS_RZ_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB213PS_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB213PS_RZ_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB213PS_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB213PS_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PS_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PS_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PS_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213PS_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB213SDValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB213SD(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213SD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213SD(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213SD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB213SD_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB213SD_RD_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213SD_RD_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB213SD_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB213SD_RD_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB213SD_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB213SD_RN_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213SD_RN_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB213SD_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB213SD_RN_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB213SD_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB213SD_RU_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213SD_RU_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB213SD_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB213SD_RU_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB213SD_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB213SD_RZ_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213SD_RZ_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB213SD_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB213SD_RZ_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB213SD_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB213SD_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213SD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB213SSValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB213SS(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213SS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213SS(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213SS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB213SS_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB213SS_RD_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213SS_RD_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB213SS_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB213SS_RD_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB213SS_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB213SS_RN_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213SS_RN_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB213SS_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB213SS_RN_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB213SS_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB213SS_RU_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213SS_RU_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB213SS_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB213SS_RU_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB213SS_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB213SS_RZ_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213SS_RZ_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB213SS_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB213SS_RZ_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB213SS_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB213SS_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB213SS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB231PDValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB231PD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PD(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB231PD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB231PD_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PD_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PD_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PD_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PD_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PD_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB231PD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB231PD_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PD_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PD_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB231PD_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB231PD_RD_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PD_RD_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB231PD_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB231PD_RD_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB231PD_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB231PD_RN_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PD_RN_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB231PD_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB231PD_RN_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB231PD_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB231PD_RU_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PD_RU_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB231PD_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB231PD_RU_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB231PD_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB231PD_RZ_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PD_RZ_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB231PD_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB231PD_RZ_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB231PD_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB231PD_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB231PSValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB231PS(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PS(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PS(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PS(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PS(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PS(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PS(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PS(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PS(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PS(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB231PS_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB231PS_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PS_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PS_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PS_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PS_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PS_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB231PS_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB231PS_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PS_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PS_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB231PS_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB231PS_RD_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PS_RD_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB231PS_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB231PS_RD_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB231PS_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB231PS_RN_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PS_RN_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB231PS_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB231PS_RN_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB231PS_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB231PS_RU_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PS_RU_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB231PS_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB231PS_RU_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB231PS_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB231PS_RZ_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PS_RZ_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB231PS_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB231PS_RZ_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB231PS_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB231PS_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PS_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PS_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PS_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231PS_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB231SDValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB231SD(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231SD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231SD(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231SD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB231SD_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB231SD_RD_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231SD_RD_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB231SD_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB231SD_RD_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB231SD_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB231SD_RN_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231SD_RN_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB231SD_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB231SD_RN_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB231SD_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB231SD_RU_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231SD_RU_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB231SD_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB231SD_RU_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB231SD_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB231SD_RZ_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231SD_RZ_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB231SD_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB231SD_RZ_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB231SD_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB231SD_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231SD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB231SSValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB231SS(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231SS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231SS(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231SS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB231SS_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB231SS_RD_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231SS_RD_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB231SS_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB231SS_RD_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB231SS_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB231SS_RN_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231SS_RN_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB231SS_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB231SS_RN_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB231SS_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB231SS_RU_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231SS_RU_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB231SS_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB231SS_RU_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB231SS_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB231SS_RZ_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231SS_RZ_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB231SS_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB231SS_RZ_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUB231SS_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUB231SS_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUB231SS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD132PDValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD132PD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PD(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD132PD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD132PD_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PD_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PD_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PD_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PD_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PD_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD132PD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD132PD_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PD_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PD_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD132PD_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD132PD_RD_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PD_RD_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD132PD_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD132PD_RD_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD132PD_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD132PD_RN_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PD_RN_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD132PD_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD132PD_RN_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD132PD_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD132PD_RU_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PD_RU_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD132PD_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD132PD_RU_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD132PD_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD132PD_RZ_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PD_RZ_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD132PD_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD132PD_RZ_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD132PD_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD132PD_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD132PSValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD132PS(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PS(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PS(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PS(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PS(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PS(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PS(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PS(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PS(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PS(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD132PS_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD132PS_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PS_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PS_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PS_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PS_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PS_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD132PS_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD132PS_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PS_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PS_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD132PS_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD132PS_RD_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PS_RD_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD132PS_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD132PS_RD_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD132PS_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD132PS_RN_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PS_RN_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD132PS_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD132PS_RN_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD132PS_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD132PS_RU_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PS_RU_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD132PS_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD132PS_RU_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD132PS_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD132PS_RZ_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PS_RZ_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD132PS_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD132PS_RZ_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD132PS_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD132PS_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PS_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PS_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PS_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD132PS_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD213PDValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD213PD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PD(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD213PD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD213PD_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PD_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PD_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PD_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PD_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PD_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD213PD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD213PD_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PD_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PD_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD213PD_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD213PD_RD_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PD_RD_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD213PD_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD213PD_RD_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD213PD_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD213PD_RN_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PD_RN_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD213PD_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD213PD_RN_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD213PD_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD213PD_RU_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PD_RU_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD213PD_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD213PD_RU_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD213PD_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD213PD_RZ_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PD_RZ_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD213PD_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD213PD_RZ_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD213PD_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD213PD_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD213PSValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD213PS(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PS(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PS(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PS(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PS(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PS(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PS(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PS(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PS(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PS(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD213PS_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD213PS_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PS_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PS_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PS_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PS_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PS_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD213PS_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD213PS_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PS_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PS_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD213PS_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD213PS_RD_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PS_RD_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD213PS_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD213PS_RD_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD213PS_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD213PS_RN_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PS_RN_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD213PS_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD213PS_RN_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD213PS_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD213PS_RU_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PS_RU_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD213PS_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD213PS_RU_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD213PS_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD213PS_RZ_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PS_RZ_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD213PS_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD213PS_RZ_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD213PS_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD213PS_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PS_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PS_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PS_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD213PS_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD231PDValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD231PD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PD(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD231PD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD231PD_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PD_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PD_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PD_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PD_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PD_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD231PD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD231PD_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PD_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PD_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD231PD_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD231PD_RD_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PD_RD_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD231PD_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD231PD_RD_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD231PD_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD231PD_RN_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PD_RN_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD231PD_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD231PD_RN_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD231PD_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD231PD_RU_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PD_RU_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD231PD_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD231PD_RU_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD231PD_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD231PD_RZ_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PD_RZ_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD231PD_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD231PD_RZ_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD231PD_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD231PD_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD231PSValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD231PS(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PS(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PS(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PS(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PS(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PS(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PS(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PS(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PS(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PS(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD231PS_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD231PS_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PS_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PS_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PS_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PS_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PS_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD231PS_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD231PS_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PS_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PS_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD231PS_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD231PS_RD_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PS_RD_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD231PS_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD231PS_RD_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD231PS_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD231PS_RN_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PS_RN_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD231PS_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD231PS_RN_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD231PS_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD231PS_RU_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PS_RU_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD231PS_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD231PS_RU_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD231PS_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD231PS_RZ_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PS_RZ_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD231PS_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD231PS_RZ_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFMSUBADD231PS_ZValidFormsNoError(t *testing.T) {
	if _, err := VFMSUBADD231PS_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PS_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PS_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PS_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFMSUBADD231PS_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD132PDValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD132PD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PD(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD132PD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD132PD_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PD_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PD_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PD_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PD_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PD_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD132PD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD132PD_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PD_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PD_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD132PD_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD132PD_RD_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PD_RD_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD132PD_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD132PD_RD_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD132PD_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD132PD_RN_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PD_RN_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD132PD_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD132PD_RN_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD132PD_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD132PD_RU_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PD_RU_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD132PD_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD132PD_RU_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD132PD_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD132PD_RZ_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PD_RZ_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD132PD_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD132PD_RZ_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD132PD_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD132PD_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD132PSValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD132PS(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PS(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PS(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PS(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PS(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PS(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PS(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PS(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PS(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PS(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD132PS_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD132PS_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PS_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PS_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PS_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PS_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PS_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD132PS_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD132PS_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PS_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PS_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD132PS_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD132PS_RD_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PS_RD_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD132PS_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD132PS_RD_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD132PS_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD132PS_RN_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PS_RN_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD132PS_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD132PS_RN_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD132PS_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD132PS_RU_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PS_RU_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD132PS_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD132PS_RU_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD132PS_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD132PS_RZ_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PS_RZ_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD132PS_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD132PS_RZ_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD132PS_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD132PS_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PS_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PS_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PS_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132PS_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD132SDValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD132SD(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132SD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132SD(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132SD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD132SD_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD132SD_RD_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132SD_RD_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD132SD_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD132SD_RD_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD132SD_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD132SD_RN_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132SD_RN_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD132SD_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD132SD_RN_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD132SD_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD132SD_RU_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132SD_RU_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD132SD_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD132SD_RU_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD132SD_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD132SD_RZ_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132SD_RZ_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD132SD_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD132SD_RZ_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD132SD_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD132SD_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132SD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD132SSValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD132SS(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132SS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132SS(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132SS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD132SS_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD132SS_RD_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132SS_RD_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD132SS_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD132SS_RD_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD132SS_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD132SS_RN_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132SS_RN_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD132SS_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD132SS_RN_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD132SS_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD132SS_RU_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132SS_RU_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD132SS_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD132SS_RU_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD132SS_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD132SS_RZ_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132SS_RZ_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD132SS_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD132SS_RZ_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD132SS_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD132SS_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD132SS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD213PDValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD213PD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PD(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD213PD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD213PD_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PD_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PD_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PD_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PD_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PD_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD213PD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD213PD_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PD_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PD_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD213PD_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD213PD_RD_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PD_RD_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD213PD_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD213PD_RD_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD213PD_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD213PD_RN_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PD_RN_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD213PD_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD213PD_RN_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD213PD_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD213PD_RU_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PD_RU_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD213PD_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD213PD_RU_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD213PD_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD213PD_RZ_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PD_RZ_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD213PD_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD213PD_RZ_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD213PD_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD213PD_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD213PSValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD213PS(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PS(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PS(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PS(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PS(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PS(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PS(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PS(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PS(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PS(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD213PS_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD213PS_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PS_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PS_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PS_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PS_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PS_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD213PS_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD213PS_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PS_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PS_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD213PS_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD213PS_RD_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PS_RD_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD213PS_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD213PS_RD_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD213PS_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD213PS_RN_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PS_RN_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD213PS_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD213PS_RN_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD213PS_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD213PS_RU_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PS_RU_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD213PS_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD213PS_RU_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD213PS_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD213PS_RZ_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PS_RZ_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD213PS_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD213PS_RZ_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD213PS_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD213PS_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PS_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PS_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PS_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213PS_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD213SDValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD213SD(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213SD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213SD(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213SD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD213SD_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD213SD_RD_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213SD_RD_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD213SD_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD213SD_RD_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD213SD_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD213SD_RN_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213SD_RN_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD213SD_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD213SD_RN_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD213SD_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD213SD_RU_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213SD_RU_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD213SD_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD213SD_RU_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD213SD_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD213SD_RZ_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213SD_RZ_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD213SD_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD213SD_RZ_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD213SD_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD213SD_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213SD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD213SSValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD213SS(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213SS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213SS(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213SS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD213SS_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD213SS_RD_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213SS_RD_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD213SS_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD213SS_RD_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD213SS_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD213SS_RN_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213SS_RN_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD213SS_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD213SS_RN_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD213SS_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD213SS_RU_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213SS_RU_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD213SS_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD213SS_RU_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD213SS_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD213SS_RZ_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213SS_RZ_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD213SS_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD213SS_RZ_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD213SS_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD213SS_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD213SS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD231PDValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD231PD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PD(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD231PD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD231PD_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PD_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PD_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PD_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PD_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PD_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD231PD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD231PD_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PD_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PD_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD231PD_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD231PD_RD_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PD_RD_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD231PD_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD231PD_RD_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD231PD_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD231PD_RN_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PD_RN_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD231PD_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD231PD_RN_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD231PD_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD231PD_RU_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PD_RU_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD231PD_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD231PD_RU_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD231PD_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD231PD_RZ_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PD_RZ_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD231PD_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD231PD_RZ_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD231PD_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD231PD_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD231PSValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD231PS(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PS(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PS(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PS(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PS(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PS(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PS(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PS(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PS(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PS(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD231PS_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD231PS_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PS_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PS_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PS_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PS_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PS_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD231PS_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD231PS_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PS_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PS_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD231PS_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD231PS_RD_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PS_RD_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD231PS_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD231PS_RD_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD231PS_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD231PS_RN_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PS_RN_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD231PS_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD231PS_RN_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD231PS_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD231PS_RU_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PS_RU_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD231PS_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD231PS_RU_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD231PS_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD231PS_RZ_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PS_RZ_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD231PS_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD231PS_RZ_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD231PS_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD231PS_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PS_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PS_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PS_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231PS_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD231SDValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD231SD(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231SD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231SD(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231SD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD231SD_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD231SD_RD_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231SD_RD_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD231SD_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD231SD_RD_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD231SD_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD231SD_RN_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231SD_RN_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD231SD_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD231SD_RN_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD231SD_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD231SD_RU_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231SD_RU_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD231SD_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD231SD_RU_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD231SD_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD231SD_RZ_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231SD_RZ_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD231SD_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD231SD_RZ_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD231SD_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD231SD_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231SD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD231SSValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD231SS(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231SS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231SS(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231SS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD231SS_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD231SS_RD_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231SS_RD_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD231SS_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD231SS_RD_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD231SS_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD231SS_RN_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231SS_RN_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD231SS_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD231SS_RN_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD231SS_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD231SS_RU_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231SS_RU_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD231SS_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD231SS_RU_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD231SS_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD231SS_RZ_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231SS_RZ_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD231SS_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD231SS_RZ_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMADD231SS_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMADD231SS_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMADD231SS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB132PDValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB132PD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PD(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB132PD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB132PD_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PD_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PD_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PD_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PD_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PD_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB132PD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB132PD_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PD_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PD_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB132PD_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB132PD_RD_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PD_RD_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB132PD_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB132PD_RD_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB132PD_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB132PD_RN_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PD_RN_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB132PD_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB132PD_RN_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB132PD_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB132PD_RU_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PD_RU_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB132PD_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB132PD_RU_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB132PD_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB132PD_RZ_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PD_RZ_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB132PD_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB132PD_RZ_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB132PD_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB132PD_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB132PSValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB132PS(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PS(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PS(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PS(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PS(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PS(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PS(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PS(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PS(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PS(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB132PS_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB132PS_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PS_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PS_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PS_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PS_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PS_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB132PS_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB132PS_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PS_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PS_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB132PS_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB132PS_RD_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PS_RD_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB132PS_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB132PS_RD_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB132PS_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB132PS_RN_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PS_RN_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB132PS_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB132PS_RN_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB132PS_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB132PS_RU_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PS_RU_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB132PS_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB132PS_RU_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB132PS_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB132PS_RZ_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PS_RZ_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB132PS_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB132PS_RZ_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB132PS_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB132PS_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PS_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PS_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PS_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132PS_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB132SDValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB132SD(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132SD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132SD(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132SD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB132SD_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB132SD_RD_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132SD_RD_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB132SD_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB132SD_RD_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB132SD_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB132SD_RN_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132SD_RN_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB132SD_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB132SD_RN_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB132SD_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB132SD_RU_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132SD_RU_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB132SD_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB132SD_RU_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB132SD_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB132SD_RZ_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132SD_RZ_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB132SD_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB132SD_RZ_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB132SD_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB132SD_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132SD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB132SSValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB132SS(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132SS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132SS(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132SS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB132SS_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB132SS_RD_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132SS_RD_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB132SS_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB132SS_RD_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB132SS_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB132SS_RN_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132SS_RN_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB132SS_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB132SS_RN_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB132SS_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB132SS_RU_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132SS_RU_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB132SS_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB132SS_RU_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB132SS_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB132SS_RZ_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132SS_RZ_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB132SS_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB132SS_RZ_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB132SS_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB132SS_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB132SS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB213PDValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB213PD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PD(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB213PD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB213PD_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PD_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PD_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PD_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PD_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PD_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB213PD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB213PD_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PD_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PD_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB213PD_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB213PD_RD_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PD_RD_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB213PD_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB213PD_RD_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB213PD_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB213PD_RN_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PD_RN_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB213PD_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB213PD_RN_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB213PD_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB213PD_RU_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PD_RU_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB213PD_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB213PD_RU_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB213PD_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB213PD_RZ_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PD_RZ_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB213PD_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB213PD_RZ_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB213PD_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB213PD_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB213PSValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB213PS(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PS(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PS(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PS(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PS(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PS(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PS(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PS(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PS(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PS(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB213PS_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB213PS_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PS_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PS_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PS_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PS_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PS_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB213PS_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB213PS_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PS_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PS_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB213PS_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB213PS_RD_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PS_RD_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB213PS_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB213PS_RD_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB213PS_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB213PS_RN_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PS_RN_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB213PS_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB213PS_RN_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB213PS_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB213PS_RU_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PS_RU_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB213PS_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB213PS_RU_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB213PS_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB213PS_RZ_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PS_RZ_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB213PS_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB213PS_RZ_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB213PS_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB213PS_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PS_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PS_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PS_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213PS_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB213SDValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB213SD(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213SD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213SD(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213SD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB213SD_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB213SD_RD_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213SD_RD_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB213SD_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB213SD_RD_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB213SD_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB213SD_RN_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213SD_RN_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB213SD_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB213SD_RN_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB213SD_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB213SD_RU_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213SD_RU_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB213SD_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB213SD_RU_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB213SD_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB213SD_RZ_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213SD_RZ_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB213SD_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB213SD_RZ_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB213SD_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB213SD_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213SD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB213SSValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB213SS(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213SS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213SS(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213SS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB213SS_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB213SS_RD_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213SS_RD_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB213SS_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB213SS_RD_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB213SS_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB213SS_RN_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213SS_RN_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB213SS_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB213SS_RN_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB213SS_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB213SS_RU_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213SS_RU_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB213SS_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB213SS_RU_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB213SS_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB213SS_RZ_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213SS_RZ_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB213SS_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB213SS_RZ_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB213SS_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB213SS_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB213SS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB231PDValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB231PD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PD(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB231PD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB231PD_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PD_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PD_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PD_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PD_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PD_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB231PD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB231PD_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PD_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PD_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB231PD_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB231PD_RD_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PD_RD_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB231PD_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB231PD_RD_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB231PD_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB231PD_RN_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PD_RN_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB231PD_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB231PD_RN_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB231PD_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB231PD_RU_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PD_RU_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB231PD_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB231PD_RU_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB231PD_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB231PD_RZ_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PD_RZ_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB231PD_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB231PD_RZ_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB231PD_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB231PD_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB231PSValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB231PS(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PS(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PS(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PS(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PS(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PS(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PS(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PS(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PS(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PS(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB231PS_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB231PS_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PS_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PS_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PS_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PS_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PS_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB231PS_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB231PS_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PS_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PS_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB231PS_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB231PS_RD_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PS_RD_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB231PS_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB231PS_RD_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB231PS_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB231PS_RN_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PS_RN_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB231PS_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB231PS_RN_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB231PS_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB231PS_RU_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PS_RU_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB231PS_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB231PS_RU_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB231PS_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB231PS_RZ_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PS_RZ_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB231PS_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB231PS_RZ_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB231PS_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB231PS_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PS_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PS_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PS_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231PS_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB231SDValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB231SD(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231SD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231SD(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231SD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB231SD_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB231SD_RD_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231SD_RD_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB231SD_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB231SD_RD_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB231SD_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB231SD_RN_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231SD_RN_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB231SD_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB231SD_RN_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB231SD_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB231SD_RU_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231SD_RU_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB231SD_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB231SD_RU_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB231SD_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB231SD_RZ_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231SD_RZ_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB231SD_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB231SD_RZ_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB231SD_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB231SD_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231SD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB231SSValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB231SS(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231SS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231SS(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231SS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB231SS_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB231SS_RD_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231SS_RD_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB231SS_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB231SS_RD_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB231SS_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB231SS_RN_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231SS_RN_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB231SS_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB231SS_RN_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB231SS_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB231SS_RU_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231SS_RU_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB231SS_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB231SS_RU_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB231SS_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB231SS_RZ_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231SS_RZ_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB231SS_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB231SS_RZ_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFNMSUB231SS_ZValidFormsNoError(t *testing.T) {
	if _, err := VFNMSUB231SS_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VFNMSUB231SS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVFPCLASSPDXValidFormsNoError(t *testing.T) {
	if _, err := VFPCLASSPDX(opimm8, opm128, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VFPCLASSPDX(opimm8, opm128, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VFPCLASSPDX(opimm8, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VFPCLASSPDX(opimm8, opxmm, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVFPCLASSPDX_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VFPCLASSPDX_BCST(opimm8, opm64, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VFPCLASSPDX_BCST(opimm8, opm64, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVFPCLASSPDYValidFormsNoError(t *testing.T) {
	if _, err := VFPCLASSPDY(opimm8, opm256, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VFPCLASSPDY(opimm8, opm256, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VFPCLASSPDY(opimm8, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VFPCLASSPDY(opimm8, opymm, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVFPCLASSPDY_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VFPCLASSPDY_BCST(opimm8, opm64, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VFPCLASSPDY_BCST(opimm8, opm64, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVFPCLASSPDZValidFormsNoError(t *testing.T) {
	if _, err := VFPCLASSPDZ(opimm8, opm512, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VFPCLASSPDZ(opimm8, opm512, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VFPCLASSPDZ(opimm8, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VFPCLASSPDZ(opimm8, opzmm, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVFPCLASSPDZ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VFPCLASSPDZ_BCST(opimm8, opm64, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VFPCLASSPDZ_BCST(opimm8, opm64, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVFPCLASSPSXValidFormsNoError(t *testing.T) {
	if _, err := VFPCLASSPSX(opimm8, opm128, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VFPCLASSPSX(opimm8, opm128, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VFPCLASSPSX(opimm8, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VFPCLASSPSX(opimm8, opxmm, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVFPCLASSPSX_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VFPCLASSPSX_BCST(opimm8, opm32, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VFPCLASSPSX_BCST(opimm8, opm32, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVFPCLASSPSYValidFormsNoError(t *testing.T) {
	if _, err := VFPCLASSPSY(opimm8, opm256, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VFPCLASSPSY(opimm8, opm256, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VFPCLASSPSY(opimm8, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VFPCLASSPSY(opimm8, opymm, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVFPCLASSPSY_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VFPCLASSPSY_BCST(opimm8, opm32, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VFPCLASSPSY_BCST(opimm8, opm32, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVFPCLASSPSZValidFormsNoError(t *testing.T) {
	if _, err := VFPCLASSPSZ(opimm8, opm512, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VFPCLASSPSZ(opimm8, opm512, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VFPCLASSPSZ(opimm8, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VFPCLASSPSZ(opimm8, opzmm, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVFPCLASSPSZ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VFPCLASSPSZ_BCST(opimm8, opm32, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VFPCLASSPSZ_BCST(opimm8, opm32, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVFPCLASSSDValidFormsNoError(t *testing.T) {
	if _, err := VFPCLASSSD(opimm8, opm64, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VFPCLASSSD(opimm8, opm64, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VFPCLASSSD(opimm8, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VFPCLASSSD(opimm8, opxmm, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVFPCLASSSSValidFormsNoError(t *testing.T) {
	if _, err := VFPCLASSSS(opimm8, opm32, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VFPCLASSSS(opimm8, opm32, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VFPCLASSSS(opimm8, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VFPCLASSSS(opimm8, opxmm, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVGATHERDPDValidFormsNoError(t *testing.T) {
	if _, err := VGATHERDPD(opxmm, opvm32x, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGATHERDPD(opymm, opvm32x, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGATHERDPD(opvm32x, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGATHERDPD(opvm32x, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGATHERDPD(opvm32y, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVGATHERDPSValidFormsNoError(t *testing.T) {
	if _, err := VGATHERDPS(opxmm, opvm32x, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGATHERDPS(opymm, opvm32y, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGATHERDPS(opvm32x, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGATHERDPS(opvm32y, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGATHERDPS(opvm32z, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVGATHERQPDValidFormsNoError(t *testing.T) {
	if _, err := VGATHERQPD(opxmm, opvm64x, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGATHERQPD(opymm, opvm64y, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGATHERQPD(opvm64x, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGATHERQPD(opvm64y, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGATHERQPD(opvm64z, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVGATHERQPSValidFormsNoError(t *testing.T) {
	if _, err := VGATHERQPS(opxmm, opvm64x, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGATHERQPS(opxmm, opvm64y, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGATHERQPS(opvm64x, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGATHERQPS(opvm64y, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGATHERQPS(opvm64z, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVGETEXPPDValidFormsNoError(t *testing.T) {
	if _, err := VGETEXPPD(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPD(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPD(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPD(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPD(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPD(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPD(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPD(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPD(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPD(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPD(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVGETEXPPD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VGETEXPPD_BCST(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPD_BCST(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPD_BCST(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPD_BCST(opm64, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPD_BCST(opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPD_BCST(opm64, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVGETEXPPD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VGETEXPPD_BCST_Z(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPD_BCST_Z(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPD_BCST_Z(opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVGETEXPPD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VGETEXPPD_SAE(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPD_SAE(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVGETEXPPD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VGETEXPPD_SAE_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVGETEXPPD_ZValidFormsNoError(t *testing.T) {
	if _, err := VGETEXPPD_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPD_Z(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPD_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPD_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPD_Z(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPD_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVGETEXPPSValidFormsNoError(t *testing.T) {
	if _, err := VGETEXPPS(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPS(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPS(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPS(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPS(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPS(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPS(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPS(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPS(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPS(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPS(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPS(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVGETEXPPS_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VGETEXPPS_BCST(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPS_BCST(opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPS_BCST(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPS_BCST(opm32, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPS_BCST(opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPS_BCST(opm32, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVGETEXPPS_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VGETEXPPS_BCST_Z(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPS_BCST_Z(opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPS_BCST_Z(opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVGETEXPPS_SAEValidFormsNoError(t *testing.T) {
	if _, err := VGETEXPPS_SAE(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPS_SAE(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVGETEXPPS_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VGETEXPPS_SAE_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVGETEXPPS_ZValidFormsNoError(t *testing.T) {
	if _, err := VGETEXPPS_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPS_Z(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPS_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPS_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPS_Z(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPPS_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVGETEXPSDValidFormsNoError(t *testing.T) {
	if _, err := VGETEXPSD(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPSD(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPSD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPSD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVGETEXPSD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VGETEXPSD_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPSD_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVGETEXPSD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VGETEXPSD_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVGETEXPSD_ZValidFormsNoError(t *testing.T) {
	if _, err := VGETEXPSD_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPSD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVGETEXPSSValidFormsNoError(t *testing.T) {
	if _, err := VGETEXPSS(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPSS(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPSS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPSS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVGETEXPSS_SAEValidFormsNoError(t *testing.T) {
	if _, err := VGETEXPSS_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPSS_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVGETEXPSS_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VGETEXPSS_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVGETEXPSS_ZValidFormsNoError(t *testing.T) {
	if _, err := VGETEXPSS_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETEXPSS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVGETMANTPDValidFormsNoError(t *testing.T) {
	if _, err := VGETMANTPD(opimm8, opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPD(opimm8, opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPD(opimm8, opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPD(opimm8, opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPD(opimm8, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPD(opimm8, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPD(opimm8, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPD(opimm8, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPD(opimm8, opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPD(opimm8, opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPD(opimm8, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPD(opimm8, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVGETMANTPD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VGETMANTPD_BCST(opimm8, opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPD_BCST(opimm8, opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPD_BCST(opimm8, opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPD_BCST(opimm8, opm64, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPD_BCST(opimm8, opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPD_BCST(opimm8, opm64, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVGETMANTPD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VGETMANTPD_BCST_Z(opimm8, opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPD_BCST_Z(opimm8, opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPD_BCST_Z(opimm8, opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVGETMANTPD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VGETMANTPD_SAE(opimm8, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPD_SAE(opimm8, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVGETMANTPD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VGETMANTPD_SAE_Z(opimm8, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVGETMANTPD_ZValidFormsNoError(t *testing.T) {
	if _, err := VGETMANTPD_Z(opimm8, opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPD_Z(opimm8, opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPD_Z(opimm8, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPD_Z(opimm8, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPD_Z(opimm8, opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPD_Z(opimm8, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVGETMANTPSValidFormsNoError(t *testing.T) {
	if _, err := VGETMANTPS(opimm8, opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPS(opimm8, opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPS(opimm8, opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPS(opimm8, opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPS(opimm8, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPS(opimm8, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPS(opimm8, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPS(opimm8, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPS(opimm8, opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPS(opimm8, opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPS(opimm8, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPS(opimm8, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVGETMANTPS_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VGETMANTPS_BCST(opimm8, opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPS_BCST(opimm8, opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPS_BCST(opimm8, opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPS_BCST(opimm8, opm32, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPS_BCST(opimm8, opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPS_BCST(opimm8, opm32, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVGETMANTPS_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VGETMANTPS_BCST_Z(opimm8, opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPS_BCST_Z(opimm8, opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPS_BCST_Z(opimm8, opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVGETMANTPS_SAEValidFormsNoError(t *testing.T) {
	if _, err := VGETMANTPS_SAE(opimm8, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPS_SAE(opimm8, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVGETMANTPS_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VGETMANTPS_SAE_Z(opimm8, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVGETMANTPS_ZValidFormsNoError(t *testing.T) {
	if _, err := VGETMANTPS_Z(opimm8, opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPS_Z(opimm8, opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPS_Z(opimm8, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPS_Z(opimm8, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPS_Z(opimm8, opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTPS_Z(opimm8, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVGETMANTSDValidFormsNoError(t *testing.T) {
	if _, err := VGETMANTSD(opimm8, opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTSD(opimm8, opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTSD(opimm8, opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTSD(opimm8, opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVGETMANTSD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VGETMANTSD_SAE(opimm8, opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTSD_SAE(opimm8, opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVGETMANTSD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VGETMANTSD_SAE_Z(opimm8, opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVGETMANTSD_ZValidFormsNoError(t *testing.T) {
	if _, err := VGETMANTSD_Z(opimm8, opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTSD_Z(opimm8, opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVGETMANTSSValidFormsNoError(t *testing.T) {
	if _, err := VGETMANTSS(opimm8, opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTSS(opimm8, opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTSS(opimm8, opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTSS(opimm8, opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVGETMANTSS_SAEValidFormsNoError(t *testing.T) {
	if _, err := VGETMANTSS_SAE(opimm8, opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTSS_SAE(opimm8, opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVGETMANTSS_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VGETMANTSS_SAE_Z(opimm8, opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVGETMANTSS_ZValidFormsNoError(t *testing.T) {
	if _, err := VGETMANTSS_Z(opimm8, opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGETMANTSS_Z(opimm8, opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVGF2P8AFFINEINVQBValidFormsNoError(t *testing.T) {
	if _, err := VGF2P8AFFINEINVQB(opimm8, opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8AFFINEINVQB(opimm8, opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8AFFINEINVQB(opimm8, opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8AFFINEINVQB(opimm8, opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8AFFINEINVQB(opimm8, opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8AFFINEINVQB(opimm8, opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8AFFINEINVQB(opimm8, opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8AFFINEINVQB(opimm8, opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8AFFINEINVQB(opimm8, opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8AFFINEINVQB(opimm8, opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8AFFINEINVQB(opimm8, opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8AFFINEINVQB(opimm8, opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVGF2P8AFFINEINVQB_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VGF2P8AFFINEINVQB_BCST(opimm8, opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8AFFINEINVQB_BCST(opimm8, opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8AFFINEINVQB_BCST(opimm8, opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8AFFINEINVQB_BCST(opimm8, opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8AFFINEINVQB_BCST(opimm8, opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8AFFINEINVQB_BCST(opimm8, opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVGF2P8AFFINEINVQB_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VGF2P8AFFINEINVQB_BCST_Z(opimm8, opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8AFFINEINVQB_BCST_Z(opimm8, opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8AFFINEINVQB_BCST_Z(opimm8, opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVGF2P8AFFINEINVQB_ZValidFormsNoError(t *testing.T) {
	if _, err := VGF2P8AFFINEINVQB_Z(opimm8, opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8AFFINEINVQB_Z(opimm8, opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8AFFINEINVQB_Z(opimm8, opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8AFFINEINVQB_Z(opimm8, opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8AFFINEINVQB_Z(opimm8, opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8AFFINEINVQB_Z(opimm8, opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVGF2P8AFFINEQBValidFormsNoError(t *testing.T) {
	if _, err := VGF2P8AFFINEQB(opimm8, opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8AFFINEQB(opimm8, opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8AFFINEQB(opimm8, opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8AFFINEQB(opimm8, opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8AFFINEQB(opimm8, opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8AFFINEQB(opimm8, opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8AFFINEQB(opimm8, opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8AFFINEQB(opimm8, opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8AFFINEQB(opimm8, opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8AFFINEQB(opimm8, opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8AFFINEQB(opimm8, opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8AFFINEQB(opimm8, opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVGF2P8AFFINEQB_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VGF2P8AFFINEQB_BCST(opimm8, opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8AFFINEQB_BCST(opimm8, opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8AFFINEQB_BCST(opimm8, opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8AFFINEQB_BCST(opimm8, opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8AFFINEQB_BCST(opimm8, opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8AFFINEQB_BCST(opimm8, opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVGF2P8AFFINEQB_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VGF2P8AFFINEQB_BCST_Z(opimm8, opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8AFFINEQB_BCST_Z(opimm8, opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8AFFINEQB_BCST_Z(opimm8, opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVGF2P8AFFINEQB_ZValidFormsNoError(t *testing.T) {
	if _, err := VGF2P8AFFINEQB_Z(opimm8, opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8AFFINEQB_Z(opimm8, opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8AFFINEQB_Z(opimm8, opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8AFFINEQB_Z(opimm8, opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8AFFINEQB_Z(opimm8, opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8AFFINEQB_Z(opimm8, opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVGF2P8MULBValidFormsNoError(t *testing.T) {
	if _, err := VGF2P8MULB(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8MULB(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8MULB(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8MULB(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8MULB(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8MULB(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8MULB(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8MULB(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8MULB(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8MULB(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8MULB(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8MULB(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVGF2P8MULB_ZValidFormsNoError(t *testing.T) {
	if _, err := VGF2P8MULB_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8MULB_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8MULB_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8MULB_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8MULB_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VGF2P8MULB_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVHADDPDValidFormsNoError(t *testing.T) {
	if _, err := VHADDPD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VHADDPD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VHADDPD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VHADDPD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVHADDPSValidFormsNoError(t *testing.T) {
	if _, err := VHADDPS(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VHADDPS(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VHADDPS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VHADDPS(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVHSUBPDValidFormsNoError(t *testing.T) {
	if _, err := VHSUBPD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VHSUBPD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VHSUBPD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VHSUBPD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVHSUBPSValidFormsNoError(t *testing.T) {
	if _, err := VHSUBPS(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VHSUBPS(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VHSUBPS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VHSUBPS(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVINSERTF128ValidFormsNoError(t *testing.T) {
	if _, err := VINSERTF128(opimm8, opm128, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTF128(opimm8, opxmm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVINSERTF32X4ValidFormsNoError(t *testing.T) {
	if _, err := VINSERTF32X4(opimm8, opm128, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTF32X4(opimm8, opm128, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTF32X4(opimm8, opxmm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTF32X4(opimm8, opxmm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTF32X4(opimm8, opm128, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTF32X4(opimm8, opm128, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTF32X4(opimm8, opxmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTF32X4(opimm8, opxmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVINSERTF32X4_ZValidFormsNoError(t *testing.T) {
	if _, err := VINSERTF32X4_Z(opimm8, opm128, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTF32X4_Z(opimm8, opxmm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTF32X4_Z(opimm8, opm128, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTF32X4_Z(opimm8, opxmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVINSERTF32X8ValidFormsNoError(t *testing.T) {
	if _, err := VINSERTF32X8(opimm8, opm256, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTF32X8(opimm8, opm256, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTF32X8(opimm8, opymm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTF32X8(opimm8, opymm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVINSERTF32X8_ZValidFormsNoError(t *testing.T) {
	if _, err := VINSERTF32X8_Z(opimm8, opm256, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTF32X8_Z(opimm8, opymm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVINSERTF64X2ValidFormsNoError(t *testing.T) {
	if _, err := VINSERTF64X2(opimm8, opm128, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTF64X2(opimm8, opm128, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTF64X2(opimm8, opxmm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTF64X2(opimm8, opxmm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTF64X2(opimm8, opm128, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTF64X2(opimm8, opm128, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTF64X2(opimm8, opxmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTF64X2(opimm8, opxmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVINSERTF64X2_ZValidFormsNoError(t *testing.T) {
	if _, err := VINSERTF64X2_Z(opimm8, opm128, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTF64X2_Z(opimm8, opxmm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTF64X2_Z(opimm8, opm128, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTF64X2_Z(opimm8, opxmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVINSERTF64X4ValidFormsNoError(t *testing.T) {
	if _, err := VINSERTF64X4(opimm8, opm256, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTF64X4(opimm8, opm256, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTF64X4(opimm8, opymm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTF64X4(opimm8, opymm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVINSERTF64X4_ZValidFormsNoError(t *testing.T) {
	if _, err := VINSERTF64X4_Z(opimm8, opm256, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTF64X4_Z(opimm8, opymm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVINSERTI128ValidFormsNoError(t *testing.T) {
	if _, err := VINSERTI128(opimm8, opm128, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTI128(opimm8, opxmm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVINSERTI32X4ValidFormsNoError(t *testing.T) {
	if _, err := VINSERTI32X4(opimm8, opm128, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTI32X4(opimm8, opm128, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTI32X4(opimm8, opxmm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTI32X4(opimm8, opxmm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTI32X4(opimm8, opm128, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTI32X4(opimm8, opm128, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTI32X4(opimm8, opxmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTI32X4(opimm8, opxmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVINSERTI32X4_ZValidFormsNoError(t *testing.T) {
	if _, err := VINSERTI32X4_Z(opimm8, opm128, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTI32X4_Z(opimm8, opxmm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTI32X4_Z(opimm8, opm128, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTI32X4_Z(opimm8, opxmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVINSERTI32X8ValidFormsNoError(t *testing.T) {
	if _, err := VINSERTI32X8(opimm8, opm256, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTI32X8(opimm8, opm256, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTI32X8(opimm8, opymm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTI32X8(opimm8, opymm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVINSERTI32X8_ZValidFormsNoError(t *testing.T) {
	if _, err := VINSERTI32X8_Z(opimm8, opm256, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTI32X8_Z(opimm8, opymm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVINSERTI64X2ValidFormsNoError(t *testing.T) {
	if _, err := VINSERTI64X2(opimm8, opm128, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTI64X2(opimm8, opm128, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTI64X2(opimm8, opxmm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTI64X2(opimm8, opxmm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTI64X2(opimm8, opm128, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTI64X2(opimm8, opm128, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTI64X2(opimm8, opxmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTI64X2(opimm8, opxmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVINSERTI64X2_ZValidFormsNoError(t *testing.T) {
	if _, err := VINSERTI64X2_Z(opimm8, opm128, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTI64X2_Z(opimm8, opxmm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTI64X2_Z(opimm8, opm128, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTI64X2_Z(opimm8, opxmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVINSERTI64X4ValidFormsNoError(t *testing.T) {
	if _, err := VINSERTI64X4(opimm8, opm256, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTI64X4(opimm8, opm256, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTI64X4(opimm8, opymm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTI64X4(opimm8, opymm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVINSERTI64X4_ZValidFormsNoError(t *testing.T) {
	if _, err := VINSERTI64X4_Z(opimm8, opm256, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTI64X4_Z(opimm8, opymm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVINSERTPSValidFormsNoError(t *testing.T) {
	if _, err := VINSERTPS(opimm8, opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VINSERTPS(opimm8, opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVLDDQUValidFormsNoError(t *testing.T) {
	if _, err := VLDDQU(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VLDDQU(opm256, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVLDMXCSRValidFormsNoError(t *testing.T) {
	if _, err := VLDMXCSR(opm32); err != nil {
		t.Fatal(err)
	}
}

func TestVMASKMOVDQUValidFormsNoError(t *testing.T) {
	if _, err := VMASKMOVDQU(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMASKMOVPDValidFormsNoError(t *testing.T) {
	if _, err := VMASKMOVPD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMASKMOVPD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMASKMOVPD(opxmm, opxmm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VMASKMOVPD(opymm, opymm, opm256); err != nil {
		t.Fatal(err)
	}
}

func TestVMASKMOVPSValidFormsNoError(t *testing.T) {
	if _, err := VMASKMOVPS(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMASKMOVPS(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMASKMOVPS(opxmm, opxmm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VMASKMOVPS(opymm, opymm, opm256); err != nil {
		t.Fatal(err)
	}
}

func TestVMAXPDValidFormsNoError(t *testing.T) {
	if _, err := VMAXPD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPD(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMAXPD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VMAXPD_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPD_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPD_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPD_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPD_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPD_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMAXPD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VMAXPD_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPD_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPD_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMAXPD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VMAXPD_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPD_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMAXPD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VMAXPD_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMAXPD_ZValidFormsNoError(t *testing.T) {
	if _, err := VMAXPD_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMAXPSValidFormsNoError(t *testing.T) {
	if _, err := VMAXPS(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPS(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPS(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPS(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPS(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPS(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPS(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPS(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPS(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPS(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMAXPS_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VMAXPS_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPS_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPS_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPS_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPS_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPS_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMAXPS_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VMAXPS_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPS_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPS_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMAXPS_SAEValidFormsNoError(t *testing.T) {
	if _, err := VMAXPS_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPS_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMAXPS_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VMAXPS_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMAXPS_ZValidFormsNoError(t *testing.T) {
	if _, err := VMAXPS_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPS_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPS_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPS_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXPS_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMAXSDValidFormsNoError(t *testing.T) {
	if _, err := VMAXSD(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXSD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXSD(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXSD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMAXSD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VMAXSD_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXSD_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMAXSD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VMAXSD_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMAXSD_ZValidFormsNoError(t *testing.T) {
	if _, err := VMAXSD_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXSD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMAXSSValidFormsNoError(t *testing.T) {
	if _, err := VMAXSS(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXSS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXSS(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXSS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMAXSS_SAEValidFormsNoError(t *testing.T) {
	if _, err := VMAXSS_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXSS_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMAXSS_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VMAXSS_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMAXSS_ZValidFormsNoError(t *testing.T) {
	if _, err := VMAXSS_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMAXSS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMINPDValidFormsNoError(t *testing.T) {
	if _, err := VMINPD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPD(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMINPD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VMINPD_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPD_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPD_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPD_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPD_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPD_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMINPD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VMINPD_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPD_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPD_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMINPD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VMINPD_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPD_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMINPD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VMINPD_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMINPD_ZValidFormsNoError(t *testing.T) {
	if _, err := VMINPD_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMINPSValidFormsNoError(t *testing.T) {
	if _, err := VMINPS(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPS(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPS(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPS(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPS(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPS(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPS(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPS(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPS(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPS(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMINPS_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VMINPS_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPS_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPS_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPS_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPS_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPS_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMINPS_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VMINPS_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPS_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPS_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMINPS_SAEValidFormsNoError(t *testing.T) {
	if _, err := VMINPS_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPS_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMINPS_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VMINPS_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMINPS_ZValidFormsNoError(t *testing.T) {
	if _, err := VMINPS_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPS_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPS_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPS_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINPS_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMINSDValidFormsNoError(t *testing.T) {
	if _, err := VMINSD(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINSD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINSD(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINSD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMINSD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VMINSD_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINSD_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMINSD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VMINSD_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMINSD_ZValidFormsNoError(t *testing.T) {
	if _, err := VMINSD_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINSD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMINSSValidFormsNoError(t *testing.T) {
	if _, err := VMINSS(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINSS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINSS(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINSS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMINSS_SAEValidFormsNoError(t *testing.T) {
	if _, err := VMINSS_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINSS_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMINSS_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VMINSS_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMINSS_ZValidFormsNoError(t *testing.T) {
	if _, err := VMINSS_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMINSS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMOVAPDValidFormsNoError(t *testing.T) {
	if _, err := VMOVAPD(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPD(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPD(opxmm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPD(opymm, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPD(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPD(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPD(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPD(opxmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPD(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPD(opymm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPD(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPD(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPD(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPD(opzmm, opk, opm512); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPD(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPD(opzmm, opm512); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPD(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMOVAPD_ZValidFormsNoError(t *testing.T) {
	if _, err := VMOVAPD_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPD_Z(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPD_Z(opxmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPD_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPD_Z(opymm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPD_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPD_Z(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPD_Z(opzmm, opk, opm512); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPD_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMOVAPSValidFormsNoError(t *testing.T) {
	if _, err := VMOVAPS(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPS(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPS(opxmm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPS(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPS(opymm, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPS(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPS(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPS(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPS(opxmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPS(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPS(opymm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPS(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPS(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPS(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPS(opzmm, opk, opm512); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPS(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPS(opzmm, opm512); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPS(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMOVAPS_ZValidFormsNoError(t *testing.T) {
	if _, err := VMOVAPS_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPS_Z(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPS_Z(opxmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPS_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPS_Z(opymm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPS_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPS_Z(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPS_Z(opzmm, opk, opm512); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVAPS_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMOVDValidFormsNoError(t *testing.T) {
	if _, err := VMOVD(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVD(opr32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVD(opxmm, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVD(opxmm, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestVMOVDDUPValidFormsNoError(t *testing.T) {
	if _, err := VMOVDDUP(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDDUP(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDDUP(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDDUP(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDDUP(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDDUP(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDDUP(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDDUP(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDDUP(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDDUP(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDDUP(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDDUP(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMOVDDUP_ZValidFormsNoError(t *testing.T) {
	if _, err := VMOVDDUP_Z(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDDUP_Z(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDDUP_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDDUP_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDDUP_Z(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDDUP_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMOVDQAValidFormsNoError(t *testing.T) {
	if _, err := VMOVDQA(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA(opxmm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA(opymm, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA(opymm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVMOVDQA32ValidFormsNoError(t *testing.T) {
	if _, err := VMOVDQA32(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA32(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA32(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA32(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA32(opxmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA32(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA32(opxmm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA32(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA32(opymm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA32(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA32(opymm, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA32(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA32(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA32(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA32(opzmm, opk, opm512); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA32(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA32(opzmm, opm512); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA32(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMOVDQA32_ZValidFormsNoError(t *testing.T) {
	if _, err := VMOVDQA32_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA32_Z(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA32_Z(opxmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA32_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA32_Z(opymm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA32_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA32_Z(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA32_Z(opzmm, opk, opm512); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA32_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMOVDQA64ValidFormsNoError(t *testing.T) {
	if _, err := VMOVDQA64(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA64(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA64(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA64(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA64(opxmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA64(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA64(opxmm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA64(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA64(opymm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA64(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA64(opymm, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA64(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA64(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA64(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA64(opzmm, opk, opm512); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA64(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA64(opzmm, opm512); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA64(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMOVDQA64_ZValidFormsNoError(t *testing.T) {
	if _, err := VMOVDQA64_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA64_Z(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA64_Z(opxmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA64_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA64_Z(opymm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA64_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA64_Z(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA64_Z(opzmm, opk, opm512); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQA64_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMOVDQUValidFormsNoError(t *testing.T) {
	if _, err := VMOVDQU(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU(opxmm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU(opymm, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU(opymm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVMOVDQU16ValidFormsNoError(t *testing.T) {
	if _, err := VMOVDQU16(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU16(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU16(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU16(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU16(opxmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU16(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU16(opxmm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU16(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU16(opymm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU16(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU16(opymm, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU16(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU16(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU16(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU16(opzmm, opk, opm512); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU16(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU16(opzmm, opm512); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU16(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMOVDQU16_ZValidFormsNoError(t *testing.T) {
	if _, err := VMOVDQU16_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU16_Z(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU16_Z(opxmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU16_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU16_Z(opymm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU16_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU16_Z(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU16_Z(opzmm, opk, opm512); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU16_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMOVDQU32ValidFormsNoError(t *testing.T) {
	if _, err := VMOVDQU32(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU32(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU32(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU32(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU32(opxmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU32(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU32(opxmm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU32(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU32(opymm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU32(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU32(opymm, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU32(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU32(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU32(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU32(opzmm, opk, opm512); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU32(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU32(opzmm, opm512); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU32(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMOVDQU32_ZValidFormsNoError(t *testing.T) {
	if _, err := VMOVDQU32_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU32_Z(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU32_Z(opxmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU32_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU32_Z(opymm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU32_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU32_Z(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU32_Z(opzmm, opk, opm512); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU32_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMOVDQU64ValidFormsNoError(t *testing.T) {
	if _, err := VMOVDQU64(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU64(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU64(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU64(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU64(opxmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU64(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU64(opxmm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU64(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU64(opymm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU64(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU64(opymm, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU64(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU64(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU64(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU64(opzmm, opk, opm512); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU64(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU64(opzmm, opm512); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU64(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMOVDQU64_ZValidFormsNoError(t *testing.T) {
	if _, err := VMOVDQU64_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU64_Z(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU64_Z(opxmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU64_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU64_Z(opymm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU64_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU64_Z(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU64_Z(opzmm, opk, opm512); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU64_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMOVDQU8ValidFormsNoError(t *testing.T) {
	if _, err := VMOVDQU8(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU8(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU8(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU8(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU8(opxmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU8(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU8(opxmm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU8(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU8(opymm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU8(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU8(opymm, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU8(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU8(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU8(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU8(opzmm, opk, opm512); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU8(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU8(opzmm, opm512); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU8(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMOVDQU8_ZValidFormsNoError(t *testing.T) {
	if _, err := VMOVDQU8_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU8_Z(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU8_Z(opxmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU8_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU8_Z(opymm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU8_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU8_Z(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU8_Z(opzmm, opk, opm512); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVDQU8_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMOVHLPSValidFormsNoError(t *testing.T) {
	if _, err := VMOVHLPS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMOVHPDValidFormsNoError(t *testing.T) {
	if _, err := VMOVHPD(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVHPD(opxmm, opm64); err != nil {
		t.Fatal(err)
	}
}

func TestVMOVHPSValidFormsNoError(t *testing.T) {
	if _, err := VMOVHPS(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVHPS(opxmm, opm64); err != nil {
		t.Fatal(err)
	}
}

func TestVMOVLHPSValidFormsNoError(t *testing.T) {
	if _, err := VMOVLHPS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMOVLPDValidFormsNoError(t *testing.T) {
	if _, err := VMOVLPD(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVLPD(opxmm, opm64); err != nil {
		t.Fatal(err)
	}
}

func TestVMOVLPSValidFormsNoError(t *testing.T) {
	if _, err := VMOVLPS(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVLPS(opxmm, opm64); err != nil {
		t.Fatal(err)
	}
}

func TestVMOVMSKPDValidFormsNoError(t *testing.T) {
	if _, err := VMOVMSKPD(opxmm, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVMSKPD(opymm, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestVMOVMSKPSValidFormsNoError(t *testing.T) {
	if _, err := VMOVMSKPS(opxmm, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVMSKPS(opymm, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestVMOVNTDQValidFormsNoError(t *testing.T) {
	if _, err := VMOVNTDQ(opxmm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVNTDQ(opymm, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVNTDQ(opzmm, opm512); err != nil {
		t.Fatal(err)
	}
}

func TestVMOVNTDQAValidFormsNoError(t *testing.T) {
	if _, err := VMOVNTDQA(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVNTDQA(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVNTDQA(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMOVNTPDValidFormsNoError(t *testing.T) {
	if _, err := VMOVNTPD(opxmm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVNTPD(opymm, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVNTPD(opzmm, opm512); err != nil {
		t.Fatal(err)
	}
}

func TestVMOVNTPSValidFormsNoError(t *testing.T) {
	if _, err := VMOVNTPS(opxmm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVNTPS(opymm, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVNTPS(opzmm, opm512); err != nil {
		t.Fatal(err)
	}
}

func TestVMOVQValidFormsNoError(t *testing.T) {
	if _, err := VMOVQ(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVQ(opr64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVQ(opxmm, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVQ(opxmm, opr64); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVQ(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMOVSDValidFormsNoError(t *testing.T) {
	if _, err := VMOVSD(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVSD(opxmm, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVSD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVSD(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVSD(opxmm, opk, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVSD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMOVSD_ZValidFormsNoError(t *testing.T) {
	if _, err := VMOVSD_Z(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVSD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMOVSHDUPValidFormsNoError(t *testing.T) {
	if _, err := VMOVSHDUP(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVSHDUP(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVSHDUP(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVSHDUP(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVSHDUP(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVSHDUP(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVSHDUP(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVSHDUP(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVSHDUP(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVSHDUP(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVSHDUP(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVSHDUP(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMOVSHDUP_ZValidFormsNoError(t *testing.T) {
	if _, err := VMOVSHDUP_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVSHDUP_Z(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVSHDUP_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVSHDUP_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVSHDUP_Z(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVSHDUP_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMOVSLDUPValidFormsNoError(t *testing.T) {
	if _, err := VMOVSLDUP(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVSLDUP(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVSLDUP(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVSLDUP(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVSLDUP(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVSLDUP(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVSLDUP(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVSLDUP(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVSLDUP(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVSLDUP(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVSLDUP(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVSLDUP(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMOVSLDUP_ZValidFormsNoError(t *testing.T) {
	if _, err := VMOVSLDUP_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVSLDUP_Z(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVSLDUP_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVSLDUP_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVSLDUP_Z(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVSLDUP_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMOVSSValidFormsNoError(t *testing.T) {
	if _, err := VMOVSS(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVSS(opxmm, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVSS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVSS(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVSS(opxmm, opk, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVSS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMOVSS_ZValidFormsNoError(t *testing.T) {
	if _, err := VMOVSS_Z(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVSS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMOVUPDValidFormsNoError(t *testing.T) {
	if _, err := VMOVUPD(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPD(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPD(opxmm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPD(opymm, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPD(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPD(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPD(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPD(opxmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPD(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPD(opymm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPD(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPD(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPD(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPD(opzmm, opk, opm512); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPD(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPD(opzmm, opm512); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPD(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMOVUPD_ZValidFormsNoError(t *testing.T) {
	if _, err := VMOVUPD_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPD_Z(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPD_Z(opxmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPD_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPD_Z(opymm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPD_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPD_Z(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPD_Z(opzmm, opk, opm512); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPD_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMOVUPSValidFormsNoError(t *testing.T) {
	if _, err := VMOVUPS(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPS(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPS(opxmm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPS(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPS(opymm, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPS(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPS(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPS(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPS(opxmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPS(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPS(opymm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPS(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPS(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPS(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPS(opzmm, opk, opm512); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPS(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPS(opzmm, opm512); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPS(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMOVUPS_ZValidFormsNoError(t *testing.T) {
	if _, err := VMOVUPS_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPS_Z(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPS_Z(opxmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPS_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPS_Z(opymm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPS_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPS_Z(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPS_Z(opzmm, opk, opm512); err != nil {
		t.Fatal(err)
	}
	if _, err := VMOVUPS_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMPSADBWValidFormsNoError(t *testing.T) {
	if _, err := VMPSADBW(opimm8, opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMPSADBW(opimm8, opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMPSADBW(opimm8, opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMPSADBW(opimm8, opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMULPDValidFormsNoError(t *testing.T) {
	if _, err := VMULPD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPD(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMULPD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VMULPD_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPD_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPD_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPD_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPD_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPD_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMULPD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VMULPD_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPD_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPD_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMULPD_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VMULPD_RD_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPD_RD_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMULPD_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VMULPD_RD_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMULPD_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VMULPD_RN_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPD_RN_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMULPD_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VMULPD_RN_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMULPD_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VMULPD_RU_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPD_RU_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMULPD_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VMULPD_RU_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMULPD_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VMULPD_RZ_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPD_RZ_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMULPD_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VMULPD_RZ_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMULPD_ZValidFormsNoError(t *testing.T) {
	if _, err := VMULPD_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMULPSValidFormsNoError(t *testing.T) {
	if _, err := VMULPS(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPS(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPS(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPS(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPS(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPS(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPS(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPS(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPS(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPS(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMULPS_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VMULPS_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPS_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPS_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPS_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPS_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPS_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMULPS_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VMULPS_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPS_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPS_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMULPS_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VMULPS_RD_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPS_RD_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMULPS_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VMULPS_RD_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMULPS_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VMULPS_RN_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPS_RN_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMULPS_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VMULPS_RN_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMULPS_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VMULPS_RU_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPS_RU_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMULPS_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VMULPS_RU_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMULPS_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VMULPS_RZ_SAE(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPS_RZ_SAE(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMULPS_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VMULPS_RZ_SAE_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMULPS_ZValidFormsNoError(t *testing.T) {
	if _, err := VMULPS_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPS_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPS_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPS_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULPS_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMULSDValidFormsNoError(t *testing.T) {
	if _, err := VMULSD(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULSD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULSD(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULSD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMULSD_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VMULSD_RD_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULSD_RD_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMULSD_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VMULSD_RD_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMULSD_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VMULSD_RN_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULSD_RN_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMULSD_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VMULSD_RN_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMULSD_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VMULSD_RU_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULSD_RU_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMULSD_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VMULSD_RU_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMULSD_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VMULSD_RZ_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULSD_RZ_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMULSD_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VMULSD_RZ_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMULSD_ZValidFormsNoError(t *testing.T) {
	if _, err := VMULSD_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULSD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMULSSValidFormsNoError(t *testing.T) {
	if _, err := VMULSS(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULSS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULSS(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULSS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMULSS_RD_SAEValidFormsNoError(t *testing.T) {
	if _, err := VMULSS_RD_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULSS_RD_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMULSS_RD_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VMULSS_RD_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMULSS_RN_SAEValidFormsNoError(t *testing.T) {
	if _, err := VMULSS_RN_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULSS_RN_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMULSS_RN_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VMULSS_RN_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMULSS_RU_SAEValidFormsNoError(t *testing.T) {
	if _, err := VMULSS_RU_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULSS_RU_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMULSS_RU_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VMULSS_RU_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMULSS_RZ_SAEValidFormsNoError(t *testing.T) {
	if _, err := VMULSS_RZ_SAE(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULSS_RZ_SAE(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMULSS_RZ_SAE_ZValidFormsNoError(t *testing.T) {
	if _, err := VMULSS_RZ_SAE_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVMULSS_ZValidFormsNoError(t *testing.T) {
	if _, err := VMULSS_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VMULSS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVORPDValidFormsNoError(t *testing.T) {
	if _, err := VORPD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VORPD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VORPD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VORPD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VORPD(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VORPD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VORPD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VORPD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VORPD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VORPD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VORPD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VORPD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVORPD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VORPD_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VORPD_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VORPD_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VORPD_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VORPD_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VORPD_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVORPD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VORPD_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VORPD_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VORPD_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVORPD_ZValidFormsNoError(t *testing.T) {
	if _, err := VORPD_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VORPD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VORPD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VORPD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VORPD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VORPD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVORPSValidFormsNoError(t *testing.T) {
	if _, err := VORPS(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VORPS(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VORPS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VORPS(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VORPS(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VORPS(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VORPS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VORPS(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VORPS(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VORPS(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VORPS(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VORPS(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVORPS_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VORPS_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VORPS_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VORPS_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VORPS_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VORPS_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VORPS_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVORPS_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VORPS_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VORPS_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VORPS_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVORPS_ZValidFormsNoError(t *testing.T) {
	if _, err := VORPS_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VORPS_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VORPS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VORPS_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VORPS_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VORPS_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPABSBValidFormsNoError(t *testing.T) {
	if _, err := VPABSB(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSB(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSB(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSB(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSB(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSB(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSB(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSB(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSB(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSB(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSB(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSB(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPABSB_ZValidFormsNoError(t *testing.T) {
	if _, err := VPABSB_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSB_Z(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSB_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSB_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSB_Z(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSB_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPABSDValidFormsNoError(t *testing.T) {
	if _, err := VPABSD(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSD(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSD(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSD(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSD(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSD(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSD(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSD(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSD(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSD(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSD(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPABSD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPABSD_BCST(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSD_BCST(opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSD_BCST(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSD_BCST(opm32, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSD_BCST(opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSD_BCST(opm32, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPABSD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPABSD_BCST_Z(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSD_BCST_Z(opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSD_BCST_Z(opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPABSD_ZValidFormsNoError(t *testing.T) {
	if _, err := VPABSD_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSD_Z(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSD_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSD_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSD_Z(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSD_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPABSQValidFormsNoError(t *testing.T) {
	if _, err := VPABSQ(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSQ(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSQ(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSQ(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSQ(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSQ(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSQ(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSQ(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSQ(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSQ(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSQ(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSQ(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPABSQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPABSQ_BCST(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSQ_BCST(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSQ_BCST(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSQ_BCST(opm64, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSQ_BCST(opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSQ_BCST(opm64, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPABSQ_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPABSQ_BCST_Z(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSQ_BCST_Z(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSQ_BCST_Z(opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPABSQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VPABSQ_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSQ_Z(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSQ_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSQ_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSQ_Z(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSQ_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPABSWValidFormsNoError(t *testing.T) {
	if _, err := VPABSW(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSW(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSW(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSW(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSW(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSW(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSW(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSW(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSW(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSW(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSW(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPABSW_ZValidFormsNoError(t *testing.T) {
	if _, err := VPABSW_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSW_Z(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSW_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSW_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSW_Z(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPABSW_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPACKSSDWValidFormsNoError(t *testing.T) {
	if _, err := VPACKSSDW(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKSSDW(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKSSDW(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKSSDW(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKSSDW(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKSSDW(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKSSDW(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKSSDW(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKSSDW(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKSSDW(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKSSDW(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKSSDW(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPACKSSDW_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPACKSSDW_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKSSDW_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKSSDW_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKSSDW_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKSSDW_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKSSDW_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPACKSSDW_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPACKSSDW_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKSSDW_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKSSDW_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPACKSSDW_ZValidFormsNoError(t *testing.T) {
	if _, err := VPACKSSDW_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKSSDW_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKSSDW_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKSSDW_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKSSDW_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKSSDW_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPACKSSWBValidFormsNoError(t *testing.T) {
	if _, err := VPACKSSWB(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKSSWB(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKSSWB(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKSSWB(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKSSWB(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKSSWB(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKSSWB(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKSSWB(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKSSWB(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKSSWB(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKSSWB(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKSSWB(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPACKSSWB_ZValidFormsNoError(t *testing.T) {
	if _, err := VPACKSSWB_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKSSWB_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKSSWB_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKSSWB_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKSSWB_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKSSWB_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPACKUSDWValidFormsNoError(t *testing.T) {
	if _, err := VPACKUSDW(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKUSDW(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKUSDW(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKUSDW(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKUSDW(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKUSDW(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKUSDW(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKUSDW(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKUSDW(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKUSDW(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKUSDW(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKUSDW(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPACKUSDW_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPACKUSDW_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKUSDW_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKUSDW_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKUSDW_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKUSDW_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKUSDW_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPACKUSDW_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPACKUSDW_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKUSDW_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKUSDW_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPACKUSDW_ZValidFormsNoError(t *testing.T) {
	if _, err := VPACKUSDW_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKUSDW_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKUSDW_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKUSDW_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKUSDW_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKUSDW_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPACKUSWBValidFormsNoError(t *testing.T) {
	if _, err := VPACKUSWB(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKUSWB(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKUSWB(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKUSWB(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKUSWB(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKUSWB(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKUSWB(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKUSWB(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKUSWB(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKUSWB(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKUSWB(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKUSWB(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPACKUSWB_ZValidFormsNoError(t *testing.T) {
	if _, err := VPACKUSWB_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKUSWB_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKUSWB_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKUSWB_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKUSWB_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPACKUSWB_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPADDBValidFormsNoError(t *testing.T) {
	if _, err := VPADDB(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDB(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDB(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDB(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDB(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDB(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDB(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDB(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDB(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDB(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDB(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDB(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPADDB_ZValidFormsNoError(t *testing.T) {
	if _, err := VPADDB_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDB_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDB_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDB_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDB_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDB_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPADDDValidFormsNoError(t *testing.T) {
	if _, err := VPADDD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDD(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPADDD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPADDD_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDD_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDD_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDD_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDD_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDD_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPADDD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPADDD_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDD_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDD_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPADDD_ZValidFormsNoError(t *testing.T) {
	if _, err := VPADDD_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPADDQValidFormsNoError(t *testing.T) {
	if _, err := VPADDQ(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDQ(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDQ(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDQ(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDQ(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDQ(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDQ(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDQ(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDQ(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDQ(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDQ(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDQ(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPADDQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPADDQ_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDQ_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDQ_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDQ_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDQ_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDQ_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPADDQ_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPADDQ_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDQ_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDQ_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPADDQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VPADDQ_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDQ_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDQ_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDQ_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDQ_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDQ_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPADDSBValidFormsNoError(t *testing.T) {
	if _, err := VPADDSB(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDSB(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDSB(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDSB(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDSB(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDSB(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDSB(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDSB(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDSB(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDSB(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDSB(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDSB(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPADDSB_ZValidFormsNoError(t *testing.T) {
	if _, err := VPADDSB_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDSB_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDSB_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDSB_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDSB_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDSB_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPADDSWValidFormsNoError(t *testing.T) {
	if _, err := VPADDSW(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDSW(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDSW(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDSW(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDSW(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDSW(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDSW(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDSW(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDSW(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDSW(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDSW(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDSW(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPADDSW_ZValidFormsNoError(t *testing.T) {
	if _, err := VPADDSW_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDSW_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDSW_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDSW_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDSW_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDSW_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPADDUSBValidFormsNoError(t *testing.T) {
	if _, err := VPADDUSB(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDUSB(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDUSB(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDUSB(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDUSB(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDUSB(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDUSB(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDUSB(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDUSB(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDUSB(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDUSB(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDUSB(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPADDUSB_ZValidFormsNoError(t *testing.T) {
	if _, err := VPADDUSB_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDUSB_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDUSB_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDUSB_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDUSB_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDUSB_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPADDUSWValidFormsNoError(t *testing.T) {
	if _, err := VPADDUSW(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDUSW(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDUSW(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDUSW(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDUSW(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDUSW(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDUSW(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDUSW(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDUSW(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDUSW(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDUSW(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDUSW(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPADDUSW_ZValidFormsNoError(t *testing.T) {
	if _, err := VPADDUSW_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDUSW_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDUSW_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDUSW_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDUSW_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDUSW_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPADDWValidFormsNoError(t *testing.T) {
	if _, err := VPADDW(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDW(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDW(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDW(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDW(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDW(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDW(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDW(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDW(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDW(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDW(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDW(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPADDW_ZValidFormsNoError(t *testing.T) {
	if _, err := VPADDW_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDW_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDW_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDW_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDW_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPADDW_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPALIGNRValidFormsNoError(t *testing.T) {
	if _, err := VPALIGNR(opimm8, opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPALIGNR(opimm8, opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPALIGNR(opimm8, opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPALIGNR(opimm8, opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPALIGNR(opimm8, opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPALIGNR(opimm8, opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPALIGNR(opimm8, opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPALIGNR(opimm8, opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPALIGNR(opimm8, opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPALIGNR(opimm8, opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPALIGNR(opimm8, opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPALIGNR(opimm8, opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPALIGNR_ZValidFormsNoError(t *testing.T) {
	if _, err := VPALIGNR_Z(opimm8, opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPALIGNR_Z(opimm8, opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPALIGNR_Z(opimm8, opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPALIGNR_Z(opimm8, opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPALIGNR_Z(opimm8, opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPALIGNR_Z(opimm8, opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPANDValidFormsNoError(t *testing.T) {
	if _, err := VPAND(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPAND(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPAND(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPAND(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPANDDValidFormsNoError(t *testing.T) {
	if _, err := VPANDD(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPANDD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPANDD_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDD_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDD_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDD_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDD_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDD_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPANDD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPANDD_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDD_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDD_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPANDD_ZValidFormsNoError(t *testing.T) {
	if _, err := VPANDD_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPANDNValidFormsNoError(t *testing.T) {
	if _, err := VPANDN(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDN(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDN(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDN(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPANDNDValidFormsNoError(t *testing.T) {
	if _, err := VPANDND(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDND(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDND(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDND(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDND(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDND(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDND(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDND(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDND(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDND(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDND(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDND(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPANDND_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPANDND_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDND_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDND_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDND_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDND_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDND_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPANDND_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPANDND_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDND_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDND_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPANDND_ZValidFormsNoError(t *testing.T) {
	if _, err := VPANDND_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDND_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDND_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDND_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDND_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDND_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPANDNQValidFormsNoError(t *testing.T) {
	if _, err := VPANDNQ(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDNQ(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDNQ(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDNQ(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDNQ(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDNQ(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDNQ(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDNQ(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDNQ(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDNQ(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDNQ(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDNQ(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPANDNQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPANDNQ_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDNQ_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDNQ_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDNQ_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDNQ_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDNQ_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPANDNQ_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPANDNQ_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDNQ_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDNQ_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPANDNQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VPANDNQ_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDNQ_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDNQ_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDNQ_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDNQ_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDNQ_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPANDQValidFormsNoError(t *testing.T) {
	if _, err := VPANDQ(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDQ(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDQ(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDQ(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDQ(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDQ(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDQ(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDQ(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDQ(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDQ(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDQ(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDQ(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPANDQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPANDQ_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDQ_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDQ_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDQ_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDQ_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDQ_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPANDQ_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPANDQ_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDQ_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDQ_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPANDQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VPANDQ_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDQ_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDQ_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDQ_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDQ_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPANDQ_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPAVGBValidFormsNoError(t *testing.T) {
	if _, err := VPAVGB(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPAVGB(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPAVGB(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPAVGB(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPAVGB(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPAVGB(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPAVGB(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPAVGB(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPAVGB(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPAVGB(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPAVGB(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPAVGB(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPAVGB_ZValidFormsNoError(t *testing.T) {
	if _, err := VPAVGB_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPAVGB_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPAVGB_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPAVGB_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPAVGB_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPAVGB_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPAVGWValidFormsNoError(t *testing.T) {
	if _, err := VPAVGW(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPAVGW(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPAVGW(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPAVGW(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPAVGW(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPAVGW(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPAVGW(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPAVGW(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPAVGW(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPAVGW(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPAVGW(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPAVGW(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPAVGW_ZValidFormsNoError(t *testing.T) {
	if _, err := VPAVGW_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPAVGW_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPAVGW_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPAVGW_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPAVGW_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPAVGW_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPBLENDDValidFormsNoError(t *testing.T) {
	if _, err := VPBLENDD(opimm8, opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDD(opimm8, opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDD(opimm8, opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDD(opimm8, opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVPBLENDMBValidFormsNoError(t *testing.T) {
	if _, err := VPBLENDMB(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMB(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMB(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMB(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMB(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMB(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMB(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMB(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMB(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMB(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMB(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMB(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPBLENDMB_ZValidFormsNoError(t *testing.T) {
	if _, err := VPBLENDMB_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMB_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMB_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMB_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMB_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMB_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPBLENDMDValidFormsNoError(t *testing.T) {
	if _, err := VPBLENDMD(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPBLENDMD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPBLENDMD_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMD_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMD_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMD_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMD_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMD_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPBLENDMD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPBLENDMD_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMD_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMD_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPBLENDMD_ZValidFormsNoError(t *testing.T) {
	if _, err := VPBLENDMD_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPBLENDMQValidFormsNoError(t *testing.T) {
	if _, err := VPBLENDMQ(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMQ(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMQ(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMQ(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMQ(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMQ(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMQ(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMQ(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMQ(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMQ(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMQ(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMQ(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPBLENDMQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPBLENDMQ_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMQ_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMQ_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMQ_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMQ_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMQ_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPBLENDMQ_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPBLENDMQ_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMQ_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMQ_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPBLENDMQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VPBLENDMQ_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMQ_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMQ_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMQ_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMQ_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMQ_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPBLENDMWValidFormsNoError(t *testing.T) {
	if _, err := VPBLENDMW(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMW(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMW(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMW(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMW(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMW(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMW(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMW(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMW(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMW(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMW(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMW(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPBLENDMW_ZValidFormsNoError(t *testing.T) {
	if _, err := VPBLENDMW_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMW_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMW_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMW_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMW_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDMW_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPBLENDVBValidFormsNoError(t *testing.T) {
	if _, err := VPBLENDVB(opymm, opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDVB(opymm, opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDVB(opxmm, opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDVB(opxmm, opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPBLENDWValidFormsNoError(t *testing.T) {
	if _, err := VPBLENDW(opimm8, opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDW(opimm8, opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDW(opimm8, opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBLENDW(opimm8, opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPBROADCASTBValidFormsNoError(t *testing.T) {
	if _, err := VPBROADCASTB(opm8, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTB(opm8, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTB(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTB(opxmm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTB(opm8, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTB(opm8, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTB(opr32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTB(opr32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTB(opr32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTB(opr32, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTB(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTB(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTB(opm8, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTB(opm8, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTB(opr32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTB(opr32, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTB(opxmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTB(opxmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPBROADCASTB_ZValidFormsNoError(t *testing.T) {
	if _, err := VPBROADCASTB_Z(opm8, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTB_Z(opm8, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTB_Z(opr32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTB_Z(opr32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTB_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTB_Z(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTB_Z(opm8, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTB_Z(opr32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTB_Z(opxmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPBROADCASTDValidFormsNoError(t *testing.T) {
	if _, err := VPBROADCASTD(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTD(opm32, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTD(opxmm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTD(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTD(opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTD(opr32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTD(opr32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTD(opr32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTD(opr32, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTD(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTD(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTD(opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTD(opm32, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTD(opr32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTD(opr32, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTD(opxmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTD(opxmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPBROADCASTD_ZValidFormsNoError(t *testing.T) {
	if _, err := VPBROADCASTD_Z(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTD_Z(opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTD_Z(opr32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTD_Z(opr32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTD_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTD_Z(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTD_Z(opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTD_Z(opr32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTD_Z(opxmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPBROADCASTMB2QValidFormsNoError(t *testing.T) {
	if _, err := VPBROADCASTMB2Q(opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTMB2Q(opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTMB2Q(opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPBROADCASTMW2DValidFormsNoError(t *testing.T) {
	if _, err := VPBROADCASTMW2D(opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTMW2D(opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTMW2D(opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPBROADCASTQValidFormsNoError(t *testing.T) {
	if _, err := VPBROADCASTQ(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTQ(opm64, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTQ(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTQ(opxmm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTQ(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTQ(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTQ(opr64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTQ(opr64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTQ(opr64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTQ(opr64, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTQ(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTQ(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTQ(opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTQ(opm64, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTQ(opr64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTQ(opr64, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTQ(opxmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTQ(opxmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPBROADCASTQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VPBROADCASTQ_Z(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTQ_Z(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTQ_Z(opr64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTQ_Z(opr64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTQ_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTQ_Z(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTQ_Z(opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTQ_Z(opr64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTQ_Z(opxmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPBROADCASTWValidFormsNoError(t *testing.T) {
	if _, err := VPBROADCASTW(opm16, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTW(opm16, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTW(opxmm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTW(opm16, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTW(opm16, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTW(opr32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTW(opr32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTW(opr32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTW(opr32, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTW(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTW(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTW(opm16, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTW(opm16, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTW(opr32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTW(opr32, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTW(opxmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTW(opxmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPBROADCASTW_ZValidFormsNoError(t *testing.T) {
	if _, err := VPBROADCASTW_Z(opm16, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTW_Z(opm16, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTW_Z(opr32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTW_Z(opr32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTW_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTW_Z(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTW_Z(opm16, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTW_Z(opr32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPBROADCASTW_Z(opxmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPCLMULQDQValidFormsNoError(t *testing.T) {
	if _, err := VPCLMULQDQ(opimm8, opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCLMULQDQ(opimm8, opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCLMULQDQ(opimm8, opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCLMULQDQ(opimm8, opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCLMULQDQ(opimm8, opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCLMULQDQ(opimm8, opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPCMPBValidFormsNoError(t *testing.T) {
	if _, err := VPCMPB(opimm8, opm128, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPB(opimm8, opm128, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPB(opimm8, opm256, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPB(opimm8, opm256, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPB(opimm8, opxmm, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPB(opimm8, opxmm, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPB(opimm8, opymm, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPB(opimm8, opymm, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPB(opimm8, opm512, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPB(opimm8, opm512, opzmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPB(opimm8, opzmm, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPB(opimm8, opzmm, opzmm, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVPCMPDValidFormsNoError(t *testing.T) {
	if _, err := VPCMPD(opimm8, opm128, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPD(opimm8, opm128, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPD(opimm8, opm256, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPD(opimm8, opm256, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPD(opimm8, opxmm, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPD(opimm8, opxmm, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPD(opimm8, opymm, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPD(opimm8, opymm, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPD(opimm8, opm512, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPD(opimm8, opm512, opzmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPD(opimm8, opzmm, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPD(opimm8, opzmm, opzmm, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVPCMPD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPCMPD_BCST(opimm8, opm32, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPD_BCST(opimm8, opm32, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPD_BCST(opimm8, opm32, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPD_BCST(opimm8, opm32, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPD_BCST(opimm8, opm32, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPD_BCST(opimm8, opm32, opzmm, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVPCMPEQBValidFormsNoError(t *testing.T) {
	if _, err := VPCMPEQB(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQB(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQB(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQB(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQB(opm128, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQB(opm128, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQB(opm256, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQB(opm256, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQB(opxmm, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQB(opxmm, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQB(opymm, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQB(opymm, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQB(opm512, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQB(opm512, opzmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQB(opzmm, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQB(opzmm, opzmm, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVPCMPEQDValidFormsNoError(t *testing.T) {
	if _, err := VPCMPEQD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQD(opm128, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQD(opm128, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQD(opm256, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQD(opm256, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQD(opxmm, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQD(opxmm, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQD(opymm, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQD(opymm, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQD(opm512, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQD(opm512, opzmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQD(opzmm, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQD(opzmm, opzmm, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVPCMPEQD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPCMPEQD_BCST(opm32, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQD_BCST(opm32, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQD_BCST(opm32, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQD_BCST(opm32, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQD_BCST(opm32, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQD_BCST(opm32, opzmm, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVPCMPEQQValidFormsNoError(t *testing.T) {
	if _, err := VPCMPEQQ(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQQ(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQQ(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQQ(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQQ(opm128, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQQ(opm128, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQQ(opm256, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQQ(opm256, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQQ(opxmm, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQQ(opxmm, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQQ(opymm, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQQ(opymm, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQQ(opm512, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQQ(opm512, opzmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQQ(opzmm, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQQ(opzmm, opzmm, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVPCMPEQQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPCMPEQQ_BCST(opm64, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQQ_BCST(opm64, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQQ_BCST(opm64, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQQ_BCST(opm64, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQQ_BCST(opm64, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQQ_BCST(opm64, opzmm, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVPCMPEQWValidFormsNoError(t *testing.T) {
	if _, err := VPCMPEQW(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQW(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQW(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQW(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQW(opm128, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQW(opm128, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQW(opm256, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQW(opm256, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQW(opxmm, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQW(opxmm, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQW(opymm, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQW(opymm, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQW(opm512, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQW(opm512, opzmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQW(opzmm, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPEQW(opzmm, opzmm, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVPCMPESTRIValidFormsNoError(t *testing.T) {
	if _, err := VPCMPESTRI(opimm8, opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPESTRI(opimm8, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPCMPESTRMValidFormsNoError(t *testing.T) {
	if _, err := VPCMPESTRM(opimm8, opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPESTRM(opimm8, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPCMPGTBValidFormsNoError(t *testing.T) {
	if _, err := VPCMPGTB(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTB(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTB(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTB(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTB(opm128, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTB(opm128, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTB(opm256, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTB(opm256, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTB(opxmm, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTB(opxmm, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTB(opymm, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTB(opymm, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTB(opm512, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTB(opm512, opzmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTB(opzmm, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTB(opzmm, opzmm, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVPCMPGTDValidFormsNoError(t *testing.T) {
	if _, err := VPCMPGTD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTD(opm128, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTD(opm128, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTD(opm256, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTD(opm256, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTD(opxmm, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTD(opxmm, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTD(opymm, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTD(opymm, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTD(opm512, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTD(opm512, opzmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTD(opzmm, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTD(opzmm, opzmm, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVPCMPGTD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPCMPGTD_BCST(opm32, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTD_BCST(opm32, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTD_BCST(opm32, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTD_BCST(opm32, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTD_BCST(opm32, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTD_BCST(opm32, opzmm, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVPCMPGTQValidFormsNoError(t *testing.T) {
	if _, err := VPCMPGTQ(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTQ(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTQ(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTQ(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTQ(opm128, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTQ(opm128, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTQ(opm256, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTQ(opm256, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTQ(opxmm, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTQ(opxmm, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTQ(opymm, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTQ(opymm, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTQ(opm512, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTQ(opm512, opzmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTQ(opzmm, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTQ(opzmm, opzmm, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVPCMPGTQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPCMPGTQ_BCST(opm64, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTQ_BCST(opm64, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTQ_BCST(opm64, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTQ_BCST(opm64, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTQ_BCST(opm64, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTQ_BCST(opm64, opzmm, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVPCMPGTWValidFormsNoError(t *testing.T) {
	if _, err := VPCMPGTW(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTW(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTW(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTW(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTW(opm128, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTW(opm128, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTW(opm256, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTW(opm256, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTW(opxmm, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTW(opxmm, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTW(opymm, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTW(opymm, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTW(opm512, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTW(opm512, opzmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTW(opzmm, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPGTW(opzmm, opzmm, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVPCMPISTRIValidFormsNoError(t *testing.T) {
	if _, err := VPCMPISTRI(opimm8, opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPISTRI(opimm8, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPCMPISTRMValidFormsNoError(t *testing.T) {
	if _, err := VPCMPISTRM(opimm8, opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPISTRM(opimm8, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPCMPQValidFormsNoError(t *testing.T) {
	if _, err := VPCMPQ(opimm8, opm128, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPQ(opimm8, opm128, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPQ(opimm8, opm256, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPQ(opimm8, opm256, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPQ(opimm8, opxmm, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPQ(opimm8, opxmm, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPQ(opimm8, opymm, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPQ(opimm8, opymm, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPQ(opimm8, opm512, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPQ(opimm8, opm512, opzmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPQ(opimm8, opzmm, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPQ(opimm8, opzmm, opzmm, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVPCMPQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPCMPQ_BCST(opimm8, opm64, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPQ_BCST(opimm8, opm64, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPQ_BCST(opimm8, opm64, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPQ_BCST(opimm8, opm64, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPQ_BCST(opimm8, opm64, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPQ_BCST(opimm8, opm64, opzmm, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVPCMPUBValidFormsNoError(t *testing.T) {
	if _, err := VPCMPUB(opimm8, opm128, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUB(opimm8, opm128, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUB(opimm8, opm256, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUB(opimm8, opm256, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUB(opimm8, opxmm, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUB(opimm8, opxmm, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUB(opimm8, opymm, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUB(opimm8, opymm, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUB(opimm8, opm512, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUB(opimm8, opm512, opzmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUB(opimm8, opzmm, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUB(opimm8, opzmm, opzmm, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVPCMPUDValidFormsNoError(t *testing.T) {
	if _, err := VPCMPUD(opimm8, opm128, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUD(opimm8, opm128, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUD(opimm8, opm256, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUD(opimm8, opm256, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUD(opimm8, opxmm, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUD(opimm8, opxmm, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUD(opimm8, opymm, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUD(opimm8, opymm, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUD(opimm8, opm512, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUD(opimm8, opm512, opzmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUD(opimm8, opzmm, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUD(opimm8, opzmm, opzmm, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVPCMPUD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPCMPUD_BCST(opimm8, opm32, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUD_BCST(opimm8, opm32, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUD_BCST(opimm8, opm32, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUD_BCST(opimm8, opm32, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUD_BCST(opimm8, opm32, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUD_BCST(opimm8, opm32, opzmm, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVPCMPUQValidFormsNoError(t *testing.T) {
	if _, err := VPCMPUQ(opimm8, opm128, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUQ(opimm8, opm128, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUQ(opimm8, opm256, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUQ(opimm8, opm256, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUQ(opimm8, opxmm, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUQ(opimm8, opxmm, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUQ(opimm8, opymm, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUQ(opimm8, opymm, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUQ(opimm8, opm512, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUQ(opimm8, opm512, opzmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUQ(opimm8, opzmm, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUQ(opimm8, opzmm, opzmm, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVPCMPUQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPCMPUQ_BCST(opimm8, opm64, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUQ_BCST(opimm8, opm64, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUQ_BCST(opimm8, opm64, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUQ_BCST(opimm8, opm64, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUQ_BCST(opimm8, opm64, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUQ_BCST(opimm8, opm64, opzmm, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVPCMPUWValidFormsNoError(t *testing.T) {
	if _, err := VPCMPUW(opimm8, opm128, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUW(opimm8, opm128, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUW(opimm8, opm256, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUW(opimm8, opm256, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUW(opimm8, opxmm, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUW(opimm8, opxmm, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUW(opimm8, opymm, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUW(opimm8, opymm, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUW(opimm8, opm512, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUW(opimm8, opm512, opzmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUW(opimm8, opzmm, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPUW(opimm8, opzmm, opzmm, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVPCMPWValidFormsNoError(t *testing.T) {
	if _, err := VPCMPW(opimm8, opm128, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPW(opimm8, opm128, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPW(opimm8, opm256, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPW(opimm8, opm256, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPW(opimm8, opxmm, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPW(opimm8, opxmm, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPW(opimm8, opymm, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPW(opimm8, opymm, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPW(opimm8, opm512, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPW(opimm8, opm512, opzmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPW(opimm8, opzmm, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCMPW(opimm8, opzmm, opzmm, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVPCOMPRESSBValidFormsNoError(t *testing.T) {
	if _, err := VPCOMPRESSB(opxmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSB(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSB(opxmm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSB(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSB(opymm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSB(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSB(opymm, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSB(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSB(opzmm, opk, opm512); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSB(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSB(opzmm, opm512); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSB(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPCOMPRESSB_ZValidFormsNoError(t *testing.T) {
	if _, err := VPCOMPRESSB_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSB_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSB_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPCOMPRESSDValidFormsNoError(t *testing.T) {
	if _, err := VPCOMPRESSD(opxmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSD(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSD(opxmm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSD(opymm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSD(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSD(opymm, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSD(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSD(opzmm, opk, opm512); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSD(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSD(opzmm, opm512); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSD(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPCOMPRESSD_ZValidFormsNoError(t *testing.T) {
	if _, err := VPCOMPRESSD_Z(opxmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSD_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSD_Z(opymm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSD_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSD_Z(opzmm, opk, opm512); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSD_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPCOMPRESSQValidFormsNoError(t *testing.T) {
	if _, err := VPCOMPRESSQ(opxmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSQ(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSQ(opxmm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSQ(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSQ(opymm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSQ(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSQ(opymm, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSQ(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSQ(opzmm, opk, opm512); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSQ(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSQ(opzmm, opm512); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSQ(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPCOMPRESSQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VPCOMPRESSQ_Z(opxmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSQ_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSQ_Z(opymm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSQ_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSQ_Z(opzmm, opk, opm512); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSQ_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPCOMPRESSWValidFormsNoError(t *testing.T) {
	if _, err := VPCOMPRESSW(opxmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSW(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSW(opxmm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSW(opymm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSW(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSW(opymm, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSW(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSW(opzmm, opk, opm512); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSW(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSW(opzmm, opm512); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSW(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPCOMPRESSW_ZValidFormsNoError(t *testing.T) {
	if _, err := VPCOMPRESSW_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSW_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCOMPRESSW_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPCONFLICTDValidFormsNoError(t *testing.T) {
	if _, err := VPCONFLICTD(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCONFLICTD(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCONFLICTD(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCONFLICTD(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCONFLICTD(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCONFLICTD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCONFLICTD(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCONFLICTD(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCONFLICTD(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCONFLICTD(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCONFLICTD(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCONFLICTD(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPCONFLICTD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPCONFLICTD_BCST(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCONFLICTD_BCST(opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCONFLICTD_BCST(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCONFLICTD_BCST(opm32, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCONFLICTD_BCST(opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCONFLICTD_BCST(opm32, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPCONFLICTD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPCONFLICTD_BCST_Z(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCONFLICTD_BCST_Z(opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCONFLICTD_BCST_Z(opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPCONFLICTD_ZValidFormsNoError(t *testing.T) {
	if _, err := VPCONFLICTD_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCONFLICTD_Z(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCONFLICTD_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCONFLICTD_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCONFLICTD_Z(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCONFLICTD_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPCONFLICTQValidFormsNoError(t *testing.T) {
	if _, err := VPCONFLICTQ(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCONFLICTQ(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCONFLICTQ(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCONFLICTQ(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCONFLICTQ(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCONFLICTQ(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCONFLICTQ(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCONFLICTQ(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCONFLICTQ(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCONFLICTQ(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCONFLICTQ(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCONFLICTQ(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPCONFLICTQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPCONFLICTQ_BCST(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCONFLICTQ_BCST(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCONFLICTQ_BCST(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCONFLICTQ_BCST(opm64, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCONFLICTQ_BCST(opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCONFLICTQ_BCST(opm64, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPCONFLICTQ_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPCONFLICTQ_BCST_Z(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCONFLICTQ_BCST_Z(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCONFLICTQ_BCST_Z(opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPCONFLICTQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VPCONFLICTQ_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCONFLICTQ_Z(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCONFLICTQ_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCONFLICTQ_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCONFLICTQ_Z(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPCONFLICTQ_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPDPBUSDValidFormsNoError(t *testing.T) {
	if _, err := VPDPBUSD(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPBUSD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPBUSD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPBUSD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPBUSD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPBUSD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPBUSD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPBUSD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPBUSD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPBUSD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPBUSD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPBUSD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPDPBUSDSValidFormsNoError(t *testing.T) {
	if _, err := VPDPBUSDS(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPBUSDS(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPBUSDS(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPBUSDS(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPBUSDS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPBUSDS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPBUSDS(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPBUSDS(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPBUSDS(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPBUSDS(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPBUSDS(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPBUSDS(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPDPBUSDS_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPDPBUSDS_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPBUSDS_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPBUSDS_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPBUSDS_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPBUSDS_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPBUSDS_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPDPBUSDS_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPDPBUSDS_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPBUSDS_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPBUSDS_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPDPBUSDS_ZValidFormsNoError(t *testing.T) {
	if _, err := VPDPBUSDS_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPBUSDS_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPBUSDS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPBUSDS_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPBUSDS_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPBUSDS_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPDPBUSD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPDPBUSD_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPBUSD_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPBUSD_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPBUSD_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPBUSD_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPBUSD_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPDPBUSD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPDPBUSD_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPBUSD_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPBUSD_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPDPBUSD_ZValidFormsNoError(t *testing.T) {
	if _, err := VPDPBUSD_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPBUSD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPBUSD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPBUSD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPBUSD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPBUSD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPDPWSSDValidFormsNoError(t *testing.T) {
	if _, err := VPDPWSSD(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPWSSD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPWSSD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPWSSD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPWSSD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPWSSD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPWSSD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPWSSD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPWSSD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPWSSD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPWSSD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPWSSD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPDPWSSDSValidFormsNoError(t *testing.T) {
	if _, err := VPDPWSSDS(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPWSSDS(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPWSSDS(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPWSSDS(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPWSSDS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPWSSDS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPWSSDS(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPWSSDS(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPWSSDS(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPWSSDS(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPWSSDS(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPWSSDS(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPDPWSSDS_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPDPWSSDS_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPWSSDS_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPWSSDS_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPWSSDS_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPWSSDS_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPWSSDS_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPDPWSSDS_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPDPWSSDS_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPWSSDS_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPWSSDS_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPDPWSSDS_ZValidFormsNoError(t *testing.T) {
	if _, err := VPDPWSSDS_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPWSSDS_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPWSSDS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPWSSDS_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPWSSDS_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPWSSDS_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPDPWSSD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPDPWSSD_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPWSSD_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPWSSD_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPWSSD_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPWSSD_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPWSSD_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPDPWSSD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPDPWSSD_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPWSSD_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPWSSD_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPDPWSSD_ZValidFormsNoError(t *testing.T) {
	if _, err := VPDPWSSD_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPWSSD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPWSSD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPWSSD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPWSSD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPDPWSSD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERM2F128ValidFormsNoError(t *testing.T) {
	if _, err := VPERM2F128(opimm8, opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERM2F128(opimm8, opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERM2I128ValidFormsNoError(t *testing.T) {
	if _, err := VPERM2I128(opimm8, opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERM2I128(opimm8, opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMBValidFormsNoError(t *testing.T) {
	if _, err := VPERMB(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMB(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMB(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMB(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMB(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMB(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMB(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMB(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMB(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMB(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMB(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMB(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMB_ZValidFormsNoError(t *testing.T) {
	if _, err := VPERMB_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMB_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMB_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMB_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMB_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMB_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMDValidFormsNoError(t *testing.T) {
	if _, err := VPERMD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPERMD_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMD_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMD_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMD_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPERMD_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMD_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMD_ZValidFormsNoError(t *testing.T) {
	if _, err := VPERMD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMI2BValidFormsNoError(t *testing.T) {
	if _, err := VPERMI2B(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2B(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2B(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2B(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2B(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2B(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2B(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2B(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2B(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2B(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2B(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2B(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMI2B_ZValidFormsNoError(t *testing.T) {
	if _, err := VPERMI2B_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2B_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2B_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2B_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2B_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2B_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMI2DValidFormsNoError(t *testing.T) {
	if _, err := VPERMI2D(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2D(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2D(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2D(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2D(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2D(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2D(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2D(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2D(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2D(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2D(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2D(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMI2D_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPERMI2D_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2D_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2D_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2D_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2D_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2D_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMI2D_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPERMI2D_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2D_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2D_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMI2D_ZValidFormsNoError(t *testing.T) {
	if _, err := VPERMI2D_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2D_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2D_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2D_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2D_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2D_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMI2PDValidFormsNoError(t *testing.T) {
	if _, err := VPERMI2PD(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2PD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2PD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2PD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2PD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2PD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2PD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2PD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2PD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2PD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2PD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2PD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMI2PD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPERMI2PD_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2PD_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2PD_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2PD_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2PD_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2PD_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMI2PD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPERMI2PD_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2PD_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2PD_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMI2PD_ZValidFormsNoError(t *testing.T) {
	if _, err := VPERMI2PD_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2PD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2PD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2PD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2PD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2PD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMI2PSValidFormsNoError(t *testing.T) {
	if _, err := VPERMI2PS(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2PS(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2PS(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2PS(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2PS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2PS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2PS(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2PS(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2PS(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2PS(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2PS(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2PS(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMI2PS_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPERMI2PS_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2PS_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2PS_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2PS_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2PS_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2PS_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMI2PS_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPERMI2PS_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2PS_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2PS_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMI2PS_ZValidFormsNoError(t *testing.T) {
	if _, err := VPERMI2PS_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2PS_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2PS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2PS_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2PS_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2PS_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMI2QValidFormsNoError(t *testing.T) {
	if _, err := VPERMI2Q(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2Q(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2Q(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2Q(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2Q(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2Q(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2Q(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2Q(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2Q(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2Q(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2Q(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2Q(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMI2Q_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPERMI2Q_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2Q_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2Q_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2Q_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2Q_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2Q_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMI2Q_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPERMI2Q_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2Q_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2Q_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMI2Q_ZValidFormsNoError(t *testing.T) {
	if _, err := VPERMI2Q_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2Q_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2Q_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2Q_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2Q_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2Q_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMI2WValidFormsNoError(t *testing.T) {
	if _, err := VPERMI2W(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2W(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2W(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2W(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2W(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2W(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2W(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2W(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2W(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2W(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2W(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2W(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMI2W_ZValidFormsNoError(t *testing.T) {
	if _, err := VPERMI2W_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2W_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2W_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2W_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2W_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMI2W_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMILPDValidFormsNoError(t *testing.T) {
	if _, err := VPERMILPD(opimm8, opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD(opimm8, opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD(opimm8, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD(opimm8, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD(opimm8, opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD(opimm8, opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD(opimm8, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD(opimm8, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD(opimm8, opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD(opimm8, opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD(opimm8, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD(opimm8, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMILPD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPERMILPD_BCST(opimm8, opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD_BCST(opimm8, opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD_BCST(opimm8, opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD_BCST(opimm8, opm64, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD_BCST(opimm8, opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD_BCST(opimm8, opm64, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMILPD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPERMILPD_BCST_Z(opimm8, opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD_BCST_Z(opimm8, opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD_BCST_Z(opimm8, opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMILPD_ZValidFormsNoError(t *testing.T) {
	if _, err := VPERMILPD_Z(opimm8, opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD_Z(opimm8, opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD_Z(opimm8, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD_Z(opimm8, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD_Z(opimm8, opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD_Z(opimm8, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMILPSValidFormsNoError(t *testing.T) {
	if _, err := VPERMILPS(opimm8, opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS(opimm8, opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS(opimm8, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS(opimm8, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS(opimm8, opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS(opimm8, opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS(opimm8, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS(opimm8, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS(opimm8, opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS(opimm8, opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS(opimm8, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS(opimm8, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMILPS_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPERMILPS_BCST(opimm8, opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS_BCST(opimm8, opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS_BCST(opimm8, opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS_BCST(opimm8, opm32, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS_BCST(opimm8, opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS_BCST(opimm8, opm32, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMILPS_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPERMILPS_BCST_Z(opimm8, opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS_BCST_Z(opimm8, opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS_BCST_Z(opimm8, opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMILPS_ZValidFormsNoError(t *testing.T) {
	if _, err := VPERMILPS_Z(opimm8, opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS_Z(opimm8, opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS_Z(opimm8, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS_Z(opimm8, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS_Z(opimm8, opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS_Z(opimm8, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMILPS_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMPDValidFormsNoError(t *testing.T) {
	if _, err := VPERMPD(opimm8, opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMPD(opimm8, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMPD(opimm8, opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMPD(opimm8, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMPD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMPD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMPD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMPD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMPD(opimm8, opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMPD(opimm8, opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMPD(opimm8, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMPD(opimm8, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMPD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMPD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMPD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMPD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMPD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPERMPD_BCST(opimm8, opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMPD_BCST(opimm8, opm64, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMPD_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMPD_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMPD_BCST(opimm8, opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMPD_BCST(opimm8, opm64, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMPD_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMPD_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMPD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPERMPD_BCST_Z(opimm8, opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMPD_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMPD_BCST_Z(opimm8, opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMPD_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMPD_ZValidFormsNoError(t *testing.T) {
	if _, err := VPERMPD_Z(opimm8, opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMPD_Z(opimm8, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMPD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMPD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMPD_Z(opimm8, opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMPD_Z(opimm8, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMPD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMPD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMPSValidFormsNoError(t *testing.T) {
	if _, err := VPERMPS(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMPS(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMPS(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMPS(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMPS(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMPS(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMPS(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMPS(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMPS_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPERMPS_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMPS_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMPS_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMPS_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMPS_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPERMPS_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMPS_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMPS_ZValidFormsNoError(t *testing.T) {
	if _, err := VPERMPS_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMPS_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMPS_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMPS_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMQValidFormsNoError(t *testing.T) {
	if _, err := VPERMQ(opimm8, opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMQ(opimm8, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMQ(opimm8, opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMQ(opimm8, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMQ(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMQ(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMQ(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMQ(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMQ(opimm8, opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMQ(opimm8, opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMQ(opimm8, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMQ(opimm8, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMQ(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMQ(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMQ(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMQ(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPERMQ_BCST(opimm8, opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMQ_BCST(opimm8, opm64, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMQ_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMQ_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMQ_BCST(opimm8, opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMQ_BCST(opimm8, opm64, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMQ_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMQ_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMQ_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPERMQ_BCST_Z(opimm8, opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMQ_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMQ_BCST_Z(opimm8, opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMQ_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VPERMQ_Z(opimm8, opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMQ_Z(opimm8, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMQ_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMQ_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMQ_Z(opimm8, opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMQ_Z(opimm8, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMQ_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMQ_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMT2BValidFormsNoError(t *testing.T) {
	if _, err := VPERMT2B(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2B(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2B(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2B(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2B(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2B(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2B(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2B(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2B(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2B(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2B(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2B(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMT2B_ZValidFormsNoError(t *testing.T) {
	if _, err := VPERMT2B_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2B_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2B_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2B_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2B_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2B_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMT2DValidFormsNoError(t *testing.T) {
	if _, err := VPERMT2D(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2D(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2D(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2D(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2D(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2D(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2D(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2D(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2D(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2D(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2D(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2D(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMT2D_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPERMT2D_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2D_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2D_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2D_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2D_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2D_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMT2D_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPERMT2D_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2D_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2D_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMT2D_ZValidFormsNoError(t *testing.T) {
	if _, err := VPERMT2D_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2D_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2D_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2D_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2D_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2D_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMT2PDValidFormsNoError(t *testing.T) {
	if _, err := VPERMT2PD(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2PD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2PD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2PD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2PD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2PD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2PD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2PD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2PD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2PD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2PD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2PD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMT2PD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPERMT2PD_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2PD_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2PD_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2PD_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2PD_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2PD_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMT2PD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPERMT2PD_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2PD_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2PD_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMT2PD_ZValidFormsNoError(t *testing.T) {
	if _, err := VPERMT2PD_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2PD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2PD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2PD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2PD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2PD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMT2PSValidFormsNoError(t *testing.T) {
	if _, err := VPERMT2PS(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2PS(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2PS(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2PS(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2PS(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2PS(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2PS(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2PS(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2PS(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2PS(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2PS(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2PS(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMT2PS_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPERMT2PS_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2PS_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2PS_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2PS_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2PS_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2PS_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMT2PS_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPERMT2PS_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2PS_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2PS_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMT2PS_ZValidFormsNoError(t *testing.T) {
	if _, err := VPERMT2PS_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2PS_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2PS_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2PS_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2PS_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2PS_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMT2QValidFormsNoError(t *testing.T) {
	if _, err := VPERMT2Q(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2Q(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2Q(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2Q(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2Q(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2Q(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2Q(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2Q(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2Q(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2Q(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2Q(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2Q(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMT2Q_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPERMT2Q_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2Q_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2Q_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2Q_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2Q_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2Q_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMT2Q_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPERMT2Q_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2Q_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2Q_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMT2Q_ZValidFormsNoError(t *testing.T) {
	if _, err := VPERMT2Q_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2Q_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2Q_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2Q_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2Q_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2Q_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMT2WValidFormsNoError(t *testing.T) {
	if _, err := VPERMT2W(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2W(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2W(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2W(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2W(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2W(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2W(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2W(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2W(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2W(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2W(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2W(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMT2W_ZValidFormsNoError(t *testing.T) {
	if _, err := VPERMT2W_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2W_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2W_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2W_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2W_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMT2W_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMWValidFormsNoError(t *testing.T) {
	if _, err := VPERMW(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMW(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMW(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMW(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMW(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMW(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMW(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMW(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMW(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMW(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMW(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMW(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPERMW_ZValidFormsNoError(t *testing.T) {
	if _, err := VPERMW_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMW_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMW_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMW_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMW_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPERMW_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPEXPANDBValidFormsNoError(t *testing.T) {
	if _, err := VPEXPANDB(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDB(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDB(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDB(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDB(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDB(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDB(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDB(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDB(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDB(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDB(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDB(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPEXPANDB_ZValidFormsNoError(t *testing.T) {
	if _, err := VPEXPANDB_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDB_Z(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDB_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDB_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDB_Z(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDB_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPEXPANDDValidFormsNoError(t *testing.T) {
	if _, err := VPEXPANDD(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDD(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDD(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDD(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDD(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDD(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDD(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDD(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDD(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDD(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDD(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPEXPANDD_ZValidFormsNoError(t *testing.T) {
	if _, err := VPEXPANDD_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDD_Z(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDD_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDD_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDD_Z(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDD_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPEXPANDQValidFormsNoError(t *testing.T) {
	if _, err := VPEXPANDQ(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDQ(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDQ(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDQ(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDQ(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDQ(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDQ(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDQ(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDQ(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDQ(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDQ(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDQ(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPEXPANDQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VPEXPANDQ_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDQ_Z(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDQ_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDQ_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDQ_Z(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDQ_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPEXPANDWValidFormsNoError(t *testing.T) {
	if _, err := VPEXPANDW(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDW(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDW(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDW(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDW(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDW(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDW(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDW(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDW(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDW(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDW(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPEXPANDW_ZValidFormsNoError(t *testing.T) {
	if _, err := VPEXPANDW_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDW_Z(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDW_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDW_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDW_Z(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXPANDW_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPEXTRBValidFormsNoError(t *testing.T) {
	if _, err := VPEXTRB(opimm8, opxmm, opm8); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXTRB(opimm8, opxmm, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestVPEXTRDValidFormsNoError(t *testing.T) {
	if _, err := VPEXTRD(opimm8, opxmm, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXTRD(opimm8, opxmm, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestVPEXTRQValidFormsNoError(t *testing.T) {
	if _, err := VPEXTRQ(opimm8, opxmm, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXTRQ(opimm8, opxmm, opr64); err != nil {
		t.Fatal(err)
	}
}

func TestVPEXTRWValidFormsNoError(t *testing.T) {
	if _, err := VPEXTRW(opimm8, opxmm, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := VPEXTRW(opimm8, opxmm, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestVPGATHERDDValidFormsNoError(t *testing.T) {
	if _, err := VPGATHERDD(opxmm, opvm32x, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPGATHERDD(opymm, opvm32y, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPGATHERDD(opvm32x, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPGATHERDD(opvm32y, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPGATHERDD(opvm32z, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPGATHERDQValidFormsNoError(t *testing.T) {
	if _, err := VPGATHERDQ(opxmm, opvm32x, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPGATHERDQ(opymm, opvm32x, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPGATHERDQ(opvm32x, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPGATHERDQ(opvm32x, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPGATHERDQ(opvm32y, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPGATHERQDValidFormsNoError(t *testing.T) {
	if _, err := VPGATHERQD(opxmm, opvm64x, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPGATHERQD(opxmm, opvm64y, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPGATHERQD(opvm64x, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPGATHERQD(opvm64y, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPGATHERQD(opvm64z, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVPGATHERQQValidFormsNoError(t *testing.T) {
	if _, err := VPGATHERQQ(opxmm, opvm64x, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPGATHERQQ(opymm, opvm64y, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPGATHERQQ(opvm64x, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPGATHERQQ(opvm64y, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPGATHERQQ(opvm64z, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPHADDDValidFormsNoError(t *testing.T) {
	if _, err := VPHADDD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPHADDD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPHADDD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPHADDD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPHADDSWValidFormsNoError(t *testing.T) {
	if _, err := VPHADDSW(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPHADDSW(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPHADDSW(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPHADDSW(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPHADDWValidFormsNoError(t *testing.T) {
	if _, err := VPHADDW(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPHADDW(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPHADDW(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPHADDW(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPHMINPOSUWValidFormsNoError(t *testing.T) {
	if _, err := VPHMINPOSUW(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPHMINPOSUW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPHSUBDValidFormsNoError(t *testing.T) {
	if _, err := VPHSUBD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPHSUBD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPHSUBD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPHSUBD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPHSUBSWValidFormsNoError(t *testing.T) {
	if _, err := VPHSUBSW(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPHSUBSW(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPHSUBSW(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPHSUBSW(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPHSUBWValidFormsNoError(t *testing.T) {
	if _, err := VPHSUBW(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPHSUBW(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPHSUBW(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPHSUBW(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPINSRBValidFormsNoError(t *testing.T) {
	if _, err := VPINSRB(opimm8, opm8, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPINSRB(opimm8, opr32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPINSRDValidFormsNoError(t *testing.T) {
	if _, err := VPINSRD(opimm8, opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPINSRD(opimm8, opr32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPINSRQValidFormsNoError(t *testing.T) {
	if _, err := VPINSRQ(opimm8, opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPINSRQ(opimm8, opr64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPINSRWValidFormsNoError(t *testing.T) {
	if _, err := VPINSRW(opimm8, opm16, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPINSRW(opimm8, opr32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPLZCNTDValidFormsNoError(t *testing.T) {
	if _, err := VPLZCNTD(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPLZCNTD(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPLZCNTD(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPLZCNTD(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPLZCNTD(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPLZCNTD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPLZCNTD(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPLZCNTD(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPLZCNTD(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPLZCNTD(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPLZCNTD(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPLZCNTD(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPLZCNTD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPLZCNTD_BCST(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPLZCNTD_BCST(opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPLZCNTD_BCST(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPLZCNTD_BCST(opm32, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPLZCNTD_BCST(opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPLZCNTD_BCST(opm32, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPLZCNTD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPLZCNTD_BCST_Z(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPLZCNTD_BCST_Z(opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPLZCNTD_BCST_Z(opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPLZCNTD_ZValidFormsNoError(t *testing.T) {
	if _, err := VPLZCNTD_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPLZCNTD_Z(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPLZCNTD_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPLZCNTD_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPLZCNTD_Z(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPLZCNTD_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPLZCNTQValidFormsNoError(t *testing.T) {
	if _, err := VPLZCNTQ(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPLZCNTQ(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPLZCNTQ(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPLZCNTQ(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPLZCNTQ(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPLZCNTQ(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPLZCNTQ(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPLZCNTQ(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPLZCNTQ(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPLZCNTQ(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPLZCNTQ(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPLZCNTQ(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPLZCNTQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPLZCNTQ_BCST(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPLZCNTQ_BCST(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPLZCNTQ_BCST(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPLZCNTQ_BCST(opm64, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPLZCNTQ_BCST(opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPLZCNTQ_BCST(opm64, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPLZCNTQ_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPLZCNTQ_BCST_Z(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPLZCNTQ_BCST_Z(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPLZCNTQ_BCST_Z(opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPLZCNTQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VPLZCNTQ_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPLZCNTQ_Z(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPLZCNTQ_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPLZCNTQ_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPLZCNTQ_Z(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPLZCNTQ_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMADD52HUQValidFormsNoError(t *testing.T) {
	if _, err := VPMADD52HUQ(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADD52HUQ(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADD52HUQ(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADD52HUQ(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADD52HUQ(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADD52HUQ(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADD52HUQ(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADD52HUQ(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADD52HUQ(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADD52HUQ(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADD52HUQ(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADD52HUQ(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMADD52HUQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPMADD52HUQ_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADD52HUQ_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADD52HUQ_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADD52HUQ_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADD52HUQ_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADD52HUQ_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMADD52HUQ_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMADD52HUQ_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADD52HUQ_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADD52HUQ_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMADD52HUQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMADD52HUQ_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADD52HUQ_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADD52HUQ_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADD52HUQ_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADD52HUQ_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADD52HUQ_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMADD52LUQValidFormsNoError(t *testing.T) {
	if _, err := VPMADD52LUQ(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADD52LUQ(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADD52LUQ(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADD52LUQ(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADD52LUQ(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADD52LUQ(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADD52LUQ(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADD52LUQ(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADD52LUQ(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADD52LUQ(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADD52LUQ(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADD52LUQ(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMADD52LUQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPMADD52LUQ_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADD52LUQ_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADD52LUQ_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADD52LUQ_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADD52LUQ_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADD52LUQ_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMADD52LUQ_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMADD52LUQ_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADD52LUQ_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADD52LUQ_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMADD52LUQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMADD52LUQ_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADD52LUQ_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADD52LUQ_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADD52LUQ_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADD52LUQ_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADD52LUQ_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMADDUBSWValidFormsNoError(t *testing.T) {
	if _, err := VPMADDUBSW(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADDUBSW(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADDUBSW(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADDUBSW(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADDUBSW(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADDUBSW(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADDUBSW(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADDUBSW(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADDUBSW(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADDUBSW(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADDUBSW(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADDUBSW(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMADDUBSW_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMADDUBSW_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADDUBSW_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADDUBSW_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADDUBSW_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADDUBSW_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADDUBSW_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMADDWDValidFormsNoError(t *testing.T) {
	if _, err := VPMADDWD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADDWD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADDWD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADDWD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADDWD(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADDWD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADDWD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADDWD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADDWD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADDWD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADDWD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADDWD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMADDWD_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMADDWD_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADDWD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADDWD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADDWD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADDWD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMADDWD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMASKMOVDValidFormsNoError(t *testing.T) {
	if _, err := VPMASKMOVD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMASKMOVD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMASKMOVD(opxmm, opxmm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMASKMOVD(opymm, opymm, opm256); err != nil {
		t.Fatal(err)
	}
}

func TestVPMASKMOVQValidFormsNoError(t *testing.T) {
	if _, err := VPMASKMOVQ(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMASKMOVQ(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMASKMOVQ(opxmm, opxmm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMASKMOVQ(opymm, opymm, opm256); err != nil {
		t.Fatal(err)
	}
}

func TestVPMAXSBValidFormsNoError(t *testing.T) {
	if _, err := VPMAXSB(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSB(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSB(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSB(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSB(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSB(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSB(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSB(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSB(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSB(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSB(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSB(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMAXSB_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMAXSB_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSB_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSB_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSB_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSB_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSB_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMAXSDValidFormsNoError(t *testing.T) {
	if _, err := VPMAXSD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSD(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMAXSD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPMAXSD_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSD_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSD_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSD_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSD_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSD_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMAXSD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMAXSD_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSD_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSD_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMAXSD_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMAXSD_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMAXSQValidFormsNoError(t *testing.T) {
	if _, err := VPMAXSQ(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSQ(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSQ(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSQ(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSQ(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSQ(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSQ(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSQ(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSQ(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSQ(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSQ(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSQ(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMAXSQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPMAXSQ_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSQ_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSQ_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSQ_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSQ_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSQ_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMAXSQ_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMAXSQ_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSQ_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSQ_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMAXSQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMAXSQ_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSQ_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSQ_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSQ_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSQ_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSQ_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMAXSWValidFormsNoError(t *testing.T) {
	if _, err := VPMAXSW(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSW(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSW(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSW(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSW(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSW(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSW(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSW(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSW(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSW(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSW(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSW(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMAXSW_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMAXSW_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSW_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSW_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSW_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSW_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXSW_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMAXUBValidFormsNoError(t *testing.T) {
	if _, err := VPMAXUB(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUB(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUB(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUB(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUB(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUB(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUB(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUB(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUB(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUB(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUB(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUB(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMAXUB_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMAXUB_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUB_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUB_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUB_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUB_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUB_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMAXUDValidFormsNoError(t *testing.T) {
	if _, err := VPMAXUD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUD(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMAXUD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPMAXUD_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUD_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUD_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUD_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUD_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUD_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMAXUD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMAXUD_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUD_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUD_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMAXUD_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMAXUD_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMAXUQValidFormsNoError(t *testing.T) {
	if _, err := VPMAXUQ(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUQ(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUQ(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUQ(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUQ(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUQ(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUQ(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUQ(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUQ(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUQ(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUQ(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUQ(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMAXUQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPMAXUQ_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUQ_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUQ_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUQ_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUQ_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUQ_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMAXUQ_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMAXUQ_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUQ_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUQ_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMAXUQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMAXUQ_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUQ_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUQ_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUQ_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUQ_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUQ_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMAXUWValidFormsNoError(t *testing.T) {
	if _, err := VPMAXUW(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUW(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUW(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUW(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUW(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUW(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUW(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUW(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUW(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUW(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUW(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUW(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMAXUW_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMAXUW_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUW_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUW_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUW_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUW_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMAXUW_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMINSBValidFormsNoError(t *testing.T) {
	if _, err := VPMINSB(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSB(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSB(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSB(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSB(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSB(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSB(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSB(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSB(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSB(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSB(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSB(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMINSB_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMINSB_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSB_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSB_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSB_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSB_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSB_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMINSDValidFormsNoError(t *testing.T) {
	if _, err := VPMINSD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSD(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMINSD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPMINSD_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSD_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSD_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSD_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSD_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSD_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMINSD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMINSD_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSD_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSD_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMINSD_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMINSD_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMINSQValidFormsNoError(t *testing.T) {
	if _, err := VPMINSQ(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSQ(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSQ(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSQ(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSQ(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSQ(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSQ(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSQ(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSQ(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSQ(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSQ(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSQ(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMINSQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPMINSQ_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSQ_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSQ_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSQ_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSQ_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSQ_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMINSQ_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMINSQ_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSQ_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSQ_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMINSQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMINSQ_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSQ_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSQ_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSQ_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSQ_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSQ_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMINSWValidFormsNoError(t *testing.T) {
	if _, err := VPMINSW(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSW(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSW(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSW(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSW(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSW(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSW(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSW(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSW(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSW(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSW(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSW(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMINSW_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMINSW_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSW_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSW_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSW_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSW_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINSW_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMINUBValidFormsNoError(t *testing.T) {
	if _, err := VPMINUB(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUB(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUB(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUB(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUB(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUB(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUB(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUB(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUB(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUB(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUB(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUB(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMINUB_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMINUB_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUB_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUB_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUB_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUB_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUB_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMINUDValidFormsNoError(t *testing.T) {
	if _, err := VPMINUD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUD(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMINUD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPMINUD_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUD_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUD_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUD_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUD_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUD_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMINUD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMINUD_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUD_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUD_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMINUD_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMINUD_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMINUQValidFormsNoError(t *testing.T) {
	if _, err := VPMINUQ(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUQ(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUQ(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUQ(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUQ(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUQ(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUQ(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUQ(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUQ(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUQ(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUQ(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUQ(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMINUQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPMINUQ_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUQ_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUQ_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUQ_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUQ_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUQ_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMINUQ_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMINUQ_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUQ_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUQ_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMINUQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMINUQ_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUQ_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUQ_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUQ_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUQ_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUQ_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMINUWValidFormsNoError(t *testing.T) {
	if _, err := VPMINUW(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUW(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUW(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUW(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUW(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUW(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUW(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUW(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUW(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUW(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUW(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUW(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMINUW_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMINUW_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUW_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUW_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUW_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUW_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMINUW_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVB2MValidFormsNoError(t *testing.T) {
	if _, err := VPMOVB2M(opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVB2M(opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVB2M(opzmm, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVD2MValidFormsNoError(t *testing.T) {
	if _, err := VPMOVD2M(opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVD2M(opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVD2M(opzmm, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVDBValidFormsNoError(t *testing.T) {
	if _, err := VPMOVDB(opxmm, opk, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVDB(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVDB(opxmm, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVDB(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVDB(opymm, opk, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVDB(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVDB(opymm, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVDB(opymm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVDB(opzmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVDB(opzmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVDB(opzmm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVDB(opzmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVDB_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMOVDB_Z(opxmm, opk, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVDB_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVDB_Z(opymm, opk, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVDB_Z(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVDB_Z(opzmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVDB_Z(opzmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVDWValidFormsNoError(t *testing.T) {
	if _, err := VPMOVDW(opxmm, opk, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVDW(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVDW(opxmm, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVDW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVDW(opymm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVDW(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVDW(opymm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVDW(opymm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVDW(opzmm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVDW(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVDW(opzmm, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVDW(opzmm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVDW_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMOVDW_Z(opxmm, opk, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVDW_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVDW_Z(opymm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVDW_Z(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVDW_Z(opzmm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVDW_Z(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVM2BValidFormsNoError(t *testing.T) {
	if _, err := VPMOVM2B(opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVM2B(opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVM2B(opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVM2DValidFormsNoError(t *testing.T) {
	if _, err := VPMOVM2D(opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVM2D(opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVM2D(opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVM2QValidFormsNoError(t *testing.T) {
	if _, err := VPMOVM2Q(opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVM2Q(opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVM2Q(opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVM2WValidFormsNoError(t *testing.T) {
	if _, err := VPMOVM2W(opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVM2W(opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVM2W(opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVMSKBValidFormsNoError(t *testing.T) {
	if _, err := VPMOVMSKB(opymm, opr32); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVMSKB(opxmm, opr32); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVQ2MValidFormsNoError(t *testing.T) {
	if _, err := VPMOVQ2M(opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQ2M(opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQ2M(opzmm, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVQBValidFormsNoError(t *testing.T) {
	if _, err := VPMOVQB(opxmm, opk, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQB(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQB(opxmm, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQB(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQB(opymm, opk, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQB(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQB(opymm, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQB(opymm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQB(opzmm, opk, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQB(opzmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQB(opzmm, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQB(opzmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVQB_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMOVQB_Z(opxmm, opk, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQB_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQB_Z(opymm, opk, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQB_Z(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQB_Z(opzmm, opk, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQB_Z(opzmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVQDValidFormsNoError(t *testing.T) {
	if _, err := VPMOVQD(opxmm, opk, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQD(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQD(opxmm, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQD(opymm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQD(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQD(opymm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQD(opymm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQD(opzmm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQD(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQD(opzmm, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQD(opzmm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVQD_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMOVQD_Z(opxmm, opk, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQD_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQD_Z(opymm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQD_Z(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQD_Z(opzmm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQD_Z(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVQWValidFormsNoError(t *testing.T) {
	if _, err := VPMOVQW(opxmm, opk, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQW(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQW(opxmm, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQW(opymm, opk, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQW(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQW(opymm, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQW(opymm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQW(opzmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQW(opzmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQW(opzmm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQW(opzmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVQW_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMOVQW_Z(opxmm, opk, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQW_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQW_Z(opymm, opk, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQW_Z(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQW_Z(opzmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVQW_Z(opzmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVSDBValidFormsNoError(t *testing.T) {
	if _, err := VPMOVSDB(opxmm, opk, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSDB(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSDB(opxmm, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSDB(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSDB(opymm, opk, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSDB(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSDB(opymm, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSDB(opymm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSDB(opzmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSDB(opzmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSDB(opzmm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSDB(opzmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVSDB_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMOVSDB_Z(opxmm, opk, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSDB_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSDB_Z(opymm, opk, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSDB_Z(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSDB_Z(opzmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSDB_Z(opzmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVSDWValidFormsNoError(t *testing.T) {
	if _, err := VPMOVSDW(opxmm, opk, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSDW(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSDW(opxmm, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSDW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSDW(opymm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSDW(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSDW(opymm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSDW(opymm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSDW(opzmm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSDW(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSDW(opzmm, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSDW(opzmm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVSDW_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMOVSDW_Z(opxmm, opk, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSDW_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSDW_Z(opymm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSDW_Z(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSDW_Z(opzmm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSDW_Z(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVSQBValidFormsNoError(t *testing.T) {
	if _, err := VPMOVSQB(opxmm, opk, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQB(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQB(opxmm, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQB(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQB(opymm, opk, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQB(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQB(opymm, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQB(opymm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQB(opzmm, opk, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQB(opzmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQB(opzmm, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQB(opzmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVSQB_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMOVSQB_Z(opxmm, opk, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQB_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQB_Z(opymm, opk, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQB_Z(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQB_Z(opzmm, opk, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQB_Z(opzmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVSQDValidFormsNoError(t *testing.T) {
	if _, err := VPMOVSQD(opxmm, opk, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQD(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQD(opxmm, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQD(opymm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQD(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQD(opymm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQD(opymm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQD(opzmm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQD(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQD(opzmm, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQD(opzmm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVSQD_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMOVSQD_Z(opxmm, opk, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQD_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQD_Z(opymm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQD_Z(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQD_Z(opzmm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQD_Z(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVSQWValidFormsNoError(t *testing.T) {
	if _, err := VPMOVSQW(opxmm, opk, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQW(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQW(opxmm, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQW(opymm, opk, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQW(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQW(opymm, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQW(opymm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQW(opzmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQW(opzmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQW(opzmm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQW(opzmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVSQW_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMOVSQW_Z(opxmm, opk, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQW_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQW_Z(opymm, opk, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQW_Z(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQW_Z(opzmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSQW_Z(opzmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVSWBValidFormsNoError(t *testing.T) {
	if _, err := VPMOVSWB(opxmm, opk, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSWB(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSWB(opxmm, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSWB(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSWB(opymm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSWB(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSWB(opymm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSWB(opymm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSWB(opzmm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSWB(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSWB(opzmm, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSWB(opzmm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVSWB_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMOVSWB_Z(opxmm, opk, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSWB_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSWB_Z(opymm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSWB_Z(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSWB_Z(opzmm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSWB_Z(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVSXBDValidFormsNoError(t *testing.T) {
	if _, err := VPMOVSXBD(opm64, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBD(opxmm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBD(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBD(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBD(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBD(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBD(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBD(opm128, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBD(opm128, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBD(opxmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBD(opxmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVSXBD_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMOVSXBD_Z(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBD_Z(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBD_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBD_Z(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBD_Z(opm128, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBD_Z(opxmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVSXBQValidFormsNoError(t *testing.T) {
	if _, err := VPMOVSXBQ(opm32, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBQ(opxmm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBQ(opm16, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBQ(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBQ(opm16, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBQ(opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBQ(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBQ(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBQ(opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBQ(opm64, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBQ(opxmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBQ(opxmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVSXBQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMOVSXBQ_Z(opm16, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBQ_Z(opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBQ_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBQ_Z(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBQ_Z(opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBQ_Z(opxmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVSXBWValidFormsNoError(t *testing.T) {
	if _, err := VPMOVSXBW(opm128, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBW(opxmm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBW(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBW(opm128, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBW(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBW(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBW(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBW(opm256, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBW(opm256, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBW(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBW(opymm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVSXBW_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMOVSXBW_Z(opm128, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBW_Z(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBW_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBW_Z(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBW_Z(opm256, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXBW_Z(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVSXDQValidFormsNoError(t *testing.T) {
	if _, err := VPMOVSXDQ(opm128, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXDQ(opxmm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXDQ(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXDQ(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXDQ(opm128, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXDQ(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXDQ(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXDQ(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXDQ(opm256, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXDQ(opm256, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXDQ(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXDQ(opymm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVSXDQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMOVSXDQ_Z(opm128, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXDQ_Z(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXDQ_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXDQ_Z(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXDQ_Z(opm256, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXDQ_Z(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVSXWDValidFormsNoError(t *testing.T) {
	if _, err := VPMOVSXWD(opm128, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXWD(opxmm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXWD(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXWD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXWD(opm128, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXWD(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXWD(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXWD(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXWD(opm256, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXWD(opm256, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXWD(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXWD(opymm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVSXWD_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMOVSXWD_Z(opm128, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXWD_Z(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXWD_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXWD_Z(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXWD_Z(opm256, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXWD_Z(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVSXWQValidFormsNoError(t *testing.T) {
	if _, err := VPMOVSXWQ(opm64, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXWQ(opxmm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXWQ(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXWQ(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXWQ(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXWQ(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXWQ(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXWQ(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXWQ(opm128, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXWQ(opm128, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXWQ(opxmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXWQ(opxmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVSXWQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMOVSXWQ_Z(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXWQ_Z(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXWQ_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXWQ_Z(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXWQ_Z(opm128, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVSXWQ_Z(opxmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVUSDBValidFormsNoError(t *testing.T) {
	if _, err := VPMOVUSDB(opxmm, opk, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSDB(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSDB(opxmm, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSDB(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSDB(opymm, opk, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSDB(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSDB(opymm, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSDB(opymm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSDB(opzmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSDB(opzmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSDB(opzmm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSDB(opzmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVUSDB_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMOVUSDB_Z(opxmm, opk, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSDB_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSDB_Z(opymm, opk, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSDB_Z(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSDB_Z(opzmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSDB_Z(opzmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVUSDWValidFormsNoError(t *testing.T) {
	if _, err := VPMOVUSDW(opxmm, opk, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSDW(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSDW(opxmm, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSDW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSDW(opymm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSDW(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSDW(opymm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSDW(opymm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSDW(opzmm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSDW(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSDW(opzmm, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSDW(opzmm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVUSDW_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMOVUSDW_Z(opxmm, opk, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSDW_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSDW_Z(opymm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSDW_Z(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSDW_Z(opzmm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSDW_Z(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVUSQBValidFormsNoError(t *testing.T) {
	if _, err := VPMOVUSQB(opxmm, opk, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQB(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQB(opxmm, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQB(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQB(opymm, opk, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQB(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQB(opymm, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQB(opymm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQB(opzmm, opk, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQB(opzmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQB(opzmm, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQB(opzmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVUSQB_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMOVUSQB_Z(opxmm, opk, opm16); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQB_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQB_Z(opymm, opk, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQB_Z(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQB_Z(opzmm, opk, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQB_Z(opzmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVUSQDValidFormsNoError(t *testing.T) {
	if _, err := VPMOVUSQD(opxmm, opk, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQD(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQD(opxmm, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQD(opymm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQD(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQD(opymm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQD(opymm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQD(opzmm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQD(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQD(opzmm, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQD(opzmm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVUSQD_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMOVUSQD_Z(opxmm, opk, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQD_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQD_Z(opymm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQD_Z(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQD_Z(opzmm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQD_Z(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVUSQWValidFormsNoError(t *testing.T) {
	if _, err := VPMOVUSQW(opxmm, opk, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQW(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQW(opxmm, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQW(opymm, opk, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQW(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQW(opymm, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQW(opymm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQW(opzmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQW(opzmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQW(opzmm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQW(opzmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVUSQW_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMOVUSQW_Z(opxmm, opk, opm32); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQW_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQW_Z(opymm, opk, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQW_Z(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQW_Z(opzmm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSQW_Z(opzmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVUSWBValidFormsNoError(t *testing.T) {
	if _, err := VPMOVUSWB(opxmm, opk, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSWB(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSWB(opxmm, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSWB(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSWB(opymm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSWB(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSWB(opymm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSWB(opymm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSWB(opzmm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSWB(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSWB(opzmm, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSWB(opzmm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVUSWB_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMOVUSWB_Z(opxmm, opk, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSWB_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSWB_Z(opymm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSWB_Z(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSWB_Z(opzmm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVUSWB_Z(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVW2MValidFormsNoError(t *testing.T) {
	if _, err := VPMOVW2M(opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVW2M(opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVW2M(opzmm, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVWBValidFormsNoError(t *testing.T) {
	if _, err := VPMOVWB(opxmm, opk, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVWB(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVWB(opxmm, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVWB(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVWB(opymm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVWB(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVWB(opymm, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVWB(opymm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVWB(opzmm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVWB(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVWB(opzmm, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVWB(opzmm, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVWB_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMOVWB_Z(opxmm, opk, opm64); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVWB_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVWB_Z(opymm, opk, opm128); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVWB_Z(opymm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVWB_Z(opzmm, opk, opm256); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVWB_Z(opzmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVZXBDValidFormsNoError(t *testing.T) {
	if _, err := VPMOVZXBD(opm64, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBD(opxmm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBD(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBD(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBD(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBD(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBD(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBD(opm128, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBD(opm128, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBD(opxmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBD(opxmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVZXBD_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMOVZXBD_Z(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBD_Z(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBD_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBD_Z(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBD_Z(opm128, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBD_Z(opxmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVZXBQValidFormsNoError(t *testing.T) {
	if _, err := VPMOVZXBQ(opm32, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBQ(opxmm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBQ(opm16, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBQ(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBQ(opm16, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBQ(opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBQ(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBQ(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBQ(opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBQ(opm64, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBQ(opxmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBQ(opxmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVZXBQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMOVZXBQ_Z(opm16, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBQ_Z(opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBQ_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBQ_Z(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBQ_Z(opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBQ_Z(opxmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVZXBWValidFormsNoError(t *testing.T) {
	if _, err := VPMOVZXBW(opm128, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBW(opxmm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBW(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBW(opm128, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBW(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBW(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBW(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBW(opm256, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBW(opm256, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBW(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBW(opymm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVZXBW_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMOVZXBW_Z(opm128, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBW_Z(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBW_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBW_Z(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBW_Z(opm256, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXBW_Z(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVZXDQValidFormsNoError(t *testing.T) {
	if _, err := VPMOVZXDQ(opm128, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXDQ(opxmm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXDQ(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXDQ(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXDQ(opm128, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXDQ(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXDQ(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXDQ(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXDQ(opm256, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXDQ(opm256, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXDQ(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXDQ(opymm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVZXDQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMOVZXDQ_Z(opm128, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXDQ_Z(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXDQ_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXDQ_Z(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXDQ_Z(opm256, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXDQ_Z(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVZXWDValidFormsNoError(t *testing.T) {
	if _, err := VPMOVZXWD(opm128, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXWD(opxmm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXWD(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXWD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXWD(opm128, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXWD(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXWD(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXWD(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXWD(opm256, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXWD(opm256, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXWD(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXWD(opymm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVZXWD_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMOVZXWD_Z(opm128, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXWD_Z(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXWD_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXWD_Z(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXWD_Z(opm256, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXWD_Z(opymm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVZXWQValidFormsNoError(t *testing.T) {
	if _, err := VPMOVZXWQ(opm64, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXWQ(opxmm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXWQ(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXWQ(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXWQ(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXWQ(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXWQ(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXWQ(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXWQ(opm128, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXWQ(opm128, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXWQ(opxmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXWQ(opxmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMOVZXWQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMOVZXWQ_Z(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXWQ_Z(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXWQ_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXWQ_Z(opxmm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXWQ_Z(opm128, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMOVZXWQ_Z(opxmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMULDQValidFormsNoError(t *testing.T) {
	if _, err := VPMULDQ(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULDQ(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULDQ(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULDQ(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULDQ(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULDQ(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULDQ(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULDQ(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULDQ(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULDQ(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULDQ(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULDQ(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMULDQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPMULDQ_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULDQ_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULDQ_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULDQ_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULDQ_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULDQ_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMULDQ_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMULDQ_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULDQ_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULDQ_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMULDQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMULDQ_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULDQ_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULDQ_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULDQ_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULDQ_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULDQ_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMULHRSWValidFormsNoError(t *testing.T) {
	if _, err := VPMULHRSW(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHRSW(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHRSW(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHRSW(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHRSW(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHRSW(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHRSW(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHRSW(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHRSW(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHRSW(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHRSW(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHRSW(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMULHRSW_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMULHRSW_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHRSW_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHRSW_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHRSW_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHRSW_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHRSW_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMULHUWValidFormsNoError(t *testing.T) {
	if _, err := VPMULHUW(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHUW(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHUW(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHUW(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHUW(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHUW(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHUW(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHUW(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHUW(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHUW(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHUW(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHUW(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMULHUW_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMULHUW_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHUW_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHUW_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHUW_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHUW_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHUW_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMULHWValidFormsNoError(t *testing.T) {
	if _, err := VPMULHW(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHW(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHW(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHW(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHW(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHW(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHW(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHW(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHW(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHW(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHW(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHW(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMULHW_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMULHW_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHW_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHW_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHW_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHW_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULHW_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMULLDValidFormsNoError(t *testing.T) {
	if _, err := VPMULLD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLD(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMULLD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPMULLD_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLD_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLD_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLD_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLD_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLD_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMULLD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMULLD_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLD_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLD_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMULLD_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMULLD_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMULLQValidFormsNoError(t *testing.T) {
	if _, err := VPMULLQ(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLQ(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLQ(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLQ(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLQ(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLQ(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLQ(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLQ(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLQ(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLQ(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLQ(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLQ(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMULLQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPMULLQ_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLQ_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLQ_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLQ_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLQ_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLQ_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMULLQ_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMULLQ_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLQ_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLQ_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMULLQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMULLQ_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLQ_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLQ_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLQ_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLQ_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLQ_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMULLWValidFormsNoError(t *testing.T) {
	if _, err := VPMULLW(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLW(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLW(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLW(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLW(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLW(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLW(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLW(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLW(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLW(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLW(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLW(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMULLW_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMULLW_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLW_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLW_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLW_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLW_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULLW_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMULTISHIFTQBValidFormsNoError(t *testing.T) {
	if _, err := VPMULTISHIFTQB(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULTISHIFTQB(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULTISHIFTQB(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULTISHIFTQB(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULTISHIFTQB(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULTISHIFTQB(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULTISHIFTQB(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULTISHIFTQB(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULTISHIFTQB(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULTISHIFTQB(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULTISHIFTQB(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULTISHIFTQB(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMULTISHIFTQB_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPMULTISHIFTQB_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULTISHIFTQB_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULTISHIFTQB_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULTISHIFTQB_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULTISHIFTQB_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULTISHIFTQB_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMULTISHIFTQB_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMULTISHIFTQB_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULTISHIFTQB_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULTISHIFTQB_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMULTISHIFTQB_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMULTISHIFTQB_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULTISHIFTQB_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULTISHIFTQB_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULTISHIFTQB_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULTISHIFTQB_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULTISHIFTQB_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMULUDQValidFormsNoError(t *testing.T) {
	if _, err := VPMULUDQ(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULUDQ(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULUDQ(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULUDQ(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULUDQ(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULUDQ(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULUDQ(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULUDQ(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULUDQ(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULUDQ(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULUDQ(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULUDQ(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMULUDQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPMULUDQ_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULUDQ_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULUDQ_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULUDQ_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULUDQ_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULUDQ_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMULUDQ_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMULUDQ_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULUDQ_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULUDQ_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPMULUDQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VPMULUDQ_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULUDQ_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULUDQ_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULUDQ_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULUDQ_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPMULUDQ_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPOPCNTBValidFormsNoError(t *testing.T) {
	if _, err := VPOPCNTB(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTB(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTB(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTB(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTB(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTB(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTB(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTB(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTB(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTB(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTB(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTB(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPOPCNTB_ZValidFormsNoError(t *testing.T) {
	if _, err := VPOPCNTB_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTB_Z(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTB_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTB_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTB_Z(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTB_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPOPCNTDValidFormsNoError(t *testing.T) {
	if _, err := VPOPCNTD(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTD(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTD(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTD(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTD(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTD(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTD(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTD(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTD(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTD(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTD(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTD(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPOPCNTD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPOPCNTD_BCST(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTD_BCST(opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTD_BCST(opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTD_BCST(opm32, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTD_BCST(opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTD_BCST(opm32, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPOPCNTD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPOPCNTD_BCST_Z(opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTD_BCST_Z(opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTD_BCST_Z(opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPOPCNTD_ZValidFormsNoError(t *testing.T) {
	if _, err := VPOPCNTD_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTD_Z(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTD_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTD_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTD_Z(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTD_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPOPCNTQValidFormsNoError(t *testing.T) {
	if _, err := VPOPCNTQ(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTQ(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTQ(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTQ(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTQ(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTQ(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTQ(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTQ(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTQ(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTQ(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTQ(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTQ(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPOPCNTQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPOPCNTQ_BCST(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTQ_BCST(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTQ_BCST(opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTQ_BCST(opm64, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTQ_BCST(opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTQ_BCST(opm64, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPOPCNTQ_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPOPCNTQ_BCST_Z(opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTQ_BCST_Z(opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTQ_BCST_Z(opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPOPCNTQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VPOPCNTQ_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTQ_Z(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTQ_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTQ_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTQ_Z(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTQ_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPOPCNTWValidFormsNoError(t *testing.T) {
	if _, err := VPOPCNTW(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTW(opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTW(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTW(opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTW(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTW(opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTW(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTW(opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTW(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTW(opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTW(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTW(opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPOPCNTW_ZValidFormsNoError(t *testing.T) {
	if _, err := VPOPCNTW_Z(opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTW_Z(opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTW_Z(opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTW_Z(opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTW_Z(opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOPCNTW_Z(opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPORValidFormsNoError(t *testing.T) {
	if _, err := VPOR(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOR(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOR(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPOR(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPORDValidFormsNoError(t *testing.T) {
	if _, err := VPORD(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPORD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPORD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPORD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPORD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPORD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPORD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPORD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPORD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPORD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPORD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPORD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPORD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPORD_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPORD_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPORD_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPORD_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPORD_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPORD_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPORD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPORD_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPORD_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPORD_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPORD_ZValidFormsNoError(t *testing.T) {
	if _, err := VPORD_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPORD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPORD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPORD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPORD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPORD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPORQValidFormsNoError(t *testing.T) {
	if _, err := VPORQ(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPORQ(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPORQ(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPORQ(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPORQ(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPORQ(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPORQ(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPORQ(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPORQ(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPORQ(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPORQ(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPORQ(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPORQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPORQ_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPORQ_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPORQ_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPORQ_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPORQ_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPORQ_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPORQ_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPORQ_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPORQ_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPORQ_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPORQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VPORQ_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPORQ_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPORQ_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPORQ_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPORQ_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPORQ_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPROLDValidFormsNoError(t *testing.T) {
	if _, err := VPROLD(opimm8, opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLD(opimm8, opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLD(opimm8, opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLD(opimm8, opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLD(opimm8, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLD(opimm8, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLD(opimm8, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLD(opimm8, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLD(opimm8, opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLD(opimm8, opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLD(opimm8, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLD(opimm8, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPROLD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPROLD_BCST(opimm8, opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLD_BCST(opimm8, opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLD_BCST(opimm8, opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLD_BCST(opimm8, opm32, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLD_BCST(opimm8, opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLD_BCST(opimm8, opm32, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPROLD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPROLD_BCST_Z(opimm8, opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLD_BCST_Z(opimm8, opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLD_BCST_Z(opimm8, opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPROLD_ZValidFormsNoError(t *testing.T) {
	if _, err := VPROLD_Z(opimm8, opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLD_Z(opimm8, opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLD_Z(opimm8, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLD_Z(opimm8, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLD_Z(opimm8, opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLD_Z(opimm8, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPROLQValidFormsNoError(t *testing.T) {
	if _, err := VPROLQ(opimm8, opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLQ(opimm8, opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLQ(opimm8, opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLQ(opimm8, opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLQ(opimm8, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLQ(opimm8, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLQ(opimm8, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLQ(opimm8, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLQ(opimm8, opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLQ(opimm8, opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLQ(opimm8, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLQ(opimm8, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPROLQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPROLQ_BCST(opimm8, opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLQ_BCST(opimm8, opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLQ_BCST(opimm8, opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLQ_BCST(opimm8, opm64, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLQ_BCST(opimm8, opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLQ_BCST(opimm8, opm64, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPROLQ_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPROLQ_BCST_Z(opimm8, opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLQ_BCST_Z(opimm8, opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLQ_BCST_Z(opimm8, opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPROLQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VPROLQ_Z(opimm8, opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLQ_Z(opimm8, opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLQ_Z(opimm8, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLQ_Z(opimm8, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLQ_Z(opimm8, opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLQ_Z(opimm8, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPROLVDValidFormsNoError(t *testing.T) {
	if _, err := VPROLVD(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLVD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLVD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLVD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLVD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLVD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLVD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLVD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLVD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLVD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLVD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLVD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPROLVD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPROLVD_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLVD_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLVD_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLVD_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLVD_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLVD_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPROLVD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPROLVD_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLVD_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLVD_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPROLVD_ZValidFormsNoError(t *testing.T) {
	if _, err := VPROLVD_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLVD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLVD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLVD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLVD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLVD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPROLVQValidFormsNoError(t *testing.T) {
	if _, err := VPROLVQ(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLVQ(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLVQ(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLVQ(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLVQ(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLVQ(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLVQ(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLVQ(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLVQ(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLVQ(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLVQ(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLVQ(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPROLVQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPROLVQ_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLVQ_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLVQ_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLVQ_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLVQ_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLVQ_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPROLVQ_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPROLVQ_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLVQ_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLVQ_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPROLVQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VPROLVQ_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLVQ_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLVQ_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLVQ_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLVQ_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPROLVQ_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPRORDValidFormsNoError(t *testing.T) {
	if _, err := VPRORD(opimm8, opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORD(opimm8, opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORD(opimm8, opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORD(opimm8, opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORD(opimm8, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORD(opimm8, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORD(opimm8, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORD(opimm8, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORD(opimm8, opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORD(opimm8, opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORD(opimm8, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORD(opimm8, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPRORD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPRORD_BCST(opimm8, opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORD_BCST(opimm8, opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORD_BCST(opimm8, opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORD_BCST(opimm8, opm32, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORD_BCST(opimm8, opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORD_BCST(opimm8, opm32, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPRORD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPRORD_BCST_Z(opimm8, opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORD_BCST_Z(opimm8, opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORD_BCST_Z(opimm8, opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPRORD_ZValidFormsNoError(t *testing.T) {
	if _, err := VPRORD_Z(opimm8, opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORD_Z(opimm8, opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORD_Z(opimm8, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORD_Z(opimm8, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORD_Z(opimm8, opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORD_Z(opimm8, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPRORQValidFormsNoError(t *testing.T) {
	if _, err := VPRORQ(opimm8, opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORQ(opimm8, opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORQ(opimm8, opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORQ(opimm8, opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORQ(opimm8, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORQ(opimm8, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORQ(opimm8, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORQ(opimm8, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORQ(opimm8, opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORQ(opimm8, opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORQ(opimm8, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORQ(opimm8, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPRORQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPRORQ_BCST(opimm8, opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORQ_BCST(opimm8, opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORQ_BCST(opimm8, opm64, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORQ_BCST(opimm8, opm64, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORQ_BCST(opimm8, opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORQ_BCST(opimm8, opm64, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPRORQ_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPRORQ_BCST_Z(opimm8, opm64, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORQ_BCST_Z(opimm8, opm64, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORQ_BCST_Z(opimm8, opm64, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPRORQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VPRORQ_Z(opimm8, opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORQ_Z(opimm8, opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORQ_Z(opimm8, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORQ_Z(opimm8, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORQ_Z(opimm8, opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORQ_Z(opimm8, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPRORVDValidFormsNoError(t *testing.T) {
	if _, err := VPRORVD(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORVD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORVD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORVD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORVD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORVD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORVD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORVD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORVD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORVD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORVD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORVD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPRORVD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPRORVD_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORVD_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORVD_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORVD_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORVD_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORVD_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPRORVD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPRORVD_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORVD_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORVD_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPRORVD_ZValidFormsNoError(t *testing.T) {
	if _, err := VPRORVD_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORVD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORVD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORVD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORVD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORVD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPRORVQValidFormsNoError(t *testing.T) {
	if _, err := VPRORVQ(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORVQ(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORVQ(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORVQ(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORVQ(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORVQ(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORVQ(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORVQ(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORVQ(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORVQ(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORVQ(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORVQ(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPRORVQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPRORVQ_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORVQ_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORVQ_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORVQ_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORVQ_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORVQ_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPRORVQ_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPRORVQ_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORVQ_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORVQ_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPRORVQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VPRORVQ_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORVQ_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORVQ_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORVQ_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORVQ_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPRORVQ_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSADBWValidFormsNoError(t *testing.T) {
	if _, err := VPSADBW(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSADBW(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSADBW(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSADBW(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSADBW(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSADBW(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSCATTERDDValidFormsNoError(t *testing.T) {
	if _, err := VPSCATTERDD(opxmm, opk, opvm32x); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSCATTERDD(opymm, opk, opvm32y); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSCATTERDD(opzmm, opk, opvm32z); err != nil {
		t.Fatal(err)
	}
}

func TestVPSCATTERDQValidFormsNoError(t *testing.T) {
	if _, err := VPSCATTERDQ(opxmm, opk, opvm32x); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSCATTERDQ(opymm, opk, opvm32x); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSCATTERDQ(opzmm, opk, opvm32y); err != nil {
		t.Fatal(err)
	}
}

func TestVPSCATTERQDValidFormsNoError(t *testing.T) {
	if _, err := VPSCATTERQD(opxmm, opk, opvm64x); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSCATTERQD(opxmm, opk, opvm64y); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSCATTERQD(opymm, opk, opvm64z); err != nil {
		t.Fatal(err)
	}
}

func TestVPSCATTERQQValidFormsNoError(t *testing.T) {
	if _, err := VPSCATTERQQ(opxmm, opk, opvm64x); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSCATTERQQ(opymm, opk, opvm64y); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSCATTERQQ(opzmm, opk, opvm64z); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHLDDValidFormsNoError(t *testing.T) {
	if _, err := VPSHLDD(opimm8, opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDD(opimm8, opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDD(opimm8, opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDD(opimm8, opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDD(opimm8, opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDD(opimm8, opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDD(opimm8, opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDD(opimm8, opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDD(opimm8, opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDD(opimm8, opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDD(opimm8, opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDD(opimm8, opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHLDD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPSHLDD_BCST(opimm8, opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDD_BCST(opimm8, opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDD_BCST(opimm8, opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDD_BCST(opimm8, opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDD_BCST(opimm8, opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDD_BCST(opimm8, opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHLDD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPSHLDD_BCST_Z(opimm8, opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDD_BCST_Z(opimm8, opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDD_BCST_Z(opimm8, opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHLDD_ZValidFormsNoError(t *testing.T) {
	if _, err := VPSHLDD_Z(opimm8, opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDD_Z(opimm8, opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDD_Z(opimm8, opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDD_Z(opimm8, opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDD_Z(opimm8, opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDD_Z(opimm8, opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHLDQValidFormsNoError(t *testing.T) {
	if _, err := VPSHLDQ(opimm8, opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDQ(opimm8, opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDQ(opimm8, opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDQ(opimm8, opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDQ(opimm8, opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDQ(opimm8, opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDQ(opimm8, opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDQ(opimm8, opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDQ(opimm8, opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDQ(opimm8, opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDQ(opimm8, opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDQ(opimm8, opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHLDQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPSHLDQ_BCST(opimm8, opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDQ_BCST(opimm8, opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDQ_BCST(opimm8, opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDQ_BCST(opimm8, opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDQ_BCST(opimm8, opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDQ_BCST(opimm8, opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHLDQ_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPSHLDQ_BCST_Z(opimm8, opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDQ_BCST_Z(opimm8, opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDQ_BCST_Z(opimm8, opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHLDQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VPSHLDQ_Z(opimm8, opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDQ_Z(opimm8, opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDQ_Z(opimm8, opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDQ_Z(opimm8, opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDQ_Z(opimm8, opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDQ_Z(opimm8, opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHLDVDValidFormsNoError(t *testing.T) {
	if _, err := VPSHLDVD(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHLDVD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPSHLDVD_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVD_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVD_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVD_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVD_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVD_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHLDVD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPSHLDVD_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVD_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVD_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHLDVD_ZValidFormsNoError(t *testing.T) {
	if _, err := VPSHLDVD_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHLDVQValidFormsNoError(t *testing.T) {
	if _, err := VPSHLDVQ(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVQ(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVQ(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVQ(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVQ(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVQ(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVQ(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVQ(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVQ(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVQ(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVQ(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVQ(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHLDVQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPSHLDVQ_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVQ_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVQ_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVQ_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVQ_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVQ_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHLDVQ_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPSHLDVQ_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVQ_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVQ_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHLDVQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VPSHLDVQ_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVQ_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVQ_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVQ_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVQ_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVQ_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHLDVWValidFormsNoError(t *testing.T) {
	if _, err := VPSHLDVW(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVW(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVW(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVW(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVW(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVW(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVW(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVW(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVW(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVW(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVW(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVW(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHLDVW_ZValidFormsNoError(t *testing.T) {
	if _, err := VPSHLDVW_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVW_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVW_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVW_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVW_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDVW_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHLDWValidFormsNoError(t *testing.T) {
	if _, err := VPSHLDW(opimm8, opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDW(opimm8, opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDW(opimm8, opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDW(opimm8, opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDW(opimm8, opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDW(opimm8, opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDW(opimm8, opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDW(opimm8, opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDW(opimm8, opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDW(opimm8, opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDW(opimm8, opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDW(opimm8, opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHLDW_ZValidFormsNoError(t *testing.T) {
	if _, err := VPSHLDW_Z(opimm8, opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDW_Z(opimm8, opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDW_Z(opimm8, opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDW_Z(opimm8, opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDW_Z(opimm8, opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHLDW_Z(opimm8, opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHRDDValidFormsNoError(t *testing.T) {
	if _, err := VPSHRDD(opimm8, opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDD(opimm8, opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDD(opimm8, opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDD(opimm8, opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDD(opimm8, opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDD(opimm8, opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDD(opimm8, opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDD(opimm8, opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDD(opimm8, opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDD(opimm8, opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDD(opimm8, opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDD(opimm8, opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHRDD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPSHRDD_BCST(opimm8, opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDD_BCST(opimm8, opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDD_BCST(opimm8, opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDD_BCST(opimm8, opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDD_BCST(opimm8, opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDD_BCST(opimm8, opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHRDD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPSHRDD_BCST_Z(opimm8, opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDD_BCST_Z(opimm8, opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDD_BCST_Z(opimm8, opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHRDD_ZValidFormsNoError(t *testing.T) {
	if _, err := VPSHRDD_Z(opimm8, opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDD_Z(opimm8, opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDD_Z(opimm8, opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDD_Z(opimm8, opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDD_Z(opimm8, opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDD_Z(opimm8, opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHRDQValidFormsNoError(t *testing.T) {
	if _, err := VPSHRDQ(opimm8, opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDQ(opimm8, opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDQ(opimm8, opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDQ(opimm8, opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDQ(opimm8, opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDQ(opimm8, opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDQ(opimm8, opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDQ(opimm8, opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDQ(opimm8, opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDQ(opimm8, opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDQ(opimm8, opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDQ(opimm8, opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHRDQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPSHRDQ_BCST(opimm8, opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDQ_BCST(opimm8, opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDQ_BCST(opimm8, opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDQ_BCST(opimm8, opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDQ_BCST(opimm8, opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDQ_BCST(opimm8, opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHRDQ_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPSHRDQ_BCST_Z(opimm8, opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDQ_BCST_Z(opimm8, opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDQ_BCST_Z(opimm8, opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHRDQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VPSHRDQ_Z(opimm8, opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDQ_Z(opimm8, opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDQ_Z(opimm8, opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDQ_Z(opimm8, opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDQ_Z(opimm8, opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDQ_Z(opimm8, opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHRDVDValidFormsNoError(t *testing.T) {
	if _, err := VPSHRDVD(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVD(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVD(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVD(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVD(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVD(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVD(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVD(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVD(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVD(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHRDVD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPSHRDVD_BCST(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVD_BCST(opm32, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVD_BCST(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVD_BCST(opm32, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVD_BCST(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVD_BCST(opm32, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHRDVD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPSHRDVD_BCST_Z(opm32, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVD_BCST_Z(opm32, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVD_BCST_Z(opm32, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHRDVD_ZValidFormsNoError(t *testing.T) {
	if _, err := VPSHRDVD_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVD_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVD_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVD_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVD_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVD_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHRDVQValidFormsNoError(t *testing.T) {
	if _, err := VPSHRDVQ(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVQ(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVQ(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVQ(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVQ(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVQ(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVQ(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVQ(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVQ(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVQ(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVQ(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVQ(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHRDVQ_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPSHRDVQ_BCST(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVQ_BCST(opm64, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVQ_BCST(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVQ_BCST(opm64, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVQ_BCST(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVQ_BCST(opm64, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHRDVQ_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPSHRDVQ_BCST_Z(opm64, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVQ_BCST_Z(opm64, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVQ_BCST_Z(opm64, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHRDVQ_ZValidFormsNoError(t *testing.T) {
	if _, err := VPSHRDVQ_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVQ_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVQ_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVQ_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVQ_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVQ_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHRDVWValidFormsNoError(t *testing.T) {
	if _, err := VPSHRDVW(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVW(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVW(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVW(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVW(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVW(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVW(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVW(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVW(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVW(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVW(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVW(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHRDVW_ZValidFormsNoError(t *testing.T) {
	if _, err := VPSHRDVW_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVW_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVW_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVW_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVW_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDVW_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHRDWValidFormsNoError(t *testing.T) {
	if _, err := VPSHRDW(opimm8, opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDW(opimm8, opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDW(opimm8, opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDW(opimm8, opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDW(opimm8, opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDW(opimm8, opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDW(opimm8, opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDW(opimm8, opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDW(opimm8, opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDW(opimm8, opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDW(opimm8, opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDW(opimm8, opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHRDW_ZValidFormsNoError(t *testing.T) {
	if _, err := VPSHRDW_Z(opimm8, opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDW_Z(opimm8, opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDW_Z(opimm8, opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDW_Z(opimm8, opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDW_Z(opimm8, opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHRDW_Z(opimm8, opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHUFBValidFormsNoError(t *testing.T) {
	if _, err := VPSHUFB(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFB(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFB(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFB(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFB(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFB(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFB(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFB(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFB(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFB(opm512, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFB(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFB(opzmm, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHUFBITQMBValidFormsNoError(t *testing.T) {
	if _, err := VPSHUFBITQMB(opm128, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFBITQMB(opm128, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFBITQMB(opm256, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFBITQMB(opm256, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFBITQMB(opxmm, opxmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFBITQMB(opxmm, opxmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFBITQMB(opymm, opymm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFBITQMB(opymm, opymm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFBITQMB(opzmm, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFBITQMB(opzmm, opzmm, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFBITQMB(opm512, opzmm, opk, opk); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFBITQMB(opm512, opzmm, opk); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHUFB_ZValidFormsNoError(t *testing.T) {
	if _, err := VPSHUFB_Z(opm128, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFB_Z(opm256, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFB_Z(opxmm, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFB_Z(opymm, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFB_Z(opm512, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFB_Z(opzmm, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHUFDValidFormsNoError(t *testing.T) {
	if _, err := VPSHUFD(opimm8, opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFD(opimm8, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFD(opimm8, opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFD(opimm8, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFD(opimm8, opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFD(opimm8, opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFD(opimm8, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFD(opimm8, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFD(opimm8, opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFD(opimm8, opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFD(opimm8, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFD(opimm8, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHUFD_BCSTValidFormsNoError(t *testing.T) {
	if _, err := VPSHUFD_BCST(opimm8, opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFD_BCST(opimm8, opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFD_BCST(opimm8, opm32, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFD_BCST(opimm8, opm32, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFD_BCST(opimm8, opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFD_BCST(opimm8, opm32, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHUFD_BCST_ZValidFormsNoError(t *testing.T) {
	if _, err := VPSHUFD_BCST_Z(opimm8, opm32, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFD_BCST_Z(opimm8, opm32, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFD_BCST_Z(opimm8, opm32, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHUFD_ZValidFormsNoError(t *testing.T) {
	if _, err := VPSHUFD_Z(opimm8, opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFD_Z(opimm8, opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFD_Z(opimm8, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFD_Z(opimm8, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFD_Z(opimm8, opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFD_Z(opimm8, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHUFHWValidFormsNoError(t *testing.T) {
	if _, err := VPSHUFHW(opimm8, opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFHW(opimm8, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFHW(opimm8, opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFHW(opimm8, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFHW(opimm8, opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFHW(opimm8, opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFHW(opimm8, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFHW(opimm8, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFHW(opimm8, opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFHW(opimm8, opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFHW(opimm8, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFHW(opimm8, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHUFHW_ZValidFormsNoError(t *testing.T) {
	if _, err := VPSHUFHW_Z(opimm8, opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFHW_Z(opimm8, opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFHW_Z(opimm8, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFHW_Z(opimm8, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFHW_Z(opimm8, opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFHW_Z(opimm8, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHUFLWValidFormsNoError(t *testing.T) {
	if _, err := VPSHUFLW(opimm8, opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFLW(opimm8, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFLW(opimm8, opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFLW(opimm8, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFLW(opimm8, opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFLW(opimm8, opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFLW(opimm8, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFLW(opimm8, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFLW(opimm8, opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFLW(opimm8, opm512, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFLW(opimm8, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFLW(opimm8, opzmm, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSHUFLW_ZValidFormsNoError(t *testing.T) {
	if _, err := VPSHUFLW_Z(opimm8, opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFLW_Z(opimm8, opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFLW_Z(opimm8, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFLW_Z(opimm8, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFLW_Z(opimm8, opm512, opk, opzmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSHUFLW_Z(opimm8, opzmm, opk, opzmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSIGNBValidFormsNoError(t *testing.T) {
	if _, err := VPSIGNB(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSIGNB(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSIGNB(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSIGNB(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSIGNDValidFormsNoError(t *testing.T) {
	if _, err := VPSIGND(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSIGND(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSIGND(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSIGND(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSIGNWValidFormsNoError(t *testing.T) {
	if _, err := VPSIGNW(opm256, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSIGNW(opymm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSIGNW(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSIGNW(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
}

func TestVPSLLDValidFormsNoError(t *testing.T) {
	if _, err := VPSLLD(opimm8, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSLLD(opm128, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSLLD(opxmm, opymm, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSLLD(opimm8, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSLLD(opm128, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSLLD(opxmm, opxmm, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSLLD(opimm8, opm128, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSLLD(opimm8, opm128, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSLLD(opimm8, opm256, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSLLD(opimm8, opm256, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSLLD(opimm8, opxmm, opk, opxmm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSLLD(opimm8, opymm, opk, opymm); err != nil {
		t.Fatal(err)
	}
	if _, err := VPSLLD(opm128, opxmm, opk, opxmm); err != nil 