// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/google/uuid"
	"github.com/mrusme/journalist/ent/feed"
	"github.com/mrusme/journalist/ent/item"
	"github.com/mrusme/journalist/ent/read"
	"github.com/mrusme/journalist/ent/user"
)

// ItemCreate is the builder for creating a Item entity.
type ItemCreate struct {
	config
	mutation *ItemMutation
	hooks    []Hook
	conflict []sql.ConflictOption
}

// SetItemGUID sets the "item_guid" field.
func (ic *ItemCreate) SetItemGUID(s string) *ItemCreate {
	ic.mutation.SetItemGUID(s)
	return ic
}

// SetItemTitle sets the "item_title" field.
func (ic *ItemCreate) SetItemTitle(s string) *ItemCreate {
	ic.mutation.SetItemTitle(s)
	return ic
}

// SetItemDescription sets the "item_description" field.
func (ic *ItemCreate) SetItemDescription(s string) *ItemCreate {
	ic.mutation.SetItemDescription(s)
	return ic
}

// SetItemContent sets the "item_content" field.
func (ic *ItemCreate) SetItemContent(s string) *ItemCreate {
	ic.mutation.SetItemContent(s)
	return ic
}

// SetItemLink sets the "item_link" field.
func (ic *ItemCreate) SetItemLink(s string) *ItemCreate {
	ic.mutation.SetItemLink(s)
	return ic
}

// SetItemUpdated sets the "item_updated" field.
func (ic *ItemCreate) SetItemUpdated(t time.Time) *ItemCreate {
	ic.mutation.SetItemUpdated(t)
	return ic
}

// SetItemPublished sets the "item_published" field.
func (ic *ItemCreate) SetItemPublished(t time.Time) *ItemCreate {
	ic.mutation.SetItemPublished(t)
	return ic
}

// SetItemAuthorName sets the "item_author_name" field.
func (ic *ItemCreate) SetItemAuthorName(s string) *ItemCreate {
	ic.mutation.SetItemAuthorName(s)
	return ic
}

// SetNillableItemAuthorName sets the "item_author_name" field if the given value is not nil.
func (ic *ItemCreate) SetNillableItemAuthorName(s *string) *ItemCreate {
	if s != nil {
		ic.SetItemAuthorName(*s)
	}
	return ic
}

// SetItemAuthorEmail sets the "item_author_email" field.
func (ic *ItemCreate) SetItemAuthorEmail(s string) *ItemCreate {
	ic.mutation.SetItemAuthorEmail(s)
	return ic
}

// SetNillableItemAuthorEmail sets the "item_author_email" field if the given value is not nil.
func (ic *ItemCreate) SetNillableItemAuthorEmail(s *string) *ItemCreate {
	if s != nil {
		ic.SetItemAuthorEmail(*s)
	}
	return ic
}

// SetItemImageTitle sets the "item_image_title" field.
func (ic *ItemCreate) SetItemImageTitle(s string) *ItemCreate {
	ic.mutation.SetItemImageTitle(s)
	return ic
}

// SetNillableItemImageTitle sets the "item_image_title" field if the given value is not nil.
func (ic *ItemCreate) SetNillableItemImageTitle(s *string) *ItemCreate {
	if s != nil {
		ic.SetItemImageTitle(*s)
	}
	return ic
}

// SetItemImageURL sets the "item_image_url" field.
func (ic *ItemCreate) SetItemImageURL(s string) *ItemCreate {
	ic.mutation.SetItemImageURL(s)
	return ic
}

// SetNillableItemImageURL sets the "item_image_url" field if the given value is not nil.
func (ic *ItemCreate) SetNillableItemImageURL(s *string) *ItemCreate {
	if s != nil {
		ic.SetItemImageURL(*s)
	}
	return ic
}

// SetItemCategories sets the "item_categories" field.
func (ic *ItemCreate) SetItemCategories(s string) *ItemCreate {
	ic.mutation.SetItemCategories(s)
	return ic
}

// SetItemEnclosures sets the "item_enclosures" field.
func (ic *ItemCreate) SetItemEnclosures(s string) *ItemCreate {
	ic.mutation.SetItemEnclosures(s)
	return ic
}

// SetCrawlerTitle sets the "crawler_title" field.
func (ic *ItemCreate) SetCrawlerTitle(s string) *ItemCreate {
	ic.mutation.SetCrawlerTitle(s)
	return ic
}

// SetNillableCrawlerTitle sets the "crawler_title" field if the given value is not nil.
func (ic *ItemCreate) SetNillableCrawlerTitle(s *string) *ItemCreate {
	if s != nil {
		ic.SetCrawlerTitle(*s)
	}
	return ic
}

// SetCrawlerAuthor sets the "crawler_author" field.
func (ic *ItemCreate) SetCrawlerAuthor(s string) *ItemCreate {
	ic.mutation.SetCrawlerAuthor(s)
	return ic
}

// SetNillableCrawlerAuthor sets the "crawler_author" field if the given value is not nil.
func (ic *ItemCreate) SetNillableCrawlerAuthor(s *string) *ItemCreate {
	if s != nil {
		ic.SetCrawlerAuthor(*s)
	}
	return ic
}

// SetCrawlerExcerpt sets the "crawler_excerpt" field.
func (ic *ItemCreate) SetCrawlerExcerpt(s string) *ItemCreate {
	ic.mutation.SetCrawlerExcerpt(s)
	return ic
}

// SetNillableCrawlerExcerpt sets the "crawler_excerpt" field if the given value is not nil.
func (ic *ItemCreate) SetNillableCrawlerExcerpt(s *string) *ItemCreate {
	if s != nil {
		ic.SetCrawlerExcerpt(*s)
	}
	return ic
}

// SetCrawlerSiteName sets the "crawler_site_name" field.
func (ic *ItemCreate) SetCrawlerSiteName(s string) *ItemCreate {
	ic.mutation.SetCrawlerSiteName(s)
	return ic
}

// SetNillableCrawlerSiteName sets the "crawler_site_name" field if the given value is not nil.
func (ic *ItemCreate) SetNillableCrawlerSiteName(s *string) *ItemCreate {
	if s != nil {
		ic.SetCrawlerSiteName(*s)
	}
	return ic
}

// SetCrawlerImage sets the "crawler_image" field.
func (ic *ItemCreate) SetCrawlerImage(s string) *ItemCreate {
	ic.mutation.SetCrawlerImage(s)
	return ic
}

// SetNillableCrawlerImage sets the "crawler_image" field if the given value is not nil.
func (ic *ItemCreate) SetNillableCrawlerImage(s *string) *ItemCreate {
	if s != nil {
		ic.SetCrawlerImage(*s)
	}
	return ic
}

// SetCrawlerContentHTML sets the "crawler_content_html" field.
func (ic *ItemCreate) SetCrawlerContentHTML(s string) *ItemCreate {
	ic.mutation.SetCrawlerContentHTML(s)
	return ic
}

// SetNillableCrawlerContentHTML sets the "crawler_content_html" field if the given value is not nil.
func (ic *ItemCreate) SetNillableCrawlerContentHTML(s *string) *ItemCreate {
	if s != nil {
		ic.SetCrawlerContentHTML(*s)
	}
	return ic
}

// SetCrawlerContentText sets the "crawler_content_text" field.
func (ic *ItemCreate) SetCrawlerContentText(s string) *ItemCreate {
	ic.mutation.SetCrawlerContentText(s)
	return ic
}

// SetNillableCrawlerContentText sets the "crawler_content_text" field if the given value is not nil.
func (ic *ItemCreate) SetNillableCrawlerContentText(s *string) *ItemCreate {
	if s != nil {
		ic.SetCrawlerContentText(*s)
	}
	return ic
}

// SetCreatedAt sets the "created_at" field.
func (ic *ItemCreate) SetCreatedAt(t time.Time) *ItemCreate {
	ic.mutation.SetCreatedAt(t)
	return ic
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (ic *ItemCreate) SetNillableCreatedAt(t *time.Time) *ItemCreate {
	if t != nil {
		ic.SetCreatedAt(*t)
	}
	return ic
}

// SetUpdatedAt sets the "updated_at" field.
func (ic *ItemCreate) SetUpdatedAt(t time.Time) *ItemCreate {
	ic.mutation.SetUpdatedAt(t)
	return ic
}

// SetNillableUpdatedAt sets the "updated_at" field if the given value is not nil.
func (ic *ItemCreate) SetNillableUpdatedAt(t *time.Time) *ItemCreate {
	if t != nil {
		ic.SetUpdatedAt(*t)
	}
	return ic
}

// SetID sets the "id" field.
func (ic *ItemCreate) SetID(u uuid.UUID) *ItemCreate {
	ic.mutation.SetID(u)
	return ic
}

// SetNillableID sets the "id" field if the given value is not nil.
func (ic *ItemCreate) SetNillableID(u *uuid.UUID) *ItemCreate {
	if u != nil {
		ic.SetID(*u)
	}
	return ic
}

// SetFeedID sets the "feed" edge to the Feed entity by ID.
func (ic *ItemCreate) SetFeedID(id uuid.UUID) *ItemCreate {
	ic.mutation.SetFeedID(id)
	return ic
}

// SetNillableFeedID sets the "feed" edge to the Feed entity by ID if the given value is not nil.
func (ic *ItemCreate) SetNillableFeedID(id *uuid.UUID) *ItemCreate {
	if id != nil {
		ic = ic.SetFeedID(*id)
	}
	return ic
}

// SetFeed sets the "feed" edge to the Feed entity.
func (ic *ItemCreate) SetFeed(f *Feed) *ItemCreate {
	return ic.SetFeedID(f.ID)
}

// AddReadByUserIDs adds the "read_by_users" edge to the User entity by IDs.
func (ic *ItemCreate) AddReadByUserIDs(ids ...uuid.UUID) *ItemCreate {
	ic.mutation.AddReadByUserIDs(ids...)
	return ic
}

// AddReadByUsers adds the "read_by_users" edges to the User entity.
func (ic *ItemCreate) AddReadByUsers(u ...*User) *ItemCreate {
	ids := make([]uuid.UUID, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return ic.AddReadByUserIDs(ids...)
}

// AddReadIDs adds the "reads" edge to the Read entity by IDs.
func (ic *ItemCreate) AddReadIDs(ids ...uuid.UUID) *ItemCreate {
	ic.mutation.AddReadIDs(ids...)
	return ic
}

// AddReads adds the "reads" edges to the Read entity.
func (ic *ItemCreate) AddReads(r ...*Read) *ItemCreate {
	ids := make([]uuid.UUID, len(r))
	for i := range r {
		ids[i] = r[i].ID
	}
	return ic.AddReadIDs(ids...)
}

// Mutation returns the ItemMutation object of the builder.
func (ic *ItemCreate) Mutation() *ItemMutation {
	return ic.mutation
}

// Save creates the Item in the database.
func (ic *ItemCreate) Save(ctx context.Context) (*Item, error) {
	ic.defaults()
	return withHooks(ctx, ic.sqlSave, ic.mutation, ic.hooks)
}

// SaveX calls Save and panics if Save returns an error.
func (ic *ItemCreate) SaveX(ctx context.Context) *Item {
	v, err := ic.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (ic *ItemCreate) Exec(ctx context.Context) error {
	_, err := ic.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (ic *ItemCreate) ExecX(ctx context.Context) {
	if err := ic.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (ic *ItemCreate) defaults() {
	if _, ok := ic.mutation.CreatedAt(); !ok {
		v := item.DefaultCreatedAt()
		ic.mutation.SetCreatedAt(v)
	}
	if _, ok := ic.mutation.UpdatedAt(); !ok {
		v := item.DefaultUpdatedAt()
		ic.mutation.SetUpdatedAt(v)
	}
	if _, ok := ic.mutation.ID(); !ok {
		v := item.DefaultID()
		ic.mutation.SetID(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (ic *ItemCreate) check() error {
	if _, ok := ic.mutation.ItemGUID(); !ok {
		return &ValidationError{Name: "item_guid", err: errors.New(`ent: missing required field "Item.item_guid"`)}
	}
	if _, ok := ic.mutation.ItemTitle(); !ok {
		return &ValidationError{Name: "item_title", err: errors.New(`ent: missing required field "Item.item_title"`)}
	}
	if _, ok := ic.mutation.ItemDescription(); !ok {
		return &ValidationError{Name: "item_description", err: errors.New(`ent: missing required field "Item.item_description"`)}
	}
	if _, ok := ic.mutation.ItemContent(); !ok {
		return &ValidationError{Name: "item_content", err: errors.New(`ent: missing required field "Item.item_content"`)}
	}
	if _, ok := ic.mutation.ItemLink(); !ok {
		return &ValidationError{Name: "item_link", err: errors.New(`ent: missing required field "Item.item_link"`)}
	}
	if v, ok := ic.mutation.ItemLink(); ok {
		if err := item.ItemLinkValidator(v); err != nil {
			return &ValidationError{Name: "item_link", err: fmt.Errorf(`ent: validator failed for field "Item.item_link": %w`, err)}
		}
	}
	if _, ok := ic.mutation.ItemUpdated(); !ok {
		return &ValidationError{Name: "item_updated", err: errors.New(`ent: missing required field "Item.item_updated"`)}
	}
	if _, ok := ic.mutation.ItemPublished(); !ok {
		return &ValidationError{Name: "item_published", err: errors.New(`ent: missing required field "Item.item_published"`)}
	}
	if _, ok := ic.mutation.ItemCategories(); !ok {
		return &ValidationError{Name: "item_categories", err: errors.New(`ent: missing required field "Item.item_categories"`)}
	}
	if _, ok := ic.mutation.ItemEnclosures(); !ok {
		return &ValidationError{Name: "item_enclosures", err: errors.New(`ent: missing required field "Item.item_enclosures"`)}
	}
	if _, ok := ic.mutation.CreatedAt(); !ok {
		return &ValidationError{Name: "created_at", err: errors.New(`ent: missing required field "Item.created_at"`)}
	}
	if _, ok := ic.mutation.UpdatedAt(); !ok {
		return &ValidationError{Name: "updated_at", err: errors.New(`ent: missing required field "Item.updated_at"`)}
	}
	return nil
}

func (ic *ItemCreate) sqlSave(ctx context.Context) (*Item, error) {
	if err := ic.check(); err != nil {
		return nil, err
	}
	_node, _spec := ic.createSpec()
	if err := sqlgraph.CreateNode(ctx, ic.driver, _spec); err != nil {
		if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	if _spec.ID.Value != nil {
		if id, ok := _spec.ID.Value.(*uuid.UUID); ok {
			_node.ID = *id
		} else if err := _node.ID.Scan(_spec.ID.Value); err != nil {
			return nil, err
		}
	}
	ic.mutation.id = &_node.ID
	ic.mutation.done = true
	return _node, nil
}

func (ic *ItemCreate) createSpec() (*Item, *sqlgraph.CreateSpec) {
	var (
		_node = &Item{config: ic.config}
		_spec = sqlgraph.NewCreateSpec(item.Table, sqlgraph.NewFieldSpec(item.FieldID, field.TypeUUID))
	)
	_spec.OnConflict = ic.conflict
	if id, ok := ic.mutation.ID(); ok {
		_node.ID = id
		_spec.ID.Value = &id
	}
	if value, ok := ic.mutation.ItemGUID(); ok {
		_spec.SetField(item.FieldItemGUID, field.TypeString, value)
		_node.ItemGUID = value
	}
	if value, ok := ic.mutation.ItemTitle(); ok {
		_spec.SetField(item.FieldItemTitle, field.TypeString, value)
		_node.ItemTitle = value
	}
	if value, ok := ic.mutation.ItemDescription(); ok {
		_spec.SetField(item.FieldItemDescription, field.TypeString, value)
		_node.ItemDescription = value
	}
	if value, ok := ic.mutation.ItemContent(); ok {
		_spec.SetField(item.FieldItemContent, field.TypeString, value)
		_node.ItemContent = value
	}
	if value, ok := ic.mutation.ItemLink(); ok {
		_spec.SetField(item.FieldItemLink, field.TypeString, value)
		_node.ItemLink = value
	}
	if value, ok := ic.mutation.ItemUpdated(); ok {
		_spec.SetField(item.FieldItemUpdated, field.TypeTime, value)
		_node.ItemUpdated = value
	}
	if value, ok := ic.mutation.ItemPublished(); ok {
		_spec.SetField(item.FieldItemPublished, field.TypeTime, value)
		_node.ItemPublished = value
	}
	if value, ok := ic.mutation.ItemAuthorName(); ok {
		_spec.SetField(item.FieldItemAuthorName, field.TypeString, value)
		_node.ItemAuthorName = value
	}
	if value, ok := ic.mutation.ItemAuthorEmail(); ok {
		_spec.SetField(item.FieldItemAuthorEmail, field.TypeString, value)
		_node.ItemAuthorEmail = value
	}
	if value, ok := ic.mutation.ItemImageTitle(); ok {
		_spec.SetField(item.FieldItemImageTitle, field.TypeString, value)
		_node.ItemImageTitle = value
	}
	if value, ok := ic.mutation.ItemImageURL(); ok {
		_spec.SetField(item.FieldItemImageURL, field.TypeString, value)
		_node.ItemImageURL = value
	}
	if value, ok := ic.mutation.ItemCategories(); ok {
		_spec.SetField(item.FieldItemCategories, field.TypeString, value)
		_node.ItemCategories = value
	}
	if value, ok := ic.mutation.ItemEnclosures(); ok {
		_spec.SetField(item.FieldItemEnclosures, field.TypeString, value)
		_node.ItemEnclosures = value
	}
	if value, ok := ic.mutation.CrawlerTitle(); ok {
		_spec.SetField(item.FieldCrawlerTitle, field.TypeString, value)
		_node.CrawlerTitle = value
	}
	if value, ok := ic.mutation.CrawlerAuthor(); ok {
		_spec.SetField(item.FieldCrawlerAuthor, field.TypeString, value)
		_node.CrawlerAuthor = value
	}
	if value, ok := ic.mutation.CrawlerExcerpt(); ok {
		_spec.SetField(item.FieldCrawlerExcerpt, field.TypeString, value)
		_node.CrawlerExcerpt = value
	}
	if value, ok := ic.mutation.CrawlerSiteName(); ok {
		_spec.SetField(item.FieldCrawlerSiteName, field.TypeString, value)
		_node.CrawlerSiteName = value
	}
	if value, ok := ic.mutation.CrawlerImage(); ok {
		_spec.SetField(item.FieldCrawlerImage, field.TypeString, value)
		_node.CrawlerImage = value
	}
	if value, ok := ic.mutation.CrawlerContentHTML(); ok {
		_spec.SetField(item.FieldCrawlerContentHTML, field.TypeString, value)
		_node.CrawlerContentHTML = value
	}
	if value, ok := ic.mutation.CrawlerContentText(); ok {
		_spec.SetField(item.FieldCrawlerContentText, field.TypeString, value)
		_node.CrawlerContentText = value
	}
	if value, ok := ic.mutation.CreatedAt(); ok {
		_spec.SetField(item.FieldCreatedAt, field.TypeTime, value)
		_node.CreatedAt = value
	}
	if value, ok := ic.mutation.UpdatedAt(); ok {
		_spec.SetField(item.FieldUpdatedAt, field.TypeTime, value)
		_node.UpdatedAt = value
	}
	if nodes := ic.mutation.FeedIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   item.FeedTable,
			Columns: []string{item.FeedColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(feed.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_node.feed_items = &nodes[0]
		_spec.Edges = append(_spec.Edges, edge)
	}
	if nodes := ic.mutation.ReadByUsersIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: true,
			Table:   item.ReadByUsersTable,
			Columns: item.ReadByUsersPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		createE := &ReadCreate{config: ic.config, mutation: newReadMutation(ic.config, OpCreate)}
		createE.defaults()
		_, specE := createE.createSpec()
		edge.Target.Fields = specE.Fields
		if specE.ID.Value != nil {
			edge.Target.Fields = append(edge.Target.Fields, specE.ID)
		}
		_spec.Edges = append(_spec.Edges, edge)
	}
	if nodes := ic.mutation.ReadsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   item.ReadsTable,
			Columns: []string{item.ReadsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(read.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges = append(_spec.Edges, edge)
	}
	return _node, _spec
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.Item.Create().
//		SetItemGUID(v).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.ItemUpsert) {
//			SetItemGUID(v+v).
//		}).
//		Exec(ctx)
func (ic *ItemCreate) OnConflict(opts ...sql.ConflictOption) *ItemUpsertOne {
	ic.conflict = opts
	return &ItemUpsertOne{
		create: ic,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.Item.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (ic *ItemCreate) OnConflictColumns(columns ...string) *ItemUpsertOne {
	ic.conflict = append(ic.conflict, sql.ConflictColumns(columns...))
	return &ItemUpsertOne{
		create: ic,
	}
}

type (
	// ItemUpsertOne is the builder for "upsert"-ing
	//  one Item node.
	ItemUpsertOne struct {
		create *ItemCreate
	}

	// ItemUpsert is the "OnConflict" setter.
	ItemUpsert struct {
		*sql.UpdateSet
	}
)

// SetItemGUID sets the "item_guid" field.
func (u *ItemUpsert) SetItemGUID(v string) *ItemUpsert {
	u.Set(item.FieldItemGUID, v)
	return u
}

// UpdateItemGUID sets the "item_guid" field to the value that was provided on create.
func (u *ItemUpsert) UpdateItemGUID() *ItemUpsert {
	u.SetExcluded(item.FieldItemGUID)
	return u
}

// SetItemTitle sets the "item_title" field.
func (u *ItemUpsert) SetItemTitle(v string) *ItemUpsert {
	u.Set(item.FieldItemTitle, v)
	return u
}

// UpdateItemTitle sets the "item_title" field to the value that was provided on create.
func (u *ItemUpsert) UpdateItemTitle() *ItemUpsert {
	u.SetExcluded(item.FieldItemTitle)
	return u
}

// SetItemDescription sets the "item_description" field.
func (u *ItemUpsert) SetItemDescription(v string) *ItemUpsert {
	u.Set(item.FieldItemDescription, v)
	return u
}

// UpdateItemDescription sets the "item_description" field to the value that was provided on create.
func (u *ItemUpsert) UpdateItemDescription() *ItemUpsert {
	u.SetExcluded(item.FieldItemDescription)
	return u
}

// SetItemContent sets the "item_content" field.
func (u *ItemUpsert) SetItemContent(v string) *ItemUpsert {
	u.Set(item.FieldItemContent, v)
	return u
}

// UpdateItemContent sets the "item_content" field to the value that was provided on create.
func (u *ItemUpsert) UpdateItemContent() *ItemUpsert {
	u.SetExcluded(item.FieldItemContent)
	return u
}

// SetItemLink sets the "item_link" field.
func (u *ItemUpsert) SetItemLink(v string) *ItemUpsert {
	u.Set(item.FieldItemLink, v)
	return u
}

// UpdateItemLink sets the "item_link" field to the value that was provided on create.
func (u *ItemUpsert) UpdateItemLink() *ItemUpsert {
	u.SetExcluded(item.FieldItemLink)
	return u
}

// SetItemUpdated sets the "item_updated" field.
func (u *ItemUpsert) SetItemUpdated(v time.Time) *ItemUpsert {
	u.Set(item.FieldItemUpdated, v)
	return u
}

// UpdateItemUpdated sets the "item_updated" field to the value that was provided on create.
func (u *ItemUpsert) UpdateItemUpdated() *ItemUpsert {
	u.SetExcluded(item.FieldItemUpdated)
	return u
}

// SetItemPublished sets the "item_published" field.
func (u *ItemUpsert) SetItemPublished(v time.Time) *ItemUpsert {
	u.Set(item.FieldItemPublished, v)
	return u
}

// UpdateItemPublished sets the "item_published" field to the value that was provided on create.
func (u *ItemUpsert) UpdateItemPublished() *ItemUpsert {
	u.SetExcluded(item.FieldItemPublished)
	return u
}

// SetItemAuthorName sets the "item_author_name" field.
func (u *ItemUpsert) SetItemAuthorName(v string) *ItemUpsert {
	u.Set(item.FieldItemAuthorName, v)
	return u
}

// UpdateItemAuthorName sets the "item_author_name" field to the value that was provided on create.
func (u *ItemUpsert) UpdateItemAuthorName() *ItemUpsert {
	u.SetExcluded(item.FieldItemAuthorName)
	return u
}

// ClearItemAuthorName clears the value of the "item_author_name" field.
func (u *ItemUpsert) ClearItemAuthorName() *ItemUpsert {
	u.SetNull(item.FieldItemAuthorName)
	return u
}

// SetItemAuthorEmail sets the "item_author_email" field.
func (u *ItemUpsert) SetItemAuthorEmail(v string) *ItemUpsert {
	u.Set(item.FieldItemAuthorEmail, v)
	return u
}

// UpdateItemAuthorEmail sets the "item_author_email" field to the value that was provided on create.
func (u *ItemUpsert) UpdateItemAuthorEmail() *ItemUpsert {
	u.SetExcluded(item.FieldItemAuthorEmail)
	return u
}

// ClearItemAuthorEmail clears the value of the "item_author_email" field.
func (u *ItemUpsert) ClearItemAuthorEmail() *ItemUpsert {
	u.SetNull(item.FieldItemAuthorEmail)
	return u
}

// SetItemImageTitle sets the "item_image_title" field.
func (u *ItemUpsert) SetItemImageTitle(v string) *ItemUpsert {
	u.Set(item.FieldItemImageTitle, v)
	return u
}

// UpdateItemImageTitle sets the "item_image_title" field to the value that was provided on create.
func (u *ItemUpsert) UpdateItemImageTitle() *ItemUpsert {
	u.SetExcluded(item.FieldItemImageTitle)
	return u
}

// ClearItemImageTitle clears the value of the "item_image_title" field.
func (u *ItemUpsert) ClearItemImageTitle() *ItemUpsert {
	u.SetNull(item.FieldItemImageTitle)
	return u
}

// SetItemImageURL sets the "item_image_url" field.
func (u *ItemUpsert) SetItemImageURL(v string) *ItemUpsert {
	u.Set(item.FieldItemImageURL, v)
	return u
}

// UpdateItemImageURL sets the "item_image_url" field to the value that was provided on create.
func (u *ItemUpsert) UpdateItemImageURL() *ItemUpsert {
	u.SetExcluded(item.FieldItemImageURL)
	return u
}

// ClearItemImageURL clears the value of the "item_image_url" field.
func (u *ItemUpsert) ClearItemImageURL() *ItemUpsert {
	u.SetNull(item.FieldItemImageURL)
	return u
}

// SetItemCategories sets the "item_categories" field.
func (u *ItemUpsert) SetItemCategories(v string) *ItemUpsert {
	u.Set(item.FieldItemCategories, v)
	return u
}

// UpdateItemCategories sets the "item_categories" field to the value that was provided on create.
func (u *ItemUpsert) UpdateItemCategories() *ItemUpsert {
	u.SetExcluded(item.FieldItemCategories)
	return u
}

// SetItemEnclosures sets the "item_enclosures" field.
func (u *ItemUpsert) SetItemEnclosures(v string) *ItemUpsert {
	u.Set(item.FieldItemEnclosures, v)
	return u
}

// UpdateItemEnclosures sets the "item_enclosures" field to the value that was provided on create.
func (u *ItemUpsert) UpdateItemEnclosures() *ItemUpsert {
	u.SetExcluded(item.FieldItemEnclosures)
	return u
}

// SetCrawlerTitle sets the "crawler_title" field.
func (u *ItemUpsert) SetCrawlerTitle(v string) *ItemUpsert {
	u.Set(item.FieldCrawlerTitle, v)
	return u
}

// UpdateCrawlerTitle sets the "crawler_title" field to the value that was provided on create.
func (u *ItemUpsert) UpdateCrawlerTitle() *ItemUpsert {
	u.SetExcluded(item.FieldCrawlerTitle)
	return u
}

// ClearCrawlerTitle clears the value of the "crawler_title" field.
func (u *ItemUpsert) ClearCrawlerTitle() *ItemUpsert {
	u.SetNull(item.FieldCrawlerTitle)
	return u
}

// SetCrawlerAuthor sets the "crawler_author" field.
func (u *ItemUpsert) SetCrawlerAuthor(v string) *ItemUpsert {
	u.Set(item.FieldCrawlerAuthor, v)
	return u
}

// UpdateCrawlerAuthor sets the "crawler_author" field to the value that was provided on create.
func (u *ItemUpsert) UpdateCrawlerAuthor() *ItemUpsert {
	u.SetExcluded(item.FieldCrawlerAuthor)
	return u
}

// ClearCrawlerAuthor clears the value of the "crawler_author" field.
func (u *ItemUpsert) ClearCrawlerAuthor() *ItemUpsert {
	u.SetNull(item.FieldCrawlerAuthor)
	return u
}

// SetCrawlerExcerpt sets the "crawler_excerpt" field.
func (u *ItemUpsert) SetCrawlerExcerpt(v string) *ItemUpsert {
	u.Set(item.FieldCrawlerExcerpt, v)
	return u
}

// UpdateCrawlerExcerpt sets the "crawler_excerpt" field to the value that was provided on create.
func (u *ItemUpsert) UpdateCrawlerExcerpt() *ItemUpsert {
	u.SetExcluded(item.FieldCrawlerExcerpt)
	return u
}

// ClearCrawlerExcerpt clears the value of the "crawler_excerpt" field.
func (u *ItemUpsert) ClearCrawlerExcerpt() *ItemUpsert {
	u.SetNull(item.FieldCrawlerExcerpt)
	return u
}

// SetCrawlerSiteName sets the "crawler_site_name" field.
func (u *ItemUpsert) SetCrawlerSiteName(v string) *ItemUpsert {
	u.Set(item.FieldCrawlerSiteName, v)
	return u
}

// UpdateCrawlerSiteName sets the "crawler_site_name" field to the value that was provided on create.
func (u *ItemUpsert) UpdateCrawlerSiteName() *ItemUpsert {
	u.SetExcluded(item.FieldCrawlerSiteName)
	return u
}

// ClearCrawlerSiteName clears the value of the "crawler_site_name" field.
func (u *ItemUpsert) ClearCrawlerSiteName() *ItemUpsert {
	u.SetNull(item.FieldCrawlerSiteName)
	return u
}

// SetCrawlerImage sets the "crawler_image" field.
func (u *ItemUpsert) SetCrawlerImage(v string) *ItemUpsert {
	u.Set(item.FieldCrawlerImage, v)
	return u
}

// UpdateCrawlerImage sets the "crawler_image" field to the value that was provided on create.
func (u *ItemUpsert) UpdateCrawlerImage() *ItemUpsert {
	u.SetExcluded(item.FieldCrawlerImage)
	return u
}

// ClearCrawlerImage clears the value of the "crawler_image" field.
func (u *ItemUpsert) ClearCrawlerImage() *ItemUpsert {
	u.SetNull(item.FieldCrawlerImage)
	return u
}

// SetCrawlerContentHTML sets the "crawler_content_html" field.
func (u *ItemUpsert) SetCrawlerContentHTML(v string) *ItemUpsert {
	u.Set(item.FieldCrawlerContentHTML, v)
	return u
}

// UpdateCrawlerContentHTML sets the "crawler_content_html" field to the value that was provided on create.
func (u *ItemUpsert) UpdateCrawlerContentHTML() *ItemUpsert {
	u.SetExcluded(item.FieldCrawlerContentHTML)
	return u
}

// ClearCrawlerContentHTML clears the value of the "crawler_content_html" field.
func (u *ItemUpsert) ClearCrawlerContentHTML() *ItemUpsert {
	u.SetNull(item.FieldCrawlerContentHTML)
	return u
}

// SetCrawlerContentText sets the "crawler_content_text" field.
func (u *ItemUpsert) SetCrawlerContentText(v string) *ItemUpsert {
	u.Set(item.FieldCrawlerContentText, v)
	return u
}

// UpdateCrawlerContentText sets the "crawler_content_text" field to the value that was provided on create.
func (u *ItemUpsert) UpdateCrawlerContentText() *ItemUpsert {
	u.SetExcluded(item.FieldCrawlerContentText)
	return u
}

// ClearCrawlerContentText clears the value of the "crawler_content_text" field.
func (u *ItemUpsert) ClearCrawlerContentText() *ItemUpsert {
	u.SetNull(item.FieldCrawlerContentText)
	return u
}

// SetCreatedAt sets the "created_at" field.
func (u *ItemUpsert) SetCreatedAt(v time.Time) *ItemUpsert {
	u.Set(item.FieldCreatedAt, v)
	return u
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *ItemUpsert) UpdateCreatedAt() *ItemUpsert {
	u.SetExcluded(item.FieldCreatedAt)
	return u
}

// SetUpdatedAt sets the "updated_at" field.
func (u *ItemUpsert) SetUpdatedAt(v time.Time) *ItemUpsert {
	u.Set(item.FieldUpdatedAt, v)
	return u
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *ItemUpsert) UpdateUpdatedAt() *ItemUpsert {
	u.SetExcluded(item.FieldUpdatedAt)
	return u
}

// UpdateNewValues updates the mutable fields using the new values that were set on create except the ID field.
// Using this option is equivalent to using:
//
//	client.Item.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(item.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *ItemUpsertOne) UpdateNewValues() *ItemUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		if _, exists := u.create.mutation.ID(); exists {
			s.SetIgnore(item.FieldID)
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.Item.Create().
//	    OnConflict(sql.ResolveWithIgnore()).
//	    Exec(ctx)
func (u *ItemUpsertOne) Ignore() *ItemUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *ItemUpsertOne) DoNothing() *ItemUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the ItemCreate.OnConflict
// documentation for more info.
func (u *ItemUpsertOne) Update(set func(*ItemUpsert)) *ItemUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&ItemUpsert{UpdateSet: update})
	}))
	return u
}

// SetItemGUID sets the "item_guid" field.
func (u *ItemUpsertOne) SetItemGUID(v string) *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.SetItemGUID(v)
	})
}

// UpdateItemGUID sets the "item_guid" field to the value that was provided on create.
func (u *ItemUpsertOne) UpdateItemGUID() *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.UpdateItemGUID()
	})
}

// SetItemTitle sets the "item_title" field.
func (u *ItemUpsertOne) SetItemTitle(v string) *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.SetItemTitle(v)
	})
}

// UpdateItemTitle sets the "item_title" field to the value that was provided on create.
func (u *ItemUpsertOne) UpdateItemTitle() *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.UpdateItemTitle()
	})
}

// SetItemDescription sets the "item_description" field.
func (u *ItemUpsertOne) SetItemDescription(v string) *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.SetItemDescription(v)
	})
}

// UpdateItemDescription sets the "item_description" field to the value that was provided on create.
func (u *ItemUpsertOne) UpdateItemDescription() *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.UpdateItemDescription()
	})
}

// SetItemContent sets the "item_content" field.
func (u *ItemUpsertOne) SetItemContent(v string) *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.SetItemContent(v)
	})
}

// UpdateItemContent sets the "item_content" field to the value that was provided on create.
func (u *ItemUpsertOne) UpdateItemContent() *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.UpdateItemContent()
	})
}

// SetItemLink sets the "item_link" field.
func (u *ItemUpsertOne) SetItemLink(v string) *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.SetItemLink(v)
	})
}

// UpdateItemLink sets the "item_link" field to the value that was provided on create.
func (u *ItemUpsertOne) UpdateItemLink() *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.UpdateItemLink()
	})
}

// SetItemUpdated sets the "item_updated" field.
func (u *ItemUpsertOne) SetItemUpdated(v time.Time) *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.SetItemUpdated(v)
	})
}

// UpdateItemUpdated sets the "item_updated" field to the value that was provided on create.
func (u *ItemUpsertOne) UpdateItemUpdated() *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.UpdateItemUpdated()
	})
}

// SetItemPublished sets the "item_published" field.
func (u *ItemUpsertOne) SetItemPublished(v time.Time) *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.SetItemPublished(v)
	})
}

// UpdateItemPublished sets the "item_published" field to the value that was provided on create.
func (u *ItemUpsertOne) UpdateItemPublished() *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.UpdateItemPublished()
	})
}

// SetItemAuthorName sets the "item_author_name" field.
func (u *ItemUpsertOne) SetItemAuthorName(v string) *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.SetItemAuthorName(v)
	})
}

// UpdateItemAuthorName sets the "item_author_name" field to the value that was provided on create.
func (u *ItemUpsertOne) UpdateItemAuthorName() *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.UpdateItemAuthorName()
	})
}

// ClearItemAuthorName clears the value of the "item_author_name" field.
func (u *ItemUpsertOne) ClearItemAuthorName() *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.ClearItemAuthorName()
	})
}

// SetItemAuthorEmail sets the "item_author_email" field.
func (u *ItemUpsertOne) SetItemAuthorEmail(v string) *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.SetItemAuthorEmail(v)
	})
}

// UpdateItemAuthorEmail sets the "item_author_email" field to the value that was provided on create.
func (u *ItemUpsertOne) UpdateItemAuthorEmail() *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.UpdateItemAuthorEmail()
	})
}

// ClearItemAuthorEmail clears the value of the "item_author_email" field.
func (u *ItemUpsertOne) ClearItemAuthorEmail() *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.ClearItemAuthorEmail()
	})
}

// SetItemImageTitle sets the "item_image_title" field.
func (u *ItemUpsertOne) SetItemImageTitle(v string) *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.SetItemImageTitle(v)
	})
}

// UpdateItemImageTitle sets the "item_image_title" field to the value that was provided on create.
func (u *ItemUpsertOne) UpdateItemImageTitle() *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.UpdateItemImageTitle()
	})
}

// ClearItemImageTitle clears the value of the "item_image_title" field.
func (u *ItemUpsertOne) ClearItemImageTitle() *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.ClearItemImageTitle()
	})
}

// SetItemImageURL sets the "item_image_url" field.
func (u *ItemUpsertOne) SetItemImageURL(v string) *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.SetItemImageURL(v)
	})
}

// UpdateItemImageURL sets the "item_image_url" field to the value that was provided on create.
func (u *ItemUpsertOne) UpdateItemImageURL() *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.UpdateItemImageURL()
	})
}

// ClearItemImageURL clears the value of the "item_image_url" field.
func (u *ItemUpsertOne) ClearItemImageURL() *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.ClearItemImageURL()
	})
}

// SetItemCategories sets the "item_categories" field.
func (u *ItemUpsertOne) SetItemCategories(v string) *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.SetItemCategories(v)
	})
}

// UpdateItemCategories sets the "item_categories" field to the value that was provided on create.
func (u *ItemUpsertOne) UpdateItemCategories() *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.UpdateItemCategories()
	})
}

// SetItemEnclosures sets the "item_enclosures" field.
func (u *ItemUpsertOne) SetItemEnclosures(v string) *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.SetItemEnclosures(v)
	})
}

// UpdateItemEnclosures sets the "item_enclosures" field to the value that was provided on create.
func (u *ItemUpsertOne) UpdateItemEnclosures() *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.UpdateItemEnclosures()
	})
}

// SetCrawlerTitle sets the "crawler_title" field.
func (u *ItemUpsertOne) SetCrawlerTitle(v string) *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.SetCrawlerTitle(v)
	})
}

// UpdateCrawlerTitle sets the "crawler_title" field to the value that was provided on create.
func (u *ItemUpsertOne) UpdateCrawlerTitle() *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.UpdateCrawlerTitle()
	})
}

// ClearCrawlerTitle clears the value of the "crawler_title" field.
func (u *ItemUpsertOne) ClearCrawlerTitle() *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.ClearCrawlerTitle()
	})
}

// SetCrawlerAuthor sets the "crawler_author" field.
func (u *ItemUpsertOne) SetCrawlerAuthor(v string) *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.SetCrawlerAuthor(v)
	})
}

// UpdateCrawlerAuthor sets the "crawler_author" field to the value that was provided on create.
func (u *ItemUpsertOne) UpdateCrawlerAuthor() *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.UpdateCrawlerAuthor()
	})
}

// ClearCrawlerAuthor clears the value of the "crawler_author" field.
func (u *ItemUpsertOne) ClearCrawlerAuthor() *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.ClearCrawlerAuthor()
	})
}

// SetCrawlerExcerpt sets the "crawler_excerpt" field.
func (u *ItemUpsertOne) SetCrawlerExcerpt(v string) *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.SetCrawlerExcerpt(v)
	})
}

// UpdateCrawlerExcerpt sets the "crawler_excerpt" field to the value that was provided on create.
func (u *ItemUpsertOne) UpdateCrawlerExcerpt() *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.UpdateCrawlerExcerpt()
	})
}

// ClearCrawlerExcerpt clears the value of the "crawler_excerpt" field.
func (u *ItemUpsertOne) ClearCrawlerExcerpt() *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.ClearCrawlerExcerpt()
	})
}

// SetCrawlerSiteName sets the "crawler_site_name" field.
func (u *ItemUpsertOne) SetCrawlerSiteName(v string) *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.SetCrawlerSiteName(v)
	})
}

// UpdateCrawlerSiteName sets the "crawler_site_name" field to the value that was provided on create.
func (u *ItemUpsertOne) UpdateCrawlerSiteName() *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.UpdateCrawlerSiteName()
	})
}

// ClearCrawlerSiteName clears the value of the "crawler_site_name" field.
func (u *ItemUpsertOne) ClearCrawlerSiteName() *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.ClearCrawlerSiteName()
	})
}

// SetCrawlerImage sets the "crawler_image" field.
func (u *ItemUpsertOne) SetCrawlerImage(v string) *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.SetCrawlerImage(v)
	})
}

// UpdateCrawlerImage sets the "crawler_image" field to the value that was provided on create.
func (u *ItemUpsertOne) UpdateCrawlerImage() *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.UpdateCrawlerImage()
	})
}

// ClearCrawlerImage clears the value of the "crawler_image" field.
func (u *ItemUpsertOne) ClearCrawlerImage() *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.ClearCrawlerImage()
	})
}

// SetCrawlerContentHTML sets the "crawler_content_html" field.
func (u *ItemUpsertOne) SetCrawlerContentHTML(v string) *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.SetCrawlerContentHTML(v)
	})
}

// UpdateCrawlerContentHTML sets the "crawler_content_html" field to the value that was provided on create.
func (u *ItemUpsertOne) UpdateCrawlerContentHTML() *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.UpdateCrawlerContentHTML()
	})
}

// ClearCrawlerContentHTML clears the value of the "crawler_content_html" field.
func (u *ItemUpsertOne) ClearCrawlerContentHTML() *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.ClearCrawlerContentHTML()
	})
}

// SetCrawlerContentText sets the "crawler_content_text" field.
func (u *ItemUpsertOne) SetCrawlerContentText(v string) *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.SetCrawlerContentText(v)
	})
}

// UpdateCrawlerContentText sets the "crawler_content_text" field to the value that was provided on create.
func (u *ItemUpsertOne) UpdateCrawlerContentText() *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.UpdateCrawlerContentText()
	})
}

// ClearCrawlerContentText clears the value of the "crawler_content_text" field.
func (u *ItemUpsertOne) ClearCrawlerContentText() *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.ClearCrawlerContentText()
	})
}

// SetCreatedAt sets the "created_at" field.
func (u *ItemUpsertOne) SetCreatedAt(v time.Time) *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.SetCreatedAt(v)
	})
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *ItemUpsertOne) UpdateCreatedAt() *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.UpdateCreatedAt()
	})
}

// SetUpdatedAt sets the "updated_at" field.
func (u *ItemUpsertOne) SetUpdatedAt(v time.Time) *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.SetUpdatedAt(v)
	})
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *ItemUpsertOne) UpdateUpdatedAt() *ItemUpsertOne {
	return u.Update(func(s *ItemUpsert) {
		s.UpdateUpdatedAt()
	})
}

// Exec executes the query.
func (u *ItemUpsertOne) Exec(ctx context.Context) error {
	if len(u.create.conflict) == 0 {
		return errors.New("ent: missing options for ItemCreate.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *ItemUpsertOne) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}

// Exec executes the UPSERT query and returns the inserted/updated ID.
func (u *ItemUpsertOne) ID(ctx context.Context) (id uuid.UUID, err error) {
	if u.create.driver.Dialect() == dialect.MySQL {
		// In case of "ON CONFLICT", there is no way to get back non-numeric ID
		// fields from the database since MySQL does not support the RETURNING clause.
		return id, errors.New("ent: ItemUpsertOne.ID is not supported by MySQL driver. Use ItemUpsertOne.Exec instead")
	}
	node, err := u.create.Save(ctx)
	if err != nil {
		return id, err
	}
	return node.ID, nil
}

// IDX is like ID, but panics if an error occurs.
func (u *ItemUpsertOne) IDX(ctx context.Context) uuid.UUID {
	id, err := u.ID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// ItemCreateBulk is the builder for creating many Item entities in bulk.
type ItemCreateBulk struct {
	config
	err      error
	builders []*ItemCreate
	conflict []sql.ConflictOption
}

// Save creates the Item entities in the database.
func (icb *ItemCreateBulk) Save(ctx context.Context) ([]*Item, error) {
	if icb.err != nil {
		return nil, icb.err
	}
	specs := make([]*sqlgraph.CreateSpec, len(icb.builders))
	nodes := make([]*Item, len(icb.builders))
	mutators := make([]Mutator, len(icb.builders))
	for i := range icb.builders {
		func(i int, root context.Context) {
			builder := icb.builders[i]
			builder.defaults()
			var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
				mutation, ok := m.(*ItemMutation)
				if !ok {
					return nil, fmt.Errorf("unexpected mutation type %T", m)
				}
				if err := builder.check(); err != nil {
					return nil, err
				}
				builder.mutation = mutation
				var err error
				nodes[i], specs[i] = builder.createSpec()
				if i < len(mutators)-1 {
					_, err = mutators[i+1].Mutate(root, icb.builders[i+1].mutation)
				} else {
					spec := &sqlgraph.BatchCreateSpec{Nodes: specs}
					spec.OnConflict = icb.conflict
					// Invoke the actual operation on the latest mutation in the chain.
					if err = sqlgraph.BatchCreate(ctx, icb.driver, spec); err != nil {
						if sqlgraph.IsConstraintError(err) {
							err = &ConstraintError{msg: err.Error(), wrap: err}
						}
					}
				}
				if err != nil {
					return nil, err
				}
				mutation.id = &nodes[i].ID
				mutation.done = true
				return nodes[i], nil
			})
			for i := len(builder.hooks) - 1; i >= 0; i-- {
				mut = builder.hooks[i](mut)
			}
			mutators[i] = mut
		}(i, ctx)
	}
	if len(mutators) > 0 {
		if _, err := mutators[0].Mutate(ctx, icb.builders[0].mutation); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

// SaveX is like Save, but panics if an error occurs.
func (icb *ItemCreateBulk) SaveX(ctx context.Context) []*Item {
	v, err := icb.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (icb *ItemCreateBulk) Exec(ctx context.Context) error {
	_, err := icb.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (icb *ItemCreateBulk) ExecX(ctx context.Context) {
	if err := icb.Exec(ctx); err != nil {
		panic(err)
	}
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.Item.CreateBulk(builders...).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.ItemUpsert) {
//			SetItemGUID(v+v).
//		}).
//		Exec(ctx)
func (icb *ItemCreateBulk) OnConflict(opts ...sql.ConflictOption) *ItemUpsertBulk {
	icb.conflict = opts
	return &ItemUpsertBulk{
		create: icb,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.Item.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (icb *ItemCreateBulk) OnConflictColumns(columns ...string) *ItemUpsertBulk {
	icb.conflict = append(icb.conflict, sql.ConflictColumns(columns...))
	return &ItemUpsertBulk{
		create: icb,
	}
}

// ItemUpsertBulk is the builder for "upsert"-ing
// a bulk of Item nodes.
type ItemUpsertBulk struct {
	create *ItemCreateBulk
}

// UpdateNewValues updates the mutable fields using the new values that
// were set on create. Using this option is equivalent to using:
//
//	client.Item.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(item.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *ItemUpsertBulk) UpdateNewValues() *ItemUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		for _, b := range u.create.builders {
			if _, exists := b.mutation.ID(); exists {
				s.SetIgnore(item.FieldID)
			}
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.Item.Create().
//		OnConflict(sql.ResolveWithIgnore()).
//		Exec(ctx)
func (u *ItemUpsertBulk) Ignore() *ItemUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *ItemUpsertBulk) DoNothing() *ItemUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the ItemCreateBulk.OnConflict
// documentation for more info.
func (u *ItemUpsertBulk) Update(set func(*ItemUpsert)) *ItemUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&ItemUpsert{UpdateSet: update})
	}))
	return u
}

// SetItemGUID sets the "item_guid" field.
func (u *ItemUpsertBulk) SetItemGUID(v string) *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.SetItemGUID(v)
	})
}

// UpdateItemGUID sets the "item_guid" field to the value that was provided on create.
func (u *ItemUpsertBulk) UpdateItemGUID() *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.UpdateItemGUID()
	})
}

// SetItemTitle sets the "item_title" field.
func (u *ItemUpsertBulk) SetItemTitle(v string) *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.SetItemTitle(v)
	})
}

// UpdateItemTitle sets the "item_title" field to the value that was provided on create.
func (u *ItemUpsertBulk) UpdateItemTitle() *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.UpdateItemTitle()
	})
}

// SetItemDescription sets the "item_description" field.
func (u *ItemUpsertBulk) SetItemDescription(v string) *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.SetItemDescription(v)
	})
}

// UpdateItemDescription sets the "item_description" field to the value that was provided on create.
func (u *ItemUpsertBulk) UpdateItemDescription() *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.UpdateItemDescription()
	})
}

// SetItemContent sets the "item_content" field.
func (u *ItemUpsertBulk) SetItemContent(v string) *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.SetItemContent(v)
	})
}

// UpdateItemContent sets the "item_content" field to the value that was provided on create.
func (u *ItemUpsertBulk) UpdateItemContent() *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.UpdateItemContent()
	})
}

// SetItemLink sets the "item_link" field.
func (u *ItemUpsertBulk) SetItemLink(v string) *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.SetItemLink(v)
	})
}

// UpdateItemLink sets the "item_link" field to the value that was provided on create.
func (u *ItemUpsertBulk) UpdateItemLink() *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.UpdateItemLink()
	})
}

// SetItemUpdated sets the "item_updated" field.
func (u *ItemUpsertBulk) SetItemUpdated(v time.Time) *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.SetItemUpdated(v)
	})
}

// UpdateItemUpdated sets the "item_updated" field to the value that was provided on create.
func (u *ItemUpsertBulk) UpdateItemUpdated() *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.UpdateItemUpdated()
	})
}

// SetItemPublished sets the "item_published" field.
func (u *ItemUpsertBulk) SetItemPublished(v time.Time) *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.SetItemPublished(v)
	})
}

// UpdateItemPublished sets the "item_published" field to the value that was provided on create.
func (u *ItemUpsertBulk) UpdateItemPublished() *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.UpdateItemPublished()
	})
}

// SetItemAuthorName sets the "item_author_name" field.
func (u *ItemUpsertBulk) SetItemAuthorName(v string) *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.SetItemAuthorName(v)
	})
}

// UpdateItemAuthorName sets the "item_author_name" field to the value that was provided on create.
func (u *ItemUpsertBulk) UpdateItemAuthorName() *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.UpdateItemAuthorName()
	})
}

// ClearItemAuthorName clears the value of the "item_author_name" field.
func (u *ItemUpsertBulk) ClearItemAuthorName() *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.ClearItemAuthorName()
	})
}

// SetItemAuthorEmail sets the "item_author_email" field.
func (u *ItemUpsertBulk) SetItemAuthorEmail(v string) *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.SetItemAuthorEmail(v)
	})
}

// UpdateItemAuthorEmail sets the "item_author_email" field to the value that was provided on create.
func (u *ItemUpsertBulk) UpdateItemAuthorEmail() *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.UpdateItemAuthorEmail()
	})
}

// ClearItemAuthorEmail clears the value of the "item_author_email" field.
func (u *ItemUpsertBulk) ClearItemAuthorEmail() *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.ClearItemAuthorEmail()
	})
}

// SetItemImageTitle sets the "item_image_title" field.
func (u *ItemUpsertBulk) SetItemImageTitle(v string) *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.SetItemImageTitle(v)
	})
}

// UpdateItemImageTitle sets the "item_image_title" field to the value that was provided on create.
func (u *ItemUpsertBulk) UpdateItemImageTitle() *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.UpdateItemImageTitle()
	})
}

// ClearItemImageTitle clears the value of the "item_image_title" field.
func (u *ItemUpsertBulk) ClearItemImageTitle() *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.ClearItemImageTitle()
	})
}

// SetItemImageURL sets the "item_image_url" field.
func (u *ItemUpsertBulk) SetItemImageURL(v string) *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.SetItemImageURL(v)
	})
}

// UpdateItemImageURL sets the "item_image_url" field to the value that was provided on create.
func (u *ItemUpsertBulk) UpdateItemImageURL() *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.UpdateItemImageURL()
	})
}

// ClearItemImageURL clears the value of the "item_image_url" field.
func (u *ItemUpsertBulk) ClearItemImageURL() *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.ClearItemImageURL()
	})
}

// SetItemCategories sets the "item_categories" field.
func (u *ItemUpsertBulk) SetItemCategories(v string) *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.SetItemCategories(v)
	})
}

// UpdateItemCategories sets the "item_categories" field to the value that was provided on create.
func (u *ItemUpsertBulk) UpdateItemCategories() *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.UpdateItemCategories()
	})
}

// SetItemEnclosures sets the "item_enclosures" field.
func (u *ItemUpsertBulk) SetItemEnclosures(v string) *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.SetItemEnclosures(v)
	})
}

// UpdateItemEnclosures sets the "item_enclosures" field to the value that was provided on create.
func (u *ItemUpsertBulk) UpdateItemEnclosures() *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.UpdateItemEnclosures()
	})
}

// SetCrawlerTitle sets the "crawler_title" field.
func (u *ItemUpsertBulk) SetCrawlerTitle(v string) *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.SetCrawlerTitle(v)
	})
}

// UpdateCrawlerTitle sets the "crawler_title" field to the value that was provided on create.
func (u *ItemUpsertBulk) UpdateCrawlerTitle() *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.UpdateCrawlerTitle()
	})
}

// ClearCrawlerTitle clears the value of the "crawler_title" field.
func (u *ItemUpsertBulk) ClearCrawlerTitle() *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.ClearCrawlerTitle()
	})
}

// SetCrawlerAuthor sets the "crawler_author" field.
func (u *ItemUpsertBulk) SetCrawlerAuthor(v string) *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.SetCrawlerAuthor(v)
	})
}

// UpdateCrawlerAuthor sets the "crawler_author" field to the value that was provided on create.
func (u *ItemUpsertBulk) UpdateCrawlerAuthor() *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.UpdateCrawlerAuthor()
	})
}

// ClearCrawlerAuthor clears the value of the "crawler_author" field.
func (u *ItemUpsertBulk) ClearCrawlerAuthor() *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.ClearCrawlerAuthor()
	})
}

// SetCrawlerExcerpt sets the "crawler_excerpt" field.
func (u *ItemUpsertBulk) SetCrawlerExcerpt(v string) *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.SetCrawlerExcerpt(v)
	})
}

// UpdateCrawlerExcerpt sets the "crawler_excerpt" field to the value that was provided on create.
func (u *ItemUpsertBulk) UpdateCrawlerExcerpt() *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.UpdateCrawlerExcerpt()
	})
}

// ClearCrawlerExcerpt clears the value of the "crawler_excerpt" field.
func (u *ItemUpsertBulk) ClearCrawlerExcerpt() *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.ClearCrawlerExcerpt()
	})
}

// SetCrawlerSiteName sets the "crawler_site_name" field.
func (u *ItemUpsertBulk) SetCrawlerSiteName(v string) *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.SetCrawlerSiteName(v)
	})
}

// UpdateCrawlerSiteName sets the "crawler_site_name" field to the value that was provided on create.
func (u *ItemUpsertBulk) UpdateCrawlerSiteName() *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.UpdateCrawlerSiteName()
	})
}

// ClearCrawlerSiteName clears the value of the "crawler_site_name" field.
func (u *ItemUpsertBulk) ClearCrawlerSiteName() *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.ClearCrawlerSiteName()
	})
}

// SetCrawlerImage sets the "crawler_image" field.
func (u *ItemUpsertBulk) SetCrawlerImage(v string) *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.SetCrawlerImage(v)
	})
}

// UpdateCrawlerImage sets the "crawler_image" field to the value that was provided on create.
func (u *ItemUpsertBulk) UpdateCrawlerImage() *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.UpdateCrawlerImage()
	})
}

// ClearCrawlerImage clears the value of the "crawler_image" field.
func (u *ItemUpsertBulk) ClearCrawlerImage() *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.ClearCrawlerImage()
	})
}

// SetCrawlerContentHTML sets the "crawler_content_html" field.
func (u *ItemUpsertBulk) SetCrawlerContentHTML(v string) *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.SetCrawlerContentHTML(v)
	})
}

// UpdateCrawlerContentHTML sets the "crawler_content_html" field to the value that was provided on create.
func (u *ItemUpsertBulk) UpdateCrawlerContentHTML() *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.UpdateCrawlerContentHTML()
	})
}

// ClearCrawlerContentHTML clears the value of the "crawler_content_html" field.
func (u *ItemUpsertBulk) ClearCrawlerContentHTML() *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.ClearCrawlerContentHTML()
	})
}

// SetCrawlerContentText sets the "crawler_content_text" field.
func (u *ItemUpsertBulk) SetCrawlerContentText(v string) *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.SetCrawlerContentText(v)
	})
}

// UpdateCrawlerContentText sets the "crawler_content_text" field to the value that was provided on create.
func (u *ItemUpsertBulk) UpdateCrawlerContentText() *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.UpdateCrawlerContentText()
	})
}

// ClearCrawlerContentText clears the value of the "crawler_content_text" field.
func (u *ItemUpsertBulk) ClearCrawlerContentText() *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.ClearCrawlerContentText()
	})
}

// SetCreatedAt sets the "created_at" field.
func (u *ItemUpsertBulk) SetCreatedAt(v time.Time) *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.SetCreatedAt(v)
	})
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *ItemUpsertBulk) UpdateCreatedAt() *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.UpdateCreatedAt()
	})
}

// SetUpdatedAt sets the "updated_at" field.
func (u *ItemUpsertBulk) SetUpdatedAt(v time.Time) *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.SetUpdatedAt(v)
	})
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *ItemUpsertBulk) UpdateUpdatedAt() *ItemUpsertBulk {
	return u.Update(func(s *ItemUpsert) {
		s.UpdateUpdatedAt()
	})
}

// Exec executes the query.
func (u *ItemUpsertBulk) Exec(ctx context.Context) error {
	if u.create.err != nil {
		return u.create.err
	}
	for i, b := range u.create.builders {
		if len(b.conflict) != 0 {
			return fmt.Errorf("ent: OnConflict was set for builder %d. Set it on the ItemCreateBulk instead", i)
		}
	}
	if len(u.create.conflict) == 0 {
		return errors.New("ent: missing options for ItemCreateBulk.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *ItemUpsertBulk) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}
