/*--------------------------------------------------------------------
 * Symbols referenced in this file:
 * - UnreservedPLKeywords
 * - UnreservedPLKeywords_kw_string
 * - UnreservedPLKeywords_kw_offsets
 * - UnreservedPLKeywords_hash_func
 *--------------------------------------------------------------------
 */

/*-------------------------------------------------------------------------
 *
 * pl_unreserved_kwlist_d.h
 *    List of keywords represented as a ScanKeywordList.
 *
 * Portions Copyright (c) 1996-2023, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * NOTES
 *  ******************************
 *  *** DO NOT EDIT THIS FILE! ***
 *  ******************************
 *
 *  It has been GENERATED by src/tools/gen_keywordlist.pl
 *
 *-------------------------------------------------------------------------
 */

#ifndef PL_UNRESERVED_KWLIST_D_H
#define PL_UNRESERVED_KWLIST_D_H

#include "common/kwlookup.h"

static const char UnreservedPLKeywords_kw_string[] =
	"absolute\0"
	"alias\0"
	"and\0"
	"array\0"
	"assert\0"
	"backward\0"
	"call\0"
	"chain\0"
	"close\0"
	"collate\0"
	"column\0"
	"column_name\0"
	"commit\0"
	"constant\0"
	"constraint\0"
	"constraint_name\0"
	"continue\0"
	"current\0"
	"cursor\0"
	"datatype\0"
	"debug\0"
	"default\0"
	"detail\0"
	"diagnostics\0"
	"do\0"
	"dump\0"
	"elseif\0"
	"elsif\0"
	"errcode\0"
	"error\0"
	"exception\0"
	"exit\0"
	"fetch\0"
	"first\0"
	"forward\0"
	"get\0"
	"hint\0"
	"import\0"
	"info\0"
	"insert\0"
	"is\0"
	"last\0"
	"log\0"
	"merge\0"
	"message\0"
	"message_text\0"
	"move\0"
	"next\0"
	"no\0"
	"notice\0"
	"open\0"
	"option\0"
	"perform\0"
	"pg_context\0"
	"pg_datatype_name\0"
	"pg_exception_context\0"
	"pg_exception_detail\0"
	"pg_exception_hint\0"
	"pg_routine_oid\0"
	"print_strict_params\0"
	"prior\0"
	"query\0"
	"raise\0"
	"relative\0"
	"return\0"
	"returned_sqlstate\0"
	"reverse\0"
	"rollback\0"
	"row_count\0"
	"rowtype\0"
	"schema\0"
	"schema_name\0"
	"scroll\0"
	"slice\0"
	"sqlstate\0"
	"stacked\0"
	"table\0"
	"table_name\0"
	"type\0"
	"use_column\0"
	"use_variable\0"
	"variable_conflict\0"
	"warning";

static const uint16 UnreservedPLKeywords_kw_offsets[] = {
	0,
	9,
	15,
	19,
	25,
	32,
	41,
	46,
	52,
	58,
	66,
	73,
	85,
	92,
	101,
	112,
	128,
	137,
	145,
	152,
	161,
	167,
	175,
	182,
	194,
	197,
	202,
	209,
	215,
	223,
	229,
	239,
	244,
	250,
	256,
	264,
	268,
	273,
	280,
	285,
	292,
	295,
	300,
	304,
	310,
	318,
	331,
	336,
	341,
	344,
	351,
	356,
	363,
	371,
	382,
	399,
	420,
	440,
	458,
	473,
	493,
	499,
	505,
	511,
	520,
	527,
	545,
	553,
	562,
	572,
	580,
	587,
	599,
	606,
	612,
	621,
	629,
	635,
	646,
	651,
	662,
	675,
	693,
};

#define UNRESERVEDPLKEYWORDS_NUM_KEYWORDS 83

static int
UnreservedPLKeywords_hash_func(const void *key, size_t keylen)
{
	static const int16 h[167] = {
		0,     -26,   32767, 0,     74,    -36,   32767, 32767,
		93,    0,     35,    14,    34,    -65,   -42,   78,
		-22,   8,     10,    0,     5,     32767, 10,    26,
		32767, 4,     32767, 32767, -81,   -9,    -25,   32767,
		-17,   11,    0,     -43,   11,    8,     45,    0,
		32767, 32767, 32767, 12,    0,     32767, 32,    32767,
		0,     32767, -18,   64,    32767, -2,    31,    32767,
		50,    80,    -75,   32767, 32767, 32767, 0,     32767,
		32767, 0,     54,    82,    32767, 32767, 69,    60,
		43,    32767, 0,     95,    21,    1,     27,    0,
		120,   32767, -46,   32767, -57,   32767, 32767, 55,
		70,    32767, 28,    32767, 0,     -14,   -38,   32767,
		57,    0,     32767, 19,    98,    0,     32767, 68,
		32767, 32767, 32767, 32767, -26,   13,    27,    35,
		37,    32767, 49,    -44,   65,    -35,   0,     32767,
		32767, 32767, 30,    0,     0,     32767, 26,    42,
		7,     32767, 72,    -43,   32767, 0,     32767, 89,
		36,    48,    32767, 32,    38,    3,     32767, 49,
		32767, 0,     51,    0,     32767, 73,    32767, 32767,
		79,    32767, 30,    32767, 0,     0,     50,    32767,
		0,     32767, 32767, 32767, 0,     32767, 32767
	};

	const unsigned char *k = (const unsigned char *) key;
	uint32		a = 0;
	uint32		b = 1;

	while (keylen--)
	{
		unsigned char c = *k++ | 0x20;

		a = a * 257 + c;
		b = b * 8191 + c;
	}
	return h[a % 167] + h[b % 167];
}

static const ScanKeywordList UnreservedPLKeywords = {
	UnreservedPLKeywords_kw_string,
	UnreservedPLKeywords_kw_offsets,
	UnreservedPLKeywords_hash_func,
	UNRESERVEDPLKEYWORDS_NUM_KEYWORDS,
	20
};

#endif							/* PL_UNRESERVED_KWLIST_D_H */
