package uniseg

// Code generated via go generate from gen_breaktest.go. DO NOT EDIT.

// lineBreakTestCases are Grapheme testcases taken from
// https://www.unicode.org/Public/14.0.0/ucd/auxiliary/LineBreakTest.txt
// on July 25, 2022. See
// https://www.unicode.org/license.html for the Unicode license agreement.
var lineBreakTestCases = []testCase{
	{original: "\u0023\u0023", expected: [][]rune{{0x0023, 0x0023}}},                                                                                                                               // × [0.3] NUMBER SIGN (AL) × [28.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u0023\u0020\u0023", expected: [][]rune{{0x0023, 0x0020}, {0x0023}}},                                                                                                               // × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u0023\u0308\u0023", expected: [][]rune{{0x0023, 0x0308, 0x0023}}},                                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [28.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u0023\u0308\u0020\u0023", expected: [][]rune{{0x0023, 0x0308, 0x0020}, {0x0023}}},                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u0023\u2014", expected: [][]rune{{0x0023}, {0x2014}}},                                                                                                                             // × [0.3] NUMBER SIGN (AL) ÷ [999.0] EM DASH (B2) ÷ [0.3]
	{original: "\u0023\u0020\u2014", expected: [][]rune{{0x0023, 0x0020}, {0x2014}}},                                                                                                               // × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
	{original: "\u0023\u0308\u2014", expected: [][]rune{{0x0023, 0x0308}, {0x2014}}},                                                                                                               // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
	{original: "\u0023\u0308\u0020\u2014", expected: [][]rune{{0x0023, 0x0308, 0x0020}, {0x2014}}},                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
	{original: "\u0023\u0009", expected: [][]rune{{0x0023, 0x0009}}},                                                                                                                               // × [0.3] NUMBER SIGN (AL) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u0023\u0020\u0009", expected: [][]rune{{0x0023, 0x0020}, {0x0009}}},                                                                                                               // × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u0023\u0308\u0009", expected: [][]rune{{0x0023, 0x0308, 0x0009}}},                                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u0023\u0308\u0020\u0009", expected: [][]rune{{0x0023, 0x0308, 0x0020}, {0x0009}}},                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u0023\u00B4", expected: [][]rune{{0x0023}, {0x00B4}}},                                                                                                                             // × [0.3] NUMBER SIGN (AL) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u0023\u0020\u00B4", expected: [][]rune{{0x0023, 0x0020}, {0x00B4}}},                                                                                                               // × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u0023\u0308\u00B4", expected: [][]rune{{0x0023, 0x0308}, {0x00B4}}},                                                                                                               // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u0023\u0308\u0020\u00B4", expected: [][]rune{{0x0023, 0x0308, 0x0020}, {0x00B4}}},                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u0023\u000B", expected: [][]rune{{0x0023, 0x000B}}},                                                                                                                               // × [0.3] NUMBER SIGN (AL) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u0023\u0020\u000B", expected: [][]rune{{0x0023, 0x0020, 0x000B}}},                                                                                                                 // × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u0023\u0308\u000B", expected: [][]rune{{0x0023, 0x0308, 0x000B}}},                                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u0023\u0308\u0020\u000B", expected: [][]rune{{0x0023, 0x0308, 0x0020, 0x000B}}},                                                                                                   // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u0023\uFFFC", expected: [][]rune{{0x0023}, {0xFFFC}}},                                                                                                                             // × [0.3] NUMBER SIGN (AL) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u0023\u0020\uFFFC", expected: [][]rune{{0x0023, 0x0020}, {0xFFFC}}},                                                                                                               // × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u0023\u0308\uFFFC", expected: [][]rune{{0x0023, 0x0308}, {0xFFFC}}},                                                                                                               // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u0023\u0308\u0020\uFFFC", expected: [][]rune{{0x0023, 0x0308, 0x0020}, {0xFFFC}}},                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u0023\u007D", expected: [][]rune{{0x0023, 0x007D}}},                                                                                                                               // × [0.3] NUMBER SIGN (AL) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u0023\u0020\u007D", expected: [][]rune{{0x0023, 0x0020, 0x007D}}},                                                                                                                 // × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u0023\u0308\u007D", expected: [][]rune{{0x0023, 0x0308, 0x007D}}},                                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u0023\u0308\u0020\u007D", expected: [][]rune{{0x0023, 0x0308, 0x0020, 0x007D}}},                                                                                                   // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u0023\u000D", expected: [][]rune{{0x0023, 0x000D}}},                                                                                                                               // × [0.3] NUMBER SIGN (AL) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0023\u0020\u000D", expected: [][]rune{{0x0023, 0x0020, 0x000D}}},                                                                                                                 // × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0023\u0308\u000D", expected: [][]rune{{0x0023, 0x0308, 0x000D}}},                                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0023\u0308\u0020\u000D", expected: [][]rune{{0x0023, 0x0308, 0x0020, 0x000D}}},                                                                                                   // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0023\u0021", expected: [][]rune{{0x0023, 0x0021}}},                                                                                                                               // × [0.3] NUMBER SIGN (AL) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u0023\u0020\u0021", expected: [][]rune{{0x0023, 0x0020, 0x0021}}},                                                                                                                 // × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u0023\u0308\u0021", expected: [][]rune{{0x0023, 0x0308, 0x0021}}},                                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u0023\u0308\u0020\u0021", expected: [][]rune{{0x0023, 0x0308, 0x0020, 0x0021}}},                                                                                                   // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u0023\u00A0", expected: [][]rune{{0x0023, 0x00A0}}},                                                                                                                               // × [0.3] NUMBER SIGN (AL) × [12.1] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u0023\u0020\u00A0", expected: [][]rune{{0x0023, 0x0020}, {0x00A0}}},                                                                                                               // × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u0023\u0308\u00A0", expected: [][]rune{{0x0023, 0x0308, 0x00A0}}},                                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u0023\u0308\u0020\u00A0", expected: [][]rune{{0x0023, 0x0308, 0x0020}, {0x00A0}}},                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u0023\uAC00", expected: [][]rune{{0x0023}, {0xAC00}}},                                                                                                                             // × [0.3] NUMBER SIGN (AL) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u0023\u0020\uAC00", expected: [][]rune{{0x0023, 0x0020}, {0xAC00}}},                                                                                                               // × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u0023\u0308\uAC00", expected: [][]rune{{0x0023, 0x0308}, {0xAC00}}},                                                                                                               // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u0023\u0308\u0020\uAC00", expected: [][]rune{{0x0023, 0x0308, 0x0020}, {0xAC00}}},                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u0023\uAC01", expected: [][]rune{{0x0023}, {0xAC01}}},                                                                                                                             // × [0.3] NUMBER SIGN (AL) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u0023\u0020\uAC01", expected: [][]rune{{0x0023, 0x0020}, {0xAC01}}},                                                                                                               // × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u0023\u0308\uAC01", expected: [][]rune{{0x0023, 0x0308}, {0xAC01}}},                                                                                                               // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u0023\u0308\u0020\uAC01", expected: [][]rune{{0x0023, 0x0308, 0x0020}, {0xAC01}}},                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u0023\u05D0", expected: [][]rune{{0x0023, 0x05D0}}},                                                                                                                               // × [0.3] NUMBER SIGN (AL) × [28.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u0023\u0020\u05D0", expected: [][]rune{{0x0023, 0x0020}, {0x05D0}}},                                                                                                               // × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u0023\u0308\u05D0", expected: [][]rune{{0x0023, 0x0308, 0x05D0}}},                                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [28.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u0023\u0308\u0020\u05D0", expected: [][]rune{{0x0023, 0x0308, 0x0020}, {0x05D0}}},                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u0023\u002D", expected: [][]rune{{0x0023, 0x002D}}},                                                                                                                               // × [0.3] NUMBER SIGN (AL) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u0023\u0020\u002D", expected: [][]rune{{0x0023, 0x0020}, {0x002D}}},                                                                                                               // × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u0023\u0308\u002D", expected: [][]rune{{0x0023, 0x0308, 0x002D}}},                                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u0023\u0308\u0020\u002D", expected: [][]rune{{0x0023, 0x0308, 0x0020}, {0x002D}}},                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u0023\u231A", expected: [][]rune{{0x0023}, {0x231A}}},                                                                                                                             // × [0.3] NUMBER SIGN (AL) ÷ [999.0] WATCH (ID) ÷ [0.3]
	{original: "\u0023\u0020\u231A", expected: [][]rune{{0x0023, 0x0020}, {0x231A}}},                                                                                                               // × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
	{original: "\u0023\u0308\u231A", expected: [][]rune{{0x0023, 0x0308}, {0x231A}}},                                                                                                               // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
	{original: "\u0023\u0308\u0020\u231A", expected: [][]rune{{0x0023, 0x0308, 0x0020}, {0x231A}}},                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
	{original: "\u0023\u2024", expected: [][]rune{{0x0023, 0x2024}}},                                                                                                                               // × [0.3] NUMBER SIGN (AL) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u0023\u0020\u2024", expected: [][]rune{{0x0023, 0x0020}, {0x2024}}},                                                                                                               // × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u0023\u0308\u2024", expected: [][]rune{{0x0023, 0x0308, 0x2024}}},                                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u0023\u0308\u0020\u2024", expected: [][]rune{{0x0023, 0x0308, 0x0020}, {0x2024}}},                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u0023\u002C", expected: [][]rune{{0x0023, 0x002C}}},                                                                                                                               // × [0.3] NUMBER SIGN (AL) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u0023\u0020\u002C", expected: [][]rune{{0x0023, 0x0020, 0x002C}}},                                                                                                                 // × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u0023\u0308\u002C", expected: [][]rune{{0x0023, 0x0308, 0x002C}}},                                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
	{original: "\u0023\u0308\u0020\u002C", expected: [][]rune{{0x0023, 0x0308, 0x0020, 0x002C}}},                                                                                                   // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u0023\u1100", expected: [][]rune{{0x0023}, {0x1100}}},                                                                                                                             // × [0.3] NUMBER SIGN (AL) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u0023\u0020\u1100", expected: [][]rune{{0x0023, 0x0020}, {0x1100}}},                                                                                                               // × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u0023\u0308\u1100", expected: [][]rune{{0x0023, 0x0308}, {0x1100}}},                                                                                                               // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u0023\u0308\u0020\u1100", expected: [][]rune{{0x0023, 0x0308, 0x0020}, {0x1100}}},                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u0023\u11A8", expected: [][]rune{{0x0023}, {0x11A8}}},                                                                                                                             // × [0.3] NUMBER SIGN (AL) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u0023\u0020\u11A8", expected: [][]rune{{0x0023, 0x0020}, {0x11A8}}},                                                                                                               // × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u0023\u0308\u11A8", expected: [][]rune{{0x0023, 0x0308}, {0x11A8}}},                                                                                                               // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u0023\u0308\u0020\u11A8", expected: [][]rune{{0x0023, 0x0308, 0x0020}, {0x11A8}}},                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u0023\u1160", expected: [][]rune{{0x0023}, {0x1160}}},                                                                                                                             // × [0.3] NUMBER SIGN (AL) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u0023\u0020\u1160", expected: [][]rune{{0x0023, 0x0020}, {0x1160}}},                                                                                                               // × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u0023\u0308\u1160", expected: [][]rune{{0x0023, 0x0308}, {0x1160}}},                                                                                                               // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u0023\u0308\u0020\u1160", expected: [][]rune{{0x0023, 0x0308, 0x0020}, {0x1160}}},                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u0023\u000A", expected: [][]rune{{0x0023, 0x000A}}},                                                                                                                               // × [0.3] NUMBER SIGN (AL) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0023\u0020\u000A", expected: [][]rune{{0x0023, 0x0020, 0x000A}}},                                                                                                                 // × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0023\u0308\u000A", expected: [][]rune{{0x0023, 0x0308, 0x000A}}},                                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0023\u0308\u0020\u000A", expected: [][]rune{{0x0023, 0x0308, 0x0020, 0x000A}}},                                                                                                   // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0023\u0085", expected: [][]rune{{0x0023, 0x0085}}},                                                                                                                               // × [0.3] NUMBER SIGN (AL) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u0023\u0020\u0085", expected: [][]rune{{0x0023, 0x0020, 0x0085}}},                                                                                                                 // × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u0023\u0308\u0085", expected: [][]rune{{0x0023, 0x0308, 0x0085}}},                                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u0023\u0308\u0020\u0085", expected: [][]rune{{0x0023, 0x0308, 0x0020, 0x0085}}},                                                                                                   // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u0023\u17D6", expected: [][]rune{{0x0023, 0x17D6}}},                                                                                                                               // × [0.3] NUMBER SIGN (AL) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u0023\u0020\u17D6", expected: [][]rune{{0x0023, 0x0020}, {0x17D6}}},                                                                                                               // × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u0023\u0308\u17D6", expected: [][]rune{{0x0023, 0x0308, 0x17D6}}},                                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u0023\u0308\u0020\u17D6", expected: [][]rune{{0x0023, 0x0308, 0x0020}, {0x17D6}}},                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u0023\u0030", expected: [][]rune{{0x0023, 0x0030}}},                                                                                                                               // × [0.3] NUMBER SIGN (AL) × [23.02] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u0023\u0020\u0030", expected: [][]rune{{0x0023, 0x0020}, {0x0030}}},                                                                                                               // × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u0023\u0308\u0030", expected: [][]rune{{0x0023, 0x0308, 0x0030}}},                                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [23.02] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u0023\u0308\u0020\u0030", expected: [][]rune{{0x0023, 0x0308, 0x0020}, {0x0030}}},                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u0023\u2329", expected: [][]rune{{0x0023}, {0x2329}}},                                                                                                                             // × [0.3] NUMBER SIGN (AL) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u0023\u0020\u2329", expected: [][]rune{{0x0023, 0x0020}, {0x2329}}},                                                                                                               // × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u0023\u0308\u2329", expected: [][]rune{{0x0023, 0x0308}, {0x2329}}},                                                                                                               // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u0023\u0308\u0020\u2329", expected: [][]rune{{0x0023, 0x0308, 0x0020}, {0x2329}}},                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u0023\u0025", expected: [][]rune{{0x0023, 0x0025}}},                                                                                                                               // × [0.3] NUMBER SIGN (AL) × [24.03] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u0023\u0020\u0025", expected: [][]rune{{0x0023, 0x0020}, {0x0025}}},                                                                                                               // × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u0023\u0308\u0025", expected: [][]rune{{0x0023, 0x0308, 0x0025}}},                                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [24.03] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u0023\u0308\u0020\u0025", expected: [][]rune{{0x0023, 0x0308, 0x0020}, {0x0025}}},                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u0023\u0024", expected: [][]rune{{0x0023, 0x0024}}},                                                                                                                               // × [0.3] NUMBER SIGN (AL) × [24.03] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u0023\u0020\u0024", expected: [][]rune{{0x0023, 0x0020}, {0x0024}}},                                                                                                               // × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u0023\u0308\u0024", expected: [][]rune{{0x0023, 0x0308, 0x0024}}},                                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [24.03] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u0023\u0308\u0020\u0024", expected: [][]rune{{0x0023, 0x0308, 0x0020}, {0x0024}}},                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u0023\u0022", expected: [][]rune{{0x0023, 0x0022}}},                                                                                                                               // × [0.3] NUMBER SIGN (AL) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u0023\u0020\u0022", expected: [][]rune{{0x0023, 0x0020}, {0x0022}}},                                                                                                               // × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u0023\u0308\u0022", expected: [][]rune{{0x0023, 0x0308, 0x0022}}},                                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u0023\u0308\u0020\u0022", expected: [][]rune{{0x0023, 0x0308, 0x0020}, {0x0022}}},                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u0023\u0020", expected: [][]rune{{0x0023, 0x0020}}},                                                                                                                               // × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u0023\u0020\u0020", expected: [][]rune{{0x0023, 0x0020, 0x0020}}},                                                                                                                 // × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u0023\u0308\u0020", expected: [][]rune{{0x0023, 0x0308, 0x0020}}},                                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u0023\u0308\u0020\u0020", expected: [][]rune{{0x0023, 0x0308, 0x0020, 0x0020}}},                                                                                                   // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u0023\u002F", expected: [][]rune{{0x0023, 0x002F}}},                                                                                                                               // × [0.3] NUMBER SIGN (AL) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\u0023\u0020\u002F", expected: [][]rune{{0x0023, 0x0020, 0x002F}}},                                                                                                                 // × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\u0023\u0308\u002F", expected: [][]rune{{0x0023, 0x0308, 0x002F}}},                                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
	{original: "\u0023\u0308\u0020\u002F", expected: [][]rune{{0x0023, 0x0308, 0x0020, 0x002F}}},                                                                                                   // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\u0023\u2060", expected: [][]rune{{0x0023, 0x2060}}},                                                                                                                               // × [0.3] NUMBER SIGN (AL) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u0023\u0020\u2060", expected: [][]rune{{0x0023, 0x0020, 0x2060}}},                                                                                                                 // × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u0023\u0308\u2060", expected: [][]rune{{0x0023, 0x0308, 0x2060}}},                                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u0023\u0308\u0020\u2060", expected: [][]rune{{0x0023, 0x0308, 0x0020, 0x2060}}},                                                                                                   // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u0023\u200B", expected: [][]rune{{0x0023, 0x200B}}},                                                                                                                               // × [0.3] NUMBER SIGN (AL) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u0023\u0020\u200B", expected: [][]rune{{0x0023, 0x0020, 0x200B}}},                                                                                                                 // × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u0023\u0308\u200B", expected: [][]rune{{0x0023, 0x0308, 0x200B}}},                                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u0023\u0308\u0020\u200B", expected: [][]rune{{0x0023, 0x0308, 0x0020, 0x200B}}},                                                                                                   // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u0023\U0001F1E6", expected: [][]rune{{0x0023}, {0x1F1E6}}},                                                                                                                        // × [0.3] NUMBER SIGN (AL) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0023\u0020\U0001F1E6", expected: [][]rune{{0x0023, 0x0020}, {0x1F1E6}}},                                                                                                          // × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0023\u0308\U0001F1E6", expected: [][]rune{{0x0023, 0x0308}, {0x1F1E6}}},                                                                                                          // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0023\u0308\u0020\U0001F1E6", expected: [][]rune{{0x0023, 0x0308, 0x0020}, {0x1F1E6}}},                                                                                            // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0023\u261D", expected: [][]rune{{0x0023}, {0x261D}}},                                                                                                                             // × [0.3] NUMBER SIGN (AL) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u0023\u0020\u261D", expected: [][]rune{{0x0023, 0x0020}, {0x261D}}},                                                                                                               // × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u0023\u0308\u261D", expected: [][]rune{{0x0023, 0x0308}, {0x261D}}},                                                                                                               // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u0023\u0308\u0020\u261D", expected: [][]rune{{0x0023, 0x0308, 0x0020}, {0x261D}}},                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u0023\U0001F3FB", expected: [][]rune{{0x0023}, {0x1F3FB}}},                                                                                                                        // × [0.3] NUMBER SIGN (AL) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u0023\u0020\U0001F3FB", expected: [][]rune{{0x0023, 0x0020}, {0x1F3FB}}},                                                                                                          // × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u0023\u0308\U0001F3FB", expected: [][]rune{{0x0023, 0x0308}, {0x1F3FB}}},                                                                                                          // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u0023\u0308\u0020\U0001F3FB", expected: [][]rune{{0x0023, 0x0308, 0x0020}, {0x1F3FB}}},                                                                                            // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u0023\u0029", expected: [][]rune{{0x0023, 0x0029}}},                                                                                                                               // × [0.3] NUMBER SIGN (AL) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u0023\u0020\u0029", expected: [][]rune{{0x0023, 0x0020, 0x0029}}},                                                                                                                 // × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u0023\u0308\u0029", expected: [][]rune{{0x0023, 0x0308, 0x0029}}},                                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u0023\u0308\u0020\u0029", expected: [][]rune{{0x0023, 0x0308, 0x0020, 0x0029}}},                                                                                                   // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u0023\u0028", expected: [][]rune{{0x0023, 0x0028}}},                                                                                                                               // × [0.3] NUMBER SIGN (AL) × [30.01] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u0023\u0020\u0028", expected: [][]rune{{0x0023, 0x0020}, {0x0028}}},                                                                                                               // × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u0023\u0308\u0028", expected: [][]rune{{0x0023, 0x0308, 0x0028}}},                                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [30.01] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u0023\u0308\u0020\u0028", expected: [][]rune{{0x0023, 0x0308, 0x0020}, {0x0028}}},                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u0023\u0001", expected: [][]rune{{0x0023, 0x0001}}},                                                                                                                               // × [0.3] NUMBER SIGN (AL) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u0023\u0020\u0001", expected: [][]rune{{0x0023, 0x0020}, {0x0001}}},                                                                                                               // × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u0023\u0308\u0001", expected: [][]rune{{0x0023, 0x0308, 0x0001}}},                                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u0023\u0308\u0020\u0001", expected: [][]rune{{0x0023, 0x0308, 0x0020}, {0x0001}}},                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u0023\u200D", expected: [][]rune{{0x0023, 0x200D}}},                                                                                                                               // × [0.3] NUMBER SIGN (AL) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u0023\u0020\u200D", expected: [][]rune{{0x0023, 0x0020}, {0x200D}}},                                                                                                               // × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u0023\u0308\u200D", expected: [][]rune{{0x0023, 0x0308, 0x200D}}},                                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u0023\u0308\u0020\u200D", expected: [][]rune{{0x0023, 0x0308, 0x0020}, {0x200D}}},                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u0023\u00A7", expected: [][]rune{{0x0023, 0x00A7}}},                                                                                                                               // × [0.3] NUMBER SIGN (AL) × [28.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u0023\u0020\u00A7", expected: [][]rune{{0x0023, 0x0020}, {0x00A7}}},                                                                                                               // × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u0023\u0308\u00A7", expected: [][]rune{{0x0023, 0x0308, 0x00A7}}},                                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [28.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u0023\u0308\u0020\u00A7", expected: [][]rune{{0x0023, 0x0308, 0x0020}, {0x00A7}}},                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u0023\U00050005", expected: [][]rune{{0x0023, 0x50005}}},                                                                                                                          // × [0.3] NUMBER SIGN (AL) × [28.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u0023\u0020\U00050005", expected: [][]rune{{0x0023, 0x0020}, {0x50005}}},                                                                                                          // × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u0023\u0308\U00050005", expected: [][]rune{{0x0023, 0x0308, 0x50005}}},                                                                                                            // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [28.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u0023\u0308\u0020\U00050005", expected: [][]rune{{0x0023, 0x0308, 0x0020}, {0x50005}}},                                                                                            // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u0023\u0E01", expected: [][]rune{{0x0023, 0x0E01}}},                                                                                                                               // × [0.3] NUMBER SIGN (AL) × [28.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u0023\u0020\u0E01", expected: [][]rune{{0x0023, 0x0020}, {0x0E01}}},                                                                                                               // × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u0023\u0308\u0E01", expected: [][]rune{{0x0023, 0x0308, 0x0E01}}},                                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [28.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u0023\u0308\u0020\u0E01", expected: [][]rune{{0x0023, 0x0308, 0x0020}, {0x0E01}}},                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u0023\u3041", expected: [][]rune{{0x0023, 0x3041}}},                                                                                                                               // × [0.3] NUMBER SIGN (AL) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u0023\u0020\u3041", expected: [][]rune{{0x0023, 0x0020}, {0x3041}}},                                                                                                               // × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u0023\u0308\u3041", expected: [][]rune{{0x0023, 0x0308, 0x3041}}},                                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u0023\u0308\u0020\u3041", expected: [][]rune{{0x0023, 0x0308, 0x0020}, {0x3041}}},                                                                                                 // × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u2014\u0023", expected: [][]rune{{0x2014}, {0x0023}}},                                                                                                                             // × [0.3] EM DASH (B2) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u2014\u0020\u0023", expected: [][]rune{{0x2014, 0x0020}, {0x0023}}},                                                                                                               // × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u2014\u0308\u0023", expected: [][]rune{{0x2014, 0x0308}, {0x0023}}},                                                                                                               // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u2014\u0308\u0020\u0023", expected: [][]rune{{0x2014, 0x0308, 0x0020}, {0x0023}}},                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u2014\u2014", expected: [][]rune{{0x2014, 0x2014}}},                                                                                                                               // × [0.3] EM DASH (B2) × [17.0] EM DASH (B2) ÷ [0.3]
	{original: "\u2014\u0020\u2014", expected: [][]rune{{0x2014, 0x0020, 0x2014}}},                                                                                                                 // × [0.3] EM DASH (B2) × [7.01] SPACE (SP) × [17.0] EM DASH (B2) ÷ [0.3]
	{original: "\u2014\u0308\u2014", expected: [][]rune{{0x2014, 0x0308, 0x2014}}},                                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [17.0] EM DASH (B2) ÷ [0.3]
	{original: "\u2014\u0308\u0020\u2014", expected: [][]rune{{0x2014, 0x0308, 0x0020, 0x2014}}},                                                                                                   // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [17.0] EM DASH (B2) ÷ [0.3]
	{original: "\u2014\u0009", expected: [][]rune{{0x2014, 0x0009}}},                                                                                                                               // × [0.3] EM DASH (B2) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u2014\u0020\u0009", expected: [][]rune{{0x2014, 0x0020}, {0x0009}}},                                                                                                               // × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u2014\u0308\u0009", expected: [][]rune{{0x2014, 0x0308, 0x0009}}},                                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u2014\u0308\u0020\u0009", expected: [][]rune{{0x2014, 0x0308, 0x0020}, {0x0009}}},                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u2014\u00B4", expected: [][]rune{{0x2014}, {0x00B4}}},                                                                                                                             // × [0.3] EM DASH (B2) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u2014\u0020\u00B4", expected: [][]rune{{0x2014, 0x0020}, {0x00B4}}},                                                                                                               // × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u2014\u0308\u00B4", expected: [][]rune{{0x2014, 0x0308}, {0x00B4}}},                                                                                                               // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u2014\u0308\u0020\u00B4", expected: [][]rune{{0x2014, 0x0308, 0x0020}, {0x00B4}}},                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u2014\u000B", expected: [][]rune{{0x2014, 0x000B}}},                                                                                                                               // × [0.3] EM DASH (B2) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u2014\u0020\u000B", expected: [][]rune{{0x2014, 0x0020, 0x000B}}},                                                                                                                 // × [0.3] EM DASH (B2) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u2014\u0308\u000B", expected: [][]rune{{0x2014, 0x0308, 0x000B}}},                                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u2014\u0308\u0020\u000B", expected: [][]rune{{0x2014, 0x0308, 0x0020, 0x000B}}},                                                                                                   // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u2014\uFFFC", expected: [][]rune{{0x2014}, {0xFFFC}}},                                                                                                                             // × [0.3] EM DASH (B2) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u2014\u0020\uFFFC", expected: [][]rune{{0x2014, 0x0020}, {0xFFFC}}},                                                                                                               // × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u2014\u0308\uFFFC", expected: [][]rune{{0x2014, 0x0308}, {0xFFFC}}},                                                                                                               // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u2014\u0308\u0020\uFFFC", expected: [][]rune{{0x2014, 0x0308, 0x0020}, {0xFFFC}}},                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u2014\u007D", expected: [][]rune{{0x2014, 0x007D}}},                                                                                                                               // × [0.3] EM DASH (B2) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u2014\u0020\u007D", expected: [][]rune{{0x2014, 0x0020, 0x007D}}},                                                                                                                 // × [0.3] EM DASH (B2) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u2014\u0308\u007D", expected: [][]rune{{0x2014, 0x0308, 0x007D}}},                                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u2014\u0308\u0020\u007D", expected: [][]rune{{0x2014, 0x0308, 0x0020, 0x007D}}},                                                                                                   // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u2014\u000D", expected: [][]rune{{0x2014, 0x000D}}},                                                                                                                               // × [0.3] EM DASH (B2) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u2014\u0020\u000D", expected: [][]rune{{0x2014, 0x0020, 0x000D}}},                                                                                                                 // × [0.3] EM DASH (B2) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u2014\u0308\u000D", expected: [][]rune{{0x2014, 0x0308, 0x000D}}},                                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u2014\u0308\u0020\u000D", expected: [][]rune{{0x2014, 0x0308, 0x0020, 0x000D}}},                                                                                                   // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u2014\u0021", expected: [][]rune{{0x2014, 0x0021}}},                                                                                                                               // × [0.3] EM DASH (B2) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u2014\u0020\u0021", expected: [][]rune{{0x2014, 0x0020, 0x0021}}},                                                                                                                 // × [0.3] EM DASH (B2) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u2014\u0308\u0021", expected: [][]rune{{0x2014, 0x0308, 0x0021}}},                                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u2014\u0308\u0020\u0021", expected: [][]rune{{0x2014, 0x0308, 0x0020, 0x0021}}},                                                                                                   // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u2014\u00A0", expected: [][]rune{{0x2014, 0x00A0}}},                                                                                                                               // × [0.3] EM DASH (B2) × [12.1] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u2014\u0020\u00A0", expected: [][]rune{{0x2014, 0x0020}, {0x00A0}}},                                                                                                               // × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u2014\u0308\u00A0", expected: [][]rune{{0x2014, 0x0308, 0x00A0}}},                                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u2014\u0308\u0020\u00A0", expected: [][]rune{{0x2014, 0x0308, 0x0020}, {0x00A0}}},                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u2014\uAC00", expected: [][]rune{{0x2014}, {0xAC00}}},                                                                                                                             // × [0.3] EM DASH (B2) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u2014\u0020\uAC00", expected: [][]rune{{0x2014, 0x0020}, {0xAC00}}},                                                                                                               // × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u2014\u0308\uAC00", expected: [][]rune{{0x2014, 0x0308}, {0xAC00}}},                                                                                                               // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u2014\u0308\u0020\uAC00", expected: [][]rune{{0x2014, 0x0308, 0x0020}, {0xAC00}}},                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u2014\uAC01", expected: [][]rune{{0x2014}, {0xAC01}}},                                                                                                                             // × [0.3] EM DASH (B2) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u2014\u0020\uAC01", expected: [][]rune{{0x2014, 0x0020}, {0xAC01}}},                                                                                                               // × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u2014\u0308\uAC01", expected: [][]rune{{0x2014, 0x0308}, {0xAC01}}},                                                                                                               // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u2014\u0308\u0020\uAC01", expected: [][]rune{{0x2014, 0x0308, 0x0020}, {0xAC01}}},                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u2014\u05D0", expected: [][]rune{{0x2014}, {0x05D0}}},                                                                                                                             // × [0.3] EM DASH (B2) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u2014\u0020\u05D0", expected: [][]rune{{0x2014, 0x0020}, {0x05D0}}},                                                                                                               // × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u2014\u0308\u05D0", expected: [][]rune{{0x2014, 0x0308}, {0x05D0}}},                                                                                                               // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u2014\u0308\u0020\u05D0", expected: [][]rune{{0x2014, 0x0308, 0x0020}, {0x05D0}}},                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u2014\u002D", expected: [][]rune{{0x2014, 0x002D}}},                                                                                                                               // × [0.3] EM DASH (B2) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u2014\u0020\u002D", expected: [][]rune{{0x2014, 0x0020}, {0x002D}}},                                                                                                               // × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u2014\u0308\u002D", expected: [][]rune{{0x2014, 0x0308, 0x002D}}},                                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u2014\u0308\u0020\u002D", expected: [][]rune{{0x2014, 0x0308, 0x0020}, {0x002D}}},                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u2014\u231A", expected: [][]rune{{0x2014}, {0x231A}}},                                                                                                                             // × [0.3] EM DASH (B2) ÷ [999.0] WATCH (ID) ÷ [0.3]
	{original: "\u2014\u0020\u231A", expected: [][]rune{{0x2014, 0x0020}, {0x231A}}},                                                                                                               // × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
	{original: "\u2014\u0308\u231A", expected: [][]rune{{0x2014, 0x0308}, {0x231A}}},                                                                                                               // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
	{original: "\u2014\u0308\u0020\u231A", expected: [][]rune{{0x2014, 0x0308, 0x0020}, {0x231A}}},                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
	{original: "\u2014\u2024", expected: [][]rune{{0x2014, 0x2024}}},                                                                                                                               // × [0.3] EM DASH (B2) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u2014\u0020\u2024", expected: [][]rune{{0x2014, 0x0020}, {0x2024}}},                                                                                                               // × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u2014\u0308\u2024", expected: [][]rune{{0x2014, 0x0308, 0x2024}}},                                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u2014\u0308\u0020\u2024", expected: [][]rune{{0x2014, 0x0308, 0x0020}, {0x2024}}},                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u2014\u002C", expected: [][]rune{{0x2014, 0x002C}}},                                                                                                                               // × [0.3] EM DASH (B2) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u2014\u0020\u002C", expected: [][]rune{{0x2014, 0x0020, 0x002C}}},                                                                                                                 // × [0.3] EM DASH (B2) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u2014\u0308\u002C", expected: [][]rune{{0x2014, 0x0308, 0x002C}}},                                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
	{original: "\u2014\u0308\u0020\u002C", expected: [][]rune{{0x2014, 0x0308, 0x0020, 0x002C}}},                                                                                                   // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u2014\u1100", expected: [][]rune{{0x2014}, {0x1100}}},                                                                                                                             // × [0.3] EM DASH (B2) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u2014\u0020\u1100", expected: [][]rune{{0x2014, 0x0020}, {0x1100}}},                                                                                                               // × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u2014\u0308\u1100", expected: [][]rune{{0x2014, 0x0308}, {0x1100}}},                                                                                                               // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u2014\u0308\u0020\u1100", expected: [][]rune{{0x2014, 0x0308, 0x0020}, {0x1100}}},                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u2014\u11A8", expected: [][]rune{{0x2014}, {0x11A8}}},                                                                                                                             // × [0.3] EM DASH (B2) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u2014\u0020\u11A8", expected: [][]rune{{0x2014, 0x0020}, {0x11A8}}},                                                                                                               // × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u2014\u0308\u11A8", expected: [][]rune{{0x2014, 0x0308}, {0x11A8}}},                                                                                                               // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u2014\u0308\u0020\u11A8", expected: [][]rune{{0x2014, 0x0308, 0x0020}, {0x11A8}}},                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u2014\u1160", expected: [][]rune{{0x2014}, {0x1160}}},                                                                                                                             // × [0.3] EM DASH (B2) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u2014\u0020\u1160", expected: [][]rune{{0x2014, 0x0020}, {0x1160}}},                                                                                                               // × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u2014\u0308\u1160", expected: [][]rune{{0x2014, 0x0308}, {0x1160}}},                                                                                                               // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u2014\u0308\u0020\u1160", expected: [][]rune{{0x2014, 0x0308, 0x0020}, {0x1160}}},                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u2014\u000A", expected: [][]rune{{0x2014, 0x000A}}},                                                                                                                               // × [0.3] EM DASH (B2) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u2014\u0020\u000A", expected: [][]rune{{0x2014, 0x0020, 0x000A}}},                                                                                                                 // × [0.3] EM DASH (B2) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u2014\u0308\u000A", expected: [][]rune{{0x2014, 0x0308, 0x000A}}},                                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u2014\u0308\u0020\u000A", expected: [][]rune{{0x2014, 0x0308, 0x0020, 0x000A}}},                                                                                                   // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u2014\u0085", expected: [][]rune{{0x2014, 0x0085}}},                                                                                                                               // × [0.3] EM DASH (B2) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u2014\u0020\u0085", expected: [][]rune{{0x2014, 0x0020, 0x0085}}},                                                                                                                 // × [0.3] EM DASH (B2) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u2014\u0308\u0085", expected: [][]rune{{0x2014, 0x0308, 0x0085}}},                                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u2014\u0308\u0020\u0085", expected: [][]rune{{0x2014, 0x0308, 0x0020, 0x0085}}},                                                                                                   // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u2014\u17D6", expected: [][]rune{{0x2014, 0x17D6}}},                                                                                                                               // × [0.3] EM DASH (B2) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u2014\u0020\u17D6", expected: [][]rune{{0x2014, 0x0020}, {0x17D6}}},                                                                                                               // × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u2014\u0308\u17D6", expected: [][]rune{{0x2014, 0x0308, 0x17D6}}},                                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u2014\u0308\u0020\u17D6", expected: [][]rune{{0x2014, 0x0308, 0x0020}, {0x17D6}}},                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u2014\u0030", expected: [][]rune{{0x2014}, {0x0030}}},                                                                                                                             // × [0.3] EM DASH (B2) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u2014\u0020\u0030", expected: [][]rune{{0x2014, 0x0020}, {0x0030}}},                                                                                                               // × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u2014\u0308\u0030", expected: [][]rune{{0x2014, 0x0308}, {0x0030}}},                                                                                                               // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u2014\u0308\u0020\u0030", expected: [][]rune{{0x2014, 0x0308, 0x0020}, {0x0030}}},                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u2014\u2329", expected: [][]rune{{0x2014}, {0x2329}}},                                                                                                                             // × [0.3] EM DASH (B2) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u2014\u0020\u2329", expected: [][]rune{{0x2014, 0x0020}, {0x2329}}},                                                                                                               // × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u2014\u0308\u2329", expected: [][]rune{{0x2014, 0x0308}, {0x2329}}},                                                                                                               // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u2014\u0308\u0020\u2329", expected: [][]rune{{0x2014, 0x0308, 0x0020}, {0x2329}}},                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u2014\u0025", expected: [][]rune{{0x2014}, {0x0025}}},                                                                                                                             // × [0.3] EM DASH (B2) ÷ [999.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u2014\u0020\u0025", expected: [][]rune{{0x2014, 0x0020}, {0x0025}}},                                                                                                               // × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u2014\u0308\u0025", expected: [][]rune{{0x2014, 0x0308}, {0x0025}}},                                                                                                               // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u2014\u0308\u0020\u0025", expected: [][]rune{{0x2014, 0x0308, 0x0020}, {0x0025}}},                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u2014\u0024", expected: [][]rune{{0x2014}, {0x0024}}},                                                                                                                             // × [0.3] EM DASH (B2) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u2014\u0020\u0024", expected: [][]rune{{0x2014, 0x0020}, {0x0024}}},                                                                                                               // × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u2014\u0308\u0024", expected: [][]rune{{0x2014, 0x0308}, {0x0024}}},                                                                                                               // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u2014\u0308\u0020\u0024", expected: [][]rune{{0x2014, 0x0308, 0x0020}, {0x0024}}},                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u2014\u0022", expected: [][]rune{{0x2014, 0x0022}}},                                                                                                                               // × [0.3] EM DASH (B2) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u2014\u0020\u0022", expected: [][]rune{{0x2014, 0x0020}, {0x0022}}},                                                                                                               // × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u2014\u0308\u0022", expected: [][]rune{{0x2014, 0x0308, 0x0022}}},                                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u2014\u0308\u0020\u0022", expected: [][]rune{{0x2014, 0x0308, 0x0020}, {0x0022}}},                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u2014\u0020", expected: [][]rune{{0x2014, 0x0020}}},                                                                                                                               // × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u2014\u0020\u0020", expected: [][]rune{{0x2014, 0x0020, 0x0020}}},                                                                                                                 // × [0.3] EM DASH (B2) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u2014\u0308\u0020", expected: [][]rune{{0x2014, 0x0308, 0x0020}}},                                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u2014\u0308\u0020\u0020", expected: [][]rune{{0x2014, 0x0308, 0x0020, 0x0020}}},                                                                                                   // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u2014\u002F", expected: [][]rune{{0x2014, 0x002F}}},                                                                                                                               // × [0.3] EM DASH (B2) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\u2014\u0020\u002F", expected: [][]rune{{0x2014, 0x0020, 0x002F}}},                                                                                                                 // × [0.3] EM DASH (B2) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\u2014\u0308\u002F", expected: [][]rune{{0x2014, 0x0308, 0x002F}}},                                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
	{original: "\u2014\u0308\u0020\u002F", expected: [][]rune{{0x2014, 0x0308, 0x0020, 0x002F}}},                                                                                                   // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\u2014\u2060", expected: [][]rune{{0x2014, 0x2060}}},                                                                                                                               // × [0.3] EM DASH (B2) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u2014\u0020\u2060", expected: [][]rune{{0x2014, 0x0020, 0x2060}}},                                                                                                                 // × [0.3] EM DASH (B2) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u2014\u0308\u2060", expected: [][]rune{{0x2014, 0x0308, 0x2060}}},                                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u2014\u0308\u0020\u2060", expected: [][]rune{{0x2014, 0x0308, 0x0020, 0x2060}}},                                                                                                   // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u2014\u200B", expected: [][]rune{{0x2014, 0x200B}}},                                                                                                                               // × [0.3] EM DASH (B2) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u2014\u0020\u200B", expected: [][]rune{{0x2014, 0x0020, 0x200B}}},                                                                                                                 // × [0.3] EM DASH (B2) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u2014\u0308\u200B", expected: [][]rune{{0x2014, 0x0308, 0x200B}}},                                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u2014\u0308\u0020\u200B", expected: [][]rune{{0x2014, 0x0308, 0x0020, 0x200B}}},                                                                                                   // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u2014\U0001F1E6", expected: [][]rune{{0x2014}, {0x1F1E6}}},                                                                                                                        // × [0.3] EM DASH (B2) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u2014\u0020\U0001F1E6", expected: [][]rune{{0x2014, 0x0020}, {0x1F1E6}}},                                                                                                          // × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u2014\u0308\U0001F1E6", expected: [][]rune{{0x2014, 0x0308}, {0x1F1E6}}},                                                                                                          // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u2014\u0308\u0020\U0001F1E6", expected: [][]rune{{0x2014, 0x0308, 0x0020}, {0x1F1E6}}},                                                                                            // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u2014\u261D", expected: [][]rune{{0x2014}, {0x261D}}},                                                                                                                             // × [0.3] EM DASH (B2) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u2014\u0020\u261D", expected: [][]rune{{0x2014, 0x0020}, {0x261D}}},                                                                                                               // × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u2014\u0308\u261D", expected: [][]rune{{0x2014, 0x0308}, {0x261D}}},                                                                                                               // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u2014\u0308\u0020\u261D", expected: [][]rune{{0x2014, 0x0308, 0x0020}, {0x261D}}},                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u2014\U0001F3FB", expected: [][]rune{{0x2014}, {0x1F3FB}}},                                                                                                                        // × [0.3] EM DASH (B2) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u2014\u0020\U0001F3FB", expected: [][]rune{{0x2014, 0x0020}, {0x1F3FB}}},                                                                                                          // × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u2014\u0308\U0001F3FB", expected: [][]rune{{0x2014, 0x0308}, {0x1F3FB}}},                                                                                                          // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u2014\u0308\u0020\U0001F3FB", expected: [][]rune{{0x2014, 0x0308, 0x0020}, {0x1F3FB}}},                                                                                            // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u2014\u0029", expected: [][]rune{{0x2014, 0x0029}}},                                                                                                                               // × [0.3] EM DASH (B2) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u2014\u0020\u0029", expected: [][]rune{{0x2014, 0x0020, 0x0029}}},                                                                                                                 // × [0.3] EM DASH (B2) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u2014\u0308\u0029", expected: [][]rune{{0x2014, 0x0308, 0x0029}}},                                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u2014\u0308\u0020\u0029", expected: [][]rune{{0x2014, 0x0308, 0x0020, 0x0029}}},                                                                                                   // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u2014\u0028", expected: [][]rune{{0x2014}, {0x0028}}},                                                                                                                             // × [0.3] EM DASH (B2) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u2014\u0020\u0028", expected: [][]rune{{0x2014, 0x0020}, {0x0028}}},                                                                                                               // × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u2014\u0308\u0028", expected: [][]rune{{0x2014, 0x0308}, {0x0028}}},                                                                                                               // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u2014\u0308\u0020\u0028", expected: [][]rune{{0x2014, 0x0308, 0x0020}, {0x0028}}},                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u2014\u0001", expected: [][]rune{{0x2014, 0x0001}}},                                                                                                                               // × [0.3] EM DASH (B2) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u2014\u0020\u0001", expected: [][]rune{{0x2014, 0x0020}, {0x0001}}},                                                                                                               // × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u2014\u0308\u0001", expected: [][]rune{{0x2014, 0x0308, 0x0001}}},                                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u2014\u0308\u0020\u0001", expected: [][]rune{{0x2014, 0x0308, 0x0020}, {0x0001}}},                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u2014\u200D", expected: [][]rune{{0x2014, 0x200D}}},                                                                                                                               // × [0.3] EM DASH (B2) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u2014\u0020\u200D", expected: [][]rune{{0x2014, 0x0020}, {0x200D}}},                                                                                                               // × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u2014\u0308\u200D", expected: [][]rune{{0x2014, 0x0308, 0x200D}}},                                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u2014\u0308\u0020\u200D", expected: [][]rune{{0x2014, 0x0308, 0x0020}, {0x200D}}},                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u2014\u00A7", expected: [][]rune{{0x2014}, {0x00A7}}},                                                                                                                             // × [0.3] EM DASH (B2) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u2014\u0020\u00A7", expected: [][]rune{{0x2014, 0x0020}, {0x00A7}}},                                                                                                               // × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u2014\u0308\u00A7", expected: [][]rune{{0x2014, 0x0308}, {0x00A7}}},                                                                                                               // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u2014\u0308\u0020\u00A7", expected: [][]rune{{0x2014, 0x0308, 0x0020}, {0x00A7}}},                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u2014\U00050005", expected: [][]rune{{0x2014}, {0x50005}}},                                                                                                                        // × [0.3] EM DASH (B2) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u2014\u0020\U00050005", expected: [][]rune{{0x2014, 0x0020}, {0x50005}}},                                                                                                          // × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u2014\u0308\U00050005", expected: [][]rune{{0x2014, 0x0308}, {0x50005}}},                                                                                                          // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u2014\u0308\u0020\U00050005", expected: [][]rune{{0x2014, 0x0308, 0x0020}, {0x50005}}},                                                                                            // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u2014\u0E01", expected: [][]rune{{0x2014}, {0x0E01}}},                                                                                                                             // × [0.3] EM DASH (B2) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u2014\u0020\u0E01", expected: [][]rune{{0x2014, 0x0020}, {0x0E01}}},                                                                                                               // × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u2014\u0308\u0E01", expected: [][]rune{{0x2014, 0x0308}, {0x0E01}}},                                                                                                               // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u2014\u0308\u0020\u0E01", expected: [][]rune{{0x2014, 0x0308, 0x0020}, {0x0E01}}},                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u2014\u3041", expected: [][]rune{{0x2014, 0x3041}}},                                                                                                                               // × [0.3] EM DASH (B2) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u2014\u0020\u3041", expected: [][]rune{{0x2014, 0x0020}, {0x3041}}},                                                                                                               // × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u2014\u0308\u3041", expected: [][]rune{{0x2014, 0x0308, 0x3041}}},                                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u2014\u0308\u0020\u3041", expected: [][]rune{{0x2014, 0x0308, 0x0020}, {0x3041}}},                                                                                                 // × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u0009\u0023", expected: [][]rune{{0x0009}, {0x0023}}},                                                                                                                             // × [0.3] <CHARACTER TABULATION> (BA) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u0009\u0020\u0023", expected: [][]rune{{0x0009, 0x0020}, {0x0023}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u0009\u0308\u0023", expected: [][]rune{{0x0009, 0x0308}, {0x0023}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u0009\u0308\u0020\u0023", expected: [][]rune{{0x0009, 0x0308, 0x0020}, {0x0023}}},                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u0009\u2014", expected: [][]rune{{0x0009}, {0x2014}}},                                                                                                                             // × [0.3] <CHARACTER TABULATION> (BA) ÷ [999.0] EM DASH (B2) ÷ [0.3]
	{original: "\u0009\u0020\u2014", expected: [][]rune{{0x0009, 0x0020}, {0x2014}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
	{original: "\u0009\u0308\u2014", expected: [][]rune{{0x0009, 0x0308}, {0x2014}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
	{original: "\u0009\u0308\u0020\u2014", expected: [][]rune{{0x0009, 0x0308, 0x0020}, {0x2014}}},                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
	{original: "\u0009\u0009", expected: [][]rune{{0x0009, 0x0009}}},                                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u0009\u0020\u0009", expected: [][]rune{{0x0009, 0x0020}, {0x0009}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u0009\u0308\u0009", expected: [][]rune{{0x0009, 0x0308, 0x0009}}},                                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u0009\u0308\u0020\u0009", expected: [][]rune{{0x0009, 0x0308, 0x0020}, {0x0009}}},                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u0009\u00B4", expected: [][]rune{{0x0009}, {0x00B4}}},                                                                                                                             // × [0.3] <CHARACTER TABULATION> (BA) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u0009\u0020\u00B4", expected: [][]rune{{0x0009, 0x0020}, {0x00B4}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u0009\u0308\u00B4", expected: [][]rune{{0x0009, 0x0308}, {0x00B4}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u0009\u0308\u0020\u00B4", expected: [][]rune{{0x0009, 0x0308, 0x0020}, {0x00B4}}},                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u0009\u000B", expected: [][]rune{{0x0009, 0x000B}}},                                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u0009\u0020\u000B", expected: [][]rune{{0x0009, 0x0020, 0x000B}}},                                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u0009\u0308\u000B", expected: [][]rune{{0x0009, 0x0308, 0x000B}}},                                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u0009\u0308\u0020\u000B", expected: [][]rune{{0x0009, 0x0308, 0x0020, 0x000B}}},                                                                                                   // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u0009\uFFFC", expected: [][]rune{{0x0009}, {0xFFFC}}},                                                                                                                             // × [0.3] <CHARACTER TABULATION> (BA) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u0009\u0020\uFFFC", expected: [][]rune{{0x0009, 0x0020}, {0xFFFC}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u0009\u0308\uFFFC", expected: [][]rune{{0x0009, 0x0308}, {0xFFFC}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u0009\u0308\u0020\uFFFC", expected: [][]rune{{0x0009, 0x0308, 0x0020}, {0xFFFC}}},                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u0009\u007D", expected: [][]rune{{0x0009, 0x007D}}},                                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u0009\u0020\u007D", expected: [][]rune{{0x0009, 0x0020, 0x007D}}},                                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u0009\u0308\u007D", expected: [][]rune{{0x0009, 0x0308, 0x007D}}},                                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u0009\u0308\u0020\u007D", expected: [][]rune{{0x0009, 0x0308, 0x0020, 0x007D}}},                                                                                                   // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u0009\u000D", expected: [][]rune{{0x0009, 0x000D}}},                                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0009\u0020\u000D", expected: [][]rune{{0x0009, 0x0020, 0x000D}}},                                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0009\u0308\u000D", expected: [][]rune{{0x0009, 0x0308, 0x000D}}},                                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0009\u0308\u0020\u000D", expected: [][]rune{{0x0009, 0x0308, 0x0020, 0x000D}}},                                                                                                   // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0009\u0021", expected: [][]rune{{0x0009, 0x0021}}},                                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u0009\u0020\u0021", expected: [][]rune{{0x0009, 0x0020, 0x0021}}},                                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u0009\u0308\u0021", expected: [][]rune{{0x0009, 0x0308, 0x0021}}},                                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u0009\u0308\u0020\u0021", expected: [][]rune{{0x0009, 0x0308, 0x0020, 0x0021}}},                                                                                                   // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u0009\u00A0", expected: [][]rune{{0x0009}, {0x00A0}}},                                                                                                                             // × [0.3] <CHARACTER TABULATION> (BA) ÷ [999.0] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u0009\u0020\u00A0", expected: [][]rune{{0x0009, 0x0020}, {0x00A0}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u0009\u0308\u00A0", expected: [][]rune{{0x0009, 0x0308}, {0x00A0}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u0009\u0308\u0020\u00A0", expected: [][]rune{{0x0009, 0x0308, 0x0020}, {0x00A0}}},                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u0009\uAC00", expected: [][]rune{{0x0009}, {0xAC00}}},                                                                                                                             // × [0.3] <CHARACTER TABULATION> (BA) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u0009\u0020\uAC00", expected: [][]rune{{0x0009, 0x0020}, {0xAC00}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u0009\u0308\uAC00", expected: [][]rune{{0x0009, 0x0308}, {0xAC00}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u0009\u0308\u0020\uAC00", expected: [][]rune{{0x0009, 0x0308, 0x0020}, {0xAC00}}},                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u0009\uAC01", expected: [][]rune{{0x0009}, {0xAC01}}},                                                                                                                             // × [0.3] <CHARACTER TABULATION> (BA) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u0009\u0020\uAC01", expected: [][]rune{{0x0009, 0x0020}, {0xAC01}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u0009\u0308\uAC01", expected: [][]rune{{0x0009, 0x0308}, {0xAC01}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u0009\u0308\u0020\uAC01", expected: [][]rune{{0x0009, 0x0308, 0x0020}, {0xAC01}}},                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u0009\u05D0", expected: [][]rune{{0x0009}, {0x05D0}}},                                                                                                                             // × [0.3] <CHARACTER TABULATION> (BA) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u0009\u0020\u05D0", expected: [][]rune{{0x0009, 0x0020}, {0x05D0}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u0009\u0308\u05D0", expected: [][]rune{{0x0009, 0x0308}, {0x05D0}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u0009\u0308\u0020\u05D0", expected: [][]rune{{0x0009, 0x0308, 0x0020}, {0x05D0}}},                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u0009\u002D", expected: [][]rune{{0x0009, 0x002D}}},                                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u0009\u0020\u002D", expected: [][]rune{{0x0009, 0x0020}, {0x002D}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u0009\u0308\u002D", expected: [][]rune{{0x0009, 0x0308, 0x002D}}},                                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u0009\u0308\u0020\u002D", expected: [][]rune{{0x0009, 0x0308, 0x0020}, {0x002D}}},                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u0009\u231A", expected: [][]rune{{0x0009}, {0x231A}}},                                                                                                                             // × [0.3] <CHARACTER TABULATION> (BA) ÷ [999.0] WATCH (ID) ÷ [0.3]
	{original: "\u0009\u0020\u231A", expected: [][]rune{{0x0009, 0x0020}, {0x231A}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
	{original: "\u0009\u0308\u231A", expected: [][]rune{{0x0009, 0x0308}, {0x231A}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
	{original: "\u0009\u0308\u0020\u231A", expected: [][]rune{{0x0009, 0x0308, 0x0020}, {0x231A}}},                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
	{original: "\u0009\u2024", expected: [][]rune{{0x0009, 0x2024}}},                                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u0009\u0020\u2024", expected: [][]rune{{0x0009, 0x0020}, {0x2024}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u0009\u0308\u2024", expected: [][]rune{{0x0009, 0x0308, 0x2024}}},                                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u0009\u0308\u0020\u2024", expected: [][]rune{{0x0009, 0x0308, 0x0020}, {0x2024}}},                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u0009\u002C", expected: [][]rune{{0x0009, 0x002C}}},                                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u0009\u0020\u002C", expected: [][]rune{{0x0009, 0x0020, 0x002C}}},                                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u0009\u0308\u002C", expected: [][]rune{{0x0009, 0x0308, 0x002C}}},                                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
	{original: "\u0009\u0308\u0020\u002C", expected: [][]rune{{0x0009, 0x0308, 0x0020, 0x002C}}},                                                                                                   // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u0009\u1100", expected: [][]rune{{0x0009}, {0x1100}}},                                                                                                                             // × [0.3] <CHARACTER TABULATION> (BA) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u0009\u0020\u1100", expected: [][]rune{{0x0009, 0x0020}, {0x1100}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u0009\u0308\u1100", expected: [][]rune{{0x0009, 0x0308}, {0x1100}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u0009\u0308\u0020\u1100", expected: [][]rune{{0x0009, 0x0308, 0x0020}, {0x1100}}},                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u0009\u11A8", expected: [][]rune{{0x0009}, {0x11A8}}},                                                                                                                             // × [0.3] <CHARACTER TABULATION> (BA) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u0009\u0020\u11A8", expected: [][]rune{{0x0009, 0x0020}, {0x11A8}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u0009\u0308\u11A8", expected: [][]rune{{0x0009, 0x0308}, {0x11A8}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u0009\u0308\u0020\u11A8", expected: [][]rune{{0x0009, 0x0308, 0x0020}, {0x11A8}}},                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u0009\u1160", expected: [][]rune{{0x0009}, {0x1160}}},                                                                                                                             // × [0.3] <CHARACTER TABULATION> (BA) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u0009\u0020\u1160", expected: [][]rune{{0x0009, 0x0020}, {0x1160}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u0009\u0308\u1160", expected: [][]rune{{0x0009, 0x0308}, {0x1160}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u0009\u0308\u0020\u1160", expected: [][]rune{{0x0009, 0x0308, 0x0020}, {0x1160}}},                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u0009\u000A", expected: [][]rune{{0x0009, 0x000A}}},                                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0009\u0020\u000A", expected: [][]rune{{0x0009, 0x0020, 0x000A}}},                                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0009\u0308\u000A", expected: [][]rune{{0x0009, 0x0308, 0x000A}}},                                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0009\u0308\u0020\u000A", expected: [][]rune{{0x0009, 0x0308, 0x0020, 0x000A}}},                                                                                                   // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0009\u0085", expected: [][]rune{{0x0009, 0x0085}}},                                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u0009\u0020\u0085", expected: [][]rune{{0x0009, 0x0020, 0x0085}}},                                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u0009\u0308\u0085", expected: [][]rune{{0x0009, 0x0308, 0x0085}}},                                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u0009\u0308\u0020\u0085", expected: [][]rune{{0x0009, 0x0308, 0x0020, 0x0085}}},                                                                                                   // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u0009\u17D6", expected: [][]rune{{0x0009, 0x17D6}}},                                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u0009\u0020\u17D6", expected: [][]rune{{0x0009, 0x0020}, {0x17D6}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u0009\u0308\u17D6", expected: [][]rune{{0x0009, 0x0308, 0x17D6}}},                                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u0009\u0308\u0020\u17D6", expected: [][]rune{{0x0009, 0x0308, 0x0020}, {0x17D6}}},                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u0009\u0030", expected: [][]rune{{0x0009}, {0x0030}}},                                                                                                                             // × [0.3] <CHARACTER TABULATION> (BA) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u0009\u0020\u0030", expected: [][]rune{{0x0009, 0x0020}, {0x0030}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u0009\u0308\u0030", expected: [][]rune{{0x0009, 0x0308}, {0x0030}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u0009\u0308\u0020\u0030", expected: [][]rune{{0x0009, 0x0308, 0x0020}, {0x0030}}},                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u0009\u2329", expected: [][]rune{{0x0009}, {0x2329}}},                                                                                                                             // × [0.3] <CHARACTER TABULATION> (BA) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u0009\u0020\u2329", expected: [][]rune{{0x0009, 0x0020}, {0x2329}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u0009\u0308\u2329", expected: [][]rune{{0x0009, 0x0308}, {0x2329}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u0009\u0308\u0020\u2329", expected: [][]rune{{0x0009, 0x0308, 0x0020}, {0x2329}}},                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u0009\u0025", expected: [][]rune{{0x0009}, {0x0025}}},                                                                                                                             // × [0.3] <CHARACTER TABULATION> (BA) ÷ [999.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u0009\u0020\u0025", expected: [][]rune{{0x0009, 0x0020}, {0x0025}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u0009\u0308\u0025", expected: [][]rune{{0x0009, 0x0308}, {0x0025}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u0009\u0308\u0020\u0025", expected: [][]rune{{0x0009, 0x0308, 0x0020}, {0x0025}}},                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u0009\u0024", expected: [][]rune{{0x0009}, {0x0024}}},                                                                                                                             // × [0.3] <CHARACTER TABULATION> (BA) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u0009\u0020\u0024", expected: [][]rune{{0x0009, 0x0020}, {0x0024}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u0009\u0308\u0024", expected: [][]rune{{0x0009, 0x0308}, {0x0024}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u0009\u0308\u0020\u0024", expected: [][]rune{{0x0009, 0x0308, 0x0020}, {0x0024}}},                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u0009\u0022", expected: [][]rune{{0x0009, 0x0022}}},                                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u0009\u0020\u0022", expected: [][]rune{{0x0009, 0x0020}, {0x0022}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u0009\u0308\u0022", expected: [][]rune{{0x0009, 0x0308, 0x0022}}},                                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u0009\u0308\u0020\u0022", expected: [][]rune{{0x0009, 0x0308, 0x0020}, {0x0022}}},                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u0009\u0020", expected: [][]rune{{0x0009, 0x0020}}},                                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u0009\u0020\u0020", expected: [][]rune{{0x0009, 0x0020, 0x0020}}},                                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u0009\u0308\u0020", expected: [][]rune{{0x0009, 0x0308, 0x0020}}},                                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u0009\u0308\u0020\u0020", expected: [][]rune{{0x0009, 0x0308, 0x0020, 0x0020}}},                                                                                                   // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u0009\u002F", expected: [][]rune{{0x0009, 0x002F}}},                                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\u0009\u0020\u002F", expected: [][]rune{{0x0009, 0x0020, 0x002F}}},                                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\u0009\u0308\u002F", expected: [][]rune{{0x0009, 0x0308, 0x002F}}},                                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
	{original: "\u0009\u0308\u0020\u002F", expected: [][]rune{{0x0009, 0x0308, 0x0020, 0x002F}}},                                                                                                   // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\u0009\u2060", expected: [][]rune{{0x0009, 0x2060}}},                                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u0009\u0020\u2060", expected: [][]rune{{0x0009, 0x0020, 0x2060}}},                                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u0009\u0308\u2060", expected: [][]rune{{0x0009, 0x0308, 0x2060}}},                                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u0009\u0308\u0020\u2060", expected: [][]rune{{0x0009, 0x0308, 0x0020, 0x2060}}},                                                                                                   // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u0009\u200B", expected: [][]rune{{0x0009, 0x200B}}},                                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u0009\u0020\u200B", expected: [][]rune{{0x0009, 0x0020, 0x200B}}},                                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u0009\u0308\u200B", expected: [][]rune{{0x0009, 0x0308, 0x200B}}},                                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u0009\u0308\u0020\u200B", expected: [][]rune{{0x0009, 0x0308, 0x0020, 0x200B}}},                                                                                                   // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u0009\U0001F1E6", expected: [][]rune{{0x0009}, {0x1F1E6}}},                                                                                                                        // × [0.3] <CHARACTER TABULATION> (BA) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0009\u0020\U0001F1E6", expected: [][]rune{{0x0009, 0x0020}, {0x1F1E6}}},                                                                                                          // × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0009\u0308\U0001F1E6", expected: [][]rune{{0x0009, 0x0308}, {0x1F1E6}}},                                                                                                          // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0009\u0308\u0020\U0001F1E6", expected: [][]rune{{0x0009, 0x0308, 0x0020}, {0x1F1E6}}},                                                                                            // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0009\u261D", expected: [][]rune{{0x0009}, {0x261D}}},                                                                                                                             // × [0.3] <CHARACTER TABULATION> (BA) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u0009\u0020\u261D", expected: [][]rune{{0x0009, 0x0020}, {0x261D}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u0009\u0308\u261D", expected: [][]rune{{0x0009, 0x0308}, {0x261D}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u0009\u0308\u0020\u261D", expected: [][]rune{{0x0009, 0x0308, 0x0020}, {0x261D}}},                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u0009\U0001F3FB", expected: [][]rune{{0x0009}, {0x1F3FB}}},                                                                                                                        // × [0.3] <CHARACTER TABULATION> (BA) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u0009\u0020\U0001F3FB", expected: [][]rune{{0x0009, 0x0020}, {0x1F3FB}}},                                                                                                          // × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u0009\u0308\U0001F3FB", expected: [][]rune{{0x0009, 0x0308}, {0x1F3FB}}},                                                                                                          // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u0009\u0308\u0020\U0001F3FB", expected: [][]rune{{0x0009, 0x0308, 0x0020}, {0x1F3FB}}},                                                                                            // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u0009\u0029", expected: [][]rune{{0x0009, 0x0029}}},                                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u0009\u0020\u0029", expected: [][]rune{{0x0009, 0x0020, 0x0029}}},                                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u0009\u0308\u0029", expected: [][]rune{{0x0009, 0x0308, 0x0029}}},                                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u0009\u0308\u0020\u0029", expected: [][]rune{{0x0009, 0x0308, 0x0020, 0x0029}}},                                                                                                   // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u0009\u0028", expected: [][]rune{{0x0009}, {0x0028}}},                                                                                                                             // × [0.3] <CHARACTER TABULATION> (BA) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u0009\u0020\u0028", expected: [][]rune{{0x0009, 0x0020}, {0x0028}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u0009\u0308\u0028", expected: [][]rune{{0x0009, 0x0308}, {0x0028}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u0009\u0308\u0020\u0028", expected: [][]rune{{0x0009, 0x0308, 0x0020}, {0x0028}}},                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u0009\u0001", expected: [][]rune{{0x0009, 0x0001}}},                                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u0009\u0020\u0001", expected: [][]rune{{0x0009, 0x0020}, {0x0001}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u0009\u0308\u0001", expected: [][]rune{{0x0009, 0x0308, 0x0001}}},                                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u0009\u0308\u0020\u0001", expected: [][]rune{{0x0009, 0x0308, 0x0020}, {0x0001}}},                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u0009\u200D", expected: [][]rune{{0x0009, 0x200D}}},                                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u0009\u0020\u200D", expected: [][]rune{{0x0009, 0x0020}, {0x200D}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u0009\u0308\u200D", expected: [][]rune{{0x0009, 0x0308, 0x200D}}},                                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u0009\u0308\u0020\u200D", expected: [][]rune{{0x0009, 0x0308, 0x0020}, {0x200D}}},                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u0009\u00A7", expected: [][]rune{{0x0009}, {0x00A7}}},                                                                                                                             // × [0.3] <CHARACTER TABULATION> (BA) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u0009\u0020\u00A7", expected: [][]rune{{0x0009, 0x0020}, {0x00A7}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u0009\u0308\u00A7", expected: [][]rune{{0x0009, 0x0308}, {0x00A7}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u0009\u0308\u0020\u00A7", expected: [][]rune{{0x0009, 0x0308, 0x0020}, {0x00A7}}},                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u0009\U00050005", expected: [][]rune{{0x0009}, {0x50005}}},                                                                                                                        // × [0.3] <CHARACTER TABULATION> (BA) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u0009\u0020\U00050005", expected: [][]rune{{0x0009, 0x0020}, {0x50005}}},                                                                                                          // × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u0009\u0308\U00050005", expected: [][]rune{{0x0009, 0x0308}, {0x50005}}},                                                                                                          // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u0009\u0308\u0020\U00050005", expected: [][]rune{{0x0009, 0x0308, 0x0020}, {0x50005}}},                                                                                            // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u0009\u0E01", expected: [][]rune{{0x0009}, {0x0E01}}},                                                                                                                             // × [0.3] <CHARACTER TABULATION> (BA) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u0009\u0020\u0E01", expected: [][]rune{{0x0009, 0x0020}, {0x0E01}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u0009\u0308\u0E01", expected: [][]rune{{0x0009, 0x0308}, {0x0E01}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u0009\u0308\u0020\u0E01", expected: [][]rune{{0x0009, 0x0308, 0x0020}, {0x0E01}}},                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u0009\u3041", expected: [][]rune{{0x0009, 0x3041}}},                                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u0009\u0020\u3041", expected: [][]rune{{0x0009, 0x0020}, {0x3041}}},                                                                                                               // × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u0009\u0308\u3041", expected: [][]rune{{0x0009, 0x0308, 0x3041}}},                                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u0009\u0308\u0020\u3041", expected: [][]rune{{0x0009, 0x0308, 0x0020}, {0x3041}}},                                                                                                 // × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u00B4\u0023", expected: [][]rune{{0x00B4, 0x0023}}},                                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [21.04] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u00B4\u0020\u0023", expected: [][]rune{{0x00B4, 0x0020}, {0x0023}}},                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u00B4\u0308\u0023", expected: [][]rune{{0x00B4, 0x0308, 0x0023}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.04] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u00B4\u0308\u0020\u0023", expected: [][]rune{{0x00B4, 0x0308, 0x0020}, {0x0023}}},                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u00B4\u2014", expected: [][]rune{{0x00B4, 0x2014}}},                                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [21.04] EM DASH (B2) ÷ [0.3]
	{original: "\u00B4\u0020\u2014", expected: [][]rune{{0x00B4, 0x0020}, {0x2014}}},                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
	{original: "\u00B4\u0308\u2014", expected: [][]rune{{0x00B4, 0x0308, 0x2014}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.04] EM DASH (B2) ÷ [0.3]
	{original: "\u00B4\u0308\u0020\u2014", expected: [][]rune{{0x00B4, 0x0308, 0x0020}, {0x2014}}},                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
	{original: "\u00B4\u0009", expected: [][]rune{{0x00B4, 0x0009}}},                                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u00B4\u0020\u0009", expected: [][]rune{{0x00B4, 0x0020}, {0x0009}}},                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u00B4\u0308\u0009", expected: [][]rune{{0x00B4, 0x0308, 0x0009}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u00B4\u0308\u0020\u0009", expected: [][]rune{{0x00B4, 0x0308, 0x0020}, {0x0009}}},                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u00B4\u00B4", expected: [][]rune{{0x00B4, 0x00B4}}},                                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [21.04] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u00B4\u0020\u00B4", expected: [][]rune{{0x00B4, 0x0020}, {0x00B4}}},                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u00B4\u0308\u00B4", expected: [][]rune{{0x00B4, 0x0308, 0x00B4}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.04] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u00B4\u0308\u0020\u00B4", expected: [][]rune{{0x00B4, 0x0308, 0x0020}, {0x00B4}}},                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u00B4\u000B", expected: [][]rune{{0x00B4, 0x000B}}},                                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u00B4\u0020\u000B", expected: [][]rune{{0x00B4, 0x0020, 0x000B}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u00B4\u0308\u000B", expected: [][]rune{{0x00B4, 0x0308, 0x000B}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u00B4\u0308\u0020\u000B", expected: [][]rune{{0x00B4, 0x0308, 0x0020, 0x000B}}},                                                                                                   // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u00B4\uFFFC", expected: [][]rune{{0x00B4}, {0xFFFC}}},                                                                                                                             // × [0.3] ACUTE ACCENT (BB) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u00B4\u0020\uFFFC", expected: [][]rune{{0x00B4, 0x0020}, {0xFFFC}}},                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u00B4\u0308\uFFFC", expected: [][]rune{{0x00B4, 0x0308}, {0xFFFC}}},                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u00B4\u0308\u0020\uFFFC", expected: [][]rune{{0x00B4, 0x0308, 0x0020}, {0xFFFC}}},                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u00B4\u007D", expected: [][]rune{{0x00B4, 0x007D}}},                                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u00B4\u0020\u007D", expected: [][]rune{{0x00B4, 0x0020, 0x007D}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u00B4\u0308\u007D", expected: [][]rune{{0x00B4, 0x0308, 0x007D}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u00B4\u0308\u0020\u007D", expected: [][]rune{{0x00B4, 0x0308, 0x0020, 0x007D}}},                                                                                                   // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u00B4\u000D", expected: [][]rune{{0x00B4, 0x000D}}},                                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u00B4\u0020\u000D", expected: [][]rune{{0x00B4, 0x0020, 0x000D}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u00B4\u0308\u000D", expected: [][]rune{{0x00B4, 0x0308, 0x000D}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u00B4\u0308\u0020\u000D", expected: [][]rune{{0x00B4, 0x0308, 0x0020, 0x000D}}},                                                                                                   // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u00B4\u0021", expected: [][]rune{{0x00B4, 0x0021}}},                                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u00B4\u0020\u0021", expected: [][]rune{{0x00B4, 0x0020, 0x0021}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u00B4\u0308\u0021", expected: [][]rune{{0x00B4, 0x0308, 0x0021}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u00B4\u0308\u0020\u0021", expected: [][]rune{{0x00B4, 0x0308, 0x0020, 0x0021}}},                                                                                                   // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u00B4\u00A0", expected: [][]rune{{0x00B4, 0x00A0}}},                                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [12.1] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u00B4\u0020\u00A0", expected: [][]rune{{0x00B4, 0x0020}, {0x00A0}}},                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u00B4\u0308\u00A0", expected: [][]rune{{0x00B4, 0x0308, 0x00A0}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u00B4\u0308\u0020\u00A0", expected: [][]rune{{0x00B4, 0x0308, 0x0020}, {0x00A0}}},                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u00B4\uAC00", expected: [][]rune{{0x00B4, 0xAC00}}},                                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [21.04] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u00B4\u0020\uAC00", expected: [][]rune{{0x00B4, 0x0020}, {0xAC00}}},                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u00B4\u0308\uAC00", expected: [][]rune{{0x00B4, 0x0308, 0xAC00}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.04] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u00B4\u0308\u0020\uAC00", expected: [][]rune{{0x00B4, 0x0308, 0x0020}, {0xAC00}}},                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u00B4\uAC01", expected: [][]rune{{0x00B4, 0xAC01}}},                                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [21.04] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u00B4\u0020\uAC01", expected: [][]rune{{0x00B4, 0x0020}, {0xAC01}}},                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u00B4\u0308\uAC01", expected: [][]rune{{0x00B4, 0x0308, 0xAC01}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.04] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u00B4\u0308\u0020\uAC01", expected: [][]rune{{0x00B4, 0x0308, 0x0020}, {0xAC01}}},                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u00B4\u05D0", expected: [][]rune{{0x00B4, 0x05D0}}},                                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [21.04] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u00B4\u0020\u05D0", expected: [][]rune{{0x00B4, 0x0020}, {0x05D0}}},                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u00B4\u0308\u05D0", expected: [][]rune{{0x00B4, 0x0308, 0x05D0}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.04] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u00B4\u0308\u0020\u05D0", expected: [][]rune{{0x00B4, 0x0308, 0x0020}, {0x05D0}}},                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u00B4\u002D", expected: [][]rune{{0x00B4, 0x002D}}},                                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u00B4\u0020\u002D", expected: [][]rune{{0x00B4, 0x0020}, {0x002D}}},                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u00B4\u0308\u002D", expected: [][]rune{{0x00B4, 0x0308, 0x002D}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u00B4\u0308\u0020\u002D", expected: [][]rune{{0x00B4, 0x0308, 0x0020}, {0x002D}}},                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u00B4\u231A", expected: [][]rune{{0x00B4, 0x231A}}},                                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [21.04] WATCH (ID) ÷ [0.3]
	{original: "\u00B4\u0020\u231A", expected: [][]rune{{0x00B4, 0x0020}, {0x231A}}},                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
	{original: "\u00B4\u0308\u231A", expected: [][]rune{{0x00B4, 0x0308, 0x231A}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.04] WATCH (ID) ÷ [0.3]
	{original: "\u00B4\u0308\u0020\u231A", expected: [][]rune{{0x00B4, 0x0308, 0x0020}, {0x231A}}},                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
	{original: "\u00B4\u2024", expected: [][]rune{{0x00B4, 0x2024}}},                                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [21.04] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u00B4\u0020\u2024", expected: [][]rune{{0x00B4, 0x0020}, {0x2024}}},                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u00B4\u0308\u2024", expected: [][]rune{{0x00B4, 0x0308, 0x2024}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.04] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u00B4\u0308\u0020\u2024", expected: [][]rune{{0x00B4, 0x0308, 0x0020}, {0x2024}}},                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u00B4\u002C", expected: [][]rune{{0x00B4, 0x002C}}},                                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u00B4\u0020\u002C", expected: [][]rune{{0x00B4, 0x0020, 0x002C}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u00B4\u0308\u002C", expected: [][]rune{{0x00B4, 0x0308, 0x002C}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
	{original: "\u00B4\u0308\u0020\u002C", expected: [][]rune{{0x00B4, 0x0308, 0x0020, 0x002C}}},                                                                                                   // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u00B4\u1100", expected: [][]rune{{0x00B4, 0x1100}}},                                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [21.04] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u00B4\u0020\u1100", expected: [][]rune{{0x00B4, 0x0020}, {0x1100}}},                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u00B4\u0308\u1100", expected: [][]rune{{0x00B4, 0x0308, 0x1100}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.04] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u00B4\u0308\u0020\u1100", expected: [][]rune{{0x00B4, 0x0308, 0x0020}, {0x1100}}},                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u00B4\u11A8", expected: [][]rune{{0x00B4, 0x11A8}}},                                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [21.04] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u00B4\u0020\u11A8", expected: [][]rune{{0x00B4, 0x0020}, {0x11A8}}},                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u00B4\u0308\u11A8", expected: [][]rune{{0x00B4, 0x0308, 0x11A8}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.04] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u00B4\u0308\u0020\u11A8", expected: [][]rune{{0x00B4, 0x0308, 0x0020}, {0x11A8}}},                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u00B4\u1160", expected: [][]rune{{0x00B4, 0x1160}}},                                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [21.04] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u00B4\u0020\u1160", expected: [][]rune{{0x00B4, 0x0020}, {0x1160}}},                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u00B4\u0308\u1160", expected: [][]rune{{0x00B4, 0x0308, 0x1160}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.04] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u00B4\u0308\u0020\u1160", expected: [][]rune{{0x00B4, 0x0308, 0x0020}, {0x1160}}},                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u00B4\u000A", expected: [][]rune{{0x00B4, 0x000A}}},                                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u00B4\u0020\u000A", expected: [][]rune{{0x00B4, 0x0020, 0x000A}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u00B4\u0308\u000A", expected: [][]rune{{0x00B4, 0x0308, 0x000A}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u00B4\u0308\u0020\u000A", expected: [][]rune{{0x00B4, 0x0308, 0x0020, 0x000A}}},                                                                                                   // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u00B4\u0085", expected: [][]rune{{0x00B4, 0x0085}}},                                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u00B4\u0020\u0085", expected: [][]rune{{0x00B4, 0x0020, 0x0085}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u00B4\u0308\u0085", expected: [][]rune{{0x00B4, 0x0308, 0x0085}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u00B4\u0308\u0020\u0085", expected: [][]rune{{0x00B4, 0x0308, 0x0020, 0x0085}}},                                                                                                   // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u00B4\u17D6", expected: [][]rune{{0x00B4, 0x17D6}}},                                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u00B4\u0020\u17D6", expected: [][]rune{{0x00B4, 0x0020}, {0x17D6}}},                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u00B4\u0308\u17D6", expected: [][]rune{{0x00B4, 0x0308, 0x17D6}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u00B4\u0308\u0020\u17D6", expected: [][]rune{{0x00B4, 0x0308, 0x0020}, {0x17D6}}},                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u00B4\u0030", expected: [][]rune{{0x00B4, 0x0030}}},                                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [21.04] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u00B4\u0020\u0030", expected: [][]rune{{0x00B4, 0x0020}, {0x0030}}},                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u00B4\u0308\u0030", expected: [][]rune{{0x00B4, 0x0308, 0x0030}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.04] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u00B4\u0308\u0020\u0030", expected: [][]rune{{0x00B4, 0x0308, 0x0020}, {0x0030}}},                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u00B4\u2329", expected: [][]rune{{0x00B4, 0x2329}}},                                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [21.04] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u00B4\u0020\u2329", expected: [][]rune{{0x00B4, 0x0020}, {0x2329}}},                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u00B4\u0308\u2329", expected: [][]rune{{0x00B4, 0x0308, 0x2329}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.04] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u00B4\u0308\u0020\u2329", expected: [][]rune{{0x00B4, 0x0308, 0x0020}, {0x2329}}},                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u00B4\u0025", expected: [][]rune{{0x00B4, 0x0025}}},                                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [21.04] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u00B4\u0020\u0025", expected: [][]rune{{0x00B4, 0x0020}, {0x0025}}},                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u00B4\u0308\u0025", expected: [][]rune{{0x00B4, 0x0308, 0x0025}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.04] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u00B4\u0308\u0020\u0025", expected: [][]rune{{0x00B4, 0x0308, 0x0020}, {0x0025}}},                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u00B4\u0024", expected: [][]rune{{0x00B4, 0x0024}}},                                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [21.04] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u00B4\u0020\u0024", expected: [][]rune{{0x00B4, 0x0020}, {0x0024}}},                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u00B4\u0308\u0024", expected: [][]rune{{0x00B4, 0x0308, 0x0024}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.04] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u00B4\u0308\u0020\u0024", expected: [][]rune{{0x00B4, 0x0308, 0x0020}, {0x0024}}},                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u00B4\u0022", expected: [][]rune{{0x00B4, 0x0022}}},                                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u00B4\u0020\u0022", expected: [][]rune{{0x00B4, 0x0020}, {0x0022}}},                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u00B4\u0308\u0022", expected: [][]rune{{0x00B4, 0x0308, 0x0022}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u00B4\u0308\u0020\u0022", expected: [][]rune{{0x00B4, 0x0308, 0x0020}, {0x0022}}},                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u00B4\u0020", expected: [][]rune{{0x00B4, 0x0020}}},                                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u00B4\u0020\u0020", expected: [][]rune{{0x00B4, 0x0020, 0x0020}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u00B4\u0308\u0020", expected: [][]rune{{0x00B4, 0x0308, 0x0020}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u00B4\u0308\u0020\u0020", expected: [][]rune{{0x00B4, 0x0308, 0x0020, 0x0020}}},                                                                                                   // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u00B4\u002F", expected: [][]rune{{0x00B4, 0x002F}}},                                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\u00B4\u0020\u002F", expected: [][]rune{{0x00B4, 0x0020, 0x002F}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\u00B4\u0308\u002F", expected: [][]rune{{0x00B4, 0x0308, 0x002F}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
	{original: "\u00B4\u0308\u0020\u002F", expected: [][]rune{{0x00B4, 0x0308, 0x0020, 0x002F}}},                                                                                                   // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\u00B4\u2060", expected: [][]rune{{0x00B4, 0x2060}}},                                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u00B4\u0020\u2060", expected: [][]rune{{0x00B4, 0x0020, 0x2060}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u00B4\u0308\u2060", expected: [][]rune{{0x00B4, 0x0308, 0x2060}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u00B4\u0308\u0020\u2060", expected: [][]rune{{0x00B4, 0x0308, 0x0020, 0x2060}}},                                                                                                   // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u00B4\u200B", expected: [][]rune{{0x00B4, 0x200B}}},                                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u00B4\u0020\u200B", expected: [][]rune{{0x00B4, 0x0020, 0x200B}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u00B4\u0308\u200B", expected: [][]rune{{0x00B4, 0x0308, 0x200B}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u00B4\u0308\u0020\u200B", expected: [][]rune{{0x00B4, 0x0308, 0x0020, 0x200B}}},                                                                                                   // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u00B4\U0001F1E6", expected: [][]rune{{0x00B4, 0x1F1E6}}},                                                                                                                          // × [0.3] ACUTE ACCENT (BB) × [21.04] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u00B4\u0020\U0001F1E6", expected: [][]rune{{0x00B4, 0x0020}, {0x1F1E6}}},                                                                                                          // × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u00B4\u0308\U0001F1E6", expected: [][]rune{{0x00B4, 0x0308, 0x1F1E6}}},                                                                                                            // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.04] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u00B4\u0308\u0020\U0001F1E6", expected: [][]rune{{0x00B4, 0x0308, 0x0020}, {0x1F1E6}}},                                                                                            // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u00B4\u261D", expected: [][]rune{{0x00B4, 0x261D}}},                                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [21.04] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u00B4\u0020\u261D", expected: [][]rune{{0x00B4, 0x0020}, {0x261D}}},                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u00B4\u0308\u261D", expected: [][]rune{{0x00B4, 0x0308, 0x261D}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.04] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u00B4\u0308\u0020\u261D", expected: [][]rune{{0x00B4, 0x0308, 0x0020}, {0x261D}}},                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u00B4\U0001F3FB", expected: [][]rune{{0x00B4, 0x1F3FB}}},                                                                                                                          // × [0.3] ACUTE ACCENT (BB) × [21.04] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u00B4\u0020\U0001F3FB", expected: [][]rune{{0x00B4, 0x0020}, {0x1F3FB}}},                                                                                                          // × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u00B4\u0308\U0001F3FB", expected: [][]rune{{0x00B4, 0x0308, 0x1F3FB}}},                                                                                                            // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.04] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u00B4\u0308\u0020\U0001F3FB", expected: [][]rune{{0x00B4, 0x0308, 0x0020}, {0x1F3FB}}},                                                                                            // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u00B4\u0029", expected: [][]rune{{0x00B4, 0x0029}}},                                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u00B4\u0020\u0029", expected: [][]rune{{0x00B4, 0x0020, 0x0029}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u00B4\u0308\u0029", expected: [][]rune{{0x00B4, 0x0308, 0x0029}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u00B4\u0308\u0020\u0029", expected: [][]rune{{0x00B4, 0x0308, 0x0020, 0x0029}}},                                                                                                   // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u00B4\u0028", expected: [][]rune{{0x00B4, 0x0028}}},                                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [21.04] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u00B4\u0020\u0028", expected: [][]rune{{0x00B4, 0x0020}, {0x0028}}},                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u00B4\u0308\u0028", expected: [][]rune{{0x00B4, 0x0308, 0x0028}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.04] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u00B4\u0308\u0020\u0028", expected: [][]rune{{0x00B4, 0x0308, 0x0020}, {0x0028}}},                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u00B4\u0001", expected: [][]rune{{0x00B4, 0x0001}}},                                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u00B4\u0020\u0001", expected: [][]rune{{0x00B4, 0x0020}, {0x0001}}},                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u00B4\u0308\u0001", expected: [][]rune{{0x00B4, 0x0308, 0x0001}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u00B4\u0308\u0020\u0001", expected: [][]rune{{0x00B4, 0x0308, 0x0020}, {0x0001}}},                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u00B4\u200D", expected: [][]rune{{0x00B4, 0x200D}}},                                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u00B4\u0020\u200D", expected: [][]rune{{0x00B4, 0x0020}, {0x200D}}},                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u00B4\u0308\u200D", expected: [][]rune{{0x00B4, 0x0308, 0x200D}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u00B4\u0308\u0020\u200D", expected: [][]rune{{0x00B4, 0x0308, 0x0020}, {0x200D}}},                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u00B4\u00A7", expected: [][]rune{{0x00B4, 0x00A7}}},                                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [21.04] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u00B4\u0020\u00A7", expected: [][]rune{{0x00B4, 0x0020}, {0x00A7}}},                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u00B4\u0308\u00A7", expected: [][]rune{{0x00B4, 0x0308, 0x00A7}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.04] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u00B4\u0308\u0020\u00A7", expected: [][]rune{{0x00B4, 0x0308, 0x0020}, {0x00A7}}},                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u00B4\U00050005", expected: [][]rune{{0x00B4, 0x50005}}},                                                                                                                          // × [0.3] ACUTE ACCENT (BB) × [21.04] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u00B4\u0020\U00050005", expected: [][]rune{{0x00B4, 0x0020}, {0x50005}}},                                                                                                          // × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u00B4\u0308\U00050005", expected: [][]rune{{0x00B4, 0x0308, 0x50005}}},                                                                                                            // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.04] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u00B4\u0308\u0020\U00050005", expected: [][]rune{{0x00B4, 0x0308, 0x0020}, {0x50005}}},                                                                                            // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u00B4\u0E01", expected: [][]rune{{0x00B4, 0x0E01}}},                                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [21.04] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u00B4\u0020\u0E01", expected: [][]rune{{0x00B4, 0x0020}, {0x0E01}}},                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u00B4\u0308\u0E01", expected: [][]rune{{0x00B4, 0x0308, 0x0E01}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.04] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u00B4\u0308\u0020\u0E01", expected: [][]rune{{0x00B4, 0x0308, 0x0020}, {0x0E01}}},                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u00B4\u3041", expected: [][]rune{{0x00B4, 0x3041}}},                                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u00B4\u0020\u3041", expected: [][]rune{{0x00B4, 0x0020}, {0x3041}}},                                                                                                               // × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u00B4\u0308\u3041", expected: [][]rune{{0x00B4, 0x0308, 0x3041}}},                                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u00B4\u0308\u0020\u3041", expected: [][]rune{{0x00B4, 0x0308, 0x0020}, {0x3041}}},                                                                                                 // × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u000B\u0023", expected: [][]rune{{0x000B}, {0x0023}}},                                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u000B\u0020\u0023", expected: [][]rune{{0x000B}, {0x0020}, {0x0023}}},                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u000B\u0308\u0023", expected: [][]rune{{0x000B}, {0x0308, 0x0023}}},                                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [28.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u000B\u0308\u0020\u0023", expected: [][]rune{{0x000B}, {0x0308, 0x0020}, {0x0023}}},                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u000B\u2014", expected: [][]rune{{0x000B}, {0x2014}}},                                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] EM DASH (B2) ÷ [0.3]
	{original: "\u000B\u0020\u2014", expected: [][]rune{{0x000B}, {0x0020}, {0x2014}}},                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
	{original: "\u000B\u0308\u2014", expected: [][]rune{{0x000B}, {0x0308}, {0x2014}}},                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
	{original: "\u000B\u0308\u0020\u2014", expected: [][]rune{{0x000B}, {0x0308, 0x0020}, {0x2014}}},                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
	{original: "\u000B\u0009", expected: [][]rune{{0x000B}, {0x0009}}},                                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u000B\u0020\u0009", expected: [][]rune{{0x000B}, {0x0020}, {0x0009}}},                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u000B\u0308\u0009", expected: [][]rune{{0x000B}, {0x0308, 0x0009}}},                                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u000B\u0308\u0020\u0009", expected: [][]rune{{0x000B}, {0x0308, 0x0020}, {0x0009}}},                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u000B\u00B4", expected: [][]rune{{0x000B}, {0x00B4}}},                                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u000B\u0020\u00B4", expected: [][]rune{{0x000B}, {0x0020}, {0x00B4}}},                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u000B\u0308\u00B4", expected: [][]rune{{0x000B}, {0x0308}, {0x00B4}}},                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u000B\u0308\u0020\u00B4", expected: [][]rune{{0x000B}, {0x0308, 0x0020}, {0x00B4}}},                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u000B\u000B", expected: [][]rune{{0x000B}, {0x000B}}},                                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u000B\u0020\u000B", expected: [][]rune{{0x000B}, {0x0020, 0x000B}}},                                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u000B\u0308\u000B", expected: [][]rune{{0x000B}, {0x0308, 0x000B}}},                                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u000B\u0308\u0020\u000B", expected: [][]rune{{0x000B}, {0x0308, 0x0020, 0x000B}}},                                                                                                 // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u000B\uFFFC", expected: [][]rune{{0x000B}, {0xFFFC}}},                                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u000B\u0020\uFFFC", expected: [][]rune{{0x000B}, {0x0020}, {0xFFFC}}},                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u000B\u0308\uFFFC", expected: [][]rune{{0x000B}, {0x0308}, {0xFFFC}}},                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u000B\u0308\u0020\uFFFC", expected: [][]rune{{0x000B}, {0x0308, 0x0020}, {0xFFFC}}},                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u000B\u007D", expected: [][]rune{{0x000B}, {0x007D}}},                                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u000B\u0020\u007D", expected: [][]rune{{0x000B}, {0x0020, 0x007D}}},                                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u000B\u0308\u007D", expected: [][]rune{{0x000B}, {0x0308, 0x007D}}},                                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u000B\u0308\u0020\u007D", expected: [][]rune{{0x000B}, {0x0308, 0x0020, 0x007D}}},                                                                                                 // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u000B\u000D", expected: [][]rune{{0x000B}, {0x000D}}},                                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u000B\u0020\u000D", expected: [][]rune{{0x000B}, {0x0020, 0x000D}}},                                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u000B\u0308\u000D", expected: [][]rune{{0x000B}, {0x0308, 0x000D}}},                                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u000B\u0308\u0020\u000D", expected: [][]rune{{0x000B}, {0x0308, 0x0020, 0x000D}}},                                                                                                 // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u000B\u0021", expected: [][]rune{{0x000B}, {0x0021}}},                                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u000B\u0020\u0021", expected: [][]rune{{0x000B}, {0x0020, 0x0021}}},                                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u000B\u0308\u0021", expected: [][]rune{{0x000B}, {0x0308, 0x0021}}},                                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u000B\u0308\u0020\u0021", expected: [][]rune{{0x000B}, {0x0308, 0x0020, 0x0021}}},                                                                                                 // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u000B\u00A0", expected: [][]rune{{0x000B}, {0x00A0}}},                                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u000B\u0020\u00A0", expected: [][]rune{{0x000B}, {0x0020}, {0x00A0}}},                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u000B\u0308\u00A0", expected: [][]rune{{0x000B}, {0x0308, 0x00A0}}},                                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u000B\u0308\u0020\u00A0", expected: [][]rune{{0x000B}, {0x0308, 0x0020}, {0x00A0}}},                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u000B\uAC00", expected: [][]rune{{0x000B}, {0xAC00}}},                                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u000B\u0020\uAC00", expected: [][]rune{{0x000B}, {0x0020}, {0xAC00}}},                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u000B\u0308\uAC00", expected: [][]rune{{0x000B}, {0x0308}, {0xAC00}}},                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u000B\u0308\u0020\uAC00", expected: [][]rune{{0x000B}, {0x0308, 0x0020}, {0xAC00}}},                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u000B\uAC01", expected: [][]rune{{0x000B}, {0xAC01}}},                                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u000B\u0020\uAC01", expected: [][]rune{{0x000B}, {0x0020}, {0xAC01}}},                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u000B\u0308\uAC01", expected: [][]rune{{0x000B}, {0x0308}, {0xAC01}}},                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u000B\u0308\u0020\uAC01", expected: [][]rune{{0x000B}, {0x0308, 0x0020}, {0xAC01}}},                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u000B\u05D0", expected: [][]rune{{0x000B}, {0x05D0}}},                                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u000B\u0020\u05D0", expected: [][]rune{{0x000B}, {0x0020}, {0x05D0}}},                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u000B\u0308\u05D0", expected: [][]rune{{0x000B}, {0x0308, 0x05D0}}},                                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [28.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u000B\u0308\u0020\u05D0", expected: [][]rune{{0x000B}, {0x0308, 0x0020}, {0x05D0}}},                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u000B\u002D", expected: [][]rune{{0x000B}, {0x002D}}},                                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u000B\u0020\u002D", expected: [][]rune{{0x000B}, {0x0020}, {0x002D}}},                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u000B\u0308\u002D", expected: [][]rune{{0x000B}, {0x0308, 0x002D}}},                                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u000B\u0308\u0020\u002D", expected: [][]rune{{0x000B}, {0x0308, 0x0020}, {0x002D}}},                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u000B\u231A", expected: [][]rune{{0x000B}, {0x231A}}},                                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] WATCH (ID) ÷ [0.3]
	{original: "\u000B\u0020\u231A", expected: [][]rune{{0x000B}, {0x0020}, {0x231A}}},                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
	{original: "\u000B\u0308\u231A", expected: [][]rune{{0x000B}, {0x0308}, {0x231A}}},                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
	{original: "\u000B\u0308\u0020\u231A", expected: [][]rune{{0x000B}, {0x0308, 0x0020}, {0x231A}}},                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
	{original: "\u000B\u2024", expected: [][]rune{{0x000B}, {0x2024}}},                                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u000B\u0020\u2024", expected: [][]rune{{0x000B}, {0x0020}, {0x2024}}},                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u000B\u0308\u2024", expected: [][]rune{{0x000B}, {0x0308, 0x2024}}},                                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u000B\u0308\u0020\u2024", expected: [][]rune{{0x000B}, {0x0308, 0x0020}, {0x2024}}},                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u000B\u002C", expected: [][]rune{{0x000B}, {0x002C}}},                                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMMA (IS) ÷ [0.3]
	{original: "\u000B\u0020\u002C", expected: [][]rune{{0x000B}, {0x0020, 0x002C}}},                                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u000B\u0308\u002C", expected: [][]rune{{0x000B}, {0x0308, 0x002C}}},                                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
	{original: "\u000B\u0308\u0020\u002C", expected: [][]rune{{0x000B}, {0x0308, 0x0020, 0x002C}}},                                                                                                 // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u000B\u1100", expected: [][]rune{{0x000B}, {0x1100}}},                                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u000B\u0020\u1100", expected: [][]rune{{0x000B}, {0x0020}, {0x1100}}},                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u000B\u0308\u1100", expected: [][]rune{{0x000B}, {0x0308}, {0x1100}}},                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u000B\u0308\u0020\u1100", expected: [][]rune{{0x000B}, {0x0308, 0x0020}, {0x1100}}},                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u000B\u11A8", expected: [][]rune{{0x000B}, {0x11A8}}},                                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u000B\u0020\u11A8", expected: [][]rune{{0x000B}, {0x0020}, {0x11A8}}},                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u000B\u0308\u11A8", expected: [][]rune{{0x000B}, {0x0308}, {0x11A8}}},                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u000B\u0308\u0020\u11A8", expected: [][]rune{{0x000B}, {0x0308, 0x0020}, {0x11A8}}},                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u000B\u1160", expected: [][]rune{{0x000B}, {0x1160}}},                                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u000B\u0020\u1160", expected: [][]rune{{0x000B}, {0x0020}, {0x1160}}},                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u000B\u0308\u1160", expected: [][]rune{{0x000B}, {0x0308}, {0x1160}}},                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u000B\u0308\u0020\u1160", expected: [][]rune{{0x000B}, {0x0308, 0x0020}, {0x1160}}},                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u000B\u000A", expected: [][]rune{{0x000B}, {0x000A}}},                                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u000B\u0020\u000A", expected: [][]rune{{0x000B}, {0x0020, 0x000A}}},                                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u000B\u0308\u000A", expected: [][]rune{{0x000B}, {0x0308, 0x000A}}},                                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u000B\u0308\u0020\u000A", expected: [][]rune{{0x000B}, {0x0308, 0x0020, 0x000A}}},                                                                                                 // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u000B\u0085", expected: [][]rune{{0x000B}, {0x0085}}},                                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u000B\u0020\u0085", expected: [][]rune{{0x000B}, {0x0020, 0x0085}}},                                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u000B\u0308\u0085", expected: [][]rune{{0x000B}, {0x0308, 0x0085}}},                                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u000B\u0308\u0020\u0085", expected: [][]rune{{0x000B}, {0x0308, 0x0020, 0x0085}}},                                                                                                 // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u000B\u17D6", expected: [][]rune{{0x000B}, {0x17D6}}},                                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u000B\u0020\u17D6", expected: [][]rune{{0x000B}, {0x0020}, {0x17D6}}},                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u000B\u0308\u17D6", expected: [][]rune{{0x000B}, {0x0308, 0x17D6}}},                                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u000B\u0308\u0020\u17D6", expected: [][]rune{{0x000B}, {0x0308, 0x0020}, {0x17D6}}},                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u000B\u0030", expected: [][]rune{{0x000B}, {0x0030}}},                                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u000B\u0020\u0030", expected: [][]rune{{0x000B}, {0x0020}, {0x0030}}},                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u000B\u0308\u0030", expected: [][]rune{{0x000B}, {0x0308, 0x0030}}},                                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [23.02] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u000B\u0308\u0020\u0030", expected: [][]rune{{0x000B}, {0x0308, 0x0020}, {0x0030}}},                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u000B\u2329", expected: [][]rune{{0x000B}, {0x2329}}},                                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u000B\u0020\u2329", expected: [][]rune{{0x000B}, {0x0020}, {0x2329}}},                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u000B\u0308\u2329", expected: [][]rune{{0x000B}, {0x0308}, {0x2329}}},                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u000B\u0308\u0020\u2329", expected: [][]rune{{0x000B}, {0x0308, 0x0020}, {0x2329}}},                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u000B\u0025", expected: [][]rune{{0x000B}, {0x0025}}},                                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u000B\u0020\u0025", expected: [][]rune{{0x000B}, {0x0020}, {0x0025}}},                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u000B\u0308\u0025", expected: [][]rune{{0x000B}, {0x0308, 0x0025}}},                                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [24.03] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u000B\u0308\u0020\u0025", expected: [][]rune{{0x000B}, {0x0308, 0x0020}, {0x0025}}},                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u000B\u0024", expected: [][]rune{{0x000B}, {0x0024}}},                                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u000B\u0020\u0024", expected: [][]rune{{0x000B}, {0x0020}, {0x0024}}},                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u000B\u0308\u0024", expected: [][]rune{{0x000B}, {0x0308, 0x0024}}},                                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [24.03] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u000B\u0308\u0020\u0024", expected: [][]rune{{0x000B}, {0x0308, 0x0020}, {0x0024}}},                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u000B\u0022", expected: [][]rune{{0x000B}, {0x0022}}},                                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u000B\u0020\u0022", expected: [][]rune{{0x000B}, {0x0020}, {0x0022}}},                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u000B\u0308\u0022", expected: [][]rune{{0x000B}, {0x0308, 0x0022}}},                                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u000B\u0308\u0020\u0022", expected: [][]rune{{0x000B}, {0x0308, 0x0020}, {0x0022}}},                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u000B\u0020", expected: [][]rune{{0x000B}, {0x0020}}},                                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [0.3]
	{original: "\u000B\u0020\u0020", expected: [][]rune{{0x000B}, {0x0020, 0x0020}}},                                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u000B\u0308\u0020", expected: [][]rune{{0x000B}, {0x0308, 0x0020}}},                                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u000B\u0308\u0020\u0020", expected: [][]rune{{0x000B}, {0x0308, 0x0020, 0x0020}}},                                                                                                 // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u000B\u002F", expected: [][]rune{{0x000B}, {0x002F}}},                                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SOLIDUS (SY) ÷ [0.3]
	{original: "\u000B\u0020\u002F", expected: [][]rune{{0x000B}, {0x0020, 0x002F}}},                                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\u000B\u0308\u002F", expected: [][]rune{{0x000B}, {0x0308, 0x002F}}},                                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
	{original: "\u000B\u0308\u0020\u002F", expected: [][]rune{{0x000B}, {0x0308, 0x0020, 0x002F}}},                                                                                                 // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\u000B\u2060", expected: [][]rune{{0x000B}, {0x2060}}},                                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u000B\u0020\u2060", expected: [][]rune{{0x000B}, {0x0020, 0x2060}}},                                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u000B\u0308\u2060", expected: [][]rune{{0x000B}, {0x0308, 0x2060}}},                                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u000B\u0308\u0020\u2060", expected: [][]rune{{0x000B}, {0x0308, 0x0020, 0x2060}}},                                                                                                 // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u000B\u200B", expected: [][]rune{{0x000B}, {0x200B}}},                                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u000B\u0020\u200B", expected: [][]rune{{0x000B}, {0x0020, 0x200B}}},                                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u000B\u0308\u200B", expected: [][]rune{{0x000B}, {0x0308, 0x200B}}},                                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u000B\u0308\u0020\u200B", expected: [][]rune{{0x000B}, {0x0308, 0x0020, 0x200B}}},                                                                                                 // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u000B\U0001F1E6", expected: [][]rune{{0x000B}, {0x1F1E6}}},                                                                                                                        // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u000B\u0020\U0001F1E6", expected: [][]rune{{0x000B}, {0x0020}, {0x1F1E6}}},                                                                                                        // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u000B\u0308\U0001F1E6", expected: [][]rune{{0x000B}, {0x0308}, {0x1F1E6}}},                                                                                                        // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u000B\u0308\u0020\U0001F1E6", expected: [][]rune{{0x000B}, {0x0308, 0x0020}, {0x1F1E6}}},                                                                                          // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u000B\u261D", expected: [][]rune{{0x000B}, {0x261D}}},                                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u000B\u0020\u261D", expected: [][]rune{{0x000B}, {0x0020}, {0x261D}}},                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u000B\u0308\u261D", expected: [][]rune{{0x000B}, {0x0308}, {0x261D}}},                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u000B\u0308\u0020\u261D", expected: [][]rune{{0x000B}, {0x0308, 0x0020}, {0x261D}}},                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u000B\U0001F3FB", expected: [][]rune{{0x000B}, {0x1F3FB}}},                                                                                                                        // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u000B\u0020\U0001F3FB", expected: [][]rune{{0x000B}, {0x0020}, {0x1F3FB}}},                                                                                                        // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u000B\u0308\U0001F3FB", expected: [][]rune{{0x000B}, {0x0308}, {0x1F3FB}}},                                                                                                        // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u000B\u0308\u0020\U0001F3FB", expected: [][]rune{{0x000B}, {0x0308, 0x0020}, {0x1F3FB}}},                                                                                          // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u000B\u0029", expected: [][]rune{{0x000B}, {0x0029}}},                                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u000B\u0020\u0029", expected: [][]rune{{0x000B}, {0x0020, 0x0029}}},                                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u000B\u0308\u0029", expected: [][]rune{{0x000B}, {0x0308, 0x0029}}},                                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u000B\u0308\u0020\u0029", expected: [][]rune{{0x000B}, {0x0308, 0x0020, 0x0029}}},                                                                                                 // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u000B\u0028", expected: [][]rune{{0x000B}, {0x0028}}},                                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u000B\u0020\u0028", expected: [][]rune{{0x000B}, {0x0020}, {0x0028}}},                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u000B\u0308\u0028", expected: [][]rune{{0x000B}, {0x0308, 0x0028}}},                                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [30.01] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u000B\u0308\u0020\u0028", expected: [][]rune{{0x000B}, {0x0308, 0x0020}, {0x0028}}},                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u000B\u0001", expected: [][]rune{{0x000B}, {0x0001}}},                                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u000B\u0020\u0001", expected: [][]rune{{0x000B}, {0x0020}, {0x0001}}},                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u000B\u0308\u0001", expected: [][]rune{{0x000B}, {0x0308, 0x0001}}},                                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u000B\u0308\u0020\u0001", expected: [][]rune{{0x000B}, {0x0308, 0x0020}, {0x0001}}},                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u000B\u200D", expected: [][]rune{{0x000B}, {0x200D}}},                                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u000B\u0020\u200D", expected: [][]rune{{0x000B}, {0x0020}, {0x200D}}},                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u000B\u0308\u200D", expected: [][]rune{{0x000B}, {0x0308, 0x200D}}},                                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u000B\u0308\u0020\u200D", expected: [][]rune{{0x000B}, {0x0308, 0x0020}, {0x200D}}},                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u000B\u00A7", expected: [][]rune{{0x000B}, {0x00A7}}},                                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u000B\u0020\u00A7", expected: [][]rune{{0x000B}, {0x0020}, {0x00A7}}},                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u000B\u0308\u00A7", expected: [][]rune{{0x000B}, {0x0308, 0x00A7}}},                                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [28.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u000B\u0308\u0020\u00A7", expected: [][]rune{{0x000B}, {0x0308, 0x0020}, {0x00A7}}},                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u000B\U00050005", expected: [][]rune{{0x000B}, {0x50005}}},                                                                                                                        // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u000B\u0020\U00050005", expected: [][]rune{{0x000B}, {0x0020}, {0x50005}}},                                                                                                        // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u000B\u0308\U00050005", expected: [][]rune{{0x000B}, {0x0308, 0x50005}}},                                                                                                          // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [28.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u000B\u0308\u0020\U00050005", expected: [][]rune{{0x000B}, {0x0308, 0x0020}, {0x50005}}},                                                                                          // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u000B\u0E01", expected: [][]rune{{0x000B}, {0x0E01}}},                                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u000B\u0020\u0E01", expected: [][]rune{{0x000B}, {0x0020}, {0x0E01}}},                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u000B\u0308\u0E01", expected: [][]rune{{0x000B}, {0x0308, 0x0E01}}},                                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [28.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u000B\u0308\u0020\u0E01", expected: [][]rune{{0x000B}, {0x0308, 0x0020}, {0x0E01}}},                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u000B\u3041", expected: [][]rune{{0x000B}, {0x3041}}},                                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u000B\u0020\u3041", expected: [][]rune{{0x000B}, {0x0020}, {0x3041}}},                                                                                                             // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u000B\u0308\u3041", expected: [][]rune{{0x000B}, {0x0308, 0x3041}}},                                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u000B\u0308\u0020\u3041", expected: [][]rune{{0x000B}, {0x0308, 0x0020}, {0x3041}}},                                                                                               // × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\uFFFC\u0023", expected: [][]rune{{0xFFFC}, {0x0023}}},                                                                                                                             // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\uFFFC\u0020\u0023", expected: [][]rune{{0xFFFC, 0x0020}, {0x0023}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\uFFFC\u0308\u0023", expected: [][]rune{{0xFFFC, 0x0308}, {0x0023}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\uFFFC\u0308\u0020\u0023", expected: [][]rune{{0xFFFC, 0x0308, 0x0020}, {0x0023}}},                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\uFFFC\u2014", expected: [][]rune{{0xFFFC}, {0x2014}}},                                                                                                                             // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] EM DASH (B2) ÷ [0.3]
	{original: "\uFFFC\u0020\u2014", expected: [][]rune{{0xFFFC, 0x0020}, {0x2014}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
	{original: "\uFFFC\u0308\u2014", expected: [][]rune{{0xFFFC, 0x0308}, {0x2014}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] EM DASH (B2) ÷ [0.3]
	{original: "\uFFFC\u0308\u0020\u2014", expected: [][]rune{{0xFFFC, 0x0308, 0x0020}, {0x2014}}},                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
	{original: "\uFFFC\u0009", expected: [][]rune{{0xFFFC}, {0x0009}}},                                                                                                                             // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\uFFFC\u0020\u0009", expected: [][]rune{{0xFFFC, 0x0020}, {0x0009}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\uFFFC\u0308\u0009", expected: [][]rune{{0xFFFC, 0x0308}, {0x0009}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\uFFFC\u0308\u0020\u0009", expected: [][]rune{{0xFFFC, 0x0308, 0x0020}, {0x0009}}},                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\uFFFC\u00B4", expected: [][]rune{{0xFFFC}, {0x00B4}}},                                                                                                                             // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\uFFFC\u0020\u00B4", expected: [][]rune{{0xFFFC, 0x0020}, {0x00B4}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\uFFFC\u0308\u00B4", expected: [][]rune{{0xFFFC, 0x0308}, {0x00B4}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\uFFFC\u0308\u0020\u00B4", expected: [][]rune{{0xFFFC, 0x0308, 0x0020}, {0x00B4}}},                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\uFFFC\u000B", expected: [][]rune{{0xFFFC, 0x000B}}},                                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\uFFFC\u0020\u000B", expected: [][]rune{{0xFFFC, 0x0020, 0x000B}}},                                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\uFFFC\u0308\u000B", expected: [][]rune{{0xFFFC, 0x0308, 0x000B}}},                                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\uFFFC\u0308\u0020\u000B", expected: [][]rune{{0xFFFC, 0x0308, 0x0020, 0x000B}}},                                                                                                   // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\uFFFC\uFFFC", expected: [][]rune{{0xFFFC}, {0xFFFC}}},                                                                                                                             // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\uFFFC\u0020\uFFFC", expected: [][]rune{{0xFFFC, 0x0020}, {0xFFFC}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\uFFFC\u0308\uFFFC", expected: [][]rune{{0xFFFC, 0x0308}, {0xFFFC}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\uFFFC\u0308\u0020\uFFFC", expected: [][]rune{{0xFFFC, 0x0308, 0x0020}, {0xFFFC}}},                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\uFFFC\u007D", expected: [][]rune{{0xFFFC, 0x007D}}},                                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\uFFFC\u0020\u007D", expected: [][]rune{{0xFFFC, 0x0020, 0x007D}}},                                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\uFFFC\u0308\u007D", expected: [][]rune{{0xFFFC, 0x0308, 0x007D}}},                                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\uFFFC\u0308\u0020\u007D", expected: [][]rune{{0xFFFC, 0x0308, 0x0020, 0x007D}}},                                                                                                   // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\uFFFC\u000D", expected: [][]rune{{0xFFFC, 0x000D}}},                                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\uFFFC\u0020\u000D", expected: [][]rune{{0xFFFC, 0x0020, 0x000D}}},                                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\uFFFC\u0308\u000D", expected: [][]rune{{0xFFFC, 0x0308, 0x000D}}},                                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\uFFFC\u0308\u0020\u000D", expected: [][]rune{{0xFFFC, 0x0308, 0x0020, 0x000D}}},                                                                                                   // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\uFFFC\u0021", expected: [][]rune{{0xFFFC, 0x0021}}},                                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\uFFFC\u0020\u0021", expected: [][]rune{{0xFFFC, 0x0020, 0x0021}}},                                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\uFFFC\u0308\u0021", expected: [][]rune{{0xFFFC, 0x0308, 0x0021}}},                                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\uFFFC\u0308\u0020\u0021", expected: [][]rune{{0xFFFC, 0x0308, 0x0020, 0x0021}}},                                                                                                   // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\uFFFC\u00A0", expected: [][]rune{{0xFFFC, 0x00A0}}},                                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [12.1] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\uFFFC\u0020\u00A0", expected: [][]rune{{0xFFFC, 0x0020}, {0x00A0}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\uFFFC\u0308\u00A0", expected: [][]rune{{0xFFFC, 0x0308, 0x00A0}}},                                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\uFFFC\u0308\u0020\u00A0", expected: [][]rune{{0xFFFC, 0x0308, 0x0020}, {0x00A0}}},                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\uFFFC\uAC00", expected: [][]rune{{0xFFFC}, {0xAC00}}},                                                                                                                             // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\uFFFC\u0020\uAC00", expected: [][]rune{{0xFFFC, 0x0020}, {0xAC00}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\uFFFC\u0308\uAC00", expected: [][]rune{{0xFFFC, 0x0308}, {0xAC00}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\uFFFC\u0308\u0020\uAC00", expected: [][]rune{{0xFFFC, 0x0308, 0x0020}, {0xAC00}}},                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\uFFFC\uAC01", expected: [][]rune{{0xFFFC}, {0xAC01}}},                                                                                                                             // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\uFFFC\u0020\uAC01", expected: [][]rune{{0xFFFC, 0x0020}, {0xAC01}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\uFFFC\u0308\uAC01", expected: [][]rune{{0xFFFC, 0x0308}, {0xAC01}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\uFFFC\u0308\u0020\uAC01", expected: [][]rune{{0xFFFC, 0x0308, 0x0020}, {0xAC01}}},                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\uFFFC\u05D0", expected: [][]rune{{0xFFFC}, {0x05D0}}},                                                                                                                             // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\uFFFC\u0020\u05D0", expected: [][]rune{{0xFFFC, 0x0020}, {0x05D0}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\uFFFC\u0308\u05D0", expected: [][]rune{{0xFFFC, 0x0308}, {0x05D0}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\uFFFC\u0308\u0020\u05D0", expected: [][]rune{{0xFFFC, 0x0308, 0x0020}, {0x05D0}}},                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\uFFFC\u002D", expected: [][]rune{{0xFFFC}, {0x002D}}},                                                                                                                             // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\uFFFC\u0020\u002D", expected: [][]rune{{0xFFFC, 0x0020}, {0x002D}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\uFFFC\u0308\u002D", expected: [][]rune{{0xFFFC, 0x0308}, {0x002D}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\uFFFC\u0308\u0020\u002D", expected: [][]rune{{0xFFFC, 0x0308, 0x0020}, {0x002D}}},                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\uFFFC\u231A", expected: [][]rune{{0xFFFC}, {0x231A}}},                                                                                                                             // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] WATCH (ID) ÷ [0.3]
	{original: "\uFFFC\u0020\u231A", expected: [][]rune{{0xFFFC, 0x0020}, {0x231A}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
	{original: "\uFFFC\u0308\u231A", expected: [][]rune{{0xFFFC, 0x0308}, {0x231A}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] WATCH (ID) ÷ [0.3]
	{original: "\uFFFC\u0308\u0020\u231A", expected: [][]rune{{0xFFFC, 0x0308, 0x0020}, {0x231A}}},                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
	{original: "\uFFFC\u2024", expected: [][]rune{{0xFFFC}, {0x2024}}},                                                                                                                             // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\uFFFC\u0020\u2024", expected: [][]rune{{0xFFFC, 0x0020}, {0x2024}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\uFFFC\u0308\u2024", expected: [][]rune{{0xFFFC, 0x0308}, {0x2024}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\uFFFC\u0308\u0020\u2024", expected: [][]rune{{0xFFFC, 0x0308, 0x0020}, {0x2024}}},                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\uFFFC\u002C", expected: [][]rune{{0xFFFC, 0x002C}}},                                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\uFFFC\u0020\u002C", expected: [][]rune{{0xFFFC, 0x0020, 0x002C}}},                                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\uFFFC\u0308\u002C", expected: [][]rune{{0xFFFC, 0x0308, 0x002C}}},                                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
	{original: "\uFFFC\u0308\u0020\u002C", expected: [][]rune{{0xFFFC, 0x0308, 0x0020, 0x002C}}},                                                                                                   // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\uFFFC\u1100", expected: [][]rune{{0xFFFC}, {0x1100}}},                                                                                                                             // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\uFFFC\u0020\u1100", expected: [][]rune{{0xFFFC, 0x0020}, {0x1100}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\uFFFC\u0308\u1100", expected: [][]rune{{0xFFFC, 0x0308}, {0x1100}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\uFFFC\u0308\u0020\u1100", expected: [][]rune{{0xFFFC, 0x0308, 0x0020}, {0x1100}}},                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\uFFFC\u11A8", expected: [][]rune{{0xFFFC}, {0x11A8}}},                                                                                                                             // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\uFFFC\u0020\u11A8", expected: [][]rune{{0xFFFC, 0x0020}, {0x11A8}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\uFFFC\u0308\u11A8", expected: [][]rune{{0xFFFC, 0x0308}, {0x11A8}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\uFFFC\u0308\u0020\u11A8", expected: [][]rune{{0xFFFC, 0x0308, 0x0020}, {0x11A8}}},                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\uFFFC\u1160", expected: [][]rune{{0xFFFC}, {0x1160}}},                                                                                                                             // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\uFFFC\u0020\u1160", expected: [][]rune{{0xFFFC, 0x0020}, {0x1160}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\uFFFC\u0308\u1160", expected: [][]rune{{0xFFFC, 0x0308}, {0x1160}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\uFFFC\u0308\u0020\u1160", expected: [][]rune{{0xFFFC, 0x0308, 0x0020}, {0x1160}}},                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\uFFFC\u000A", expected: [][]rune{{0xFFFC, 0x000A}}},                                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\uFFFC\u0020\u000A", expected: [][]rune{{0xFFFC, 0x0020, 0x000A}}},                                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\uFFFC\u0308\u000A", expected: [][]rune{{0xFFFC, 0x0308, 0x000A}}},                                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\uFFFC\u0308\u0020\u000A", expected: [][]rune{{0xFFFC, 0x0308, 0x0020, 0x000A}}},                                                                                                   // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\uFFFC\u0085", expected: [][]rune{{0xFFFC, 0x0085}}},                                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\uFFFC\u0020\u0085", expected: [][]rune{{0xFFFC, 0x0020, 0x0085}}},                                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\uFFFC\u0308\u0085", expected: [][]rune{{0xFFFC, 0x0308, 0x0085}}},                                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\uFFFC\u0308\u0020\u0085", expected: [][]rune{{0xFFFC, 0x0308, 0x0020, 0x0085}}},                                                                                                   // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\uFFFC\u17D6", expected: [][]rune{{0xFFFC}, {0x17D6}}},                                                                                                                             // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\uFFFC\u0020\u17D6", expected: [][]rune{{0xFFFC, 0x0020}, {0x17D6}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\uFFFC\u0308\u17D6", expected: [][]rune{{0xFFFC, 0x0308}, {0x17D6}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\uFFFC\u0308\u0020\u17D6", expected: [][]rune{{0xFFFC, 0x0308, 0x0020}, {0x17D6}}},                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\uFFFC\u0030", expected: [][]rune{{0xFFFC}, {0x0030}}},                                                                                                                             // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\uFFFC\u0020\u0030", expected: [][]rune{{0xFFFC, 0x0020}, {0x0030}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\uFFFC\u0308\u0030", expected: [][]rune{{0xFFFC, 0x0308}, {0x0030}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\uFFFC\u0308\u0020\u0030", expected: [][]rune{{0xFFFC, 0x0308, 0x0020}, {0x0030}}},                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\uFFFC\u2329", expected: [][]rune{{0xFFFC}, {0x2329}}},                                                                                                                             // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\uFFFC\u0020\u2329", expected: [][]rune{{0xFFFC, 0x0020}, {0x2329}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\uFFFC\u0308\u2329", expected: [][]rune{{0xFFFC, 0x0308}, {0x2329}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\uFFFC\u0308\u0020\u2329", expected: [][]rune{{0xFFFC, 0x0308, 0x0020}, {0x2329}}},                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\uFFFC\u0025", expected: [][]rune{{0xFFFC}, {0x0025}}},                                                                                                                             // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\uFFFC\u0020\u0025", expected: [][]rune{{0xFFFC, 0x0020}, {0x0025}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\uFFFC\u0308\u0025", expected: [][]rune{{0xFFFC, 0x0308}, {0x0025}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\uFFFC\u0308\u0020\u0025", expected: [][]rune{{0xFFFC, 0x0308, 0x0020}, {0x0025}}},                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\uFFFC\u0024", expected: [][]rune{{0xFFFC}, {0x0024}}},                                                                                                                             // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\uFFFC\u0020\u0024", expected: [][]rune{{0xFFFC, 0x0020}, {0x0024}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\uFFFC\u0308\u0024", expected: [][]rune{{0xFFFC, 0x0308}, {0x0024}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\uFFFC\u0308\u0020\u0024", expected: [][]rune{{0xFFFC, 0x0308, 0x0020}, {0x0024}}},                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\uFFFC\u0022", expected: [][]rune{{0xFFFC, 0x0022}}},                                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\uFFFC\u0020\u0022", expected: [][]rune{{0xFFFC, 0x0020}, {0x0022}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\uFFFC\u0308\u0022", expected: [][]rune{{0xFFFC, 0x0308, 0x0022}}},                                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\uFFFC\u0308\u0020\u0022", expected: [][]rune{{0xFFFC, 0x0308, 0x0020}, {0x0022}}},                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\uFFFC\u0020", expected: [][]rune{{0xFFFC, 0x0020}}},                                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\uFFFC\u0020\u0020", expected: [][]rune{{0xFFFC, 0x0020, 0x0020}}},                                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\uFFFC\u0308\u0020", expected: [][]rune{{0xFFFC, 0x0308, 0x0020}}},                                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\uFFFC\u0308\u0020\u0020", expected: [][]rune{{0xFFFC, 0x0308, 0x0020, 0x0020}}},                                                                                                   // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\uFFFC\u002F", expected: [][]rune{{0xFFFC, 0x002F}}},                                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\uFFFC\u0020\u002F", expected: [][]rune{{0xFFFC, 0x0020, 0x002F}}},                                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\uFFFC\u0308\u002F", expected: [][]rune{{0xFFFC, 0x0308, 0x002F}}},                                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
	{original: "\uFFFC\u0308\u0020\u002F", expected: [][]rune{{0xFFFC, 0x0308, 0x0020, 0x002F}}},                                                                                                   // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\uFFFC\u2060", expected: [][]rune{{0xFFFC, 0x2060}}},                                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\uFFFC\u0020\u2060", expected: [][]rune{{0xFFFC, 0x0020, 0x2060}}},                                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\uFFFC\u0308\u2060", expected: [][]rune{{0xFFFC, 0x0308, 0x2060}}},                                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\uFFFC\u0308\u0020\u2060", expected: [][]rune{{0xFFFC, 0x0308, 0x0020, 0x2060}}},                                                                                                   // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\uFFFC\u200B", expected: [][]rune{{0xFFFC, 0x200B}}},                                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\uFFFC\u0020\u200B", expected: [][]rune{{0xFFFC, 0x0020, 0x200B}}},                                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\uFFFC\u0308\u200B", expected: [][]rune{{0xFFFC, 0x0308, 0x200B}}},                                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\uFFFC\u0308\u0020\u200B", expected: [][]rune{{0xFFFC, 0x0308, 0x0020, 0x200B}}},                                                                                                   // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\uFFFC\U0001F1E6", expected: [][]rune{{0xFFFC}, {0x1F1E6}}},                                                                                                                        // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\uFFFC\u0020\U0001F1E6", expected: [][]rune{{0xFFFC, 0x0020}, {0x1F1E6}}},                                                                                                          // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\uFFFC\u0308\U0001F1E6", expected: [][]rune{{0xFFFC, 0x0308}, {0x1F1E6}}},                                                                                                          // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\uFFFC\u0308\u0020\U0001F1E6", expected: [][]rune{{0xFFFC, 0x0308, 0x0020}, {0x1F1E6}}},                                                                                            // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\uFFFC\u261D", expected: [][]rune{{0xFFFC}, {0x261D}}},                                                                                                                             // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\uFFFC\u0020\u261D", expected: [][]rune{{0xFFFC, 0x0020}, {0x261D}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\uFFFC\u0308\u261D", expected: [][]rune{{0xFFFC, 0x0308}, {0x261D}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\uFFFC\u0308\u0020\u261D", expected: [][]rune{{0xFFFC, 0x0308, 0x0020}, {0x261D}}},                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\uFFFC\U0001F3FB", expected: [][]rune{{0xFFFC}, {0x1F3FB}}},                                                                                                                        // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\uFFFC\u0020\U0001F3FB", expected: [][]rune{{0xFFFC, 0x0020}, {0x1F3FB}}},                                                                                                          // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\uFFFC\u0308\U0001F3FB", expected: [][]rune{{0xFFFC, 0x0308}, {0x1F3FB}}},                                                                                                          // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\uFFFC\u0308\u0020\U0001F3FB", expected: [][]rune{{0xFFFC, 0x0308, 0x0020}, {0x1F3FB}}},                                                                                            // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\uFFFC\u0029", expected: [][]rune{{0xFFFC, 0x0029}}},                                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\uFFFC\u0020\u0029", expected: [][]rune{{0xFFFC, 0x0020, 0x0029}}},                                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\uFFFC\u0308\u0029", expected: [][]rune{{0xFFFC, 0x0308, 0x0029}}},                                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\uFFFC\u0308\u0020\u0029", expected: [][]rune{{0xFFFC, 0x0308, 0x0020, 0x0029}}},                                                                                                   // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\uFFFC\u0028", expected: [][]rune{{0xFFFC}, {0x0028}}},                                                                                                                             // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\uFFFC\u0020\u0028", expected: [][]rune{{0xFFFC, 0x0020}, {0x0028}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\uFFFC\u0308\u0028", expected: [][]rune{{0xFFFC, 0x0308}, {0x0028}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\uFFFC\u0308\u0020\u0028", expected: [][]rune{{0xFFFC, 0x0308, 0x0020}, {0x0028}}},                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\uFFFC\u0001", expected: [][]rune{{0xFFFC, 0x0001}}},                                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\uFFFC\u0020\u0001", expected: [][]rune{{0xFFFC, 0x0020}, {0x0001}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\uFFFC\u0308\u0001", expected: [][]rune{{0xFFFC, 0x0308, 0x0001}}},                                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\uFFFC\u0308\u0020\u0001", expected: [][]rune{{0xFFFC, 0x0308, 0x0020}, {0x0001}}},                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\uFFFC\u200D", expected: [][]rune{{0xFFFC, 0x200D}}},                                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\uFFFC\u0020\u200D", expected: [][]rune{{0xFFFC, 0x0020}, {0x200D}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\uFFFC\u0308\u200D", expected: [][]rune{{0xFFFC, 0x0308, 0x200D}}},                                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\uFFFC\u0308\u0020\u200D", expected: [][]rune{{0xFFFC, 0x0308, 0x0020}, {0x200D}}},                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\uFFFC\u00A7", expected: [][]rune{{0xFFFC}, {0x00A7}}},                                                                                                                             // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\uFFFC\u0020\u00A7", expected: [][]rune{{0xFFFC, 0x0020}, {0x00A7}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\uFFFC\u0308\u00A7", expected: [][]rune{{0xFFFC, 0x0308}, {0x00A7}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\uFFFC\u0308\u0020\u00A7", expected: [][]rune{{0xFFFC, 0x0308, 0x0020}, {0x00A7}}},                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\uFFFC\U00050005", expected: [][]rune{{0xFFFC}, {0x50005}}},                                                                                                                        // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\uFFFC\u0020\U00050005", expected: [][]rune{{0xFFFC, 0x0020}, {0x50005}}},                                                                                                          // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\uFFFC\u0308\U00050005", expected: [][]rune{{0xFFFC, 0x0308}, {0x50005}}},                                                                                                          // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\uFFFC\u0308\u0020\U00050005", expected: [][]rune{{0xFFFC, 0x0308, 0x0020}, {0x50005}}},                                                                                            // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\uFFFC\u0E01", expected: [][]rune{{0xFFFC}, {0x0E01}}},                                                                                                                             // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\uFFFC\u0020\u0E01", expected: [][]rune{{0xFFFC, 0x0020}, {0x0E01}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\uFFFC\u0308\u0E01", expected: [][]rune{{0xFFFC, 0x0308}, {0x0E01}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\uFFFC\u0308\u0020\u0E01", expected: [][]rune{{0xFFFC, 0x0308, 0x0020}, {0x0E01}}},                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\uFFFC\u3041", expected: [][]rune{{0xFFFC}, {0x3041}}},                                                                                                                             // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\uFFFC\u0020\u3041", expected: [][]rune{{0xFFFC, 0x0020}, {0x3041}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\uFFFC\u0308\u3041", expected: [][]rune{{0xFFFC, 0x0308}, {0x3041}}},                                                                                                               // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\uFFFC\u0308\u0020\u3041", expected: [][]rune{{0xFFFC, 0x0308, 0x0020}, {0x3041}}},                                                                                                 // × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u007D\u0023", expected: [][]rune{{0x007D}, {0x0023}}},                                                                                                                             // × [0.3] RIGHT CURLY BRACKET (CL) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u007D\u0020\u0023", expected: [][]rune{{0x007D, 0x0020}, {0x0023}}},                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u007D\u0308\u0023", expected: [][]rune{{0x007D, 0x0308}, {0x0023}}},                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u007D\u0308\u0020\u0023", expected: [][]rune{{0x007D, 0x0308, 0x0020}, {0x0023}}},                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u007D\u2014", expected: [][]rune{{0x007D}, {0x2014}}},                                                                                                                             // × [0.3] RIGHT CURLY BRACKET (CL) ÷ [999.0] EM DASH (B2) ÷ [0.3]
	{original: "\u007D\u0020\u2014", expected: [][]rune{{0x007D, 0x0020}, {0x2014}}},                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
	{original: "\u007D\u0308\u2014", expected: [][]rune{{0x007D, 0x0308}, {0x2014}}},                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
	{original: "\u007D\u0308\u0020\u2014", expected: [][]rune{{0x007D, 0x0308, 0x0020}, {0x2014}}},                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
	{original: "\u007D\u0009", expected: [][]rune{{0x007D, 0x0009}}},                                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u007D\u0020\u0009", expected: [][]rune{{0x007D, 0x0020}, {0x0009}}},                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u007D\u0308\u0009", expected: [][]rune{{0x007D, 0x0308, 0x0009}}},                                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u007D\u0308\u0020\u0009", expected: [][]rune{{0x007D, 0x0308, 0x0020}, {0x0009}}},                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u007D\u00B4", expected: [][]rune{{0x007D}, {0x00B4}}},                                                                                                                             // × [0.3] RIGHT CURLY BRACKET (CL) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u007D\u0020\u00B4", expected: [][]rune{{0x007D, 0x0020}, {0x00B4}}},                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u007D\u0308\u00B4", expected: [][]rune{{0x007D, 0x0308}, {0x00B4}}},                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u007D\u0308\u0020\u00B4", expected: [][]rune{{0x007D, 0x0308, 0x0020}, {0x00B4}}},                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u007D\u000B", expected: [][]rune{{0x007D, 0x000B}}},                                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u007D\u0020\u000B", expected: [][]rune{{0x007D, 0x0020, 0x000B}}},                                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u007D\u0308\u000B", expected: [][]rune{{0x007D, 0x0308, 0x000B}}},                                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u007D\u0308\u0020\u000B", expected: [][]rune{{0x007D, 0x0308, 0x0020, 0x000B}}},                                                                                                   // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u007D\uFFFC", expected: [][]rune{{0x007D}, {0xFFFC}}},                                                                                                                             // × [0.3] RIGHT CURLY BRACKET (CL) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u007D\u0020\uFFFC", expected: [][]rune{{0x007D, 0x0020}, {0xFFFC}}},                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u007D\u0308\uFFFC", expected: [][]rune{{0x007D, 0x0308}, {0xFFFC}}},                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u007D\u0308\u0020\uFFFC", expected: [][]rune{{0x007D, 0x0308, 0x0020}, {0xFFFC}}},                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u007D\u007D", expected: [][]rune{{0x007D, 0x007D}}},                                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u007D\u0020\u007D", expected: [][]rune{{0x007D, 0x0020, 0x007D}}},                                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u007D\u0308\u007D", expected: [][]rune{{0x007D, 0x0308, 0x007D}}},                                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u007D\u0308\u0020\u007D", expected: [][]rune{{0x007D, 0x0308, 0x0020, 0x007D}}},                                                                                                   // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u007D\u000D", expected: [][]rune{{0x007D, 0x000D}}},                                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u007D\u0020\u000D", expected: [][]rune{{0x007D, 0x0020, 0x000D}}},                                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u007D\u0308\u000D", expected: [][]rune{{0x007D, 0x0308, 0x000D}}},                                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u007D\u0308\u0020\u000D", expected: [][]rune{{0x007D, 0x0308, 0x0020, 0x000D}}},                                                                                                   // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u007D\u0021", expected: [][]rune{{0x007D, 0x0021}}},                                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u007D\u0020\u0021", expected: [][]rune{{0x007D, 0x0020, 0x0021}}},                                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u007D\u0308\u0021", expected: [][]rune{{0x007D, 0x0308, 0x0021}}},                                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u007D\u0308\u0020\u0021", expected: [][]rune{{0x007D, 0x0308, 0x0020, 0x0021}}},                                                                                                   // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u007D\u00A0", expected: [][]rune{{0x007D, 0x00A0}}},                                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [12.1] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u007D\u0020\u00A0", expected: [][]rune{{0x007D, 0x0020}, {0x00A0}}},                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u007D\u0308\u00A0", expected: [][]rune{{0x007D, 0x0308, 0x00A0}}},                                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u007D\u0308\u0020\u00A0", expected: [][]rune{{0x007D, 0x0308, 0x0020}, {0x00A0}}},                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u007D\uAC00", expected: [][]rune{{0x007D}, {0xAC00}}},                                                                                                                             // × [0.3] RIGHT CURLY BRACKET (CL) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u007D\u0020\uAC00", expected: [][]rune{{0x007D, 0x0020}, {0xAC00}}},                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u007D\u0308\uAC00", expected: [][]rune{{0x007D, 0x0308}, {0xAC00}}},                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u007D\u0308\u0020\uAC00", expected: [][]rune{{0x007D, 0x0308, 0x0020}, {0xAC00}}},                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u007D\uAC01", expected: [][]rune{{0x007D}, {0xAC01}}},                                                                                                                             // × [0.3] RIGHT CURLY BRACKET (CL) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u007D\u0020\uAC01", expected: [][]rune{{0x007D, 0x0020}, {0xAC01}}},                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u007D\u0308\uAC01", expected: [][]rune{{0x007D, 0x0308}, {0xAC01}}},                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u007D\u0308\u0020\uAC01", expected: [][]rune{{0x007D, 0x0308, 0x0020}, {0xAC01}}},                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u007D\u05D0", expected: [][]rune{{0x007D}, {0x05D0}}},                                                                                                                             // × [0.3] RIGHT CURLY BRACKET (CL) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u007D\u0020\u05D0", expected: [][]rune{{0x007D, 0x0020}, {0x05D0}}},                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u007D\u0308\u05D0", expected: [][]rune{{0x007D, 0x0308}, {0x05D0}}},                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u007D\u0308\u0020\u05D0", expected: [][]rune{{0x007D, 0x0308, 0x0020}, {0x05D0}}},                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u007D\u002D", expected: [][]rune{{0x007D, 0x002D}}},                                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u007D\u0020\u002D", expected: [][]rune{{0x007D, 0x0020}, {0x002D}}},                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u007D\u0308\u002D", expected: [][]rune{{0x007D, 0x0308, 0x002D}}},                                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u007D\u0308\u0020\u002D", expected: [][]rune{{0x007D, 0x0308, 0x0020}, {0x002D}}},                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u007D\u231A", expected: [][]rune{{0x007D}, {0x231A}}},                                                                                                                             // × [0.3] RIGHT CURLY BRACKET (CL) ÷ [999.0] WATCH (ID) ÷ [0.3]
	{original: "\u007D\u0020\u231A", expected: [][]rune{{0x007D, 0x0020}, {0x231A}}},                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
	{original: "\u007D\u0308\u231A", expected: [][]rune{{0x007D, 0x0308}, {0x231A}}},                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
	{original: "\u007D\u0308\u0020\u231A", expected: [][]rune{{0x007D, 0x0308, 0x0020}, {0x231A}}},                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
	{original: "\u007D\u2024", expected: [][]rune{{0x007D, 0x2024}}},                                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u007D\u0020\u2024", expected: [][]rune{{0x007D, 0x0020}, {0x2024}}},                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u007D\u0308\u2024", expected: [][]rune{{0x007D, 0x0308, 0x2024}}},                                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u007D\u0308\u0020\u2024", expected: [][]rune{{0x007D, 0x0308, 0x0020}, {0x2024}}},                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u007D\u002C", expected: [][]rune{{0x007D, 0x002C}}},                                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u007D\u0020\u002C", expected: [][]rune{{0x007D, 0x0020, 0x002C}}},                                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u007D\u0308\u002C", expected: [][]rune{{0x007D, 0x0308, 0x002C}}},                                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
	{original: "\u007D\u0308\u0020\u002C", expected: [][]rune{{0x007D, 0x0308, 0x0020, 0x002C}}},                                                                                                   // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u007D\u1100", expected: [][]rune{{0x007D}, {0x1100}}},                                                                                                                             // × [0.3] RIGHT CURLY BRACKET (CL) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u007D\u0020\u1100", expected: [][]rune{{0x007D, 0x0020}, {0x1100}}},                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u007D\u0308\u1100", expected: [][]rune{{0x007D, 0x0308}, {0x1100}}},                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u007D\u0308\u0020\u1100", expected: [][]rune{{0x007D, 0x0308, 0x0020}, {0x1100}}},                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u007D\u11A8", expected: [][]rune{{0x007D}, {0x11A8}}},                                                                                                                             // × [0.3] RIGHT CURLY BRACKET (CL) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u007D\u0020\u11A8", expected: [][]rune{{0x007D, 0x0020}, {0x11A8}}},                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u007D\u0308\u11A8", expected: [][]rune{{0x007D, 0x0308}, {0x11A8}}},                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u007D\u0308\u0020\u11A8", expected: [][]rune{{0x007D, 0x0308, 0x0020}, {0x11A8}}},                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u007D\u1160", expected: [][]rune{{0x007D}, {0x1160}}},                                                                                                                             // × [0.3] RIGHT CURLY BRACKET (CL) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u007D\u0020\u1160", expected: [][]rune{{0x007D, 0x0020}, {0x1160}}},                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u007D\u0308\u1160", expected: [][]rune{{0x007D, 0x0308}, {0x1160}}},                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u007D\u0308\u0020\u1160", expected: [][]rune{{0x007D, 0x0308, 0x0020}, {0x1160}}},                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u007D\u000A", expected: [][]rune{{0x007D, 0x000A}}},                                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u007D\u0020\u000A", expected: [][]rune{{0x007D, 0x0020, 0x000A}}},                                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u007D\u0308\u000A", expected: [][]rune{{0x007D, 0x0308, 0x000A}}},                                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u007D\u0308\u0020\u000A", expected: [][]rune{{0x007D, 0x0308, 0x0020, 0x000A}}},                                                                                                   // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u007D\u0085", expected: [][]rune{{0x007D, 0x0085}}},                                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u007D\u0020\u0085", expected: [][]rune{{0x007D, 0x0020, 0x0085}}},                                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u007D\u0308\u0085", expected: [][]rune{{0x007D, 0x0308, 0x0085}}},                                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u007D\u0308\u0020\u0085", expected: [][]rune{{0x007D, 0x0308, 0x0020, 0x0085}}},                                                                                                   // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u007D\u17D6", expected: [][]rune{{0x007D, 0x17D6}}},                                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [16.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u007D\u0020\u17D6", expected: [][]rune{{0x007D, 0x0020, 0x17D6}}},                                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) × [16.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u007D\u0308\u17D6", expected: [][]rune{{0x007D, 0x0308, 0x17D6}}},                                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [16.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u007D\u0308\u0020\u17D6", expected: [][]rune{{0x007D, 0x0308, 0x0020, 0x17D6}}},                                                                                                   // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [16.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u007D\u0030", expected: [][]rune{{0x007D}, {0x0030}}},                                                                                                                             // × [0.3] RIGHT CURLY BRACKET (CL) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u007D\u0020\u0030", expected: [][]rune{{0x007D, 0x0020}, {0x0030}}},                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u007D\u0308\u0030", expected: [][]rune{{0x007D, 0x0308}, {0x0030}}},                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u007D\u0308\u0020\u0030", expected: [][]rune{{0x007D, 0x0308, 0x0020}, {0x0030}}},                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u007D\u2329", expected: [][]rune{{0x007D}, {0x2329}}},                                                                                                                             // × [0.3] RIGHT CURLY BRACKET (CL) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u007D\u0020\u2329", expected: [][]rune{{0x007D, 0x0020}, {0x2329}}},                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u007D\u0308\u2329", expected: [][]rune{{0x007D, 0x0308}, {0x2329}}},                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u007D\u0308\u0020\u2329", expected: [][]rune{{0x007D, 0x0308, 0x0020}, {0x2329}}},                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u007D\u0025", expected: [][]rune{{0x007D}, {0x0025}}},                                                                                                                             // × [0.3] RIGHT CURLY BRACKET (CL) ÷ [999.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u007D\u0020\u0025", expected: [][]rune{{0x007D, 0x0020}, {0x0025}}},                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u007D\u0308\u0025", expected: [][]rune{{0x007D, 0x0308}, {0x0025}}},                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u007D\u0308\u0020\u0025", expected: [][]rune{{0x007D, 0x0308, 0x0020}, {0x0025}}},                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u007D\u0024", expected: [][]rune{{0x007D}, {0x0024}}},                                                                                                                             // × [0.3] RIGHT CURLY BRACKET (CL) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u007D\u0020\u0024", expected: [][]rune{{0x007D, 0x0020}, {0x0024}}},                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u007D\u0308\u0024", expected: [][]rune{{0x007D, 0x0308}, {0x0024}}},                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u007D\u0308\u0020\u0024", expected: [][]rune{{0x007D, 0x0308, 0x0020}, {0x0024}}},                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u007D\u0022", expected: [][]rune{{0x007D, 0x0022}}},                                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u007D\u0020\u0022", expected: [][]rune{{0x007D, 0x0020}, {0x0022}}},                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u007D\u0308\u0022", expected: [][]rune{{0x007D, 0x0308, 0x0022}}},                                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u007D\u0308\u0020\u0022", expected: [][]rune{{0x007D, 0x0308, 0x0020}, {0x0022}}},                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u007D\u0020", expected: [][]rune{{0x007D, 0x0020}}},                                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u007D\u0020\u0020", expected: [][]rune{{0x007D, 0x0020, 0x0020}}},                                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u007D\u0308\u0020", expected: [][]rune{{0x007D, 0x0308, 0x0020}}},                                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u007D\u0308\u0020\u0020", expected: [][]rune{{0x007D, 0x0308, 0x0020, 0x0020}}},                                                                                                   // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u007D\u002F", expected: [][]rune{{0x007D, 0x002F}}},                                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\u007D\u0020\u002F", expected: [][]rune{{0x007D, 0x0020, 0x002F}}},                                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\u007D\u0308\u002F", expected: [][]rune{{0x007D, 0x0308, 0x002F}}},                                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
	{original: "\u007D\u0308\u0020\u002F", expected: [][]rune{{0x007D, 0x0308, 0x0020, 0x002F}}},                                                                                                   // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\u007D\u2060", expected: [][]rune{{0x007D, 0x2060}}},                                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u007D\u0020\u2060", expected: [][]rune{{0x007D, 0x0020, 0x2060}}},                                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u007D\u0308\u2060", expected: [][]rune{{0x007D, 0x0308, 0x2060}}},                                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u007D\u0308\u0020\u2060", expected: [][]rune{{0x007D, 0x0308, 0x0020, 0x2060}}},                                                                                                   // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u007D\u200B", expected: [][]rune{{0x007D, 0x200B}}},                                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u007D\u0020\u200B", expected: [][]rune{{0x007D, 0x0020, 0x200B}}},                                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u007D\u0308\u200B", expected: [][]rune{{0x007D, 0x0308, 0x200B}}},                                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u007D\u0308\u0020\u200B", expected: [][]rune{{0x007D, 0x0308, 0x0020, 0x200B}}},                                                                                                   // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u007D\U0001F1E6", expected: [][]rune{{0x007D}, {0x1F1E6}}},                                                                                                                        // × [0.3] RIGHT CURLY BRACKET (CL) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u007D\u0020\U0001F1E6", expected: [][]rune{{0x007D, 0x0020}, {0x1F1E6}}},                                                                                                          // × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u007D\u0308\U0001F1E6", expected: [][]rune{{0x007D, 0x0308}, {0x1F1E6}}},                                                                                                          // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u007D\u0308\u0020\U0001F1E6", expected: [][]rune{{0x007D, 0x0308, 0x0020}, {0x1F1E6}}},                                                                                            // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u007D\u261D", expected: [][]rune{{0x007D}, {0x261D}}},                                                                                                                             // × [0.3] RIGHT CURLY BRACKET (CL) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u007D\u0020\u261D", expected: [][]rune{{0x007D, 0x0020}, {0x261D}}},                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u007D\u0308\u261D", expected: [][]rune{{0x007D, 0x0308}, {0x261D}}},                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u007D\u0308\u0020\u261D", expected: [][]rune{{0x007D, 0x0308, 0x0020}, {0x261D}}},                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u007D\U0001F3FB", expected: [][]rune{{0x007D}, {0x1F3FB}}},                                                                                                                        // × [0.3] RIGHT CURLY BRACKET (CL) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u007D\u0020\U0001F3FB", expected: [][]rune{{0x007D, 0x0020}, {0x1F3FB}}},                                                                                                          // × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u007D\u0308\U0001F3FB", expected: [][]rune{{0x007D, 0x0308}, {0x1F3FB}}},                                                                                                          // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u007D\u0308\u0020\U0001F3FB", expected: [][]rune{{0x007D, 0x0308, 0x0020}, {0x1F3FB}}},                                                                                            // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u007D\u0029", expected: [][]rune{{0x007D, 0x0029}}},                                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u007D\u0020\u0029", expected: [][]rune{{0x007D, 0x0020, 0x0029}}},                                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u007D\u0308\u0029", expected: [][]rune{{0x007D, 0x0308, 0x0029}}},                                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u007D\u0308\u0020\u0029", expected: [][]rune{{0x007D, 0x0308, 0x0020, 0x0029}}},                                                                                                   // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u007D\u0028", expected: [][]rune{{0x007D}, {0x0028}}},                                                                                                                             // × [0.3] RIGHT CURLY BRACKET (CL) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u007D\u0020\u0028", expected: [][]rune{{0x007D, 0x0020}, {0x0028}}},                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u007D\u0308\u0028", expected: [][]rune{{0x007D, 0x0308}, {0x0028}}},                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u007D\u0308\u0020\u0028", expected: [][]rune{{0x007D, 0x0308, 0x0020}, {0x0028}}},                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u007D\u0001", expected: [][]rune{{0x007D, 0x0001}}},                                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u007D\u0020\u0001", expected: [][]rune{{0x007D, 0x0020}, {0x0001}}},                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u007D\u0308\u0001", expected: [][]rune{{0x007D, 0x0308, 0x0001}}},                                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u007D\u0308\u0020\u0001", expected: [][]rune{{0x007D, 0x0308, 0x0020}, {0x0001}}},                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u007D\u200D", expected: [][]rune{{0x007D, 0x200D}}},                                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u007D\u0020\u200D", expected: [][]rune{{0x007D, 0x0020}, {0x200D}}},                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u007D\u0308\u200D", expected: [][]rune{{0x007D, 0x0308, 0x200D}}},                                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u007D\u0308\u0020\u200D", expected: [][]rune{{0x007D, 0x0308, 0x0020}, {0x200D}}},                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u007D\u00A7", expected: [][]rune{{0x007D}, {0x00A7}}},                                                                                                                             // × [0.3] RIGHT CURLY BRACKET (CL) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u007D\u0020\u00A7", expected: [][]rune{{0x007D, 0x0020}, {0x00A7}}},                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u007D\u0308\u00A7", expected: [][]rune{{0x007D, 0x0308}, {0x00A7}}},                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u007D\u0308\u0020\u00A7", expected: [][]rune{{0x007D, 0x0308, 0x0020}, {0x00A7}}},                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u007D\U00050005", expected: [][]rune{{0x007D}, {0x50005}}},                                                                                                                        // × [0.3] RIGHT CURLY BRACKET (CL) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u007D\u0020\U00050005", expected: [][]rune{{0x007D, 0x0020}, {0x50005}}},                                                                                                          // × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u007D\u0308\U00050005", expected: [][]rune{{0x007D, 0x0308}, {0x50005}}},                                                                                                          // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u007D\u0308\u0020\U00050005", expected: [][]rune{{0x007D, 0x0308, 0x0020}, {0x50005}}},                                                                                            // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u007D\u0E01", expected: [][]rune{{0x007D}, {0x0E01}}},                                                                                                                             // × [0.3] RIGHT CURLY BRACKET (CL) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u007D\u0020\u0E01", expected: [][]rune{{0x007D, 0x0020}, {0x0E01}}},                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u007D\u0308\u0E01", expected: [][]rune{{0x007D, 0x0308}, {0x0E01}}},                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u007D\u0308\u0020\u0E01", expected: [][]rune{{0x007D, 0x0308, 0x0020}, {0x0E01}}},                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u007D\u3041", expected: [][]rune{{0x007D, 0x3041}}},                                                                                                                               // × [0.3] RIGHT CURLY BRACKET (CL) × [16.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u007D\u0020\u3041", expected: [][]rune{{0x007D, 0x0020, 0x3041}}},                                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) × [16.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u007D\u0308\u3041", expected: [][]rune{{0x007D, 0x0308, 0x3041}}},                                                                                                                 // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [16.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u007D\u0308\u0020\u3041", expected: [][]rune{{0x007D, 0x0308, 0x0020, 0x3041}}},                                                                                                   // × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [16.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u000D\u0023", expected: [][]rune{{0x000D}, {0x0023}}},                                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u000D\u0020\u0023", expected: [][]rune{{0x000D}, {0x0020}, {0x0023}}},                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u000D\u0308\u0023", expected: [][]rune{{0x000D}, {0x0308, 0x0023}}},                                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [28.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u000D\u0308\u0020\u0023", expected: [][]rune{{0x000D}, {0x0308, 0x0020}, {0x0023}}},                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u000D\u2014", expected: [][]rune{{0x000D}, {0x2014}}},                                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] EM DASH (B2) ÷ [0.3]
	{original: "\u000D\u0020\u2014", expected: [][]rune{{0x000D}, {0x0020}, {0x2014}}},                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
	{original: "\u000D\u0308\u2014", expected: [][]rune{{0x000D}, {0x0308}, {0x2014}}},                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
	{original: "\u000D\u0308\u0020\u2014", expected: [][]rune{{0x000D}, {0x0308, 0x0020}, {0x2014}}},                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
	{original: "\u000D\u0009", expected: [][]rune{{0x000D}, {0x0009}}},                                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u000D\u0020\u0009", expected: [][]rune{{0x000D}, {0x0020}, {0x0009}}},                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u000D\u0308\u0009", expected: [][]rune{{0x000D}, {0x0308, 0x0009}}},                                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u000D\u0308\u0020\u0009", expected: [][]rune{{0x000D}, {0x0308, 0x0020}, {0x0009}}},                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u000D\u00B4", expected: [][]rune{{0x000D}, {0x00B4}}},                                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u000D\u0020\u00B4", expected: [][]rune{{0x000D}, {0x0020}, {0x00B4}}},                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u000D\u0308\u00B4", expected: [][]rune{{0x000D}, {0x0308}, {0x00B4}}},                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u000D\u0308\u0020\u00B4", expected: [][]rune{{0x000D}, {0x0308, 0x0020}, {0x00B4}}},                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u000D\u000B", expected: [][]rune{{0x000D}, {0x000B}}},                                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u000D\u0020\u000B", expected: [][]rune{{0x000D}, {0x0020, 0x000B}}},                                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u000D\u0308\u000B", expected: [][]rune{{0x000D}, {0x0308, 0x000B}}},                                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u000D\u0308\u0020\u000B", expected: [][]rune{{0x000D}, {0x0308, 0x0020, 0x000B}}},                                                                                                 // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u000D\uFFFC", expected: [][]rune{{0x000D}, {0xFFFC}}},                                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u000D\u0020\uFFFC", expected: [][]rune{{0x000D}, {0x0020}, {0xFFFC}}},                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u000D\u0308\uFFFC", expected: [][]rune{{0x000D}, {0x0308}, {0xFFFC}}},                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u000D\u0308\u0020\uFFFC", expected: [][]rune{{0x000D}, {0x0308, 0x0020}, {0xFFFC}}},                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u000D\u007D", expected: [][]rune{{0x000D}, {0x007D}}},                                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u000D\u0020\u007D", expected: [][]rune{{0x000D}, {0x0020, 0x007D}}},                                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u000D\u0308\u007D", expected: [][]rune{{0x000D}, {0x0308, 0x007D}}},                                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u000D\u0308\u0020\u007D", expected: [][]rune{{0x000D}, {0x0308, 0x0020, 0x007D}}},                                                                                                 // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u000D\u000D", expected: [][]rune{{0x000D}, {0x000D}}},                                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u000D\u0020\u000D", expected: [][]rune{{0x000D}, {0x0020, 0x000D}}},                                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u000D\u0308\u000D", expected: [][]rune{{0x000D}, {0x0308, 0x000D}}},                                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u000D\u0308\u0020\u000D", expected: [][]rune{{0x000D}, {0x0308, 0x0020, 0x000D}}},                                                                                                 // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u000D\u0021", expected: [][]rune{{0x000D}, {0x0021}}},                                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u000D\u0020\u0021", expected: [][]rune{{0x000D}, {0x0020, 0x0021}}},                                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u000D\u0308\u0021", expected: [][]rune{{0x000D}, {0x0308, 0x0021}}},                                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u000D\u0308\u0020\u0021", expected: [][]rune{{0x000D}, {0x0308, 0x0020, 0x0021}}},                                                                                                 // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u000D\u00A0", expected: [][]rune{{0x000D}, {0x00A0}}},                                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u000D\u0020\u00A0", expected: [][]rune{{0x000D}, {0x0020}, {0x00A0}}},                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u000D\u0308\u00A0", expected: [][]rune{{0x000D}, {0x0308, 0x00A0}}},                                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u000D\u0308\u0020\u00A0", expected: [][]rune{{0x000D}, {0x0308, 0x0020}, {0x00A0}}},                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u000D\uAC00", expected: [][]rune{{0x000D}, {0xAC00}}},                                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u000D\u0020\uAC00", expected: [][]rune{{0x000D}, {0x0020}, {0xAC00}}},                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u000D\u0308\uAC00", expected: [][]rune{{0x000D}, {0x0308}, {0xAC00}}},                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u000D\u0308\u0020\uAC00", expected: [][]rune{{0x000D}, {0x0308, 0x0020}, {0xAC00}}},                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u000D\uAC01", expected: [][]rune{{0x000D}, {0xAC01}}},                                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u000D\u0020\uAC01", expected: [][]rune{{0x000D}, {0x0020}, {0xAC01}}},                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u000D\u0308\uAC01", expected: [][]rune{{0x000D}, {0x0308}, {0xAC01}}},                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u000D\u0308\u0020\uAC01", expected: [][]rune{{0x000D}, {0x0308, 0x0020}, {0xAC01}}},                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u000D\u05D0", expected: [][]rune{{0x000D}, {0x05D0}}},                                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u000D\u0020\u05D0", expected: [][]rune{{0x000D}, {0x0020}, {0x05D0}}},                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u000D\u0308\u05D0", expected: [][]rune{{0x000D}, {0x0308, 0x05D0}}},                                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [28.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u000D\u0308\u0020\u05D0", expected: [][]rune{{0x000D}, {0x0308, 0x0020}, {0x05D0}}},                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u000D\u002D", expected: [][]rune{{0x000D}, {0x002D}}},                                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u000D\u0020\u002D", expected: [][]rune{{0x000D}, {0x0020}, {0x002D}}},                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u000D\u0308\u002D", expected: [][]rune{{0x000D}, {0x0308, 0x002D}}},                                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u000D\u0308\u0020\u002D", expected: [][]rune{{0x000D}, {0x0308, 0x0020}, {0x002D}}},                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u000D\u231A", expected: [][]rune{{0x000D}, {0x231A}}},                                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] WATCH (ID) ÷ [0.3]
	{original: "\u000D\u0020\u231A", expected: [][]rune{{0x000D}, {0x0020}, {0x231A}}},                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
	{original: "\u000D\u0308\u231A", expected: [][]rune{{0x000D}, {0x0308}, {0x231A}}},                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
	{original: "\u000D\u0308\u0020\u231A", expected: [][]rune{{0x000D}, {0x0308, 0x0020}, {0x231A}}},                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
	{original: "\u000D\u2024", expected: [][]rune{{0x000D}, {0x2024}}},                                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u000D\u0020\u2024", expected: [][]rune{{0x000D}, {0x0020}, {0x2024}}},                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u000D\u0308\u2024", expected: [][]rune{{0x000D}, {0x0308, 0x2024}}},                                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u000D\u0308\u0020\u2024", expected: [][]rune{{0x000D}, {0x0308, 0x0020}, {0x2024}}},                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u000D\u002C", expected: [][]rune{{0x000D}, {0x002C}}},                                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMMA (IS) ÷ [0.3]
	{original: "\u000D\u0020\u002C", expected: [][]rune{{0x000D}, {0x0020, 0x002C}}},                                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u000D\u0308\u002C", expected: [][]rune{{0x000D}, {0x0308, 0x002C}}},                                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
	{original: "\u000D\u0308\u0020\u002C", expected: [][]rune{{0x000D}, {0x0308, 0x0020, 0x002C}}},                                                                                                 // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u000D\u1100", expected: [][]rune{{0x000D}, {0x1100}}},                                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u000D\u0020\u1100", expected: [][]rune{{0x000D}, {0x0020}, {0x1100}}},                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u000D\u0308\u1100", expected: [][]rune{{0x000D}, {0x0308}, {0x1100}}},                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u000D\u0308\u0020\u1100", expected: [][]rune{{0x000D}, {0x0308, 0x0020}, {0x1100}}},                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u000D\u11A8", expected: [][]rune{{0x000D}, {0x11A8}}},                                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u000D\u0020\u11A8", expected: [][]rune{{0x000D}, {0x0020}, {0x11A8}}},                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u000D\u0308\u11A8", expected: [][]rune{{0x000D}, {0x0308}, {0x11A8}}},                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u000D\u0308\u0020\u11A8", expected: [][]rune{{0x000D}, {0x0308, 0x0020}, {0x11A8}}},                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u000D\u1160", expected: [][]rune{{0x000D}, {0x1160}}},                                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u000D\u0020\u1160", expected: [][]rune{{0x000D}, {0x0020}, {0x1160}}},                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u000D\u0308\u1160", expected: [][]rune{{0x000D}, {0x0308}, {0x1160}}},                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u000D\u0308\u0020\u1160", expected: [][]rune{{0x000D}, {0x0308, 0x0020}, {0x1160}}},                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u000D\u000A", expected: [][]rune{{0x000D, 0x000A}}},                                                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) × [5.01] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u000D\u0020\u000A", expected: [][]rune{{0x000D}, {0x0020, 0x000A}}},                                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u000D\u0308\u000A", expected: [][]rune{{0x000D}, {0x0308, 0x000A}}},                                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u000D\u0308\u0020\u000A", expected: [][]rune{{0x000D}, {0x0308, 0x0020, 0x000A}}},                                                                                                 // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u000D\u0085", expected: [][]rune{{0x000D}, {0x0085}}},                                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u000D\u0020\u0085", expected: [][]rune{{0x000D}, {0x0020, 0x0085}}},                                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u000D\u0308\u0085", expected: [][]rune{{0x000D}, {0x0308, 0x0085}}},                                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u000D\u0308\u0020\u0085", expected: [][]rune{{0x000D}, {0x0308, 0x0020, 0x0085}}},                                                                                                 // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u000D\u17D6", expected: [][]rune{{0x000D}, {0x17D6}}},                                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u000D\u0020\u17D6", expected: [][]rune{{0x000D}, {0x0020}, {0x17D6}}},                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u000D\u0308\u17D6", expected: [][]rune{{0x000D}, {0x0308, 0x17D6}}},                                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u000D\u0308\u0020\u17D6", expected: [][]rune{{0x000D}, {0x0308, 0x0020}, {0x17D6}}},                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u000D\u0030", expected: [][]rune{{0x000D}, {0x0030}}},                                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u000D\u0020\u0030", expected: [][]rune{{0x000D}, {0x0020}, {0x0030}}},                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u000D\u0308\u0030", expected: [][]rune{{0x000D}, {0x0308, 0x0030}}},                                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [23.02] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u000D\u0308\u0020\u0030", expected: [][]rune{{0x000D}, {0x0308, 0x0020}, {0x0030}}},                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u000D\u2329", expected: [][]rune{{0x000D}, {0x2329}}},                                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u000D\u0020\u2329", expected: [][]rune{{0x000D}, {0x0020}, {0x2329}}},                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u000D\u0308\u2329", expected: [][]rune{{0x000D}, {0x0308}, {0x2329}}},                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u000D\u0308\u0020\u2329", expected: [][]rune{{0x000D}, {0x0308, 0x0020}, {0x2329}}},                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u000D\u0025", expected: [][]rune{{0x000D}, {0x0025}}},                                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u000D\u0020\u0025", expected: [][]rune{{0x000D}, {0x0020}, {0x0025}}},                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u000D\u0308\u0025", expected: [][]rune{{0x000D}, {0x0308, 0x0025}}},                                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [24.03] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u000D\u0308\u0020\u0025", expected: [][]rune{{0x000D}, {0x0308, 0x0020}, {0x0025}}},                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u000D\u0024", expected: [][]rune{{0x000D}, {0x0024}}},                                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u000D\u0020\u0024", expected: [][]rune{{0x000D}, {0x0020}, {0x0024}}},                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u000D\u0308\u0024", expected: [][]rune{{0x000D}, {0x0308, 0x0024}}},                                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [24.03] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u000D\u0308\u0020\u0024", expected: [][]rune{{0x000D}, {0x0308, 0x0020}, {0x0024}}},                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u000D\u0022", expected: [][]rune{{0x000D}, {0x0022}}},                                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u000D\u0020\u0022", expected: [][]rune{{0x000D}, {0x0020}, {0x0022}}},                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u000D\u0308\u0022", expected: [][]rune{{0x000D}, {0x0308, 0x0022}}},                                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u000D\u0308\u0020\u0022", expected: [][]rune{{0x000D}, {0x0308, 0x0020}, {0x0022}}},                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u000D\u0020", expected: [][]rune{{0x000D}, {0x0020}}},                                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [0.3]
	{original: "\u000D\u0020\u0020", expected: [][]rune{{0x000D}, {0x0020, 0x0020}}},                                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u000D\u0308\u0020", expected: [][]rune{{0x000D}, {0x0308, 0x0020}}},                                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u000D\u0308\u0020\u0020", expected: [][]rune{{0x000D}, {0x0308, 0x0020, 0x0020}}},                                                                                                 // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u000D\u002F", expected: [][]rune{{0x000D}, {0x002F}}},                                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\u000D\u0020\u002F", expected: [][]rune{{0x000D}, {0x0020, 0x002F}}},                                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\u000D\u0308\u002F", expected: [][]rune{{0x000D}, {0x0308, 0x002F}}},                                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
	{original: "\u000D\u0308\u0020\u002F", expected: [][]rune{{0x000D}, {0x0308, 0x0020, 0x002F}}},                                                                                                 // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\u000D\u2060", expected: [][]rune{{0x000D}, {0x2060}}},                                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u000D\u0020\u2060", expected: [][]rune{{0x000D}, {0x0020, 0x2060}}},                                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u000D\u0308\u2060", expected: [][]rune{{0x000D}, {0x0308, 0x2060}}},                                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u000D\u0308\u0020\u2060", expected: [][]rune{{0x000D}, {0x0308, 0x0020, 0x2060}}},                                                                                                 // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u000D\u200B", expected: [][]rune{{0x000D}, {0x200B}}},                                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u000D\u0020\u200B", expected: [][]rune{{0x000D}, {0x0020, 0x200B}}},                                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u000D\u0308\u200B", expected: [][]rune{{0x000D}, {0x0308, 0x200B}}},                                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u000D\u0308\u0020\u200B", expected: [][]rune{{0x000D}, {0x0308, 0x0020, 0x200B}}},                                                                                                 // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u000D\U0001F1E6", expected: [][]rune{{0x000D}, {0x1F1E6}}},                                                                                                                        // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u000D\u0020\U0001F1E6", expected: [][]rune{{0x000D}, {0x0020}, {0x1F1E6}}},                                                                                                        // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u000D\u0308\U0001F1E6", expected: [][]rune{{0x000D}, {0x0308}, {0x1F1E6}}},                                                                                                        // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u000D\u0308\u0020\U0001F1E6", expected: [][]rune{{0x000D}, {0x0308, 0x0020}, {0x1F1E6}}},                                                                                          // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u000D\u261D", expected: [][]rune{{0x000D}, {0x261D}}},                                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u000D\u0020\u261D", expected: [][]rune{{0x000D}, {0x0020}, {0x261D}}},                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u000D\u0308\u261D", expected: [][]rune{{0x000D}, {0x0308}, {0x261D}}},                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u000D\u0308\u0020\u261D", expected: [][]rune{{0x000D}, {0x0308, 0x0020}, {0x261D}}},                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u000D\U0001F3FB", expected: [][]rune{{0x000D}, {0x1F3FB}}},                                                                                                                        // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u000D\u0020\U0001F3FB", expected: [][]rune{{0x000D}, {0x0020}, {0x1F3FB}}},                                                                                                        // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u000D\u0308\U0001F3FB", expected: [][]rune{{0x000D}, {0x0308}, {0x1F3FB}}},                                                                                                        // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u000D\u0308\u0020\U0001F3FB", expected: [][]rune{{0x000D}, {0x0308, 0x0020}, {0x1F3FB}}},                                                                                          // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u000D\u0029", expected: [][]rune{{0x000D}, {0x0029}}},                                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u000D\u0020\u0029", expected: [][]rune{{0x000D}, {0x0020, 0x0029}}},                                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u000D\u0308\u0029", expected: [][]rune{{0x000D}, {0x0308, 0x0029}}},                                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u000D\u0308\u0020\u0029", expected: [][]rune{{0x000D}, {0x0308, 0x0020, 0x0029}}},                                                                                                 // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u000D\u0028", expected: [][]rune{{0x000D}, {0x0028}}},                                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u000D\u0020\u0028", expected: [][]rune{{0x000D}, {0x0020}, {0x0028}}},                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u000D\u0308\u0028", expected: [][]rune{{0x000D}, {0x0308, 0x0028}}},                                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [30.01] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u000D\u0308\u0020\u0028", expected: [][]rune{{0x000D}, {0x0308, 0x0020}, {0x0028}}},                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u000D\u0001", expected: [][]rune{{0x000D}, {0x0001}}},                                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u000D\u0020\u0001", expected: [][]rune{{0x000D}, {0x0020}, {0x0001}}},                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u000D\u0308\u0001", expected: [][]rune{{0x000D}, {0x0308, 0x0001}}},                                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u000D\u0308\u0020\u0001", expected: [][]rune{{0x000D}, {0x0308, 0x0020}, {0x0001}}},                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u000D\u200D", expected: [][]rune{{0x000D}, {0x200D}}},                                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u000D\u0020\u200D", expected: [][]rune{{0x000D}, {0x0020}, {0x200D}}},                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u000D\u0308\u200D", expected: [][]rune{{0x000D}, {0x0308, 0x200D}}},                                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u000D\u0308\u0020\u200D", expected: [][]rune{{0x000D}, {0x0308, 0x0020}, {0x200D}}},                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u000D\u00A7", expected: [][]rune{{0x000D}, {0x00A7}}},                                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u000D\u0020\u00A7", expected: [][]rune{{0x000D}, {0x0020}, {0x00A7}}},                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u000D\u0308\u00A7", expected: [][]rune{{0x000D}, {0x0308, 0x00A7}}},                                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [28.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u000D\u0308\u0020\u00A7", expected: [][]rune{{0x000D}, {0x0308, 0x0020}, {0x00A7}}},                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u000D\U00050005", expected: [][]rune{{0x000D}, {0x50005}}},                                                                                                                        // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u000D\u0020\U00050005", expected: [][]rune{{0x000D}, {0x0020}, {0x50005}}},                                                                                                        // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u000D\u0308\U00050005", expected: [][]rune{{0x000D}, {0x0308, 0x50005}}},                                                                                                          // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [28.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u000D\u0308\u0020\U00050005", expected: [][]rune{{0x000D}, {0x0308, 0x0020}, {0x50005}}},                                                                                          // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u000D\u0E01", expected: [][]rune{{0x000D}, {0x0E01}}},                                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u000D\u0020\u0E01", expected: [][]rune{{0x000D}, {0x0020}, {0x0E01}}},                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u000D\u0308\u0E01", expected: [][]rune{{0x000D}, {0x0308, 0x0E01}}},                                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [28.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u000D\u0308\u0020\u0E01", expected: [][]rune{{0x000D}, {0x0308, 0x0020}, {0x0E01}}},                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u000D\u3041", expected: [][]rune{{0x000D}, {0x3041}}},                                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u000D\u0020\u3041", expected: [][]rune{{0x000D}, {0x0020}, {0x3041}}},                                                                                                             // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u000D\u0308\u3041", expected: [][]rune{{0x000D}, {0x0308, 0x3041}}},                                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u000D\u0308\u0020\u3041", expected: [][]rune{{0x000D}, {0x0308, 0x0020}, {0x3041}}},                                                                                               // × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u0021\u0023", expected: [][]rune{{0x0021}, {0x0023}}},                                                                                                                             // × [0.3] EXCLAMATION MARK (EX) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u0021\u0020\u0023", expected: [][]rune{{0x0021, 0x0020}, {0x0023}}},                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u0021\u0308\u0023", expected: [][]rune{{0x0021, 0x0308}, {0x0023}}},                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u0021\u0308\u0020\u0023", expected: [][]rune{{0x0021, 0x0308, 0x0020}, {0x0023}}},                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u0021\u2014", expected: [][]rune{{0x0021}, {0x2014}}},                                                                                                                             // × [0.3] EXCLAMATION MARK (EX) ÷ [999.0] EM DASH (B2) ÷ [0.3]
	{original: "\u0021\u0020\u2014", expected: [][]rune{{0x0021, 0x0020}, {0x2014}}},                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
	{original: "\u0021\u0308\u2014", expected: [][]rune{{0x0021, 0x0308}, {0x2014}}},                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
	{original: "\u0021\u0308\u0020\u2014", expected: [][]rune{{0x0021, 0x0308, 0x0020}, {0x2014}}},                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
	{original: "\u0021\u0009", expected: [][]rune{{0x0021, 0x0009}}},                                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u0021\u0020\u0009", expected: [][]rune{{0x0021, 0x0020}, {0x0009}}},                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u0021\u0308\u0009", expected: [][]rune{{0x0021, 0x0308, 0x0009}}},                                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u0021\u0308\u0020\u0009", expected: [][]rune{{0x0021, 0x0308, 0x0020}, {0x0009}}},                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u0021\u00B4", expected: [][]rune{{0x0021}, {0x00B4}}},                                                                                                                             // × [0.3] EXCLAMATION MARK (EX) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u0021\u0020\u00B4", expected: [][]rune{{0x0021, 0x0020}, {0x00B4}}},                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u0021\u0308\u00B4", expected: [][]rune{{0x0021, 0x0308}, {0x00B4}}},                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u0021\u0308\u0020\u00B4", expected: [][]rune{{0x0021, 0x0308, 0x0020}, {0x00B4}}},                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u0021\u000B", expected: [][]rune{{0x0021, 0x000B}}},                                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u0021\u0020\u000B", expected: [][]rune{{0x0021, 0x0020, 0x000B}}},                                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u0021\u0308\u000B", expected: [][]rune{{0x0021, 0x0308, 0x000B}}},                                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u0021\u0308\u0020\u000B", expected: [][]rune{{0x0021, 0x0308, 0x0020, 0x000B}}},                                                                                                   // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u0021\uFFFC", expected: [][]rune{{0x0021}, {0xFFFC}}},                                                                                                                             // × [0.3] EXCLAMATION MARK (EX) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u0021\u0020\uFFFC", expected: [][]rune{{0x0021, 0x0020}, {0xFFFC}}},                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u0021\u0308\uFFFC", expected: [][]rune{{0x0021, 0x0308}, {0xFFFC}}},                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u0021\u0308\u0020\uFFFC", expected: [][]rune{{0x0021, 0x0308, 0x0020}, {0xFFFC}}},                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u0021\u007D", expected: [][]rune{{0x0021, 0x007D}}},                                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u0021\u0020\u007D", expected: [][]rune{{0x0021, 0x0020, 0x007D}}},                                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u0021\u0308\u007D", expected: [][]rune{{0x0021, 0x0308, 0x007D}}},                                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u0021\u0308\u0020\u007D", expected: [][]rune{{0x0021, 0x0308, 0x0020, 0x007D}}},                                                                                                   // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u0021\u000D", expected: [][]rune{{0x0021, 0x000D}}},                                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0021\u0020\u000D", expected: [][]rune{{0x0021, 0x0020, 0x000D}}},                                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0021\u0308\u000D", expected: [][]rune{{0x0021, 0x0308, 0x000D}}},                                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0021\u0308\u0020\u000D", expected: [][]rune{{0x0021, 0x0308, 0x0020, 0x000D}}},                                                                                                   // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0021\u0021", expected: [][]rune{{0x0021, 0x0021}}},                                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u0021\u0020\u0021", expected: [][]rune{{0x0021, 0x0020, 0x0021}}},                                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u0021\u0308\u0021", expected: [][]rune{{0x0021, 0x0308, 0x0021}}},                                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u0021\u0308\u0020\u0021", expected: [][]rune{{0x0021, 0x0308, 0x0020, 0x0021}}},                                                                                                   // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u0021\u00A0", expected: [][]rune{{0x0021, 0x00A0}}},                                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [12.1] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u0021\u0020\u00A0", expected: [][]rune{{0x0021, 0x0020}, {0x00A0}}},                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u0021\u0308\u00A0", expected: [][]rune{{0x0021, 0x0308, 0x00A0}}},                                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u0021\u0308\u0020\u00A0", expected: [][]rune{{0x0021, 0x0308, 0x0020}, {0x00A0}}},                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u0021\uAC00", expected: [][]rune{{0x0021}, {0xAC00}}},                                                                                                                             // × [0.3] EXCLAMATION MARK (EX) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u0021\u0020\uAC00", expected: [][]rune{{0x0021, 0x0020}, {0xAC00}}},                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u0021\u0308\uAC00", expected: [][]rune{{0x0021, 0x0308}, {0xAC00}}},                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u0021\u0308\u0020\uAC00", expected: [][]rune{{0x0021, 0x0308, 0x0020}, {0xAC00}}},                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u0021\uAC01", expected: [][]rune{{0x0021}, {0xAC01}}},                                                                                                                             // × [0.3] EXCLAMATION MARK (EX) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u0021\u0020\uAC01", expected: [][]rune{{0x0021, 0x0020}, {0xAC01}}},                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u0021\u0308\uAC01", expected: [][]rune{{0x0021, 0x0308}, {0xAC01}}},                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u0021\u0308\u0020\uAC01", expected: [][]rune{{0x0021, 0x0308, 0x0020}, {0xAC01}}},                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u0021\u05D0", expected: [][]rune{{0x0021}, {0x05D0}}},                                                                                                                             // × [0.3] EXCLAMATION MARK (EX) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u0021\u0020\u05D0", expected: [][]rune{{0x0021, 0x0020}, {0x05D0}}},                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u0021\u0308\u05D0", expected: [][]rune{{0x0021, 0x0308}, {0x05D0}}},                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u0021\u0308\u0020\u05D0", expected: [][]rune{{0x0021, 0x0308, 0x0020}, {0x05D0}}},                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u0021\u002D", expected: [][]rune{{0x0021, 0x002D}}},                                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u0021\u0020\u002D", expected: [][]rune{{0x0021, 0x0020}, {0x002D}}},                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u0021\u0308\u002D", expected: [][]rune{{0x0021, 0x0308, 0x002D}}},                                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u0021\u0308\u0020\u002D", expected: [][]rune{{0x0021, 0x0308, 0x0020}, {0x002D}}},                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u0021\u231A", expected: [][]rune{{0x0021}, {0x231A}}},                                                                                                                             // × [0.3] EXCLAMATION MARK (EX) ÷ [999.0] WATCH (ID) ÷ [0.3]
	{original: "\u0021\u0020\u231A", expected: [][]rune{{0x0021, 0x0020}, {0x231A}}},                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
	{original: "\u0021\u0308\u231A", expected: [][]rune{{0x0021, 0x0308}, {0x231A}}},                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
	{original: "\u0021\u0308\u0020\u231A", expected: [][]rune{{0x0021, 0x0308, 0x0020}, {0x231A}}},                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
	{original: "\u0021\u2024", expected: [][]rune{{0x0021, 0x2024}}},                                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u0021\u0020\u2024", expected: [][]rune{{0x0021, 0x0020}, {0x2024}}},                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u0021\u0308\u2024", expected: [][]rune{{0x0021, 0x0308, 0x2024}}},                                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u0021\u0308\u0020\u2024", expected: [][]rune{{0x0021, 0x0308, 0x0020}, {0x2024}}},                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u0021\u002C", expected: [][]rune{{0x0021, 0x002C}}},                                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u0021\u0020\u002C", expected: [][]rune{{0x0021, 0x0020, 0x002C}}},                                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u0021\u0308\u002C", expected: [][]rune{{0x0021, 0x0308, 0x002C}}},                                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
	{original: "\u0021\u0308\u0020\u002C", expected: [][]rune{{0x0021, 0x0308, 0x0020, 0x002C}}},                                                                                                   // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u0021\u1100", expected: [][]rune{{0x0021}, {0x1100}}},                                                                                                                             // × [0.3] EXCLAMATION MARK (EX) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u0021\u0020\u1100", expected: [][]rune{{0x0021, 0x0020}, {0x1100}}},                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u0021\u0308\u1100", expected: [][]rune{{0x0021, 0x0308}, {0x1100}}},                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u0021\u0308\u0020\u1100", expected: [][]rune{{0x0021, 0x0308, 0x0020}, {0x1100}}},                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u0021\u11A8", expected: [][]rune{{0x0021}, {0x11A8}}},                                                                                                                             // × [0.3] EXCLAMATION MARK (EX) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u0021\u0020\u11A8", expected: [][]rune{{0x0021, 0x0020}, {0x11A8}}},                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u0021\u0308\u11A8", expected: [][]rune{{0x0021, 0x0308}, {0x11A8}}},                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u0021\u0308\u0020\u11A8", expected: [][]rune{{0x0021, 0x0308, 0x0020}, {0x11A8}}},                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u0021\u1160", expected: [][]rune{{0x0021}, {0x1160}}},                                                                                                                             // × [0.3] EXCLAMATION MARK (EX) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u0021\u0020\u1160", expected: [][]rune{{0x0021, 0x0020}, {0x1160}}},                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u0021\u0308\u1160", expected: [][]rune{{0x0021, 0x0308}, {0x1160}}},                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u0021\u0308\u0020\u1160", expected: [][]rune{{0x0021, 0x0308, 0x0020}, {0x1160}}},                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u0021\u000A", expected: [][]rune{{0x0021, 0x000A}}},                                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0021\u0020\u000A", expected: [][]rune{{0x0021, 0x0020, 0x000A}}},                                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0021\u0308\u000A", expected: [][]rune{{0x0021, 0x0308, 0x000A}}},                                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0021\u0308\u0020\u000A", expected: [][]rune{{0x0021, 0x0308, 0x0020, 0x000A}}},                                                                                                   // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0021\u0085", expected: [][]rune{{0x0021, 0x0085}}},                                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u0021\u0020\u0085", expected: [][]rune{{0x0021, 0x0020, 0x0085}}},                                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u0021\u0308\u0085", expected: [][]rune{{0x0021, 0x0308, 0x0085}}},                                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u0021\u0308\u0020\u0085", expected: [][]rune{{0x0021, 0x0308, 0x0020, 0x0085}}},                                                                                                   // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u0021\u17D6", expected: [][]rune{{0x0021, 0x17D6}}},                                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u0021\u0020\u17D6", expected: [][]rune{{0x0021, 0x0020}, {0x17D6}}},                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u0021\u0308\u17D6", expected: [][]rune{{0x0021, 0x0308, 0x17D6}}},                                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u0021\u0308\u0020\u17D6", expected: [][]rune{{0x0021, 0x0308, 0x0020}, {0x17D6}}},                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u0021\u0030", expected: [][]rune{{0x0021}, {0x0030}}},                                                                                                                             // × [0.3] EXCLAMATION MARK (EX) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u0021\u0020\u0030", expected: [][]rune{{0x0021, 0x0020}, {0x0030}}},                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u0021\u0308\u0030", expected: [][]rune{{0x0021, 0x0308}, {0x0030}}},                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u0021\u0308\u0020\u0030", expected: [][]rune{{0x0021, 0x0308, 0x0020}, {0x0030}}},                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u0021\u2329", expected: [][]rune{{0x0021}, {0x2329}}},                                                                                                                             // × [0.3] EXCLAMATION MARK (EX) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u0021\u0020\u2329", expected: [][]rune{{0x0021, 0x0020}, {0x2329}}},                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u0021\u0308\u2329", expected: [][]rune{{0x0021, 0x0308}, {0x2329}}},                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u0021\u0308\u0020\u2329", expected: [][]rune{{0x0021, 0x0308, 0x0020}, {0x2329}}},                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u0021\u0025", expected: [][]rune{{0x0021}, {0x0025}}},                                                                                                                             // × [0.3] EXCLAMATION MARK (EX) ÷ [999.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u0021\u0020\u0025", expected: [][]rune{{0x0021, 0x0020}, {0x0025}}},                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u0021\u0308\u0025", expected: [][]rune{{0x0021, 0x0308}, {0x0025}}},                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u0021\u0308\u0020\u0025", expected: [][]rune{{0x0021, 0x0308, 0x0020}, {0x0025}}},                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u0021\u0024", expected: [][]rune{{0x0021}, {0x0024}}},                                                                                                                             // × [0.3] EXCLAMATION MARK (EX) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u0021\u0020\u0024", expected: [][]rune{{0x0021, 0x0020}, {0x0024}}},                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u0021\u0308\u0024", expected: [][]rune{{0x0021, 0x0308}, {0x0024}}},                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u0021\u0308\u0020\u0024", expected: [][]rune{{0x0021, 0x0308, 0x0020}, {0x0024}}},                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u0021\u0022", expected: [][]rune{{0x0021, 0x0022}}},                                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u0021\u0020\u0022", expected: [][]rune{{0x0021, 0x0020}, {0x0022}}},                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u0021\u0308\u0022", expected: [][]rune{{0x0021, 0x0308, 0x0022}}},                                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u0021\u0308\u0020\u0022", expected: [][]rune{{0x0021, 0x0308, 0x0020}, {0x0022}}},                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u0021\u0020", expected: [][]rune{{0x0021, 0x0020}}},                                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u0021\u0020\u0020", expected: [][]rune{{0x0021, 0x0020, 0x0020}}},                                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u0021\u0308\u0020", expected: [][]rune{{0x0021, 0x0308, 0x0020}}},                                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u0021\u0308\u0020\u0020", expected: [][]rune{{0x0021, 0x0308, 0x0020, 0x0020}}},                                                                                                   // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u0021\u002F", expected: [][]rune{{0x0021, 0x002F}}},                                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\u0021\u0020\u002F", expected: [][]rune{{0x0021, 0x0020, 0x002F}}},                                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\u0021\u0308\u002F", expected: [][]rune{{0x0021, 0x0308, 0x002F}}},                                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
	{original: "\u0021\u0308\u0020\u002F", expected: [][]rune{{0x0021, 0x0308, 0x0020, 0x002F}}},                                                                                                   // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\u0021\u2060", expected: [][]rune{{0x0021, 0x2060}}},                                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u0021\u0020\u2060", expected: [][]rune{{0x0021, 0x0020, 0x2060}}},                                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u0021\u0308\u2060", expected: [][]rune{{0x0021, 0x0308, 0x2060}}},                                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u0021\u0308\u0020\u2060", expected: [][]rune{{0x0021, 0x0308, 0x0020, 0x2060}}},                                                                                                   // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u0021\u200B", expected: [][]rune{{0x0021, 0x200B}}},                                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u0021\u0020\u200B", expected: [][]rune{{0x0021, 0x0020, 0x200B}}},                                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u0021\u0308\u200B", expected: [][]rune{{0x0021, 0x0308, 0x200B}}},                                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u0021\u0308\u0020\u200B", expected: [][]rune{{0x0021, 0x0308, 0x0020, 0x200B}}},                                                                                                   // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u0021\U0001F1E6", expected: [][]rune{{0x0021}, {0x1F1E6}}},                                                                                                                        // × [0.3] EXCLAMATION MARK (EX) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0021\u0020\U0001F1E6", expected: [][]rune{{0x0021, 0x0020}, {0x1F1E6}}},                                                                                                          // × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0021\u0308\U0001F1E6", expected: [][]rune{{0x0021, 0x0308}, {0x1F1E6}}},                                                                                                          // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0021\u0308\u0020\U0001F1E6", expected: [][]rune{{0x0021, 0x0308, 0x0020}, {0x1F1E6}}},                                                                                            // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0021\u261D", expected: [][]rune{{0x0021}, {0x261D}}},                                                                                                                             // × [0.3] EXCLAMATION MARK (EX) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u0021\u0020\u261D", expected: [][]rune{{0x0021, 0x0020}, {0x261D}}},                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u0021\u0308\u261D", expected: [][]rune{{0x0021, 0x0308}, {0x261D}}},                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u0021\u0308\u0020\u261D", expected: [][]rune{{0x0021, 0x0308, 0x0020}, {0x261D}}},                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u0021\U0001F3FB", expected: [][]rune{{0x0021}, {0x1F3FB}}},                                                                                                                        // × [0.3] EXCLAMATION MARK (EX) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u0021\u0020\U0001F3FB", expected: [][]rune{{0x0021, 0x0020}, {0x1F3FB}}},                                                                                                          // × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u0021\u0308\U0001F3FB", expected: [][]rune{{0x0021, 0x0308}, {0x1F3FB}}},                                                                                                          // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u0021\u0308\u0020\U0001F3FB", expected: [][]rune{{0x0021, 0x0308, 0x0020}, {0x1F3FB}}},                                                                                            // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u0021\u0029", expected: [][]rune{{0x0021, 0x0029}}},                                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u0021\u0020\u0029", expected: [][]rune{{0x0021, 0x0020, 0x0029}}},                                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u0021\u0308\u0029", expected: [][]rune{{0x0021, 0x0308, 0x0029}}},                                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u0021\u0308\u0020\u0029", expected: [][]rune{{0x0021, 0x0308, 0x0020, 0x0029}}},                                                                                                   // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u0021\u0028", expected: [][]rune{{0x0021}, {0x0028}}},                                                                                                                             // × [0.3] EXCLAMATION MARK (EX) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u0021\u0020\u0028", expected: [][]rune{{0x0021, 0x0020}, {0x0028}}},                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u0021\u0308\u0028", expected: [][]rune{{0x0021, 0x0308}, {0x0028}}},                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u0021\u0308\u0020\u0028", expected: [][]rune{{0x0021, 0x0308, 0x0020}, {0x0028}}},                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u0021\u0001", expected: [][]rune{{0x0021, 0x0001}}},                                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u0021\u0020\u0001", expected: [][]rune{{0x0021, 0x0020}, {0x0001}}},                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u0021\u0308\u0001", expected: [][]rune{{0x0021, 0x0308, 0x0001}}},                                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u0021\u0308\u0020\u0001", expected: [][]rune{{0x0021, 0x0308, 0x0020}, {0x0001}}},                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u0021\u200D", expected: [][]rune{{0x0021, 0x200D}}},                                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u0021\u0020\u200D", expected: [][]rune{{0x0021, 0x0020}, {0x200D}}},                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u0021\u0308\u200D", expected: [][]rune{{0x0021, 0x0308, 0x200D}}},                                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u0021\u0308\u0020\u200D", expected: [][]rune{{0x0021, 0x0308, 0x0020}, {0x200D}}},                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u0021\u00A7", expected: [][]rune{{0x0021}, {0x00A7}}},                                                                                                                             // × [0.3] EXCLAMATION MARK (EX) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u0021\u0020\u00A7", expected: [][]rune{{0x0021, 0x0020}, {0x00A7}}},                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u0021\u0308\u00A7", expected: [][]rune{{0x0021, 0x0308}, {0x00A7}}},                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u0021\u0308\u0020\u00A7", expected: [][]rune{{0x0021, 0x0308, 0x0020}, {0x00A7}}},                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u0021\U00050005", expected: [][]rune{{0x0021}, {0x50005}}},                                                                                                                        // × [0.3] EXCLAMATION MARK (EX) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u0021\u0020\U00050005", expected: [][]rune{{0x0021, 0x0020}, {0x50005}}},                                                                                                          // × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u0021\u0308\U00050005", expected: [][]rune{{0x0021, 0x0308}, {0x50005}}},                                                                                                          // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u0021\u0308\u0020\U00050005", expected: [][]rune{{0x0021, 0x0308, 0x0020}, {0x50005}}},                                                                                            // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u0021\u0E01", expected: [][]rune{{0x0021}, {0x0E01}}},                                                                                                                             // × [0.3] EXCLAMATION MARK (EX) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u0021\u0020\u0E01", expected: [][]rune{{0x0021, 0x0020}, {0x0E01}}},                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u0021\u0308\u0E01", expected: [][]rune{{0x0021, 0x0308}, {0x0E01}}},                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u0021\u0308\u0020\u0E01", expected: [][]rune{{0x0021, 0x0308, 0x0020}, {0x0E01}}},                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u0021\u3041", expected: [][]rune{{0x0021, 0x3041}}},                                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u0021\u0020\u3041", expected: [][]rune{{0x0021, 0x0020}, {0x3041}}},                                                                                                               // × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u0021\u0308\u3041", expected: [][]rune{{0x0021, 0x0308, 0x3041}}},                                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u0021\u0308\u0020\u3041", expected: [][]rune{{0x0021, 0x0308, 0x0020}, {0x3041}}},                                                                                                 // × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u00A0\u0023", expected: [][]rune{{0x00A0, 0x0023}}},                                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [12.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u00A0\u0020\u0023", expected: [][]rune{{0x00A0, 0x0020}, {0x0023}}},                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u00A0\u0308\u0023", expected: [][]rune{{0x00A0, 0x0308, 0x0023}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u00A0\u0308\u0020\u0023", expected: [][]rune{{0x00A0, 0x0308, 0x0020}, {0x0023}}},                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u00A0\u2014", expected: [][]rune{{0x00A0, 0x2014}}},                                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [12.0] EM DASH (B2) ÷ [0.3]
	{original: "\u00A0\u0020\u2014", expected: [][]rune{{0x00A0, 0x0020}, {0x2014}}},                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
	{original: "\u00A0\u0308\u2014", expected: [][]rune{{0x00A0, 0x0308, 0x2014}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] EM DASH (B2) ÷ [0.3]
	{original: "\u00A0\u0308\u0020\u2014", expected: [][]rune{{0x00A0, 0x0308, 0x0020}, {0x2014}}},                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
	{original: "\u00A0\u0009", expected: [][]rune{{0x00A0, 0x0009}}},                                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [12.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u00A0\u0020\u0009", expected: [][]rune{{0x00A0, 0x0020}, {0x0009}}},                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u00A0\u0308\u0009", expected: [][]rune{{0x00A0, 0x0308, 0x0009}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u00A0\u0308\u0020\u0009", expected: [][]rune{{0x00A0, 0x0308, 0x0020}, {0x0009}}},                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u00A0\u00B4", expected: [][]rune{{0x00A0, 0x00B4}}},                                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [12.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u00A0\u0020\u00B4", expected: [][]rune{{0x00A0, 0x0020}, {0x00B4}}},                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u00A0\u0308\u00B4", expected: [][]rune{{0x00A0, 0x0308, 0x00B4}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u00A0\u0308\u0020\u00B4", expected: [][]rune{{0x00A0, 0x0308, 0x0020}, {0x00B4}}},                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u00A0\u000B", expected: [][]rune{{0x00A0, 0x000B}}},                                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u00A0\u0020\u000B", expected: [][]rune{{0x00A0, 0x0020, 0x000B}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u00A0\u0308\u000B", expected: [][]rune{{0x00A0, 0x0308, 0x000B}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u00A0\u0308\u0020\u000B", expected: [][]rune{{0x00A0, 0x0308, 0x0020, 0x000B}}},                                                                                                   // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u00A0\uFFFC", expected: [][]rune{{0x00A0, 0xFFFC}}},                                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [12.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u00A0\u0020\uFFFC", expected: [][]rune{{0x00A0, 0x0020}, {0xFFFC}}},                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u00A0\u0308\uFFFC", expected: [][]rune{{0x00A0, 0x0308, 0xFFFC}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u00A0\u0308\u0020\uFFFC", expected: [][]rune{{0x00A0, 0x0308, 0x0020}, {0xFFFC}}},                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u00A0\u007D", expected: [][]rune{{0x00A0, 0x007D}}},                                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [12.0] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u00A0\u0020\u007D", expected: [][]rune{{0x00A0, 0x0020, 0x007D}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u00A0\u0308\u007D", expected: [][]rune{{0x00A0, 0x0308, 0x007D}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u00A0\u0308\u0020\u007D", expected: [][]rune{{0x00A0, 0x0308, 0x0020, 0x007D}}},                                                                                                   // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u00A0\u000D", expected: [][]rune{{0x00A0, 0x000D}}},                                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u00A0\u0020\u000D", expected: [][]rune{{0x00A0, 0x0020, 0x000D}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u00A0\u0308\u000D", expected: [][]rune{{0x00A0, 0x0308, 0x000D}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u00A0\u0308\u0020\u000D", expected: [][]rune{{0x00A0, 0x0308, 0x0020, 0x000D}}},                                                                                                   // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u00A0\u0021", expected: [][]rune{{0x00A0, 0x0021}}},                                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [12.0] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u00A0\u0020\u0021", expected: [][]rune{{0x00A0, 0x0020, 0x0021}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u00A0\u0308\u0021", expected: [][]rune{{0x00A0, 0x0308, 0x0021}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u00A0\u0308\u0020\u0021", expected: [][]rune{{0x00A0, 0x0308, 0x0020, 0x0021}}},                                                                                                   // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u00A0\u00A0", expected: [][]rune{{0x00A0, 0x00A0}}},                                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [12.0] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u00A0\u0020\u00A0", expected: [][]rune{{0x00A0, 0x0020}, {0x00A0}}},                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u00A0\u0308\u00A0", expected: [][]rune{{0x00A0, 0x0308, 0x00A0}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u00A0\u0308\u0020\u00A0", expected: [][]rune{{0x00A0, 0x0308, 0x0020}, {0x00A0}}},                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u00A0\uAC00", expected: [][]rune{{0x00A0, 0xAC00}}},                                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [12.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u00A0\u0020\uAC00", expected: [][]rune{{0x00A0, 0x0020}, {0xAC00}}},                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u00A0\u0308\uAC00", expected: [][]rune{{0x00A0, 0x0308, 0xAC00}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u00A0\u0308\u0020\uAC00", expected: [][]rune{{0x00A0, 0x0308, 0x0020}, {0xAC00}}},                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u00A0\uAC01", expected: [][]rune{{0x00A0, 0xAC01}}},                                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [12.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u00A0\u0020\uAC01", expected: [][]rune{{0x00A0, 0x0020}, {0xAC01}}},                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u00A0\u0308\uAC01", expected: [][]rune{{0x00A0, 0x0308, 0xAC01}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u00A0\u0308\u0020\uAC01", expected: [][]rune{{0x00A0, 0x0308, 0x0020}, {0xAC01}}},                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u00A0\u05D0", expected: [][]rune{{0x00A0, 0x05D0}}},                                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [12.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u00A0\u0020\u05D0", expected: [][]rune{{0x00A0, 0x0020}, {0x05D0}}},                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u00A0\u0308\u05D0", expected: [][]rune{{0x00A0, 0x0308, 0x05D0}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u00A0\u0308\u0020\u05D0", expected: [][]rune{{0x00A0, 0x0308, 0x0020}, {0x05D0}}},                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u00A0\u002D", expected: [][]rune{{0x00A0, 0x002D}}},                                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [12.0] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u00A0\u0020\u002D", expected: [][]rune{{0x00A0, 0x0020}, {0x002D}}},                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u00A0\u0308\u002D", expected: [][]rune{{0x00A0, 0x0308, 0x002D}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u00A0\u0308\u0020\u002D", expected: [][]rune{{0x00A0, 0x0308, 0x0020}, {0x002D}}},                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u00A0\u231A", expected: [][]rune{{0x00A0, 0x231A}}},                                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [12.0] WATCH (ID) ÷ [0.3]
	{original: "\u00A0\u0020\u231A", expected: [][]rune{{0x00A0, 0x0020}, {0x231A}}},                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
	{original: "\u00A0\u0308\u231A", expected: [][]rune{{0x00A0, 0x0308, 0x231A}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] WATCH (ID) ÷ [0.3]
	{original: "\u00A0\u0308\u0020\u231A", expected: [][]rune{{0x00A0, 0x0308, 0x0020}, {0x231A}}},                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
	{original: "\u00A0\u2024", expected: [][]rune{{0x00A0, 0x2024}}},                                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [12.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u00A0\u0020\u2024", expected: [][]rune{{0x00A0, 0x0020}, {0x2024}}},                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u00A0\u0308\u2024", expected: [][]rune{{0x00A0, 0x0308, 0x2024}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u00A0\u0308\u0020\u2024", expected: [][]rune{{0x00A0, 0x0308, 0x0020}, {0x2024}}},                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u00A0\u002C", expected: [][]rune{{0x00A0, 0x002C}}},                                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [12.0] COMMA (IS) ÷ [0.3]
	{original: "\u00A0\u0020\u002C", expected: [][]rune{{0x00A0, 0x0020, 0x002C}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u00A0\u0308\u002C", expected: [][]rune{{0x00A0, 0x0308, 0x002C}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] COMMA (IS) ÷ [0.3]
	{original: "\u00A0\u0308\u0020\u002C", expected: [][]rune{{0x00A0, 0x0308, 0x0020, 0x002C}}},                                                                                                   // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u00A0\u1100", expected: [][]rune{{0x00A0, 0x1100}}},                                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [12.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u00A0\u0020\u1100", expected: [][]rune{{0x00A0, 0x0020}, {0x1100}}},                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u00A0\u0308\u1100", expected: [][]rune{{0x00A0, 0x0308, 0x1100}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u00A0\u0308\u0020\u1100", expected: [][]rune{{0x00A0, 0x0308, 0x0020}, {0x1100}}},                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u00A0\u11A8", expected: [][]rune{{0x00A0, 0x11A8}}},                                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [12.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u00A0\u0020\u11A8", expected: [][]rune{{0x00A0, 0x0020}, {0x11A8}}},                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u00A0\u0308\u11A8", expected: [][]rune{{0x00A0, 0x0308, 0x11A8}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u00A0\u0308\u0020\u11A8", expected: [][]rune{{0x00A0, 0x0308, 0x0020}, {0x11A8}}},                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u00A0\u1160", expected: [][]rune{{0x00A0, 0x1160}}},                                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [12.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u00A0\u0020\u1160", expected: [][]rune{{0x00A0, 0x0020}, {0x1160}}},                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u00A0\u0308\u1160", expected: [][]rune{{0x00A0, 0x0308, 0x1160}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u00A0\u0308\u0020\u1160", expected: [][]rune{{0x00A0, 0x0308, 0x0020}, {0x1160}}},                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u00A0\u000A", expected: [][]rune{{0x00A0, 0x000A}}},                                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u00A0\u0020\u000A", expected: [][]rune{{0x00A0, 0x0020, 0x000A}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u00A0\u0308\u000A", expected: [][]rune{{0x00A0, 0x0308, 0x000A}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u00A0\u0308\u0020\u000A", expected: [][]rune{{0x00A0, 0x0308, 0x0020, 0x000A}}},                                                                                                   // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u00A0\u0085", expected: [][]rune{{0x00A0, 0x0085}}},                                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u00A0\u0020\u0085", expected: [][]rune{{0x00A0, 0x0020, 0x0085}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u00A0\u0308\u0085", expected: [][]rune{{0x00A0, 0x0308, 0x0085}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u00A0\u0308\u0020\u0085", expected: [][]rune{{0x00A0, 0x0308, 0x0020, 0x0085}}},                                                                                                   // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u00A0\u17D6", expected: [][]rune{{0x00A0, 0x17D6}}},                                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [12.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u00A0\u0020\u17D6", expected: [][]rune{{0x00A0, 0x0020}, {0x17D6}}},                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u00A0\u0308\u17D6", expected: [][]rune{{0x00A0, 0x0308, 0x17D6}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u00A0\u0308\u0020\u17D6", expected: [][]rune{{0x00A0, 0x0308, 0x0020}, {0x17D6}}},                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u00A0\u0030", expected: [][]rune{{0x00A0, 0x0030}}},                                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [12.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u00A0\u0020\u0030", expected: [][]rune{{0x00A0, 0x0020}, {0x0030}}},                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u00A0\u0308\u0030", expected: [][]rune{{0x00A0, 0x0308, 0x0030}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u00A0\u0308\u0020\u0030", expected: [][]rune{{0x00A0, 0x0308, 0x0020}, {0x0030}}},                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u00A0\u2329", expected: [][]rune{{0x00A0, 0x2329}}},                                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [12.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u00A0\u0020\u2329", expected: [][]rune{{0x00A0, 0x0020}, {0x2329}}},                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u00A0\u0308\u2329", expected: [][]rune{{0x00A0, 0x0308, 0x2329}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u00A0\u0308\u0020\u2329", expected: [][]rune{{0x00A0, 0x0308, 0x0020}, {0x2329}}},                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u00A0\u0025", expected: [][]rune{{0x00A0, 0x0025}}},                                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [12.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u00A0\u0020\u0025", expected: [][]rune{{0x00A0, 0x0020}, {0x0025}}},                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u00A0\u0308\u0025", expected: [][]rune{{0x00A0, 0x0308, 0x0025}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u00A0\u0308\u0020\u0025", expected: [][]rune{{0x00A0, 0x0308, 0x0020}, {0x0025}}},                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u00A0\u0024", expected: [][]rune{{0x00A0, 0x0024}}},                                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [12.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u00A0\u0020\u0024", expected: [][]rune{{0x00A0, 0x0020}, {0x0024}}},                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u00A0\u0308\u0024", expected: [][]rune{{0x00A0, 0x0308, 0x0024}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u00A0\u0308\u0020\u0024", expected: [][]rune{{0x00A0, 0x0308, 0x0020}, {0x0024}}},                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u00A0\u0022", expected: [][]rune{{0x00A0, 0x0022}}},                                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [12.0] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u00A0\u0020\u0022", expected: [][]rune{{0x00A0, 0x0020}, {0x0022}}},                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u00A0\u0308\u0022", expected: [][]rune{{0x00A0, 0x0308, 0x0022}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u00A0\u0308\u0020\u0022", expected: [][]rune{{0x00A0, 0x0308, 0x0020}, {0x0022}}},                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u00A0\u0020", expected: [][]rune{{0x00A0, 0x0020}}},                                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u00A0\u0020\u0020", expected: [][]rune{{0x00A0, 0x0020, 0x0020}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u00A0\u0308\u0020", expected: [][]rune{{0x00A0, 0x0308, 0x0020}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u00A0\u0308\u0020\u0020", expected: [][]rune{{0x00A0, 0x0308, 0x0020, 0x0020}}},                                                                                                   // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u00A0\u002F", expected: [][]rune{{0x00A0, 0x002F}}},                                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [12.0] SOLIDUS (SY) ÷ [0.3]
	{original: "\u00A0\u0020\u002F", expected: [][]rune{{0x00A0, 0x0020, 0x002F}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\u00A0\u0308\u002F", expected: [][]rune{{0x00A0, 0x0308, 0x002F}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] SOLIDUS (SY) ÷ [0.3]
	{original: "\u00A0\u0308\u0020\u002F", expected: [][]rune{{0x00A0, 0x0308, 0x0020, 0x002F}}},                                                                                                   // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\u00A0\u2060", expected: [][]rune{{0x00A0, 0x2060}}},                                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u00A0\u0020\u2060", expected: [][]rune{{0x00A0, 0x0020, 0x2060}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u00A0\u0308\u2060", expected: [][]rune{{0x00A0, 0x0308, 0x2060}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u00A0\u0308\u0020\u2060", expected: [][]rune{{0x00A0, 0x0308, 0x0020, 0x2060}}},                                                                                                   // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u00A0\u200B", expected: [][]rune{{0x00A0, 0x200B}}},                                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u00A0\u0020\u200B", expected: [][]rune{{0x00A0, 0x0020, 0x200B}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u00A0\u0308\u200B", expected: [][]rune{{0x00A0, 0x0308, 0x200B}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u00A0\u0308\u0020\u200B", expected: [][]rune{{0x00A0, 0x0308, 0x0020, 0x200B}}},                                                                                                   // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u00A0\U0001F1E6", expected: [][]rune{{0x00A0, 0x1F1E6}}},                                                                                                                          // × [0.3] NO-BREAK SPACE (GL) × [12.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u00A0\u0020\U0001F1E6", expected: [][]rune{{0x00A0, 0x0020}, {0x1F1E6}}},                                                                                                          // × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u00A0\u0308\U0001F1E6", expected: [][]rune{{0x00A0, 0x0308, 0x1F1E6}}},                                                                                                            // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u00A0\u0308\u0020\U0001F1E6", expected: [][]rune{{0x00A0, 0x0308, 0x0020}, {0x1F1E6}}},                                                                                            // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u00A0\u261D", expected: [][]rune{{0x00A0, 0x261D}}},                                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [12.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u00A0\u0020\u261D", expected: [][]rune{{0x00A0, 0x0020}, {0x261D}}},                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u00A0\u0308\u261D", expected: [][]rune{{0x00A0, 0x0308, 0x261D}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u00A0\u0308\u0020\u261D", expected: [][]rune{{0x00A0, 0x0308, 0x0020}, {0x261D}}},                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u00A0\U0001F3FB", expected: [][]rune{{0x00A0, 0x1F3FB}}},                                                                                                                          // × [0.3] NO-BREAK SPACE (GL) × [12.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u00A0\u0020\U0001F3FB", expected: [][]rune{{0x00A0, 0x0020}, {0x1F3FB}}},                                                                                                          // × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u00A0\u0308\U0001F3FB", expected: [][]rune{{0x00A0, 0x0308, 0x1F3FB}}},                                                                                                            // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u00A0\u0308\u0020\U0001F3FB", expected: [][]rune{{0x00A0, 0x0308, 0x0020}, {0x1F3FB}}},                                                                                            // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u00A0\u0029", expected: [][]rune{{0x00A0, 0x0029}}},                                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [12.0] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u00A0\u0020\u0029", expected: [][]rune{{0x00A0, 0x0020, 0x0029}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u00A0\u0308\u0029", expected: [][]rune{{0x00A0, 0x0308, 0x0029}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u00A0\u0308\u0020\u0029", expected: [][]rune{{0x00A0, 0x0308, 0x0020, 0x0029}}},                                                                                                   // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u00A0\u0028", expected: [][]rune{{0x00A0, 0x0028}}},                                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [12.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u00A0\u0020\u0028", expected: [][]rune{{0x00A0, 0x0020}, {0x0028}}},                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u00A0\u0308\u0028", expected: [][]rune{{0x00A0, 0x0308, 0x0028}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u00A0\u0308\u0020\u0028", expected: [][]rune{{0x00A0, 0x0308, 0x0020}, {0x0028}}},                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u00A0\u0001", expected: [][]rune{{0x00A0, 0x0001}}},                                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u00A0\u0020\u0001", expected: [][]rune{{0x00A0, 0x0020}, {0x0001}}},                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u00A0\u0308\u0001", expected: [][]rune{{0x00A0, 0x0308, 0x0001}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u00A0\u0308\u0020\u0001", expected: [][]rune{{0x00A0, 0x0308, 0x0020}, {0x0001}}},                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u00A0\u200D", expected: [][]rune{{0x00A0, 0x200D}}},                                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u00A0\u0020\u200D", expected: [][]rune{{0x00A0, 0x0020}, {0x200D}}},                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u00A0\u0308\u200D", expected: [][]rune{{0x00A0, 0x0308, 0x200D}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u00A0\u0308\u0020\u200D", expected: [][]rune{{0x00A0, 0x0308, 0x0020}, {0x200D}}},                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u00A0\u00A7", expected: [][]rune{{0x00A0, 0x00A7}}},                                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [12.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u00A0\u0020\u00A7", expected: [][]rune{{0x00A0, 0x0020}, {0x00A7}}},                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u00A0\u0308\u00A7", expected: [][]rune{{0x00A0, 0x0308, 0x00A7}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u00A0\u0308\u0020\u00A7", expected: [][]rune{{0x00A0, 0x0308, 0x0020}, {0x00A7}}},                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u00A0\U00050005", expected: [][]rune{{0x00A0, 0x50005}}},                                                                                                                          // × [0.3] NO-BREAK SPACE (GL) × [12.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u00A0\u0020\U00050005", expected: [][]rune{{0x00A0, 0x0020}, {0x50005}}},                                                                                                          // × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u00A0\u0308\U00050005", expected: [][]rune{{0x00A0, 0x0308, 0x50005}}},                                                                                                            // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u00A0\u0308\u0020\U00050005", expected: [][]rune{{0x00A0, 0x0308, 0x0020}, {0x50005}}},                                                                                            // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u00A0\u0E01", expected: [][]rune{{0x00A0, 0x0E01}}},                                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [12.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u00A0\u0020\u0E01", expected: [][]rune{{0x00A0, 0x0020}, {0x0E01}}},                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u00A0\u0308\u0E01", expected: [][]rune{{0x00A0, 0x0308, 0x0E01}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u00A0\u0308\u0020\u0E01", expected: [][]rune{{0x00A0, 0x0308, 0x0020}, {0x0E01}}},                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u00A0\u3041", expected: [][]rune{{0x00A0, 0x3041}}},                                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [12.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u00A0\u0020\u3041", expected: [][]rune{{0x00A0, 0x0020}, {0x3041}}},                                                                                                               // × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u00A0\u0308\u3041", expected: [][]rune{{0x00A0, 0x0308, 0x3041}}},                                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u00A0\u0308\u0020\u3041", expected: [][]rune{{0x00A0, 0x0308, 0x0020}, {0x3041}}},                                                                                                 // × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\uAC00\u0023", expected: [][]rune{{0xAC00}, {0x0023}}},                                                                                                                             // × [0.3] HANGUL SYLLABLE GA (H2) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\uAC00\u0020\u0023", expected: [][]rune{{0xAC00, 0x0020}, {0x0023}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\uAC00\u0308\u0023", expected: [][]rune{{0xAC00, 0x0308}, {0x0023}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\uAC00\u0308\u0020\u0023", expected: [][]rune{{0xAC00, 0x0308, 0x0020}, {0x0023}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\uAC00\u2014", expected: [][]rune{{0xAC00}, {0x2014}}},                                                                                                                             // × [0.3] HANGUL SYLLABLE GA (H2) ÷ [999.0] EM DASH (B2) ÷ [0.3]
	{original: "\uAC00\u0020\u2014", expected: [][]rune{{0xAC00, 0x0020}, {0x2014}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
	{original: "\uAC00\u0308\u2014", expected: [][]rune{{0xAC00, 0x0308}, {0x2014}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
	{original: "\uAC00\u0308\u0020\u2014", expected: [][]rune{{0xAC00, 0x0308, 0x0020}, {0x2014}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
	{original: "\uAC00\u0009", expected: [][]rune{{0xAC00, 0x0009}}},                                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\uAC00\u0020\u0009", expected: [][]rune{{0xAC00, 0x0020}, {0x0009}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\uAC00\u0308\u0009", expected: [][]rune{{0xAC00, 0x0308, 0x0009}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\uAC00\u0308\u0020\u0009", expected: [][]rune{{0xAC00, 0x0308, 0x0020}, {0x0009}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\uAC00\u00B4", expected: [][]rune{{0xAC00}, {0x00B4}}},                                                                                                                             // × [0.3] HANGUL SYLLABLE GA (H2) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\uAC00\u0020\u00B4", expected: [][]rune{{0xAC00, 0x0020}, {0x00B4}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\uAC00\u0308\u00B4", expected: [][]rune{{0xAC00, 0x0308}, {0x00B4}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\uAC00\u0308\u0020\u00B4", expected: [][]rune{{0xAC00, 0x0308, 0x0020}, {0x00B4}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\uAC00\u000B", expected: [][]rune{{0xAC00, 0x000B}}},                                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\uAC00\u0020\u000B", expected: [][]rune{{0xAC00, 0x0020, 0x000B}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\uAC00\u0308\u000B", expected: [][]rune{{0xAC00, 0x0308, 0x000B}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\uAC00\u0308\u0020\u000B", expected: [][]rune{{0xAC00, 0x0308, 0x0020, 0x000B}}},                                                                                                   // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\uAC00\uFFFC", expected: [][]rune{{0xAC00}, {0xFFFC}}},                                                                                                                             // × [0.3] HANGUL SYLLABLE GA (H2) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\uAC00\u0020\uFFFC", expected: [][]rune{{0xAC00, 0x0020}, {0xFFFC}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\uAC00\u0308\uFFFC", expected: [][]rune{{0xAC00, 0x0308}, {0xFFFC}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\uAC00\u0308\u0020\uFFFC", expected: [][]rune{{0xAC00, 0x0308, 0x0020}, {0xFFFC}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\uAC00\u007D", expected: [][]rune{{0xAC00, 0x007D}}},                                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\uAC00\u0020\u007D", expected: [][]rune{{0xAC00, 0x0020, 0x007D}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\uAC00\u0308\u007D", expected: [][]rune{{0xAC00, 0x0308, 0x007D}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\uAC00\u0308\u0020\u007D", expected: [][]rune{{0xAC00, 0x0308, 0x0020, 0x007D}}},                                                                                                   // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\uAC00\u000D", expected: [][]rune{{0xAC00, 0x000D}}},                                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\uAC00\u0020\u000D", expected: [][]rune{{0xAC00, 0x0020, 0x000D}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\uAC00\u0308\u000D", expected: [][]rune{{0xAC00, 0x0308, 0x000D}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\uAC00\u0308\u0020\u000D", expected: [][]rune{{0xAC00, 0x0308, 0x0020, 0x000D}}},                                                                                                   // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\uAC00\u0021", expected: [][]rune{{0xAC00, 0x0021}}},                                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\uAC00\u0020\u0021", expected: [][]rune{{0xAC00, 0x0020, 0x0021}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\uAC00\u0308\u0021", expected: [][]rune{{0xAC00, 0x0308, 0x0021}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\uAC00\u0308\u0020\u0021", expected: [][]rune{{0xAC00, 0x0308, 0x0020, 0x0021}}},                                                                                                   // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\uAC00\u00A0", expected: [][]rune{{0xAC00, 0x00A0}}},                                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [12.1] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\uAC00\u0020\u00A0", expected: [][]rune{{0xAC00, 0x0020}, {0x00A0}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\uAC00\u0308\u00A0", expected: [][]rune{{0xAC00, 0x0308, 0x00A0}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\uAC00\u0308\u0020\u00A0", expected: [][]rune{{0xAC00, 0x0308, 0x0020}, {0x00A0}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\uAC00\uAC00", expected: [][]rune{{0xAC00}, {0xAC00}}},                                                                                                                             // × [0.3] HANGUL SYLLABLE GA (H2) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\uAC00\u0020\uAC00", expected: [][]rune{{0xAC00, 0x0020}, {0xAC00}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\uAC00\u0308\uAC00", expected: [][]rune{{0xAC00, 0x0308}, {0xAC00}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\uAC00\u0308\u0020\uAC00", expected: [][]rune{{0xAC00, 0x0308, 0x0020}, {0xAC00}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\uAC00\uAC01", expected: [][]rune{{0xAC00}, {0xAC01}}},                                                                                                                             // × [0.3] HANGUL SYLLABLE GA (H2) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\uAC00\u0020\uAC01", expected: [][]rune{{0xAC00, 0x0020}, {0xAC01}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\uAC00\u0308\uAC01", expected: [][]rune{{0xAC00, 0x0308}, {0xAC01}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\uAC00\u0308\u0020\uAC01", expected: [][]rune{{0xAC00, 0x0308, 0x0020}, {0xAC01}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\uAC00\u05D0", expected: [][]rune{{0xAC00}, {0x05D0}}},                                                                                                                             // × [0.3] HANGUL SYLLABLE GA (H2) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\uAC00\u0020\u05D0", expected: [][]rune{{0xAC00, 0x0020}, {0x05D0}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\uAC00\u0308\u05D0", expected: [][]rune{{0xAC00, 0x0308}, {0x05D0}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\uAC00\u0308\u0020\u05D0", expected: [][]rune{{0xAC00, 0x0308, 0x0020}, {0x05D0}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\uAC00\u002D", expected: [][]rune{{0xAC00, 0x002D}}},                                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\uAC00\u0020\u002D", expected: [][]rune{{0xAC00, 0x0020}, {0x002D}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\uAC00\u0308\u002D", expected: [][]rune{{0xAC00, 0x0308, 0x002D}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\uAC00\u0308\u0020\u002D", expected: [][]rune{{0xAC00, 0x0308, 0x0020}, {0x002D}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\uAC00\u231A", expected: [][]rune{{0xAC00}, {0x231A}}},                                                                                                                             // × [0.3] HANGUL SYLLABLE GA (H2) ÷ [999.0] WATCH (ID) ÷ [0.3]
	{original: "\uAC00\u0020\u231A", expected: [][]rune{{0xAC00, 0x0020}, {0x231A}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
	{original: "\uAC00\u0308\u231A", expected: [][]rune{{0xAC00, 0x0308}, {0x231A}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
	{original: "\uAC00\u0308\u0020\u231A", expected: [][]rune{{0xAC00, 0x0308, 0x0020}, {0x231A}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
	{original: "\uAC00\u2024", expected: [][]rune{{0xAC00, 0x2024}}},                                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\uAC00\u0020\u2024", expected: [][]rune{{0xAC00, 0x0020}, {0x2024}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\uAC00\u0308\u2024", expected: [][]rune{{0xAC00, 0x0308, 0x2024}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\uAC00\u0308\u0020\u2024", expected: [][]rune{{0xAC00, 0x0308, 0x0020}, {0x2024}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\uAC00\u002C", expected: [][]rune{{0xAC00, 0x002C}}},                                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\uAC00\u0020\u002C", expected: [][]rune{{0xAC00, 0x0020, 0x002C}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\uAC00\u0308\u002C", expected: [][]rune{{0xAC00, 0x0308, 0x002C}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
	{original: "\uAC00\u0308\u0020\u002C", expected: [][]rune{{0xAC00, 0x0308, 0x0020, 0x002C}}},                                                                                                   // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\uAC00\u1100", expected: [][]rune{{0xAC00}, {0x1100}}},                                                                                                                             // × [0.3] HANGUL SYLLABLE GA (H2) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\uAC00\u0020\u1100", expected: [][]rune{{0xAC00, 0x0020}, {0x1100}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\uAC00\u0308\u1100", expected: [][]rune{{0xAC00, 0x0308}, {0x1100}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\uAC00\u0308\u0020\u1100", expected: [][]rune{{0xAC00, 0x0308, 0x0020}, {0x1100}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\uAC00\u11A8", expected: [][]rune{{0xAC00, 0x11A8}}},                                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [26.02] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\uAC00\u0020\u11A8", expected: [][]rune{{0xAC00, 0x0020}, {0x11A8}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\uAC00\u0308\u11A8", expected: [][]rune{{0xAC00, 0x0308, 0x11A8}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [26.02] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\uAC00\u0308\u0020\u11A8", expected: [][]rune{{0xAC00, 0x0308, 0x0020}, {0x11A8}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\uAC00\u1160", expected: [][]rune{{0xAC00, 0x1160}}},                                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [26.02] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\uAC00\u0020\u1160", expected: [][]rune{{0xAC00, 0x0020}, {0x1160}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\uAC00\u0308\u1160", expected: [][]rune{{0xAC00, 0x0308, 0x1160}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [26.02] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\uAC00\u0308\u0020\u1160", expected: [][]rune{{0xAC00, 0x0308, 0x0020}, {0x1160}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\uAC00\u000A", expected: [][]rune{{0xAC00, 0x000A}}},                                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\uAC00\u0020\u000A", expected: [][]rune{{0xAC00, 0x0020, 0x000A}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\uAC00\u0308\u000A", expected: [][]rune{{0xAC00, 0x0308, 0x000A}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\uAC00\u0308\u0020\u000A", expected: [][]rune{{0xAC00, 0x0308, 0x0020, 0x000A}}},                                                                                                   // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\uAC00\u0085", expected: [][]rune{{0xAC00, 0x0085}}},                                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\uAC00\u0020\u0085", expected: [][]rune{{0xAC00, 0x0020, 0x0085}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\uAC00\u0308\u0085", expected: [][]rune{{0xAC00, 0x0308, 0x0085}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\uAC00\u0308\u0020\u0085", expected: [][]rune{{0xAC00, 0x0308, 0x0020, 0x0085}}},                                                                                                   // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\uAC00\u17D6", expected: [][]rune{{0xAC00, 0x17D6}}},                                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\uAC00\u0020\u17D6", expected: [][]rune{{0xAC00, 0x0020}, {0x17D6}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\uAC00\u0308\u17D6", expected: [][]rune{{0xAC00, 0x0308, 0x17D6}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\uAC00\u0308\u0020\u17D6", expected: [][]rune{{0xAC00, 0x0308, 0x0020}, {0x17D6}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\uAC00\u0030", expected: [][]rune{{0xAC00}, {0x0030}}},                                                                                                                             // × [0.3] HANGUL SYLLABLE GA (H2) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\uAC00\u0020\u0030", expected: [][]rune{{0xAC00, 0x0020}, {0x0030}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\uAC00\u0308\u0030", expected: [][]rune{{0xAC00, 0x0308}, {0x0030}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\uAC00\u0308\u0020\u0030", expected: [][]rune{{0xAC00, 0x0308, 0x0020}, {0x0030}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\uAC00\u2329", expected: [][]rune{{0xAC00}, {0x2329}}},                                                                                                                             // × [0.3] HANGUL SYLLABLE GA (H2) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\uAC00\u0020\u2329", expected: [][]rune{{0xAC00, 0x0020}, {0x2329}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\uAC00\u0308\u2329", expected: [][]rune{{0xAC00, 0x0308}, {0x2329}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\uAC00\u0308\u0020\u2329", expected: [][]rune{{0xAC00, 0x0308, 0x0020}, {0x2329}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\uAC00\u0025", expected: [][]rune{{0xAC00, 0x0025}}},                                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [27.01] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\uAC00\u0020\u0025", expected: [][]rune{{0xAC00, 0x0020}, {0x0025}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\uAC00\u0308\u0025", expected: [][]rune{{0xAC00, 0x0308, 0x0025}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [27.01] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\uAC00\u0308\u0020\u0025", expected: [][]rune{{0xAC00, 0x0308, 0x0020}, {0x0025}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\uAC00\u0024", expected: [][]rune{{0xAC00}, {0x0024}}},                                                                                                                             // × [0.3] HANGUL SYLLABLE GA (H2) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\uAC00\u0020\u0024", expected: [][]rune{{0xAC00, 0x0020}, {0x0024}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\uAC00\u0308\u0024", expected: [][]rune{{0xAC00, 0x0308}, {0x0024}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\uAC00\u0308\u0020\u0024", expected: [][]rune{{0xAC00, 0x0308, 0x0020}, {0x0024}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\uAC00\u0022", expected: [][]rune{{0xAC00, 0x0022}}},                                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\uAC00\u0020\u0022", expected: [][]rune{{0xAC00, 0x0020}, {0x0022}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\uAC00\u0308\u0022", expected: [][]rune{{0xAC00, 0x0308, 0x0022}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\uAC00\u0308\u0020\u0022", expected: [][]rune{{0xAC00, 0x0308, 0x0020}, {0x0022}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\uAC00\u0020", expected: [][]rune{{0xAC00, 0x0020}}},                                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\uAC00\u0020\u0020", expected: [][]rune{{0xAC00, 0x0020, 0x0020}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\uAC00\u0308\u0020", expected: [][]rune{{0xAC00, 0x0308, 0x0020}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\uAC00\u0308\u0020\u0020", expected: [][]rune{{0xAC00, 0x0308, 0x0020, 0x0020}}},                                                                                                   // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\uAC00\u002F", expected: [][]rune{{0xAC00, 0x002F}}},                                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\uAC00\u0020\u002F", expected: [][]rune{{0xAC00, 0x0020, 0x002F}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\uAC00\u0308\u002F", expected: [][]rune{{0xAC00, 0x0308, 0x002F}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
	{original: "\uAC00\u0308\u0020\u002F", expected: [][]rune{{0xAC00, 0x0308, 0x0020, 0x002F}}},                                                                                                   // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\uAC00\u2060", expected: [][]rune{{0xAC00, 0x2060}}},                                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\uAC00\u0020\u2060", expected: [][]rune{{0xAC00, 0x0020, 0x2060}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\uAC00\u0308\u2060", expected: [][]rune{{0xAC00, 0x0308, 0x2060}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\uAC00\u0308\u0020\u2060", expected: [][]rune{{0xAC00, 0x0308, 0x0020, 0x2060}}},                                                                                                   // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\uAC00\u200B", expected: [][]rune{{0xAC00, 0x200B}}},                                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\uAC00\u0020\u200B", expected: [][]rune{{0xAC00, 0x0020, 0x200B}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\uAC00\u0308\u200B", expected: [][]rune{{0xAC00, 0x0308, 0x200B}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\uAC00\u0308\u0020\u200B", expected: [][]rune{{0xAC00, 0x0308, 0x0020, 0x200B}}},                                                                                                   // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\uAC00\U0001F1E6", expected: [][]rune{{0xAC00}, {0x1F1E6}}},                                                                                                                        // × [0.3] HANGUL SYLLABLE GA (H2) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\uAC00\u0020\U0001F1E6", expected: [][]rune{{0xAC00, 0x0020}, {0x1F1E6}}},                                                                                                          // × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\uAC00\u0308\U0001F1E6", expected: [][]rune{{0xAC00, 0x0308}, {0x1F1E6}}},                                                                                                          // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\uAC00\u0308\u0020\U0001F1E6", expected: [][]rune{{0xAC00, 0x0308, 0x0020}, {0x1F1E6}}},                                                                                            // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\uAC00\u261D", expected: [][]rune{{0xAC00}, {0x261D}}},                                                                                                                             // × [0.3] HANGUL SYLLABLE GA (H2) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\uAC00\u0020\u261D", expected: [][]rune{{0xAC00, 0x0020}, {0x261D}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\uAC00\u0308\u261D", expected: [][]rune{{0xAC00, 0x0308}, {0x261D}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\uAC00\u0308\u0020\u261D", expected: [][]rune{{0xAC00, 0x0308, 0x0020}, {0x261D}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\uAC00\U0001F3FB", expected: [][]rune{{0xAC00}, {0x1F3FB}}},                                                                                                                        // × [0.3] HANGUL SYLLABLE GA (H2) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\uAC00\u0020\U0001F3FB", expected: [][]rune{{0xAC00, 0x0020}, {0x1F3FB}}},                                                                                                          // × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\uAC00\u0308\U0001F3FB", expected: [][]rune{{0xAC00, 0x0308}, {0x1F3FB}}},                                                                                                          // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\uAC00\u0308\u0020\U0001F3FB", expected: [][]rune{{0xAC00, 0x0308, 0x0020}, {0x1F3FB}}},                                                                                            // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\uAC00\u0029", expected: [][]rune{{0xAC00, 0x0029}}},                                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\uAC00\u0020\u0029", expected: [][]rune{{0xAC00, 0x0020, 0x0029}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\uAC00\u0308\u0029", expected: [][]rune{{0xAC00, 0x0308, 0x0029}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\uAC00\u0308\u0020\u0029", expected: [][]rune{{0xAC00, 0x0308, 0x0020, 0x0029}}},                                                                                                   // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\uAC00\u0028", expected: [][]rune{{0xAC00}, {0x0028}}},                                                                                                                             // × [0.3] HANGUL SYLLABLE GA (H2) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\uAC00\u0020\u0028", expected: [][]rune{{0xAC00, 0x0020}, {0x0028}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\uAC00\u0308\u0028", expected: [][]rune{{0xAC00, 0x0308}, {0x0028}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\uAC00\u0308\u0020\u0028", expected: [][]rune{{0xAC00, 0x0308, 0x0020}, {0x0028}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\uAC00\u0001", expected: [][]rune{{0xAC00, 0x0001}}},                                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\uAC00\u0020\u0001", expected: [][]rune{{0xAC00, 0x0020}, {0x0001}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\uAC00\u0308\u0001", expected: [][]rune{{0xAC00, 0x0308, 0x0001}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\uAC00\u0308\u0020\u0001", expected: [][]rune{{0xAC00, 0x0308, 0x0020}, {0x0001}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\uAC00\u200D", expected: [][]rune{{0xAC00, 0x200D}}},                                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\uAC00\u0020\u200D", expected: [][]rune{{0xAC00, 0x0020}, {0x200D}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\uAC00\u0308\u200D", expected: [][]rune{{0xAC00, 0x0308, 0x200D}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\uAC00\u0308\u0020\u200D", expected: [][]rune{{0xAC00, 0x0308, 0x0020}, {0x200D}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\uAC00\u00A7", expected: [][]rune{{0xAC00}, {0x00A7}}},                                                                                                                             // × [0.3] HANGUL SYLLABLE GA (H2) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\uAC00\u0020\u00A7", expected: [][]rune{{0xAC00, 0x0020}, {0x00A7}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\uAC00\u0308\u00A7", expected: [][]rune{{0xAC00, 0x0308}, {0x00A7}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\uAC00\u0308\u0020\u00A7", expected: [][]rune{{0xAC00, 0x0308, 0x0020}, {0x00A7}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\uAC00\U00050005", expected: [][]rune{{0xAC00}, {0x50005}}},                                                                                                                        // × [0.3] HANGUL SYLLABLE GA (H2) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\uAC00\u0020\U00050005", expected: [][]rune{{0xAC00, 0x0020}, {0x50005}}},                                                                                                          // × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\uAC00\u0308\U00050005", expected: [][]rune{{0xAC00, 0x0308}, {0x50005}}},                                                                                                          // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\uAC00\u0308\u0020\U00050005", expected: [][]rune{{0xAC00, 0x0308, 0x0020}, {0x50005}}},                                                                                            // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\uAC00\u0E01", expected: [][]rune{{0xAC00}, {0x0E01}}},                                                                                                                             // × [0.3] HANGUL SYLLABLE GA (H2) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\uAC00\u0020\u0E01", expected: [][]rune{{0xAC00, 0x0020}, {0x0E01}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\uAC00\u0308\u0E01", expected: [][]rune{{0xAC00, 0x0308}, {0x0E01}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\uAC00\u0308\u0020\u0E01", expected: [][]rune{{0xAC00, 0x0308, 0x0020}, {0x0E01}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\uAC00\u3041", expected: [][]rune{{0xAC00, 0x3041}}},                                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\uAC00\u0020\u3041", expected: [][]rune{{0xAC00, 0x0020}, {0x3041}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\uAC00\u0308\u3041", expected: [][]rune{{0xAC00, 0x0308, 0x3041}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\uAC00\u0308\u0020\u3041", expected: [][]rune{{0xAC00, 0x0308, 0x0020}, {0x3041}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\uAC01\u0023", expected: [][]rune{{0xAC01}, {0x0023}}},                                                                                                                             // × [0.3] HANGUL SYLLABLE GAG (H3) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\uAC01\u0020\u0023", expected: [][]rune{{0xAC01, 0x0020}, {0x0023}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\uAC01\u0308\u0023", expected: [][]rune{{0xAC01, 0x0308}, {0x0023}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\uAC01\u0308\u0020\u0023", expected: [][]rune{{0xAC01, 0x0308, 0x0020}, {0x0023}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\uAC01\u2014", expected: [][]rune{{0xAC01}, {0x2014}}},                                                                                                                             // × [0.3] HANGUL SYLLABLE GAG (H3) ÷ [999.0] EM DASH (B2) ÷ [0.3]
	{original: "\uAC01\u0020\u2014", expected: [][]rune{{0xAC01, 0x0020}, {0x2014}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
	{original: "\uAC01\u0308\u2014", expected: [][]rune{{0xAC01, 0x0308}, {0x2014}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
	{original: "\uAC01\u0308\u0020\u2014", expected: [][]rune{{0xAC01, 0x0308, 0x0020}, {0x2014}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
	{original: "\uAC01\u0009", expected: [][]rune{{0xAC01, 0x0009}}},                                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\uAC01\u0020\u0009", expected: [][]rune{{0xAC01, 0x0020}, {0x0009}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\uAC01\u0308\u0009", expected: [][]rune{{0xAC01, 0x0308, 0x0009}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\uAC01\u0308\u0020\u0009", expected: [][]rune{{0xAC01, 0x0308, 0x0020}, {0x0009}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\uAC01\u00B4", expected: [][]rune{{0xAC01}, {0x00B4}}},                                                                                                                             // × [0.3] HANGUL SYLLABLE GAG (H3) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\uAC01\u0020\u00B4", expected: [][]rune{{0xAC01, 0x0020}, {0x00B4}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\uAC01\u0308\u00B4", expected: [][]rune{{0xAC01, 0x0308}, {0x00B4}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\uAC01\u0308\u0020\u00B4", expected: [][]rune{{0xAC01, 0x0308, 0x0020}, {0x00B4}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\uAC01\u000B", expected: [][]rune{{0xAC01, 0x000B}}},                                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\uAC01\u0020\u000B", expected: [][]rune{{0xAC01, 0x0020, 0x000B}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\uAC01\u0308\u000B", expected: [][]rune{{0xAC01, 0x0308, 0x000B}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\uAC01\u0308\u0020\u000B", expected: [][]rune{{0xAC01, 0x0308, 0x0020, 0x000B}}},                                                                                                   // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\uAC01\uFFFC", expected: [][]rune{{0xAC01}, {0xFFFC}}},                                                                                                                             // × [0.3] HANGUL SYLLABLE GAG (H3) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\uAC01\u0020\uFFFC", expected: [][]rune{{0xAC01, 0x0020}, {0xFFFC}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\uAC01\u0308\uFFFC", expected: [][]rune{{0xAC01, 0x0308}, {0xFFFC}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\uAC01\u0308\u0020\uFFFC", expected: [][]rune{{0xAC01, 0x0308, 0x0020}, {0xFFFC}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\uAC01\u007D", expected: [][]rune{{0xAC01, 0x007D}}},                                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\uAC01\u0020\u007D", expected: [][]rune{{0xAC01, 0x0020, 0x007D}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\uAC01\u0308\u007D", expected: [][]rune{{0xAC01, 0x0308, 0x007D}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\uAC01\u0308\u0020\u007D", expected: [][]rune{{0xAC01, 0x0308, 0x0020, 0x007D}}},                                                                                                   // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\uAC01\u000D", expected: [][]rune{{0xAC01, 0x000D}}},                                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\uAC01\u0020\u000D", expected: [][]rune{{0xAC01, 0x0020, 0x000D}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\uAC01\u0308\u000D", expected: [][]rune{{0xAC01, 0x0308, 0x000D}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\uAC01\u0308\u0020\u000D", expected: [][]rune{{0xAC01, 0x0308, 0x0020, 0x000D}}},                                                                                                   // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\uAC01\u0021", expected: [][]rune{{0xAC01, 0x0021}}},                                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\uAC01\u0020\u0021", expected: [][]rune{{0xAC01, 0x0020, 0x0021}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\uAC01\u0308\u0021", expected: [][]rune{{0xAC01, 0x0308, 0x0021}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\uAC01\u0308\u0020\u0021", expected: [][]rune{{0xAC01, 0x0308, 0x0020, 0x0021}}},                                                                                                   // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\uAC01\u00A0", expected: [][]rune{{0xAC01, 0x00A0}}},                                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [12.1] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\uAC01\u0020\u00A0", expected: [][]rune{{0xAC01, 0x0020}, {0x00A0}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\uAC01\u0308\u00A0", expected: [][]rune{{0xAC01, 0x0308, 0x00A0}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\uAC01\u0308\u0020\u00A0", expected: [][]rune{{0xAC01, 0x0308, 0x0020}, {0x00A0}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\uAC01\uAC00", expected: [][]rune{{0xAC01}, {0xAC00}}},                                                                                                                             // × [0.3] HANGUL SYLLABLE GAG (H3) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\uAC01\u0020\uAC00", expected: [][]rune{{0xAC01, 0x0020}, {0xAC00}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\uAC01\u0308\uAC00", expected: [][]rune{{0xAC01, 0x0308}, {0xAC00}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\uAC01\u0308\u0020\uAC00", expected: [][]rune{{0xAC01, 0x0308, 0x0020}, {0xAC00}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\uAC01\uAC01", expected: [][]rune{{0xAC01}, {0xAC01}}},                                                                                                                             // × [0.3] HANGUL SYLLABLE GAG (H3) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\uAC01\u0020\uAC01", expected: [][]rune{{0xAC01, 0x0020}, {0xAC01}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\uAC01\u0308\uAC01", expected: [][]rune{{0xAC01, 0x0308}, {0xAC01}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\uAC01\u0308\u0020\uAC01", expected: [][]rune{{0xAC01, 0x0308, 0x0020}, {0xAC01}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\uAC01\u05D0", expected: [][]rune{{0xAC01}, {0x05D0}}},                                                                                                                             // × [0.3] HANGUL SYLLABLE GAG (H3) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\uAC01\u0020\u05D0", expected: [][]rune{{0xAC01, 0x0020}, {0x05D0}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\uAC01\u0308\u05D0", expected: [][]rune{{0xAC01, 0x0308}, {0x05D0}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\uAC01\u0308\u0020\u05D0", expected: [][]rune{{0xAC01, 0x0308, 0x0020}, {0x05D0}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\uAC01\u002D", expected: [][]rune{{0xAC01, 0x002D}}},                                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\uAC01\u0020\u002D", expected: [][]rune{{0xAC01, 0x0020}, {0x002D}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\uAC01\u0308\u002D", expected: [][]rune{{0xAC01, 0x0308, 0x002D}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\uAC01\u0308\u0020\u002D", expected: [][]rune{{0xAC01, 0x0308, 0x0020}, {0x002D}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\uAC01\u231A", expected: [][]rune{{0xAC01}, {0x231A}}},                                                                                                                             // × [0.3] HANGUL SYLLABLE GAG (H3) ÷ [999.0] WATCH (ID) ÷ [0.3]
	{original: "\uAC01\u0020\u231A", expected: [][]rune{{0xAC01, 0x0020}, {0x231A}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
	{original: "\uAC01\u0308\u231A", expected: [][]rune{{0xAC01, 0x0308}, {0x231A}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
	{original: "\uAC01\u0308\u0020\u231A", expected: [][]rune{{0xAC01, 0x0308, 0x0020}, {0x231A}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
	{original: "\uAC01\u2024", expected: [][]rune{{0xAC01, 0x2024}}},                                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\uAC01\u0020\u2024", expected: [][]rune{{0xAC01, 0x0020}, {0x2024}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\uAC01\u0308\u2024", expected: [][]rune{{0xAC01, 0x0308, 0x2024}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\uAC01\u0308\u0020\u2024", expected: [][]rune{{0xAC01, 0x0308, 0x0020}, {0x2024}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\uAC01\u002C", expected: [][]rune{{0xAC01, 0x002C}}},                                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\uAC01\u0020\u002C", expected: [][]rune{{0xAC01, 0x0020, 0x002C}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\uAC01\u0308\u002C", expected: [][]rune{{0xAC01, 0x0308, 0x002C}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
	{original: "\uAC01\u0308\u0020\u002C", expected: [][]rune{{0xAC01, 0x0308, 0x0020, 0x002C}}},                                                                                                   // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\uAC01\u1100", expected: [][]rune{{0xAC01}, {0x1100}}},                                                                                                                             // × [0.3] HANGUL SYLLABLE GAG (H3) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\uAC01\u0020\u1100", expected: [][]rune{{0xAC01, 0x0020}, {0x1100}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\uAC01\u0308\u1100", expected: [][]rune{{0xAC01, 0x0308}, {0x1100}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\uAC01\u0308\u0020\u1100", expected: [][]rune{{0xAC01, 0x0308, 0x0020}, {0x1100}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\uAC01\u11A8", expected: [][]rune{{0xAC01, 0x11A8}}},                                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [26.03] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\uAC01\u0020\u11A8", expected: [][]rune{{0xAC01, 0x0020}, {0x11A8}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\uAC01\u0308\u11A8", expected: [][]rune{{0xAC01, 0x0308, 0x11A8}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [26.03] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\uAC01\u0308\u0020\u11A8", expected: [][]rune{{0xAC01, 0x0308, 0x0020}, {0x11A8}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\uAC01\u1160", expected: [][]rune{{0xAC01}, {0x1160}}},                                                                                                                             // × [0.3] HANGUL SYLLABLE GAG (H3) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\uAC01\u0020\u1160", expected: [][]rune{{0xAC01, 0x0020}, {0x1160}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\uAC01\u0308\u1160", expected: [][]rune{{0xAC01, 0x0308}, {0x1160}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\uAC01\u0308\u0020\u1160", expected: [][]rune{{0xAC01, 0x0308, 0x0020}, {0x1160}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\uAC01\u000A", expected: [][]rune{{0xAC01, 0x000A}}},                                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\uAC01\u0020\u000A", expected: [][]rune{{0xAC01, 0x0020, 0x000A}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\uAC01\u0308\u000A", expected: [][]rune{{0xAC01, 0x0308, 0x000A}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\uAC01\u0308\u0020\u000A", expected: [][]rune{{0xAC01, 0x0308, 0x0020, 0x000A}}},                                                                                                   // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\uAC01\u0085", expected: [][]rune{{0xAC01, 0x0085}}},                                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\uAC01\u0020\u0085", expected: [][]rune{{0xAC01, 0x0020, 0x0085}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\uAC01\u0308\u0085", expected: [][]rune{{0xAC01, 0x0308, 0x0085}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\uAC01\u0308\u0020\u0085", expected: [][]rune{{0xAC01, 0x0308, 0x0020, 0x0085}}},                                                                                                   // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\uAC01\u17D6", expected: [][]rune{{0xAC01, 0x17D6}}},                                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\uAC01\u0020\u17D6", expected: [][]rune{{0xAC01, 0x0020}, {0x17D6}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\uAC01\u0308\u17D6", expected: [][]rune{{0xAC01, 0x0308, 0x17D6}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\uAC01\u0308\u0020\u17D6", expected: [][]rune{{0xAC01, 0x0308, 0x0020}, {0x17D6}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\uAC01\u0030", expected: [][]rune{{0xAC01}, {0x0030}}},                                                                                                                             // × [0.3] HANGUL SYLLABLE GAG (H3) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\uAC01\u0020\u0030", expected: [][]rune{{0xAC01, 0x0020}, {0x0030}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\uAC01\u0308\u0030", expected: [][]rune{{0xAC01, 0x0308}, {0x0030}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\uAC01\u0308\u0020\u0030", expected: [][]rune{{0xAC01, 0x0308, 0x0020}, {0x0030}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\uAC01\u2329", expected: [][]rune{{0xAC01}, {0x2329}}},                                                                                                                             // × [0.3] HANGUL SYLLABLE GAG (H3) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\uAC01\u0020\u2329", expected: [][]rune{{0xAC01, 0x0020}, {0x2329}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\uAC01\u0308\u2329", expected: [][]rune{{0xAC01, 0x0308}, {0x2329}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\uAC01\u0308\u0020\u2329", expected: [][]rune{{0xAC01, 0x0308, 0x0020}, {0x2329}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\uAC01\u0025", expected: [][]rune{{0xAC01, 0x0025}}},                                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [27.01] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\uAC01\u0020\u0025", expected: [][]rune{{0xAC01, 0x0020}, {0x0025}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\uAC01\u0308\u0025", expected: [][]rune{{0xAC01, 0x0308, 0x0025}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [27.01] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\uAC01\u0308\u0020\u0025", expected: [][]rune{{0xAC01, 0x0308, 0x0020}, {0x0025}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\uAC01\u0024", expected: [][]rune{{0xAC01}, {0x0024}}},                                                                                                                             // × [0.3] HANGUL SYLLABLE GAG (H3) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\uAC01\u0020\u0024", expected: [][]rune{{0xAC01, 0x0020}, {0x0024}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\uAC01\u0308\u0024", expected: [][]rune{{0xAC01, 0x0308}, {0x0024}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\uAC01\u0308\u0020\u0024", expected: [][]rune{{0xAC01, 0x0308, 0x0020}, {0x0024}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\uAC01\u0022", expected: [][]rune{{0xAC01, 0x0022}}},                                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\uAC01\u0020\u0022", expected: [][]rune{{0xAC01, 0x0020}, {0x0022}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\uAC01\u0308\u0022", expected: [][]rune{{0xAC01, 0x0308, 0x0022}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\uAC01\u0308\u0020\u0022", expected: [][]rune{{0xAC01, 0x0308, 0x0020}, {0x0022}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\uAC01\u0020", expected: [][]rune{{0xAC01, 0x0020}}},                                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\uAC01\u0020\u0020", expected: [][]rune{{0xAC01, 0x0020, 0x0020}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\uAC01\u0308\u0020", expected: [][]rune{{0xAC01, 0x0308, 0x0020}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\uAC01\u0308\u0020\u0020", expected: [][]rune{{0xAC01, 0x0308, 0x0020, 0x0020}}},                                                                                                   // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\uAC01\u002F", expected: [][]rune{{0xAC01, 0x002F}}},                                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\uAC01\u0020\u002F", expected: [][]rune{{0xAC01, 0x0020, 0x002F}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\uAC01\u0308\u002F", expected: [][]rune{{0xAC01, 0x0308, 0x002F}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
	{original: "\uAC01\u0308\u0020\u002F", expected: [][]rune{{0xAC01, 0x0308, 0x0020, 0x002F}}},                                                                                                   // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\uAC01\u2060", expected: [][]rune{{0xAC01, 0x2060}}},                                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\uAC01\u0020\u2060", expected: [][]rune{{0xAC01, 0x0020, 0x2060}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\uAC01\u0308\u2060", expected: [][]rune{{0xAC01, 0x0308, 0x2060}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\uAC01\u0308\u0020\u2060", expected: [][]rune{{0xAC01, 0x0308, 0x0020, 0x2060}}},                                                                                                   // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\uAC01\u200B", expected: [][]rune{{0xAC01, 0x200B}}},                                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\uAC01\u0020\u200B", expected: [][]rune{{0xAC01, 0x0020, 0x200B}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\uAC01\u0308\u200B", expected: [][]rune{{0xAC01, 0x0308, 0x200B}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\uAC01\u0308\u0020\u200B", expected: [][]rune{{0xAC01, 0x0308, 0x0020, 0x200B}}},                                                                                                   // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\uAC01\U0001F1E6", expected: [][]rune{{0xAC01}, {0x1F1E6}}},                                                                                                                        // × [0.3] HANGUL SYLLABLE GAG (H3) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\uAC01\u0020\U0001F1E6", expected: [][]rune{{0xAC01, 0x0020}, {0x1F1E6}}},                                                                                                          // × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\uAC01\u0308\U0001F1E6", expected: [][]rune{{0xAC01, 0x0308}, {0x1F1E6}}},                                                                                                          // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\uAC01\u0308\u0020\U0001F1E6", expected: [][]rune{{0xAC01, 0x0308, 0x0020}, {0x1F1E6}}},                                                                                            // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\uAC01\u261D", expected: [][]rune{{0xAC01}, {0x261D}}},                                                                                                                             // × [0.3] HANGUL SYLLABLE GAG (H3) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\uAC01\u0020\u261D", expected: [][]rune{{0xAC01, 0x0020}, {0x261D}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\uAC01\u0308\u261D", expected: [][]rune{{0xAC01, 0x0308}, {0x261D}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\uAC01\u0308\u0020\u261D", expected: [][]rune{{0xAC01, 0x0308, 0x0020}, {0x261D}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\uAC01\U0001F3FB", expected: [][]rune{{0xAC01}, {0x1F3FB}}},                                                                                                                        // × [0.3] HANGUL SYLLABLE GAG (H3) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\uAC01\u0020\U0001F3FB", expected: [][]rune{{0xAC01, 0x0020}, {0x1F3FB}}},                                                                                                          // × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\uAC01\u0308\U0001F3FB", expected: [][]rune{{0xAC01, 0x0308}, {0x1F3FB}}},                                                                                                          // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\uAC01\u0308\u0020\U0001F3FB", expected: [][]rune{{0xAC01, 0x0308, 0x0020}, {0x1F3FB}}},                                                                                            // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\uAC01\u0029", expected: [][]rune{{0xAC01, 0x0029}}},                                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\uAC01\u0020\u0029", expected: [][]rune{{0xAC01, 0x0020, 0x0029}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\uAC01\u0308\u0029", expected: [][]rune{{0xAC01, 0x0308, 0x0029}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\uAC01\u0308\u0020\u0029", expected: [][]rune{{0xAC01, 0x0308, 0x0020, 0x0029}}},                                                                                                   // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\uAC01\u0028", expected: [][]rune{{0xAC01}, {0x0028}}},                                                                                                                             // × [0.3] HANGUL SYLLABLE GAG (H3) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\uAC01\u0020\u0028", expected: [][]rune{{0xAC01, 0x0020}, {0x0028}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\uAC01\u0308\u0028", expected: [][]rune{{0xAC01, 0x0308}, {0x0028}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\uAC01\u0308\u0020\u0028", expected: [][]rune{{0xAC01, 0x0308, 0x0020}, {0x0028}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\uAC01\u0001", expected: [][]rune{{0xAC01, 0x0001}}},                                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\uAC01\u0020\u0001", expected: [][]rune{{0xAC01, 0x0020}, {0x0001}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\uAC01\u0308\u0001", expected: [][]rune{{0xAC01, 0x0308, 0x0001}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\uAC01\u0308\u0020\u0001", expected: [][]rune{{0xAC01, 0x0308, 0x0020}, {0x0001}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\uAC01\u200D", expected: [][]rune{{0xAC01, 0x200D}}},                                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\uAC01\u0020\u200D", expected: [][]rune{{0xAC01, 0x0020}, {0x200D}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\uAC01\u0308\u200D", expected: [][]rune{{0xAC01, 0x0308, 0x200D}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\uAC01\u0308\u0020\u200D", expected: [][]rune{{0xAC01, 0x0308, 0x0020}, {0x200D}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\uAC01\u00A7", expected: [][]rune{{0xAC01}, {0x00A7}}},                                                                                                                             // × [0.3] HANGUL SYLLABLE GAG (H3) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\uAC01\u0020\u00A7", expected: [][]rune{{0xAC01, 0x0020}, {0x00A7}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\uAC01\u0308\u00A7", expected: [][]rune{{0xAC01, 0x0308}, {0x00A7}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\uAC01\u0308\u0020\u00A7", expected: [][]rune{{0xAC01, 0x0308, 0x0020}, {0x00A7}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\uAC01\U00050005", expected: [][]rune{{0xAC01}, {0x50005}}},                                                                                                                        // × [0.3] HANGUL SYLLABLE GAG (H3) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\uAC01\u0020\U00050005", expected: [][]rune{{0xAC01, 0x0020}, {0x50005}}},                                                                                                          // × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\uAC01\u0308\U00050005", expected: [][]rune{{0xAC01, 0x0308}, {0x50005}}},                                                                                                          // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\uAC01\u0308\u0020\U00050005", expected: [][]rune{{0xAC01, 0x0308, 0x0020}, {0x50005}}},                                                                                            // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\uAC01\u0E01", expected: [][]rune{{0xAC01}, {0x0E01}}},                                                                                                                             // × [0.3] HANGUL SYLLABLE GAG (H3) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\uAC01\u0020\u0E01", expected: [][]rune{{0xAC01, 0x0020}, {0x0E01}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\uAC01\u0308\u0E01", expected: [][]rune{{0xAC01, 0x0308}, {0x0E01}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\uAC01\u0308\u0020\u0E01", expected: [][]rune{{0xAC01, 0x0308, 0x0020}, {0x0E01}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\uAC01\u3041", expected: [][]rune{{0xAC01, 0x3041}}},                                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\uAC01\u0020\u3041", expected: [][]rune{{0xAC01, 0x0020}, {0x3041}}},                                                                                                               // × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\uAC01\u0308\u3041", expected: [][]rune{{0xAC01, 0x0308, 0x3041}}},                                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\uAC01\u0308\u0020\u3041", expected: [][]rune{{0xAC01, 0x0308, 0x0020}, {0x3041}}},                                                                                                 // × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u05D0\u0023", expected: [][]rune{{0x05D0, 0x0023}}},                                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [28.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u05D0\u0020\u0023", expected: [][]rune{{0x05D0, 0x0020}, {0x0023}}},                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u05D0\u0308\u0023", expected: [][]rune{{0x05D0, 0x0308, 0x0023}}},                                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [28.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u05D0\u0308\u0020\u0023", expected: [][]rune{{0x05D0, 0x0308, 0x0020}, {0x0023}}},                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u05D0\u2014", expected: [][]rune{{0x05D0}, {0x2014}}},                                                                                                                             // × [0.3] HEBREW LETTER ALEF (HL) ÷ [999.0] EM DASH (B2) ÷ [0.3]
	{original: "\u05D0\u0020\u2014", expected: [][]rune{{0x05D0, 0x0020}, {0x2014}}},                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
	{original: "\u05D0\u0308\u2014", expected: [][]rune{{0x05D0, 0x0308}, {0x2014}}},                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
	{original: "\u05D0\u0308\u0020\u2014", expected: [][]rune{{0x05D0, 0x0308, 0x0020}, {0x2014}}},                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
	{original: "\u05D0\u0009", expected: [][]rune{{0x05D0, 0x0009}}},                                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u05D0\u0020\u0009", expected: [][]rune{{0x05D0, 0x0020}, {0x0009}}},                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u05D0\u0308\u0009", expected: [][]rune{{0x05D0, 0x0308, 0x0009}}},                                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u05D0\u0308\u0020\u0009", expected: [][]rune{{0x05D0, 0x0308, 0x0020}, {0x0009}}},                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u05D0\u00B4", expected: [][]rune{{0x05D0}, {0x00B4}}},                                                                                                                             // × [0.3] HEBREW LETTER ALEF (HL) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u05D0\u0020\u00B4", expected: [][]rune{{0x05D0, 0x0020}, {0x00B4}}},                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u05D0\u0308\u00B4", expected: [][]rune{{0x05D0, 0x0308}, {0x00B4}}},                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u05D0\u0308\u0020\u00B4", expected: [][]rune{{0x05D0, 0x0308, 0x0020}, {0x00B4}}},                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u05D0\u000B", expected: [][]rune{{0x05D0, 0x000B}}},                                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u05D0\u0020\u000B", expected: [][]rune{{0x05D0, 0x0020, 0x000B}}},                                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u05D0\u0308\u000B", expected: [][]rune{{0x05D0, 0x0308, 0x000B}}},                                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u05D0\u0308\u0020\u000B", expected: [][]rune{{0x05D0, 0x0308, 0x0020, 0x000B}}},                                                                                                   // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u05D0\uFFFC", expected: [][]rune{{0x05D0}, {0xFFFC}}},                                                                                                                             // × [0.3] HEBREW LETTER ALEF (HL) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u05D0\u0020\uFFFC", expected: [][]rune{{0x05D0, 0x0020}, {0xFFFC}}},                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u05D0\u0308\uFFFC", expected: [][]rune{{0x05D0, 0x0308}, {0xFFFC}}},                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u05D0\u0308\u0020\uFFFC", expected: [][]rune{{0x05D0, 0x0308, 0x0020}, {0xFFFC}}},                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u05D0\u007D", expected: [][]rune{{0x05D0, 0x007D}}},                                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u05D0\u0020\u007D", expected: [][]rune{{0x05D0, 0x0020, 0x007D}}},                                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u05D0\u0308\u007D", expected: [][]rune{{0x05D0, 0x0308, 0x007D}}},                                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u05D0\u0308\u0020\u007D", expected: [][]rune{{0x05D0, 0x0308, 0x0020, 0x007D}}},                                                                                                   // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u05D0\u000D", expected: [][]rune{{0x05D0, 0x000D}}},                                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u05D0\u0020\u000D", expected: [][]rune{{0x05D0, 0x0020, 0x000D}}},                                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u05D0\u0308\u000D", expected: [][]rune{{0x05D0, 0x0308, 0x000D}}},                                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u05D0\u0308\u0020\u000D", expected: [][]rune{{0x05D0, 0x0308, 0x0020, 0x000D}}},                                                                                                   // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u05D0\u0021", expected: [][]rune{{0x05D0, 0x0021}}},                                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u05D0\u0020\u0021", expected: [][]rune{{0x05D0, 0x0020, 0x0021}}},                                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u05D0\u0308\u0021", expected: [][]rune{{0x05D0, 0x0308, 0x0021}}},                                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u05D0\u0308\u0020\u0021", expected: [][]rune{{0x05D0, 0x0308, 0x0020, 0x0021}}},                                                                                                   // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u05D0\u00A0", expected: [][]rune{{0x05D0, 0x00A0}}},                                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [12.1] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u05D0\u0020\u00A0", expected: [][]rune{{0x05D0, 0x0020}, {0x00A0}}},                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u05D0\u0308\u00A0", expected: [][]rune{{0x05D0, 0x0308, 0x00A0}}},                                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u05D0\u0308\u0020\u00A0", expected: [][]rune{{0x05D0, 0x0308, 0x0020}, {0x00A0}}},                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u05D0\uAC00", expected: [][]rune{{0x05D0}, {0xAC00}}},                                                                                                                             // × [0.3] HEBREW LETTER ALEF (HL) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u05D0\u0020\uAC00", expected: [][]rune{{0x05D0, 0x0020}, {0xAC00}}},                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u05D0\u0308\uAC00", expected: [][]rune{{0x05D0, 0x0308}, {0xAC00}}},                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u05D0\u0308\u0020\uAC00", expected: [][]rune{{0x05D0, 0x0308, 0x0020}, {0xAC00}}},                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u05D0\uAC01", expected: [][]rune{{0x05D0}, {0xAC01}}},                                                                                                                             // × [0.3] HEBREW LETTER ALEF (HL) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u05D0\u0020\uAC01", expected: [][]rune{{0x05D0, 0x0020}, {0xAC01}}},                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u05D0\u0308\uAC01", expected: [][]rune{{0x05D0, 0x0308}, {0xAC01}}},                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u05D0\u0308\u0020\uAC01", expected: [][]rune{{0x05D0, 0x0308, 0x0020}, {0xAC01}}},                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u05D0\u05D0", expected: [][]rune{{0x05D0, 0x05D0}}},                                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [28.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u05D0\u0020\u05D0", expected: [][]rune{{0x05D0, 0x0020}, {0x05D0}}},                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u05D0\u0308\u05D0", expected: [][]rune{{0x05D0, 0x0308, 0x05D0}}},                                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [28.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u05D0\u0308\u0020\u05D0", expected: [][]rune{{0x05D0, 0x0308, 0x0020}, {0x05D0}}},                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u05D0\u002D", expected: [][]rune{{0x05D0, 0x002D}}},                                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u05D0\u0020\u002D", expected: [][]rune{{0x05D0, 0x0020}, {0x002D}}},                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u05D0\u0308\u002D", expected: [][]rune{{0x05D0, 0x0308, 0x002D}}},                                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u05D0\u0308\u0020\u002D", expected: [][]rune{{0x05D0, 0x0308, 0x0020}, {0x002D}}},                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u05D0\u231A", expected: [][]rune{{0x05D0}, {0x231A}}},                                                                                                                             // × [0.3] HEBREW LETTER ALEF (HL) ÷ [999.0] WATCH (ID) ÷ [0.3]
	{original: "\u05D0\u0020\u231A", expected: [][]rune{{0x05D0, 0x0020}, {0x231A}}},                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
	{original: "\u05D0\u0308\u231A", expected: [][]rune{{0x05D0, 0x0308}, {0x231A}}},                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
	{original: "\u05D0\u0308\u0020\u231A", expected: [][]rune{{0x05D0, 0x0308, 0x0020}, {0x231A}}},                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
	{original: "\u05D0\u2024", expected: [][]rune{{0x05D0, 0x2024}}},                                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u05D0\u0020\u2024", expected: [][]rune{{0x05D0, 0x0020}, {0x2024}}},                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u05D0\u0308\u2024", expected: [][]rune{{0x05D0, 0x0308, 0x2024}}},                                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u05D0\u0308\u0020\u2024", expected: [][]rune{{0x05D0, 0x0308, 0x0020}, {0x2024}}},                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u05D0\u002C", expected: [][]rune{{0x05D0, 0x002C}}},                                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u05D0\u0020\u002C", expected: [][]rune{{0x05D0, 0x0020, 0x002C}}},                                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u05D0\u0308\u002C", expected: [][]rune{{0x05D0, 0x0308, 0x002C}}},                                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
	{original: "\u05D0\u0308\u0020\u002C", expected: [][]rune{{0x05D0, 0x0308, 0x0020, 0x002C}}},                                                                                                   // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u05D0\u1100", expected: [][]rune{{0x05D0}, {0x1100}}},                                                                                                                             // × [0.3] HEBREW LETTER ALEF (HL) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u05D0\u0020\u1100", expected: [][]rune{{0x05D0, 0x0020}, {0x1100}}},                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u05D0\u0308\u1100", expected: [][]rune{{0x05D0, 0x0308}, {0x1100}}},                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u05D0\u0308\u0020\u1100", expected: [][]rune{{0x05D0, 0x0308, 0x0020}, {0x1100}}},                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u05D0\u11A8", expected: [][]rune{{0x05D0}, {0x11A8}}},                                                                                                                             // × [0.3] HEBREW LETTER ALEF (HL) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u05D0\u0020\u11A8", expected: [][]rune{{0x05D0, 0x0020}, {0x11A8}}},                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u05D0\u0308\u11A8", expected: [][]rune{{0x05D0, 0x0308}, {0x11A8}}},                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u05D0\u0308\u0020\u11A8", expected: [][]rune{{0x05D0, 0x0308, 0x0020}, {0x11A8}}},                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u05D0\u1160", expected: [][]rune{{0x05D0}, {0x1160}}},                                                                                                                             // × [0.3] HEBREW LETTER ALEF (HL) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u05D0\u0020\u1160", expected: [][]rune{{0x05D0, 0x0020}, {0x1160}}},                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u05D0\u0308\u1160", expected: [][]rune{{0x05D0, 0x0308}, {0x1160}}},                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u05D0\u0308\u0020\u1160", expected: [][]rune{{0x05D0, 0x0308, 0x0020}, {0x1160}}},                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u05D0\u000A", expected: [][]rune{{0x05D0, 0x000A}}},                                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u05D0\u0020\u000A", expected: [][]rune{{0x05D0, 0x0020, 0x000A}}},                                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u05D0\u0308\u000A", expected: [][]rune{{0x05D0, 0x0308, 0x000A}}},                                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u05D0\u0308\u0020\u000A", expected: [][]rune{{0x05D0, 0x0308, 0x0020, 0x000A}}},                                                                                                   // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u05D0\u0085", expected: [][]rune{{0x05D0, 0x0085}}},                                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u05D0\u0020\u0085", expected: [][]rune{{0x05D0, 0x0020, 0x0085}}},                                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u05D0\u0308\u0085", expected: [][]rune{{0x05D0, 0x0308, 0x0085}}},                                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u05D0\u0308\u0020\u0085", expected: [][]rune{{0x05D0, 0x0308, 0x0020, 0x0085}}},                                                                                                   // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u05D0\u17D6", expected: [][]rune{{0x05D0, 0x17D6}}},                                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u05D0\u0020\u17D6", expected: [][]rune{{0x05D0, 0x0020}, {0x17D6}}},                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u05D0\u0308\u17D6", expected: [][]rune{{0x05D0, 0x0308, 0x17D6}}},                                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u05D0\u0308\u0020\u17D6", expected: [][]rune{{0x05D0, 0x0308, 0x0020}, {0x17D6}}},                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u05D0\u0030", expected: [][]rune{{0x05D0, 0x0030}}},                                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [23.02] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u05D0\u0020\u0030", expected: [][]rune{{0x05D0, 0x0020}, {0x0030}}},                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u05D0\u0308\u0030", expected: [][]rune{{0x05D0, 0x0308, 0x0030}}},                                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [23.02] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u05D0\u0308\u0020\u0030", expected: [][]rune{{0x05D0, 0x0308, 0x0020}, {0x0030}}},                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u05D0\u2329", expected: [][]rune{{0x05D0}, {0x2329}}},                                                                                                                             // × [0.3] HEBREW LETTER ALEF (HL) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u05D0\u0020\u2329", expected: [][]rune{{0x05D0, 0x0020}, {0x2329}}},                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u05D0\u0308\u2329", expected: [][]rune{{0x05D0, 0x0308}, {0x2329}}},                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u05D0\u0308\u0020\u2329", expected: [][]rune{{0x05D0, 0x0308, 0x0020}, {0x2329}}},                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u05D0\u0025", expected: [][]rune{{0x05D0, 0x0025}}},                                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [24.03] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u05D0\u0020\u0025", expected: [][]rune{{0x05D0, 0x0020}, {0x0025}}},                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u05D0\u0308\u0025", expected: [][]rune{{0x05D0, 0x0308, 0x0025}}},                                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [24.03] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u05D0\u0308\u0020\u0025", expected: [][]rune{{0x05D0, 0x0308, 0x0020}, {0x0025}}},                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u05D0\u0024", expected: [][]rune{{0x05D0, 0x0024}}},                                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [24.03] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u05D0\u0020\u0024", expected: [][]rune{{0x05D0, 0x0020}, {0x0024}}},                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u05D0\u0308\u0024", expected: [][]rune{{0x05D0, 0x0308, 0x0024}}},                                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [24.03] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u05D0\u0308\u0020\u0024", expected: [][]rune{{0x05D0, 0x0308, 0x0020}, {0x0024}}},                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u05D0\u0022", expected: [][]rune{{0x05D0, 0x0022}}},                                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u05D0\u0020\u0022", expected: [][]rune{{0x05D0, 0x0020}, {0x0022}}},                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u05D0\u0308\u0022", expected: [][]rune{{0x05D0, 0x0308, 0x0022}}},                                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u05D0\u0308\u0020\u0022", expected: [][]rune{{0x05D0, 0x0308, 0x0020}, {0x0022}}},                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u05D0\u0020", expected: [][]rune{{0x05D0, 0x0020}}},                                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u05D0\u0020\u0020", expected: [][]rune{{0x05D0, 0x0020, 0x0020}}},                                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u05D0\u0308\u0020", expected: [][]rune{{0x05D0, 0x0308, 0x0020}}},                                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u05D0\u0308\u0020\u0020", expected: [][]rune{{0x05D0, 0x0308, 0x0020, 0x0020}}},                                                                                                   // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u05D0\u002F", expected: [][]rune{{0x05D0, 0x002F}}},                                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\u05D0\u0020\u002F", expected: [][]rune{{0x05D0, 0x0020, 0x002F}}},                                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\u05D0\u0308\u002F", expected: [][]rune{{0x05D0, 0x0308, 0x002F}}},                                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
	{original: "\u05D0\u0308\u0020\u002F", expected: [][]rune{{0x05D0, 0x0308, 0x0020, 0x002F}}},                                                                                                   // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\u05D0\u2060", expected: [][]rune{{0x05D0, 0x2060}}},                                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u05D0\u0020\u2060", expected: [][]rune{{0x05D0, 0x0020, 0x2060}}},                                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u05D0\u0308\u2060", expected: [][]rune{{0x05D0, 0x0308, 0x2060}}},                                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u05D0\u0308\u0020\u2060", expected: [][]rune{{0x05D0, 0x0308, 0x0020, 0x2060}}},                                                                                                   // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u05D0\u200B", expected: [][]rune{{0x05D0, 0x200B}}},                                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u05D0\u0020\u200B", expected: [][]rune{{0x05D0, 0x0020, 0x200B}}},                                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u05D0\u0308\u200B", expected: [][]rune{{0x05D0, 0x0308, 0x200B}}},                                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u05D0\u0308\u0020\u200B", expected: [][]rune{{0x05D0, 0x0308, 0x0020, 0x200B}}},                                                                                                   // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u05D0\U0001F1E6", expected: [][]rune{{0x05D0}, {0x1F1E6}}},                                                                                                                        // × [0.3] HEBREW LETTER ALEF (HL) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u05D0\u0020\U0001F1E6", expected: [][]rune{{0x05D0, 0x0020}, {0x1F1E6}}},                                                                                                          // × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u05D0\u0308\U0001F1E6", expected: [][]rune{{0x05D0, 0x0308}, {0x1F1E6}}},                                                                                                          // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u05D0\u0308\u0020\U0001F1E6", expected: [][]rune{{0x05D0, 0x0308, 0x0020}, {0x1F1E6}}},                                                                                            // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u05D0\u261D", expected: [][]rune{{0x05D0}, {0x261D}}},                                                                                                                             // × [0.3] HEBREW LETTER ALEF (HL) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u05D0\u0020\u261D", expected: [][]rune{{0x05D0, 0x0020}, {0x261D}}},                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u05D0\u0308\u261D", expected: [][]rune{{0x05D0, 0x0308}, {0x261D}}},                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u05D0\u0308\u0020\u261D", expected: [][]rune{{0x05D0, 0x0308, 0x0020}, {0x261D}}},                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u05D0\U0001F3FB", expected: [][]rune{{0x05D0}, {0x1F3FB}}},                                                                                                                        // × [0.3] HEBREW LETTER ALEF (HL) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u05D0\u0020\U0001F3FB", expected: [][]rune{{0x05D0, 0x0020}, {0x1F3FB}}},                                                                                                          // × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u05D0\u0308\U0001F3FB", expected: [][]rune{{0x05D0, 0x0308}, {0x1F3FB}}},                                                                                                          // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u05D0\u0308\u0020\U0001F3FB", expected: [][]rune{{0x05D0, 0x0308, 0x0020}, {0x1F3FB}}},                                                                                            // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u05D0\u0029", expected: [][]rune{{0x05D0, 0x0029}}},                                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u05D0\u0020\u0029", expected: [][]rune{{0x05D0, 0x0020, 0x0029}}},                                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u05D0\u0308\u0029", expected: [][]rune{{0x05D0, 0x0308, 0x0029}}},                                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u05D0\u0308\u0020\u0029", expected: [][]rune{{0x05D0, 0x0308, 0x0020, 0x0029}}},                                                                                                   // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u05D0\u0028", expected: [][]rune{{0x05D0, 0x0028}}},                                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [30.01] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u05D0\u0020\u0028", expected: [][]rune{{0x05D0, 0x0020}, {0x0028}}},                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u05D0\u0308\u0028", expected: [][]rune{{0x05D0, 0x0308, 0x0028}}},                                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [30.01] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u05D0\u0308\u0020\u0028", expected: [][]rune{{0x05D0, 0x0308, 0x0020}, {0x0028}}},                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u05D0\u0001", expected: [][]rune{{0x05D0, 0x0001}}},                                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u05D0\u0020\u0001", expected: [][]rune{{0x05D0, 0x0020}, {0x0001}}},                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u05D0\u0308\u0001", expected: [][]rune{{0x05D0, 0x0308, 0x0001}}},                                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u05D0\u0308\u0020\u0001", expected: [][]rune{{0x05D0, 0x0308, 0x0020}, {0x0001}}},                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u05D0\u200D", expected: [][]rune{{0x05D0, 0x200D}}},                                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u05D0\u0020\u200D", expected: [][]rune{{0x05D0, 0x0020}, {0x200D}}},                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u05D0\u0308\u200D", expected: [][]rune{{0x05D0, 0x0308, 0x200D}}},                                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u05D0\u0308\u0020\u200D", expected: [][]rune{{0x05D0, 0x0308, 0x0020}, {0x200D}}},                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u05D0\u00A7", expected: [][]rune{{0x05D0, 0x00A7}}},                                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [28.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u05D0\u0020\u00A7", expected: [][]rune{{0x05D0, 0x0020}, {0x00A7}}},                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u05D0\u0308\u00A7", expected: [][]rune{{0x05D0, 0x0308, 0x00A7}}},                                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [28.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u05D0\u0308\u0020\u00A7", expected: [][]rune{{0x05D0, 0x0308, 0x0020}, {0x00A7}}},                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u05D0\U00050005", expected: [][]rune{{0x05D0, 0x50005}}},                                                                                                                          // × [0.3] HEBREW LETTER ALEF (HL) × [28.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u05D0\u0020\U00050005", expected: [][]rune{{0x05D0, 0x0020}, {0x50005}}},                                                                                                          // × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u05D0\u0308\U00050005", expected: [][]rune{{0x05D0, 0x0308, 0x50005}}},                                                                                                            // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [28.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u05D0\u0308\u0020\U00050005", expected: [][]rune{{0x05D0, 0x0308, 0x0020}, {0x50005}}},                                                                                            // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u05D0\u0E01", expected: [][]rune{{0x05D0, 0x0E01}}},                                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [28.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u05D0\u0020\u0E01", expected: [][]rune{{0x05D0, 0x0020}, {0x0E01}}},                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u05D0\u0308\u0E01", expected: [][]rune{{0x05D0, 0x0308, 0x0E01}}},                                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [28.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u05D0\u0308\u0020\u0E01", expected: [][]rune{{0x05D0, 0x0308, 0x0020}, {0x0E01}}},                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u05D0\u3041", expected: [][]rune{{0x05D0, 0x3041}}},                                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u05D0\u0020\u3041", expected: [][]rune{{0x05D0, 0x0020}, {0x3041}}},                                                                                                               // × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u05D0\u0308\u3041", expected: [][]rune{{0x05D0, 0x0308, 0x3041}}},                                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u05D0\u0308\u0020\u3041", expected: [][]rune{{0x05D0, 0x0308, 0x0020}, {0x3041}}},                                                                                                 // × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u002D\u0023", expected: [][]rune{{0x002D}, {0x0023}}},                                                                                                                             // × [0.3] HYPHEN-MINUS (HY) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u002D\u0020\u0023", expected: [][]rune{{0x002D, 0x0020}, {0x0023}}},                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u002D\u0308\u0023", expected: [][]rune{{0x002D, 0x0308}, {0x0023}}},                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u002D\u0308\u0020\u0023", expected: [][]rune{{0x002D, 0x0308, 0x0020}, {0x0023}}},                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u002D\u2014", expected: [][]rune{{0x002D}, {0x2014}}},                                                                                                                             // × [0.3] HYPHEN-MINUS (HY) ÷ [999.0] EM DASH (B2) ÷ [0.3]
	{original: "\u002D\u0020\u2014", expected: [][]rune{{0x002D, 0x0020}, {0x2014}}},                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
	{original: "\u002D\u0308\u2014", expected: [][]rune{{0x002D, 0x0308}, {0x2014}}},                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
	{original: "\u002D\u0308\u0020\u2014", expected: [][]rune{{0x002D, 0x0308, 0x0020}, {0x2014}}},                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
	{original: "\u002D\u0009", expected: [][]rune{{0x002D, 0x0009}}},                                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u002D\u0020\u0009", expected: [][]rune{{0x002D, 0x0020}, {0x0009}}},                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u002D\u0308\u0009", expected: [][]rune{{0x002D, 0x0308, 0x0009}}},                                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u002D\u0308\u0020\u0009", expected: [][]rune{{0x002D, 0x0308, 0x0020}, {0x0009}}},                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u002D\u00B4", expected: [][]rune{{0x002D}, {0x00B4}}},                                                                                                                             // × [0.3] HYPHEN-MINUS (HY) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u002D\u0020\u00B4", expected: [][]rune{{0x002D, 0x0020}, {0x00B4}}},                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u002D\u0308\u00B4", expected: [][]rune{{0x002D, 0x0308}, {0x00B4}}},                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u002D\u0308\u0020\u00B4", expected: [][]rune{{0x002D, 0x0308, 0x0020}, {0x00B4}}},                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u002D\u000B", expected: [][]rune{{0x002D, 0x000B}}},                                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u002D\u0020\u000B", expected: [][]rune{{0x002D, 0x0020, 0x000B}}},                                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u002D\u0308\u000B", expected: [][]rune{{0x002D, 0x0308, 0x000B}}},                                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u002D\u0308\u0020\u000B", expected: [][]rune{{0x002D, 0x0308, 0x0020, 0x000B}}},                                                                                                   // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u002D\uFFFC", expected: [][]rune{{0x002D}, {0xFFFC}}},                                                                                                                             // × [0.3] HYPHEN-MINUS (HY) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u002D\u0020\uFFFC", expected: [][]rune{{0x002D, 0x0020}, {0xFFFC}}},                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u002D\u0308\uFFFC", expected: [][]rune{{0x002D, 0x0308}, {0xFFFC}}},                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u002D\u0308\u0020\uFFFC", expected: [][]rune{{0x002D, 0x0308, 0x0020}, {0xFFFC}}},                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u002D\u007D", expected: [][]rune{{0x002D, 0x007D}}},                                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u002D\u0020\u007D", expected: [][]rune{{0x002D, 0x0020, 0x007D}}},                                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u002D\u0308\u007D", expected: [][]rune{{0x002D, 0x0308, 0x007D}}},                                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u002D\u0308\u0020\u007D", expected: [][]rune{{0x002D, 0x0308, 0x0020, 0x007D}}},                                                                                                   // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u002D\u000D", expected: [][]rune{{0x002D, 0x000D}}},                                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u002D\u0020\u000D", expected: [][]rune{{0x002D, 0x0020, 0x000D}}},                                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u002D\u0308\u000D", expected: [][]rune{{0x002D, 0x0308, 0x000D}}},                                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u002D\u0308\u0020\u000D", expected: [][]rune{{0x002D, 0x0308, 0x0020, 0x000D}}},                                                                                                   // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u002D\u0021", expected: [][]rune{{0x002D, 0x0021}}},                                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u002D\u0020\u0021", expected: [][]rune{{0x002D, 0x0020, 0x0021}}},                                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u002D\u0308\u0021", expected: [][]rune{{0x002D, 0x0308, 0x0021}}},                                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u002D\u0308\u0020\u0021", expected: [][]rune{{0x002D, 0x0308, 0x0020, 0x0021}}},                                                                                                   // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u002D\u00A0", expected: [][]rune{{0x002D}, {0x00A0}}},                                                                                                                             // × [0.3] HYPHEN-MINUS (HY) ÷ [999.0] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u002D\u0020\u00A0", expected: [][]rune{{0x002D, 0x0020}, {0x00A0}}},                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u002D\u0308\u00A0", expected: [][]rune{{0x002D, 0x0308}, {0x00A0}}},                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u002D\u0308\u0020\u00A0", expected: [][]rune{{0x002D, 0x0308, 0x0020}, {0x00A0}}},                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u002D\uAC00", expected: [][]rune{{0x002D}, {0xAC00}}},                                                                                                                             // × [0.3] HYPHEN-MINUS (HY) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u002D\u0020\uAC00", expected: [][]rune{{0x002D, 0x0020}, {0xAC00}}},                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u002D\u0308\uAC00", expected: [][]rune{{0x002D, 0x0308}, {0xAC00}}},                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u002D\u0308\u0020\uAC00", expected: [][]rune{{0x002D, 0x0308, 0x0020}, {0xAC00}}},                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u002D\uAC01", expected: [][]rune{{0x002D}, {0xAC01}}},                                                                                                                             // × [0.3] HYPHEN-MINUS (HY) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u002D\u0020\uAC01", expected: [][]rune{{0x002D, 0x0020}, {0xAC01}}},                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u002D\u0308\uAC01", expected: [][]rune{{0x002D, 0x0308}, {0xAC01}}},                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u002D\u0308\u0020\uAC01", expected: [][]rune{{0x002D, 0x0308, 0x0020}, {0xAC01}}},                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u002D\u05D0", expected: [][]rune{{0x002D}, {0x05D0}}},                                                                                                                             // × [0.3] HYPHEN-MINUS (HY) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u002D\u0020\u05D0", expected: [][]rune{{0x002D, 0x0020}, {0x05D0}}},                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u002D\u0308\u05D0", expected: [][]rune{{0x002D, 0x0308}, {0x05D0}}},                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u002D\u0308\u0020\u05D0", expected: [][]rune{{0x002D, 0x0308, 0x0020}, {0x05D0}}},                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u002D\u002D", expected: [][]rune{{0x002D, 0x002D}}},                                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u002D\u0020\u002D", expected: [][]rune{{0x002D, 0x0020}, {0x002D}}},                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u002D\u0308\u002D", expected: [][]rune{{0x002D, 0x0308, 0x002D}}},                                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u002D\u0308\u0020\u002D", expected: [][]rune{{0x002D, 0x0308, 0x0020}, {0x002D}}},                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u002D\u231A", expected: [][]rune{{0x002D}, {0x231A}}},                                                                                                                             // × [0.3] HYPHEN-MINUS (HY) ÷ [999.0] WATCH (ID) ÷ [0.3]
	{original: "\u002D\u0020\u231A", expected: [][]rune{{0x002D, 0x0020}, {0x231A}}},                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
	{original: "\u002D\u0308\u231A", expected: [][]rune{{0x002D, 0x0308}, {0x231A}}},                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
	{original: "\u002D\u0308\u0020\u231A", expected: [][]rune{{0x002D, 0x0308, 0x0020}, {0x231A}}},                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
	{original: "\u002D\u2024", expected: [][]rune{{0x002D, 0x2024}}},                                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u002D\u0020\u2024", expected: [][]rune{{0x002D, 0x0020}, {0x2024}}},                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u002D\u0308\u2024", expected: [][]rune{{0x002D, 0x0308, 0x2024}}},                                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u002D\u0308\u0020\u2024", expected: [][]rune{{0x002D, 0x0308, 0x0020}, {0x2024}}},                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u002D\u002C", expected: [][]rune{{0x002D, 0x002C}}},                                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u002D\u0020\u002C", expected: [][]rune{{0x002D, 0x0020, 0x002C}}},                                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u002D\u0308\u002C", expected: [][]rune{{0x002D, 0x0308, 0x002C}}},                                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
	{original: "\u002D\u0308\u0020\u002C", expected: [][]rune{{0x002D, 0x0308, 0x0020, 0x002C}}},                                                                                                   // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u002D\u1100", expected: [][]rune{{0x002D}, {0x1100}}},                                                                                                                             // × [0.3] HYPHEN-MINUS (HY) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u002D\u0020\u1100", expected: [][]rune{{0x002D, 0x0020}, {0x1100}}},                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u002D\u0308\u1100", expected: [][]rune{{0x002D, 0x0308}, {0x1100}}},                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u002D\u0308\u0020\u1100", expected: [][]rune{{0x002D, 0x0308, 0x0020}, {0x1100}}},                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u002D\u11A8", expected: [][]rune{{0x002D}, {0x11A8}}},                                                                                                                             // × [0.3] HYPHEN-MINUS (HY) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u002D\u0020\u11A8", expected: [][]rune{{0x002D, 0x0020}, {0x11A8}}},                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u002D\u0308\u11A8", expected: [][]rune{{0x002D, 0x0308}, {0x11A8}}},                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u002D\u0308\u0020\u11A8", expected: [][]rune{{0x002D, 0x0308, 0x0020}, {0x11A8}}},                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u002D\u1160", expected: [][]rune{{0x002D}, {0x1160}}},                                                                                                                             // × [0.3] HYPHEN-MINUS (HY) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u002D\u0020\u1160", expected: [][]rune{{0x002D, 0x0020}, {0x1160}}},                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u002D\u0308\u1160", expected: [][]rune{{0x002D, 0x0308}, {0x1160}}},                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u002D\u0308\u0020\u1160", expected: [][]rune{{0x002D, 0x0308, 0x0020}, {0x1160}}},                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u002D\u000A", expected: [][]rune{{0x002D, 0x000A}}},                                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u002D\u0020\u000A", expected: [][]rune{{0x002D, 0x0020, 0x000A}}},                                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u002D\u0308\u000A", expected: [][]rune{{0x002D, 0x0308, 0x000A}}},                                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u002D\u0308\u0020\u000A", expected: [][]rune{{0x002D, 0x0308, 0x0020, 0x000A}}},                                                                                                   // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u002D\u0085", expected: [][]rune{{0x002D, 0x0085}}},                                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u002D\u0020\u0085", expected: [][]rune{{0x002D, 0x0020, 0x0085}}},                                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u002D\u0308\u0085", expected: [][]rune{{0x002D, 0x0308, 0x0085}}},                                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u002D\u0308\u0020\u0085", expected: [][]rune{{0x002D, 0x0308, 0x0020, 0x0085}}},                                                                                                   // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u002D\u17D6", expected: [][]rune{{0x002D, 0x17D6}}},                                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u002D\u0020\u17D6", expected: [][]rune{{0x002D, 0x0020}, {0x17D6}}},                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u002D\u0308\u17D6", expected: [][]rune{{0x002D, 0x0308, 0x17D6}}},                                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u002D\u0308\u0020\u17D6", expected: [][]rune{{0x002D, 0x0308, 0x0020}, {0x17D6}}},                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u002D\u0030", expected: [][]rune{{0x002D, 0x0030}}},                                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [25.02] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u002D\u0020\u0030", expected: [][]rune{{0x002D, 0x0020}, {0x0030}}},                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u002D\u0308\u0030", expected: [][]rune{{0x002D, 0x0308, 0x0030}}},                                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [25.02] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u002D\u0308\u0020\u0030", expected: [][]rune{{0x002D, 0x0308, 0x0020}, {0x0030}}},                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u002D\u2329", expected: [][]rune{{0x002D}, {0x2329}}},                                                                                                                             // × [0.3] HYPHEN-MINUS (HY) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u002D\u0020\u2329", expected: [][]rune{{0x002D, 0x0020}, {0x2329}}},                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u002D\u0308\u2329", expected: [][]rune{{0x002D, 0x0308}, {0x2329}}},                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u002D\u0308\u0020\u2329", expected: [][]rune{{0x002D, 0x0308, 0x0020}, {0x2329}}},                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u002D\u0025", expected: [][]rune{{0x002D}, {0x0025}}},                                                                                                                             // × [0.3] HYPHEN-MINUS (HY) ÷ [999.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u002D\u0020\u0025", expected: [][]rune{{0x002D, 0x0020}, {0x0025}}},                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u002D\u0308\u0025", expected: [][]rune{{0x002D, 0x0308}, {0x0025}}},                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u002D\u0308\u0020\u0025", expected: [][]rune{{0x002D, 0x0308, 0x0020}, {0x0025}}},                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u002D\u0024", expected: [][]rune{{0x002D}, {0x0024}}},                                                                                                                             // × [0.3] HYPHEN-MINUS (HY) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u002D\u0020\u0024", expected: [][]rune{{0x002D, 0x0020}, {0x0024}}},                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u002D\u0308\u0024", expected: [][]rune{{0x002D, 0x0308}, {0x0024}}},                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u002D\u0308\u0020\u0024", expected: [][]rune{{0x002D, 0x0308, 0x0020}, {0x0024}}},                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u002D\u0022", expected: [][]rune{{0x002D, 0x0022}}},                                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u002D\u0020\u0022", expected: [][]rune{{0x002D, 0x0020}, {0x0022}}},                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u002D\u0308\u0022", expected: [][]rune{{0x002D, 0x0308, 0x0022}}},                                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u002D\u0308\u0020\u0022", expected: [][]rune{{0x002D, 0x0308, 0x0020}, {0x0022}}},                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u002D\u0020", expected: [][]rune{{0x002D, 0x0020}}},                                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u002D\u0020\u0020", expected: [][]rune{{0x002D, 0x0020, 0x0020}}},                                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u002D\u0308\u0020", expected: [][]rune{{0x002D, 0x0308, 0x0020}}},                                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u002D\u0308\u0020\u0020", expected: [][]rune{{0x002D, 0x0308, 0x0020, 0x0020}}},                                                                                                   // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u002D\u002F", expected: [][]rune{{0x002D, 0x002F}}},                                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\u002D\u0020\u002F", expected: [][]rune{{0x002D, 0x0020, 0x002F}}},                                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\u002D\u0308\u002F", expected: [][]rune{{0x002D, 0x0308, 0x002F}}},                                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
	{original: "\u002D\u0308\u0020\u002F", expected: [][]rune{{0x002D, 0x0308, 0x0020, 0x002F}}},                                                                                                   // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\u002D\u2060", expected: [][]rune{{0x002D, 0x2060}}},                                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u002D\u0020\u2060", expected: [][]rune{{0x002D, 0x0020, 0x2060}}},                                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u002D\u0308\u2060", expected: [][]rune{{0x002D, 0x0308, 0x2060}}},                                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u002D\u0308\u0020\u2060", expected: [][]rune{{0x002D, 0x0308, 0x0020, 0x2060}}},                                                                                                   // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u002D\u200B", expected: [][]rune{{0x002D, 0x200B}}},                                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u002D\u0020\u200B", expected: [][]rune{{0x002D, 0x0020, 0x200B}}},                                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u002D\u0308\u200B", expected: [][]rune{{0x002D, 0x0308, 0x200B}}},                                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u002D\u0308\u0020\u200B", expected: [][]rune{{0x002D, 0x0308, 0x0020, 0x200B}}},                                                                                                   // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u002D\U0001F1E6", expected: [][]rune{{0x002D}, {0x1F1E6}}},                                                                                                                        // × [0.3] HYPHEN-MINUS (HY) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u002D\u0020\U0001F1E6", expected: [][]rune{{0x002D, 0x0020}, {0x1F1E6}}},                                                                                                          // × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u002D\u0308\U0001F1E6", expected: [][]rune{{0x002D, 0x0308}, {0x1F1E6}}},                                                                                                          // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u002D\u0308\u0020\U0001F1E6", expected: [][]rune{{0x002D, 0x0308, 0x0020}, {0x1F1E6}}},                                                                                            // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u002D\u261D", expected: [][]rune{{0x002D}, {0x261D}}},                                                                                                                             // × [0.3] HYPHEN-MINUS (HY) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u002D\u0020\u261D", expected: [][]rune{{0x002D, 0x0020}, {0x261D}}},                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u002D\u0308\u261D", expected: [][]rune{{0x002D, 0x0308}, {0x261D}}},                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u002D\u0308\u0020\u261D", expected: [][]rune{{0x002D, 0x0308, 0x0020}, {0x261D}}},                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u002D\U0001F3FB", expected: [][]rune{{0x002D}, {0x1F3FB}}},                                                                                                                        // × [0.3] HYPHEN-MINUS (HY) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u002D\u0020\U0001F3FB", expected: [][]rune{{0x002D, 0x0020}, {0x1F3FB}}},                                                                                                          // × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u002D\u0308\U0001F3FB", expected: [][]rune{{0x002D, 0x0308}, {0x1F3FB}}},                                                                                                          // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u002D\u0308\u0020\U0001F3FB", expected: [][]rune{{0x002D, 0x0308, 0x0020}, {0x1F3FB}}},                                                                                            // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u002D\u0029", expected: [][]rune{{0x002D, 0x0029}}},                                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u002D\u0020\u0029", expected: [][]rune{{0x002D, 0x0020, 0x0029}}},                                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u002D\u0308\u0029", expected: [][]rune{{0x002D, 0x0308, 0x0029}}},                                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u002D\u0308\u0020\u0029", expected: [][]rune{{0x002D, 0x0308, 0x0020, 0x0029}}},                                                                                                   // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u002D\u0028", expected: [][]rune{{0x002D}, {0x0028}}},                                                                                                                             // × [0.3] HYPHEN-MINUS (HY) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u002D\u0020\u0028", expected: [][]rune{{0x002D, 0x0020}, {0x0028}}},                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u002D\u0308\u0028", expected: [][]rune{{0x002D, 0x0308}, {0x0028}}},                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u002D\u0308\u0020\u0028", expected: [][]rune{{0x002D, 0x0308, 0x0020}, {0x0028}}},                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u002D\u0001", expected: [][]rune{{0x002D, 0x0001}}},                                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u002D\u0020\u0001", expected: [][]rune{{0x002D, 0x0020}, {0x0001}}},                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u002D\u0308\u0001", expected: [][]rune{{0x002D, 0x0308, 0x0001}}},                                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u002D\u0308\u0020\u0001", expected: [][]rune{{0x002D, 0x0308, 0x0020}, {0x0001}}},                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u002D\u200D", expected: [][]rune{{0x002D, 0x200D}}},                                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u002D\u0020\u200D", expected: [][]rune{{0x002D, 0x0020}, {0x200D}}},                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u002D\u0308\u200D", expected: [][]rune{{0x002D, 0x0308, 0x200D}}},                                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u002D\u0308\u0020\u200D", expected: [][]rune{{0x002D, 0x0308, 0x0020}, {0x200D}}},                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u002D\u00A7", expected: [][]rune{{0x002D}, {0x00A7}}},                                                                                                                             // × [0.3] HYPHEN-MINUS (HY) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u002D\u0020\u00A7", expected: [][]rune{{0x002D, 0x0020}, {0x00A7}}},                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u002D\u0308\u00A7", expected: [][]rune{{0x002D, 0x0308}, {0x00A7}}},                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u002D\u0308\u0020\u00A7", expected: [][]rune{{0x002D, 0x0308, 0x0020}, {0x00A7}}},                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u002D\U00050005", expected: [][]rune{{0x002D}, {0x50005}}},                                                                                                                        // × [0.3] HYPHEN-MINUS (HY) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u002D\u0020\U00050005", expected: [][]rune{{0x002D, 0x0020}, {0x50005}}},                                                                                                          // × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u002D\u0308\U00050005", expected: [][]rune{{0x002D, 0x0308}, {0x50005}}},                                                                                                          // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u002D\u0308\u0020\U00050005", expected: [][]rune{{0x002D, 0x0308, 0x0020}, {0x50005}}},                                                                                            // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u002D\u0E01", expected: [][]rune{{0x002D}, {0x0E01}}},                                                                                                                             // × [0.3] HYPHEN-MINUS (HY) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u002D\u0020\u0E01", expected: [][]rune{{0x002D, 0x0020}, {0x0E01}}},                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u002D\u0308\u0E01", expected: [][]rune{{0x002D, 0x0308}, {0x0E01}}},                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u002D\u0308\u0020\u0E01", expected: [][]rune{{0x002D, 0x0308, 0x0020}, {0x0E01}}},                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u002D\u3041", expected: [][]rune{{0x002D, 0x3041}}},                                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u002D\u0020\u3041", expected: [][]rune{{0x002D, 0x0020}, {0x3041}}},                                                                                                               // × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u002D\u0308\u3041", expected: [][]rune{{0x002D, 0x0308, 0x3041}}},                                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u002D\u0308\u0020\u3041", expected: [][]rune{{0x002D, 0x0308, 0x0020}, {0x3041}}},                                                                                                 // × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u231A\u0023", expected: [][]rune{{0x231A}, {0x0023}}},                                                                                                                             // × [0.3] WATCH (ID) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u231A\u0020\u0023", expected: [][]rune{{0x231A, 0x0020}, {0x0023}}},                                                                                                               // × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u231A\u0308\u0023", expected: [][]rune{{0x231A, 0x0308}, {0x0023}}},                                                                                                               // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u231A\u0308\u0020\u0023", expected: [][]rune{{0x231A, 0x0308, 0x0020}, {0x0023}}},                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u231A\u2014", expected: [][]rune{{0x231A}, {0x2014}}},                                                                                                                             // × [0.3] WATCH (ID) ÷ [999.0] EM DASH (B2) ÷ [0.3]
	{original: "\u231A\u0020\u2014", expected: [][]rune{{0x231A, 0x0020}, {0x2014}}},                                                                                                               // × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
	{original: "\u231A\u0308\u2014", expected: [][]rune{{0x231A, 0x0308}, {0x2014}}},                                                                                                               // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
	{original: "\u231A\u0308\u0020\u2014", expected: [][]rune{{0x231A, 0x0308, 0x0020}, {0x2014}}},                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
	{original: "\u231A\u0009", expected: [][]rune{{0x231A, 0x0009}}},                                                                                                                               // × [0.3] WATCH (ID) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u231A\u0020\u0009", expected: [][]rune{{0x231A, 0x0020}, {0x0009}}},                                                                                                               // × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u231A\u0308\u0009", expected: [][]rune{{0x231A, 0x0308, 0x0009}}},                                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u231A\u0308\u0020\u0009", expected: [][]rune{{0x231A, 0x0308, 0x0020}, {0x0009}}},                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u231A\u00B4", expected: [][]rune{{0x231A}, {0x00B4}}},                                                                                                                             // × [0.3] WATCH (ID) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u231A\u0020\u00B4", expected: [][]rune{{0x231A, 0x0020}, {0x00B4}}},                                                                                                               // × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u231A\u0308\u00B4", expected: [][]rune{{0x231A, 0x0308}, {0x00B4}}},                                                                                                               // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u231A\u0308\u0020\u00B4", expected: [][]rune{{0x231A, 0x0308, 0x0020}, {0x00B4}}},                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u231A\u000B", expected: [][]rune{{0x231A, 0x000B}}},                                                                                                                               // × [0.3] WATCH (ID) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u231A\u0020\u000B", expected: [][]rune{{0x231A, 0x0020, 0x000B}}},                                                                                                                 // × [0.3] WATCH (ID) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u231A\u0308\u000B", expected: [][]rune{{0x231A, 0x0308, 0x000B}}},                                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u231A\u0308\u0020\u000B", expected: [][]rune{{0x231A, 0x0308, 0x0020, 0x000B}}},                                                                                                   // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u231A\uFFFC", expected: [][]rune{{0x231A}, {0xFFFC}}},                                                                                                                             // × [0.3] WATCH (ID) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u231A\u0020\uFFFC", expected: [][]rune{{0x231A, 0x0020}, {0xFFFC}}},                                                                                                               // × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u231A\u0308\uFFFC", expected: [][]rune{{0x231A, 0x0308}, {0xFFFC}}},                                                                                                               // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u231A\u0308\u0020\uFFFC", expected: [][]rune{{0x231A, 0x0308, 0x0020}, {0xFFFC}}},                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u231A\u007D", expected: [][]rune{{0x231A, 0x007D}}},                                                                                                                               // × [0.3] WATCH (ID) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u231A\u0020\u007D", expected: [][]rune{{0x231A, 0x0020, 0x007D}}},                                                                                                                 // × [0.3] WATCH (ID) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u231A\u0308\u007D", expected: [][]rune{{0x231A, 0x0308, 0x007D}}},                                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u231A\u0308\u0020\u007D", expected: [][]rune{{0x231A, 0x0308, 0x0020, 0x007D}}},                                                                                                   // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u231A\u000D", expected: [][]rune{{0x231A, 0x000D}}},                                                                                                                               // × [0.3] WATCH (ID) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u231A\u0020\u000D", expected: [][]rune{{0x231A, 0x0020, 0x000D}}},                                                                                                                 // × [0.3] WATCH (ID) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u231A\u0308\u000D", expected: [][]rune{{0x231A, 0x0308, 0x000D}}},                                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u231A\u0308\u0020\u000D", expected: [][]rune{{0x231A, 0x0308, 0x0020, 0x000D}}},                                                                                                   // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u231A\u0021", expected: [][]rune{{0x231A, 0x0021}}},                                                                                                                               // × [0.3] WATCH (ID) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u231A\u0020\u0021", expected: [][]rune{{0x231A, 0x0020, 0x0021}}},                                                                                                                 // × [0.3] WATCH (ID) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u231A\u0308\u0021", expected: [][]rune{{0x231A, 0x0308, 0x0021}}},                                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u231A\u0308\u0020\u0021", expected: [][]rune{{0x231A, 0x0308, 0x0020, 0x0021}}},                                                                                                   // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u231A\u00A0", expected: [][]rune{{0x231A, 0x00A0}}},                                                                                                                               // × [0.3] WATCH (ID) × [12.1] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u231A\u0020\u00A0", expected: [][]rune{{0x231A, 0x0020}, {0x00A0}}},                                                                                                               // × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u231A\u0308\u00A0", expected: [][]rune{{0x231A, 0x0308, 0x00A0}}},                                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u231A\u0308\u0020\u00A0", expected: [][]rune{{0x231A, 0x0308, 0x0020}, {0x00A0}}},                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u231A\uAC00", expected: [][]rune{{0x231A}, {0xAC00}}},                                                                                                                             // × [0.3] WATCH (ID) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u231A\u0020\uAC00", expected: [][]rune{{0x231A, 0x0020}, {0xAC00}}},                                                                                                               // × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u231A\u0308\uAC00", expected: [][]rune{{0x231A, 0x0308}, {0xAC00}}},                                                                                                               // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u231A\u0308\u0020\uAC00", expected: [][]rune{{0x231A, 0x0308, 0x0020}, {0xAC00}}},                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u231A\uAC01", expected: [][]rune{{0x231A}, {0xAC01}}},                                                                                                                             // × [0.3] WATCH (ID) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u231A\u0020\uAC01", expected: [][]rune{{0x231A, 0x0020}, {0xAC01}}},                                                                                                               // × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u231A\u0308\uAC01", expected: [][]rune{{0x231A, 0x0308}, {0xAC01}}},                                                                                                               // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u231A\u0308\u0020\uAC01", expected: [][]rune{{0x231A, 0x0308, 0x0020}, {0xAC01}}},                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u231A\u05D0", expected: [][]rune{{0x231A}, {0x05D0}}},                                                                                                                             // × [0.3] WATCH (ID) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u231A\u0020\u05D0", expected: [][]rune{{0x231A, 0x0020}, {0x05D0}}},                                                                                                               // × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u231A\u0308\u05D0", expected: [][]rune{{0x231A, 0x0308}, {0x05D0}}},                                                                                                               // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u231A\u0308\u0020\u05D0", expected: [][]rune{{0x231A, 0x0308, 0x0020}, {0x05D0}}},                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u231A\u002D", expected: [][]rune{{0x231A, 0x002D}}},                                                                                                                               // × [0.3] WATCH (ID) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u231A\u0020\u002D", expected: [][]rune{{0x231A, 0x0020}, {0x002D}}},                                                                                                               // × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u231A\u0308\u002D", expected: [][]rune{{0x231A, 0x0308, 0x002D}}},                                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u231A\u0308\u0020\u002D", expected: [][]rune{{0x231A, 0x0308, 0x0020}, {0x002D}}},                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u231A\u231A", expected: [][]rune{{0x231A}, {0x231A}}},                                                                                                                             // × [0.3] WATCH (ID) ÷ [999.0] WATCH (ID) ÷ [0.3]
	{original: "\u231A\u0020\u231A", expected: [][]rune{{0x231A, 0x0020}, {0x231A}}},                                                                                                               // × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
	{original: "\u231A\u0308\u231A", expected: [][]rune{{0x231A, 0x0308}, {0x231A}}},                                                                                                               // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
	{original: "\u231A\u0308\u0020\u231A", expected: [][]rune{{0x231A, 0x0308, 0x0020}, {0x231A}}},                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
	{original: "\u231A\u2024", expected: [][]rune{{0x231A, 0x2024}}},                                                                                                                               // × [0.3] WATCH (ID) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u231A\u0020\u2024", expected: [][]rune{{0x231A, 0x0020}, {0x2024}}},                                                                                                               // × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u231A\u0308\u2024", expected: [][]rune{{0x231A, 0x0308, 0x2024}}},                                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u231A\u0308\u0020\u2024", expected: [][]rune{{0x231A, 0x0308, 0x0020}, {0x2024}}},                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u231A\u002C", expected: [][]rune{{0x231A, 0x002C}}},                                                                                                                               // × [0.3] WATCH (ID) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u231A\u0020\u002C", expected: [][]rune{{0x231A, 0x0020, 0x002C}}},                                                                                                                 // × [0.3] WATCH (ID) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u231A\u0308\u002C", expected: [][]rune{{0x231A, 0x0308, 0x002C}}},                                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
	{original: "\u231A\u0308\u0020\u002C", expected: [][]rune{{0x231A, 0x0308, 0x0020, 0x002C}}},                                                                                                   // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u231A\u1100", expected: [][]rune{{0x231A}, {0x1100}}},                                                                                                                             // × [0.3] WATCH (ID) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u231A\u0020\u1100", expected: [][]rune{{0x231A, 0x0020}, {0x1100}}},                                                                                                               // × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u231A\u0308\u1100", expected: [][]rune{{0x231A, 0x0308}, {0x1100}}},                                                                                                               // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u231A\u0308\u0020\u1100", expected: [][]rune{{0x231A, 0x0308, 0x0020}, {0x1100}}},                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u231A\u11A8", expected: [][]rune{{0x231A}, {0x11A8}}},                                                                                                                             // × [0.3] WATCH (ID) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u231A\u0020\u11A8", expected: [][]rune{{0x231A, 0x0020}, {0x11A8}}},                                                                                                               // × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u231A\u0308\u11A8", expected: [][]rune{{0x231A, 0x0308}, {0x11A8}}},                                                                                                               // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u231A\u0308\u0020\u11A8", expected: [][]rune{{0x231A, 0x0308, 0x0020}, {0x11A8}}},                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u231A\u1160", expected: [][]rune{{0x231A}, {0x1160}}},                                                                                                                             // × [0.3] WATCH (ID) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u231A\u0020\u1160", expected: [][]rune{{0x231A, 0x0020}, {0x1160}}},                                                                                                               // × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u231A\u0308\u1160", expected: [][]rune{{0x231A, 0x0308}, {0x1160}}},                                                                                                               // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u231A\u0308\u0020\u1160", expected: [][]rune{{0x231A, 0x0308, 0x0020}, {0x1160}}},                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u231A\u000A", expected: [][]rune{{0x231A, 0x000A}}},                                                                                                                               // × [0.3] WATCH (ID) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u231A\u0020\u000A", expected: [][]rune{{0x231A, 0x0020, 0x000A}}},                                                                                                                 // × [0.3] WATCH (ID) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u231A\u0308\u000A", expected: [][]rune{{0x231A, 0x0308, 0x000A}}},                                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u231A\u0308\u0020\u000A", expected: [][]rune{{0x231A, 0x0308, 0x0020, 0x000A}}},                                                                                                   // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u231A\u0085", expected: [][]rune{{0x231A, 0x0085}}},                                                                                                                               // × [0.3] WATCH (ID) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u231A\u0020\u0085", expected: [][]rune{{0x231A, 0x0020, 0x0085}}},                                                                                                                 // × [0.3] WATCH (ID) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u231A\u0308\u0085", expected: [][]rune{{0x231A, 0x0308, 0x0085}}},                                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u231A\u0308\u0020\u0085", expected: [][]rune{{0x231A, 0x0308, 0x0020, 0x0085}}},                                                                                                   // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u231A\u17D6", expected: [][]rune{{0x231A, 0x17D6}}},                                                                                                                               // × [0.3] WATCH (ID) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u231A\u0020\u17D6", expected: [][]rune{{0x231A, 0x0020}, {0x17D6}}},                                                                                                               // × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u231A\u0308\u17D6", expected: [][]rune{{0x231A, 0x0308, 0x17D6}}},                                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u231A\u0308\u0020\u17D6", expected: [][]rune{{0x231A, 0x0308, 0x0020}, {0x17D6}}},                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u231A\u0030", expected: [][]rune{{0x231A}, {0x0030}}},                                                                                                                             // × [0.3] WATCH (ID) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u231A\u0020\u0030", expected: [][]rune{{0x231A, 0x0020}, {0x0030}}},                                                                                                               // × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u231A\u0308\u0030", expected: [][]rune{{0x231A, 0x0308}, {0x0030}}},                                                                                                               // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u231A\u0308\u0020\u0030", expected: [][]rune{{0x231A, 0x0308, 0x0020}, {0x0030}}},                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u231A\u2329", expected: [][]rune{{0x231A}, {0x2329}}},                                                                                                                             // × [0.3] WATCH (ID) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u231A\u0020\u2329", expected: [][]rune{{0x231A, 0x0020}, {0x2329}}},                                                                                                               // × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u231A\u0308\u2329", expected: [][]rune{{0x231A, 0x0308}, {0x2329}}},                                                                                                               // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u231A\u0308\u0020\u2329", expected: [][]rune{{0x231A, 0x0308, 0x0020}, {0x2329}}},                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u231A\u0025", expected: [][]rune{{0x231A, 0x0025}}},                                                                                                                               // × [0.3] WATCH (ID) × [23.13] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u231A\u0020\u0025", expected: [][]rune{{0x231A, 0x0020}, {0x0025}}},                                                                                                               // × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u231A\u0308\u0025", expected: [][]rune{{0x231A, 0x0308, 0x0025}}},                                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [23.13] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u231A\u0308\u0020\u0025", expected: [][]rune{{0x231A, 0x0308, 0x0020}, {0x0025}}},                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u231A\u0024", expected: [][]rune{{0x231A}, {0x0024}}},                                                                                                                             // × [0.3] WATCH (ID) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u231A\u0020\u0024", expected: [][]rune{{0x231A, 0x0020}, {0x0024}}},                                                                                                               // × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u231A\u0308\u0024", expected: [][]rune{{0x231A, 0x0308}, {0x0024}}},                                                                                                               // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u231A\u0308\u0020\u0024", expected: [][]rune{{0x231A, 0x0308, 0x0020}, {0x0024}}},                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u231A\u0022", expected: [][]rune{{0x231A, 0x0022}}},                                                                                                                               // × [0.3] WATCH (ID) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u231A\u0020\u0022", expected: [][]rune{{0x231A, 0x0020}, {0x0022}}},                                                                                                               // × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u231A\u0308\u0022", expected: [][]rune{{0x231A, 0x0308, 0x0022}}},                                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u231A\u0308\u0020\u0022", expected: [][]rune{{0x231A, 0x0308, 0x0020}, {0x0022}}},                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u231A\u0020", expected: [][]rune{{0x231A, 0x0020}}},                                                                                                                               // × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u231A\u0020\u0020", expected: [][]rune{{0x231A, 0x0020, 0x0020}}},                                                                                                                 // × [0.3] WATCH (ID) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u231A\u0308\u0020", expected: [][]rune{{0x231A, 0x0308, 0x0020}}},                                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u231A\u0308\u0020\u0020", expected: [][]rune{{0x231A, 0x0308, 0x0020, 0x0020}}},                                                                                                   // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u231A\u002F", expected: [][]rune{{0x231A, 0x002F}}},                                                                                                                               // × [0.3] WATCH (ID) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\u231A\u0020\u002F", expected: [][]rune{{0x231A, 0x0020, 0x002F}}},                                                                                                                 // × [0.3] WATCH (ID) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\u231A\u0308\u002F", expected: [][]rune{{0x231A, 0x0308, 0x002F}}},                                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
	{original: "\u231A\u0308\u0020\u002F", expected: [][]rune{{0x231A, 0x0308, 0x0020, 0x002F}}},                                                                                                   // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\u231A\u2060", expected: [][]rune{{0x231A, 0x2060}}},                                                                                                                               // × [0.3] WATCH (ID) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u231A\u0020\u2060", expected: [][]rune{{0x231A, 0x0020, 0x2060}}},                                                                                                                 // × [0.3] WATCH (ID) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u231A\u0308\u2060", expected: [][]rune{{0x231A, 0x0308, 0x2060}}},                                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u231A\u0308\u0020\u2060", expected: [][]rune{{0x231A, 0x0308, 0x0020, 0x2060}}},                                                                                                   // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u231A\u200B", expected: [][]rune{{0x231A, 0x200B}}},                                                                                                                               // × [0.3] WATCH (ID) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u231A\u0020\u200B", expected: [][]rune{{0x231A, 0x0020, 0x200B}}},                                                                                                                 // × [0.3] WATCH (ID) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u231A\u0308\u200B", expected: [][]rune{{0x231A, 0x0308, 0x200B}}},                                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u231A\u0308\u0020\u200B", expected: [][]rune{{0x231A, 0x0308, 0x0020, 0x200B}}},                                                                                                   // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u231A\U0001F1E6", expected: [][]rune{{0x231A}, {0x1F1E6}}},                                                                                                                        // × [0.3] WATCH (ID) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u231A\u0020\U0001F1E6", expected: [][]rune{{0x231A, 0x0020}, {0x1F1E6}}},                                                                                                          // × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u231A\u0308\U0001F1E6", expected: [][]rune{{0x231A, 0x0308}, {0x1F1E6}}},                                                                                                          // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u231A\u0308\u0020\U0001F1E6", expected: [][]rune{{0x231A, 0x0308, 0x0020}, {0x1F1E6}}},                                                                                            // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u231A\u261D", expected: [][]rune{{0x231A}, {0x261D}}},                                                                                                                             // × [0.3] WATCH (ID) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u231A\u0020\u261D", expected: [][]rune{{0x231A, 0x0020}, {0x261D}}},                                                                                                               // × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u231A\u0308\u261D", expected: [][]rune{{0x231A, 0x0308}, {0x261D}}},                                                                                                               // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u231A\u0308\u0020\u261D", expected: [][]rune{{0x231A, 0x0308, 0x0020}, {0x261D}}},                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u231A\U0001F3FB", expected: [][]rune{{0x231A}, {0x1F3FB}}},                                                                                                                        // × [0.3] WATCH (ID) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u231A\u0020\U0001F3FB", expected: [][]rune{{0x231A, 0x0020}, {0x1F3FB}}},                                                                                                          // × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u231A\u0308\U0001F3FB", expected: [][]rune{{0x231A, 0x0308}, {0x1F3FB}}},                                                                                                          // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u231A\u0308\u0020\U0001F3FB", expected: [][]rune{{0x231A, 0x0308, 0x0020}, {0x1F3FB}}},                                                                                            // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u231A\u0029", expected: [][]rune{{0x231A, 0x0029}}},                                                                                                                               // × [0.3] WATCH (ID) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u231A\u0020\u0029", expected: [][]rune{{0x231A, 0x0020, 0x0029}}},                                                                                                                 // × [0.3] WATCH (ID) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u231A\u0308\u0029", expected: [][]rune{{0x231A, 0x0308, 0x0029}}},                                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u231A\u0308\u0020\u0029", expected: [][]rune{{0x231A, 0x0308, 0x0020, 0x0029}}},                                                                                                   // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u231A\u0028", expected: [][]rune{{0x231A}, {0x0028}}},                                                                                                                             // × [0.3] WATCH (ID) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u231A\u0020\u0028", expected: [][]rune{{0x231A, 0x0020}, {0x0028}}},                                                                                                               // × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u231A\u0308\u0028", expected: [][]rune{{0x231A, 0x0308}, {0x0028}}},                                                                                                               // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u231A\u0308\u0020\u0028", expected: [][]rune{{0x231A, 0x0308, 0x0020}, {0x0028}}},                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u231A\u0001", expected: [][]rune{{0x231A, 0x0001}}},                                                                                                                               // × [0.3] WATCH (ID) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u231A\u0020\u0001", expected: [][]rune{{0x231A, 0x0020}, {0x0001}}},                                                                                                               // × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u231A\u0308\u0001", expected: [][]rune{{0x231A, 0x0308, 0x0001}}},                                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u231A\u0308\u0020\u0001", expected: [][]rune{{0x231A, 0x0308, 0x0020}, {0x0001}}},                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u231A\u200D", expected: [][]rune{{0x231A, 0x200D}}},                                                                                                                               // × [0.3] WATCH (ID) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u231A\u0020\u200D", expected: [][]rune{{0x231A, 0x0020}, {0x200D}}},                                                                                                               // × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u231A\u0308\u200D", expected: [][]rune{{0x231A, 0x0308, 0x200D}}},                                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u231A\u0308\u0020\u200D", expected: [][]rune{{0x231A, 0x0308, 0x0020}, {0x200D}}},                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u231A\u00A7", expected: [][]rune{{0x231A}, {0x00A7}}},                                                                                                                             // × [0.3] WATCH (ID) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u231A\u0020\u00A7", expected: [][]rune{{0x231A, 0x0020}, {0x00A7}}},                                                                                                               // × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u231A\u0308\u00A7", expected: [][]rune{{0x231A, 0x0308}, {0x00A7}}},                                                                                                               // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u231A\u0308\u0020\u00A7", expected: [][]rune{{0x231A, 0x0308, 0x0020}, {0x00A7}}},                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u231A\U00050005", expected: [][]rune{{0x231A}, {0x50005}}},                                                                                                                        // × [0.3] WATCH (ID) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u231A\u0020\U00050005", expected: [][]rune{{0x231A, 0x0020}, {0x50005}}},                                                                                                          // × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u231A\u0308\U00050005", expected: [][]rune{{0x231A, 0x0308}, {0x50005}}},                                                                                                          // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u231A\u0308\u0020\U00050005", expected: [][]rune{{0x231A, 0x0308, 0x0020}, {0x50005}}},                                                                                            // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u231A\u0E01", expected: [][]rune{{0x231A}, {0x0E01}}},                                                                                                                             // × [0.3] WATCH (ID) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u231A\u0020\u0E01", expected: [][]rune{{0x231A, 0x0020}, {0x0E01}}},                                                                                                               // × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u231A\u0308\u0E01", expected: [][]rune{{0x231A, 0x0308}, {0x0E01}}},                                                                                                               // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u231A\u0308\u0020\u0E01", expected: [][]rune{{0x231A, 0x0308, 0x0020}, {0x0E01}}},                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u231A\u3041", expected: [][]rune{{0x231A, 0x3041}}},                                                                                                                               // × [0.3] WATCH (ID) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u231A\u0020\u3041", expected: [][]rune{{0x231A, 0x0020}, {0x3041}}},                                                                                                               // × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u231A\u0308\u3041", expected: [][]rune{{0x231A, 0x0308, 0x3041}}},                                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u231A\u0308\u0020\u3041", expected: [][]rune{{0x231A, 0x0308, 0x0020}, {0x3041}}},                                                                                                 // × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u2024\u0023", expected: [][]rune{{0x2024}, {0x0023}}},                                                                                                                             // × [0.3] ONE DOT LEADER (IN) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u2024\u0020\u0023", expected: [][]rune{{0x2024, 0x0020}, {0x0023}}},                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u2024\u0308\u0023", expected: [][]rune{{0x2024, 0x0308}, {0x0023}}},                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u2024\u0308\u0020\u0023", expected: [][]rune{{0x2024, 0x0308, 0x0020}, {0x0023}}},                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u2024\u2014", expected: [][]rune{{0x2024}, {0x2014}}},                                                                                                                             // × [0.3] ONE DOT LEADER (IN) ÷ [999.0] EM DASH (B2) ÷ [0.3]
	{original: "\u2024\u0020\u2014", expected: [][]rune{{0x2024, 0x0020}, {0x2014}}},                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
	{original: "\u2024\u0308\u2014", expected: [][]rune{{0x2024, 0x0308}, {0x2014}}},                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
	{original: "\u2024\u0308\u0020\u2014", expected: [][]rune{{0x2024, 0x0308, 0x0020}, {0x2014}}},                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
	{original: "\u2024\u0009", expected: [][]rune{{0x2024, 0x0009}}},                                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u2024\u0020\u0009", expected: [][]rune{{0x2024, 0x0020}, {0x0009}}},                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u2024\u0308\u0009", expected: [][]rune{{0x2024, 0x0308, 0x0009}}},                                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u2024\u0308\u0020\u0009", expected: [][]rune{{0x2024, 0x0308, 0x0020}, {0x0009}}},                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u2024\u00B4", expected: [][]rune{{0x2024}, {0x00B4}}},                                                                                                                             // × [0.3] ONE DOT LEADER (IN) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u2024\u0020\u00B4", expected: [][]rune{{0x2024, 0x0020}, {0x00B4}}},                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u2024\u0308\u00B4", expected: [][]rune{{0x2024, 0x0308}, {0x00B4}}},                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u2024\u0308\u0020\u00B4", expected: [][]rune{{0x2024, 0x0308, 0x0020}, {0x00B4}}},                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u2024\u000B", expected: [][]rune{{0x2024, 0x000B}}},                                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u2024\u0020\u000B", expected: [][]rune{{0x2024, 0x0020, 0x000B}}},                                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u2024\u0308\u000B", expected: [][]rune{{0x2024, 0x0308, 0x000B}}},                                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u2024\u0308\u0020\u000B", expected: [][]rune{{0x2024, 0x0308, 0x0020, 0x000B}}},                                                                                                   // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u2024\uFFFC", expected: [][]rune{{0x2024}, {0xFFFC}}},                                                                                                                             // × [0.3] ONE DOT LEADER (IN) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u2024\u0020\uFFFC", expected: [][]rune{{0x2024, 0x0020}, {0xFFFC}}},                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u2024\u0308\uFFFC", expected: [][]rune{{0x2024, 0x0308}, {0xFFFC}}},                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u2024\u0308\u0020\uFFFC", expected: [][]rune{{0x2024, 0x0308, 0x0020}, {0xFFFC}}},                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u2024\u007D", expected: [][]rune{{0x2024, 0x007D}}},                                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u2024\u0020\u007D", expected: [][]rune{{0x2024, 0x0020, 0x007D}}},                                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u2024\u0308\u007D", expected: [][]rune{{0x2024, 0x0308, 0x007D}}},                                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u2024\u0308\u0020\u007D", expected: [][]rune{{0x2024, 0x0308, 0x0020, 0x007D}}},                                                                                                   // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u2024\u000D", expected: [][]rune{{0x2024, 0x000D}}},                                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u2024\u0020\u000D", expected: [][]rune{{0x2024, 0x0020, 0x000D}}},                                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u2024\u0308\u000D", expected: [][]rune{{0x2024, 0x0308, 0x000D}}},                                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u2024\u0308\u0020\u000D", expected: [][]rune{{0x2024, 0x0308, 0x0020, 0x000D}}},                                                                                                   // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u2024\u0021", expected: [][]rune{{0x2024, 0x0021}}},                                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u2024\u0020\u0021", expected: [][]rune{{0x2024, 0x0020, 0x0021}}},                                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u2024\u0308\u0021", expected: [][]rune{{0x2024, 0x0308, 0x0021}}},                                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u2024\u0308\u0020\u0021", expected: [][]rune{{0x2024, 0x0308, 0x0020, 0x0021}}},                                                                                                   // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u2024\u00A0", expected: [][]rune{{0x2024, 0x00A0}}},                                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [12.1] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u2024\u0020\u00A0", expected: [][]rune{{0x2024, 0x0020}, {0x00A0}}},                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u2024\u0308\u00A0", expected: [][]rune{{0x2024, 0x0308, 0x00A0}}},                                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u2024\u0308\u0020\u00A0", expected: [][]rune{{0x2024, 0x0308, 0x0020}, {0x00A0}}},                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u2024\uAC00", expected: [][]rune{{0x2024}, {0xAC00}}},                                                                                                                             // × [0.3] ONE DOT LEADER (IN) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u2024\u0020\uAC00", expected: [][]rune{{0x2024, 0x0020}, {0xAC00}}},                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u2024\u0308\uAC00", expected: [][]rune{{0x2024, 0x0308}, {0xAC00}}},                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u2024\u0308\u0020\uAC00", expected: [][]rune{{0x2024, 0x0308, 0x0020}, {0xAC00}}},                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u2024\uAC01", expected: [][]rune{{0x2024}, {0xAC01}}},                                                                                                                             // × [0.3] ONE DOT LEADER (IN) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u2024\u0020\uAC01", expected: [][]rune{{0x2024, 0x0020}, {0xAC01}}},                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u2024\u0308\uAC01", expected: [][]rune{{0x2024, 0x0308}, {0xAC01}}},                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u2024\u0308\u0020\uAC01", expected: [][]rune{{0x2024, 0x0308, 0x0020}, {0xAC01}}},                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u2024\u05D0", expected: [][]rune{{0x2024}, {0x05D0}}},                                                                                                                             // × [0.3] ONE DOT LEADER (IN) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u2024\u0020\u05D0", expected: [][]rune{{0x2024, 0x0020}, {0x05D0}}},                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u2024\u0308\u05D0", expected: [][]rune{{0x2024, 0x0308}, {0x05D0}}},                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u2024\u0308\u0020\u05D0", expected: [][]rune{{0x2024, 0x0308, 0x0020}, {0x05D0}}},                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u2024\u002D", expected: [][]rune{{0x2024, 0x002D}}},                                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u2024\u0020\u002D", expected: [][]rune{{0x2024, 0x0020}, {0x002D}}},                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u2024\u0308\u002D", expected: [][]rune{{0x2024, 0x0308, 0x002D}}},                                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u2024\u0308\u0020\u002D", expected: [][]rune{{0x2024, 0x0308, 0x0020}, {0x002D}}},                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u2024\u231A", expected: [][]rune{{0x2024}, {0x231A}}},                                                                                                                             // × [0.3] ONE DOT LEADER (IN) ÷ [999.0] WATCH (ID) ÷ [0.3]
	{original: "\u2024\u0020\u231A", expected: [][]rune{{0x2024, 0x0020}, {0x231A}}},                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
	{original: "\u2024\u0308\u231A", expected: [][]rune{{0x2024, 0x0308}, {0x231A}}},                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
	{original: "\u2024\u0308\u0020\u231A", expected: [][]rune{{0x2024, 0x0308, 0x0020}, {0x231A}}},                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
	{original: "\u2024\u2024", expected: [][]rune{{0x2024, 0x2024}}},                                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u2024\u0020\u2024", expected: [][]rune{{0x2024, 0x0020}, {0x2024}}},                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u2024\u0308\u2024", expected: [][]rune{{0x2024, 0x0308, 0x2024}}},                                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u2024\u0308\u0020\u2024", expected: [][]rune{{0x2024, 0x0308, 0x0020}, {0x2024}}},                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u2024\u002C", expected: [][]rune{{0x2024, 0x002C}}},                                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u2024\u0020\u002C", expected: [][]rune{{0x2024, 0x0020, 0x002C}}},                                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u2024\u0308\u002C", expected: [][]rune{{0x2024, 0x0308, 0x002C}}},                                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
	{original: "\u2024\u0308\u0020\u002C", expected: [][]rune{{0x2024, 0x0308, 0x0020, 0x002C}}},                                                                                                   // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u2024\u1100", expected: [][]rune{{0x2024}, {0x1100}}},                                                                                                                             // × [0.3] ONE DOT LEADER (IN) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u2024\u0020\u1100", expected: [][]rune{{0x2024, 0x0020}, {0x1100}}},                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u2024\u0308\u1100", expected: [][]rune{{0x2024, 0x0308}, {0x1100}}},                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u2024\u0308\u0020\u1100", expected: [][]rune{{0x2024, 0x0308, 0x0020}, {0x1100}}},                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u2024\u11A8", expected: [][]rune{{0x2024}, {0x11A8}}},                                                                                                                             // × [0.3] ONE DOT LEADER (IN) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u2024\u0020\u11A8", expected: [][]rune{{0x2024, 0x0020}, {0x11A8}}},                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u2024\u0308\u11A8", expected: [][]rune{{0x2024, 0x0308}, {0x11A8}}},                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u2024\u0308\u0020\u11A8", expected: [][]rune{{0x2024, 0x0308, 0x0020}, {0x11A8}}},                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u2024\u1160", expected: [][]rune{{0x2024}, {0x1160}}},                                                                                                                             // × [0.3] ONE DOT LEADER (IN) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u2024\u0020\u1160", expected: [][]rune{{0x2024, 0x0020}, {0x1160}}},                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u2024\u0308\u1160", expected: [][]rune{{0x2024, 0x0308}, {0x1160}}},                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u2024\u0308\u0020\u1160", expected: [][]rune{{0x2024, 0x0308, 0x0020}, {0x1160}}},                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u2024\u000A", expected: [][]rune{{0x2024, 0x000A}}},                                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u2024\u0020\u000A", expected: [][]rune{{0x2024, 0x0020, 0x000A}}},                                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u2024\u0308\u000A", expected: [][]rune{{0x2024, 0x0308, 0x000A}}},                                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u2024\u0308\u0020\u000A", expected: [][]rune{{0x2024, 0x0308, 0x0020, 0x000A}}},                                                                                                   // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u2024\u0085", expected: [][]rune{{0x2024, 0x0085}}},                                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u2024\u0020\u0085", expected: [][]rune{{0x2024, 0x0020, 0x0085}}},                                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u2024\u0308\u0085", expected: [][]rune{{0x2024, 0x0308, 0x0085}}},                                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u2024\u0308\u0020\u0085", expected: [][]rune{{0x2024, 0x0308, 0x0020, 0x0085}}},                                                                                                   // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u2024\u17D6", expected: [][]rune{{0x2024, 0x17D6}}},                                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u2024\u0020\u17D6", expected: [][]rune{{0x2024, 0x0020}, {0x17D6}}},                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u2024\u0308\u17D6", expected: [][]rune{{0x2024, 0x0308, 0x17D6}}},                                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u2024\u0308\u0020\u17D6", expected: [][]rune{{0x2024, 0x0308, 0x0020}, {0x17D6}}},                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u2024\u0030", expected: [][]rune{{0x2024}, {0x0030}}},                                                                                                                             // × [0.3] ONE DOT LEADER (IN) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u2024\u0020\u0030", expected: [][]rune{{0x2024, 0x0020}, {0x0030}}},                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u2024\u0308\u0030", expected: [][]rune{{0x2024, 0x0308}, {0x0030}}},                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u2024\u0308\u0020\u0030", expected: [][]rune{{0x2024, 0x0308, 0x0020}, {0x0030}}},                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u2024\u2329", expected: [][]rune{{0x2024}, {0x2329}}},                                                                                                                             // × [0.3] ONE DOT LEADER (IN) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u2024\u0020\u2329", expected: [][]rune{{0x2024, 0x0020}, {0x2329}}},                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u2024\u0308\u2329", expected: [][]rune{{0x2024, 0x0308}, {0x2329}}},                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u2024\u0308\u0020\u2329", expected: [][]rune{{0x2024, 0x0308, 0x0020}, {0x2329}}},                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u2024\u0025", expected: [][]rune{{0x2024}, {0x0025}}},                                                                                                                             // × [0.3] ONE DOT LEADER (IN) ÷ [999.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u2024\u0020\u0025", expected: [][]rune{{0x2024, 0x0020}, {0x0025}}},                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u2024\u0308\u0025", expected: [][]rune{{0x2024, 0x0308}, {0x0025}}},                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u2024\u0308\u0020\u0025", expected: [][]rune{{0x2024, 0x0308, 0x0020}, {0x0025}}},                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u2024\u0024", expected: [][]rune{{0x2024}, {0x0024}}},                                                                                                                             // × [0.3] ONE DOT LEADER (IN) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u2024\u0020\u0024", expected: [][]rune{{0x2024, 0x0020}, {0x0024}}},                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u2024\u0308\u0024", expected: [][]rune{{0x2024, 0x0308}, {0x0024}}},                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u2024\u0308\u0020\u0024", expected: [][]rune{{0x2024, 0x0308, 0x0020}, {0x0024}}},                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u2024\u0022", expected: [][]rune{{0x2024, 0x0022}}},                                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u2024\u0020\u0022", expected: [][]rune{{0x2024, 0x0020}, {0x0022}}},                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u2024\u0308\u0022", expected: [][]rune{{0x2024, 0x0308, 0x0022}}},                                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u2024\u0308\u0020\u0022", expected: [][]rune{{0x2024, 0x0308, 0x0020}, {0x0022}}},                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u2024\u0020", expected: [][]rune{{0x2024, 0x0020}}},                                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u2024\u0020\u0020", expected: [][]rune{{0x2024, 0x0020, 0x0020}}},                                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u2024\u0308\u0020", expected: [][]rune{{0x2024, 0x0308, 0x0020}}},                                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u2024\u0308\u0020\u0020", expected: [][]rune{{0x2024, 0x0308, 0x0020, 0x0020}}},                                                                                                   // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u2024\u002F", expected: [][]rune{{0x2024, 0x002F}}},                                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\u2024\u0020\u002F", expected: [][]rune{{0x2024, 0x0020, 0x002F}}},                                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\u2024\u0308\u002F", expected: [][]rune{{0x2024, 0x0308, 0x002F}}},                                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
	{original: "\u2024\u0308\u0020\u002F", expected: [][]rune{{0x2024, 0x0308, 0x0020, 0x002F}}},                                                                                                   // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\u2024\u2060", expected: [][]rune{{0x2024, 0x2060}}},                                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u2024\u0020\u2060", expected: [][]rune{{0x2024, 0x0020, 0x2060}}},                                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u2024\u0308\u2060", expected: [][]rune{{0x2024, 0x0308, 0x2060}}},                                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u2024\u0308\u0020\u2060", expected: [][]rune{{0x2024, 0x0308, 0x0020, 0x2060}}},                                                                                                   // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u2024\u200B", expected: [][]rune{{0x2024, 0x200B}}},                                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u2024\u0020\u200B", expected: [][]rune{{0x2024, 0x0020, 0x200B}}},                                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u2024\u0308\u200B", expected: [][]rune{{0x2024, 0x0308, 0x200B}}},                                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u2024\u0308\u0020\u200B", expected: [][]rune{{0x2024, 0x0308, 0x0020, 0x200B}}},                                                                                                   // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u2024\U0001F1E6", expected: [][]rune{{0x2024}, {0x1F1E6}}},                                                                                                                        // × [0.3] ONE DOT LEADER (IN) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u2024\u0020\U0001F1E6", expected: [][]rune{{0x2024, 0x0020}, {0x1F1E6}}},                                                                                                          // × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u2024\u0308\U0001F1E6", expected: [][]rune{{0x2024, 0x0308}, {0x1F1E6}}},                                                                                                          // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u2024\u0308\u0020\U0001F1E6", expected: [][]rune{{0x2024, 0x0308, 0x0020}, {0x1F1E6}}},                                                                                            // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u2024\u261D", expected: [][]rune{{0x2024}, {0x261D}}},                                                                                                                             // × [0.3] ONE DOT LEADER (IN) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u2024\u0020\u261D", expected: [][]rune{{0x2024, 0x0020}, {0x261D}}},                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u2024\u0308\u261D", expected: [][]rune{{0x2024, 0x0308}, {0x261D}}},                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u2024\u0308\u0020\u261D", expected: [][]rune{{0x2024, 0x0308, 0x0020}, {0x261D}}},                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u2024\U0001F3FB", expected: [][]rune{{0x2024}, {0x1F3FB}}},                                                                                                                        // × [0.3] ONE DOT LEADER (IN) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u2024\u0020\U0001F3FB", expected: [][]rune{{0x2024, 0x0020}, {0x1F3FB}}},                                                                                                          // × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u2024\u0308\U0001F3FB", expected: [][]rune{{0x2024, 0x0308}, {0x1F3FB}}},                                                                                                          // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u2024\u0308\u0020\U0001F3FB", expected: [][]rune{{0x2024, 0x0308, 0x0020}, {0x1F3FB}}},                                                                                            // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u2024\u0029", expected: [][]rune{{0x2024, 0x0029}}},                                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u2024\u0020\u0029", expected: [][]rune{{0x2024, 0x0020, 0x0029}}},                                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u2024\u0308\u0029", expected: [][]rune{{0x2024, 0x0308, 0x0029}}},                                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u2024\u0308\u0020\u0029", expected: [][]rune{{0x2024, 0x0308, 0x0020, 0x0029}}},                                                                                                   // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u2024\u0028", expected: [][]rune{{0x2024}, {0x0028}}},                                                                                                                             // × [0.3] ONE DOT LEADER (IN) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u2024\u0020\u0028", expected: [][]rune{{0x2024, 0x0020}, {0x0028}}},                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u2024\u0308\u0028", expected: [][]rune{{0x2024, 0x0308}, {0x0028}}},                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u2024\u0308\u0020\u0028", expected: [][]rune{{0x2024, 0x0308, 0x0020}, {0x0028}}},                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u2024\u0001", expected: [][]rune{{0x2024, 0x0001}}},                                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u2024\u0020\u0001", expected: [][]rune{{0x2024, 0x0020}, {0x0001}}},                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u2024\u0308\u0001", expected: [][]rune{{0x2024, 0x0308, 0x0001}}},                                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u2024\u0308\u0020\u0001", expected: [][]rune{{0x2024, 0x0308, 0x0020}, {0x0001}}},                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u2024\u200D", expected: [][]rune{{0x2024, 0x200D}}},                                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u2024\u0020\u200D", expected: [][]rune{{0x2024, 0x0020}, {0x200D}}},                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u2024\u0308\u200D", expected: [][]rune{{0x2024, 0x0308, 0x200D}}},                                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u2024\u0308\u0020\u200D", expected: [][]rune{{0x2024, 0x0308, 0x0020}, {0x200D}}},                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u2024\u00A7", expected: [][]rune{{0x2024}, {0x00A7}}},                                                                                                                             // × [0.3] ONE DOT LEADER (IN) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u2024\u0020\u00A7", expected: [][]rune{{0x2024, 0x0020}, {0x00A7}}},                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u2024\u0308\u00A7", expected: [][]rune{{0x2024, 0x0308}, {0x00A7}}},                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u2024\u0308\u0020\u00A7", expected: [][]rune{{0x2024, 0x0308, 0x0020}, {0x00A7}}},                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u2024\U00050005", expected: [][]rune{{0x2024}, {0x50005}}},                                                                                                                        // × [0.3] ONE DOT LEADER (IN) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u2024\u0020\U00050005", expected: [][]rune{{0x2024, 0x0020}, {0x50005}}},                                                                                                          // × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u2024\u0308\U00050005", expected: [][]rune{{0x2024, 0x0308}, {0x50005}}},                                                                                                          // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u2024\u0308\u0020\U00050005", expected: [][]rune{{0x2024, 0x0308, 0x0020}, {0x50005}}},                                                                                            // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u2024\u0E01", expected: [][]rune{{0x2024}, {0x0E01}}},                                                                                                                             // × [0.3] ONE DOT LEADER (IN) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u2024\u0020\u0E01", expected: [][]rune{{0x2024, 0x0020}, {0x0E01}}},                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u2024\u0308\u0E01", expected: [][]rune{{0x2024, 0x0308}, {0x0E01}}},                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u2024\u0308\u0020\u0E01", expected: [][]rune{{0x2024, 0x0308, 0x0020}, {0x0E01}}},                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u2024\u3041", expected: [][]rune{{0x2024, 0x3041}}},                                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u2024\u0020\u3041", expected: [][]rune{{0x2024, 0x0020}, {0x3041}}},                                                                                                               // × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u2024\u0308\u3041", expected: [][]rune{{0x2024, 0x0308, 0x3041}}},                                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u2024\u0308\u0020\u3041", expected: [][]rune{{0x2024, 0x0308, 0x0020}, {0x3041}}},                                                                                                 // × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u002C\u0023", expected: [][]rune{{0x002C, 0x0023}}},                                                                                                                               // × [0.3] COMMA (IS) × [29.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u002C\u0020\u0023", expected: [][]rune{{0x002C, 0x0020}, {0x0023}}},                                                                                                               // × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u002C\u0308\u0023", expected: [][]rune{{0x002C, 0x0308, 0x0023}}},                                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [29.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u002C\u0308\u0020\u0023", expected: [][]rune{{0x002C, 0x0308, 0x0020}, {0x0023}}},                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u002C\u2014", expected: [][]rune{{0x002C}, {0x2014}}},                                                                                                                             // × [0.3] COMMA (IS) ÷ [999.0] EM DASH (B2) ÷ [0.3]
	{original: "\u002C\u0020\u2014", expected: [][]rune{{0x002C, 0x0020}, {0x2014}}},                                                                                                               // × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
	{original: "\u002C\u0308\u2014", expected: [][]rune{{0x002C, 0x0308}, {0x2014}}},                                                                                                               // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
	{original: "\u002C\u0308\u0020\u2014", expected: [][]rune{{0x002C, 0x0308, 0x0020}, {0x2014}}},                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
	{original: "\u002C\u0009", expected: [][]rune{{0x002C, 0x0009}}},                                                                                                                               // × [0.3] COMMA (IS) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u002C\u0020\u0009", expected: [][]rune{{0x002C, 0x0020}, {0x0009}}},                                                                                                               // × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u002C\u0308\u0009", expected: [][]rune{{0x002C, 0x0308, 0x0009}}},                                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u002C\u0308\u0020\u0009", expected: [][]rune{{0x002C, 0x0308, 0x0020}, {0x0009}}},                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u002C\u00B4", expected: [][]rune{{0x002C}, {0x00B4}}},                                                                                                                             // × [0.3] COMMA (IS) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u002C\u0020\u00B4", expected: [][]rune{{0x002C, 0x0020}, {0x00B4}}},                                                                                                               // × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u002C\u0308\u00B4", expected: [][]rune{{0x002C, 0x0308}, {0x00B4}}},                                                                                                               // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u002C\u0308\u0020\u00B4", expected: [][]rune{{0x002C, 0x0308, 0x0020}, {0x00B4}}},                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u002C\u000B", expected: [][]rune{{0x002C, 0x000B}}},                                                                                                                               // × [0.3] COMMA (IS) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u002C\u0020\u000B", expected: [][]rune{{0x002C, 0x0020, 0x000B}}},                                                                                                                 // × [0.3] COMMA (IS) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u002C\u0308\u000B", expected: [][]rune{{0x002C, 0x0308, 0x000B}}},                                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u002C\u0308\u0020\u000B", expected: [][]rune{{0x002C, 0x0308, 0x0020, 0x000B}}},                                                                                                   // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u002C\uFFFC", expected: [][]rune{{0x002C}, {0xFFFC}}},                                                                                                                             // × [0.3] COMMA (IS) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u002C\u0020\uFFFC", expected: [][]rune{{0x002C, 0x0020}, {0xFFFC}}},                                                                                                               // × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u002C\u0308\uFFFC", expected: [][]rune{{0x002C, 0x0308}, {0xFFFC}}},                                                                                                               // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u002C\u0308\u0020\uFFFC", expected: [][]rune{{0x002C, 0x0308, 0x0020}, {0xFFFC}}},                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u002C\u007D", expected: [][]rune{{0x002C, 0x007D}}},                                                                                                                               // × [0.3] COMMA (IS) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u002C\u0020\u007D", expected: [][]rune{{0x002C, 0x0020, 0x007D}}},                                                                                                                 // × [0.3] COMMA (IS) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u002C\u0308\u007D", expected: [][]rune{{0x002C, 0x0308, 0x007D}}},                                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u002C\u0308\u0020\u007D", expected: [][]rune{{0x002C, 0x0308, 0x0020, 0x007D}}},                                                                                                   // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u002C\u000D", expected: [][]rune{{0x002C, 0x000D}}},                                                                                                                               // × [0.3] COMMA (IS) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u002C\u0020\u000D", expected: [][]rune{{0x002C, 0x0020, 0x000D}}},                                                                                                                 // × [0.3] COMMA (IS) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u002C\u0308\u000D", expected: [][]rune{{0x002C, 0x0308, 0x000D}}},                                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u002C\u0308\u0020\u000D", expected: [][]rune{{0x002C, 0x0308, 0x0020, 0x000D}}},                                                                                                   // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u002C\u0021", expected: [][]rune{{0x002C, 0x0021}}},                                                                                                                               // × [0.3] COMMA (IS) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u002C\u0020\u0021", expected: [][]rune{{0x002C, 0x0020, 0x0021}}},                                                                                                                 // × [0.3] COMMA (IS) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u002C\u0308\u0021", expected: [][]rune{{0x002C, 0x0308, 0x0021}}},                                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u002C\u0308\u0020\u0021", expected: [][]rune{{0x002C, 0x0308, 0x0020, 0x0021}}},                                                                                                   // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u002C\u00A0", expected: [][]rune{{0x002C, 0x00A0}}},                                                                                                                               // × [0.3] COMMA (IS) × [12.1] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u002C\u0020\u00A0", expected: [][]rune{{0x002C, 0x0020}, {0x00A0}}},                                                                                                               // × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u002C\u0308\u00A0", expected: [][]rune{{0x002C, 0x0308, 0x00A0}}},                                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u002C\u0308\u0020\u00A0", expected: [][]rune{{0x002C, 0x0308, 0x0020}, {0x00A0}}},                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u002C\uAC00", expected: [][]rune{{0x002C}, {0xAC00}}},                                                                                                                             // × [0.3] COMMA (IS) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u002C\u0020\uAC00", expected: [][]rune{{0x002C, 0x0020}, {0xAC00}}},                                                                                                               // × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u002C\u0308\uAC00", expected: [][]rune{{0x002C, 0x0308}, {0xAC00}}},                                                                                                               // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u002C\u0308\u0020\uAC00", expected: [][]rune{{0x002C, 0x0308, 0x0020}, {0xAC00}}},                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u002C\uAC01", expected: [][]rune{{0x002C}, {0xAC01}}},                                                                                                                             // × [0.3] COMMA (IS) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u002C\u0020\uAC01", expected: [][]rune{{0x002C, 0x0020}, {0xAC01}}},                                                                                                               // × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u002C\u0308\uAC01", expected: [][]rune{{0x002C, 0x0308}, {0xAC01}}},                                                                                                               // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u002C\u0308\u0020\uAC01", expected: [][]rune{{0x002C, 0x0308, 0x0020}, {0xAC01}}},                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u002C\u05D0", expected: [][]rune{{0x002C, 0x05D0}}},                                                                                                                               // × [0.3] COMMA (IS) × [29.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u002C\u0020\u05D0", expected: [][]rune{{0x002C, 0x0020}, {0x05D0}}},                                                                                                               // × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u002C\u0308\u05D0", expected: [][]rune{{0x002C, 0x0308, 0x05D0}}},                                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [29.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u002C\u0308\u0020\u05D0", expected: [][]rune{{0x002C, 0x0308, 0x0020}, {0x05D0}}},                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u002C\u002D", expected: [][]rune{{0x002C, 0x002D}}},                                                                                                                               // × [0.3] COMMA (IS) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u002C\u0020\u002D", expected: [][]rune{{0x002C, 0x0020}, {0x002D}}},                                                                                                               // × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u002C\u0308\u002D", expected: [][]rune{{0x002C, 0x0308, 0x002D}}},                                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u002C\u0308\u0020\u002D", expected: [][]rune{{0x002C, 0x0308, 0x0020}, {0x002D}}},                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u002C\u231A", expected: [][]rune{{0x002C}, {0x231A}}},                                                                                                                             // × [0.3] COMMA (IS) ÷ [999.0] WATCH (ID) ÷ [0.3]
	{original: "\u002C\u0020\u231A", expected: [][]rune{{0x002C, 0x0020}, {0x231A}}},                                                                                                               // × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
	{original: "\u002C\u0308\u231A", expected: [][]rune{{0x002C, 0x0308}, {0x231A}}},                                                                                                               // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
	{original: "\u002C\u0308\u0020\u231A", expected: [][]rune{{0x002C, 0x0308, 0x0020}, {0x231A}}},                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
	{original: "\u002C\u2024", expected: [][]rune{{0x002C, 0x2024}}},                                                                                                                               // × [0.3] COMMA (IS) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u002C\u0020\u2024", expected: [][]rune{{0x002C, 0x0020}, {0x2024}}},                                                                                                               // × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u002C\u0308\u2024", expected: [][]rune{{0x002C, 0x0308, 0x2024}}},                                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u002C\u0308\u0020\u2024", expected: [][]rune{{0x002C, 0x0308, 0x0020}, {0x2024}}},                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u002C\u002C", expected: [][]rune{{0x002C, 0x002C}}},                                                                                                                               // × [0.3] COMMA (IS) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u002C\u0020\u002C", expected: [][]rune{{0x002C, 0x0020, 0x002C}}},                                                                                                                 // × [0.3] COMMA (IS) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u002C\u0308\u002C", expected: [][]rune{{0x002C, 0x0308, 0x002C}}},                                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
	{original: "\u002C\u0308\u0020\u002C", expected: [][]rune{{0x002C, 0x0308, 0x0020, 0x002C}}},                                                                                                   // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u002C\u1100", expected: [][]rune{{0x002C}, {0x1100}}},                                                                                                                             // × [0.3] COMMA (IS) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u002C\u0020\u1100", expected: [][]rune{{0x002C, 0x0020}, {0x1100}}},                                                                                                               // × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u002C\u0308\u1100", expected: [][]rune{{0x002C, 0x0308}, {0x1100}}},                                                                                                               // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u002C\u0308\u0020\u1100", expected: [][]rune{{0x002C, 0x0308, 0x0020}, {0x1100}}},                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u002C\u11A8", expected: [][]rune{{0x002C}, {0x11A8}}},                                                                                                                             // × [0.3] COMMA (IS) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u002C\u0020\u11A8", expected: [][]rune{{0x002C, 0x0020}, {0x11A8}}},                                                                                                               // × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u002C\u0308\u11A8", expected: [][]rune{{0x002C, 0x0308}, {0x11A8}}},                                                                                                               // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u002C\u0308\u0020\u11A8", expected: [][]rune{{0x002C, 0x0308, 0x0020}, {0x11A8}}},                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u002C\u1160", expected: [][]rune{{0x002C}, {0x1160}}},                                                                                                                             // × [0.3] COMMA (IS) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u002C\u0020\u1160", expected: [][]rune{{0x002C, 0x0020}, {0x1160}}},                                                                                                               // × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u002C\u0308\u1160", expected: [][]rune{{0x002C, 0x0308}, {0x1160}}},                                                                                                               // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u002C\u0308\u0020\u1160", expected: [][]rune{{0x002C, 0x0308, 0x0020}, {0x1160}}},                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u002C\u000A", expected: [][]rune{{0x002C, 0x000A}}},                                                                                                                               // × [0.3] COMMA (IS) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u002C\u0020\u000A", expected: [][]rune{{0x002C, 0x0020, 0x000A}}},                                                                                                                 // × [0.3] COMMA (IS) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u002C\u0308\u000A", expected: [][]rune{{0x002C, 0x0308, 0x000A}}},                                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u002C\u0308\u0020\u000A", expected: [][]rune{{0x002C, 0x0308, 0x0020, 0x000A}}},                                                                                                   // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u002C\u0085", expected: [][]rune{{0x002C, 0x0085}}},                                                                                                                               // × [0.3] COMMA (IS) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u002C\u0020\u0085", expected: [][]rune{{0x002C, 0x0020, 0x0085}}},                                                                                                                 // × [0.3] COMMA (IS) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u002C\u0308\u0085", expected: [][]rune{{0x002C, 0x0308, 0x0085}}},                                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u002C\u0308\u0020\u0085", expected: [][]rune{{0x002C, 0x0308, 0x0020, 0x0085}}},                                                                                                   // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u002C\u17D6", expected: [][]rune{{0x002C, 0x17D6}}},                                                                                                                               // × [0.3] COMMA (IS) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u002C\u0020\u17D6", expected: [][]rune{{0x002C, 0x0020}, {0x17D6}}},                                                                                                               // × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u002C\u0308\u17D6", expected: [][]rune{{0x002C, 0x0308, 0x17D6}}},                                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u002C\u0308\u0020\u17D6", expected: [][]rune{{0x002C, 0x0308, 0x0020}, {0x17D6}}},                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u002C\u0030", expected: [][]rune{{0x002C}, {0x0030}}},                                                                                                                             // × [0.3] COMMA (IS) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u002C\u0020\u0030", expected: [][]rune{{0x002C, 0x0020}, {0x0030}}},                                                                                                               // × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u002C\u0308\u0030", expected: [][]rune{{0x002C, 0x0308}, {0x0030}}},                                                                                                               // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u002C\u0308\u0020\u0030", expected: [][]rune{{0x002C, 0x0308, 0x0020}, {0x0030}}},                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u002C\u2329", expected: [][]rune{{0x002C}, {0x2329}}},                                                                                                                             // × [0.3] COMMA (IS) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u002C\u0020\u2329", expected: [][]rune{{0x002C, 0x0020}, {0x2329}}},                                                                                                               // × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u002C\u0308\u2329", expected: [][]rune{{0x002C, 0x0308}, {0x2329}}},                                                                                                               // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u002C\u0308\u0020\u2329", expected: [][]rune{{0x002C, 0x0308, 0x0020}, {0x2329}}},                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u002C\u0025", expected: [][]rune{{0x002C}, {0x0025}}},                                                                                                                             // × [0.3] COMMA (IS) ÷ [999.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u002C\u0020\u0025", expected: [][]rune{{0x002C, 0x0020}, {0x0025}}},                                                                                                               // × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u002C\u0308\u0025", expected: [][]rune{{0x002C, 0x0308}, {0x0025}}},                                                                                                               // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u002C\u0308\u0020\u0025", expected: [][]rune{{0x002C, 0x0308, 0x0020}, {0x0025}}},                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u002C\u0024", expected: [][]rune{{0x002C}, {0x0024}}},                                                                                                                             // × [0.3] COMMA (IS) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u002C\u0020\u0024", expected: [][]rune{{0x002C, 0x0020}, {0x0024}}},                                                                                                               // × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u002C\u0308\u0024", expected: [][]rune{{0x002C, 0x0308}, {0x0024}}},                                                                                                               // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u002C\u0308\u0020\u0024", expected: [][]rune{{0x002C, 0x0308, 0x0020}, {0x0024}}},                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u002C\u0022", expected: [][]rune{{0x002C, 0x0022}}},                                                                                                                               // × [0.3] COMMA (IS) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u002C\u0020\u0022", expected: [][]rune{{0x002C, 0x0020}, {0x0022}}},                                                                                                               // × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u002C\u0308\u0022", expected: [][]rune{{0x002C, 0x0308, 0x0022}}},                                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u002C\u0308\u0020\u0022", expected: [][]rune{{0x002C, 0x0308, 0x0020}, {0x0022}}},                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u002C\u0020", expected: [][]rune{{0x002C, 0x0020}}},                                                                                                                               // × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u002C\u0020\u0020", expected: [][]rune{{0x002C, 0x0020, 0x0020}}},                                                                                                                 // × [0.3] COMMA (IS) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u002C\u0308\u0020", expected: [][]rune{{0x002C, 0x0308, 0x0020}}},                                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u002C\u0308\u0020\u0020", expected: [][]rune{{0x002C, 0x0308, 0x0020, 0x0020}}},                                                                                                   // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u002C\u002F", expected: [][]rune{{0x002C, 0x002F}}},                                                                                                                               // × [0.3] COMMA (IS) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\u002C\u0020\u002F", expected: [][]rune{{0x002C, 0x0020, 0x002F}}},                                                                                                                 // × [0.3] COMMA (IS) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\u002C\u0308\u002F", expected: [][]rune{{0x002C, 0x0308, 0x002F}}},                                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
	{original: "\u002C\u0308\u0020\u002F", expected: [][]rune{{0x002C, 0x0308, 0x0020, 0x002F}}},                                                                                                   // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\u002C\u2060", expected: [][]rune{{0x002C, 0x2060}}},                                                                                                                               // × [0.3] COMMA (IS) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u002C\u0020\u2060", expected: [][]rune{{0x002C, 0x0020, 0x2060}}},                                                                                                                 // × [0.3] COMMA (IS) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u002C\u0308\u2060", expected: [][]rune{{0x002C, 0x0308, 0x2060}}},                                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u002C\u0308\u0020\u2060", expected: [][]rune{{0x002C, 0x0308, 0x0020, 0x2060}}},                                                                                                   // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u002C\u200B", expected: [][]rune{{0x002C, 0x200B}}},                                                                                                                               // × [0.3] COMMA (IS) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u002C\u0020\u200B", expected: [][]rune{{0x002C, 0x0020, 0x200B}}},                                                                                                                 // × [0.3] COMMA (IS) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u002C\u0308\u200B", expected: [][]rune{{0x002C, 0x0308, 0x200B}}},                                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u002C\u0308\u0020\u200B", expected: [][]rune{{0x002C, 0x0308, 0x0020, 0x200B}}},                                                                                                   // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u002C\U0001F1E6", expected: [][]rune{{0x002C}, {0x1F1E6}}},                                                                                                                        // × [0.3] COMMA (IS) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u002C\u0020\U0001F1E6", expected: [][]rune{{0x002C, 0x0020}, {0x1F1E6}}},                                                                                                          // × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u002C\u0308\U0001F1E6", expected: [][]rune{{0x002C, 0x0308}, {0x1F1E6}}},                                                                                                          // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u002C\u0308\u0020\U0001F1E6", expected: [][]rune{{0x002C, 0x0308, 0x0020}, {0x1F1E6}}},                                                                                            // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u002C\u261D", expected: [][]rune{{0x002C}, {0x261D}}},                                                                                                                             // × [0.3] COMMA (IS) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u002C\u0020\u261D", expected: [][]rune{{0x002C, 0x0020}, {0x261D}}},                                                                                                               // × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u002C\u0308\u261D", expected: [][]rune{{0x002C, 0x0308}, {0x261D}}},                                                                                                               // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u002C\u0308\u0020\u261D", expected: [][]rune{{0x002C, 0x0308, 0x0020}, {0x261D}}},                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u002C\U0001F3FB", expected: [][]rune{{0x002C}, {0x1F3FB}}},                                                                                                                        // × [0.3] COMMA (IS) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u002C\u0020\U0001F3FB", expected: [][]rune{{0x002C, 0x0020}, {0x1F3FB}}},                                                                                                          // × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u002C\u0308\U0001F3FB", expected: [][]rune{{0x002C, 0x0308}, {0x1F3FB}}},                                                                                                          // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u002C\u0308\u0020\U0001F3FB", expected: [][]rune{{0x002C, 0x0308, 0x0020}, {0x1F3FB}}},                                                                                            // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u002C\u0029", expected: [][]rune{{0x002C, 0x0029}}},                                                                                                                               // × [0.3] COMMA (IS) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u002C\u0020\u0029", expected: [][]rune{{0x002C, 0x0020, 0x0029}}},                                                                                                                 // × [0.3] COMMA (IS) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u002C\u0308\u0029", expected: [][]rune{{0x002C, 0x0308, 0x0029}}},                                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u002C\u0308\u0020\u0029", expected: [][]rune{{0x002C, 0x0308, 0x0020, 0x0029}}},                                                                                                   // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u002C\u0028", expected: [][]rune{{0x002C}, {0x0028}}},                                                                                                                             // × [0.3] COMMA (IS) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u002C\u0020\u0028", expected: [][]rune{{0x002C, 0x0020}, {0x0028}}},                                                                                                               // × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u002C\u0308\u0028", expected: [][]rune{{0x002C, 0x0308}, {0x0028}}},                                                                                                               // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u002C\u0308\u0020\u0028", expected: [][]rune{{0x002C, 0x0308, 0x0020}, {0x0028}}},                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u002C\u0001", expected: [][]rune{{0x002C, 0x0001}}},                                                                                                                               // × [0.3] COMMA (IS) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u002C\u0020\u0001", expected: [][]rune{{0x002C, 0x0020}, {0x0001}}},                                                                                                               // × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u002C\u0308\u0001", expected: [][]rune{{0x002C, 0x0308, 0x0001}}},                                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u002C\u0308\u0020\u0001", expected: [][]rune{{0x002C, 0x0308, 0x0020}, {0x0001}}},                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u002C\u200D", expected: [][]rune{{0x002C, 0x200D}}},                                                                                                                               // × [0.3] COMMA (IS) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u002C\u0020\u200D", expected: [][]rune{{0x002C, 0x0020}, {0x200D}}},                                                                                                               // × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u002C\u0308\u200D", expected: [][]rune{{0x002C, 0x0308, 0x200D}}},                                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u002C\u0308\u0020\u200D", expected: [][]rune{{0x002C, 0x0308, 0x0020}, {0x200D}}},                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u002C\u00A7", expected: [][]rune{{0x002C, 0x00A7}}},                                                                                                                               // × [0.3] COMMA (IS) × [29.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u002C\u0020\u00A7", expected: [][]rune{{0x002C, 0x0020}, {0x00A7}}},                                                                                                               // × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u002C\u0308\u00A7", expected: [][]rune{{0x002C, 0x0308, 0x00A7}}},                                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [29.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u002C\u0308\u0020\u00A7", expected: [][]rune{{0x002C, 0x0308, 0x0020}, {0x00A7}}},                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u002C\U00050005", expected: [][]rune{{0x002C, 0x50005}}},                                                                                                                          // × [0.3] COMMA (IS) × [29.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u002C\u0020\U00050005", expected: [][]rune{{0x002C, 0x0020}, {0x50005}}},                                                                                                          // × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u002C\u0308\U00050005", expected: [][]rune{{0x002C, 0x0308, 0x50005}}},                                                                                                            // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [29.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u002C\u0308\u0020\U00050005", expected: [][]rune{{0x002C, 0x0308, 0x0020}, {0x50005}}},                                                                                            // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u002C\u0E01", expected: [][]rune{{0x002C, 0x0E01}}},                                                                                                                               // × [0.3] COMMA (IS) × [29.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u002C\u0020\u0E01", expected: [][]rune{{0x002C, 0x0020}, {0x0E01}}},                                                                                                               // × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u002C\u0308\u0E01", expected: [][]rune{{0x002C, 0x0308, 0x0E01}}},                                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [29.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u002C\u0308\u0020\u0E01", expected: [][]rune{{0x002C, 0x0308, 0x0020}, {0x0E01}}},                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u002C\u3041", expected: [][]rune{{0x002C, 0x3041}}},                                                                                                                               // × [0.3] COMMA (IS) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u002C\u0020\u3041", expected: [][]rune{{0x002C, 0x0020}, {0x3041}}},                                                                                                               // × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u002C\u0308\u3041", expected: [][]rune{{0x002C, 0x0308, 0x3041}}},                                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u002C\u0308\u0020\u3041", expected: [][]rune{{0x002C, 0x0308, 0x0020}, {0x3041}}},                                                                                                 // × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u1100\u0023", expected: [][]rune{{0x1100}, {0x0023}}},                                                                                                                             // × [0.3] HANGUL CHOSEONG KIYEOK (JL) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u1100\u0020\u0023", expected: [][]rune{{0x1100, 0x0020}, {0x0023}}},                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u1100\u0308\u0023", expected: [][]rune{{0x1100, 0x0308}, {0x0023}}},                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u1100\u0308\u0020\u0023", expected: [][]rune{{0x1100, 0x0308, 0x0020}, {0x0023}}},                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u1100\u2014", expected: [][]rune{{0x1100}, {0x2014}}},                                                                                                                             // × [0.3] HANGUL CHOSEONG KIYEOK (JL) ÷ [999.0] EM DASH (B2) ÷ [0.3]
	{original: "\u1100\u0020\u2014", expected: [][]rune{{0x1100, 0x0020}, {0x2014}}},                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
	{original: "\u1100\u0308\u2014", expected: [][]rune{{0x1100, 0x0308}, {0x2014}}},                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
	{original: "\u1100\u0308\u0020\u2014", expected: [][]rune{{0x1100, 0x0308, 0x0020}, {0x2014}}},                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
	{original: "\u1100\u0009", expected: [][]rune{{0x1100, 0x0009}}},                                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u1100\u0020\u0009", expected: [][]rune{{0x1100, 0x0020}, {0x0009}}},                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u1100\u0308\u0009", expected: [][]rune{{0x1100, 0x0308, 0x0009}}},                                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u1100\u0308\u0020\u0009", expected: [][]rune{{0x1100, 0x0308, 0x0020}, {0x0009}}},                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u1100\u00B4", expected: [][]rune{{0x1100}, {0x00B4}}},                                                                                                                             // × [0.3] HANGUL CHOSEONG KIYEOK (JL) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u1100\u0020\u00B4", expected: [][]rune{{0x1100, 0x0020}, {0x00B4}}},                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u1100\u0308\u00B4", expected: [][]rune{{0x1100, 0x0308}, {0x00B4}}},                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u1100\u0308\u0020\u00B4", expected: [][]rune{{0x1100, 0x0308, 0x0020}, {0x00B4}}},                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u1100\u000B", expected: [][]rune{{0x1100, 0x000B}}},                                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u1100\u0020\u000B", expected: [][]rune{{0x1100, 0x0020, 0x000B}}},                                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u1100\u0308\u000B", expected: [][]rune{{0x1100, 0x0308, 0x000B}}},                                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u1100\u0308\u0020\u000B", expected: [][]rune{{0x1100, 0x0308, 0x0020, 0x000B}}},                                                                                                   // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u1100\uFFFC", expected: [][]rune{{0x1100}, {0xFFFC}}},                                                                                                                             // × [0.3] HANGUL CHOSEONG KIYEOK (JL) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u1100\u0020\uFFFC", expected: [][]rune{{0x1100, 0x0020}, {0xFFFC}}},                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u1100\u0308\uFFFC", expected: [][]rune{{0x1100, 0x0308}, {0xFFFC}}},                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u1100\u0308\u0020\uFFFC", expected: [][]rune{{0x1100, 0x0308, 0x0020}, {0xFFFC}}},                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u1100\u007D", expected: [][]rune{{0x1100, 0x007D}}},                                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u1100\u0020\u007D", expected: [][]rune{{0x1100, 0x0020, 0x007D}}},                                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u1100\u0308\u007D", expected: [][]rune{{0x1100, 0x0308, 0x007D}}},                                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u1100\u0308\u0020\u007D", expected: [][]rune{{0x1100, 0x0308, 0x0020, 0x007D}}},                                                                                                   // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u1100\u000D", expected: [][]rune{{0x1100, 0x000D}}},                                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u1100\u0020\u000D", expected: [][]rune{{0x1100, 0x0020, 0x000D}}},                                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u1100\u0308\u000D", expected: [][]rune{{0x1100, 0x0308, 0x000D}}},                                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u1100\u0308\u0020\u000D", expected: [][]rune{{0x1100, 0x0308, 0x0020, 0x000D}}},                                                                                                   // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u1100\u0021", expected: [][]rune{{0x1100, 0x0021}}},                                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u1100\u0020\u0021", expected: [][]rune{{0x1100, 0x0020, 0x0021}}},                                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u1100\u0308\u0021", expected: [][]rune{{0x1100, 0x0308, 0x0021}}},                                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u1100\u0308\u0020\u0021", expected: [][]rune{{0x1100, 0x0308, 0x0020, 0x0021}}},                                                                                                   // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u1100\u00A0", expected: [][]rune{{0x1100, 0x00A0}}},                                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [12.1] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u1100\u0020\u00A0", expected: [][]rune{{0x1100, 0x0020}, {0x00A0}}},                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u1100\u0308\u00A0", expected: [][]rune{{0x1100, 0x0308, 0x00A0}}},                                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u1100\u0308\u0020\u00A0", expected: [][]rune{{0x1100, 0x0308, 0x0020}, {0x00A0}}},                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u1100\uAC00", expected: [][]rune{{0x1100, 0xAC00}}},                                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [26.01] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u1100\u0020\uAC00", expected: [][]rune{{0x1100, 0x0020}, {0xAC00}}},                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u1100\u0308\uAC00", expected: [][]rune{{0x1100, 0x0308, 0xAC00}}},                                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [26.01] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u1100\u0308\u0020\uAC00", expected: [][]rune{{0x1100, 0x0308, 0x0020}, {0xAC00}}},                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u1100\uAC01", expected: [][]rune{{0x1100, 0xAC01}}},                                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [26.01] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u1100\u0020\uAC01", expected: [][]rune{{0x1100, 0x0020}, {0xAC01}}},                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u1100\u0308\uAC01", expected: [][]rune{{0x1100, 0x0308, 0xAC01}}},                                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [26.01] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u1100\u0308\u0020\uAC01", expected: [][]rune{{0x1100, 0x0308, 0x0020}, {0xAC01}}},                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u1100\u05D0", expected: [][]rune{{0x1100}, {0x05D0}}},                                                                                                                             // × [0.3] HANGUL CHOSEONG KIYEOK (JL) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u1100\u0020\u05D0", expected: [][]rune{{0x1100, 0x0020}, {0x05D0}}},                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u1100\u0308\u05D0", expected: [][]rune{{0x1100, 0x0308}, {0x05D0}}},                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u1100\u0308\u0020\u05D0", expected: [][]rune{{0x1100, 0x0308, 0x0020}, {0x05D0}}},                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u1100\u002D", expected: [][]rune{{0x1100, 0x002D}}},                                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u1100\u0020\u002D", expected: [][]rune{{0x1100, 0x0020}, {0x002D}}},                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u1100\u0308\u002D", expected: [][]rune{{0x1100, 0x0308, 0x002D}}},                                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u1100\u0308\u0020\u002D", expected: [][]rune{{0x1100, 0x0308, 0x0020}, {0x002D}}},                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u1100\u231A", expected: [][]rune{{0x1100}, {0x231A}}},                                                                                                                             // × [0.3] HANGUL CHOSEONG KIYEOK (JL) ÷ [999.0] WATCH (ID) ÷ [0.3]
	{original: "\u1100\u0020\u231A", expected: [][]rune{{0x1100, 0x0020}, {0x231A}}},                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
	{original: "\u1100\u0308\u231A", expected: [][]rune{{0x1100, 0x0308}, {0x231A}}},                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
	{original: "\u1100\u0308\u0020\u231A", expected: [][]rune{{0x1100, 0x0308, 0x0020}, {0x231A}}},                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
	{original: "\u1100\u2024", expected: [][]rune{{0x1100, 0x2024}}},                                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u1100\u0020\u2024", expected: [][]rune{{0x1100, 0x0020}, {0x2024}}},                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u1100\u0308\u2024", expected: [][]rune{{0x1100, 0x0308, 0x2024}}},                                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u1100\u0308\u0020\u2024", expected: [][]rune{{0x1100, 0x0308, 0x0020}, {0x2024}}},                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u1100\u002C", expected: [][]rune{{0x1100, 0x002C}}},                                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u1100\u0020\u002C", expected: [][]rune{{0x1100, 0x0020, 0x002C}}},                                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u1100\u0308\u002C", expected: [][]rune{{0x1100, 0x0308, 0x002C}}},                                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
	{original: "\u1100\u0308\u0020\u002C", expected: [][]rune{{0x1100, 0x0308, 0x0020, 0x002C}}},                                                                                                   // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u1100\u1100", expected: [][]rune{{0x1100, 0x1100}}},                                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [26.01] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u1100\u0020\u1100", expected: [][]rune{{0x1100, 0x0020}, {0x1100}}},                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u1100\u0308\u1100", expected: [][]rune{{0x1100, 0x0308, 0x1100}}},                                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [26.01] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u1100\u0308\u0020\u1100", expected: [][]rune{{0x1100, 0x0308, 0x0020}, {0x1100}}},                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u1100\u11A8", expected: [][]rune{{0x1100}, {0x11A8}}},                                                                                                                             // × [0.3] HANGUL CHOSEONG KIYEOK (JL) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u1100\u0020\u11A8", expected: [][]rune{{0x1100, 0x0020}, {0x11A8}}},                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u1100\u0308\u11A8", expected: [][]rune{{0x1100, 0x0308}, {0x11A8}}},                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u1100\u0308\u0020\u11A8", expected: [][]rune{{0x1100, 0x0308, 0x0020}, {0x11A8}}},                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u1100\u1160", expected: [][]rune{{0x1100, 0x1160}}},                                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [26.01] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u1100\u0020\u1160", expected: [][]rune{{0x1100, 0x0020}, {0x1160}}},                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u1100\u0308\u1160", expected: [][]rune{{0x1100, 0x0308, 0x1160}}},                                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [26.01] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u1100\u0308\u0020\u1160", expected: [][]rune{{0x1100, 0x0308, 0x0020}, {0x1160}}},                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u1100\u000A", expected: [][]rune{{0x1100, 0x000A}}},                                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u1100\u0020\u000A", expected: [][]rune{{0x1100, 0x0020, 0x000A}}},                                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u1100\u0308\u000A", expected: [][]rune{{0x1100, 0x0308, 0x000A}}},                                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u1100\u0308\u0020\u000A", expected: [][]rune{{0x1100, 0x0308, 0x0020, 0x000A}}},                                                                                                   // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u1100\u0085", expected: [][]rune{{0x1100, 0x0085}}},                                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u1100\u0020\u0085", expected: [][]rune{{0x1100, 0x0020, 0x0085}}},                                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u1100\u0308\u0085", expected: [][]rune{{0x1100, 0x0308, 0x0085}}},                                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u1100\u0308\u0020\u0085", expected: [][]rune{{0x1100, 0x0308, 0x0020, 0x0085}}},                                                                                                   // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u1100\u17D6", expected: [][]rune{{0x1100, 0x17D6}}},                                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u1100\u0020\u17D6", expected: [][]rune{{0x1100, 0x0020}, {0x17D6}}},                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u1100\u0308\u17D6", expected: [][]rune{{0x1100, 0x0308, 0x17D6}}},                                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u1100\u0308\u0020\u17D6", expected: [][]rune{{0x1100, 0x0308, 0x0020}, {0x17D6}}},                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u1100\u0030", expected: [][]rune{{0x1100}, {0x0030}}},                                                                                                                             // × [0.3] HANGUL CHOSEONG KIYEOK (JL) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u1100\u0020\u0030", expected: [][]rune{{0x1100, 0x0020}, {0x0030}}},                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u1100\u0308\u0030", expected: [][]rune{{0x1100, 0x0308}, {0x0030}}},                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u1100\u0308\u0020\u0030", expected: [][]rune{{0x1100, 0x0308, 0x0020}, {0x0030}}},                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u1100\u2329", expected: [][]rune{{0x1100}, {0x2329}}},                                                                                                                             // × [0.3] HANGUL CHOSEONG KIYEOK (JL) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u1100\u0020\u2329", expected: [][]rune{{0x1100, 0x0020}, {0x2329}}},                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u1100\u0308\u2329", expected: [][]rune{{0x1100, 0x0308}, {0x2329}}},                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u1100\u0308\u0020\u2329", expected: [][]rune{{0x1100, 0x0308, 0x0020}, {0x2329}}},                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u1100\u0025", expected: [][]rune{{0x1100, 0x0025}}},                                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [27.01] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u1100\u0020\u0025", expected: [][]rune{{0x1100, 0x0020}, {0x0025}}},                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u1100\u0308\u0025", expected: [][]rune{{0x1100, 0x0308, 0x0025}}},                                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [27.01] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u1100\u0308\u0020\u0025", expected: [][]rune{{0x1100, 0x0308, 0x0020}, {0x0025}}},                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u1100\u0024", expected: [][]rune{{0x1100}, {0x0024}}},                                                                                                                             // × [0.3] HANGUL CHOSEONG KIYEOK (JL) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u1100\u0020\u0024", expected: [][]rune{{0x1100, 0x0020}, {0x0024}}},                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u1100\u0308\u0024", expected: [][]rune{{0x1100, 0x0308}, {0x0024}}},                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u1100\u0308\u0020\u0024", expected: [][]rune{{0x1100, 0x0308, 0x0020}, {0x0024}}},                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u1100\u0022", expected: [][]rune{{0x1100, 0x0022}}},                                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u1100\u0020\u0022", expected: [][]rune{{0x1100, 0x0020}, {0x0022}}},                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u1100\u0308\u0022", expected: [][]rune{{0x1100, 0x0308, 0x0022}}},                                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u1100\u0308\u0020\u0022", expected: [][]rune{{0x1100, 0x0308, 0x0020}, {0x0022}}},                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u1100\u0020", expected: [][]rune{{0x1100, 0x0020}}},                                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u1100\u0020\u0020", expected: [][]rune{{0x1100, 0x0020, 0x0020}}},                                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u1100\u0308\u0020", expected: [][]rune{{0x1100, 0x0308, 0x0020}}},                                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u1100\u0308\u0020\u0020", expected: [][]rune{{0x1100, 0x0308, 0x0020, 0x0020}}},                                                                                                   // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u1100\u002F", expected: [][]rune{{0x1100, 0x002F}}},                                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\u1100\u0020\u002F", expected: [][]rune{{0x1100, 0x0020, 0x002F}}},                                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\u1100\u0308\u002F", expected: [][]rune{{0x1100, 0x0308, 0x002F}}},                                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
	{original: "\u1100\u0308\u0020\u002F", expected: [][]rune{{0x1100, 0x0308, 0x0020, 0x002F}}},                                                                                                   // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\u1100\u2060", expected: [][]rune{{0x1100, 0x2060}}},                                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u1100\u0020\u2060", expected: [][]rune{{0x1100, 0x0020, 0x2060}}},                                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u1100\u0308\u2060", expected: [][]rune{{0x1100, 0x0308, 0x2060}}},                                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u1100\u0308\u0020\u2060", expected: [][]rune{{0x1100, 0x0308, 0x0020, 0x2060}}},                                                                                                   // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u1100\u200B", expected: [][]rune{{0x1100, 0x200B}}},                                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u1100\u0020\u200B", expected: [][]rune{{0x1100, 0x0020, 0x200B}}},                                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u1100\u0308\u200B", expected: [][]rune{{0x1100, 0x0308, 0x200B}}},                                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u1100\u0308\u0020\u200B", expected: [][]rune{{0x1100, 0x0308, 0x0020, 0x200B}}},                                                                                                   // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u1100\U0001F1E6", expected: [][]rune{{0x1100}, {0x1F1E6}}},                                                                                                                        // × [0.3] HANGUL CHOSEONG KIYEOK (JL) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u1100\u0020\U0001F1E6", expected: [][]rune{{0x1100, 0x0020}, {0x1F1E6}}},                                                                                                          // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u1100\u0308\U0001F1E6", expected: [][]rune{{0x1100, 0x0308}, {0x1F1E6}}},                                                                                                          // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u1100\u0308\u0020\U0001F1E6", expected: [][]rune{{0x1100, 0x0308, 0x0020}, {0x1F1E6}}},                                                                                            // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u1100\u261D", expected: [][]rune{{0x1100}, {0x261D}}},                                                                                                                             // × [0.3] HANGUL CHOSEONG KIYEOK (JL) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u1100\u0020\u261D", expected: [][]rune{{0x1100, 0x0020}, {0x261D}}},                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u1100\u0308\u261D", expected: [][]rune{{0x1100, 0x0308}, {0x261D}}},                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u1100\u0308\u0020\u261D", expected: [][]rune{{0x1100, 0x0308, 0x0020}, {0x261D}}},                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u1100\U0001F3FB", expected: [][]rune{{0x1100}, {0x1F3FB}}},                                                                                                                        // × [0.3] HANGUL CHOSEONG KIYEOK (JL) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u1100\u0020\U0001F3FB", expected: [][]rune{{0x1100, 0x0020}, {0x1F3FB}}},                                                                                                          // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u1100\u0308\U0001F3FB", expected: [][]rune{{0x1100, 0x0308}, {0x1F3FB}}},                                                                                                          // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u1100\u0308\u0020\U0001F3FB", expected: [][]rune{{0x1100, 0x0308, 0x0020}, {0x1F3FB}}},                                                                                            // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u1100\u0029", expected: [][]rune{{0x1100, 0x0029}}},                                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u1100\u0020\u0029", expected: [][]rune{{0x1100, 0x0020, 0x0029}}},                                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u1100\u0308\u0029", expected: [][]rune{{0x1100, 0x0308, 0x0029}}},                                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u1100\u0308\u0020\u0029", expected: [][]rune{{0x1100, 0x0308, 0x0020, 0x0029}}},                                                                                                   // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u1100\u0028", expected: [][]rune{{0x1100}, {0x0028}}},                                                                                                                             // × [0.3] HANGUL CHOSEONG KIYEOK (JL) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u1100\u0020\u0028", expected: [][]rune{{0x1100, 0x0020}, {0x0028}}},                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u1100\u0308\u0028", expected: [][]rune{{0x1100, 0x0308}, {0x0028}}},                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u1100\u0308\u0020\u0028", expected: [][]rune{{0x1100, 0x0308, 0x0020}, {0x0028}}},                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u1100\u0001", expected: [][]rune{{0x1100, 0x0001}}},                                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u1100\u0020\u0001", expected: [][]rune{{0x1100, 0x0020}, {0x0001}}},                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u1100\u0308\u0001", expected: [][]rune{{0x1100, 0x0308, 0x0001}}},                                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u1100\u0308\u0020\u0001", expected: [][]rune{{0x1100, 0x0308, 0x0020}, {0x0001}}},                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u1100\u200D", expected: [][]rune{{0x1100, 0x200D}}},                                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u1100\u0020\u200D", expected: [][]rune{{0x1100, 0x0020}, {0x200D}}},                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u1100\u0308\u200D", expected: [][]rune{{0x1100, 0x0308, 0x200D}}},                                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u1100\u0308\u0020\u200D", expected: [][]rune{{0x1100, 0x0308, 0x0020}, {0x200D}}},                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u1100\u00A7", expected: [][]rune{{0x1100}, {0x00A7}}},                                                                                                                             // × [0.3] HANGUL CHOSEONG KIYEOK (JL) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u1100\u0020\u00A7", expected: [][]rune{{0x1100, 0x0020}, {0x00A7}}},                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u1100\u0308\u00A7", expected: [][]rune{{0x1100, 0x0308}, {0x00A7}}},                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u1100\u0308\u0020\u00A7", expected: [][]rune{{0x1100, 0x0308, 0x0020}, {0x00A7}}},                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u1100\U00050005", expected: [][]rune{{0x1100}, {0x50005}}},                                                                                                                        // × [0.3] HANGUL CHOSEONG KIYEOK (JL) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u1100\u0020\U00050005", expected: [][]rune{{0x1100, 0x0020}, {0x50005}}},                                                                                                          // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u1100\u0308\U00050005", expected: [][]rune{{0x1100, 0x0308}, {0x50005}}},                                                                                                          // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u1100\u0308\u0020\U00050005", expected: [][]rune{{0x1100, 0x0308, 0x0020}, {0x50005}}},                                                                                            // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u1100\u0E01", expected: [][]rune{{0x1100}, {0x0E01}}},                                                                                                                             // × [0.3] HANGUL CHOSEONG KIYEOK (JL) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u1100\u0020\u0E01", expected: [][]rune{{0x1100, 0x0020}, {0x0E01}}},                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u1100\u0308\u0E01", expected: [][]rune{{0x1100, 0x0308}, {0x0E01}}},                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u1100\u0308\u0020\u0E01", expected: [][]rune{{0x1100, 0x0308, 0x0020}, {0x0E01}}},                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u1100\u3041", expected: [][]rune{{0x1100, 0x3041}}},                                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u1100\u0020\u3041", expected: [][]rune{{0x1100, 0x0020}, {0x3041}}},                                                                                                               // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u1100\u0308\u3041", expected: [][]rune{{0x1100, 0x0308, 0x3041}}},                                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u1100\u0308\u0020\u3041", expected: [][]rune{{0x1100, 0x0308, 0x0020}, {0x3041}}},                                                                                                 // × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u11A8\u0023", expected: [][]rune{{0x11A8}, {0x0023}}},                                                                                                                             // × [0.3] HANGUL JONGSEONG KIYEOK (JT) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u11A8\u0020\u0023", expected: [][]rune{{0x11A8, 0x0020}, {0x0023}}},                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u11A8\u0308\u0023", expected: [][]rune{{0x11A8, 0x0308}, {0x0023}}},                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u11A8\u0308\u0020\u0023", expected: [][]rune{{0x11A8, 0x0308, 0x0020}, {0x0023}}},                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u11A8\u2014", expected: [][]rune{{0x11A8}, {0x2014}}},                                                                                                                             // × [0.3] HANGUL JONGSEONG KIYEOK (JT) ÷ [999.0] EM DASH (B2) ÷ [0.3]
	{original: "\u11A8\u0020\u2014", expected: [][]rune{{0x11A8, 0x0020}, {0x2014}}},                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
	{original: "\u11A8\u0308\u2014", expected: [][]rune{{0x11A8, 0x0308}, {0x2014}}},                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
	{original: "\u11A8\u0308\u0020\u2014", expected: [][]rune{{0x11A8, 0x0308, 0x0020}, {0x2014}}},                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
	{original: "\u11A8\u0009", expected: [][]rune{{0x11A8, 0x0009}}},                                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u11A8\u0020\u0009", expected: [][]rune{{0x11A8, 0x0020}, {0x0009}}},                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u11A8\u0308\u0009", expected: [][]rune{{0x11A8, 0x0308, 0x0009}}},                                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u11A8\u0308\u0020\u0009", expected: [][]rune{{0x11A8, 0x0308, 0x0020}, {0x0009}}},                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u11A8\u00B4", expected: [][]rune{{0x11A8}, {0x00B4}}},                                                                                                                             // × [0.3] HANGUL JONGSEONG KIYEOK (JT) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u11A8\u0020\u00B4", expected: [][]rune{{0x11A8, 0x0020}, {0x00B4}}},                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u11A8\u0308\u00B4", expected: [][]rune{{0x11A8, 0x0308}, {0x00B4}}},                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u11A8\u0308\u0020\u00B4", expected: [][]rune{{0x11A8, 0x0308, 0x0020}, {0x00B4}}},                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u11A8\u000B", expected: [][]rune{{0x11A8, 0x000B}}},                                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u11A8\u0020\u000B", expected: [][]rune{{0x11A8, 0x0020, 0x000B}}},                                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u11A8\u0308\u000B", expected: [][]rune{{0x11A8, 0x0308, 0x000B}}},                                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u11A8\u0308\u0020\u000B", expected: [][]rune{{0x11A8, 0x0308, 0x0020, 0x000B}}},                                                                                                   // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u11A8\uFFFC", expected: [][]rune{{0x11A8}, {0xFFFC}}},                                                                                                                             // × [0.3] HANGUL JONGSEONG KIYEOK (JT) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u11A8\u0020\uFFFC", expected: [][]rune{{0x11A8, 0x0020}, {0xFFFC}}},                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u11A8\u0308\uFFFC", expected: [][]rune{{0x11A8, 0x0308}, {0xFFFC}}},                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u11A8\u0308\u0020\uFFFC", expected: [][]rune{{0x11A8, 0x0308, 0x0020}, {0xFFFC}}},                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u11A8\u007D", expected: [][]rune{{0x11A8, 0x007D}}},                                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u11A8\u0020\u007D", expected: [][]rune{{0x11A8, 0x0020, 0x007D}}},                                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u11A8\u0308\u007D", expected: [][]rune{{0x11A8, 0x0308, 0x007D}}},                                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u11A8\u0308\u0020\u007D", expected: [][]rune{{0x11A8, 0x0308, 0x0020, 0x007D}}},                                                                                                   // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u11A8\u000D", expected: [][]rune{{0x11A8, 0x000D}}},                                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u11A8\u0020\u000D", expected: [][]rune{{0x11A8, 0x0020, 0x000D}}},                                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u11A8\u0308\u000D", expected: [][]rune{{0x11A8, 0x0308, 0x000D}}},                                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u11A8\u0308\u0020\u000D", expected: [][]rune{{0x11A8, 0x0308, 0x0020, 0x000D}}},                                                                                                   // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u11A8\u0021", expected: [][]rune{{0x11A8, 0x0021}}},                                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u11A8\u0020\u0021", expected: [][]rune{{0x11A8, 0x0020, 0x0021}}},                                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u11A8\u0308\u0021", expected: [][]rune{{0x11A8, 0x0308, 0x0021}}},                                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u11A8\u0308\u0020\u0021", expected: [][]rune{{0x11A8, 0x0308, 0x0020, 0x0021}}},                                                                                                   // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u11A8\u00A0", expected: [][]rune{{0x11A8, 0x00A0}}},                                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [12.1] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u11A8\u0020\u00A0", expected: [][]rune{{0x11A8, 0x0020}, {0x00A0}}},                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u11A8\u0308\u00A0", expected: [][]rune{{0x11A8, 0x0308, 0x00A0}}},                                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u11A8\u0308\u0020\u00A0", expected: [][]rune{{0x11A8, 0x0308, 0x0020}, {0x00A0}}},                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u11A8\uAC00", expected: [][]rune{{0x11A8}, {0xAC00}}},                                                                                                                             // × [0.3] HANGUL JONGSEONG KIYEOK (JT) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u11A8\u0020\uAC00", expected: [][]rune{{0x11A8, 0x0020}, {0xAC00}}},                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u11A8\u0308\uAC00", expected: [][]rune{{0x11A8, 0x0308}, {0xAC00}}},                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u11A8\u0308\u0020\uAC00", expected: [][]rune{{0x11A8, 0x0308, 0x0020}, {0xAC00}}},                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u11A8\uAC01", expected: [][]rune{{0x11A8}, {0xAC01}}},                                                                                                                             // × [0.3] HANGUL JONGSEONG KIYEOK (JT) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u11A8\u0020\uAC01", expected: [][]rune{{0x11A8, 0x0020}, {0xAC01}}},                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u11A8\u0308\uAC01", expected: [][]rune{{0x11A8, 0x0308}, {0xAC01}}},                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u11A8\u0308\u0020\uAC01", expected: [][]rune{{0x11A8, 0x0308, 0x0020}, {0xAC01}}},                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u11A8\u05D0", expected: [][]rune{{0x11A8}, {0x05D0}}},                                                                                                                             // × [0.3] HANGUL JONGSEONG KIYEOK (JT) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u11A8\u0020\u05D0", expected: [][]rune{{0x11A8, 0x0020}, {0x05D0}}},                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u11A8\u0308\u05D0", expected: [][]rune{{0x11A8, 0x0308}, {0x05D0}}},                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u11A8\u0308\u0020\u05D0", expected: [][]rune{{0x11A8, 0x0308, 0x0020}, {0x05D0}}},                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u11A8\u002D", expected: [][]rune{{0x11A8, 0x002D}}},                                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u11A8\u0020\u002D", expected: [][]rune{{0x11A8, 0x0020}, {0x002D}}},                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u11A8\u0308\u002D", expected: [][]rune{{0x11A8, 0x0308, 0x002D}}},                                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u11A8\u0308\u0020\u002D", expected: [][]rune{{0x11A8, 0x0308, 0x0020}, {0x002D}}},                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u11A8\u231A", expected: [][]rune{{0x11A8}, {0x231A}}},                                                                                                                             // × [0.3] HANGUL JONGSEONG KIYEOK (JT) ÷ [999.0] WATCH (ID) ÷ [0.3]
	{original: "\u11A8\u0020\u231A", expected: [][]rune{{0x11A8, 0x0020}, {0x231A}}},                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
	{original: "\u11A8\u0308\u231A", expected: [][]rune{{0x11A8, 0x0308}, {0x231A}}},                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
	{original: "\u11A8\u0308\u0020\u231A", expected: [][]rune{{0x11A8, 0x0308, 0x0020}, {0x231A}}},                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
	{original: "\u11A8\u2024", expected: [][]rune{{0x11A8, 0x2024}}},                                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u11A8\u0020\u2024", expected: [][]rune{{0x11A8, 0x0020}, {0x2024}}},                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u11A8\u0308\u2024", expected: [][]rune{{0x11A8, 0x0308, 0x2024}}},                                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u11A8\u0308\u0020\u2024", expected: [][]rune{{0x11A8, 0x0308, 0x0020}, {0x2024}}},                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u11A8\u002C", expected: [][]rune{{0x11A8, 0x002C}}},                                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u11A8\u0020\u002C", expected: [][]rune{{0x11A8, 0x0020, 0x002C}}},                                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u11A8\u0308\u002C", expected: [][]rune{{0x11A8, 0x0308, 0x002C}}},                                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
	{original: "\u11A8\u0308\u0020\u002C", expected: [][]rune{{0x11A8, 0x0308, 0x0020, 0x002C}}},                                                                                                   // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u11A8\u1100", expected: [][]rune{{0x11A8}, {0x1100}}},                                                                                                                             // × [0.3] HANGUL JONGSEONG KIYEOK (JT) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u11A8\u0020\u1100", expected: [][]rune{{0x11A8, 0x0020}, {0x1100}}},                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u11A8\u0308\u1100", expected: [][]rune{{0x11A8, 0x0308}, {0x1100}}},                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u11A8\u0308\u0020\u1100", expected: [][]rune{{0x11A8, 0x0308, 0x0020}, {0x1100}}},                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u11A8\u11A8", expected: [][]rune{{0x11A8, 0x11A8}}},                                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [26.03] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u11A8\u0020\u11A8", expected: [][]rune{{0x11A8, 0x0020}, {0x11A8}}},                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u11A8\u0308\u11A8", expected: [][]rune{{0x11A8, 0x0308, 0x11A8}}},                                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [26.03] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u11A8\u0308\u0020\u11A8", expected: [][]rune{{0x11A8, 0x0308, 0x0020}, {0x11A8}}},                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u11A8\u1160", expected: [][]rune{{0x11A8}, {0x1160}}},                                                                                                                             // × [0.3] HANGUL JONGSEONG KIYEOK (JT) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u11A8\u0020\u1160", expected: [][]rune{{0x11A8, 0x0020}, {0x1160}}},                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u11A8\u0308\u1160", expected: [][]rune{{0x11A8, 0x0308}, {0x1160}}},                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u11A8\u0308\u0020\u1160", expected: [][]rune{{0x11A8, 0x0308, 0x0020}, {0x1160}}},                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u11A8\u000A", expected: [][]rune{{0x11A8, 0x000A}}},                                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u11A8\u0020\u000A", expected: [][]rune{{0x11A8, 0x0020, 0x000A}}},                                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u11A8\u0308\u000A", expected: [][]rune{{0x11A8, 0x0308, 0x000A}}},                                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u11A8\u0308\u0020\u000A", expected: [][]rune{{0x11A8, 0x0308, 0x0020, 0x000A}}},                                                                                                   // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u11A8\u0085", expected: [][]rune{{0x11A8, 0x0085}}},                                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u11A8\u0020\u0085", expected: [][]rune{{0x11A8, 0x0020, 0x0085}}},                                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u11A8\u0308\u0085", expected: [][]rune{{0x11A8, 0x0308, 0x0085}}},                                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u11A8\u0308\u0020\u0085", expected: [][]rune{{0x11A8, 0x0308, 0x0020, 0x0085}}},                                                                                                   // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u11A8\u17D6", expected: [][]rune{{0x11A8, 0x17D6}}},                                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u11A8\u0020\u17D6", expected: [][]rune{{0x11A8, 0x0020}, {0x17D6}}},                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u11A8\u0308\u17D6", expected: [][]rune{{0x11A8, 0x0308, 0x17D6}}},                                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u11A8\u0308\u0020\u17D6", expected: [][]rune{{0x11A8, 0x0308, 0x0020}, {0x17D6}}},                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u11A8\u0030", expected: [][]rune{{0x11A8}, {0x0030}}},                                                                                                                             // × [0.3] HANGUL JONGSEONG KIYEOK (JT) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u11A8\u0020\u0030", expected: [][]rune{{0x11A8, 0x0020}, {0x0030}}},                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u11A8\u0308\u0030", expected: [][]rune{{0x11A8, 0x0308}, {0x0030}}},                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u11A8\u0308\u0020\u0030", expected: [][]rune{{0x11A8, 0x0308, 0x0020}, {0x0030}}},                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u11A8\u2329", expected: [][]rune{{0x11A8}, {0x2329}}},                                                                                                                             // × [0.3] HANGUL JONGSEONG KIYEOK (JT) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u11A8\u0020\u2329", expected: [][]rune{{0x11A8, 0x0020}, {0x2329}}},                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u11A8\u0308\u2329", expected: [][]rune{{0x11A8, 0x0308}, {0x2329}}},                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u11A8\u0308\u0020\u2329", expected: [][]rune{{0x11A8, 0x0308, 0x0020}, {0x2329}}},                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u11A8\u0025", expected: [][]rune{{0x11A8, 0x0025}}},                                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [27.01] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u11A8\u0020\u0025", expected: [][]rune{{0x11A8, 0x0020}, {0x0025}}},                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u11A8\u0308\u0025", expected: [][]rune{{0x11A8, 0x0308, 0x0025}}},                                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [27.01] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u11A8\u0308\u0020\u0025", expected: [][]rune{{0x11A8, 0x0308, 0x0020}, {0x0025}}},                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u11A8\u0024", expected: [][]rune{{0x11A8}, {0x0024}}},                                                                                                                             // × [0.3] HANGUL JONGSEONG KIYEOK (JT) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u11A8\u0020\u0024", expected: [][]rune{{0x11A8, 0x0020}, {0x0024}}},                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u11A8\u0308\u0024", expected: [][]rune{{0x11A8, 0x0308}, {0x0024}}},                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u11A8\u0308\u0020\u0024", expected: [][]rune{{0x11A8, 0x0308, 0x0020}, {0x0024}}},                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u11A8\u0022", expected: [][]rune{{0x11A8, 0x0022}}},                                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u11A8\u0020\u0022", expected: [][]rune{{0x11A8, 0x0020}, {0x0022}}},                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u11A8\u0308\u0022", expected: [][]rune{{0x11A8, 0x0308, 0x0022}}},                                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u11A8\u0308\u0020\u0022", expected: [][]rune{{0x11A8, 0x0308, 0x0020}, {0x0022}}},                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u11A8\u0020", expected: [][]rune{{0x11A8, 0x0020}}},                                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u11A8\u0020\u0020", expected: [][]rune{{0x11A8, 0x0020, 0x0020}}},                                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u11A8\u0308\u0020", expected: [][]rune{{0x11A8, 0x0308, 0x0020}}},                                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u11A8\u0308\u0020\u0020", expected: [][]rune{{0x11A8, 0x0308, 0x0020, 0x0020}}},                                                                                                   // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
	{original: "\u11A8\u002F", expected: [][]rune{{0x11A8, 0x002F}}},                                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\u11A8\u0020\u002F", expected: [][]rune{{0x11A8, 0x0020, 0x002F}}},                                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\u11A8\u0308\u002F", expected: [][]rune{{0x11A8, 0x0308, 0x002F}}},                                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
	{original: "\u11A8\u0308\u0020\u002F", expected: [][]rune{{0x11A8, 0x0308, 0x0020, 0x002F}}},                                                                                                   // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
	{original: "\u11A8\u2060", expected: [][]rune{{0x11A8, 0x2060}}},                                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u11A8\u0020\u2060", expected: [][]rune{{0x11A8, 0x0020, 0x2060}}},                                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u11A8\u0308\u2060", expected: [][]rune{{0x11A8, 0x0308, 0x2060}}},                                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u11A8\u0308\u0020\u2060", expected: [][]rune{{0x11A8, 0x0308, 0x0020, 0x2060}}},                                                                                                   // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
	{original: "\u11A8\u200B", expected: [][]rune{{0x11A8, 0x200B}}},                                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u11A8\u0020\u200B", expected: [][]rune{{0x11A8, 0x0020, 0x200B}}},                                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u11A8\u0308\u200B", expected: [][]rune{{0x11A8, 0x0308, 0x200B}}},                                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u11A8\u0308\u0020\u200B", expected: [][]rune{{0x11A8, 0x0308, 0x0020, 0x200B}}},                                                                                                   // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
	{original: "\u11A8\U0001F1E6", expected: [][]rune{{0x11A8}, {0x1F1E6}}},                                                                                                                        // × [0.3] HANGUL JONGSEONG KIYEOK (JT) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u11A8\u0020\U0001F1E6", expected: [][]rune{{0x11A8, 0x0020}, {0x1F1E6}}},                                                                                                          // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u11A8\u0308\U0001F1E6", expected: [][]rune{{0x11A8, 0x0308}, {0x1F1E6}}},                                                                                                          // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u11A8\u0308\u0020\U0001F1E6", expected: [][]rune{{0x11A8, 0x0308, 0x0020}, {0x1F1E6}}},                                                                                            // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u11A8\u261D", expected: [][]rune{{0x11A8}, {0x261D}}},                                                                                                                             // × [0.3] HANGUL JONGSEONG KIYEOK (JT) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u11A8\u0020\u261D", expected: [][]rune{{0x11A8, 0x0020}, {0x261D}}},                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u11A8\u0308\u261D", expected: [][]rune{{0x11A8, 0x0308}, {0x261D}}},                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u11A8\u0308\u0020\u261D", expected: [][]rune{{0x11A8, 0x0308, 0x0020}, {0x261D}}},                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
	{original: "\u11A8\U0001F3FB", expected: [][]rune{{0x11A8}, {0x1F3FB}}},                                                                                                                        // × [0.3] HANGUL JONGSEONG KIYEOK (JT) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u11A8\u0020\U0001F3FB", expected: [][]rune{{0x11A8, 0x0020}, {0x1F3FB}}},                                                                                                          // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u11A8\u0308\U0001F3FB", expected: [][]rune{{0x11A8, 0x0308}, {0x1F3FB}}},                                                                                                          // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u11A8\u0308\u0020\U0001F3FB", expected: [][]rune{{0x11A8, 0x0308, 0x0020}, {0x1F3FB}}},                                                                                            // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
	{original: "\u11A8\u0029", expected: [][]rune{{0x11A8, 0x0029}}},                                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u11A8\u0020\u0029", expected: [][]rune{{0x11A8, 0x0020, 0x0029}}},                                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u11A8\u0308\u0029", expected: [][]rune{{0x11A8, 0x0308, 0x0029}}},                                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u11A8\u0308\u0020\u0029", expected: [][]rune{{0x11A8, 0x0308, 0x0020, 0x0029}}},                                                                                                   // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
	{original: "\u11A8\u0028", expected: [][]rune{{0x11A8}, {0x0028}}},                                                                                                                             // × [0.3] HANGUL JONGSEONG KIYEOK (JT) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u11A8\u0020\u0028", expected: [][]rune{{0x11A8, 0x0020}, {0x0028}}},                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u11A8\u0308\u0028", expected: [][]rune{{0x11A8, 0x0308}, {0x0028}}},                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u11A8\u0308\u0020\u0028", expected: [][]rune{{0x11A8, 0x0308, 0x0020}, {0x0028}}},                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
	{original: "\u11A8\u0001", expected: [][]rune{{0x11A8, 0x0001}}},                                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u11A8\u0020\u0001", expected: [][]rune{{0x11A8, 0x0020}, {0x0001}}},                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u11A8\u0308\u0001", expected: [][]rune{{0x11A8, 0x0308, 0x0001}}},                                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u11A8\u0308\u0020\u0001", expected: [][]rune{{0x11A8, 0x0308, 0x0020}, {0x0001}}},                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
	{original: "\u11A8\u200D", expected: [][]rune{{0x11A8, 0x200D}}},                                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u11A8\u0020\u200D", expected: [][]rune{{0x11A8, 0x0020}, {0x200D}}},                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u11A8\u0308\u200D", expected: [][]rune{{0x11A8, 0x0308, 0x200D}}},                                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u11A8\u0308\u0020\u200D", expected: [][]rune{{0x11A8, 0x0308, 0x0020}, {0x200D}}},                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
	{original: "\u11A8\u00A7", expected: [][]rune{{0x11A8}, {0x00A7}}},                                                                                                                             // × [0.3] HANGUL JONGSEONG KIYEOK (JT) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u11A8\u0020\u00A7", expected: [][]rune{{0x11A8, 0x0020}, {0x00A7}}},                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u11A8\u0308\u00A7", expected: [][]rune{{0x11A8, 0x0308}, {0x00A7}}},                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u11A8\u0308\u0020\u00A7", expected: [][]rune{{0x11A8, 0x0308, 0x0020}, {0x00A7}}},                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
	{original: "\u11A8\U00050005", expected: [][]rune{{0x11A8}, {0x50005}}},                                                                                                                        // × [0.3] HANGUL JONGSEONG KIYEOK (JT) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u11A8\u0020\U00050005", expected: [][]rune{{0x11A8, 0x0020}, {0x50005}}},                                                                                                          // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u11A8\u0308\U00050005", expected: [][]rune{{0x11A8, 0x0308}, {0x50005}}},                                                                                                          // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u11A8\u0308\u0020\U00050005", expected: [][]rune{{0x11A8, 0x0308, 0x0020}, {0x50005}}},                                                                                            // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
	{original: "\u11A8\u0E01", expected: [][]rune{{0x11A8}, {0x0E01}}},                                                                                                                             // × [0.3] HANGUL JONGSEONG KIYEOK (JT) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u11A8\u0020\u0E01", expected: [][]rune{{0x11A8, 0x0020}, {0x0E01}}},                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u11A8\u0308\u0E01", expected: [][]rune{{0x11A8, 0x0308}, {0x0E01}}},                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u11A8\u0308\u0020\u0E01", expected: [][]rune{{0x11A8, 0x0308, 0x0020}, {0x0E01}}},                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
	{original: "\u11A8\u3041", expected: [][]rune{{0x11A8, 0x3041}}},                                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u11A8\u0020\u3041", expected: [][]rune{{0x11A8, 0x0020}, {0x3041}}},                                                                                                               // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u11A8\u0308\u3041", expected: [][]rune{{0x11A8, 0x0308, 0x3041}}},                                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u11A8\u0308\u0020\u3041", expected: [][]rune{{0x11A8, 0x0308, 0x0020}, {0x3041}}},                                                                                                 // × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
	{original: "\u1160\u0023", expected: [][]rune{{0x1160}, {0x0023}}},                                                                                                                             // × [0.3] HANGUL JUNGSEONG FILLER (JV) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u1160\u0020\u0023", expected: [][]rune{{0x1160, 0x0020}, {0x0023}}},                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u1160\u0308\u0023", expected: [][]rune{{0x1160, 0x0308}, {0x0023}}},                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u1160\u0308\u0020\u0023", expected: [][]rune{{0x1160, 0x0308, 0x0020}, {0x0023}}},                                                                                                 // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
	{original: "\u1160\u2014", expected: [][]rune{{0x1160}, {0x2014}}},                                                                                                                             // × [0.3] HANGUL JUNGSEONG FILLER (JV) ÷ [999.0] EM DASH (B2) ÷ [0.3]
	{original: "\u1160\u0020\u2014", expected: [][]rune{{0x1160, 0x0020}, {0x2014}}},                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
	{original: "\u1160\u0308\u2014", expected: [][]rune{{0x1160, 0x0308}, {0x2014}}},                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
	{original: "\u1160\u0308\u0020\u2014", expected: [][]rune{{0x1160, 0x0308, 0x0020}, {0x2014}}},                                                                                                 // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
	{original: "\u1160\u0009", expected: [][]rune{{0x1160, 0x0009}}},                                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u1160\u0020\u0009", expected: [][]rune{{0x1160, 0x0020}, {0x0009}}},                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u1160\u0308\u0009", expected: [][]rune{{0x1160, 0x0308, 0x0009}}},                                                                                                                 // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u1160\u0308\u0020\u0009", expected: [][]rune{{0x1160, 0x0308, 0x0020}, {0x0009}}},                                                                                                 // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
	{original: "\u1160\u00B4", expected: [][]rune{{0x1160}, {0x00B4}}},                                                                                                                             // × [0.3] HANGUL JUNGSEONG FILLER (JV) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u1160\u0020\u00B4", expected: [][]rune{{0x1160, 0x0020}, {0x00B4}}},                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u1160\u0308\u00B4", expected: [][]rune{{0x1160, 0x0308}, {0x00B4}}},                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u1160\u0308\u0020\u00B4", expected: [][]rune{{0x1160, 0x0308, 0x0020}, {0x00B4}}},                                                                                                 // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
	{original: "\u1160\u000B", expected: [][]rune{{0x1160, 0x000B}}},                                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u1160\u0020\u000B", expected: [][]rune{{0x1160, 0x0020, 0x000B}}},                                                                                                                 // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u1160\u0308\u000B", expected: [][]rune{{0x1160, 0x0308, 0x000B}}},                                                                                                                 // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u1160\u0308\u0020\u000B", expected: [][]rune{{0x1160, 0x0308, 0x0020, 0x000B}}},                                                                                                   // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
	{original: "\u1160\uFFFC", expected: [][]rune{{0x1160}, {0xFFFC}}},                                                                                                                             // × [0.3] HANGUL JUNGSEONG FILLER (JV) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u1160\u0020\uFFFC", expected: [][]rune{{0x1160, 0x0020}, {0xFFFC}}},                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u1160\u0308\uFFFC", expected: [][]rune{{0x1160, 0x0308}, {0xFFFC}}},                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u1160\u0308\u0020\uFFFC", expected: [][]rune{{0x1160, 0x0308, 0x0020}, {0xFFFC}}},                                                                                                 // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
	{original: "\u1160\u007D", expected: [][]rune{{0x1160, 0x007D}}},                                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u1160\u0020\u007D", expected: [][]rune{{0x1160, 0x0020, 0x007D}}},                                                                                                                 // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u1160\u0308\u007D", expected: [][]rune{{0x1160, 0x0308, 0x007D}}},                                                                                                                 // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u1160\u0308\u0020\u007D", expected: [][]rune{{0x1160, 0x0308, 0x0020, 0x007D}}},                                                                                                   // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
	{original: "\u1160\u000D", expected: [][]rune{{0x1160, 0x000D}}},                                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u1160\u0020\u000D", expected: [][]rune{{0x1160, 0x0020, 0x000D}}},                                                                                                                 // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u1160\u0308\u000D", expected: [][]rune{{0x1160, 0x0308, 0x000D}}},                                                                                                                 // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u1160\u0308\u0020\u000D", expected: [][]rune{{0x1160, 0x0308, 0x0020, 0x000D}}},                                                                                                   // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u1160\u0021", expected: [][]rune{{0x1160, 0x0021}}},                                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u1160\u0020\u0021", expected: [][]rune{{0x1160, 0x0020, 0x0021}}},                                                                                                                 // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u1160\u0308\u0021", expected: [][]rune{{0x1160, 0x0308, 0x0021}}},                                                                                                                 // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u1160\u0308\u0020\u0021", expected: [][]rune{{0x1160, 0x0308, 0x0020, 0x0021}}},                                                                                                   // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
	{original: "\u1160\u00A0", expected: [][]rune{{0x1160, 0x00A0}}},                                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [12.1] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u1160\u0020\u00A0", expected: [][]rune{{0x1160, 0x0020}, {0x00A0}}},                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u1160\u0308\u00A0", expected: [][]rune{{0x1160, 0x0308, 0x00A0}}},                                                                                                                 // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u1160\u0308\u0020\u00A0", expected: [][]rune{{0x1160, 0x0308, 0x0020}, {0x00A0}}},                                                                                                 // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
	{original: "\u1160\uAC00", expected: [][]rune{{0x1160}, {0xAC00}}},                                                                                                                             // × [0.3] HANGUL JUNGSEONG FILLER (JV) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u1160\u0020\uAC00", expected: [][]rune{{0x1160, 0x0020}, {0xAC00}}},                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u1160\u0308\uAC00", expected: [][]rune{{0x1160, 0x0308}, {0xAC00}}},                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u1160\u0308\u0020\uAC00", expected: [][]rune{{0x1160, 0x0308, 0x0020}, {0xAC00}}},                                                                                                 // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
	{original: "\u1160\uAC01", expected: [][]rune{{0x1160}, {0xAC01}}},                                                                                                                             // × [0.3] HANGUL JUNGSEONG FILLER (JV) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u1160\u0020\uAC01", expected: [][]rune{{0x1160, 0x0020}, {0xAC01}}},                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u1160\u0308\uAC01", expected: [][]rune{{0x1160, 0x0308}, {0xAC01}}},                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u1160\u0308\u0020\uAC01", expected: [][]rune{{0x1160, 0x0308, 0x0020}, {0xAC01}}},                                                                                                 // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
	{original: "\u1160\u05D0", expected: [][]rune{{0x1160}, {0x05D0}}},                                                                                                                             // × [0.3] HANGUL JUNGSEONG FILLER (JV) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u1160\u0020\u05D0", expected: [][]rune{{0x1160, 0x0020}, {0x05D0}}},                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u1160\u0308\u05D0", expected: [][]rune{{0x1160, 0x0308}, {0x05D0}}},                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u1160\u0308\u0020\u05D0", expected: [][]rune{{0x1160, 0x0308, 0x0020}, {0x05D0}}},                                                                                                 // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
	{original: "\u1160\u002D", expected: [][]rune{{0x1160, 0x002D}}},                                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u1160\u0020\u002D", expected: [][]rune{{0x1160, 0x0020}, {0x002D}}},                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u1160\u0308\u002D", expected: [][]rune{{0x1160, 0x0308, 0x002D}}},                                                                                                                 // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u1160\u0308\u0020\u002D", expected: [][]rune{{0x1160, 0x0308, 0x0020}, {0x002D}}},                                                                                                 // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
	{original: "\u1160\u231A", expected: [][]rune{{0x1160}, {0x231A}}},                                                                                                                             // × [0.3] HANGUL JUNGSEONG FILLER (JV) ÷ [999.0] WATCH (ID) ÷ [0.3]
	{original: "\u1160\u0020\u231A", expected: [][]rune{{0x1160, 0x0020}, {0x231A}}},                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
	{original: "\u1160\u0308\u231A", expected: [][]rune{{0x1160, 0x0308}, {0x231A}}},                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
	{original: "\u1160\u0308\u0020\u231A", expected: [][]rune{{0x1160, 0x0308, 0x0020}, {0x231A}}},                                                                                                 // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
	{original: "\u1160\u2024", expected: [][]rune{{0x1160, 0x2024}}},                                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u1160\u0020\u2024", expected: [][]rune{{0x1160, 0x0020}, {0x2024}}},                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u1160\u0308\u2024", expected: [][]rune{{0x1160, 0x0308, 0x2024}}},                                                                                                                 // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u1160\u0308\u0020\u2024", expected: [][]rune{{0x1160, 0x0308, 0x0020}, {0x2024}}},                                                                                                 // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
	{original: "\u1160\u002C", expected: [][]rune{{0x1160, 0x002C}}},                                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u1160\u0020\u002C", expected: [][]rune{{0x1160, 0x0020, 0x002C}}},                                                                                                                 // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u1160\u0308\u002C", expected: [][]rune{{0x1160, 0x0308, 0x002C}}},                                                                                                                 // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
	{original: "\u1160\u0308\u0020\u002C", expected: [][]rune{{0x1160, 0x0308, 0x0020, 0x002C}}},                                                                                                   // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
	{original: "\u1160\u1100", expected: [][]rune{{0x1160}, {0x1100}}},                                                                                                                             // × [0.3] HANGUL JUNGSEONG FILLER (JV) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u1160\u0020\u1100", expected: [][]rune{{0x1160, 0x0020}, {0x1100}}},                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u1160\u0308\u1100", expected: [][]rune{{0x1160, 0x0308}, {0x1100}}},                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u1160\u0308\u0020\u1100", expected: [][]rune{{0x1160, 0x0308, 0x0020}, {0x1100}}},                                                                                                 // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
	{original: "\u1160\u11A8", expected: [][]rune{{0x1160, 0x11A8}}},                                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [26.02] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u1160\u0020\u11A8", expected: [][]rune{{0x1160, 0x0020}, {0x11A8}}},                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u1160\u0308\u11A8", expected: [][]rune{{0x1160, 0x0308, 0x11A8}}},                                                                                                                 // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [26.02] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u1160\u0308\u0020\u11A8", expected: [][]rune{{0x1160, 0x0308, 0x0020}, {0x11A8}}},                                                                                                 // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
	{original: "\u1160\u1160", expected: [][]rune{{0x1160, 0x1160}}},                                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [26.02] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u1160\u0020\u1160", expected: [][]rune{{0x1160, 0x0020}, {0x1160}}},                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u1160\u0308\u1160", expected: [][]rune{{0x1160, 0x0308, 0x1160}}},                                                                                                                 // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [26.02] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u1160\u0308\u0020\u1160", expected: [][]rune{{0x1160, 0x0308, 0x0020}, {0x1160}}},                                                                                                 // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
	{original: "\u1160\u000A", expected: [][]rune{{0x1160, 0x000A}}},                                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u1160\u0020\u000A", expected: [][]rune{{0x1160, 0x0020, 0x000A}}},                                                                                                                 // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u1160\u0308\u000A", expected: [][]rune{{0x1160, 0x0308, 0x000A}}},                                                                                                                 // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u1160\u0308\u0020\u000A", expected: [][]rune{{0x1160, 0x0308, 0x0020, 0x000A}}},                                                                                                   // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u1160\u0085", expected: [][]rune{{0x1160, 0x0085}}},                                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u1160\u0020\u0085", expected: [][]rune{{0x1160, 0x0020, 0x0085}}},                                                                                                                 // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u1160\u0308\u0085", expected: [][]rune{{0x1160, 0x0308, 0x0085}}},                                                                                                                 // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u1160\u0308\u0020\u0085", expected: [][]rune{{0x1160, 0x0308, 0x0020, 0x0085}}},                                                                                                   // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
	{original: "\u1160\u17D6", expected: [][]rune{{0x1160, 0x17D6}}},                                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u1160\u0020\u17D6", expected: [][]rune{{0x1160, 0x0020}, {0x17D6}}},                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u1160\u0308\u17D6", expected: [][]rune{{0x1160, 0x0308, 0x17D6}}},                                                                                                                 // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u1160\u0308\u0020\u17D6", expected: [][]rune{{0x1160, 0x0308, 0x0020}, {0x17D6}}},                                                                                                 // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
	{original: "\u1160\u0030", expected: [][]rune{{0x1160}, {0x0030}}},                                                                                                                             // × [0.3] HANGUL JUNGSEONG FILLER (JV) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u1160\u0020\u0030", expected: [][]rune{{0x1160, 0x0020}, {0x0030}}},                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u1160\u0308\u0030", expected: [][]rune{{0x1160, 0x0308}, {0x0030}}},                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u1160\u0308\u0020\u0030", expected: [][]rune{{0x1160, 0x0308, 0x0020}, {0x0030}}},                                                                                                 // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
	{original: "\u1160\u2329", expected: [][]rune{{0x1160}, {0x2329}}},                                                                                                                             // × [0.3] HANGUL JUNGSEONG FILLER (JV) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u1160\u0020\u2329", expected: [][]rune{{0x1160, 0x0020}, {0x2329}}},                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u1160\u0308\u2329", expected: [][]rune{{0x1160, 0x0308}, {0x2329}}},                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u1160\u0308\u0020\u2329", expected: [][]rune{{0x1160, 0x0308, 0x0020}, {0x2329}}},                                                                                                 // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
	{original: "\u1160\u0025", expected: [][]rune{{0x1160, 0x0025}}},                                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [27.01] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u1160\u0020\u0025", expected: [][]rune{{0x1160, 0x0020}, {0x0025}}},                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u1160\u0308\u0025", expected: [][]rune{{0x1160, 0x0308, 0x0025}}},                                                                                                                 // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [27.01] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u1160\u0308\u0020\u0025", expected: [][]rune{{0x1160, 0x0308, 0x0020}, {0x0025}}},                                                                                                 // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
	{original: "\u1160\u0024", expected: [][]rune{{0x1160}, {0x0024}}},                                                                                                                             // × [0.3] HANGUL JUNGSEONG FILLER (JV) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u1160\u0020\u0024", expected: [][]rune{{0x1160, 0x0020}, {0x0024}}},                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u1160\u0308\u0024", expected: [][]rune{{0x1160, 0x0308}, {0x0024}}},                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u1160\u0308\u0020\u0024", expected: [][]rune{{0x1160, 0x0308, 0x0020}, {0x0024}}},                                                                                                 // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
	{original: "\u1160\u0022", expected: [][]rune{{0x1160, 0x0022}}},                                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u1160\u0020\u0022", expected: [][]rune{{0x1160, 0x0020}, {0x0022}}},                                                                                                               // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u1160\u0308\u0022", expected: [][]rune{{0x1160, 0x0308, 0x0022}}},                                                                                                                 // × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
	{original: "\u1160\u0308\u0020\u0022", expected: [][]rune{{0x1160, 0x0308, 0x0020}, {0x0022}}},                                