// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/apps/market/v2/resources.proto

package marketplace

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type CustomerLicense struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of API resource. This is always appsmarket#customerLicense.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// The customer's license status. One of:
	//
	// - `ACTIVE`: The customer has a valid license.
	// - `UNLICENSED`: There is no license: either this customer has never
	// installed your application, or else has deleted it.
	State string `protobuf:"bytes,2,opt,name=state,proto3" json:"state,omitempty"`
	// The ID of the application corresponding to this license query.
	ApplicationId string `protobuf:"bytes,3,opt,name=application_id,json=applicationId,proto3" json:"application_id,omitempty"`
	// (Deprecated)
	//
	// Deprecated: Do not use.
	Editions []*CustomerLicense_Editions `protobuf:"bytes,4,rep,name=editions,proto3" json:"editions,omitempty"`
	// The ID of the customer license.
	Id string `protobuf:"bytes,101,opt,name=id,proto3" json:"id,omitempty"`
	// The domain name of the customer.
	CustomerId string `protobuf:"bytes,102,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
}

func (x *CustomerLicense) Reset() {
	*x = CustomerLicense{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_market_v2_resources_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CustomerLicense) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomerLicense) ProtoMessage() {}

func (x *CustomerLicense) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_market_v2_resources_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomerLicense.ProtoReflect.Descriptor instead.
func (*CustomerLicense) Descriptor() ([]byte, []int) {
	return file_google_apps_market_v2_resources_proto_rawDescGZIP(), []int{0}
}

func (x *CustomerLicense) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *CustomerLicense) GetState() string {
	if x != nil {
		return x.State
	}
	return ""
}

func (x *CustomerLicense) GetApplicationId() string {
	if x != nil {
		return x.ApplicationId
	}
	return ""
}

// Deprecated: Do not use.
func (x *CustomerLicense) GetEditions() []*CustomerLicense_Editions {
	if x != nil {
		return x.Editions
	}
	return nil
}

func (x *CustomerLicense) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *CustomerLicense) GetCustomerId() string {
	if x != nil {
		return x.CustomerId
	}
	return ""
}

type LicenseNotification struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the license notification.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The ID of the application according to this notification.
	ApplicationId string `protobuf:"bytes,2,opt,name=application_id,json=applicationId,proto3" json:"application_id,omitempty"`
	// The time the event occurred, measuring in milliseconds since the UNIX
	// epoch.
	Timestamp int64 `protobuf:"varint,3,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// The domain name of the customer corresponding to this notification.
	CustomerId string `protobuf:"bytes,4,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// The type of API resource. This is always appsmarket#licenseNotification.
	Kind string `protobuf:"bytes,5,opt,name=kind,proto3" json:"kind,omitempty"`
	// The list of provisioning notifications.
	Provisions []*LicenseNotification_Provisions `protobuf:"bytes,6,rep,name=provisions,proto3" json:"provisions,omitempty"`
	// The list of expiry notifications.
	Expiries []*LicenseNotification_Expiries `protobuf:"bytes,7,rep,name=expiries,proto3" json:"expiries,omitempty"`
	// The list of reassignment notifications.
	Reassignments []*LicenseNotification_Reassignments `protobuf:"bytes,8,rep,name=reassignments,proto3" json:"reassignments,omitempty"`
	// The list of deletion notifications.
	Deletes []*LicenseNotification_Deletes `protobuf:"bytes,9,rep,name=deletes,proto3" json:"deletes,omitempty"`
}

func (x *LicenseNotification) Reset() {
	*x = LicenseNotification{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_market_v2_resources_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LicenseNotification) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LicenseNotification) ProtoMessage() {}

func (x *LicenseNotification) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_market_v2_resources_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LicenseNotification.ProtoReflect.Descriptor instead.
func (*LicenseNotification) Descriptor() ([]byte, []int) {
	return file_google_apps_market_v2_resources_proto_rawDescGZIP(), []int{1}
}

func (x *LicenseNotification) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *LicenseNotification) GetApplicationId() string {
	if x != nil {
		return x.ApplicationId
	}
	return ""
}

func (x *LicenseNotification) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

func (x *LicenseNotification) GetCustomerId() string {
	if x != nil {
		return x.CustomerId
	}
	return ""
}

func (x *LicenseNotification) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *LicenseNotification) GetProvisions() []*LicenseNotification_Provisions {
	if x != nil {
		return x.Provisions
	}
	return nil
}

func (x *LicenseNotification) GetExpiries() []*LicenseNotification_Expiries {
	if x != nil {
		return x.Expiries
	}
	return nil
}

func (x *LicenseNotification) GetReassignments() []*LicenseNotification_Reassignments {
	if x != nil {
		return x.Reassignments
	}
	return nil
}

func (x *LicenseNotification) GetDeletes() []*LicenseNotification_Deletes {
	if x != nil {
		return x.Deletes
	}
	return nil
}

type LicenseNotificationList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// The list of notifications. One or more of:
	//
	// - `provisions`: A new license of the application has been provisioned.
	// - `expiries`: A license of the application has expired.
	// - `deletions`: An application has been deleted from a domain.
	// - `reassignments`: An administrator has assigned or revoked a seat license
	// for the application on the provided domain.
	Notifications []*LicenseNotification `protobuf:"bytes,1007,rep,name=notifications,proto3" json:"notifications,omitempty"`
	// The token used to continue querying for notifications after the final
	// notification in the current result set.
	NextPageToken string `protobuf:"bytes,100602,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *LicenseNotificationList) Reset() {
	*x = LicenseNotificationList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_market_v2_resources_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LicenseNotificationList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LicenseNotificationList) ProtoMessage() {}

func (x *LicenseNotificationList) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_market_v2_resources_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LicenseNotificationList.ProtoReflect.Descriptor instead.
func (*LicenseNotificationList) Descriptor() ([]byte, []int) {
	return file_google_apps_market_v2_resources_proto_rawDescGZIP(), []int{2}
}

func (x *LicenseNotificationList) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *LicenseNotificationList) GetNotifications() []*LicenseNotification {
	if x != nil {
		return x.Notifications
	}
	return nil
}

func (x *LicenseNotificationList) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

type UserLicense struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of API resource. This is always appsmarket#userLicense.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// The domain administrator has activated the application for this domain.
	Enabled bool `protobuf:"varint,2,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// The user's licensing status. One of:
	//
	// - `ACTIVE`: The user has a valid license and should be permitted to use the
	// application.
	// - `UNLICENSED`: The administrator of this user's domain never assigned a
	// seat for the application to this user.
	// - `EXPIRED`: The administrator assigned a seat to this user, but the
	// license is expired.
	State string `protobuf:"bytes,3,opt,name=state,proto3" json:"state,omitempty"`
	// (Deprecated)
	//
	// Deprecated: Do not use.
	EditionId string `protobuf:"bytes,4,opt,name=edition_id,json=editionId,proto3" json:"edition_id,omitempty"`
	// The domain name of the user.
	CustomerId string `protobuf:"bytes,5,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// The ID of the application corresponding to the license query.
	ApplicationId string `protobuf:"bytes,6,opt,name=application_id,json=applicationId,proto3" json:"application_id,omitempty"`
	// The ID of user license.
	Id string `protobuf:"bytes,101,opt,name=id,proto3" json:"id,omitempty"`
	// The email address of the user.
	UserId string `protobuf:"bytes,102,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
}

func (x *UserLicense) Reset() {
	*x = UserLicense{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_market_v2_resources_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserLicense) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserLicense) ProtoMessage() {}

func (x *UserLicense) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_market_v2_resources_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserLicense.ProtoReflect.Descriptor instead.
func (*UserLicense) Descriptor() ([]byte, []int) {
	return file_google_apps_market_v2_resources_proto_rawDescGZIP(), []int{3}
}

func (x *UserLicense) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *UserLicense) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *UserLicense) GetState() string {
	if x != nil {
		return x.State
	}
	return ""
}

// Deprecated: Do not use.
func (x *UserLicense) GetEditionId() string {
	if x != nil {
		return x.EditionId
	}
	return ""
}

func (x *UserLicense) GetCustomerId() string {
	if x != nil {
		return x.CustomerId
	}
	return ""
}

func (x *UserLicense) GetApplicationId() string {
	if x != nil {
		return x.ApplicationId
	}
	return ""
}

func (x *UserLicense) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *UserLicense) GetUserId() string {
	if x != nil {
		return x.UserId
	}
	return ""
}

type CustomerLicense_Editions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Deprecated)
	//
	// Deprecated: Do not use.
	EditionId string `protobuf:"bytes,405,opt,name=edition_id,json=editionId,proto3" json:"edition_id,omitempty"`
	// (Deprecated)
	//
	// Deprecated: Do not use.
	SeatCount int32 `protobuf:"varint,406,opt,name=seat_count,json=seatCount,proto3" json:"seat_count,omitempty"`
	// (Deprecated)
	//
	// Deprecated: Do not use.
	AssignedSeats int32 `protobuf:"varint,409,opt,name=assigned_seats,json=assignedSeats,proto3" json:"assigned_seats,omitempty"`
}

func (x *CustomerLicense_Editions) Reset() {
	*x = CustomerLicense_Editions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_market_v2_resources_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CustomerLicense_Editions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomerLicense_Editions) ProtoMessage() {}

func (x *CustomerLicense_Editions) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_market_v2_resources_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomerLicense_Editions.ProtoReflect.Descriptor instead.
func (*CustomerLicense_Editions) Descriptor() ([]byte, []int) {
	return file_google_apps_market_v2_resources_proto_rawDescGZIP(), []int{0, 0}
}

// Deprecated: Do not use.
func (x *CustomerLicense_Editions) GetEditionId() string {
	if x != nil {
		return x.EditionId
	}
	return ""
}

// Deprecated: Do not use.
func (x *CustomerLicense_Editions) GetSeatCount() int32 {
	if x != nil {
		return x.SeatCount
	}
	return 0
}

// Deprecated: Do not use.
func (x *CustomerLicense_Editions) GetAssignedSeats() int32 {
	if x != nil {
		return x.AssignedSeats
	}
	return 0
}

type LicenseNotification_Deletes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// (Deprecated)
	//
	// Deprecated: Do not use.
	EditionId string `protobuf:"bytes,901,opt,name=edition_id,json=editionId,proto3" json:"edition_id,omitempty"`
}

func (x *LicenseNotification_Deletes) Reset() {
	*x = LicenseNotification_Deletes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_market_v2_resources_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LicenseNotification_Deletes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LicenseNotification_Deletes) ProtoMessage() {}

func (x *LicenseNotification_Deletes) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_market_v2_resources_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LicenseNotification_Deletes.ProtoReflect.Descriptor instead.
func (*LicenseNotification_Deletes) Descriptor() ([]byte, []int) {
	return file_google_apps_market_v2_resources_proto_rawDescGZIP(), []int{1, 0}
}

func (x *LicenseNotification_Deletes) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

// Deprecated: Do not use.
func (x *LicenseNotification_Deletes) GetEditionId() string {
	if x != nil {
		return x.EditionId
	}
	return ""
}

type LicenseNotification_Expiries struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// (Deprecated)
	//
	// Deprecated: Do not use.
	EditionId string `protobuf:"bytes,701,opt,name=edition_id,json=editionId,proto3" json:"edition_id,omitempty"`
}

func (x *LicenseNotification_Expiries) Reset() {
	*x = LicenseNotification_Expiries{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_market_v2_resources_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LicenseNotification_Expiries) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LicenseNotification_Expiries) ProtoMessage() {}

func (x *LicenseNotification_Expiries) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_market_v2_resources_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LicenseNotification_Expiries.ProtoReflect.Descriptor instead.
func (*LicenseNotification_Expiries) Descriptor() ([]byte, []int) {
	return file_google_apps_market_v2_resources_proto_rawDescGZIP(), []int{1, 1}
}

func (x *LicenseNotification_Expiries) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

// Deprecated: Do not use.
func (x *LicenseNotification_Expiries) GetEditionId() string {
	if x != nil {
		return x.EditionId
	}
	return ""
}

type LicenseNotification_Provisions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// (Deprecated)
	//
	// Deprecated: Do not use.
	EditionId string `protobuf:"bytes,601,opt,name=edition_id,json=editionId,proto3" json:"edition_id,omitempty"`
	// The number of seats that were provisioned.
	SeatCount int64 `protobuf:"varint,602,opt,name=seat_count,json=seatCount,proto3" json:"seat_count,omitempty"`
}

func (x *LicenseNotification_Provisions) Reset() {
	*x = LicenseNotification_Provisions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_market_v2_resources_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LicenseNotification_Provisions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LicenseNotification_Provisions) ProtoMessage() {}

func (x *LicenseNotification_Provisions) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_market_v2_resources_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LicenseNotification_Provisions.ProtoReflect.Descriptor instead.
func (*LicenseNotification_Provisions) Descriptor() ([]byte, []int) {
	return file_google_apps_market_v2_resources_proto_rawDescGZIP(), []int{1, 2}
}

func (x *LicenseNotification_Provisions) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

// Deprecated: Do not use.
func (x *LicenseNotification_Provisions) GetEditionId() string {
	if x != nil {
		return x.EditionId
	}
	return ""
}

func (x *LicenseNotification_Provisions) GetSeatCount() int64 {
	if x != nil {
		return x.SeatCount
	}
	return 0
}

type LicenseNotification_Reassignments struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// The email address of the reassigned user.
	UserId string `protobuf:"bytes,801,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
	Type   string `protobuf:"bytes,802,opt,name=type,proto3" json:"type,omitempty"`
	// (Deprecated)
	//
	// Deprecated: Do not use.
	EditionId string `protobuf:"bytes,803,opt,name=edition_id,json=editionId,proto3" json:"edition_id,omitempty"`
}

func (x *LicenseNotification_Reassignments) Reset() {
	*x = LicenseNotification_Reassignments{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_market_v2_resources_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LicenseNotification_Reassignments) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LicenseNotification_Reassignments) ProtoMessage() {}

func (x *LicenseNotification_Reassignments) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_market_v2_resources_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LicenseNotification_Reassignments.ProtoReflect.Descriptor instead.
func (*LicenseNotification_Reassignments) Descriptor() ([]byte, []int) {
	return file_google_apps_market_v2_resources_proto_rawDescGZIP(), []int{1, 3}
}

func (x *LicenseNotification_Reassignments) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *LicenseNotification_Reassignments) GetUserId() string {
	if x != nil {
		return x.UserId
	}
	return ""
}

func (x *LicenseNotification_Reassignments) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

// Deprecated: Do not use.
func (x *LicenseNotification_Reassignments) GetEditionId() string {
	if x != nil {
		return x.EditionId
	}
	return ""
}

var File_google_apps_market_v2_resources_proto protoreflect.FileDescriptor

var file_google_apps_market_v2_resources_proto_rawDesc = []byte{
	0x0a, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x70, 0x73, 0x2f, 0x6d, 0x61,
	0x72, 0x6b, 0x65, 0x74, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x19, 0x63, 0x63, 0x63, 0x2e, 0x68, 0x6f, 0x73,
	0x74, 0x65, 0x64, 0x2e, 0x6d, 0x61, 0x72, 0x6b, 0x65, 0x74, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x2e,
	0x76, 0x32, 0x22, 0xe8, 0x02, 0x0a, 0x0f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x4c,
	0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x25, 0x0a, 0x0e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x53, 0x0a, 0x08, 0x65, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x63, 0x63, 0x63, 0x2e,
	0x68, 0x6f, 0x73, 0x74, 0x65, 0x64, 0x2e, 0x6d, 0x61, 0x72, 0x6b, 0x65, 0x74, 0x70, 0x6c, 0x61,
	0x63, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x4c, 0x69,
	0x63, 0x65, 0x6e, 0x73, 0x65, 0x2e, 0x45, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x02,
	0x18, 0x01, 0x52, 0x08, 0x65, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x0e, 0x0a, 0x02,
	0x69, 0x64, 0x18, 0x65, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x1f, 0x0a, 0x0b,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x66, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x49, 0x64, 0x1a, 0x7e, 0x0a,
	0x08, 0x45, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x22, 0x0a, 0x0a, 0x65, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x95, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02,
	0x18, 0x01, 0x52, 0x09, 0x65, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x22, 0x0a,
	0x0a, 0x73, 0x65, 0x61, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x96, 0x03, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x73, 0x65, 0x61, 0x74, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x12, 0x2a, 0x0a, 0x0e, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x5f, 0x73, 0x65,
	0x61, 0x74, 0x73, 0x18, 0x99, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0d,
	0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x53, 0x65, 0x61, 0x74, 0x73, 0x22, 0xea, 0x06,
	0x0a, 0x13, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x25, 0x0a, 0x0e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x61,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x1c, 0x0a, 0x09,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0a, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6b,
	0x69, 0x6e, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12,
	0x59, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x63, 0x63, 0x63, 0x2e, 0x68, 0x6f, 0x73, 0x74, 0x65, 0x64,
	0x2e, 0x6d, 0x61, 0x72, 0x6b, 0x65, 0x74, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x32, 0x2e,
	0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x0a,
	0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x53, 0x0a, 0x08, 0x65, 0x78,
	0x70, 0x69, 0x72, 0x69, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x63,
	0x63, 0x63, 0x2e, 0x68, 0x6f, 0x73, 0x74, 0x65, 0x64, 0x2e, 0x6d, 0x61, 0x72, 0x6b, 0x65, 0x74,
	0x70, 0x6c, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65,
	0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x45, 0x78, 0x70,
	0x69, 0x72, 0x69, 0x65, 0x73, 0x52, 0x08, 0x65, 0x78, 0x70, 0x69, 0x72, 0x69, 0x65, 0x73, 0x12,
	0x62, 0x0a, 0x0d, 0x72, 0x65, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x63, 0x63, 0x63, 0x2e, 0x68, 0x6f, 0x73,
	0x74, 0x65, 0x64, 0x2e, 0x6d, 0x61, 0x72, 0x6b, 0x65, 0x74, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x2e,
	0x76, 0x32, 0x2e, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x52, 0x0d, 0x72, 0x65, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x12, 0x50, 0x0a, 0x07, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x73, 0x18, 0x09,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x63, 0x63, 0x63, 0x2e, 0x68, 0x6f, 0x73, 0x74, 0x65,
	0x64, 0x2e, 0x6d, 0x61, 0x72, 0x6b, 0x65, 0x74, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x32,
	0x2e, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x73, 0x52, 0x07, 0x64, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x73, 0x1a, 0x41, 0x0a, 0x07, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x73,
	0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6b, 0x69, 0x6e, 0x64, 0x12, 0x22, 0x0a, 0x0a, 0x65, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x18, 0x85, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x65,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x1a, 0x42, 0x0a, 0x08, 0x45, 0x78, 0x70, 0x69,
	0x72, 0x69, 0x65, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x22, 0x0a, 0x0a, 0x65, 0x64, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0xbd, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18,
	0x01, 0x52, 0x09, 0x65, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x1a, 0x64, 0x0a, 0x0a,
	0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69,
	0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x22,
	0x0a, 0x0a, 0x65, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0xd9, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x65, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x64, 0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x65, 0x61, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0xda, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x73, 0x65, 0x61, 0x74, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x1a, 0x76, 0x0a, 0x0d, 0x52, 0x65, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x75, 0x73, 0x65, 0x72, 0x5f,
	0x69, 0x64, 0x18, 0xa1, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49,
	0x64, 0x12, 0x13, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0xa2, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x65, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x18, 0xa3, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52,
	0x09, 0x65, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0xae, 0x01, 0x0a, 0x17, 0x4c,
	0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x55, 0x0a, 0x0d, 0x6e, 0x6f,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0xef, 0x07, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x63, 0x63, 0x63, 0x2e, 0x68, 0x6f, 0x73, 0x74, 0x65, 0x64, 0x2e,
	0x6d, 0x61, 0x72, 0x6b, 0x65, 0x74, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x4c,
	0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x0d, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x28, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0xfa, 0x91, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xe5, 0x01, 0x0a, 0x0b,
	0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6b,
	0x69, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12,
	0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x21, 0x0a, 0x0a, 0x65, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x65, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x69,
	0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65,
	0x72, 0x49, 0x64, 0x12, 0x25, 0x0a, 0x0e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x61, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64,
	0x18, 0x65, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x17, 0x0a, 0x07, 0x75, 0x73,
	0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x66, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x73, 0x65,
	0x72, 0x49, 0x64, 0x42, 0x9d, 0x01, 0x0a, 0x24, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x63, 0x63, 0x2e, 0x68, 0x6f, 0x73, 0x74, 0x65, 0x64, 0x2e, 0x6d, 0x61,
	0x72, 0x6b, 0x65, 0x74, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x32, 0x42, 0x0e, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4b,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72,
	0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x63, 0x63, 0x2f, 0x68, 0x6f, 0x73, 0x74, 0x65, 0x64,
	0x2f, 0x6d, 0x61, 0x72, 0x6b, 0x65, 0x74, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x2f, 0x76, 0x32, 0x3b,
	0x6d, 0x61, 0x72, 0x6b, 0x65, 0x74, 0x70, 0x6c, 0x61, 0x63, 0x65, 0xca, 0x02, 0x15, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x41, 0x70, 0x70, 0x73, 0x5c, 0x4d, 0x61, 0x72, 0x6b, 0x65, 0x74,
	0x5c, 0x56, 0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_apps_market_v2_resources_proto_rawDescOnce sync.Once
	file_google_apps_market_v2_resources_proto_rawDescData = file_google_apps_market_v2_resources_proto_rawDesc
)

func file_google_apps_market_v2_resources_proto_rawDescGZIP() []byte {
	file_google_apps_market_v2_resources_proto_rawDescOnce.Do(func() {
		file_google_apps_market_v2_resources_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_apps_market_v2_resources_proto_rawDescData)
	})
	return file_google_apps_market_v2_resources_proto_rawDescData
}

var file_google_apps_market_v2_resources_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_google_apps_market_v2_resources_proto_goTypes = []interface{}{
	(*CustomerLicense)(nil),                   // 0: ccc.hosted.marketplace.v2.CustomerLicense
	(*LicenseNotification)(nil),               // 1: ccc.hosted.marketplace.v2.LicenseNotification
	(*LicenseNotificationList)(nil),           // 2: ccc.hosted.marketplace.v2.LicenseNotificationList
	(*UserLicense)(nil),                       // 3: ccc.hosted.marketplace.v2.UserLicense
	(*CustomerLicense_Editions)(nil),          // 4: ccc.hosted.marketplace.v2.CustomerLicense.Editions
	(*LicenseNotification_Deletes)(nil),       // 5: ccc.hosted.marketplace.v2.LicenseNotification.Deletes
	(*LicenseNotification_Expiries)(nil),      // 6: ccc.hosted.marketplace.v2.LicenseNotification.Expiries
	(*LicenseNotification_Provisions)(nil),    // 7: ccc.hosted.marketplace.v2.LicenseNotification.Provisions
	(*LicenseNotification_Reassignments)(nil), // 8: ccc.hosted.marketplace.v2.LicenseNotification.Reassignments
}
var file_google_apps_market_v2_resources_proto_depIdxs = []int32{
	4, // 0: ccc.hosted.marketplace.v2.CustomerLicense.editions:type_name -> ccc.hosted.marketplace.v2.CustomerLicense.Editions
	7, // 1: ccc.hosted.marketplace.v2.LicenseNotification.provisions:type_name -> ccc.hosted.marketplace.v2.LicenseNotification.Provisions
	6, // 2: ccc.hosted.marketplace.v2.LicenseNotification.expiries:type_name -> ccc.hosted.marketplace.v2.LicenseNotification.Expiries
	8, // 3: ccc.hosted.marketplace.v2.LicenseNotification.reassignments:type_name -> ccc.hosted.marketplace.v2.LicenseNotification.Reassignments
	5, // 4: ccc.hosted.marketplace.v2.LicenseNotification.deletes:type_name -> ccc.hosted.marketplace.v2.LicenseNotification.Deletes
	1, // 5: ccc.hosted.marketplace.v2.LicenseNotificationList.notifications:type_name -> ccc.hosted.marketplace.v2.LicenseNotification
	6, // [6:6] is the sub-list for method output_type
	6, // [6:6] is the sub-list for method input_type
	6, // [6:6] is the sub-list for extension type_name
	6, // [6:6] is the sub-list for extension extendee
	0, // [0:6] is the sub-list for field type_name
}

func init() { file_google_apps_market_v2_resources_proto_init() }
func file_google_apps_market_v2_resources_proto_init() {
	if File_google_apps_market_v2_resources_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_apps_market_v2_resources_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CustomerLicense); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_market_v2_resources_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LicenseNotification); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_market_v2_resources_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LicenseNotificationList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_market_v2_resources_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UserLicense); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_market_v2_resources_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CustomerLicense_Editions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_market_v2_resources_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LicenseNotification_Deletes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_market_v2_resources_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LicenseNotification_Expiries); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_market_v2_resources_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LicenseNotification_Provisions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_market_v2_resources_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LicenseNotification_Reassignments); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_apps_market_v2_resources_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_apps_market_v2_resources_proto_goTypes,
		DependencyIndexes: file_google_apps_market_v2_resources_proto_depIdxs,
		MessageInfos:      file_google_apps_market_v2_resources_proto_msgTypes,
	}.Build()
	File_google_apps_market_v2_resources_proto = out.File
	file_google_apps_market_v2_resources_proto_rawDesc = nil
	file_google_apps_market_v2_resources_proto_goTypes = nil
	file_google_apps_market_v2_resources_proto_depIdxs = nil
}
