// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/contentwarehouse/v1/filters.proto

package contentwarehouse

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	interval "google.golang.org/genproto/googleapis/type/interval"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Time field used in TimeFilter.
type TimeFilter_TimeField int32

const (
	// Default value.
	TimeFilter_TIME_FIELD_UNSPECIFIED TimeFilter_TimeField = 0
	// Earliest document create time.
	TimeFilter_CREATE_TIME TimeFilter_TimeField = 1
	// Latest document update time.
	TimeFilter_UPDATE_TIME TimeFilter_TimeField = 2
)

// Enum value maps for TimeFilter_TimeField.
var (
	TimeFilter_TimeField_name = map[int32]string{
		0: "TIME_FIELD_UNSPECIFIED",
		1: "CREATE_TIME",
		2: "UPDATE_TIME",
	}
	TimeFilter_TimeField_value = map[string]int32{
		"TIME_FIELD_UNSPECIFIED": 0,
		"CREATE_TIME":            1,
		"UPDATE_TIME":            2,
	}
)

func (x TimeFilter_TimeField) Enum() *TimeFilter_TimeField {
	p := new(TimeFilter_TimeField)
	*p = x
	return p
}

func (x TimeFilter_TimeField) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TimeFilter_TimeField) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_contentwarehouse_v1_filters_proto_enumTypes[0].Descriptor()
}

func (TimeFilter_TimeField) Type() protoreflect.EnumType {
	return &file_google_cloud_contentwarehouse_v1_filters_proto_enumTypes[0]
}

func (x TimeFilter_TimeField) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TimeFilter_TimeField.Descriptor instead.
func (TimeFilter_TimeField) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_filters_proto_rawDescGZIP(), []int{1, 0}
}

// Representation of the types of files.
type FileTypeFilter_FileType int32

const (
	// Default document type. If set, disables the filter.
	FileTypeFilter_FILE_TYPE_UNSPECIFIED FileTypeFilter_FileType = 0
	// Returns all document types, including folders.
	FileTypeFilter_ALL FileTypeFilter_FileType = 1
	// Returns only folders.
	FileTypeFilter_FOLDER FileTypeFilter_FileType = 2
	// Returns only non-folder documents.
	FileTypeFilter_DOCUMENT FileTypeFilter_FileType = 3
)

// Enum value maps for FileTypeFilter_FileType.
var (
	FileTypeFilter_FileType_name = map[int32]string{
		0: "FILE_TYPE_UNSPECIFIED",
		1: "ALL",
		2: "FOLDER",
		3: "DOCUMENT",
	}
	FileTypeFilter_FileType_value = map[string]int32{
		"FILE_TYPE_UNSPECIFIED": 0,
		"ALL":                   1,
		"FOLDER":                2,
		"DOCUMENT":              3,
	}
)

func (x FileTypeFilter_FileType) Enum() *FileTypeFilter_FileType {
	p := new(FileTypeFilter_FileType)
	*p = x
	return p
}

func (x FileTypeFilter_FileType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FileTypeFilter_FileType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_contentwarehouse_v1_filters_proto_enumTypes[1].Descriptor()
}

func (FileTypeFilter_FileType) Type() protoreflect.EnumType {
	return &file_google_cloud_contentwarehouse_v1_filters_proto_enumTypes[1]
}

func (x FileTypeFilter_FileType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FileTypeFilter_FileType.Descriptor instead.
func (FileTypeFilter_FileType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_filters_proto_rawDescGZIP(), []int{3, 0}
}

// NEXT_ID: 13
type DocumentQuery struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The query string that matches against the full text of the document and
	// the searchable properties.
	// The maximum number of allowed characters is 255.
	Query string `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	// Experimental, do not use.
	// If the query is a natural language question. False by default. If true,
	// then the question-answering feature will be used instead of search, and
	// `result_count` in [SearchDocumentsRequest][google.cloud.contentwarehouse.v1.SearchDocumentsRequest] must be set. In addition, all
	// other input fields related to search (pagination, histograms, etc.) will be
	// ignored.
	IsNlQuery bool `protobuf:"varint,12,opt,name=is_nl_query,json=isNlQuery,proto3" json:"is_nl_query,omitempty"`
	// This filter specifies a structured syntax to match against the
	// [PropertyDefinition].[is_filterable][] marked as `true`. The syntax for
	// this expression is a subset of SQL syntax.
	//
	// Supported operators are: `=`, `!=`, `<`, `<=`, `>`, and `>=` where the left
	// of the operator is a property name and the right of the operator is a
	// number or a quoted string. You must escape backslash (\\) and quote (\")
	// characters. Supported functions are `LOWER([property_name])` to perform a
	// case insensitive match and `EMPTY([property_name])` to filter on the
	// existence of a key.
	//
	// Boolean expressions (AND/OR/NOT) are supported up to 3 levels of nesting
	// (for example, "((A AND B AND C) OR NOT D) AND E"), a maximum of 100
	// comparisons or functions are allowed in the expression. The expression must
	// be < 6000 bytes in length.
	//
	// Sample Query:
	// `(LOWER(driving_license)="class \"a\"" OR EMPTY(driving_license)) AND
	// driving_years > 10`
	//
	// Deprecated: Do not use.
	CustomPropertyFilter string `protobuf:"bytes,4,opt,name=custom_property_filter,json=customPropertyFilter,proto3" json:"custom_property_filter,omitempty"`
	// Documents created/updated within a range specified by this filter are
	// searched against.
	TimeFilters []*TimeFilter `protobuf:"bytes,5,rep,name=time_filters,json=timeFilters,proto3" json:"time_filters,omitempty"`
	// This filter specifies the exact document schema
	// [Document.document_schema_name][google.cloud.contentwarehouse.v1.Document.document_schema_name] of the documents to search against.
	//
	// If a value isn't specified, documents within the search results are
	// associated with any schema. If multiple values are specified, documents
	// within the search results may be associated with any of the specified
	// schemas.
	//
	// At most 20 document schema names are allowed.
	DocumentSchemaNames []string `protobuf:"bytes,6,rep,name=document_schema_names,json=documentSchemaNames,proto3" json:"document_schema_names,omitempty"`
	// This filter specifies a structured syntax to match against the
	// [PropertyDefinition.is_filterable][google.cloud.contentwarehouse.v1.PropertyDefinition.is_filterable] marked as `true`. The relationship
	// between the PropertyFilters is OR.
	PropertyFilter []*PropertyFilter `protobuf:"bytes,7,rep,name=property_filter,json=propertyFilter,proto3" json:"property_filter,omitempty"`
	// This filter specifies the types of files to return: ALL, FOLDER, or FILE.
	// If FOLDER or FILE is specified, then only either folders or files will be
	// returned, respectively. If ALL is specified, both folders and files will be
	// returned.
	//
	// If no value is specified, ALL files will be returned.
	FileTypeFilter *FileTypeFilter `protobuf:"bytes,8,opt,name=file_type_filter,json=fileTypeFilter,proto3" json:"file_type_filter,omitempty"`
	// Search all the documents under this specified folder.
	// Format:
	// projects/{project_number}/locations/{location}/documents/{document_id}.
	FolderNameFilter string `protobuf:"bytes,9,opt,name=folder_name_filter,json=folderNameFilter,proto3" json:"folder_name_filter,omitempty"`
	// For custom synonyms.
	// Customers provide the synonyms based on context. One customer can provide
	// multiple set of synonyms based on different context. The search query will
	// be expanded based on the custom synonyms of the query context set.
	// By default, no custom synonyms wll be applied if no query context is
	// provided.
	// It is not supported for CMEK compliant deployment.
	QueryContext []string `protobuf:"bytes,10,rep,name=query_context,json=queryContext,proto3" json:"query_context,omitempty"`
	// The exact creator(s) of the documents to search against.
	//
	// If a value isn't specified, documents within the search results are
	// associated with any creator. If multiple values are specified, documents
	// within the search results may be associated with any of the specified
	// creators.
	DocumentCreatorFilter []string `protobuf:"bytes,11,rep,name=document_creator_filter,json=documentCreatorFilter,proto3" json:"document_creator_filter,omitempty"`
}

func (x *DocumentQuery) Reset() {
	*x = DocumentQuery{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_filters_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DocumentQuery) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DocumentQuery) ProtoMessage() {}

func (x *DocumentQuery) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_filters_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DocumentQuery.ProtoReflect.Descriptor instead.
func (*DocumentQuery) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_filters_proto_rawDescGZIP(), []int{0}
}

func (x *DocumentQuery) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *DocumentQuery) GetIsNlQuery() bool {
	if x != nil {
		return x.IsNlQuery
	}
	return false
}

// Deprecated: Do not use.
func (x *DocumentQuery) GetCustomPropertyFilter() string {
	if x != nil {
		return x.CustomPropertyFilter
	}
	return ""
}

func (x *DocumentQuery) GetTimeFilters() []*TimeFilter {
	if x != nil {
		return x.TimeFilters
	}
	return nil
}

func (x *DocumentQuery) GetDocumentSchemaNames() []string {
	if x != nil {
		return x.DocumentSchemaNames
	}
	return nil
}

func (x *DocumentQuery) GetPropertyFilter() []*PropertyFilter {
	if x != nil {
		return x.PropertyFilter
	}
	return nil
}

func (x *DocumentQuery) GetFileTypeFilter() *FileTypeFilter {
	if x != nil {
		return x.FileTypeFilter
	}
	return nil
}

func (x *DocumentQuery) GetFolderNameFilter() string {
	if x != nil {
		return x.FolderNameFilter
	}
	return ""
}

func (x *DocumentQuery) GetQueryContext() []string {
	if x != nil {
		return x.QueryContext
	}
	return nil
}

func (x *DocumentQuery) GetDocumentCreatorFilter() []string {
	if x != nil {
		return x.DocumentCreatorFilter
	}
	return nil
}

// Filter on create timestamp or update timestamp of documents.
type TimeFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	TimeRange *interval.Interval `protobuf:"bytes,1,opt,name=time_range,json=timeRange,proto3" json:"time_range,omitempty"`
	// Specifies which time field to filter documents on.
	//
	// Defaults to [TimeField.UPLOAD_TIME][].
	TimeField TimeFilter_TimeField `protobuf:"varint,2,opt,name=time_field,json=timeField,proto3,enum=google.cloud.contentwarehouse.v1.TimeFilter_TimeField" json:"time_field,omitempty"`
}

func (x *TimeFilter) Reset() {
	*x = TimeFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_filters_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TimeFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimeFilter) ProtoMessage() {}

func (x *TimeFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_filters_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimeFilter.ProtoReflect.Descriptor instead.
func (*TimeFilter) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_filters_proto_rawDescGZIP(), []int{1}
}

func (x *TimeFilter) GetTimeRange() *interval.Interval {
	if x != nil {
		return x.TimeRange
	}
	return nil
}

func (x *TimeFilter) GetTimeField() TimeFilter_TimeField {
	if x != nil {
		return x.TimeField
	}
	return TimeFilter_TIME_FIELD_UNSPECIFIED
}

type PropertyFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Document schema name [Document.document_schema_name][google.cloud.contentwarehouse.v1.Document.document_schema_name].
	// Format:
	// projects/{project_number}/locations/{location}/documentSchemas/{document_schema_id}.
	DocumentSchemaName string `protobuf:"bytes,1,opt,name=document_schema_name,json=documentSchemaName,proto3" json:"document_schema_name,omitempty"`
	// The filter condition.
	// The syntax for this expression is a subset of SQL syntax.
	//
	// Supported operators are: `=`, `!=`, `<`, `<=`, `>`, `>=`, and `~~` where
	// the left of the operator is a property name and the right of the operator
	// is a number or a quoted string. You must escape backslash (\\) and quote
	// (\") characters.
	//
	// `~~` is the LIKE operator. The right of the operator must be a string. The
	// only supported property data type for LIKE is text_values. It provides
	// semantic search functionality by parsing, stemming and doing synonyms
	// expansion against the input query. It matches if the property contains
	// semantic similar content to the query. It is not regex matching or wildcard
	// matching. For example, "property.company ~~ \"google\"" will match records
	// whose property `property.compnay` have values like "Google Inc.", "Google
	// LLC" or "Google Company".
	//
	// Supported functions are `LOWER([property_name])` to perform a
	// case insensitive match and `EMPTY([property_name])` to filter on the
	// existence of a key.
	//
	// Boolean expressions (AND/OR/NOT) are supported up to 3 levels of nesting
	// (for example, "((A AND B AND C) OR NOT D) AND E"), a maximum of 100
	// comparisons or functions are allowed in the expression. The expression must
	// be < 6000 bytes in length.
	//
	// Only properties that are marked filterable are allowed
	// ([PropertyDefinition.is_filterable][google.cloud.contentwarehouse.v1.PropertyDefinition.is_filterable]). Property names do not need to be
	// prefixed by the document schema id (as is the case with histograms),
	// however property names will need to be prefixed by its parent hierarchy, if
	// any.  For example: top_property_name.sub_property_name.
	//
	// Sample Query:
	// `(LOWER(driving_license)="class \"a\"" OR EMPTY(driving_license)) AND
	// driving_years > 10`
	//
	// CMEK compliant deployment only supports:
	//
	// * Operators: `=`, `<`, `<=`, `>`, and `>=`.
	// * Boolean expressions: AND and OR.
	Condition string `protobuf:"bytes,2,opt,name=condition,proto3" json:"condition,omitempty"`
}

func (x *PropertyFilter) Reset() {
	*x = PropertyFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_filters_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PropertyFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PropertyFilter) ProtoMessage() {}

func (x *PropertyFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_filters_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PropertyFilter.ProtoReflect.Descriptor instead.
func (*PropertyFilter) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_filters_proto_rawDescGZIP(), []int{2}
}

func (x *PropertyFilter) GetDocumentSchemaName() string {
	if x != nil {
		return x.DocumentSchemaName
	}
	return ""
}

func (x *PropertyFilter) GetCondition() string {
	if x != nil {
		return x.Condition
	}
	return ""
}

// Filter for the specific types of documents returned.
type FileTypeFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of files to return.
	FileType FileTypeFilter_FileType `protobuf:"varint,1,opt,name=file_type,json=fileType,proto3,enum=google.cloud.contentwarehouse.v1.FileTypeFilter_FileType" json:"file_type,omitempty"`
}

func (x *FileTypeFilter) Reset() {
	*x = FileTypeFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_filters_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FileTypeFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FileTypeFilter) ProtoMessage() {}

func (x *FileTypeFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_filters_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FileTypeFilter.ProtoReflect.Descriptor instead.
func (*FileTypeFilter) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_filters_proto_rawDescGZIP(), []int{3}
}

func (x *FileTypeFilter) GetFileType() FileTypeFilter_FileType {
	if x != nil {
		return x.FileType
	}
	return FileTypeFilter_FILE_TYPE_UNSPECIFIED
}

var File_google_cloud_contentwarehouse_v1_filters_proto protoreflect.FileDescriptor

var file_google_cloud_contentwarehouse_v1_filters_proto_rawDesc = []byte{
	0x0a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2f,
	0x76, 0x31, 0x2f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e,
	0x76, 0x31, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x76, 0x61, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc6, 0x04, 0x0a, 0x0d, 0x44, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x12, 0x1e, 0x0a, 0x0b, 0x69, 0x73, 0x5f, 0x6e, 0x6c, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x18, 0x0c, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x69, 0x73, 0x4e, 0x6c, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x12, 0x38, 0x0a, 0x16, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x14, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x50, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x79, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x4f, 0x0a, 0x0c, 0x74,
	0x69, 0x6d, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52,
	0x0b, 0x74, 0x69, 0x6d, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x12, 0x32, 0x0a, 0x15,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x13, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x4e, 0x61, 0x6d, 0x65, 0x73,
	0x12, 0x59, 0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x5f, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x79, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x0e, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x79, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x5a, 0x0a, 0x10, 0x66,
	0x69, 0x6c, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65,
	0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x0e, 0x66, 0x69, 0x6c, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x2c, 0x0a, 0x12, 0x66, 0x6f, 0x6c, 0x64, 0x65,
	0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x10, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x23, 0x0a, 0x0d, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x36, 0x0a, 0x17, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x09, 0x52, 0x15, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x72, 0x65, 0x61, 0x74, 0x6f, 0x72, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x22, 0xe4, 0x01, 0x0a, 0x0a, 0x54, 0x69, 0x6d, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0x34, 0x0a, 0x0a, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74,
	0x79, 0x70, 0x65, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x52, 0x09, 0x74, 0x69,
	0x6d, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x55, 0x0a, 0x0a, 0x74, 0x69, 0x6d, 0x65, 0x5f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x22, 0x49,
	0x0a, 0x09, 0x54, 0x69, 0x6d, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x1a, 0x0a, 0x16, 0x54,
	0x49, 0x4d, 0x45, 0x5f, 0x46, 0x49, 0x45, 0x4c, 0x44, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x43, 0x52, 0x45, 0x41, 0x54,
	0x45, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x50, 0x44, 0x41,
	0x54, 0x45, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x10, 0x02, 0x22, 0x95, 0x01, 0x0a, 0x0e, 0x50, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x65, 0x0a, 0x14,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xfa, 0x41, 0x30, 0x0a,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73,
	0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52,
	0x12, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0xb2, 0x01, 0x0a, 0x0e, 0x46, 0x69, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x12, 0x56, 0x0a, 0x09, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61,
	0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x22, 0x48, 0x0a, 0x08,
	0x46, 0x69, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x46, 0x49, 0x4c, 0x45,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x41, 0x4c, 0x4c, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06,
	0x46, 0x4f, 0x4c, 0x44, 0x45, 0x52, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x4f, 0x43, 0x55,
	0x4d, 0x45, 0x4e, 0x54, 0x10, 0x03, 0x42, 0x88, 0x01, 0x0a, 0x24, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x42,
	0x0c, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x50, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f,
	0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2f, 0x76, 0x31,
	0x3b, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73,
	0x65, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_contentwarehouse_v1_filters_proto_rawDescOnce sync.Once
	file_google_cloud_contentwarehouse_v1_filters_proto_rawDescData = file_google_cloud_contentwarehouse_v1_filters_proto_rawDesc
)

func file_google_cloud_contentwarehouse_v1_filters_proto_rawDescGZIP() []byte {
	file_google_cloud_contentwarehouse_v1_filters_proto_rawDescOnce.Do(func() {
		file_google_cloud_contentwarehouse_v1_filters_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_contentwarehouse_v1_filters_proto_rawDescData)
	})
	return file_google_cloud_contentwarehouse_v1_filters_proto_rawDescData
}

var file_google_cloud_contentwarehouse_v1_filters_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_contentwarehouse_v1_filters_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_google_cloud_contentwarehouse_v1_filters_proto_goTypes = []interface{}{
	(TimeFilter_TimeField)(0),    // 0: google.cloud.contentwarehouse.v1.TimeFilter.TimeField
	(FileTypeFilter_FileType)(0), // 1: google.cloud.contentwarehouse.v1.FileTypeFilter.FileType
	(*DocumentQuery)(nil),        // 2: google.cloud.contentwarehouse.v1.DocumentQuery
	(*TimeFilter)(nil),           // 3: google.cloud.contentwarehouse.v1.TimeFilter
	(*PropertyFilter)(nil),       // 4: google.cloud.contentwarehouse.v1.PropertyFilter
	(*FileTypeFilter)(nil),       // 5: google.cloud.contentwarehouse.v1.FileTypeFilter
	(*interval.Interval)(nil),    // 6: google.type.Interval
}
var file_google_cloud_contentwarehouse_v1_filters_proto_depIdxs = []int32{
	3, // 0: google.cloud.contentwarehouse.v1.DocumentQuery.time_filters:type_name -> google.cloud.contentwarehouse.v1.TimeFilter
	4, // 1: google.cloud.contentwarehouse.v1.DocumentQuery.property_filter:type_name -> google.cloud.contentwarehouse.v1.PropertyFilter
	5, // 2: google.cloud.contentwarehouse.v1.DocumentQuery.file_type_filter:type_name -> google.cloud.contentwarehouse.v1.FileTypeFilter
	6, // 3: google.cloud.contentwarehouse.v1.TimeFilter.time_range:type_name -> google.type.Interval
	0, // 4: google.cloud.contentwarehouse.v1.TimeFilter.time_field:type_name -> google.cloud.contentwarehouse.v1.TimeFilter.TimeField
	1, // 5: google.cloud.contentwarehouse.v1.FileTypeFilter.file_type:type_name -> google.cloud.contentwarehouse.v1.FileTypeFilter.FileType
	6, // [6:6] is the sub-list for method output_type
	6, // [6:6] is the sub-list for method input_type
	6, // [6:6] is the sub-list for extension type_name
	6, // [6:6] is the sub-list for extension extendee
	0, // [0:6] is the sub-list for field type_name
}

func init() { file_google_cloud_contentwarehouse_v1_filters_proto_init() }
func file_google_cloud_contentwarehouse_v1_filters_proto_init() {
	if File_google_cloud_contentwarehouse_v1_filters_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_contentwarehouse_v1_filters_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DocumentQuery); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_filters_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TimeFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_filters_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PropertyFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_filters_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FileTypeFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_contentwarehouse_v1_filters_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_contentwarehouse_v1_filters_proto_goTypes,
		DependencyIndexes: file_google_cloud_contentwarehouse_v1_filters_proto_depIdxs,
		EnumInfos:         file_google_cloud_contentwarehouse_v1_filters_proto_enumTypes,
		MessageInfos:      file_google_cloud_contentwarehouse_v1_filters_proto_msgTypes,
	}.Build()
	File_google_cloud_contentwarehouse_v1_filters_proto = out.File
	file_google_cloud_contentwarehouse_v1_filters_proto_rawDesc = nil
	file_google_cloud_contentwarehouse_v1_filters_proto_goTypes = nil
	file_google_cloud_contentwarehouse_v1_filters_proto_depIdxs = nil
}
