// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.21.9
// source: google/cloud/paymentgateway/issuerswitch/v1/logs.proto

package issuerswitch

import (
	reflect "reflect"
	sync "sync"

	_type "google.golang.org/genproto/googleapis/logging/type"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The payload for the log entry.
type UpiTransaction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A human readable message about the log entry.
	Message string `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
	// The severity of the log entry.
	Severity _type.LogSeverity `protobuf:"varint,2,opt,name=severity,proto3,enum=google.logging.type.LogSeverity" json:"severity,omitempty"`
	// The API type of the transaction.
	ApiType ApiType `protobuf:"varint,3,opt,name=api_type,json=apiType,proto3,enum=google.cloud.paymentgateway.issuerswitch.v1.ApiType" json:"api_type,omitempty"`
	// The XML API type of the transaction.
	XmlApiType XmlApiType `protobuf:"varint,4,opt,name=xml_api_type,json=xmlApiType,proto3,enum=google.cloud.paymentgateway.issuerswitch.v1.XmlApiType" json:"xml_api_type,omitempty"`
	// The type of the transaction.
	TransactionType TransactionType `protobuf:"varint,5,opt,name=transaction_type,json=transactionType,proto3,enum=google.cloud.paymentgateway.issuerswitch.v1.TransactionType" json:"transaction_type,omitempty"`
	// UPI's transaction ID.
	TransactionId string `protobuf:"bytes,6,opt,name=transaction_id,json=transactionId,proto3" json:"transaction_id,omitempty"`
	// UPI's message ID.
	MessageId string `protobuf:"bytes,7,opt,name=message_id,json=messageId,proto3" json:"message_id,omitempty"`
	// The payment's RRN. This will be present only for payment related
	// transactions.
	Rrn string `protobuf:"bytes,8,opt,name=rrn,proto3" json:"rrn,omitempty"`
	// The timestamp at which the payload was received by the issuer switch.
	PayloadReceiptTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=payload_receipt_time,json=payloadReceiptTime,proto3" json:"payload_receipt_time,omitempty"`
	// The timestamp at which the payload was sent by the issuer switch.
	PayloadSentTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=payload_sent_time,json=payloadSentTime,proto3" json:"payload_sent_time,omitempty"`
	// Status of the transaction which could be SUCCESS or FAILURE. This will be
	// populated only after transaction is complete.
	Status TransactionInfo_State `protobuf:"varint,11,opt,name=status,proto3,enum=google.cloud.paymentgateway.issuerswitch.v1.TransactionInfo_State" json:"status,omitempty"`
	// Issuer switch error code. This will be present only for failed
	// transactions.
	ErrorCode string `protobuf:"bytes,12,opt,name=error_code,json=errorCode,proto3" json:"error_code,omitempty"`
	// UPI error code that was sent back to NPCI. This will be present only for
	// failed transactions.
	UpiErrorCode string `protobuf:"bytes,13,opt,name=upi_error_code,json=upiErrorCode,proto3" json:"upi_error_code,omitempty"`
	// Issuer switch error message. This will be present only for failed
	// transactions.
	ErrorMessage string `protobuf:"bytes,14,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	// The ack, request or response payload.
	//
	// Types that are assignable to Payload:
	//
	//	*UpiTransaction_Sent
	//	*UpiTransaction_Received
	Payload isUpiTransaction_Payload `protobuf_oneof:"payload"`
}

func (x *UpiTransaction) Reset() {
	*x = UpiTransaction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_logs_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpiTransaction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpiTransaction) ProtoMessage() {}

func (x *UpiTransaction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_logs_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpiTransaction.ProtoReflect.Descriptor instead.
func (*UpiTransaction) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_logs_proto_rawDescGZIP(), []int{0}
}

func (x *UpiTransaction) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *UpiTransaction) GetSeverity() _type.LogSeverity {
	if x != nil {
		return x.Severity
	}
	return _type.LogSeverity_DEFAULT
}

func (x *UpiTransaction) GetApiType() ApiType {
	if x != nil {
		return x.ApiType
	}
	return ApiType_API_TYPE_UNSPECIFIED
}

func (x *UpiTransaction) GetXmlApiType() XmlApiType {
	if x != nil {
		return x.XmlApiType
	}
	return XmlApiType_XML_API_TYPE_UNSPECIFIED
}

func (x *UpiTransaction) GetTransactionType() TransactionType {
	if x != nil {
		return x.TransactionType
	}
	return TransactionType_TRANSACTION_TYPE_UNSPECIFIED
}

func (x *UpiTransaction) GetTransactionId() string {
	if x != nil {
		return x.TransactionId
	}
	return ""
}

func (x *UpiTransaction) GetMessageId() string {
	if x != nil {
		return x.MessageId
	}
	return ""
}

func (x *UpiTransaction) GetRrn() string {
	if x != nil {
		return x.Rrn
	}
	return ""
}

func (x *UpiTransaction) GetPayloadReceiptTime() *timestamppb.Timestamp {
	if x != nil {
		return x.PayloadReceiptTime
	}
	return nil
}

func (x *UpiTransaction) GetPayloadSentTime() *timestamppb.Timestamp {
	if x != nil {
		return x.PayloadSentTime
	}
	return nil
}

func (x *UpiTransaction) GetStatus() TransactionInfo_State {
	if x != nil {
		return x.Status
	}
	return TransactionInfo_STATE_UNSPECIFIED
}

func (x *UpiTransaction) GetErrorCode() string {
	if x != nil {
		return x.ErrorCode
	}
	return ""
}

func (x *UpiTransaction) GetUpiErrorCode() string {
	if x != nil {
		return x.UpiErrorCode
	}
	return ""
}

func (x *UpiTransaction) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

func (m *UpiTransaction) GetPayload() isUpiTransaction_Payload {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (x *UpiTransaction) GetSent() string {
	if x, ok := x.GetPayload().(*UpiTransaction_Sent); ok {
		return x.Sent
	}
	return ""
}

func (x *UpiTransaction) GetReceived() string {
	if x, ok := x.GetPayload().(*UpiTransaction_Received); ok {
		return x.Received
	}
	return ""
}

type isUpiTransaction_Payload interface {
	isUpiTransaction_Payload()
}

type UpiTransaction_Sent struct {
	// The payload in XML format sent to the issuer switch.
	Sent string `protobuf:"bytes,15,opt,name=sent,proto3,oneof"`
}

type UpiTransaction_Received struct {
	// The payload in XML format received by the issuer switch.
	Received string `protobuf:"bytes,16,opt,name=received,proto3,oneof"`
}

func (*UpiTransaction_Sent) isUpiTransaction_Payload() {}

func (*UpiTransaction_Received) isUpiTransaction_Payload() {}

var File_google_cloud_paymentgateway_issuerswitch_v1_logs_proto protoreflect.FileDescriptor

var file_google_cloud_paymentgateway_issuerswitch_v1_logs_proto_rawDesc = []byte{
	0x0a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x70,
	0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2f, 0x69, 0x73,
	0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2f, 0x76, 0x31, 0x2f, 0x6c, 0x6f,
	0x67, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61,
	0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74,
	0x63, 0x68, 0x2e, 0x76, 0x31, 0x1a, 0x3f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77,
	0x61, 0x79, 0x2f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2f,
	0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x2f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68,
	0x2f, 0x76, 0x31, 0x2f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c,
	0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x6c, 0x6f, 0x67, 0x5f,
	0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0xf0, 0x06, 0x0a, 0x0e, 0x55, 0x70, 0x69, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x3c, 0x0a, 0x08,
	0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x20,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e,
	0x74, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x6f, 0x67, 0x53, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79,
	0x52, 0x08, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x12, 0x4f, 0x0a, 0x08, 0x61, 0x70,
	0x69, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d,
	0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65,
	0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x69, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x07, 0x61, 0x70, 0x69, 0x54, 0x79, 0x70, 0x65, 0x12, 0x59, 0x0a, 0x0c, 0x78,
	0x6d, 0x6c, 0x5f, 0x61, 0x70, 0x69, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e,
	0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e,
	0x58, 0x6d, 0x6c, 0x41, 0x70, 0x69, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x78, 0x6d, 0x6c, 0x41,
	0x70, 0x69, 0x54, 0x79, 0x70, 0x65, 0x12, 0x67, 0x0a, 0x10, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69,
	0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0f,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x25, 0x0a, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69,
	0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x5f, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x49, 0x64, 0x12, 0x10, 0x0a, 0x03, 0x72, 0x72, 0x6e, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x72, 0x72, 0x6e, 0x12, 0x4c, 0x0a, 0x14, 0x70, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x5f, 0x72, 0x65, 0x63, 0x65, 0x69, 0x70, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x12, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x63, 0x65, 0x69, 0x70,
	0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x46, 0x0a, 0x11, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64,
	0x5f, 0x73, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0f, 0x70, 0x61,
	0x79, 0x6c, 0x6f, 0x61, 0x64, 0x53, 0x65, 0x6e, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x5a, 0x0a,
	0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x42, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79,
	0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75,
	0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x24, 0x0a, 0x0e, 0x75, 0x70, 0x69, 0x5f,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x75, 0x70, 0x69, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x23,
	0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18,
	0x0e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x12, 0x14, 0x0a, 0x04, 0x73, 0x65, 0x6e, 0x74, 0x18, 0x0f, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x00, 0x52, 0x04, 0x73, 0x65, 0x6e, 0x74, 0x12, 0x1c, 0x0a, 0x08, 0x72, 0x65, 0x63,
	0x65, 0x69, 0x76, 0x65, 0x64, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x08, 0x72,
	0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x42, 0x09, 0x0a, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x42, 0xa5, 0x02, 0x0a, 0x2f, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69,
	0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x42, 0x09, 0x4c, 0x6f, 0x67, 0x73, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x57, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61,
	0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2f,
	0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2f, 0x76, 0x31, 0x3b,
	0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0xaa, 0x02, 0x2b, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x50, 0x61, 0x79, 0x6d,
	0x65, 0x6e, 0x74, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x65,
	0x72, 0x53, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x2b, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x50, 0x61, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5c, 0x49, 0x73, 0x73, 0x75, 0x65, 0x72, 0x53,
	0x77, 0x69, 0x74, 0x63, 0x68, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x2f, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x50, 0x61, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x3a, 0x3a, 0x49, 0x73, 0x73, 0x75, 0x65, 0x72,
	0x53, 0x77, 0x69, 0x74, 0x63, 0x68, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_cloud_paymentgateway_issuerswitch_v1_logs_proto_rawDescOnce sync.Once
	file_google_cloud_paymentgateway_issuerswitch_v1_logs_proto_rawDescData = file_google_cloud_paymentgateway_issuerswitch_v1_logs_proto_rawDesc
)

func file_google_cloud_paymentgateway_issuerswitch_v1_logs_proto_rawDescGZIP() []byte {
	file_google_cloud_paymentgateway_issuerswitch_v1_logs_proto_rawDescOnce.Do(func() {
		file_google_cloud_paymentgateway_issuerswitch_v1_logs_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_paymentgateway_issuerswitch_v1_logs_proto_rawDescData)
	})
	return file_google_cloud_paymentgateway_issuerswitch_v1_logs_proto_rawDescData
}

var file_google_cloud_paymentgateway_issuerswitch_v1_logs_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_google_cloud_paymentgateway_issuerswitch_v1_logs_proto_goTypes = []interface{}{
	(*UpiTransaction)(nil),        // 0: google.cloud.paymentgateway.issuerswitch.v1.UpiTransaction
	(_type.LogSeverity)(0),        // 1: google.logging.type.LogSeverity
	(ApiType)(0),                  // 2: google.cloud.paymentgateway.issuerswitch.v1.ApiType
	(XmlApiType)(0),               // 3: google.cloud.paymentgateway.issuerswitch.v1.XmlApiType
	(TransactionType)(0),          // 4: google.cloud.paymentgateway.issuerswitch.v1.TransactionType
	(*timestamppb.Timestamp)(nil), // 5: google.protobuf.Timestamp
	(TransactionInfo_State)(0),    // 6: google.cloud.paymentgateway.issuerswitch.v1.TransactionInfo.State
}
var file_google_cloud_paymentgateway_issuerswitch_v1_logs_proto_depIdxs = []int32{
	1, // 0: google.cloud.paymentgateway.issuerswitch.v1.UpiTransaction.severity:type_name -> google.logging.type.LogSeverity
	2, // 1: google.cloud.paymentgateway.issuerswitch.v1.UpiTransaction.api_type:type_name -> google.cloud.paymentgateway.issuerswitch.v1.ApiType
	3, // 2: google.cloud.paymentgateway.issuerswitch.v1.UpiTransaction.xml_api_type:type_name -> google.cloud.paymentgateway.issuerswitch.v1.XmlApiType
	4, // 3: google.cloud.paymentgateway.issuerswitch.v1.UpiTransaction.transaction_type:type_name -> google.cloud.paymentgateway.issuerswitch.v1.TransactionType
	5, // 4: google.cloud.paymentgateway.issuerswitch.v1.UpiTransaction.payload_receipt_time:type_name -> google.protobuf.Timestamp
	5, // 5: google.cloud.paymentgateway.issuerswitch.v1.UpiTransaction.payload_sent_time:type_name -> google.protobuf.Timestamp
	6, // 6: google.cloud.paymentgateway.issuerswitch.v1.UpiTransaction.status:type_name -> google.cloud.paymentgateway.issuerswitch.v1.TransactionInfo.State
	7, // [7:7] is the sub-list for method output_type
	7, // [7:7] is the sub-list for method input_type
	7, // [7:7] is the sub-list for extension type_name
	7, // [7:7] is the sub-list for extension extendee
	0, // [0:7] is the sub-list for field type_name
}

func init() { file_google_cloud_paymentgateway_issuerswitch_v1_logs_proto_init() }
func file_google_cloud_paymentgateway_issuerswitch_v1_logs_proto_init() {
	if File_google_cloud_paymentgateway_issuerswitch_v1_logs_proto != nil {
		return
	}
	file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_init()
	file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_paymentgateway_issuerswitch_v1_logs_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpiTransaction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_paymentgateway_issuerswitch_v1_logs_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*UpiTransaction_Sent)(nil),
		(*UpiTransaction_Received)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_paymentgateway_issuerswitch_v1_logs_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_paymentgateway_issuerswitch_v1_logs_proto_goTypes,
		DependencyIndexes: file_google_cloud_paymentgateway_issuerswitch_v1_logs_proto_depIdxs,
		MessageInfos:      file_google_cloud_paymentgateway_issuerswitch_v1_logs_proto_msgTypes,
	}.Build()
	File_google_cloud_paymentgateway_issuerswitch_v1_logs_proto = out.File
	file_google_cloud_paymentgateway_issuerswitch_v1_logs_proto_rawDesc = nil
	file_google_cloud_paymentgateway_issuerswitch_v1_logs_proto_goTypes = nil
	file_google_cloud_paymentgateway_issuerswitch_v1_logs_proto_depIdxs = nil
}
