// Code generated by protoc-gen-go. DO NOT EDIT.
// source: interop/grpc_testing/test.proto

package grpc_testing

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The type of payload that should be returned.
type PayloadType int32

const (
	// Compressable text format.
	PayloadType_COMPRESSABLE PayloadType = 0
	// Uncompressable binary format.
	PayloadType_UNCOMPRESSABLE PayloadType = 1
	// Randomly chosen from all other formats defined in this enum.
	PayloadType_RANDOM PayloadType = 2
)

var PayloadType_name = map[int32]string{
	0: "COMPRESSABLE",
	1: "UNCOMPRESSABLE",
	2: "RANDOM",
}

var PayloadType_value = map[string]int32{
	"COMPRESSABLE":   0,
	"UNCOMPRESSABLE": 1,
	"RANDOM":         2,
}

func (x PayloadType) String() string {
	return proto.EnumName(PayloadType_name, int32(x))
}

func (PayloadType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_534063719f48d90d, []int{0}
}

// The type of route that a client took to reach a server w.r.t. gRPCLB.
// The server must fill in "fallback" if it detects that the RPC reached
// the server via the "gRPCLB fallback" path, and "backend" if it detects
// that the RPC reached the server via "gRPCLB backend" path (i.e. if it got
// the address of this server from the gRPCLB server BalanceLoad RPC). Exactly
// how this detection is done is context and server dependant.
type GrpclbRouteType int32

const (
	// Server didn't detect the route that a client took to reach it.
	GrpclbRouteType_GRPCLB_ROUTE_TYPE_UNKNOWN GrpclbRouteType = 0
	// Indicates that a client reached a server via gRPCLB fallback.
	GrpclbRouteType_GRPCLB_ROUTE_TYPE_FALLBACK GrpclbRouteType = 1
	// Indicates that a client reached a server as a gRPCLB-given backend.
	GrpclbRouteType_GRPCLB_ROUTE_TYPE_BACKEND GrpclbRouteType = 2
)

var GrpclbRouteType_name = map[int32]string{
	0: "GRPCLB_ROUTE_TYPE_UNKNOWN",
	1: "GRPCLB_ROUTE_TYPE_FALLBACK",
	2: "GRPCLB_ROUTE_TYPE_BACKEND",
}

var GrpclbRouteType_value = map[string]int32{
	"GRPCLB_ROUTE_TYPE_UNKNOWN":  0,
	"GRPCLB_ROUTE_TYPE_FALLBACK": 1,
	"GRPCLB_ROUTE_TYPE_BACKEND":  2,
}

func (x GrpclbRouteType) String() string {
	return proto.EnumName(GrpclbRouteType_name, int32(x))
}

func (GrpclbRouteType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_534063719f48d90d, []int{1}
}

type Empty struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Empty) Reset()         { *m = Empty{} }
func (m *Empty) String() string { return proto.CompactTextString(m) }
func (*Empty) ProtoMessage()    {}
func (*Empty) Descriptor() ([]byte, []int) {
	return fileDescriptor_534063719f48d90d, []int{0}
}

func (m *Empty) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Empty.Unmarshal(m, b)
}
func (m *Empty) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Empty.Marshal(b, m, deterministic)
}
func (m *Empty) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Empty.Merge(m, src)
}
func (m *Empty) XXX_Size() int {
	return xxx_messageInfo_Empty.Size(m)
}
func (m *Empty) XXX_DiscardUnknown() {
	xxx_messageInfo_Empty.DiscardUnknown(m)
}

var xxx_messageInfo_Empty proto.InternalMessageInfo

// A block of data, to simply increase gRPC message size.
type Payload struct {
	// The type of data in body.
	Type PayloadType `protobuf:"varint,1,opt,name=type,proto3,enum=grpc.testing.PayloadType" json:"type,omitempty"`
	// Primary contents of payload.
	Body                 []byte   `protobuf:"bytes,2,opt,name=body,proto3" json:"body,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Payload) Reset()         { *m = Payload{} }
func (m *Payload) String() string { return proto.CompactTextString(m) }
func (*Payload) ProtoMessage()    {}
func (*Payload) Descriptor() ([]byte, []int) {
	return fileDescriptor_534063719f48d90d, []int{1}
}

func (m *Payload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Payload.Unmarshal(m, b)
}
func (m *Payload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Payload.Marshal(b, m, deterministic)
}
func (m *Payload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Payload.Merge(m, src)
}
func (m *Payload) XXX_Size() int {
	return xxx_messageInfo_Payload.Size(m)
}
func (m *Payload) XXX_DiscardUnknown() {
	xxx_messageInfo_Payload.DiscardUnknown(m)
}

var xxx_messageInfo_Payload proto.InternalMessageInfo

func (m *Payload) GetType() PayloadType {
	if m != nil {
		return m.Type
	}
	return PayloadType_COMPRESSABLE
}

func (m *Payload) GetBody() []byte {
	if m != nil {
		return m.Body
	}
	return nil
}

// A protobuf representation for grpc status. This is used by test
// clients to specify a status that the server should attempt to return.
type EchoStatus struct {
	Code                 int32    `protobuf:"varint,1,opt,name=code,proto3" json:"code,omitempty"`
	Message              string   `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EchoStatus) Reset()         { *m = EchoStatus{} }
func (m *EchoStatus) String() string { return proto.CompactTextString(m) }
func (*EchoStatus) ProtoMessage()    {}
func (*EchoStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_534063719f48d90d, []int{2}
}

func (m *EchoStatus) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EchoStatus.Unmarshal(m, b)
}
func (m *EchoStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EchoStatus.Marshal(b, m, deterministic)
}
func (m *EchoStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EchoStatus.Merge(m, src)
}
func (m *EchoStatus) XXX_Size() int {
	return xxx_messageInfo_EchoStatus.Size(m)
}
func (m *EchoStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_EchoStatus.DiscardUnknown(m)
}

var xxx_messageInfo_EchoStatus proto.InternalMessageInfo

func (m *EchoStatus) GetCode() int32 {
	if m != nil {
		return m.Code
	}
	return 0
}

func (m *EchoStatus) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

// Unary request.
type SimpleRequest struct {
	// Desired payload type in the response from the server.
	// If response_type is RANDOM, server randomly chooses one from other formats.
	ResponseType PayloadType `protobuf:"varint,1,opt,name=response_type,json=responseType,proto3,enum=grpc.testing.PayloadType" json:"response_type,omitempty"`
	// Desired payload size in the response from the server.
	// If response_type is COMPRESSABLE, this denotes the size before compression.
	ResponseSize int32 `protobuf:"varint,2,opt,name=response_size,json=responseSize,proto3" json:"response_size,omitempty"`
	// Optional input payload sent along with the request.
	Payload *Payload `protobuf:"bytes,3,opt,name=payload,proto3" json:"payload,omitempty"`
	// Whether SimpleResponse should include username.
	FillUsername bool `protobuf:"varint,4,opt,name=fill_username,json=fillUsername,proto3" json:"fill_username,omitempty"`
	// Whether SimpleResponse should include OAuth scope.
	FillOauthScope bool `protobuf:"varint,5,opt,name=fill_oauth_scope,json=fillOauthScope,proto3" json:"fill_oauth_scope,omitempty"`
	// Whether server should return a given status
	ResponseStatus *EchoStatus `protobuf:"bytes,7,opt,name=response_status,json=responseStatus,proto3" json:"response_status,omitempty"`
	// Whether SimpleResponse should include server_id.
	FillServerId bool `protobuf:"varint,9,opt,name=fill_server_id,json=fillServerId,proto3" json:"fill_server_id,omitempty"`
	// Whether SimpleResponse should include grpclb_route_type.
	FillGrpclbRouteType  bool     `protobuf:"varint,10,opt,name=fill_grpclb_route_type,json=fillGrpclbRouteType,proto3" json:"fill_grpclb_route_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SimpleRequest) Reset()         { *m = SimpleRequest{} }
func (m *SimpleRequest) String() string { return proto.CompactTextString(m) }
func (*SimpleRequest) ProtoMessage()    {}
func (*SimpleRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_534063719f48d90d, []int{3}
}

func (m *SimpleRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SimpleRequest.Unmarshal(m, b)
}
func (m *SimpleRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SimpleRequest.Marshal(b, m, deterministic)
}
func (m *SimpleRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SimpleRequest.Merge(m, src)
}
func (m *SimpleRequest) XXX_Size() int {
	return xxx_messageInfo_SimpleRequest.Size(m)
}
func (m *SimpleRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SimpleRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SimpleRequest proto.InternalMessageInfo

func (m *SimpleRequest) GetResponseType() PayloadType {
	if m != nil {
		return m.ResponseType
	}
	return PayloadType_COMPRESSABLE
}

func (m *SimpleRequest) GetResponseSize() int32 {
	if m != nil {
		return m.ResponseSize
	}
	return 0
}

func (m *SimpleRequest) GetPayload() *Payload {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (m *SimpleRequest) GetFillUsername() bool {
	if m != nil {
		return m.FillUsername
	}
	return false
}

func (m *SimpleRequest) GetFillOauthScope() bool {
	if m != nil {
		return m.FillOauthScope
	}
	return false
}

func (m *SimpleRequest) GetResponseStatus() *EchoStatus {
	if m != nil {
		return m.ResponseStatus
	}
	return nil
}

func (m *SimpleRequest) GetFillServerId() bool {
	if m != nil {
		return m.FillServerId
	}
	return false
}

func (m *SimpleRequest) GetFillGrpclbRouteType() bool {
	if m != nil {
		return m.FillGrpclbRouteType
	}
	return false
}

// Unary response, as configured by the request.
type SimpleResponse struct {
	// Payload to increase message size.
	Payload *Payload `protobuf:"bytes,1,opt,name=payload,proto3" json:"payload,omitempty"`
	// The user the request came from, for verifying authentication was
	// successful when the client expected it.
	Username string `protobuf:"bytes,2,opt,name=username,proto3" json:"username,omitempty"`
	// OAuth scope.
	OauthScope string `protobuf:"bytes,3,opt,name=oauth_scope,json=oauthScope,proto3" json:"oauth_scope,omitempty"`
	// Server ID. This must be unique among different server instances,
	// but the same across all RPC's made to a particular server instance.
	ServerId string `protobuf:"bytes,4,opt,name=server_id,json=serverId,proto3" json:"server_id,omitempty"`
	// gRPCLB Path.
	GrpclbRouteType GrpclbRouteType `protobuf:"varint,5,opt,name=grpclb_route_type,json=grpclbRouteType,proto3,enum=grpc.testing.GrpclbRouteType" json:"grpclb_route_type,omitempty"`
	// Server hostname.
	Hostname             string   `protobuf:"bytes,6,opt,name=hostname,proto3" json:"hostname,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SimpleResponse) Reset()         { *m = SimpleResponse{} }
func (m *SimpleResponse) String() string { return proto.CompactTextString(m) }
func (*SimpleResponse) ProtoMessage()    {}
func (*SimpleResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_534063719f48d90d, []int{4}
}

func (m *SimpleResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SimpleResponse.Unmarshal(m, b)
}
func (m *SimpleResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SimpleResponse.Marshal(b, m, deterministic)
}
func (m *SimpleResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SimpleResponse.Merge(m, src)
}
func (m *SimpleResponse) XXX_Size() int {
	return xxx_messageInfo_SimpleResponse.Size(m)
}
func (m *SimpleResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SimpleResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SimpleResponse proto.InternalMessageInfo

func (m *SimpleResponse) GetPayload() *Payload {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (m *SimpleResponse) GetUsername() string {
	if m != nil {
		return m.Username
	}
	return ""
}

func (m *SimpleResponse) GetOauthScope() string {
	if m != nil {
		return m.OauthScope
	}
	return ""
}

func (m *SimpleResponse) GetServerId() string {
	if m != nil {
		return m.ServerId
	}
	return ""
}

func (m *SimpleResponse) GetGrpclbRouteType() GrpclbRouteType {
	if m != nil {
		return m.GrpclbRouteType
	}
	return GrpclbRouteType_GRPCLB_ROUTE_TYPE_UNKNOWN
}

func (m *SimpleResponse) GetHostname() string {
	if m != nil {
		return m.Hostname
	}
	return ""
}

// Client-streaming request.
type StreamingInputCallRequest struct {
	// Optional input payload sent along with the request.
	Payload              *Payload `protobuf:"bytes,1,opt,name=payload,proto3" json:"payload,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamingInputCallRequest) Reset()         { *m = StreamingInputCallRequest{} }
func (m *StreamingInputCallRequest) String() string { return proto.CompactTextString(m) }
func (*StreamingInputCallRequest) ProtoMessage()    {}
func (*StreamingInputCallRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_534063719f48d90d, []int{5}
}

func (m *StreamingInputCallRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingInputCallRequest.Unmarshal(m, b)
}
func (m *StreamingInputCallRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingInputCallRequest.Marshal(b, m, deterministic)
}
func (m *StreamingInputCallRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingInputCallRequest.Merge(m, src)
}
func (m *StreamingInputCallRequest) XXX_Size() int {
	return xxx_messageInfo_StreamingInputCallRequest.Size(m)
}
func (m *StreamingInputCallRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingInputCallRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingInputCallRequest proto.InternalMessageInfo

func (m *StreamingInputCallRequest) GetPayload() *Payload {
	if m != nil {
		return m.Payload
	}
	return nil
}

// Client-streaming response.
type StreamingInputCallResponse struct {
	// Aggregated size of payloads received from the client.
	AggregatedPayloadSize int32    `protobuf:"varint,1,opt,name=aggregated_payload_size,json=aggregatedPayloadSize,proto3" json:"aggregated_payload_size,omitempty"`
	XXX_NoUnkeyedLiteral  struct{} `json:"-"`
	XXX_unrecognized      []byte   `json:"-"`
	XXX_sizecache         int32    `json:"-"`
}

func (m *StreamingInputCallResponse) Reset()         { *m = StreamingInputCallResponse{} }
func (m *StreamingInputCallResponse) String() string { return proto.CompactTextString(m) }
func (*StreamingInputCallResponse) ProtoMessage()    {}
func (*StreamingInputCallResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_534063719f48d90d, []int{6}
}

func (m *StreamingInputCallResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingInputCallResponse.Unmarshal(m, b)
}
func (m *StreamingInputCallResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingInputCallResponse.Marshal(b, m, deterministic)
}
func (m *StreamingInputCallResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingInputCallResponse.Merge(m, src)
}
func (m *StreamingInputCallResponse) XXX_Size() int {
	return xxx_messageInfo_StreamingInputCallResponse.Size(m)
}
func (m *StreamingInputCallResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingInputCallResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingInputCallResponse proto.InternalMessageInfo

func (m *StreamingInputCallResponse) GetAggregatedPayloadSize() int32 {
	if m != nil {
		return m.AggregatedPayloadSize
	}
	return 0
}

// Configuration for a particular response.
type ResponseParameters struct {
	// Desired payload sizes in responses from the server.
	// If response_type is COMPRESSABLE, this denotes the size before compression.
	Size int32 `protobuf:"varint,1,opt,name=size,proto3" json:"size,omitempty"`
	// Desired interval between consecutive responses in the response stream in
	// microseconds.
	IntervalUs           int32    `protobuf:"varint,2,opt,name=interval_us,json=intervalUs,proto3" json:"interval_us,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ResponseParameters) Reset()         { *m = ResponseParameters{} }
func (m *ResponseParameters) String() string { return proto.CompactTextString(m) }
func (*ResponseParameters) ProtoMessage()    {}
func (*ResponseParameters) Descriptor() ([]byte, []int) {
	return fileDescriptor_534063719f48d90d, []int{7}
}

func (m *ResponseParameters) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ResponseParameters.Unmarshal(m, b)
}
func (m *ResponseParameters) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ResponseParameters.Marshal(b, m, deterministic)
}
func (m *ResponseParameters) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResponseParameters.Merge(m, src)
}
func (m *ResponseParameters) XXX_Size() int {
	return xxx_messageInfo_ResponseParameters.Size(m)
}
func (m *ResponseParameters) XXX_DiscardUnknown() {
	xxx_messageInfo_ResponseParameters.DiscardUnknown(m)
}

var xxx_messageInfo_ResponseParameters proto.InternalMessageInfo

func (m *ResponseParameters) GetSize() int32 {
	if m != nil {
		return m.Size
	}
	return 0
}

func (m *ResponseParameters) GetIntervalUs() int32 {
	if m != nil {
		return m.IntervalUs
	}
	return 0
}

// Server-streaming request.
type StreamingOutputCallRequest struct {
	// Desired payload type in the response from the server.
	// If response_type is RANDOM, the payload from each response in the stream
	// might be of different types. This is to simulate a mixed type of payload
	// stream.
	ResponseType PayloadType `protobuf:"varint,1,opt,name=response_type,json=responseType,proto3,enum=grpc.testing.PayloadType" json:"response_type,omitempty"`
	// Configuration for each expected response message.
	ResponseParameters []*ResponseParameters `protobuf:"bytes,2,rep,name=response_parameters,json=responseParameters,proto3" json:"response_parameters,omitempty"`
	// Optional input payload sent along with the request.
	Payload *Payload `protobuf:"bytes,3,opt,name=payload,proto3" json:"payload,omitempty"`
	// Whether server should return a given status
	ResponseStatus       *EchoStatus `protobuf:"bytes,7,opt,name=response_status,json=responseStatus,proto3" json:"response_status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *StreamingOutputCallRequest) Reset()         { *m = StreamingOutputCallRequest{} }
func (m *StreamingOutputCallRequest) String() string { return proto.CompactTextString(m) }
func (*StreamingOutputCallRequest) ProtoMessage()    {}
func (*StreamingOutputCallRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_534063719f48d90d, []int{8}
}

func (m *StreamingOutputCallRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingOutputCallRequest.Unmarshal(m, b)
}
func (m *StreamingOutputCallRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingOutputCallRequest.Marshal(b, m, deterministic)
}
func (m *StreamingOutputCallRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingOutputCallRequest.Merge(m, src)
}
func (m *StreamingOutputCallRequest) XXX_Size() int {
	return xxx_messageInfo_StreamingOutputCallRequest.Size(m)
}
func (m *StreamingOutputCallRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingOutputCallRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingOutputCallRequest proto.InternalMessageInfo

func (m *StreamingOutputCallRequest) GetResponseType() PayloadType {
	if m != nil {
		return m.ResponseType
	}
	return PayloadType_COMPRESSABLE
}

func (m *StreamingOutputCallRequest) GetResponseParameters() []*ResponseParameters {
	if m != nil {
		return m.ResponseParameters
	}
	return nil
}

func (m *StreamingOutputCallRequest) GetPayload() *Payload {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (m *StreamingOutputCallRequest) GetResponseStatus() *EchoStatus {
	if m != nil {
		return m.ResponseStatus
	}
	return nil
}

// Server-streaming response, as configured by the request and parameters.
type StreamingOutputCallResponse struct {
	// Payload to increase response size.
	Payload              *Payload `protobuf:"bytes,1,opt,name=payload,proto3" json:"payload,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamingOutputCallResponse) Reset()         { *m = StreamingOutputCallResponse{} }
func (m *StreamingOutputCallResponse) String() string { return proto.CompactTextString(m) }
func (*StreamingOutputCallResponse) ProtoMessage()    {}
func (*StreamingOutputCallResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_534063719f48d90d, []int{9}
}

func (m *StreamingOutputCallResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingOutputCallResponse.Unmarshal(m, b)
}
func (m *StreamingOutputCallResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingOutputCallResponse.Marshal(b, m, deterministic)
}
func (m *StreamingOutputCallResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingOutputCallResponse.Merge(m, src)
}
func (m *StreamingOutputCallResponse) XXX_Size() int {
	return xxx_messageInfo_StreamingOutputCallResponse.Size(m)
}
func (m *StreamingOutputCallResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingOutputCallResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingOutputCallResponse proto.InternalMessageInfo

func (m *StreamingOutputCallResponse) GetPayload() *Payload {
	if m != nil {
		return m.Payload
	}
	return nil
}

type LoadBalancerStatsRequest struct {
	// Request stats for the next num_rpcs sent by client.
	NumRpcs int32 `protobuf:"varint,1,opt,name=num_rpcs,json=numRpcs,proto3" json:"num_rpcs,omitempty"`
	// If num_rpcs have not completed within timeout_sec, return partial results.
	TimeoutSec           int32    `protobuf:"varint,2,opt,name=timeout_sec,json=timeoutSec,proto3" json:"timeout_sec,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LoadBalancerStatsRequest) Reset()         { *m = LoadBalancerStatsRequest{} }
func (m *LoadBalancerStatsRequest) String() string { return proto.CompactTextString(m) }
func (*LoadBalancerStatsRequest) ProtoMessage()    {}
func (*LoadBalancerStatsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_534063719f48d90d, []int{10}
}

func (m *LoadBalancerStatsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LoadBalancerStatsRequest.Unmarshal(m, b)
}
func (m *LoadBalancerStatsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LoadBalancerStatsRequest.Marshal(b, m, deterministic)
}
func (m *LoadBalancerStatsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LoadBalancerStatsRequest.Merge(m, src)
}
func (m *LoadBalancerStatsRequest) XXX_Size() int {
	return xxx_messageInfo_LoadBalancerStatsRequest.Size(m)
}
func (m *LoadBalancerStatsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_LoadBalancerStatsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_LoadBalancerStatsRequest proto.InternalMessageInfo

func (m *LoadBalancerStatsRequest) GetNumRpcs() int32 {
	if m != nil {
		return m.NumRpcs
	}
	return 0
}

func (m *LoadBalancerStatsRequest) GetTimeoutSec() int32 {
	if m != nil {
		return m.TimeoutSec
	}
	return 0
}

type LoadBalancerStatsResponse struct {
	// The number of completed RPCs for each peer.
	RpcsByPeer map[string]int32 `protobuf:"bytes,1,rep,name=rpcs_by_peer,json=rpcsByPeer,proto3" json:"rpcs_by_peer,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// The number of RPCs that failed to record a remote peer.
	NumFailures int32 `protobuf:"varint,2,opt,name=num_failures,json=numFailures,proto3" json:"num_failures,omitempty"`
	// The number of completed RPCs for each method (UnaryCall or EmptyCall).
	RpcsByMethod         map[string]*LoadBalancerStatsResponse_RpcsByPeer `protobuf:"bytes,3,rep,name=rpcs_by_method,json=rpcsByMethod,proto3" json:"rpcs_by_method,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                                         `json:"-"`
	XXX_unrecognized     []byte                                           `json:"-"`
	XXX_sizecache        int32                                            `json:"-"`
}

func (m *LoadBalancerStatsResponse) Reset()         { *m = LoadBalancerStatsResponse{} }
func (m *LoadBalancerStatsResponse) String() string { return proto.CompactTextString(m) }
func (*LoadBalancerStatsResponse) ProtoMessage()    {}
func (*LoadBalancerStatsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_534063719f48d90d, []int{11}
}

func (m *LoadBalancerStatsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LoadBalancerStatsResponse.Unmarshal(m, b)
}
func (m *LoadBalancerStatsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LoadBalancerStatsResponse.Marshal(b, m, deterministic)
}
func (m *LoadBalancerStatsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LoadBalancerStatsResponse.Merge(m, src)
}
func (m *LoadBalancerStatsResponse) XXX_Size() int {
	return xxx_messageInfo_LoadBalancerStatsResponse.Size(m)
}
func (m *LoadBalancerStatsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_LoadBalancerStatsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_LoadBalancerStatsResponse proto.InternalMessageInfo

func (m *LoadBalancerStatsResponse) GetRpcsByPeer() map[string]int32 {
	if m != nil {
		return m.RpcsByPeer
	}
	return nil
}

func (m *LoadBalancerStatsResponse) GetNumFailures() int32 {
	if m != nil {
		return m.NumFailures
	}
	return 0
}

func (m *LoadBalancerStatsResponse) GetRpcsByMethod() map[string]*LoadBalancerStatsResponse_RpcsByPeer {
	if m != nil {
		return m.RpcsByMethod
	}
	return nil
}

type LoadBalancerStatsResponse_RpcsByPeer struct {
	// The number of completed RPCs for each peer.
	RpcsByPeer           map[string]int32 `protobuf:"bytes,1,rep,name=rpcs_by_peer,json=rpcsByPeer,proto3" json:"rpcs_by_peer,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *LoadBalancerStatsResponse_RpcsByPeer) Reset()         { *m = LoadBalancerStatsResponse_RpcsByPeer{} }
func (m *LoadBalancerStatsResponse_RpcsByPeer) String() string { return proto.CompactTextString(m) }
func (*LoadBalancerStatsResponse_RpcsByPeer) ProtoMessage()    {}
func (*LoadBalancerStatsResponse_RpcsByPeer) Descriptor() ([]byte, []int) {
	return fileDescriptor_534063719f48d90d, []int{11, 0}
}

func (m *LoadBalancerStatsResponse_RpcsByPeer) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LoadBalancerStatsResponse_RpcsByPeer.Unmarshal(m, b)
}
func (m *LoadBalancerStatsResponse_RpcsByPeer) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LoadBalancerStatsResponse_RpcsByPeer.Marshal(b, m, deterministic)
}
func (m *LoadBalancerStatsResponse_RpcsByPeer) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LoadBalancerStatsResponse_RpcsByPeer.Merge(m, src)
}
func (m *LoadBalancerStatsResponse_RpcsByPeer) XXX_Size() int {
	return xxx_messageInfo_LoadBalancerStatsResponse_RpcsByPeer.Size(m)
}
func (m *LoadBalancerStatsResponse_RpcsByPeer) XXX_DiscardUnknown() {
	xxx_messageInfo_LoadBalancerStatsResponse_RpcsByPeer.DiscardUnknown(m)
}

var xxx_messageInfo_LoadBalancerStatsResponse_RpcsByPeer proto.InternalMessageInfo

func (m *LoadBalancerStatsResponse_RpcsByPeer) GetRpcsByPeer() map[string]int32 {
	if m != nil {
		return m.RpcsByPeer
	}
	return nil
}

func init() {
	proto.RegisterEnum("grpc.testing.PayloadType", PayloadType_name, PayloadType_value)
	proto.RegisterEnum("grpc.testing.GrpclbRouteType", GrpclbRouteType_name, GrpclbRouteType_value)
	proto.RegisterType((*Empty)(nil), "grpc.testing.Empty")
	proto.RegisterType((*Payload)(nil), "grpc.testing.Payload")
	proto.RegisterType((*EchoStatus)(nil), "grpc.testing.EchoStatus")
	proto.RegisterType((*SimpleRequest)(nil), "grpc.testing.SimpleRequest")
	proto.RegisterType((*SimpleResponse)(nil), "grpc.testing.SimpleResponse")
	proto.RegisterType((*StreamingInputCallRequest)(nil), "grpc.testing.StreamingInputCallRequest")
	proto.RegisterType((*StreamingInputCallResponse)(nil), "grpc.testing.StreamingInputCallResponse")
	proto.RegisterType((*ResponseParameters)(nil), "grpc.testing.ResponseParameters")
	proto.RegisterType((*StreamingOutputCallRequest)(nil), "grpc.testing.StreamingOutputCallRequest")
	proto.RegisterType((*StreamingOutputCallResponse)(nil), "grpc.testing.StreamingOutputCallResponse")
	proto.RegisterType((*LoadBalancerStatsRequest)(nil), "grpc.testing.LoadBalancerStatsRequest")
	proto.RegisterType((*LoadBalancerStatsResponse)(nil), "grpc.testing.LoadBalancerStatsResponse")
	proto.RegisterMapType((map[string]*LoadBalancerStatsResponse_RpcsByPeer)(nil), "grpc.testing.LoadBalancerStatsResponse.RpcsByMethodEntry")
	proto.RegisterMapType((map[string]int32)(nil), "grpc.testing.LoadBalancerStatsResponse.RpcsByPeerEntry")
	proto.RegisterType((*LoadBalancerStatsResponse_RpcsByPeer)(nil), "grpc.testing.LoadBalancerStatsResponse.RpcsByPeer")
	proto.RegisterMapType((map[string]int32)(nil), "grpc.testing.LoadBalancerStatsResponse.RpcsByPeer.RpcsByPeerEntry")
}

func init() { proto.RegisterFile("interop/grpc_testing/test.proto", fileDescriptor_534063719f48d90d) }

var fileDescriptor_534063719f48d90d = []byte{
	// 1083 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x57, 0xdd, 0x72, 0xdb, 0xc4,
	0x17, 0x8f, 0x1c, 0x3b, 0x8e, 0x8f, 0x5d, 0xc7, 0xd9, 0xb4, 0xff, 0xbf, 0xe2, 0x50, 0x6a, 0x04,
	0x43, 0x4d, 0x99, 0x3a, 0x8c, 0x3b, 0x7c, 0x75, 0xa6, 0x30, 0x71, 0xe2, 0xa4, 0x99, 0x3a, 0xb6,
	0x91, 0x63, 0x98, 0x72, 0xa3, 0xd9, 0xc8, 0x1b, 0x45, 0x83, 0xa4, 0x15, 0xab, 0x55, 0x06, 0xf7,
	0x86, 0x19, 0x1e, 0x81, 0x57, 0xe0, 0x09, 0xb8, 0xe6, 0x6d, 0x78, 0x12, 0x66, 0x57, 0x92, 0x3f,
	0x15, 0x1a, 0x93, 0x81, 0x2b, 0xef, 0x9e, 0xcf, 0xdf, 0xf9, 0x9d, 0x3d, 0xbb, 0x16, 0x3c, 0xb2,
	0x3d, 0x4e, 0x18, 0xf5, 0xf7, 0x2d, 0xe6, 0x9b, 0x06, 0x27, 0x01, 0xb7, 0x3d, 0x6b, 0x5f, 0xfc,
	0x36, 0x7c, 0x46, 0x39, 0x45, 0x25, 0xa1, 0x68, 0xc4, 0x0a, 0x2d, 0x0f, 0xb9, 0xb6, 0xeb, 0xf3,
	0xb1, 0xd6, 0x81, 0x7c, 0x1f, 0x8f, 0x1d, 0x8a, 0x47, 0xe8, 0x29, 0x64, 0xf9, 0xd8, 0x27, 0xaa,
	0x52, 0x53, 0xea, 0xe5, 0xe6, 0x6e, 0x63, 0xd6, 0xa1, 0x11, 0x1b, 0x9d, 0x8f, 0x7d, 0xa2, 0x4b,
	0x33, 0x84, 0x20, 0x7b, 0x41, 0x47, 0x63, 0x35, 0x53, 0x53, 0xea, 0x25, 0x5d, 0xae, 0xb5, 0xe7,
	0x00, 0x6d, 0xf3, 0x8a, 0x0e, 0x38, 0xe6, 0x61, 0x20, 0x2c, 0x4c, 0x3a, 0x8a, 0x02, 0xe6, 0x74,
	0xb9, 0x46, 0x2a, 0xe4, 0x5d, 0x12, 0x04, 0xd8, 0x22, 0xd2, 0xb1, 0xa0, 0x27, 0x5b, 0xed, 0xd7,
	0x75, 0xb8, 0x37, 0xb0, 0x5d, 0xdf, 0x21, 0x3a, 0xf9, 0x31, 0x24, 0x01, 0x47, 0x5f, 0xc1, 0x3d,
	0x46, 0x02, 0x9f, 0x7a, 0x01, 0x31, 0x6e, 0x87, 0xac, 0x94, 0xd8, 0x8b, 0x1d, 0x7a, 0x7f, 0xc6,
	0x3f, 0xb0, 0xdf, 0x44, 0x19, 0x73, 0x53, 0xa3, 0x81, 0xfd, 0x86, 0xa0, 0x7d, 0xc8, 0xfb, 0x51,
	0x04, 0x75, 0xbd, 0xa6, 0xd4, 0x8b, 0xcd, 0x07, 0xa9, 0xe1, 0xf5, 0xc4, 0x4a, 0x44, 0xbd, 0xb4,
	0x1d, 0xc7, 0x08, 0x03, 0xc2, 0x3c, 0xec, 0x12, 0x35, 0x5b, 0x53, 0xea, 0x9b, 0x7a, 0x49, 0x08,
	0x87, 0xb1, 0x0c, 0xd5, 0xa1, 0x22, 0x8d, 0x28, 0x0e, 0xf9, 0x95, 0x11, 0x98, 0xd4, 0x27, 0x6a,
	0x4e, 0xda, 0x95, 0x85, 0xbc, 0x27, 0xc4, 0x03, 0x21, 0x45, 0x07, 0xb0, 0x35, 0x05, 0x29, 0x79,
	0x53, 0xf3, 0x12, 0x87, 0x3a, 0x8f, 0x63, 0xca, 0xab, 0x5e, 0x9e, 0x14, 0x10, 0xf1, 0xfc, 0x01,
	0xc8, 0xa0, 0x46, 0x40, 0xd8, 0x35, 0x61, 0x86, 0x3d, 0x52, 0x0b, 0x53, 0x48, 0x03, 0x29, 0x3c,
	0x1d, 0xa1, 0x67, 0xf0, 0x3f, 0x69, 0x25, 0xa2, 0x3a, 0x17, 0x06, 0xa3, 0x21, 0x8f, 0x69, 0x05,
	0x69, 0xbd, 0x23, 0xb4, 0x27, 0x52, 0xa9, 0x0b, 0x9d, 0xa0, 0x50, 0xfb, 0x25, 0x03, 0xe5, 0xa4,
	0x29, 0x51, 0xce, 0x59, 0xc2, 0x94, 0x5b, 0x11, 0x56, 0x85, 0xcd, 0x09, 0x57, 0x51, 0xcf, 0x27,
	0x7b, 0xf4, 0x08, 0x8a, 0xb3, 0x14, 0xad, 0x4b, 0x35, 0xd0, 0x29, 0x3d, 0x7b, 0x50, 0x98, 0x96,
	0x95, 0x8d, 0xbc, 0x83, 0xa4, 0xa4, 0x53, 0xd8, 0x5e, 0xae, 0x26, 0x27, 0x0f, 0xc9, 0xc3, 0x79,
	0x50, 0x0b, 0x75, 0xe9, 0x5b, 0xd6, 0xbc, 0x40, 0x80, 0xbc, 0xa2, 0x01, 0x97, 0x20, 0x37, 0xa2,
	0x34, 0xc9, 0x5e, 0xeb, 0xc0, 0xee, 0x80, 0x33, 0x82, 0x5d, 0xdb, 0xb3, 0x4e, 0x3d, 0x3f, 0xe4,
	0x87, 0xd8, 0x71, 0x92, 0x43, 0xba, 0x2a, 0x1d, 0xda, 0x39, 0x54, 0xd3, 0xa2, 0xc5, 0xec, 0x7e,
	0x06, 0xff, 0xc7, 0x96, 0xc5, 0x88, 0x85, 0x39, 0x19, 0x19, 0xb1, 0x4f, 0x74, 0x7a, 0xa3, 0x31,
	0x7a, 0x30, 0x55, 0xc7, 0xa1, 0xc5, 0x31, 0xd6, 0x4e, 0x01, 0x25, 0x31, 0xfa, 0x98, 0x61, 0x97,
	0x70, 0xc2, 0xe4, 0x04, 0xce, 0xb8, 0xca, 0xb5, 0xa0, 0x5c, 0xde, 0x15, 0xd7, 0x58, 0x9c, 0xe1,
	0x78, 0x26, 0x20, 0x11, 0x0d, 0x03, 0xed, 0xb7, 0xcc, 0x0c, 0xc2, 0x5e, 0xc8, 0x17, 0x0a, 0xbe,
	0xeb, 0x54, 0x7e, 0x03, 0x3b, 0x13, 0x7f, 0x7f, 0x02, 0x55, 0xcd, 0xd4, 0xd6, 0xeb, 0xc5, 0x66,
	0x6d, 0x3e, 0xca, 0x72, 0x49, 0x3a, 0x62, 0xcb, 0x65, 0xae, 0x3c, 0xc3, 0x77, 0x1f, 0x3a, 0xad,
	0x0b, 0x7b, 0xa9, 0x24, 0xfd, 0xc3, 0x29, 0xd1, 0xbe, 0x05, 0xb5, 0x43, 0xf1, 0xa8, 0x85, 0x1d,
	0xec, 0x99, 0x84, 0x89, 0x2c, 0x41, 0x42, 0xf9, 0x2e, 0x6c, 0x7a, 0xa1, 0x6b, 0x30, 0xdf, 0x0c,
	0xe2, 0x56, 0xe6, 0xbd, 0xd0, 0xd5, 0x7d, 0x33, 0x10, 0xdd, 0xe4, 0xb6, 0x4b, 0x68, 0xc8, 0x8d,
	0x80, 0x98, 0x49, 0x37, 0x63, 0xd1, 0x80, 0x98, 0xda, 0x9f, 0x59, 0xd8, 0x4d, 0x09, 0x1c, 0xc3,
	0x7c, 0x0d, 0x25, 0x11, 0xd5, 0xb8, 0x18, 0x1b, 0x3e, 0x21, 0x4c, 0x55, 0x64, 0x17, 0x3e, 0x9f,
	0xc7, 0x7a, 0xa3, 0x7b, 0x43, 0x40, 0x68, 0x8d, 0xfb, 0x84, 0xb0, 0xb6, 0xc7, 0xd9, 0x58, 0x07,
	0x36, 0x11, 0xa0, 0xf7, 0xa0, 0x24, 0x40, 0x5f, 0x62, 0xdb, 0x09, 0x19, 0x49, 0x0e, 0x5a, 0xd1,
	0x0b, 0xdd, 0xe3, 0x58, 0x84, 0x0c, 0x28, 0x27, 0xd9, 0x5d, 0xc2, 0xaf, 0xa8, 0x68, 0x9f, 0xc8,
	0xff, 0xe5, 0x6a, 0xf9, 0xcf, 0xa4, 0x6f, 0x84, 0xa0, 0xc4, 0x66, 0x44, 0xd5, 0xdf, 0x15, 0x80,
	0x29, 0x46, 0x34, 0x4a, 0xad, 0xb6, 0xb5, 0x7a, 0xb5, 0x7f, 0x57, 0x78, 0xf5, 0x05, 0x6c, 0x2d,
	0xa8, 0x51, 0x05, 0xd6, 0x7f, 0x20, 0x63, 0xd9, 0xbb, 0x82, 0x2e, 0x96, 0xe8, 0x3e, 0xe4, 0xae,
	0xb1, 0x13, 0x26, 0x6f, 0x52, 0xb4, 0x79, 0x9e, 0xf9, 0x42, 0xb9, 0xab, 0x7b, 0x00, 0xdb, 0x4b,
	0xac, 0xa4, 0x04, 0x78, 0x39, 0x1b, 0xa0, 0xd8, 0x6c, 0xae, 0xce, 0xc1, 0x4c, 0xd2, 0x27, 0x5f,
	0x43, 0x71, 0x66, 0xe0, 0x51, 0x05, 0x4a, 0x87, 0xbd, 0xb3, 0xbe, 0xde, 0x1e, 0x0c, 0x0e, 0x5a,
	0x9d, 0x76, 0x65, 0x0d, 0x21, 0x28, 0x0f, 0xbb, 0x73, 0x32, 0x05, 0x01, 0x6c, 0xe8, 0x07, 0xdd,
	0xa3, 0xde, 0x59, 0x25, 0xf3, 0x84, 0xc2, 0xd6, 0xc2, 0x15, 0x8d, 0x1e, 0xc2, 0xee, 0x89, 0xde,
	0x3f, 0xec, 0xb4, 0x0c, 0xbd, 0x37, 0x3c, 0x6f, 0x1b, 0xe7, 0xaf, 0xfb, 0x6d, 0x63, 0xd8, 0x7d,
	0xd5, 0xed, 0x7d, 0xd7, 0xad, 0xac, 0xa1, 0x77, 0xa1, 0xba, 0xac, 0x3e, 0x3e, 0xe8, 0x74, 0x5a,
	0x07, 0x87, 0xaf, 0x2a, 0x4a, 0xba, 0xbb, 0xd0, 0xb5, 0xbb, 0x47, 0x95, 0x4c, 0xf3, 0x8f, 0x2c,
	0x14, 0xcf, 0x49, 0xc0, 0xc5, 0xf3, 0x68, 0x9b, 0x04, 0x7d, 0x0a, 0x05, 0xf9, 0x87, 0x48, 0x0c,
	0x31, 0xda, 0x59, 0xb8, 0x05, 0x84, 0xa2, 0x9a, 0x26, 0x44, 0xc7, 0x50, 0x18, 0x7a, 0x98, 0x45,
	0x6e, 0x7b, 0xf3, 0x16, 0x73, 0x7f, 0x66, 0xaa, 0xef, 0xa4, 0x2b, 0xe3, 0x39, 0x74, 0x60, 0x27,
	0xe5, 0x36, 0x41, 0xf5, 0x05, 0xa7, 0x1b, 0x6f, 0xe5, 0xea, 0x47, 0xb7, 0xb0, 0x8c, 0x72, 0x7d,
	0xa2, 0x20, 0x1b, 0xd0, 0xf2, 0x13, 0x84, 0x1e, 0xdf, 0x10, 0x62, 0xf1, 0xc9, 0xab, 0xd6, 0xdf,
	0x6e, 0x18, 0xa5, 0xaa, 0x8b, 0x54, 0xe5, 0xe3, 0xd0, 0x71, 0x8e, 0x42, 0xdf, 0x21, 0x3f, 0xfd,
	0x6b, 0x35, 0xd5, 0x15, 0x59, 0x55, 0xf9, 0x25, 0x76, 0x2e, 0xff, 0x83, 0x54, 0xcd, 0x21, 0xdc,
	0x1f, 0x7a, 0xb2, 0x83, 0x2e, 0xf1, 0x38, 0x19, 0x25, 0xa7, 0xe8, 0x05, 0x6c, 0xcf, 0xc9, 0x57,
	0x3b, 0x4d, 0xcd, 0x9f, 0x53, 0xde, 0x80, 0x24, 0xb4, 0x09, 0xe5, 0x13, 0xc2, 0x0f, 0x1d, 0x9b,
	0x78, 0x5c, 0x2a, 0xd0, 0x87, 0x6f, 0x9d, 0xd9, 0xa8, 0xb6, 0xc7, 0xb7, 0x9c, 0x6d, 0x6d, 0xad,
	0xf5, 0xf4, 0xfb, 0x8f, 0x2d, 0x4a, 0x2d, 0x87, 0x34, 0x2c, 0xea, 0x60, 0xcf, 0x6a, 0x50, 0x66,
	0xc9, 0x2f, 0x8a, 0xfd, 0xb4, 0xcf, 0x8b, 0x8b, 0x0d, 0xf9, 0x69, 0xf1, 0xec, 0xaf, 0x00, 0x00,
	0x00, 0xff, 0xff, 0x8c, 0x0b, 0x8c, 0x16, 0x7d, 0x0c, 0x00, 0x00,
}
