/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1beta2

// DeviceAllocationResultApplyConfiguration represents a declarative configuration of the DeviceAllocationResult type for use
// with apply.
type DeviceAllocationResultApplyConfiguration struct {
	Results []DeviceRequestAllocationResultApplyConfiguration `json:"results,omitempty"`
	Config  []DeviceAllocationConfigurationApplyConfiguration `json:"config,omitempty"`
}

// DeviceAllocationResultApplyConfiguration constructs a declarative configuration of the DeviceAllocationResult type for use with
// apply.
func DeviceAllocationResult() *DeviceAllocationResultApplyConfiguration {
	return &DeviceAllocationResultApplyConfiguration{}
}

// WithResults adds the given value to the Results field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Results field.
func (b *DeviceAllocationResultApplyConfiguration) WithResults(values ...*DeviceRequestAllocationResultApplyConfiguration) *DeviceAllocationResultApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithResults")
		}
		b.Results = append(b.Results, *values[i])
	}
	return b
}

// WithConfig adds the given value to the Config field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Config field.
func (b *DeviceAllocationResultApplyConfiguration) WithConfig(values ...*DeviceAllocationConfigurationApplyConfiguration) *DeviceAllocationResultApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithConfig")
		}
		b.Config = append(b.Config, *values[i])
	}
	return b
}
