/*    
   Wrentrs.c - write entries to disk.

   Copyright (C) 2000 Imre Leber

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   If you have any questions, comments, suggestions, or fixes please
   email me at:  imre.leber@worldonline.be
*/



int WriteEntries(RDWRHandle handle, CLUSTER cluster,
                 struct DirectoryEntry* entries,
                 CLUSTER* clusters,
                 int amofentries)
{
     int i, j;
     struct DirectoryPosition* pos;
     unsigned char sectorspercluster;
     int cpos=0;

     sectorspercluster = GetSectorsPerCluster(handle);
     if (!sectorspercluster) return FALSE;

     for (i = 0, j = 0; i < amofentries; i++, j++)
     {
         if ((j % ENTRIESPERSECTOR) == 0)
         {
            if (j == sectorspercluster * ENTRIESPERSECTOR)
            {
               pos.sector = clusters[cpos] * sectorspercluster;
               j = 0;
            }
            else
               pos.sector++;

            pos.offset = 0;
         }
         else
            pos.offset++;

         if (!WriteDirectory(handle, pos, entries[i])) return FALSE;
     }

     return TRUE;
}
