Program MrLoad;
Uses DOS;

Var
  Buffer: array[0..4095] of byte;
  F: file;
  Regs: Registers;

function FileExists(Filename: string): boolean;
Var
  F1: file;
begin
{$I-}
  Assign(F1, Filename);
  Reset(F1,1);
  Close(F1);
{$I+}
  FileExists:=(IOResult=0) and (Filename<>'');
end;

begin
  if ParamStr(1)='-r' then
  begin
    with Regs do
    begin
      AH:=$11;
      AL:=$04;
      BH:=0;
      BL:=0;
      Intr($10, Regs);
    end;
    Halt(0);
  end;

  if not FileExists(ParamStr(1)) then
  begin
    writeln('Font file ',ParamStr(1),' does not exist');
    Halt(1);
  end;
  Assign(F, ParamStr(1));
  Reset(F,1);
  BlockRead(F, Buffer, 2048);
  Close(F);
  with Regs do
  begin
    AH:=$11;
    AL:=$10;
    BH:=16;
    BL:=0;
    CX:=127;
    DX:=0;
    BP:=Ofs(Buffer);
    ES:=Seg(Buffer);
    Intr($10, Regs);
  end;
end.