/*  Scandisk exit routine

    Copyright (c) Joe Cosentino 2000.
    All Rights Reserved.

    Created by: Joseph Cosentino.

*/

// I N C L U D E S //////////////////////////////////////////////////////////

#include "dialog.h"
#include "..\screen\screen.h"
#include "..\event\event.h"
#include "..\mouse\mouse.h"
#include "..\winman\winman.h"
#include "..\winman\cmdbtn.h"
#include "..\winman\control.h"
#include "..\winman\window.h"
#include "..\winman\controls.h"
#include "..\scandisk.h"

// D E F I N E S ////////////////////////////////////////////////////////////

#define DIALOG_X      18
#define DIALOG_Y      7
#define DIALOG_X_LEN  30
#define DIALOG_Y_LEN  8
#define TEXT_X        16
#define BUTTON_LENGTH 10
//#define BUTTON_X      DIALOG_X + (DIALOG_X_LEN / 2) - (BUTTON_LENGTH / 2)
#define BUTTON_X      DIALOG_X + (DIALOG_X_LEN / 4) - (BUTTON_LENGTH / 2)
#define BUTTON_X2     DIALOG_X + (DIALOG_X_LEN / 2) + 1
#define BUTTON_Y      DIALOG_Y + 6

#define AMOFCONTROLS 5
#define OKBUTTON     3
#define CANCELBUTTON 4

// G L O B A L S ////////////////////////////////////////////////////////////

static struct Control Controls[AMOFCONTROLS];
extern struct CommandButton OkButton, CancelButton;
static struct Window Exit = {DIALOG_X, DIALOG_Y,
                            DIALOG_X_LEN, DIALOG_Y_LEN,
                            DIALOGBACKCOLOR, DIALOGFORCOLOR,
                            " Exit ",
                            Controls,
                            AMOFCONTROLS};
static int Initialized = FALSE;

// F U N C T I O N S ////////////////////////////////////////////////////////

static void Initialize(void)
{
    Controls[0] = CreateLabel("HEY!", DIALOGFORCOLOR, DIALOGBACKCOLOR, 31, DIALOG_Y+2);
    Controls[1] = CreateLabel("Do you really", DIALOGFORCOLOR, DIALOGBACKCOLOR, 27, DIALOG_Y+3);
    Controls[2] = CreateLabel("want to exit?", DIALOGFORCOLOR, DIALOGBACKCOLOR, 27, DIALOG_Y+4);
    Controls[3] = CreateCommandButton(&OkButton, BUTTONFORCOLOR, BUTTONBACKCOLOR, BUTTON_X, BUTTON_Y, FALSE, FALSE, FALSE);
    Controls[4] = CreateCommandButton(&CancelButton, BUTTONFORCOLOR, BUTTONBACKCOLOR, BUTTON_X2, BUTTON_Y, FALSE, TRUE, TRUE);

} // end Initialize.

/////////////////////////////////////////////////////////////////////////////

int show_exit()
{
    int control,result;

    if (!Initialized)
        {
        Initialize();
        Initialized = TRUE;
        } // end if.

    OpenWindow(&Exit);
    control = ControlWindow(&Exit);
    CloseWindow();

    // Interpret values.
    if ((control == CANCELBUTTON) || (control == -1))
        result = FALSE;
    else
        result = TRUE;

    return result;

} // end show_exit.
